/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.ma.nbudget.BgElimDiffDealEnum;
import com.kingdee.eas.ma.nbudget.BgElimFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgElimTemplateEntryCollection;
import com.kingdee.eas.ma.nbudget.BgElimTemplateEntryInfo;
import com.kingdee.eas.ma.nbudget.BgElimTemplateFactory;
import com.kingdee.eas.ma.nbudget.BgElimTemplateInfo;
import com.kingdee.eas.ma.nbudget.BgElimTypeEnum;
import com.kingdee.eas.ma.nbudget.BgInnerDataCheckInfo;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BizDirectionEnum;
import com.kingdee.eas.ma.nbudget.IBgElimFacade;
import com.kingdee.eas.ma.nbudget.IBgElimTemplate;
import com.kingdee.eas.ma.nbudget.client.AbstractBgInnerDataDiffDealUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class BgInnerDataDiffDealUI
extends AbstractBgInnerDataDiffDealUI {
    private static final Logger logger = CoreUIObject.getLogger(BgInnerDataDiffDealUI.class);
    BgElimTemplateInfo elimTemplateInfo = null;
    private boolean isManual = false;
    private static final String RES_PATH = "com.kingdee.eas.ma.nbudget.client.BgEliminationResource";
    private static final String NUM_FOTMATTER = "#,##0.00";
    private static final String SUMROW = "SUMROW";
    private String sumStr = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgAnalyseResource", (String)"sum");
    private static final String col_orgUnit = "orgUnit";
    private static final String col_orgUnitId = "orgUnitId";
    private static final String col_oppOrgUnit = "oppOrgUnit";
    private static final String col_oppOrgUnitId = "oppOrgUnitId";
    private static final String col_bgItemNumber = "bgItemNumber";
    private static final String col_bgItemName = "bgItemName";
    private static final String col_debitFilled = "debitFilled";
    private static final String col_creditFilled = "creditFilled";
    private static final String col_debitAmount = "debitAmount";
    private static final String col_creditAmount = "creditAmount";
    private static final String col_diff = "diff";
    private static final String col_dataId = "dataId";
    private static final String col_bgItemId = "bgItemId";
    private BgElimTypeEnum elimType = null;
    private BgElimDiffDealEnum diffDeal = null;
    private boolean isViewMode = false;
    private boolean isConfirmed = false;

    public void onLoad() throws Exception {
        super.onLoad();
        String elimTemplateId = (String)this.getUIContext().get("BG_ELIM_TEMPLATE");
        this.elimTemplateInfo = this.getBgElimTemplateInterface().getBgElimTemplateInfo("select diffDeal, elimType, entries.bgItemId, entries.bgItemNumber, entries.bgItemName, entries.bizDirection where id = '" + elimTemplateId + "'");
        this.elimType = this.elimTemplateInfo.getElimType();
        this.diffDeal = this.getUIContext().get("diffDeal") != null ? (BgElimDiffDealEnum)((Object)this.getUIContext().get("diffDeal")) : this.elimTemplateInfo.getDiffDeal();
        if (BgElimDiffDealEnum.manual.equals((Object)this.diffDeal)) {
            this.isManual = true;
        }
        this.initUI();
        Boolean viewMode = (Boolean)this.getUIContext().get("viewMode");
        if (viewMode != null) {
            this.isViewMode = viewMode;
        }
        List datas = (List)this.getUIContext().get("datas");
        this.fillData(this.elimTemplateInfo, datas);
    }

    private void initUI() {
        this.getTblMain().checkParsed();
        this.getTblMain().getSelectManager().setSelectMode(2);
        int columnCount = this.getTblMain().getColumnCount();
        for (int i = 1; i < columnCount; ++i) {
            if (i == 9 && i == 10) continue;
            this.getTblMain().getColumn(i).getStyleAttributes().setLocked(true);
        }
        this.getTblMain().setUserCellDisplayParser((IUserCellDisplayParser)new UserCellDisplayParser());
        KDFormattedTextField formattedTextField = null;
        formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        formattedTextField.setPrecision(10);
        formattedTextField.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
        formattedTextField.setMinimumValue((Comparable)GlUtils.minBigDecimal);
        this.getTblMain().getColumn(col_creditFilled).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
        this.getTblMain().getColumn(col_creditAmount).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
        this.getTblMain().getColumn(col_debitFilled).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
        this.getTblMain().getColumn(col_debitAmount).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
        if (this.elimTemplateInfo != null) {
            this.comboElimType.setSelectedItem((Object)this.elimType);
            this.comboDiffDeal.setSelectedItem((Object)this.diffDeal);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        Boolean viewMode = (Boolean)this.getUIContext().get("viewMode");
        this.btnRefresh.setVisible(false);
        this.btnCheck.setIcon(EASResource.getIcon((String)"imgTbtn_affirm"));
        if (viewMode != null && viewMode.booleanValue()) {
            this.btnCheck.setEnabled(false);
        }
    }

    private void fillData(BgElimTemplateInfo elimTemplateInfo, List datas) {
        int i;
        if (elimTemplateInfo == null || datas == null || datas.isEmpty()) {
            return;
        }
        this.getTblMain().removeRows();
        this.getTblMain().setRefresh(false);
        BgInnerDataCheckInfo info = (BgInnerDataCheckInfo)datas.get(0);
        String[] orgUnitId = new String[]{info.getOrgUnitId(), info.getOppOrgUnitId()};
        String[] orgUnitName = new String[]{info.getOrgUnitName(), info.getOppOrgUnitName()};
        String[] oppOrgUnitId = new String[]{info.getOppOrgUnitId(), info.getOrgUnitId()};
        String[] oppOrgUnitName = new String[]{info.getOppOrgUnitName(), info.getOrgUnitName()};
        BgElimTemplateEntryCollection entryCol = elimTemplateInfo.getEntries();
        BgElimTemplateEntryInfo entryInfo = null;
        int size = entryCol.size();
        IRow row = null;
        BigDecimal sumDebitFill = new BigDecimal("0.00");
        BigDecimal sumCreditFill = new BigDecimal("0.00");
        BigDecimal diffAmount = (BigDecimal)this.getUIContext().get("diffAmount");
        if (!this.isViewMode) {
            diffAmount = this.preHandleDiff(datas, diffAmount);
        }
        for (int orgIndex = 0; orgIndex < orgUnitId.length; ++orgIndex) {
            block1: for (i = 0; i < size; ++i) {
                int j;
                entryInfo = entryCol.get(i);
                row = this.getTblMain().addRow();
                row.getCell(col_orgUnitId).setValue((Object)orgUnitId[orgIndex]);
                row.getCell(col_orgUnit).setValue((Object)orgUnitName[orgIndex]);
                row.getCell(col_oppOrgUnitId).setValue((Object)oppOrgUnitId[orgIndex]);
                row.getCell(col_oppOrgUnit).setValue((Object)oppOrgUnitName[orgIndex]);
                row.getCell(col_bgItemNumber).setValue((Object)entryInfo.getBgItemNumber());
                row.getCell(col_bgItemName).setValue((Object)entryInfo.getBgItemName());
                if (entryInfo.getBizDirection() == BizDirectionEnum.Borrow) {
                    row.getCell(col_debitFilled).setValue((Object)new BigDecimal("0.00"));
                    row.getCell(col_debitAmount).setValue((Object)new BigDecimal("0.00"));
                    if (this.isManual && !this.isViewMode) {
                        row.getCell(col_debitAmount).getStyleAttributes().setLocked(false);
                    }
                    for (j = 0; j < datas.size(); ++j) {
                        info = (BgInnerDataCheckInfo)datas.get(j);
                        if (!orgUnitId[orgIndex].equals(info.getOrgUnitId()) || !oppOrgUnitId[orgIndex].equals(info.getOppOrgUnitId()) || !entryInfo.getBgItemNumber().equals(info.getBgItemNumber())) continue;
                        row.getCell(col_debitFilled).setValue((Object)info.getFillAmount());
                        row.getCell(col_debitAmount).setValue((Object)info.getAmount());
                        sumDebitFill = sumDebitFill.add(info.getFillAmount());
                        row.getCell(col_dataId).setValue((Object)info.getId());
                        row.setUserObject((Object)info.getKey());
                        datas.remove(info);
                        continue block1;
                    }
                    continue;
                }
                if (entryInfo.getBizDirection() != BizDirectionEnum.loan) continue;
                row.getCell(col_creditFilled).setValue((Object)new BigDecimal("0.00"));
                row.getCell(col_creditAmount).setValue((Object)new BigDecimal("0.00"));
                if (this.isManual && !this.isViewMode) {
                    row.getCell(col_creditAmount).getStyleAttributes().setLocked(false);
                }
                for (j = 0; j < datas.size(); ++j) {
                    info = (BgInnerDataCheckInfo)datas.get(j);
                    if (!orgUnitId[orgIndex].equals(info.getOrgUnitId()) || !oppOrgUnitId[orgIndex].equals(info.getOppOrgUnitId()) || !entryInfo.getBgItemNumber().equals(info.getBgItemNumber())) continue;
                    row.getCell(col_creditFilled).setValue((Object)info.getFillAmount());
                    row.getCell(col_creditAmount).setValue((Object)info.getAmount());
                    sumCreditFill = sumCreditFill.add(info.getFillAmount());
                    row.getCell(col_dataId).setValue((Object)info.getId());
                    row.setUserObject((Object)info.getKey());
                    datas.remove(info);
                    continue block1;
                }
            }
        }
        int rowCount = this.getTblMain().getRowCount();
        for (i = 0; i < rowCount; ++i) {
            row = this.getTblMain().getRow(i);
            row.getCell(col_diff).setValue((Object)((BigDecimal)this.getUIContext().get("diffAmount")));
        }
        this.getTblMain().getMergeManager().mergeBlock(0, 11, this.getTblMain().getRowCount() - 1, 11);
        if (diffAmount.compareTo(new BigDecimal("0.00")) != 0 && !this.isViewMode) {
            this.handleDiff();
        }
        row = this.getTblMain().addRow();
        row.setUserObject((Object)SUMROW);
        row.getCell(col_debitFilled).setValue((Object)sumDebitFill);
        row.getCell(col_creditFilled).setValue((Object)sumCreditFill);
        row.getCell(col_diff).setValue((Object)((BigDecimal)this.getUIContext().get("diffAmount")));
        row.getCell(col_bgItemNumber).setValue((Object)this.sumStr);
        row.getStyleAttributes().setBackground(BgNConstants.LITILE_SUM_COROR);
        row.getCell(col_bgItemNumber).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        this.getTblMain().getMergeManager().mergeBlock(row.getRowIndex(), 0, row.getRowIndex(), 6);
        this.refreshSumAmount();
        this.getTblMain().setRefresh(true);
    }

    private BigDecimal preHandleDiff(List datas, BigDecimal diffAmount) {
        block17: {
            int i;
            int debitIndex;
            int creditIndex;
            int debitSize;
            int creditSize;
            int size;
            BigDecimal adjAmount;
            BgInnerDataCheckInfo info;
            block16: {
                if (datas == null || datas.isEmpty()) {
                    return diffAmount;
                }
                info = null;
                adjAmount = null;
                size = datas.size();
                creditSize = 0;
                debitSize = 0;
                creditIndex = 0;
                debitIndex = 0;
                for (i = 0; i < size; ++i) {
                    info.setAmount((info = (BgInnerDataCheckInfo)datas.get(i)).getFillAmount() == null ? BgNConstants.ZERO : info.getFillAmount());
                    if (info.getBizDirection() == 0) {
                        ++debitSize;
                        continue;
                    }
                    ++creditSize;
                }
                if (diffAmount == null || diffAmount.compareTo(BgNConstants.ZERO) == 0) {
                    return diffAmount;
                }
                if (!BgElimDiffDealEnum.Up.equals((Object)this.diffDeal)) break block16;
                if (diffAmount.compareTo(BgNConstants.ZERO) > 0) {
                    for (i = 0; i < size; ++i) {
                        info = (BgInnerDataCheckInfo)datas.get(i);
                        if (info.getBizDirection() != 1) continue;
                        adjAmount = info.getAmount().add(diffAmount.abs());
                        info.setAmount(adjAmount);
                        return BgNConstants.ZERO;
                    }
                } else {
                    for (i = 0; i < size; ++i) {
                        info = (BgInnerDataCheckInfo)datas.get(i);
                        if (info.getBizDirection() != 0) continue;
                        adjAmount = info.getAmount().add(diffAmount.abs());
                        info.setAmount(adjAmount);
                        return BgNConstants.ZERO;
                    }
                }
                break block17;
            }
            if (!BgElimDiffDealEnum.low.equals((Object)this.diffDeal)) break block17;
            if (diffAmount.compareTo(BgNConstants.ZERO) > 0) {
                for (i = 0; i < size; ++i) {
                    info = (BgInnerDataCheckInfo)datas.get(i);
                    if (info.getBizDirection() != 0) continue;
                    if (++debitIndex >= debitSize) {
                        adjAmount = info.getAmount().subtract(diffAmount.abs());
                        info.setAmount(adjAmount);
                        return BgNConstants.ZERO;
                    }
                    if (info.getAmount().compareTo(BgNConstants.ZERO) < 0) continue;
                    if (info.getAmount().subtract(diffAmount.abs()).compareTo(BgNConstants.ZERO) >= 0) {
                        adjAmount = info.getAmount().subtract(diffAmount.abs());
                        info.setAmount(adjAmount);
                        return BgNConstants.ZERO;
                    }
                    diffAmount = info.getAmount().subtract(diffAmount.abs());
                    info.setAmount(BgNConstants.ZERO);
                }
            } else {
                for (i = 0; i < size; ++i) {
                    info = (BgInnerDataCheckInfo)datas.get(i);
                    if (info.getBizDirection() != 1) continue;
                    if (++creditIndex >= creditSize) {
                        adjAmount = info.getAmount().subtract(diffAmount.abs());
                        info.setAmount(adjAmount);
                        return BgNConstants.ZERO;
                    }
                    if (info.getAmount().compareTo(BgNConstants.ZERO) < 0) continue;
                    if (info.getAmount().compareTo(diffAmount.abs()) >= 0) {
                        adjAmount = info.getAmount().add(diffAmount);
                        info.setAmount(adjAmount);
                        return BgNConstants.ZERO;
                    }
                    diffAmount = info.getAmount().subtract(diffAmount.abs());
                    info.setAmount(BgNConstants.ZERO);
                }
            }
        }
        return diffAmount;
    }

    private void handleDiff() {
        block8: {
            IRow row;
            BigDecimal amount;
            BigDecimal diffAmount;
            int rowCount;
            block9: {
                block10: {
                    rowCount = this.getTblMain().getRowCount();
                    if (rowCount <= 0) {
                        return;
                    }
                    diffAmount = (BigDecimal)this.getTblMain().getRow(0).getCell(col_diff).getValue();
                    amount = null;
                    row = null;
                    if (!BgElimDiffDealEnum.Up.equals((Object)this.diffDeal)) break block9;
                    if (diffAmount == null || diffAmount.compareTo(BgNConstants.ZERO) <= 0) break block10;
                    for (int i = 0; i < rowCount; ++i) {
                        row = this.getTblMain().getRow(i);
                        amount = (BigDecimal)row.getCell(col_creditAmount).getValue();
                        if (amount == null) continue;
                        row.getCell(col_creditAmount).setValue((Object)amount.add(diffAmount.abs()));
                        break block8;
                    }
                    break block8;
                }
                if (diffAmount == null || diffAmount.compareTo(BgNConstants.ZERO) >= 0) break block8;
                for (int i = 0; i < rowCount; ++i) {
                    row = this.getTblMain().getRow(i);
                    amount = (BigDecimal)row.getCell(col_debitAmount).getValue();
                    if (amount == null) continue;
                    row.getCell(col_debitAmount).setValue((Object)amount.add(diffAmount.abs()));
                    break block8;
                }
                break block8;
            }
            if (!BgElimDiffDealEnum.low.equals((Object)this.diffDeal)) break block8;
            if (diffAmount != null && diffAmount.compareTo(BgNConstants.ZERO) > 0) {
                for (int i = 0; i < rowCount; ++i) {
                    row = this.getTblMain().getRow(i);
                    amount = (BigDecimal)row.getCell(col_debitAmount).getValue();
                    if (amount == null) continue;
                    row.getCell(col_debitAmount).setValue((Object)amount.subtract(diffAmount.abs()));
                    break;
                }
            } else if (diffAmount != null && diffAmount.compareTo(BgNConstants.ZERO) < 0) {
                for (int i = 0; i < rowCount; ++i) {
                    row = this.getTblMain().getRow(i);
                    amount = (BigDecimal)row.getCell(col_creditAmount).getValue();
                    if (amount == null) continue;
                    row.getCell(col_creditAmount).setValue((Object)amount.subtract(diffAmount.abs()));
                    break;
                }
            }
        }
    }

    @Override
    public void actionCheck_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.getTblMain().getRowCount();
        IRow row = null;
        HashMap<String, ArrayList<Object>> map = new HashMap<String, ArrayList<Object>>();
        ArrayList<BgInnerDataCheckInfo> checkList = new ArrayList<BgInnerDataCheckInfo>();
        BgInnerDataCheckInfo info = null;
        Object key = null;
        BigDecimal diffAmount = new BigDecimal("0.00");
        for (int i = 0; i < rowCount; ++i) {
            row = this.getTblMain().getRow(i);
            if (this.isEmptyRow(row) || this.isSumRow(row)) continue;
            if (key == null) {
                key = row.getUserObject();
            }
            info = new BgInnerDataCheckInfo();
            info.setId((String)row.getCell(col_dataId).getValue());
            info.setOrgUnitId((String)row.getCell(col_orgUnitId).getValue());
            info.setOppOrgUnitId((String)row.getCell(col_oppOrgUnitId).getValue());
            info.setBgItemId((String)row.getCell(col_bgItemId).getValue());
            info.setBgItemNumber((String)row.getCell(col_bgItemNumber).getValue());
            info.setBgItemName((String)row.getCell(col_bgItemName).getValue());
            if (row.getCell(col_debitAmount).getValue() != null) {
                info.setAmount((BigDecimal)row.getCell(col_debitAmount).getValue());
                diffAmount = diffAmount.add(info.getAmount());
            } else if (row.getCell(col_creditAmount).getValue() != null) {
                info.setAmount((BigDecimal)row.getCell(col_creditAmount).getValue());
                diffAmount = diffAmount.subtract(info.getAmount());
            }
            checkList.add(info);
        }
        if (!checkList.isEmpty()) {
            if (diffAmount.compareTo(BgNConstants.ZERO) != 0) {
                if (key == null) {
                    key = this.getUIContext().get("orgNums");
                }
                MsgBox.showWarning((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)RES_PATH, (String)"amountNotEqualcantConfirm"), ((String)key).split("\\|")));
                SysUtil.abort();
            }
            map.put("datas", checkList);
            map.put("BG_SCHEME", (ArrayList<Object>)this.getUIContext().get("BG_SCHEME"));
            map.put("BG_PERIOD", (ArrayList<Object>)this.getUIContext().get("BG_PERIOD"));
            map.put("BG_ELEMENT", (ArrayList<Object>)this.getUIContext().get("BG_ELEMENT"));
            map.put("CURRENCY", (ArrayList<Object>)this.getUIContext().get("CURRENCY"));
            map.put("DATA_TYPE", (ArrayList<Object>)this.getUIContext().get("DATA_TYPE"));
            if (this.getBgElimFacade().confirmInnerData(map)) {
                this.isConfirmed = true;
                this.showSuccessMsg(EASResource.getString((String)RES_PATH, (String)"checkSuccess"));
                this.actionExitCurrent_actionPerformed(e);
            }
        }
    }

    @Override
    protected void kDTable1_editStopped(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        if (colIndex == 9 || colIndex == 10) {
            this.refreshSumAmount();
        }
    }

    private void refreshSumAmount() {
        int rowCount = this.getTblMain().getRowCount();
        IRow row = null;
        BigDecimal debitAmount = null;
        BigDecimal creditAmount = null;
        BigDecimal sumDebitAmount = new BigDecimal("0.00");
        BigDecimal sumCreditAmount = new BigDecimal("0.00");
        for (int i = 0; i < rowCount; ++i) {
            row = this.getTblMain().getRow(i);
            if (this.isSumRow(row)) {
                row.getCell(col_debitAmount).setValue((Object)sumDebitAmount);
                row.getCell(col_creditAmount).setValue((Object)sumCreditAmount);
                sumDebitAmount = new BigDecimal("0.00");
                sumCreditAmount = new BigDecimal("0.00");
                continue;
            }
            debitAmount = (BigDecimal)row.getCell(col_debitAmount).getValue();
            creditAmount = (BigDecimal)row.getCell(col_creditAmount).getValue();
            sumDebitAmount = sumDebitAmount.add(debitAmount == null ? BgNConstants.ZERO : debitAmount);
            sumCreditAmount = sumCreditAmount.add(creditAmount == null ? BgNConstants.ZERO : creditAmount);
        }
    }

    private boolean isEmptyRow(IRow row) {
        if (row == null) {
            return true;
        }
        return !(row.getCell(col_creditFilled).getValue() instanceof BigDecimal && BgNConstants.ZERO.compareTo((BigDecimal)row.getCell(col_creditFilled).getValue()) != 0 || row.getCell(col_debitFilled).getValue() instanceof BigDecimal && BgNConstants.ZERO.compareTo((BigDecimal)row.getCell(col_debitFilled).getValue()) != 0 || row.getCell(col_creditAmount).getValue() instanceof BigDecimal && BgNConstants.ZERO.compareTo((BigDecimal)row.getCell(col_creditAmount).getValue()) != 0) && (!(row.getCell(col_debitAmount).getValue() instanceof BigDecimal) || BgNConstants.ZERO.compareTo((BigDecimal)row.getCell(col_debitAmount).getValue()) == 0);
    }

    private boolean isSumRow(IRow row) {
        String key = (String)row.getUserObject();
        return SUMROW.equals(key);
    }

    private IBgElimTemplate getBgElimTemplateInterface() throws BOSException {
        return BgElimTemplateFactory.getRemoteInstance();
    }

    protected KDTable getTblMain() {
        return this.kDTable1;
    }

    protected Object formatCellDisplay(int rowIndex, int colIndex, ICell cell, Object value) {
        if (value instanceof BigDecimal && StringUtils.isEmpty((String)cell.getFormattedStyleAttributes().getNumberFormat())) {
            cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            cell.getStyleAttributes().setNumberFormat(NUM_FOTMATTER);
        }
        return value;
    }

    private IBgElimFacade getBgElimFacade() throws BOSException {
        return BgElimFacadeFactory.getRemoteInstance();
    }

    public void showSuccessMsg(String msg) {
        this.setMessageIcon(SHOW_MESSAGE_ICON_OK);
        this.setMessageBgcolor(SHOW_MESSAGE_BG_OK);
        this.setMessageText(msg);
        this.showMessage();
    }

    public boolean destroyWindow() {
        if (!this.isViewMode && !this.isConfirmed) {
            int re = MsgBox.showConfirm2((String)EASResource.getString((String)RES_PATH, (String)"diffDealNotFinished"));
            if (0 != re) {
                return false;
            }
            return super.destroyWindow();
        }
        return super.destroyWindow();
    }

    private final class UserCellDisplayParser
    implements IUserCellDisplayParser {
        private UserCellDisplayParser() {
        }

        public Object parse(int rowIndex, int colIndex, ICell cell, Object value) {
            return BgInnerDataDiffDealUI.this.formatCellDisplay(rowIndex, colIndex, cell, value);
        }
    }
}

