/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgActualRecordFacadeFactory;
import com.kingdee.eas.ma.budget.BgDataTypeEnum;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgActualRecordFacade;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgNActualCollectViewUI;
import com.kingdee.eas.ma.nbudget.client.BgNActualRecordProcessUI;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgNActualCollectViewUI
extends AbstractBgNActualCollectViewUI {
    private static final Logger logger = CoreUIObject.getLogger(BgNActualCollectViewUI.class);
    private IBgActualRecordFacade iBgActFacade = null;

    public IBgActualRecordFacade getBgActualCollectInterface() throws BOSException {
        if (this.iBgActFacade == null) {
            this.iBgActFacade = BgActualRecordFacadeFactory.getRemoteInstance();
        }
        return this.iBgActFacade;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.processInitSystem();
        this.processCollectInfo();
    }

    private void processInitSystem() {
        this.txtBgDataType.setText("");
        this.txtBgElementName.setText("");
        this.txtBgItemName.setText("");
        this.txtBgItemNumber.setText("");
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.contBgItemName.setEnabled(false);
        this.contBgItemNumber.setEnabled(false);
        this.contBgElementName.setEnabled(false);
        this.contBgDataType.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processCollectInfo() throws BOSException, EASBizException {
        ArrayList<String[]> orgUnitList;
        BigDecimal measure;
        String[] parameter;
        String formulaString;
        block21: {
            block22: {
                formulaString = (String)this.getUIContext().get("GATHER_FORMULA");
                parameter = BgNFSHelper.parseFormulaPara(null, formulaString);
                measure = null;
                if (this.getUIContext().get("GATHER_MEASUREUNIT") != null) {
                    measure = (BigDecimal)this.getUIContext().get("GATHER_MEASUREUNIT");
                }
                String orgUnitID = null;
                String orgName = null;
                ArrayList orgUnitList1 = null;
                ArrayList orgUnitList2 = null;
                HashMap bgSchemeMap = null;
                String[] orgUnitStr = null;
                orgUnitList = new ArrayList<String[]>();
                if (this.getUIContext().get("GATHER_ORG_ID") == null) return;
                if (this.getUIContext().get("GATHER_SCHEME") == null) return;
                orgUnitList1 = (ArrayList)this.getUIContext().get("GATHER_ORG_ID");
                orgUnitList2 = (ArrayList)this.getUIContext().get("GATHER_ORG_NAME");
                bgSchemeMap = (HashMap)this.getUIContext().get("GATHER_SCHEME");
                if (orgUnitList1 == null) return;
                if (orgUnitList1.isEmpty()) return;
                if (bgSchemeMap == null) return;
                if (bgSchemeMap.isEmpty()) return;
                int n = orgUnitList1.size();
                for (int i = 0; i < n; ++i) {
                    orgUnitID = (String)orgUnitList1.get(i);
                    orgName = (String)orgUnitList2.get(i);
                    if (!bgSchemeMap.containsKey(orgUnitID)) continue;
                    orgUnitStr = new String[]{orgUnitID, orgName, (String)bgSchemeMap.get(orgUnitID)};
                    orgUnitList.add(orgUnitStr);
                }
                bgSchemeMap = null;
                if (parameter == null) return;
                if (parameter[0] == null || parameter[0].trim().length() <= 0) break block22;
                HashSet<String> bgItemsSet = new HashSet<String>();
                HashMap<String, String> bgItemsMap = new HashMap<String, String>();
                String bgItemsName = null;
                String[] bgItems = parameter[0].split(",");
                int n2 = bgItems.length;
                for (int i = 0; i < n2; ++i) {
                    bgItemsSet.add(bgItems[i]);
                }
                try {
                    IBgItem ibgItem = BgItemFactory.getRemoteInstance();
                    if (ibgItem == null) {
                        throw new BgException(BgException.NOINSTANCE);
                    }
                    String orgUnitId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
                    orgUnitId = BgSHelper.getIsolateOrg((String)orgUnitId);
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", bgItemsSet, CompareType.INCLUDE));
                    filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
                    view.setFilter(filter);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("number"));
                    view.getSelector().addObjectCollection((IObjectCollection)sic);
                    BgItemInfo bgItemInfo2222222 = null;
                    BgItemCollection bgItemCol = ibgItem.getBgItemCollection(view);
                    for (BgItemInfo bgItemInfo2222222 : bgItemCol) {
                        if (bgItemsMap.containsKey(bgItemInfo2222222.getNumber())) continue;
                        bgItemsMap.put(bgItemInfo2222222.getNumber(), bgItemInfo2222222.getName());
                    }
                    if (bgItemCol != null) {
                        bgItemCol.clear();
                    }
                    int n3 = bgItems.length;
                    for (int i = 0; i < n3; ++i) {
                        bgItemsName = i == 0 ? (String)bgItemsMap.get(bgItems[i]) : bgItemsName + "|" + bgItemsMap.get(bgItems[i]);
                    }
                    this.txtBgItemNumber.setText(parameter[0]);
                }
                catch (BOSException ex) {
                    throw ex;
                    catch (EASBizException ex2) {
                        throw ex2;
                    }
                    catch (Exception e) {
                        logger.error((Object)"budget error:", (Throwable)e);
                        break block21;
                    }
                }
                this.txtBgItemName.setText(bgItemsName);
                break block21;
                finally {
                    this.txtBgItemNumber.setText(parameter[0]);
                    this.txtBgItemName.setText(bgItemsName);
                }
            }
            this.txtBgItemNumber.setText("");
            this.txtBgItemName.setText("");
        }
        this.dealBGelement(parameter);
        this.txtBgDataType.setText(BgDataTypeEnum.BgActual.getAlias());
        int idecimal = this.dealCurrency(parameter);
        String bgPeriodId = this.getUIContext().get("bgPeriodId") == null ? "" : this.getUIContext().get("bgPeriodId").toString();
        List reInfo = this.getBgActualCollectInterface().getCollectData(formulaString, orgUnitList, bgPeriodId);
        if (reInfo == null) return;
        if (reInfo.isEmpty()) return;
        String[] data = null;
        IRow row = null;
        int i = 0;
        int n = 0;
        int x = 0;
        int y = 0;
        i = 0;
        n = reInfo.size();
        while (true) {
            if (i >= n) {
                this.tblMain.getSelectManager().select(0, 0, 0, 0);
                return;
            }
            data = (String[])reInfo.get(i);
            row = this.tblMain.addRow();
            if (measure == null) {
                y = data.length;
                for (x = 0; x < y; ++x) {
                    row.getCell(x).setValue((Object)data[x]);
                }
            } else {
                row.getCell(0).setValue((Object)data[0]);
                try {
                    row.getCell(1).setValue((Object)new BigDecimal(data[1]).divide(measure, idecimal, 4).toString());
                }
                catch (Exception ex) {
                    row.getCell(1).setValue((Object)data[1]);
                }
                row.getCell(2).setValue((Object)data[2]);
            }
            ++i;
        }
    }

    private int dealCurrency(String[] parameter) throws BOSException, EASBizException {
        CurrencyInfo currencyInfo;
        int idecimal = 8;
        if (parameter != null && parameter[5] != null && (currencyInfo = BgSHelper.getCurrencyInfo(null, (String)parameter[5], null)) != null) {
            idecimal = currencyInfo.getPrecision();
        }
        return idecimal;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dealBGelement(String[] parameter) throws BOSException, EASBizException {
        if (parameter[2] == null) return;
        if (parameter[2].trim().length() <= 0) return;
        String bgElementName = null;
        try {
            IBgElement ibgElement = BgElementFactory.getRemoteInstance();
            if (ibgElement == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)parameter[2], CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            BgElementCollection bgElementCol = ibgElement.getBgElementCollection(view);
            bgElementName = !bgElementCol.isEmpty() ? bgElementCol.get(0).getName() : "";
            if (bgElementCol != null) {
                bgElementCol.clear();
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (EASBizException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                this.txtBgElementName.setText(bgElementName);
                throw throwable;
            }
        }
        this.txtBgElementName.setText(bgElementName);
    }

    @Override
    protected void btnViewRpt_actionPerformed(ActionEvent e) throws Exception {
        super.btnViewRpt_actionPerformed(e);
        this.openReport(OprtState.VIEW);
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 2) {
            this.openReport(OprtState.VIEW);
        }
    }

    protected void openReport(String reportState) throws Exception {
        Object bgActualRecordId;
        if (this.tblMain.getBody().size() == 0) {
            return;
        }
        int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (activeRowIndex < 0) {
            activeRowIndex = 0;
        }
        if ((bgActualRecordId = this.tblMain.getCell(activeRowIndex, 2).getValue()) != null && bgActualRecordId.toString().trim().length() != 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)bgActualRecordId.toString());
            uiContext.put((Object)"isWillAudit", (Object)false);
            uiContext.put((Object)"isWillUnAudit", (Object)false);
            uiContext.put((Object)"ORGUNIT_INFO", this.getUIContext().get("ORGUNIT_INFO"));
            uiContext.put((Object)"ORGUNIT_CU", this.getUIContext().get("ORGUNIT_CU"));
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgNActualRecordProcessUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
    }
}

