/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.client.GeneralModifyingManager;
import com.kingdee.eas.fi.rpt.client.IModifyingManager;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.ma.budget.BgActualRecordException;
import com.kingdee.eas.ma.budget.BgActualRecordFacadeFactory;
import com.kingdee.eas.ma.budget.BgActualRecordFactory;
import com.kingdee.eas.ma.budget.BgActualRecordInfo;
import com.kingdee.eas.ma.budget.BgActualRecordStateEnum;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgActualRecord;
import com.kingdee.eas.ma.budget.IBgActualRecordFacade;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.client.BgActualRecordProcessUI;
import com.kingdee.eas.ma.nbudget.BgNExpressionHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgNActualRecordEditUI;
import com.kingdee.eas.ma.nbudget.client.BgCodeNumberCHelper;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class BgNActualRecordEditUI
extends AbstractBgNActualRecordEditUI {
    private static final long serialVersionUID = 7116737467957626727L;
    private static final Logger logger = CoreUIObject.getLogger(BgNActualRecordEditUI.class);
    private static final String RESOURCE = "com.kingdee.eas.ma.budget.client.BgActualRecordResource";
    private FullOrgUnitInfo ccOrgUnitInfo = null;
    private boolean hasCodeNumber = false;
    private boolean hasShowCodeNumber = false;
    private boolean hasSubmit = false;
    private boolean isUseIntermitNumber = false;
    private boolean hasProperty = false;
    private IModifyingManager imm = null;

    public boolean isHasProperty() {
        return this.hasProperty;
    }

    public void setHasProperty(boolean hasProperty) {
        this.hasProperty = hasProperty;
    }

    public IModifyingManager getModifyingManager() {
        if (this.imm == null) {
            this.imm = new GeneralModifyingManager();
        }
        return this.imm;
    }

    public IObjectValue getEditDataObject() {
        return this.editData;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgActualRecordFactory.getRemoteInstance();
    }

    public boolean isHasSubmit() {
        return this.hasSubmit;
    }

    public void setHasSubmit(boolean hasSubmit) {
        this.hasSubmit = hasSubmit;
    }

    public boolean isUseIntermitNumber() {
        return this.isUseIntermitNumber;
    }

    public void setUseIntermitNumber(boolean isUseIntermitNumber) {
        this.isUseIntermitNumber = isUseIntermitNumber;
    }

    protected IObjectValue createNewData() {
        BgActualRecordInfo info = new BgActualRecordInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setCU((CtrlUnitInfo)this.getUIContext().get("ORGUNIT_CU"));
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)this.ccOrgUnitInfo.getId().toString()));
        info.setCompany(company);
        info.setName(this.txtName.getText());
        return info;
    }

    protected void prepareNumber(IObjectValue caller, String number) {
        if (number != null && number.length() > 0) {
            caller.put("number", (Object)number);
            this.txtNumber.setText(number);
        }
    }

    @Override
    public void storeFields() {
        this.editData.setIsEditByPeriod(this.kdCheckByPeriod.isSelected());
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnReset.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnCancel.setVisible(false);
        this.separatorFile1.setVisible(false);
        this.separatorFW1.setVisible(false);
        this.separatorFW2.setVisible(false);
        this.separatorFW3.setVisible(false);
        this.actionReset.setEnabled(false);
        this.actionAddNew.setEnabled(false);
        this.actionRemove.setEnabled(false);
    }

    public boolean getIsCacl() {
        return this.getOprtState().equals("ADDNEW");
    }

    public void beforeLoad() throws EASBizException {
        if (this.getUIContext().get("ORGUNIT_INFO") != null) {
            this.ccOrgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("ORGUNIT_INFO");
        }
    }

    protected void loadData() throws Exception {
        super.loadData();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            String CUID = this.ccOrgUnitInfo.getId().toString();
            boolean re = BgCodeNumberCHelper.hasCodeNumber((IObjectValue)this.editData, CUID, "sourceType");
            if (re) {
                this.setHasProperty(true);
            } else {
                this.setHasProperty(false);
                re = BgCodeNumberCHelper.hasCodeNumber((IObjectValue)this.editData, CUID);
            }
            this.setHasCodeNumber(re);
            this.txtNumber.setEnabled(!re);
            if (this.isHasCodeNumber()) {
                re = this.isHasProperty() ? BgCodeNumberCHelper.hasDisplayNumber((IObjectValue)this.editData, CUID, "sourceType") : BgCodeNumberCHelper.hasDisplayNumber((IObjectValue)this.editData, CUID);
                this.setHasShowCodeNumber(re);
            }
            this.getNumberByCodingRule((IObjectValue)this.editData, CUID);
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            String OUID = this.ccOrgUnitInfo.getId().toString();
            BgCodeNumberCHelper.dealNameCodeRule(this.txtName, (IObjectValue)this.editData, OUID, "sourceType", "name", (EditUI)this);
        }
    }

    protected void getNumberByCodingRule(IObjectValue caller, String orgId) {
        if (this.isHasCodeNumber() && this.isHasShowCodeNumber()) {
            if (this.isHasProperty()) {
                BgCodeNumberCHelper.applyNumber(this.txtNumber, (IObjectValue)this.editData, orgId, "sourceType", this.isHasCodeNumber(), this.isHasShowCodeNumber());
            } else {
                BgCodeNumberCHelper.applyNumber(this.txtNumber, (IObjectValue)this.editData, orgId, this.isHasCodeNumber(), this.isHasShowCodeNumber());
            }
        }
    }

    public boolean isHasCodeNumber() {
        return this.hasCodeNumber;
    }

    public void setHasCodeNumber(boolean hasCodeNumber) {
        this.hasCodeNumber = hasCodeNumber;
    }

    public boolean isHasShowCodeNumber() {
        return this.hasShowCodeNumber;
    }

    public void setHasShowCodeNumber(boolean hasShowCodeNumber) {
        this.hasShowCodeNumber = hasShowCodeNumber;
    }

    public void onLoad() throws Exception {
        this.beforeLoad();
        super.onLoad();
        String strKey = "CTRL_SHIFT_S";
        KeyStroke ks = KeyStroke.getKeyStroke(83, 192, false);
        this.getActionMap().put(strKey, (Action)this.actionSubmit);
        this.getInputMap(2).put(ks, strKey);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            this.prmtCurrency.setData((Object)this.editData.getBgForm().getCurrency());
            this.kdCheckByPeriod.setSelected(this.editData.isIsEditByPeriod());
            this.kdCheckByPeriod.setEnabled(false);
        }
        this.initMeasure();
        if (this.getOprtState().equals("ADDNEW")) {
            IUser iUser = UserFactory.getRemoteInstance();
            UserInfo user = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()));
            this.prmtLastUpdateUser.setData((Object)user);
            this.pkLastUpdateTime.setValue((Object)new Date(System.currentTimeMillis()));
            this.editData.setState(BgActualRecordStateEnum.Edited);
        } else {
            for (int i = 0; i < this.comboBgPeriod.getItemCount(); ++i) {
                if (!((BgPeriodInfo)this.comboBgPeriod.getItemAt(i)).getId().toString().equals(this.editData.getBgPeriod().getId().toString())) continue;
                this.comboBgPeriod.setSelectedIndex(i);
                break;
            }
            this.kdCheckFormulaFormTem.setEnabled(false);
        }
        this.setBgFormView();
        if (this.getOprtState().equals("ADDNEW")) {
            this.getModifyingManager().setModifiedCount(0);
        }
        if (this.editData.getBgPeriod() != null && this.editData.getBgForm() != null) {
            String periodId = this.editData.getBgPeriod().getId().toString();
            this.comboBgPeriod.removeAllItems();
            BgFormInfo bgForm = this.editData.getBgForm();
            IBgForm iForm = BgFormFactory.getRemoteInstance();
            BgFormInfo tmpForm = iForm.getBgFormInfo("select bgPeriod.* where id='" + bgForm.getId() + "'");
            BgPeriodInfo period = tmpForm.getBgPeriod();
            if (period == null) {
                return;
            }
            BgPeriodCollection coll = this.getBgPeriodColl(period);
            this.comboBgPeriod.addItems(coll.toArray());
            for (int i = 0; i < coll.size(); ++i) {
                if (!((BgPeriodInfo)this.comboBgPeriod.getItemAt(i)).getId().toString().equals(periodId)) continue;
                this.comboBgPeriod.setSelectedIndex(i);
                break;
            }
        }
    }

    private void initMeasure() throws BOSException {
        IMeasureUnit iM = MeasureUnitFactory.getRemoteInstance();
        EntityViewInfo muView = new EntityViewInfo();
        FilterInfo muFilter = new FilterInfo();
        muFilter.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        muView.setFilter(muFilter);
        muView.getSorter().add(new SorterItemInfo("id"));
        muView.getSorter().add(new SorterItemInfo("name"));
        muView.getSorter().add(new SorterItemInfo("number"));
        MeasureUnitCollection measureColl = iM.getMeasureUnitCollection(muView);
        if (measureColl != null && measureColl.size() != 0) {
            this.comboMeasure.addItems(measureColl.toArray());
        }
        if (!this.getOprtState().equals("ADDNEW") && this.editData != null && this.editData.getBgForm() != null) {
            String mearureId = this.editData.getMeasureUnit() == null ? this.editData.getBgForm().getMeasureUnit().getId().toString() : this.editData.getMeasureUnit().getId().toString();
            for (int i = 0; i < this.comboMeasure.getItemCount(); ++i) {
                if (!((MeasureUnitInfo)this.comboMeasure.getItemAt(i)).getId().toString().equals(mearureId)) continue;
                this.comboMeasure.setSelectedIndex(i);
            }
        }
    }

    public boolean isModify() {
        if (this.getOprtState().equals("FINDVIEW") || this.getOprtState().equals("VIEW")) {
            return false;
        }
        return this.getModifyingManager().isModified();
    }

    protected void setBgFormView() {
        String orgNumber = ((FullOrgUnitInfo)this.getUIContext().get("ORGUNIT_INFO")).getNumber();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.number", (Object)orgNumber));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(2)));
        filter.setMaskString(" #0 and #1 ");
        if (BgParamCHelper.isFodian()) {
            filter.getFilterItems().add(new FilterItemInfo("bgPeriod.periodType", (Object)new Integer(4), CompareType.NOTEQUALS));
            filter.setMaskString(" #0 and #1 and #2 ");
        }
        if (BgSHelper.isBgPermissionUsed()) {
            HashSet<String> orgId = new HashSet<String>();
            orgId.add(((FullOrgUnitInfo)this.getUIContext().get("ORGUNIT_INFO")).getId().toString());
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            filter = BgPermissionHelper.addBgFormPermissionFormActualRecord(userId, orgId, filter);
        }
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.formType", (Object)new Integer(2), CompareType.NOTEQUALS));
        filter.setMaskString(filter.getMaskString() + " and #" + (filter.getFilterItems().size() - 1));
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.formType", (Object)new Integer(4), CompareType.NOTEQUALS));
        filter.setMaskString(filter.getMaskString() + " and #" + (filter.getFilterItems().size() - 1));
        view.setFilter(filter);
        this.prmtBgForm.setEntityViewInfo(view);
    }

    public VirtualSheetParamInfo save() throws Exception {
        if (!this.verifyInput()) {
            this.getUIWindow().show();
            if (this.getButtonAction() == 1) {
                this.save();
            } else {
                this.abort();
            }
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        if (((IBgActualRecord)this.getBizInterface()).exists((IObjectPK)pk)) {
            ((IBgActualRecord)this.getBizInterface()).update((IObjectPK)pk, (CoreBaseInfo)this.editData);
        } else {
            pk = ((IBgActualRecord)this.getBizInterface()).addnew((CoreBaseInfo)this.editData);
        }
        this.setOprtState("EDIT");
        this.setDataObject((IObjectValue)((IBgActualRecord)this.getBizInterface()).getBgActualRecordInfo((IObjectPK)pk, this.getSelectors()));
        this.save = true;
        this.txtNumber.setText(this.editData.getNumber());
        this.getModifyingManager().setModifiedCount(0);
        return this.editData;
    }

    private boolean verifyInput() {
        this.storeFields();
        return true;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        this.check();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.checkBgFormState();
            this.submitBgActualRecordInfo();
            this.setHasSubmit(true);
            this.destroyWindow();
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            super.actionSubmit_actionPerformed(e);
            this.getUIWindow().close();
        }
    }

    private void checkBgFormState() throws Exception {
        if (this.editData != null && this.editData.getBgForm() != null && this.editData.getBgForm().getId() != null) {
            String bgFormId = this.editData.getBgForm().getId().toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("state");
            BgFormInfo form = null;
            try {
                form = BgFormFactory.getRemoteInstance().getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId), sic);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            if (form != null && form.getState() != null && form.getState().getValue() != 2) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"66_BgNActualRecordEditUI"));
                SysUtil.abort();
            }
        }
    }

    private void submitBgActualRecordInfo() throws BOSException, EASBizException {
        BgFormInfo targetBgForm = null;
        IBgForm iBgForm = BgFormFactory.getRemoteInstance();
        targetBgForm = iBgForm.getBgFormInfo("select data, bgScheme.id, bgScheme.rootid, bgScheme.number, orgUnit.id, orgUnit.number, orgUnit.isCompanyOrgUnit, company.number, currency.*, bgTemplate.id, bgTemplate.rootid, bgTemplate.data, bgPeriod.*, sheetParam.*, measureUnit.*, bgMeasureUnit.*,bgTemplate.formType where id = '" + this.editData.getBgForm().getId() + "'");
        if (this.kdCheckFormulaFormTem.isSelected()) {
            try {
                this.updateFormulaWithBgTemplate(targetBgForm);
            }
            catch (Exception e) {
                logger.error((Object)"budget error:", (Throwable)e);
                MsgBox.showError((Component)((Object)this), (String)"updateFormulaWithBgTemplate error");
            }
        }
        this.editData.setId(BOSUuid.create((BOSObjectType)this.editData.getBOSType()));
        try {
            Book book = IOHelper.unpackBook((byte[])targetBgForm.getData());
            BgNExpressionHelper.dealAcctExpressionAtAddNew(book, (IObjectValue)this.editData, 2);
            this.editData.setData(IOHelper.packBook((Book)book));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.editData.getBgForm().setOrgUnit(targetBgForm.getOrgUnit());
        this.editData.getBgForm().setBgScheme(targetBgForm.getBgScheme());
        this.editData.getBgForm().setBgTemplate(targetBgForm.getBgTemplate());
        this.editData.getBgForm().setBgPeriod(targetBgForm.getBgPeriod());
        this.editData.getBgForm().setCurrency(targetBgForm.getCurrency());
        if (targetBgForm.getSheetParam() != null && !targetBgForm.getSheetParam().isEmpty()) {
            this.editData.getBgForm().getSheetParam().clear();
            this.editData.getBgForm().getSheetParam().addCollection(targetBgForm.getSheetParam());
        }
        CompanyOrgUnitInfo companyInfo = null;
        try {
            companyInfo = this.getCompanyByOrgUnit((OrgUnitInfo)targetBgForm.getOrgUnit());
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        if (companyInfo != null) {
            this.editData.setCompany(companyInfo);
            this.editData.getBgForm().setCompany(companyInfo);
        } else {
            companyInfo = SysContext.getSysContext().getCurrentFIUnit();
            this.editData.setCompany(companyInfo);
            this.editData.getBgForm().setCompany(companyInfo);
        }
        this.editData.getBgForm().setMeasureUnit(targetBgForm.getMeasureUnit());
        this.editData.getBgForm().getBgMeasureUnit().addCollection(targetBgForm.getBgMeasureUnit());
    }

    protected SelectorItemCollection getCompanySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("isBizUnit");
        sic.add("accountPeriodType.id");
        return sic;
    }

    protected INewOrgViewFacade getOrgFacadeInterface() throws Exception {
        return NewOrgViewFacadeFactory.getRemoteInstance();
    }

    protected CompanyOrgUnitInfo getCompanyByOrgUnit(OrgUnitInfo orgUnitInfo) throws Exception {
        if (orgUnitInfo.isIsCompanyOrgUnit()) {
            return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), this.getCompanySelectors());
        }
        OrgUnitInfo parent = this.getOrgFacadeInterface().getParent(orgUnitInfo.getId().toString(), OrgViewType.COSTCENTER);
        if (parent != null) {
            return this.getCompanyByOrgUnit(parent);
        }
        return null;
    }

    private void updateFormulaWithBgTemplate(BgFormInfo targetBgForm) throws Exception {
        int n;
        int m;
        int i;
        BgTemplateInfo temInfo = targetBgForm.getBgTemplate();
        Book formB = targetBgForm.getBook();
        Book temB = temInfo.getBook();
        if (formB == null || temB == null) {
            return;
        }
        BgNFSHelper.disableCal(formB);
        BgNFSHelper.disableUndo(formB);
        String companyNumber = BgNExpressionHelper.getCompanyNumber(null, (IObjectValue)targetBgForm);
        HashMap<String, String> formulaMap = new HashMap<String, String>();
        Sheet sheet = null;
        Cell cell = null;
        for (i = 0; i < temB.getSheetCount(); ++i) {
            sheet = temB.getSheet(i);
            for (m = 0; m <= sheet.getMaxRowIndex(); ++m) {
                for (n = 0; n <= sheet.getMaxColIndex(); ++n) {
                    cell = sheet.getCell(m, n, false);
                    if (!BgNFSHelper.checkHasExpression(cell, 2)) continue;
                    formulaMap.put(BgNFSHelper.getRowSign(sheet.getRow(m, false)) + BgNFSHelper.getColSign(sheet.getColumn(n, false)), BgNFSHelper.loadExpression(cell, 2));
                }
            }
        }
        for (i = 0; i < formB.getSheetCount(); ++i) {
            sheet = formB.getSheet(i);
            for (m = 0; m <= sheet.getMaxRowIndex(); ++m) {
                for (n = 0; n <= sheet.getMaxColIndex(); ++n) {
                    cell = sheet.getCell(m, n, false);
                    if (cell == null) continue;
                    if (formulaMap.containsKey(BgNFSHelper.getRowSign(sheet.getRow(m, false)) + BgNFSHelper.getColSign(sheet.getColumn(n, false)))) {
                        BgNFSHelper.saveExpression(cell, (String)formulaMap.get(BgNFSHelper.getRowSign(sheet.getRow(m, false)) + BgNFSHelper.getColSign(sheet.getColumn(n, false))), 2);
                        BgNFSHelper.checkExpressions(cell, (IObjectValue)targetBgForm, 2, companyNumber);
                        continue;
                    }
                    BgNFSHelper.clearExpression(cell, 2);
                }
            }
        }
        BgNFSHelper.enableCal(formB);
        BgNFSHelper.enableUndo(formB);
        targetBgForm.setBook(formB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check() throws BOSException, EASBizException, BgActualRecordException {
        String id = this.editData.getId() == null ? "" : this.editData.getId().toString();
        String number = this.editData.getNumber();
        String bgFormId = this.editData.getBgForm().getId().toString();
        String bgPeriodId = this.editData.getBgPeriod().getId().toString();
        IBgActualRecordFacade iActual = BgActualRecordFacadeFactory.getRemoteInstance();
        StringBuffer kSql = new StringBuffer();
        kSql.append(" select count(ar.FId) as fidcount");
        kSql.append("   from T_BG_BgActualRecord ar,");
        kSql.append("        T_BG_BgForm f");
        kSql.append("  where ar.FBgFormId = f.FId");
        kSql.append("    and ar.FId <> '" + id + "'");
        kSql.append("    and f.FOrgUnitId = '" + this.ccOrgUnitInfo.getId().toString() + "'");
        kSql.append("    and ar.FNumber = '" + number + "'");
        ISQLExecutor sqlExecuter = SQLExecutorFactory.getRemoteInstance((String)kSql.toString());
        IRowSet rst = sqlExecuter.executeSQL();
        try {
            if (rst.next() && rst.getInt(1) > 0) {
                throw new BgActualRecordException(BgActualRecordException.DUPNUMBER);
            }
        }
        catch (SQLException ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
        boolean isCanInput = iActual.checkCanInputActual(id, bgFormId, bgPeriodId);
        if (!isCanInput) {
            throw new BgActualRecordException(BgActualRecordException.DUPACTUALRECORD);
        }
        if (this.comboBgPeriod.getSelectedItem() != null) {
            BgPeriodInfo period = (BgPeriodInfo)this.comboBgPeriod.getSelectedItem();
            BgActualRecordFactory.getRemoteInstance().checkBgPeriodAcross(id.trim().equals("") ? "xxx" : id, bgFormId, period.getBeginDate(), period.getEndDate());
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.txtNumber.isEnabled() && StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.requestFocus();
            this.showWarning("numberIsNull");
        }
        if (this.txtName.isEnabled() && StringUtils.isEmpty((String)this.txtName.getText())) {
            this.txtName.requestFocus();
            this.showWarning("nameIsNull");
        }
        if (!(this.prmtBgForm.getData() instanceof BgFormInfo)) {
            this.prmtBgForm.requestFocus();
            this.showWarning("bgFormIsNull");
        }
        if (this.comboBgPeriod.getSelectedItem() == null) {
            this.comboBgPeriod.requestFocus();
            this.showWarning("bgPeriodIsNull");
        }
    }

    private void showWarning(String key) {
        if (key == null) {
            return;
        }
        MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)key));
        SysUtil.abort();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("isEditByPeriod"));
        sic.add(new SelectorItemInfo("bgPeriod.*"));
        sic.add(new SelectorItemInfo("measureUnit.id"));
        sic.add(new SelectorItemInfo("bgForm.id"));
        sic.add(new SelectorItemInfo("bgForm.name"));
        sic.add(new SelectorItemInfo("bgForm.state"));
        sic.add(new SelectorItemInfo("bgForm.measureUnit.id"));
        sic.add(new SelectorItemInfo("bgForm.bgMeasureUnit.id"));
        sic.add(new SelectorItemInfo("bgForm.bgPeriod.id"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("bgForm.sheetParam.*"));
        sic.add(new SelectorItemInfo("bgForm.currency.id"));
        sic.add(new SelectorItemInfo("bgForm.currency.name"));
        sic.add(new SelectorItemInfo("bgForm.currency.number"));
        sic.add(new SelectorItemInfo("bgForm.currency.precision"));
        sic.add(new SelectorItemInfo("bgForm.bgScheme.number"));
        sic.add(new SelectorItemInfo("bgForm.orgUnit.id"));
        sic.add(new SelectorItemInfo("bgForm.orgUnit.number"));
        sic.add(new SelectorItemInfo("bgForm.orgUnit.name"));
        sic.add(new SelectorItemInfo("bgForm.company.id"));
        sic.add(new SelectorItemInfo("bgForm.company.number"));
        sic.add(new SelectorItemInfo("bgForm.company.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.*"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("isFormulaFromTem"));
        return sic;
    }

    public String getReportUIName() {
        return BgActualRecordProcessUI.class.getName();
    }

    @Override
    protected void prmtBgForm_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.prmtBgForm.isEnabled()) {
            return;
        }
        if (this.prmtBgForm.getData() != null) {
            this.comboBgPeriod.removeAllItems();
            BgFormInfo bgForm = null;
            Object value = this.prmtBgForm.getData();
            if (value instanceof BgFormInfo) {
                bgForm = (BgFormInfo)this.prmtBgForm.getData();
            } else if (value instanceof String) {
                try {
                    String bgFormNumber = value.toString();
                    String orgNumber = ((FullOrgUnitInfo)this.getUIContext().get("ORGUNIT_INFO")).getNumber();
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("orgUnit.number", (Object)orgNumber));
                    filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(2)));
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)bgFormNumber, CompareType.EQUALS));
                    filter.setMaskString(" #0 and #1 and #2 ");
                    if (BgParamCHelper.isFodian()) {
                        filter.getFilterItems().add(new FilterItemInfo("bgPeriod.periodType", (Object)new Integer(4), CompareType.NOTEQUALS));
                        filter.setMaskString(" #0 and #1 and #2 and #3 ");
                    }
                    if (BgSHelper.isBgPermissionUsed()) {
                        HashSet<String> orgId = new HashSet<String>();
                        orgId.add(((FullOrgUnitInfo)this.getUIContext().get("ORGUNIT_INFO")).getId().toString());
                        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                        filter = BgPermissionHelper.addBgFormPermissionFormActualRecord(userId, orgId, filter);
                    }
                    view.setFilter(filter);
                    view.setSelector(this.getSelectors());
                    BgFormCollection col = null;
                    try {
                        col = BgFormFactory.getRemoteInstance().getBgFormCollection(view);
                    }
                    catch (ObjectNotFoundException objectNotFoundException) {
                        // empty catch block
                    }
                    if (col != null && col.size() > 0) {
                        bgForm = col.get(0);
                        this.prmtBgForm.setData((Object)bgForm);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"budget error:", (Throwable)ex);
                }
            }
            if (bgForm == null) {
                this.prmtBgForm.setValue((Object)"");
                return;
            }
            BgPeriodInfo period = bgForm.getBgPeriod();
            if (period == null) {
                return;
            }
            BgPeriodCollection coll = this.getBgPeriodColl(period);
            this.comboBgPeriod.addItems(coll.toArray());
            ICurrency ic = CurrencyFactory.getRemoteInstance();
            this.prmtCurrency.setData((Object)ic.getValue((IObjectPK)new ObjectUuidPK(bgForm.getCurrency().getId())));
            if (bgForm.getMeasureUnit() != null) {
                String mearureId = bgForm.getMeasureUnit().getId().toString();
                for (int i = 0; i < this.comboMeasure.getItemCount(); ++i) {
                    if (!((MeasureUnitInfo)this.comboMeasure.getItemAt(i)).getId().toString().equals(mearureId)) continue;
                    this.comboMeasure.setSelectedIndex(i);
                }
            }
        } else {
            this.comboBgPeriod.removeAllItems();
            this.prmtCurrency.setData(null);
            this.comboMeasure.setSelectedIndex(0);
        }
    }

    private Date rebuildDate(Date date, boolean isMin) {
        int year = date.getYear();
        int month = date.getMonth();
        int _date = date.getDate();
        if (isMin) {
            return new Date(year, month, _date, 0, 0, 0);
        }
        return new Date(year, month, _date, 23, 59, 59);
    }

    private BgPeriodCollection getBgPeriodColl(BgPeriodInfo period) throws BOSException, EASBizException {
        IBgPeriod iPeriod = BgPeriodFactory.getRemoteInstance();
        period = iPeriod.getBgPeriodInfo("select longNumber, periodType, beginDate,endDate where id = '" + period.getId() + "'");
        String longNumber = period.getLongNumber();
        int type = period.getPeriodType().getValue();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (type == 8) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)period.getId()));
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)this.rebuildDate(period.getBeginDate(), true), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)this.rebuildDate(period.getEndDate(), false), CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("periodtype", (Object)new Integer(1)));
            filter.setMaskString("#0 or ( #1 and #2 and #3 )");
            SorterItemInfo sort1 = new SorterItemInfo("periodtype");
            sort1.setSortType(SortType.DESCEND);
            SorterItemInfo sort2 = new SorterItemInfo("longNumber");
            sort2.setSortType(SortType.ASCEND);
            view.getSorter().add(sort1);
            view.getSorter().add(sort2);
        } else {
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)longNumber));
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
            filter.setMaskString("#0 or #1");
            view.getSorter().add(new SorterItemInfo("longNumber"));
        }
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("longNumber"));
        view.getSelector().add(new SelectorItemInfo("beginDate"));
        view.getSelector().add(new SelectorItemInfo("endDate"));
        view.getSelector().add(new SelectorItemInfo("year"));
        view.getSelector().add(new SelectorItemInfo("month"));
        view.getSelector().add(new SelectorItemInfo("halfyear"));
        view.getSelector().add(new SelectorItemInfo("week"));
        view.getSelector().add(new SelectorItemInfo("quarter"));
        view.getSelector().add(new SelectorItemInfo("periodType"));
        BgPeriodCollection coll = iPeriod.getBgPeriodCollection(view);
        return coll;
    }
}

