/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetOption;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgUnitHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.client.designer.IMenuStrategy;
import com.kingdee.eas.fi.newrpt.client.designer.render.DefaultItemRenderProvider;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.fi.newrpt.designer.IReportVariableProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgActualRecordException;
import com.kingdee.eas.ma.budget.BgActualRecordFacadeFactory;
import com.kingdee.eas.ma.budget.BgActualRecordFactory;
import com.kingdee.eas.ma.budget.BgActualRecordInfo;
import com.kingdee.eas.ma.budget.BgActualRecordPropertyAdapter;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormHelper;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemHelper;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgActualRecordFacade;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.client.AssignSolutionUI;
import com.kingdee.eas.ma.budget.client.BgCollectViewUI;
import com.kingdee.eas.ma.budget.client.BgEnumerateRender;
import com.kingdee.eas.ma.budget.client.BgSubOrgUnitSelectUIForForm;
import com.kingdee.eas.ma.nbudget.BgActualRecordDisplayValueProvider;
import com.kingdee.eas.ma.nbudget.BgActualRecordProvider;
import com.kingdee.eas.ma.nbudget.BgActualRecordVariableProvider;
import com.kingdee.eas.ma.nbudget.BgExpressionsParseHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNExpressionHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNLockProtectHelper;
import com.kingdee.eas.ma.nbudget.BgNTemplateHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgNActualRecordProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgActualRecordMenuManager;
import com.kingdee.eas.ma.nbudget.client.BgNActualRecordEditUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.ma.nbudget.client.BgUserCellDisplayProvider;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class BgNActualRecordProcessUI
extends AbstractBgNActualRecordProcessUI {
    private static final long serialVersionUID = -8818517902585984207L;
    private static final Logger logger = CoreUIObject.getLogger(BgNActualRecordProcessUI.class);
    public static final String RESOURCE = "com.kingdee.eas.ma.budget.client.BgActualRecordResource";
    public static final String NRESOURCE = "com.kingdee.eas.ma.nbudget.client.BgNActualRecordResource";
    public static final String GATHER_ORG_ID = "GATHER_ORG_ID";
    public static final String GATHER_ORG_NAME = "GATHER_ORG_NAME";
    private CostCenterOrgUnitInfo ccOrgUnit = SysContext.getSysContext().getCurrentCostUnit();
    private String formulaType = "bgActualAdd";

    @Override
    public IMenuStrategy getBudgetMenuStrategy() {
        return new BgActualRecordMenuManager((Component)((Object)this));
    }

    @Override
    public IBookProvider getBudgetProvider() {
        return new BgActualRecordProvider((Component)((Object)this));
    }

    @Override
    public IReportVariableProvider getBudgetVariableProvider() {
        return new BgActualRecordVariableProvider();
    }

    @Override
    protected BgUserCellDisplayProvider getCellDisplayRender() {
        BgUserCellDisplayProvider render = new BgUserCellDisplayProvider();
        render.setDisplayValueProvider(new BgActualRecordDisplayValueProvider((Component)((Object)this)));
        BgUserCellDisplayProvider.addRenderProvider((IRenderProvider)new DefaultItemRenderProvider());
        BgUserCellDisplayProvider.addRenderProvider((IRenderProvider)new BgEnumerateRender());
        return render;
    }

    @Override
    protected void showAllBook() throws Exception {
        if (!OprtState.ADDNEW.equals(this.getOprtState())) {
            Book book = this.getBook();
            UserInfo create = null;
            create = this.getBgFormInfo() != null ? this.getBgFormInfo().getCreator() : SysContext.getSysContext().getCurrentUserInfo();
            if (create != null && book != null) {
                int n = book.getSheetCount();
                for (int i = 0; i < n; ++i) {
                    if (book.getSheet(i).getUserObjectValue("SHEET_CREATER_ID") != null) continue;
                    book.getSheet(i).setUserObject("SHEET_CREATER_ID", (Object)create.getId().toString());
                }
            }
        }
        super.showAllBook();
    }

    @Override
    public BgFormInfo getBgFormInfo() {
        if ((BgActualRecordInfo)this.getBookProvider().getEditValue() != null) {
            return ((BgActualRecordInfo)this.getBookProvider().getEditValue()).getBgForm();
        }
        return null;
    }

    public BgActualRecordInfo getActualRecordInfo() {
        return (BgActualRecordInfo)this.getBookProvider().getEditValue();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemSort.setVisible(false);
        this.menuItemValidation.setVisible(false);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.actionImport.setEnabled(true);
            this.actionExport.setVisible(true);
            this.actionExport.setEnabled(true);
            this.actionExport.setVisible(true);
            this.menuItemImport.setEnabled(true);
            this.menuItemImport.setVisible(true);
            Book book = ((BgActualRecordProvider)this.getBookProvider()).getBgActualRecordInfo().getBook();
            BgNFSHelper.disableCal(book);
            BgNFSHelper.disableUndo(book);
            this.updateValueAndExpression(book);
            this.getSpreadManager().getSpreadContainer().setBook(book);
            this.getBook().getUndoManager().enable(true);
            this.getBook().setCalculate(false);
            this.showVarialbes();
        }
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.actionImport.setEnabled(true);
            this.actionExport.setVisible(true);
            this.actionExport.setEnabled(true);
            this.actionExport.setVisible(true);
            this.menuItemImport.setEnabled(true);
            this.menuItemImport.setVisible(true);
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actionCalculate.setEnabled(false);
            this.actionCalculateSelectedSheet.setEnabled(false);
        }
        this.actionCreateExpFromItemProperty.setVisible(true);
        this.actionCreateExpFromItemProperty.setEnabled(true);
        Book _book = null;
        Sheet _sheet = null;
        boolean isSheetPer = BgParamCHelper.isBgSheetPermissionUsed();
        Map sheetPer = null;
        if (isSheetPer) {
            sheetPer = this.addBgSheetPermission();
        }
        String user = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        _book = this.getBook();
        boolean isShowSheet = false;
        if (_book != null) {
            int sheetIndex = 0;
            int sheetSize = _book.getSheetCount();
            for (sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                _sheet = _book.getSheet(sheetIndex);
                if (isSheetPer) {
                    if (!isShowSheet) {
                        isShowSheet = this.hideSheet(_sheet, sheetPer, user);
                        continue;
                    }
                    this.hideSheet(_sheet, sheetPer, user);
                    continue;
                }
                _sheet.setHide(false);
            }
        }
        if (isSheetPer && !isShowSheet) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"67_BgNActualRecordProcessUI"));
            SysUtil.abort();
        }
        this.updateExpr(this.getBook());
        this.setCalculateState();
        this.formulaType = "bgActualAdd";
        BgNTemplateHelper.showForceLock(this.getBook());
        if (BgParamCHelper.isCalculateOfAddNew() && OprtState.ADDNEW.equals(this.getOprtState()) || this.isCalculateTag() && !OprtState.VIEW.equals(this.getOprtState())) {
            this.actionCalculate_actionPerformed(null);
        }
        String strKey = "CTRL_SHIFT_S";
        KeyStroke ks = KeyStroke.getKeyStroke(83, 192, false);
        this.getActionMap().put(strKey, (Action)this.actionSave);
        this.getInputMap(2).put(ks, strKey);
        strKey = "CTRL_I";
        ks = KeyStroke.getKeyStroke(73, 128, false);
        this.getActionMap().put(strKey, (Action)this.actionImport);
        this.getInputMap(2).put(ks, strKey);
        strKey = "SHIFT_F3";
        ks = KeyStroke.getKeyStroke(114, 64, false);
        this.getActionMap().put(strKey, (Action)this.actionAttachement);
        this.getInputMap(2).put(ks, strKey);
        strKey = "CTRL_SHIFT_O";
        ks = KeyStroke.getKeyStroke(79, 192, false);
        this.getActionMap().put(strKey, (Action)((Object)this.actionOrgCollect));
        this.getInputMap(2).put(ks, strKey);
        strKey = "CTRL_SHIFT_E";
        ks = KeyStroke.getKeyStroke(69, 192, false);
        this.getActionMap().put(strKey, (Action)this.actionExport);
        this.getInputMap(2).put(ks, strKey);
        this.kmNormal.setVisible(false);
        this.kmPagin.setVisible(false);
        this.menuItemClassifiedStatistics.setVisible(false);
        this.menuItemToolBarCustom.setVisible(false);
        this.menuItemToolBarCustom.setEnabled(false);
        this.menuItemQueryBizBill.setVisible(false);
        this.menuItemQueryBizBill.setEnabled(false);
        this.actionSetCtrl.setVisible(false);
    }

    @Override
    protected boolean isNeedCalculateForAddNew() {
        return false;
    }

    @Override
    protected boolean isCalculateOfUpdate() {
        return false;
    }

    @Override
    protected void afterLockedAndProtection() {
        super.afterLockedAndProtection();
    }

    @Override
    protected boolean isActualRecordUI() {
        return true;
    }

    @Override
    protected void afterSave() throws Exception {
        this.setHint(true);
        this.actionImport.setEnabled(true);
        this.actionExport.setVisible(true);
        this.actionExport.setEnabled(true);
        this.actionExport.setVisible(true);
        this.menuItemImport.setEnabled(true);
        this.menuItemImport.setVisible(true);
        this.menuItemExport.setEnabled(true);
        this.menuItemExport.setVisible(true);
        this.setUITitle(this.getUITitle());
    }

    @Override
    public void onShow() {
        super.onShow();
        this.setUITitle(this.getUITitle());
        this.menuItemImport.setAccelerator(KeyStroke.getKeyStroke(73, 128, false));
        this.menuItemExport.setAccelerator(KeyStroke.getKeyStroke(69, 192, false));
        this.menuItemCopy.setAccelerator(KeyStroke.getKeyStroke(67, 128, false));
        this.menuItemDelete.setAccelerator(KeyStroke.getKeyStroke(68, 128, false));
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke(123, 192, false));
        this.menuItemAttachement.setAccelerator(KeyStroke.getKeyStroke(114, 64, false));
    }

    public String getUITitle() {
        Object state = this.getUIContext().get("isWillAudit");
        state = state instanceof Boolean && (Boolean)state != false ? "AUDIT" : this.getOprtState();
        return EASResource.getString((String)NRESOURCE, (String)"bgActualRecord") + " - " + BgNFCHelper.getMessageStr(state.toString()) + " - " + (this.getEditData().get("name") == null ? "" : this.getEditData().get("name"));
    }

    @Override
    public MeasureUnitInfo getMeasureUnit() {
        return this.getActualRecordInfo().getMeasureUnit();
    }

    @Override
    protected void initToolbarAction() {
        super.initToolbarAction();
        this.toolBar.remove((Component)this.btnAuditActual);
        this.toolBar.remove((Component)this.btnUnAuditActual);
        ToolBarManager toolBarManager = this.getSpreadManager().getSpreadContainer().getToolBarManager();
        this.actionRefer.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        toolBarManager.addFirstGroupItem((Action)((Object)this.actionRefer), "common");
        toolBarManager.addFirstGroupItem((Component)this.btnAuditActual, "common");
        toolBarManager.addFirstGroupItem((Component)this.btnUnAuditActual, "common");
    }

    @Override
    protected void defFillCellValue(Cell cell) {
        if (cell != null && cell.getValue().getValue() == null) {
            BgNFSHelper.setValue(cell, BgNConstants.ZERO);
        }
    }

    @Override
    protected void showCell(Cell cell) throws Exception {
        super.showCell(cell);
        if (cell == null) {
            return;
        }
        if (OprtState.ADDNEW.equals(this.getOprtState()) && BgNFSHelper.checkHasFormulaOfCell(cell)) {
            BgNFSHelper.setFormulaEditOfCell(cell, false);
        }
        if (cell.hasFormula() && this.isLockCellByFormula()) {
            BgNFSHelper.setLockOfCell(cell, true);
        }
    }

    protected void updateValueAndExpression(Book book) throws BgFormException {
        boolean isEnum = false;
        if (this.getActualRecordInfo() != null && this.getActualRecordInfo().getBgForm() != null && this.getActualRecordInfo().getBgForm().getBgTemplate() != null && this.getActualRecordInfo().getBgForm().getBgTemplate().getFormType() != null) {
            boolean bl = isEnum = this.getActualRecordInfo().getBgForm().getBgTemplate().getFormType().getValue() == 1;
        }
        if (book == null) {
            return;
        }
        Sheet _sheet = null;
        Cell _cell = null;
        String companyNumber = BgNExpressionHelper.getCompanyNumber(null, (IObjectValue)this.getActualRecordInfo());
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        String expression = null;
        int _sheetSize = book.getSheetCount();
        for (int _sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
            _sheet = book.getSheet(_sheetIndex);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (_cell == null) continue;
                    BgNLockProtectHelper.setCellLockedAndProtectionOnlyCell(_cell, false, false);
                    if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
                        BgNFSHelper.setFormulaEditOfCell(_cell, false);
                        BgNFSHelper.setValue(_cell, null);
                        expression = BgNFSHelper.loadExpression(_cell, 2);
                        if (!StringUtils.isEmpty((String)expression)) {
                            if (isEnum) {
                                String e_budget = BgNFSHelper.loadExpression(_cell, 0);
                                String e_actual = BgNFSHelper.loadExpression(_cell, 1);
                                if (BgExpressionsParseHelper.isSumExpress(expression) && BgExpressionsParseHelper.isSumExpress(e_actual) && BgExpressionsParseHelper.isSumExpress(e_budget)) {
                                    expression = e_budget;
                                }
                            }
                            String tmpExp = BgNExpressionHelper.checkExpression(_cell, expression, (IObjectValue)this.getActualRecordInfo(), null, companyNumber);
                            BgNFSHelper.setExpression(_cell, tmpExp);
                        } else {
                            BgNFSHelper.clearExpression(_cell);
                        }
                    }
                    if (!_cell.hasFormula()) continue;
                    BgNFSHelper.setValue(_cell, null);
                    if (!this.isLockCellByFormula()) continue;
                    BgNFSHelper.setLockOfCell(_cell, true);
                }
            }
        }
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCalculate.setToolTipText(EASResource.getString((String)NRESOURCE, (String)"calculate"));
        this.btnAuditActual.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnUnAuditActual.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.btnOrgCollect.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.btnViewOrgCollect.setIcon(EASResource.getIcon((String)"imgTbtn_seegather"));
        this.itemAuditActual.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.itemUnAuditActual.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.itemOrgCollect.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.itemViewOrgCollect.setIcon(EASResource.getIcon((String)"imgTbtn_seegather"));
        this.menuItemExport.setEnabled(true);
        this.menuItemExport.setVisible(true);
        this.menuItemRemoveBgFormula.setVisible(false);
        this.menuItemRemoveBgFormula.setEnabled(false);
        this.itemItemInput.setVisible(false);
        this.itemItemInput.setEnabled(false);
        this.initBtnEnable();
        this.menuItemReportVariables.setVisible(false);
        this.btnViewGatherBook.setVisible(false);
        this.btnViewGatherBookItemCol.setVisible(false);
        this.btnViewGatherBookOrgCol.setVisible(false);
        this.actionGather.setVisible(false);
        this.actionViewGather.setVisible(false);
        this.menuProtect.setVisible(false);
        this.menuItemGroup.setVisible(false);
        this.menuFilter.setVisible(false);
    }

    private void initBtnEnable() {
        boolean isWillUnAudit;
        this.actionViewItemFormula.setEnabled(false);
        this.actionViewItemFormula.setVisible(false);
        this.actionShowSumRange.setEnabled(false);
        this.actionShowSumRange.setVisible(false);
        this.menuViewInfo.setEnabled(false);
        this.menuViewInfo.setVisible(false);
        this.actionRefer.setVisible(false);
        this.actionProperty.setVisible(false);
        this.actionProperty.setEnabled(false);
        boolean isWillAudit = this.getUIContext().get("isWillAudit") == null ? false : (Boolean)this.getUIContext().get("isWillAudit");
        boolean bl = isWillUnAudit = this.getUIContext().get("isWillUnAudit") == null ? false : (Boolean)this.getUIContext().get("isWillUnAudit");
        if (isWillAudit && !isWillUnAudit) {
            this.actionAuditActual.setVisible(true);
            this.actionAuditActual.setEnabled(true);
            this.actionUnAuditActual.setVisible(false);
            this.actionUnAuditActual.setEnabled(false);
        } else if (!isWillAudit && isWillUnAudit) {
            this.actionAuditActual.setVisible(false);
            this.actionAuditActual.setEnabled(false);
            this.actionUnAuditActual.setVisible(true);
            this.actionUnAuditActual.setEnabled(true);
        } else {
            this.actionAuditActual.setVisible(false);
            this.actionAuditActual.setEnabled(false);
            this.actionUnAuditActual.setVisible(false);
            this.actionUnAuditActual.setEnabled(false);
        }
        if (isWillAudit || isWillUnAudit) {
            this.actionOrgCollect.setVisible(false);
            this.actionOrgCollect.setEnabled(false);
            this.actionCalculateSelectedSheet.setEnabled(false);
            this.actionCalculateSelectedSheet.setVisible(false);
            this.actionCalculate.setEnabled(false);
            this.actionCalculate.setVisible(false);
            this.actionImport.setVisible(false);
            this.actionExport.setVisible(false);
        }
        this.initExpressionButtonState();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkRecordState();
        if (this.getBookProvider().getEditValue() instanceof BgActualRecordInfo) {
            BgActualRecordInfo record = (BgActualRecordInfo)this.getBookProvider().getEditValue();
            try {
                String companyId = null;
                if (record.getCompany() != null && record.getCompany().getId() != null) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("isCompanyOrgUnit"));
                    sic.add(new SelectorItemInfo("parent"));
                    String ccid = record.getCompany().getId().toString();
                    while (true) {
                        OrgUnitInfo org = null;
                        try {
                            org = NewOrgUnitHelper.getTypedOrgUnit((String)ccid, (SelectorItemCollection)sic, (OrgType)OrgType.CostCenter);
                        }
                        catch (ObjectNotFoundException ex) {
                            logger.error((Object)ex);
                        }
                        if (org == null || org.get("parent") == null) break;
                        if (org.isIsCompanyOrgUnit()) {
                            companyId = org.getId().toString();
                            break;
                        }
                        ccid = ((OrgUnitInfo)org.get("parent")).getId().toString();
                    }
                    if (!StringUtils.isEmpty(companyId)) {
                        record.getCompany().setId(BOSUuid.read(companyId));
                    }
                }
                if (record.getBgForm() != null) {
                    record.setSourceType(record.getBgForm().getSourceType());
                }
            }
            catch (ObjectNotFoundException ex) {
                logger.error((Object)ex);
            }
        }
        super.actionSave_actionPerformed(e);
        this.setUITitle(this.getUITitle());
    }

    private void checkRecordState() throws Exception {
        BgActualRecordInfo bgActualRecordInfo = (BgActualRecordInfo)this.getBookProvider().getEditValue();
        if (!this.getOprtState().equals(OprtState.ADDNEW) && bgActualRecordInfo != null && bgActualRecordInfo.getId() != null) {
            BgActualRecordInfo info = null;
            try {
                info = BgActualRecordFactory.getRemoteInstance().getBgActualRecordInfo((IObjectPK)new ObjectUuidPK(bgActualRecordInfo.getId()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (info != null && info.getState().getValue() != 1) {
                throw new BgActualRecordException(BgActualRecordException.NOTINEDITED);
            }
        }
    }

    @Override
    protected SelectorItemCollection getFormSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("createTime");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("lastUpdateTime");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateUser.name");
        sic.add("startDate");
        sic.add("endDate");
        sic.add("data");
        sic.add("isEditByPeriod");
        sic.add("isFormulaFromTem");
        sic.add("state");
        sic.add("measureUnit.id");
        sic.add("measureUnit.name");
        sic.add("measureUnit.number");
        sic.add("measureUnit.coefficient");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.periodType");
        sic.add("bgPeriod.beginDate");
        sic.add("bgPeriod.endDate");
        sic.add("bgPeriod.year");
        sic.add("bgPeriod.halfYear");
        sic.add("bgPeriod.quarter");
        sic.add("bgPeriod.month");
        sic.add("bgPeriod.week");
        sic.add("periodType");
        sic.add("bgMeasureUnit.id");
        sic.add("bgMeasureUnit.bgElement.id");
        sic.add("bgMeasureUnit.bgElement.name");
        sic.add("bgMeasureUnit.bgElement.number");
        sic.add("bgMeasureUnit.measureUnit.id");
        sic.add("bgMeasureUnit.measureUnit.name");
        sic.add("bgMeasureUnit.measureUnit.number");
        sic.add("bgMeasureUnit.measureUnit.coefficient");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("currency.isoCode");
        sic.add("currency.precision");
        sic.add("postils.*");
        sic.add("postils.report.id");
        sic.add("postils.sheet.id");
        sic.add("postils.sheet.sheetID");
        sic.add("postils.creator.id");
        sic.add("postils.creator.name");
        sic.add("sheetParam.id");
        sic.add("sheetParam.*");
        sic.add("sheetParam.orgRela.id");
        sic.add("sheetParam.orgRela.orgType");
        sic.add("sheetParam.orgRela.orgUnit.id");
        sic.add("sheetParam.orgRela.orgUnit.type");
        sic.add("sheetParam.orgRela.orgUnit.name");
        sic.add("sheetParam.currency.id");
        sic.add("sheetParam.currency.number");
        sic.add("sheetParam.currency.name");
        sic.add("sheetParam.currency.precision");
        sic.add("sheetParam.postils.*");
        sic.add("sheetParam.postils.report.id");
        sic.add("sheetParam.postils.sheet.id");
        sic.add("sheetParam.postils.sheet.sheetID");
        sic.add("sheetParam.postils.creator.id");
        sic.add("sheetParam.postils.creator.name");
        sic.add("bgForm.currency.id");
        sic.add("bgForm.currency.name");
        sic.add("bgForm.currency.number");
        sic.add("bgForm.currency.isoCode");
        sic.add("bgForm.currency.precision");
        sic.add("bgForm.id");
        sic.add("bgForm.name");
        sic.add("bgForm.number");
        sic.add("bgForm.createTime");
        sic.add("bgForm.creator.id");
        sic.add("bgForm.creator.name");
        sic.add("bgForm.lastUpdateTime");
        sic.add("bgForm.lastUpdateUser.id");
        sic.add("bgForm.lastUpdateUser.name");
        sic.add("bgForm.state");
        sic.add("bgForm.auditedStatus");
        sic.add("bgForm.dataSource");
        sic.add("bgForm.description");
        sic.add("bgForm.versionNo");
        sic.add("bgForm.startDate");
        sic.add("bgForm.endDate");
        sic.add("bgForm.data");
        sic.add("bgForm.orgUnit.id");
        sic.add("bgForm.orgUnit.name");
        sic.add("bgForm.orgUnit.number");
        sic.add("bgForm.company.id");
        sic.add("bgForm.company.name");
        sic.add("bgForm.company.number");
        sic.add("bgForm.company.isBizUnit");
        sic.add("bgForm.company.accountPeriodType.id");
        sic.add("bgForm.CU.id");
        sic.add("bgForm.CU.name");
        sic.add("bgForm.bgType.id");
        sic.add("bgForm.bgType.name");
        sic.add("bgForm.bgType.number");
        sic.add("bgForm.bgScheme.id");
        sic.add("bgForm.bgScheme.name");
        sic.add("bgForm.bgScheme.number");
        sic.add("bgForm.bgScheme.period");
        sic.add("bgForm.bgScheme.rootId");
        sic.add("bgForm.bgScheme.isFormal");
        sic.add("bgForm.bgTemplate.id");
        sic.add("bgForm.bgTemplate.name");
        sic.add("bgForm.bgTemplate.number");
        sic.add("bgForm.bgTemplate.canModify");
        sic.add("bgForm.bgTemplate.parent.id");
        sic.add("bgForm.bgTemplate.rootId");
        sic.add("bgForm.bgTemplate.formType");
        sic.add("bgForm.bgPeriod.id");
        sic.add("bgForm.bgPeriod.number");
        sic.add("bgForm.bgPeriod.periodType");
        sic.add("bgForm.bgPeriod.name");
        return sic;
    }

    @Override
    public void actionFormulaValueSwitch_actionPerformed(ActionEvent e) throws Exception {
        Book book = this.getBook();
        for (int i = 0; i < book.getSheetCount(); ++i) {
            SheetOption so = book.getSheet(i).getSheetOption();
            if ("value".equals(e.getActionCommand())) {
                if (so.getCellDisplayMode() == 0) continue;
                so.setCellDisplayMode(0);
                this.getSpreadManager().getSpreadContainer().repaint();
                continue;
            }
            if (!"formula".equals(e.getActionCommand()) || so.getCellDisplayMode() == 1) continue;
            so.setCellDisplayMode(1);
            this.getSpreadManager().getSpreadContainer().repaint();
        }
    }

    @Override
    public void actionOrgCollect_actionPerformed(ActionEvent e) throws Exception {
        super.actionOrgCollect_actionPerformed(e);
        Book _book = null;
        Book _tmpBook = null;
        Sheet _sheet = null;
        String _billId = this.getBillId();
        String _billName = null;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        if (StringUtils.isEmpty((String)_billId)) {
            return;
        }
        BgFormInfo _bgFormInfo = this.getBgFormInfo();
        _billName = _bgFormInfo.getName();
        _orgUnitId = _bgFormInfo.getOrgUnit().getId().toString();
        _bgSchemeId = _bgFormInfo.getBgScheme().getId().toString();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)_bgSchemeId);
        uiContext.put((Object)"BGFORM_ID", (Object)_billId);
        uiContext.put((Object)"BGFORM_NAME", (Object)_billName);
        uiContext.put((Object)"BGFORM_SHEET", (Object)this.getSheets());
        uiContext.put((Object)"ORGUNIT_CU", (Object)_orgUnitId);
        uiContext.put((Object)"GATHER_TYPE", (Object)new Boolean(this.isGatherType()));
        uiContext.put((Object)"selfPanelUiName", (Object)BgSubOrgUnitSelectUIForForm.class.getName());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AssignSolutionUI.class.getName(), (Map)uiContext);
        uiWindow.show();
        Map solution = (Map)((AssignSolutionUI)uiWindow.getUIObject()).getReturnData();
        if (solution == null || solution.isEmpty()) {
            return;
        }
        _bgFormInfo = new BgFormInfo();
        _bgFormInfo.setId(this.getBgFormInfo().getId());
        _bgFormInfo.setState(this.getBgFormInfo().getState());
        _bgFormInfo.setBgScheme(this.getBgFormInfo().getBgScheme());
        _bgFormInfo.setBgTemplate(this.getBgFormInfo().getBgTemplate());
        _bgFormInfo.setBgPeriod(this.getBgFormInfo().getBgPeriod());
        _bgFormInfo.setCurrency(this.getBgFormInfo().getCurrency());
        Map result = this.getGatherInterface().checkGatherInfo((IObjectValue)_bgFormInfo, this.getGatherOrgUnits(solution), this.getGatherParameter(solution));
        Map _gatherOrgUnitMap = (Map)result.get("GATHER_CHECK_ORGUNIT");
        Map _gatherCantOrgMap = (Map)result.get("GATHER_CHECK_CANT_ORGUNIT");
        Map _gatherBgSchemeMap = (Map)result.get("GATHER_CHECK_BGSCHEME_ID");
        Map _gatherBgFormIdsMap = (Map)result.get("GATHER_CHECK_BGFORM_ID");
        if (Boolean.FALSE.equals(result.get("GATHER_CHECK_RESULT"))) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "cantCollect"));
            return;
        }
        int re = 0;
        if (this.isGatherShowMsg(solution) && !_gatherCantOrgMap.isEmpty()) {
            re = MsgBox.showConfirm2((Component)((Object)this), (String)this.getGatherCantOrgMessage(_gatherCantOrgMap));
        }
        if (re == 0) {
            _bgFormInfo.setBook(this.getBook());
            BgFormInfo model = this.getGatherInterface().getGatherValue(_bgFormInfo, _gatherOrgUnitMap, _gatherBgSchemeMap, _gatherBgFormIdsMap, this.getGatherParameter(solution));
            if (model != null) {
                int i;
                int sheetCount = 0;
                String _sheetId = null;
                String _oldSheetId = null;
                HashMap<String, String> sheetIdMap = new HashMap<String, String>();
                HashMap<String, String> sheetNameMap = new HashMap<String, String>();
                _book = this.getBook();
                _tmpBook = model.getBook();
                sheetCount = _book.getSheetCount();
                BgNFSHelper.setBookLANDP(_book, false, null, null);
                int in = sheetCount;
                for (i = 0; i < in; ++i) {
                    _sheet = _book.getSheet(i);
                    sheetNameMap.put(_sheet.getID(), _sheet.getSheetName());
                }
                in = _tmpBook.getSheetCount();
                for (i = 0; i < in; ++i) {
                    _sheet = _tmpBook.getSheet(i);
                    _oldSheetId = _sheet.getID();
                    _book.addSheet(_sheet);
                    _sheet.updateUnknownMethod(_book.getDeps().getUnknownMethodManager());
                    _sheetId = _sheet.getID();
                    sheetIdMap.put(_sheetId, _oldSheetId);
                }
                in = sheetCount;
                for (i = 0; i < in; ++i) {
                    _book.removeSheet(0);
                }
                in = _book.getSheetCount();
                for (i = 0; i < in; ++i) {
                    _sheet = _tmpBook.getSheet(i);
                    _sheet.setID((String)sheetIdMap.get(_sheet.getID()));
                    _sheet.setName((String)sheetNameMap.get(_sheet.getID()));
                }
                BgNFSHelper.setBookLANDP(_book, false, null, BgNFSHelper.getMaxOperation());
                _book.setUserObject("GATHER_ORGUNIT", (Object)_gatherOrgUnitMap);
                _book.setUserObject("GATHER_SCHEME", (Object)_gatherBgSchemeMap);
                _book.setUserObject("GATHER_BGFORM", (Object)_gatherBgFormIdsMap);
                _book.setUserObject("IS_GATHER_ADJUST", (Object)new Boolean(this.isGatherTmpData(solution)));
                _book.setUserObject("IS_GATHER_PERIOD", (Object)new Boolean(this.isGatherByPeriod(solution)));
                this.showCtrl(_book.getSheet(0));
            }
        }
    }

    protected boolean isGatherByPeriod(Map solution) {
        return (Boolean)solution.get("GATHER_PERIOD");
    }

    @Override
    protected Map getGatherParameter(Map solution) {
        Map _parameter = super.getGatherParameter(solution);
        _parameter.put("GATHER_TYPE_EXT", "GATHER_ADD_ACTUAL");
        _parameter.put("GATHER_PERIOD", solution.get("GATHER_PERIOD"));
        _parameter.put("GATHER_PERIOD_ID", this.getActualRecordInfo().getBgPeriod().getId().toString());
        return _parameter;
    }

    @Override
    protected Boolean checkIsBudget() {
        return Boolean.FALSE;
    }

    @Override
    public void actionViewOrgCollect_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewOrgCollect_actionPerformed(e);
        Book _book = null;
        Cell _cell = null;
        String _formulaStr = null;
        _book = this.getBook();
        _cell = this.getBook().getActiveSheet().getActiveCell();
        if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
            _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"GATHER_DATA_TYPE", (Object)this.checkIsBudget());
            uiContext.put((Object)"BGSCHEME_ID", (Object)this.getBgFormInfo().getBgScheme().getRootId());
            uiContext.put((Object)"GATHER_FORMULA", (Object)_formulaStr);
            uiContext.put((Object)"GATHER_ORGUNIT", BgNFSHelper.getBookObject(_book, "GATHER_ORGUNIT"));
            uiContext.put((Object)"GATHER_SCHEME", BgNFSHelper.getBookObject(_book, "GATHER_SCHEME"));
            uiContext.put((Object)"GATHER_BGFORM", BgNFSHelper.getBookObject(_book, "GATHER_BGFORM"));
            uiContext.put((Object)"IS_GATHER_ADD", (Object)Boolean.TRUE);
            uiContext.put((Object)"IS_GATHER_PERIOD", BgNFSHelper.getBookObject(_book, "IS_GATHER_PERIOD"));
            uiContext.put((Object)"IS_GATHER_PERIOD_ID", (Object)this.getActualRecordInfo().getBgPeriod().getId().toString());
            BigDecimal _coefficient = BgNConstants.ONE;
            MeasureUnitInfo muInfo = ((BgActualRecordInfo)this.getBookProvider().getEditValue()).getMeasureUnit();
            if (muInfo != null && muInfo.getCoefficient() != null) {
                _coefficient = muInfo.getCoefficient();
            }
            if (!this.getMeasureUnitMap().isEmpty()) {
                String[] parameter = BgNFSHelper.parseFormulaPara(this.getFormulaMap(), _formulaStr);
                if (this.getMeasureUnitMap().containsKey(parameter[2])) {
                    _coefficient = (BigDecimal)this.getMeasureUnitMap().get(parameter[2]);
                }
            }
            uiContext.put((Object)"GATHER_MEASUREUNIT", (Object)_coefficient);
            uiContext.put((Object)"isActual", (Object)Boolean.TRUE);
            uiContext.put((Object)"operState", (Object)this.getOprtState());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgCollectViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"checkFormulaNoCollectView"));
        }
    }

    @Override
    public void actionAuditActual_actionPerformed(ActionEvent e) throws Exception {
        super.actionAuditActual_actionPerformed(e);
        String id = this.getBookProvider().getEditValue().get("id").toString();
        String bgFormId = this.getBgFormInfo().getId().toString();
        IBgActualRecordFacade iActual = BgActualRecordFacadeFactory.getRemoteInstance();
        iActual.auditBgActual(id, bgFormId);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"auditSuccess"));
        BgFormHelper.refreshBgFormList((CoreUI)((CoreUI)this.getUIContext().get("Owner")));
    }

    @Override
    public void actionUnAuditActual_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnAuditActual_actionPerformed(e);
        String id = this.getBookProvider().getEditValue().get("id").toString();
        String bgFormId = this.getBgFormInfo().getId().toString();
        IBgActualRecordFacade iActual = BgActualRecordFacadeFactory.getRemoteInstance();
        iActual.unAuditBgActual(id, bgFormId);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"unAuditSuccess"));
        BgFormHelper.refreshBgFormList((CoreUI)((CoreUI)this.getUIContext().get("Owner")));
    }

    @Override
    public void actionCreateExpFromItemProperty_actionPerformed(ActionEvent e) throws Exception {
        block28: {
            String[] tmpParams;
            String[] tmpPos;
            String tmpNumber;
            String exp;
            BgItemCollection bgItemCollection;
            HashMap<String, String> selectedFormulaPos;
            Sheet sheet;
            block29: {
                block27: {
                    super.actionCreateExpFromItemProperty_actionPerformed(e);
                    sheet = this.getBook().getActiveSheet();
                    Range range = sheet.getSelectionRange();
                    range.setIgnoreProtected(true);
                    int num = range.size();
                    if (num <= 0) {
                        return;
                    }
                    Protection pro = sheet.getSheetOption().getProtection(false);
                    boolean isPro = false;
                    if (pro != null && pro.isProtected() && !pro.allowEditObjects()) {
                        isPro = true;
                    }
                    boolean hasNotLock = false;
                    for (int i = 0; i < num; ++i) {
                        CellBlock block = range.getBlock(i);
                        int xn = block.getRow2();
                        for (int x = block.getRow(); x <= xn; ++x) {
                            int yn = block.getCol2();
                            for (int y = block.getCol(); y <= yn; ++y) {
                                Cell cell = sheet.getCell(x, y, true);
                                if (cell == null || isPro && BgNLockProtectHelper.isCellLocked(cell)) continue;
                                hasNotLock = true;
                                break;
                            }
                            if (hasNotLock) break;
                        }
                        if (hasNotLock) break;
                    }
                    if (!hasNotLock) {
                        MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"cellLock"));
                        SysUtil.abort();
                    }
                    selectedFormulaPos = new HashMap<String, String>();
                    Map allFormulaPos = BgItemHelper.getFormulaPosFromBook((Book)this.getBook());
                    HashMap selectedNumbers = new HashMap();
                    HashSet numbers = new HashSet();
                    String[] params = null;
                    int selectedCount = 0;
                    boolean hasCombinItem = false;
                    for (int i = 0; i < range.size(); ++i) {
                        CellBlock block = range.getBlock(i);
                        for (int j = block.getRow(); j <= block.getRow2(); ++j) {
                            for (int k = block.getCol(); k <= block.getCol2(); ++k) {
                                Cell cell;
                                if (sheet.getMergeBlock(j, k) != null || (cell = sheet.getCell(j, k, true)) == null) continue;
                                ++selectedCount;
                                if (!BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                                String formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                                params = BgNFSHelper.parseFormulaPara(null, formulaStr);
                                if (params[0].indexOf(44) != -1) {
                                    hasCombinItem = true;
                                    continue;
                                }
                                String pos = j + "," + k;
                                selectedFormulaPos.put(formulaStr, pos);
                                selectedNumbers.put(params[0], null);
                            }
                        }
                    }
                    if (selectedCount < 0) {
                        return;
                    }
                    if (!hasCombinItem && selectedNumbers.isEmpty()) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)NRESOURCE, (String)"selectCellWithFormula"));
                        return;
                    }
                    if (hasCombinItem && selectedNumbers.isEmpty()) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)NRESOURCE, (String)"canntConvertFormula"));
                        return;
                    }
                    if (hasCombinItem && !selectedNumbers.isEmpty()) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)NRESOURCE, (String)"convertFail", (Object[])new Object[]{"\n", "\n"}));
                    }
                    Iterator itNumbers = selectedNumbers.keySet().iterator();
                    while (itNumbers.hasNext()) {
                        numbers.add(itNumbers.next());
                    }
                    IBgItem ie = BgItemFactory.getRemoteInstance();
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)BgSHelper.getIsolateOrg((String)this.ccOrgUnit.getId().toString()), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
                    view.setFilter(filter);
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add("id");
                    selector.add("name");
                    selector.add("number");
                    selector.add("isSumFormula");
                    selector.add("formula");
                    selector.add("acctInit");
                    selector.add("acctMaintain");
                    view.getSelector().addObjectCollection((IObjectCollection)selector);
                    bgItemCollection = ie.getBgItemCollection(view);
                    boolean isSumFormula = false;
                    exp = "";
                    String transFormedExp = null;
                    tmpNumber = null;
                    BgItemInfo info2 = null;
                    String tmpFormula2 = null;
                    tmpPos = null;
                    tmpParams = null;
                    if (!this.formulaType.equals("bgData")) break block27;
                    for (BgItemInfo info2 : bgItemCollection) {
                        tmpNumber = info2.getNumber();
                        isSumFormula = info2.isIsSumFormula();
                        String string = exp = info2.getFormula() == null ? "" : info2.getFormula();
                        if (!isSumFormula) {
                            for (String tmpFormula2 : selectedFormulaPos.keySet()) {
                                tmpParams = BgNFSHelper.parseFormulaPara(null, tmpFormula2);
                                if (!tmpParams[0].equals(tmpNumber)) continue;
                                tmpPos = ((String)selectedFormulaPos.get(tmpFormula2)).split(",");
                                if (!StringUtils.isEmpty((String)exp) && !exp.startsWith("=")) {
                                    exp = "=" + exp;
                                }
                                sheet.getCell(Integer.parseInt(tmpPos[0]), Integer.parseInt(tmpPos[1]), true).setFormula(exp);
                            }
                            continue;
                        }
                        for (String tmpFormula2 : selectedFormulaPos.keySet()) {
                            tmpParams = BgNFSHelper.parseFormulaPara(null, tmpFormula2);
                            if (!tmpParams[0].equals(tmpNumber)) continue;
                            transFormedExp = BgItemHelper.transformSumFormula((String)exp, (String)tmpFormula2, (Map)allFormulaPos);
                            if (!StringUtils.isEmpty((String)transFormedExp) && !transFormedExp.startsWith("=")) {
                                transFormedExp = "=" + transFormedExp;
                            }
                            tmpPos = ((String)selectedFormulaPos.get(tmpFormula2)).split(",");
                            sheet.getCell(Integer.parseInt(tmpPos[0]), Integer.parseInt(tmpPos[1]), true).setFormula(transFormedExp);
                        }
                    }
                    break block28;
                }
                if (!this.formulaType.equals("bgActual")) break block29;
                for (BgItemInfo info2 : bgItemCollection) {
                    tmpNumber = info2.getNumber();
                    exp = info2.getAcctInit() == null ? "" : info2.getAcctInit();
                    for (String tmpFormula2 : selectedFormulaPos.keySet()) {
                        tmpParams = BgNFSHelper.parseFormulaPara(null, tmpFormula2);
                        if (!tmpParams[0].equals(tmpNumber)) continue;
                        tmpPos = ((String)selectedFormulaPos.get(tmpFormula2)).split(",");
                        if (!StringUtils.isEmpty((String)exp) && !exp.startsWith("=")) {
                            exp = "=" + exp;
                        }
                        sheet.getCell(Integer.parseInt(tmpPos[0]), Integer.parseInt(tmpPos[1]), true).setFormula(exp);
                    }
                }
                break block28;
            }
            if (!this.formulaType.equals("bgActualAdd")) break block28;
            for (BgItemInfo info2 : bgItemCollection) {
                tmpNumber = info2.getNumber();
                exp = info2.getAcctMaintain() == null ? "" : info2.getAcctMaintain();
                for (String tmpFormula2 : selectedFormulaPos.keySet()) {
                    tmpParams = BgNFSHelper.parseFormulaPara(null, tmpFormula2);
                    if (!tmpParams[0].equals(tmpNumber)) continue;
                    tmpPos = ((String)selectedFormulaPos.get(tmpFormula2)).split(",");
                    if (!StringUtils.isEmpty((String)exp) && !exp.startsWith("=")) {
                        exp = "=" + exp;
                    }
                    sheet.getCell(Integer.parseInt(tmpPos[0]), Integer.parseInt(tmpPos[1]), true).setFormula(exp);
                }
            }
        }
    }

    @Override
    public void actionProperty_actionPerformed(ActionEvent e) throws Exception {
        super.actionProperty_actionPerformed(e);
        String id = this.getBookProvider().getEditValue().get("id").toString();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id);
        uiContext.put((Object)"ORGUNIT_INFO", this.getUIContext().get("ORGUNIT_INFO"));
        uiContext.put((Object)"ORGUNIT_CU", this.getUIContext().get("ORGUNIT_CU"));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgNActualRecordEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    protected String getHideUnHidePermItem() {
        return "bg_actralRecord_hide_unhide";
    }

    @Override
    public String getTemplateId() {
        if (this.getBgFormInfo() != null && this.getBgFormInfo().getBgTemplate() != null && this.getBgFormInfo().getBgTemplate().getId() != null) {
            return this.getBgFormInfo().getBgTemplate().getId().toString();
        }
        return null;
    }

    private SelectorItemCollection getBgMeasureUnitSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bgMeasureUnit.id");
        sic.add("bgMeasureUnit.bgElement.id");
        sic.add("bgMeasureUnit.bgElement.name");
        sic.add("bgMeasureUnit.bgElement.number");
        sic.add("bgMeasureUnit.measureUnit.id");
        sic.add("bgMeasureUnit.measureUnit.name");
        sic.add("bgMeasureUnit.measureUnit.number");
        sic.add("bgMeasureUnit.measureUnit.coefficient");
        return sic;
    }

    @Override
    protected void initMeasureUnitInfo() throws Exception {
        BgActualRecordInfo bgactualRecordInfo = (BgActualRecordInfo)this.getBookProvider().getEditValue();
        BgFormInfo bgformInfo = null;
        try {
            bgformInfo = BgFormFactory.getRemoteInstance().getBgFormInfo((IObjectPK)new ObjectUuidPK(bgactualRecordInfo.getBgForm().getId().toString()), this.getBgMeasureUnitSelectors());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setMeasureUnitMap(BgNFSHelper.getMeasureUnitMap(bgformInfo));
        if (this.getMeasureUnitMap() == null) {
            this.setMeasureUnitMap(new HashMap());
        }
        this.getSYSTEMINFO_DATA().add(this.getMeasureUnitMap());
    }

    @Override
    public IReportPropertyAdapter getBudgetPropertyAdapter() {
        return new BgActualRecordPropertyAdapter();
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed2(e);
    }

    @Override
    protected BigDecimal getMeasureUnitCoefficient() {
        BigDecimal _coefficient = this.getActualRecordInfo().getMeasureUnit() != null ? this.getActualRecordInfo().getMeasureUnit().getCoefficient() : BgNConstants.ONE;
        return _coefficient;
    }
}

