/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.eas.ma.budget.BgAdjustDiversityData;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.client.BgAdjustBillEditUI;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFormProcessUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Action;

public class BgNAdjustFormProcessUI
extends BgNFormProcessUI {
    private static final long serialVersionUID = 5467127036835445194L;
    protected BgAdjustBillEditUI processUI = null;
    protected Map adjustCtrlMap = null;

    @Override
    public void onLoad() throws Exception {
        this.setCtrlEnumerate(true);
        super.onLoad();
        this.initToolbarActions();
    }

    @Override
    protected void showAllBook() throws Exception {
        Book book = this.getBook();
        BgNFSHelper.disableCal(book);
        BgNFSHelper.disableUndo(book);
        super.showAllBook();
    }

    @Override
    protected void showAllSheet(Sheet sheet) throws Exception {
        super.showAllSheet(sheet);
        BgNFSHelper.setLockOfSheet(sheet, true);
    }

    @Override
    protected void cell_Selection_Changed(SheetChangeEvent e) throws Exception {
    }

    @Override
    protected void init() throws Exception {
        super.init();
        if (this.getUIContext().get("Owner") != null) {
            this.processUI = (BgAdjustBillEditUI)this.getUIContext().get("Owner");
        }
    }

    @Override
    protected void initSystemInfo() throws Exception {
        super.initSystemInfo();
        this.setAdjustMap(new LinkedHashMap());
        this.setAdjustCtrlMap(new LinkedHashMap());
        this.getSYSTEMINFO_DATA().add(this.getAdjustMap());
        this.getSYSTEMINFO_DATA().add(this.getAdjustCtrlMap());
    }

    protected void initToolbarActions() {
        ToolBarManager toolBarManager = this.getSpreadManager().getSpreadContainer().getToolBarManager();
        toolBarManager.getToolBar("style").hide();
        toolBarManager.getToolBar("common").removeAllToolBarComponents();
        this.actionRefer.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        toolBarManager.getToolBar("common").add((Action)((Object)this.actionRefer));
        Object obj = this.getUIContext().get("isAuditState");
        boolean isAuditState = false;
        if (obj != null && obj instanceof Boolean) {
            isAuditState = (Boolean)obj;
        }
        this.actionRefer.setVisible(!isAuditState);
        this.actionRefer.setEnabled(!isAuditState);
        this.actionExport.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_output"));
        toolBarManager.getToolBar("common").add((Action)this.actionExport);
        this.actionExport.setVisible(true);
        this.actionExport.setEnabled(true);
    }

    @Override
    public void actionRefer_actionPerformed(ActionEvent e) throws Exception {
        if (this.processUI != null) {
            Sheet.ICellsIterator iterator;
            int i;
            Cell cell = null;
            String formulaString = null;
            String[] parameter = null;
            BgAdjustDiversityData divData = null;
            CellBlock block = null;
            Sheet sheet = this.getBook().getActiveSheet();
            Range range = sheet.getSelectionRange();
            boolean hasItem = false;
            int n = range.size();
            block2: for (i = 0; i < n; ++i) {
                block = (CellBlock)range.getAt(i);
                iterator = sheet.getCellsIterator(block, false, false);
                while (iterator.hasNext()) {
                    cell = iterator.next();
                    if (!BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                    hasItem = true;
                    continue block2;
                }
            }
            if (!hasItem) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgAdjustBillResource", (String)"noItemError"));
                SysUtil.abort();
            }
            n = range.size();
            for (i = 0; i < n; ++i) {
                block = (CellBlock)range.getAt(i);
                iterator = sheet.getCellsIterator(block, false, false);
                while (iterator.hasNext()) {
                    cell = iterator.next();
                    if (!BgNFSHelper.checkHasFormulaOfCell(cell) || (formulaString = BgNFSHelper.getFormulaOfCell(cell)) == null || formulaString.trim().length() <= 0) continue;
                    parameter = BgNFSHelper.parseFormulaPara(this.getFormulaMap(), formulaString);
                    divData = new BgAdjustDiversityData();
                    divData.setFormula(formulaString);
                    if (cell.getValue() != null && cell.getValue().toString().trim().length() > 0) {
                        divData.setNewValue(new BigDecimal(cell.getValue().toString().trim()));
                    } else {
                        divData.setNewValue(BgConstants.BIGZERO);
                    }
                    divData.setParameter(parameter);
                    this.getAdjustMap().put(formulaString, divData);
                    LinkedHashMap tmp = new LinkedHashMap();
                    this.setCtrlMap(cell, tmp);
                    this.adjustCtrlMap.put(formulaString, tmp);
                }
            }
            this.processUI.setReportInfo((BgFormInfo)this.getEditData());
            this.processUI.setAdjustInfo(this.getAdjustMap());
            this.processUI.setAdjustCtrlMap((HashMap)((LinkedHashMap)this.getAdjustCtrlMap()));
            this.processUI.updateAdjustMapInfo();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgAdjustBillResource", (String)"submitAdjustInfo"));
        }
    }

    private void setCtrlMap(Cell cell, HashMap map) {
        Boolean isCtrl = BgNFSHelper.getItemFormula(cell).getExt("isCtrl") == null ? Boolean.FALSE : new Boolean(BgNFSHelper.getItemFormula(cell).getExt("isCtrl").toString());
        Boolean isFlexCtrl = BgNFSHelper.getItemFormula(cell).getExt("isFlexCtrl") == null ? Boolean.FALSE : new Boolean(BgNFSHelper.getItemFormula(cell).getExt("isFlexCtrl").toString());
        BigDecimal flexCtrlParam = BgNFSHelper.getItemFormula(cell).getExt("flexCtrlParam") == null ? new BigDecimal("1.00") : new BigDecimal(BgNFSHelper.getItemFormula(cell).getExt("flexCtrlParam").toString());
        Integer periodCtrlPolicy = BgNFSHelper.getItemFormula(cell).getExt("periodCtrlPolicy") == null ? new Integer(-1) : new Integer(BgNFSHelper.getItemFormula(cell).getExt("periodCtrlPolicy").toString());
        Boolean isGroupCtrl = BgNFSHelper.getItemFormula(cell).getExt("isGroupCtrl") == null ? Boolean.FALSE : new Boolean(BgNFSHelper.getItemFormula(cell).getExt("isGroupCtrl").toString());
        Integer groupNo = new Integer(-1);
        if (BgNFSHelper.getItemFormula(cell).getExt("groupCtrlNo") != null) {
            try {
                groupNo = new Integer(BgNFSHelper.getItemFormula(cell).getExt("groupCtrlNo").toString());
            }
            catch (NumberFormatException e) {
                groupNo = new Integer(-1);
            }
        }
        Boolean isAllowAccess = BgNFSHelper.getItemFormula(cell).getExt("isAllowAccess") == null ? Boolean.TRUE : new Boolean(BgNFSHelper.getItemFormula(cell).getExt("isAllowAccess").toString());
        map.put("isCtrl", isCtrl);
        map.put("isFlexCtrl", isFlexCtrl);
        map.put("flexCtrlParam", flexCtrlParam);
        map.put("periodCtrlPolicy", periodCtrlPolicy);
        map.put("isGroupCtrl", isGroupCtrl);
        map.put("groupCtrlNo", groupNo);
        map.put("isAllowAccess", isAllowAccess);
        if (this.getBgFormInfo() != null && this.getBgFormInfo().getBgTemplate() != null && this.getBgFormInfo().getBgTemplate().getId() != null) {
            map.put("BGTEMPLATE_ID", this.getBgFormInfo().getBgTemplate().getId().toString());
        }
    }

    public Map getAdjustCtrlMap() {
        return this.adjustCtrlMap;
    }

    public void setAdjustCtrlMap(Map adjustCtrlMap) {
        this.adjustCtrlMap = adjustCtrlMap;
    }

    @Override
    public boolean isCtrlEnumerate() {
        return true;
    }
}

