/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.ma.budget.BgAnalyseFilterParam;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgItemObject;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.budget.client.NewBgItemDialog;
import com.kingdee.eas.ma.nbudget.BgFlexibleFilterParam;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgNAnalyseFlexibleFilterUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class BgNAnalyseFlexibleFilterUI
extends AbstractBgNAnalyseFlexibleFilterUI {
    private static final long serialVersionUID = -8392411108767943845L;
    private static final Logger logger = CoreUIObject.getLogger(BgNAnalyseFlexibleFilterUI.class);
    public static final String CURR_ORGUNIT_ID = "curr_orgunit_id";
    public static final String BGSCHEME_ID = "bgscheme_id";
    public static final String BGPERIOD_ID = "period_id";
    public static final String CURRENCY_ID = "currency_id";
    public static final String BGITEM_NUMBER = "bgitem_number";
    private static final String BGELEMNET_MEASUREUNIT_IDS = "BGELEMNET_MEASUREUNIT_IDS";
    private static final String ELEMENT_COLUMN = "colElement";
    private static final String MEASURE_UNIT_COLUMN = "colMeasureUnit";
    private OrgUnitInfo currOrgUnit = SysContext.getSysContext().getCurrentOrgUnit();
    private CurrencyInfo currencyInfo = null;

    protected CurrencyInfo getCurrencyInfo() {
        return this.currencyInfo;
    }

    protected void setCurrencyInfo(CurrencyInfo currencyInfo) {
        this.currencyInfo = currencyInfo;
    }

    public OrgUnitInfo getCurrOrgUnit() {
        return this.currOrgUnit;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.prmtOrgUnit.setEditable(false);
        this.prmtOrgUnit.setEnabled(false);
        this.tblMain.checkParsed();
        this.initFilter();
        this.init();
    }

    protected void init() throws Exception {
        this.tblMain.setRefresh(false);
        this.tblMain.reLayoutAndPaint();
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        prmtSelect.setQueryInfo("com.kingdee.eas.ma.budget.F7BgElementQuery");
        prmtSelect.setVisible(true);
        prmtSelect.setEditable(false);
        prmtSelect.setEnabledMultiSelection(true);
        prmtSelect.setEditFormat("$number$");
        prmtSelect.setDisplayFormat("$name$");
        this.tblMain.getColumn(ELEMENT_COLUMN).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
        EntityViewInfo muView = new EntityViewInfo();
        FilterInfo muFilter = new FilterInfo();
        muFilter.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        muView.setFilter(muFilter);
        muView.getSorter().add(new SorterItemInfo("coefficient"));
        MeasureUnitInfo muInfo2 = null;
        MeasureUnitCollection muCol = null;
        KDTDefaultCellEditor editor = null;
        KDComboBox comboBox = new KDComboBox();
        DefaultComboBoxModel<MeasureUnitInfo> model = new DefaultComboBoxModel<MeasureUnitInfo>();
        try {
            muCol = this.getMeasureUnitInterface().getMeasureUnitCollection(muView);
            if (muCol != null && !muCol.isEmpty()) {
                for (MeasureUnitInfo muInfo2 : muCol) {
                    model.addElement(muInfo2);
                }
            }
            comboBox.setModel(model);
            editor = new KDTDefaultCellEditor((JComboBox)comboBox);
            this.tblMain.getColumn(MEASURE_UNIT_COLUMN).setEditor((ICellEditor)editor);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
    }

    protected void initFilter() throws Exception {
        this.initBgScheme();
        this.initSelectBgItem();
        this.initBgPeriod();
        this.initCurrency();
    }

    protected void initBgPeriod() {
        BgPeriodDialog bgPeriodDialog = new BgPeriodDialog((CoreUIObject)this);
        this.prmtBgPeriod.setSelector((KDPromptSelector)bgPeriodDialog);
        this.prmtBgPeriod.setEditable(false);
    }

    protected void initSelectBgItem() throws Exception {
        NewBgItemDialog bgItemSelect = new NewBgItemDialog((IUIObject)this);
        bgItemSelect.setMulSelect(true);
        bgItemSelect.setSelectCombinItem(false);
        this.prmtBgItem.setSelector((KDPromptSelector)bgItemSelect);
        this.prmtBgItem.setEditable(false);
    }

    protected void initCurrency() throws Exception {
        CurrencyInfo currencyInfo = null;
        OrgUnitInfo unitInfo = this.getCurrOrgUnit();
        BgNFCHelper.setCurrency(this.combCurrency, null, false);
        if (unitInfo != null) {
            currencyInfo = BgNFCHelper.getBaseCurrency(unitInfo.getId());
            BgNFCHelper.setSelectObject(this.combCurrency, currencyInfo);
            this.setCurrencyInfo(currencyInfo);
        }
        if (this.ui != null) {
            Method method = null;
            try {
                BgAnalyseFilterParam filterParam;
                method = this.ui.getClass().getMethod("getFilterParam", null);
                if (method != null && (filterParam = (BgAnalyseFilterParam)method.invoke(this.ui, null)) != null) {
                    BgAnalyseHelper.setSelectObject((KDComboBox)this.combCurrency, (Object)filterParam.getCurrency());
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }

    protected void initBgScheme() {
        if (this.ui != null) {
            Method method = null;
            try {
                BgFlexibleFilterParam filterParam;
                method = this.ui.getClass().getMethod("getFilterParam", null);
                if (method != null && (filterParam = (BgFlexibleFilterParam)method.invoke(this.ui, null)) != null) {
                    this.prmtBgScheme.setValue((Object)filterParam.getBgScheme());
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }

    protected IMeasureUnit getMeasureUnitInterface() throws Exception {
        return MeasureUnitFactory.getRemoteInstance();
    }

    @Override
    protected void btnAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddLine_actionPerformed(e);
        this.tblMain.addRow();
    }

    @Override
    protected void btnRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.removeRow(this.tblMain.getSelectManager().getActiveRowIndex());
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (ELEMENT_COLUMN.equalsIgnoreCase(this.tblMain.getColumnKey(colIndex))) {
            KDTRange range = this.tblMain.getSelectManager().toRange();
            KDTSelectBlock block = (KDTSelectBlock)range.get(0);
            int firstInsertRow = block.getBeginRow();
            Object object = this.tblMain.getCell(rowIndex, colIndex).getValue();
            if (object instanceof Object[]) {
                int i;
                Object[] result = (Object[])object;
                int size = result.length;
                int maxRow = this.tblMain.getRowCount();
                int leftRow = maxRow - (firstInsertRow + 1);
                if (size > leftRow) {
                    for (i = leftRow; i < size - 1; ++i) {
                        this.tblMain.addRow();
                    }
                }
                int length = result.length;
                for (i = 0; i < length; ++i) {
                    BgElementInfo info = (BgElementInfo)result[i];
                    this.tblMain.getCell(firstInsertRow, ELEMENT_COLUMN).setValue((Object)info);
                    ++firstInsertRow;
                }
            }
        }
    }

    public String getUITitle() {
        return this.resHelper.getString("this.title");
    }

    public boolean verify() {
        boolean re = super.verify();
        if (re) {
            Object obj = this.prmtOrgUnit.getData();
            if (obj == null || obj instanceof String) {
                this.prmtOrgUnit.requestFocus();
                MsgBox.showWarning((String)BgAnalyseHelper.getMessage((String)"selectOrgUnit"));
                return false;
            }
            if (!(this.prmtBgScheme.getValue() instanceof BgSchemeInfo)) {
                this.prmtBgScheme.requestFocus();
                MsgBox.showWarning((String)BgAnalyseHelper.getMessage((String)"selectBgScheme"));
                return false;
            }
            if (!(this.prmtBgItem.getData() instanceof BgItemObject)) {
                this.prmtBgItem.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgAnalyseHelper.getMessage((String)"selectBgItem"));
                return false;
            }
            if (!(this.prmtBgPeriod.getData() instanceof BgPeriodInfo)) {
                this.prmtBgPeriod.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgAnalyseHelper.getMessage((String)"selectBgPeriod"));
                return false;
            }
            if (this.combCurrency.getSelectedItem() == null) {
                this.combCurrency.requestFocus();
                MsgBox.showWarning((String)BgAnalyseHelper.getMessage((String)"selectCurrency"));
                return false;
            }
            if (this.tblMain.getRowCount() > 0) {
                int i;
                HashSet<String> verifySet = new HashSet<String>();
                int size = 0;
                ArrayList<Integer> rowList = new ArrayList<Integer>();
                int rowCount = this.tblMain.getRowCount();
                for (i = 0; i < rowCount; ++i) {
                    ICell elementCell = this.tblMain.getCell(i, ELEMENT_COLUMN);
                    ICell measureUnitCell = this.tblMain.getCell(i, MEASURE_UNIT_COLUMN);
                    if (elementCell.getValue() == null && measureUnitCell.getValue() == null) {
                        rowList.add(new Integer(i));
                        continue;
                    }
                    if (elementCell.getValue() == null) {
                        MsgBox.showWarning((String)BgAnalyseHelper.getMessage((String)"elementIsNull"));
                        return false;
                    }
                    if (measureUnitCell.getValue() == null) {
                        MsgBox.showWarning((String)BgAnalyseHelper.getMessage((String)"measureUnitIsNull"));
                        return false;
                    }
                    String elementNumber = ((BgElementInfo)elementCell.getValue()).getNumber();
                    verifySet.add(elementNumber);
                    ++size;
                }
                for (i = rowList.size() - 1; i >= 0; --i) {
                    int rowIndex = (Integer)rowList.get(i);
                    this.tblMain.removeRow(rowIndex);
                }
                if (verifySet.size() < size) {
                    MsgBox.showWarning((String)BgAnalyseHelper.getMessage((String)"elementIsRepeat"));
                    return false;
                }
            }
        }
        return re;
    }

    public void clear() {
        super.clear();
        this.prmtOrgUnit.setData((Object)this.getCurrOrgUnit());
        this.prmtBgScheme.setData(null);
        this.prmtBgItem.setData(null);
        this.prmtBgPeriod.setData(null);
        if (this.combCurrency.getItemCount() > 0) {
            CurrencyInfo currencyInfo = this.getCurrencyInfo();
            if (currencyInfo != null) {
                BgNFCHelper.setSelectObject(this.combCurrency, currencyInfo);
            } else {
                this.combCurrency.setSelectedIndex(0);
            }
        }
        this.tblMain.removeRows();
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtOrgUnit_dataChanged(e);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.prmtOrgUnit.getData() instanceof FullOrgUnitInfo) {
            FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)this.prmtOrgUnit.getData();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
            if (BgParamCHelper.isFodian()) {
                filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(4), CompareType.NOTEQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(-1), CompareType.NOTEQUALS));
            }
            filter.setMaskString("#0 and #1");
            if (BgSHelper.isBgPermissionUsed()) {
                String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                HashSet<String> orgSet = new HashSet<String>();
                orgSet.add(orgUnitInfo.getId().toString());
                filter = BgPermissionHelper.addBgSchemePermission(userId, orgSet, filter);
            }
        } else {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)"000000000000000000000000000=", CompareType.EQUALS));
        }
        view.setFilter(filter);
        this.prmtBgScheme.setEntityViewInfo(view);
    }

    protected FilterParam createNewFilterParam() {
        return new BgFlexibleFilterParam();
    }

    protected FilterParam getFilterParam(FilterParam mainParam, FilterParam filterParam) {
        if (mainParam == null) {
            mainParam = this.createNewFilterParam();
        }
        BgFlexibleFilterParam _mainParam = null;
        BgFlexibleFilterParam _filterParam = null;
        if (mainParam != null && filterParam != null) {
            _mainParam = (BgFlexibleFilterParam)mainParam;
            _filterParam = (BgFlexibleFilterParam)filterParam;
            if (_filterParam != null && _filterParam.getCurrOrgUnit() != null) {
                _mainParam.setCurrOrgUnit(_filterParam.getCurrOrgUnit());
            } else {
                _mainParam.setCurrOrgUnit(null);
            }
            if (_filterParam != null && _filterParam.getBgScheme() != null) {
                _mainParam.setBgScheme(_filterParam.getBgScheme());
            } else {
                _mainParam.setBgScheme(null);
            }
            if (_filterParam != null && _filterParam.getBgPeriod() != null) {
                _mainParam.setBgPeriod(_filterParam.getBgPeriod());
            } else {
                _mainParam.setBgPeriod(null);
            }
            if (_filterParam != null && _filterParam.getCurrency() != null) {
                _mainParam.setCurrency(_filterParam.getCurrency());
            } else {
                _mainParam.setCurrency(null);
            }
            if (_filterParam != null && _filterParam.getBgItems() != null) {
                _mainParam.setBgItems(_filterParam.getBgItems());
            } else {
                _mainParam.setBgItems(null);
            }
            if (_filterParam.getElementMap() != null) {
                _mainParam.setElementMap(_filterParam.getElementMap());
            } else {
                _mainParam.setElementMap(null);
            }
        }
        return _mainParam;
    }

    protected void setFilterParam(FilterParam filterParam) {
        super.setFilterParam(filterParam);
        if (filterParam instanceof BgFlexibleFilterParam) {
            BgFlexibleFilterParam _filterParam = (BgFlexibleFilterParam)filterParam;
            _filterParam.setCurrOrgUnit(this.getCurrOrgUnit());
            _filterParam.setBgScheme((BgSchemeInfo)this.prmtBgScheme.getValue());
            if (this.prmtBgPeriod.getData() != null) {
                _filterParam.setBgPeriod((BgPeriodInfo)this.prmtBgPeriod.getData());
            } else {
                _filterParam.setBgPeriod(null);
            }
            if (this.combCurrency.getSelectedItem() != null) {
                _filterParam.setCurrency((CurrencyInfo)this.combCurrency.getSelectedItem());
            } else {
                _filterParam.setCurrency(null);
            }
            if (this.prmtBgItem.getData() instanceof BgItemObject) {
                _filterParam.setBgItems((BgItemObject)this.prmtBgItem.getData());
            } else {
                _filterParam.setBgItems(null);
            }
            HashMap<Object, Object> elementMap = new HashMap<Object, Object>();
            if (this.tblMain.getRowCount() > 0) {
                ICell elementCell = null;
                ICell measureUnitCell = null;
                int rowCount = this.tblMain.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    elementCell = this.tblMain.getCell(i, ELEMENT_COLUMN);
                    measureUnitCell = this.tblMain.getCell(i, MEASURE_UNIT_COLUMN);
                    elementMap.put(elementCell.getValue(), measureUnitCell.getValue());
                }
            }
            _filterParam.setElementMap(elementMap);
        }
    }

    protected void getFilterParam(FilterParam filterParam) {
        super.getFilterParam(filterParam);
        if (filterParam instanceof BgFlexibleFilterParam) {
            BgFlexibleFilterParam _filterParam = (BgFlexibleFilterParam)filterParam;
            this.getFilterParamBefore(_filterParam);
            if (_filterParam.getCurrOrgUnit() != null) {
                this.prmtOrgUnit.setData((Object)_filterParam.getCurrOrgUnit());
            } else {
                this.prmtOrgUnit.setData(null);
            }
            this.prmtBgScheme.setData((Object)_filterParam.getBgScheme());
            if (_filterParam.getBgPeriod() != null) {
                this.prmtBgPeriod.setData((Object)_filterParam.getBgPeriod());
            } else {
                this.prmtBgPeriod.setData(null);
            }
            if (_filterParam.getCurrency() != null) {
                BgAnalyseHelper.setSelectObject((KDComboBox)this.combCurrency, (Object)_filterParam.getCurrency());
            }
            if (_filterParam.getBgItems() != null) {
                this.prmtBgItem.setData((Object)_filterParam.getBgItems());
            } else {
                this.prmtBgItem.setData(null);
            }
            this.tblMain.removeRows();
            if (_filterParam.getElementMap() != null && !_filterParam.getElementMap().isEmpty()) {
                Map.Entry _entry2 = null;
                IRow _row = null;
                for (Map.Entry _entry2 : _filterParam.getElementMap().entrySet()) {
                    _row = this.tblMain.addRow();
                    _row.getCell(ELEMENT_COLUMN).setValue(_entry2.getKey());
                    _row.getCell(MEASURE_UNIT_COLUMN).setValue(_entry2.getValue());
                }
            }
        }
    }

    protected void getFilterParamBefore(FilterParam filterParam) {
    }

    protected void loadCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.loadCustomerParams(cp, filterParam);
        if (cp == null || !(filterParam instanceof BgFlexibleFilterParam)) {
            return;
        }
        String id = null;
        Object ids = null;
        BgFlexibleFilterParam _filterParam = (BgFlexibleFilterParam)filterParam;
        try {
            id = cp.getCustomerParam(CURR_ORGUNIT_ID);
            if (!StringUtils.isEmpty((String)id)) {
                _filterParam.setCurrOrgUnit(new OrgUnitInfo());
                _filterParam.getCurrOrgUnit().setId(BOSUuid.read((String)id));
            } else {
                _filterParam.setCurrOrgUnit(null);
            }
            id = cp.getCustomerParam(BGSCHEME_ID);
            if (!StringUtils.isEmpty((String)id)) {
                _filterParam.setBgScheme(new BgSchemeInfo());
                _filterParam.getBgScheme().setId(BOSUuid.read((String)id));
            } else {
                _filterParam.setBgScheme(null);
            }
            id = cp.getCustomerParam(BGPERIOD_ID);
            if (!StringUtils.isEmpty((String)id)) {
                _filterParam.setBgPeriod(new BgPeriodInfo());
                _filterParam.getBgPeriod().setId(BOSUuid.read((String)id));
            } else {
                _filterParam.setBgPeriod(null);
            }
            id = cp.getCustomerParam(CURRENCY_ID);
            if (!StringUtils.isEmpty((String)id)) {
                _filterParam.setCurrency(new CurrencyInfo());
                _filterParam.getCurrency().setId(BOSUuid.read((String)id));
            } else {
                _filterParam.setCurrency(null);
            }
            String numbers = cp.getCustomerParam(BGITEM_NUMBER);
            if (!StringUtils.isEmpty((String)numbers)) {
                _filterParam.setBgItemNumbers(numbers);
            } else {
                _filterParam.setBgItems(null);
            }
            Map tmpMap = (Map)BgAnalyseHelper.getObject((byte[])BgAnalyseHelper.decode((String)cp.getCustomerParam(BGELEMNET_MEASUREUNIT_IDS)));
            if (tmpMap != null) {
                _filterParam.setElementMap(new HashMap());
                _filterParam.getElementMap().putAll(tmpMap);
            } else {
                _filterParam.setElementMap(null);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            this.handUIException(ex);
        }
    }

    protected void saveCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.saveCustomerParams(cp, filterParam);
        if (cp == null || !(filterParam instanceof BgFlexibleFilterParam)) {
            return;
        }
        Object tmpList = null;
        Object _unitInfo = null;
        BgFlexibleFilterParam _filterParam = (BgFlexibleFilterParam)filterParam;
        if (_filterParam.getCurrOrgUnit() != null) {
            cp.addCustomerParam(CURR_ORGUNIT_ID, _filterParam.getCurrOrgUnit().getId().toString());
        } else {
            cp.removeCustomerParam(CURR_ORGUNIT_ID);
        }
        if (_filterParam.getBgScheme() != null) {
            cp.addCustomerParam(BGSCHEME_ID, _filterParam.getBgScheme().getId().toString());
        } else {
            cp.removeCustomerParam(BGSCHEME_ID);
        }
        if (_filterParam.getBgPeriod() != null) {
            cp.addCustomerParam(BGPERIOD_ID, _filterParam.getBgPeriod().getId().toString());
        } else {
            cp.removeCustomerParam(BGPERIOD_ID);
        }
        if (_filterParam.getCurrency() != null) {
            cp.addCustomerParam(CURRENCY_ID, _filterParam.getCurrency().getId().toString());
        } else {
            cp.removeCustomerParam(CURRENCY_ID);
        }
        if (_filterParam.getBgItems() != null) {
            cp.addCustomerParam(BGITEM_NUMBER, _filterParam.getBgItemNumbers());
        } else {
            cp.removeCustomerParam(BGITEM_NUMBER);
        }
        if (_filterParam.getElementMap() != null) {
            BgElementInfo _bgElementInfo = null;
            MeasureUnitInfo _measureUnitInfo = null;
            Map.Entry _entry2 = null;
            HashMap<String, String> tmpMap = new HashMap<String, String>();
            for (Map.Entry _entry2 : _filterParam.getElementMap().entrySet()) {
                _bgElementInfo = (BgElementInfo)_entry2.getKey();
                _measureUnitInfo = (MeasureUnitInfo)_entry2.getValue();
                tmpMap.put(_bgElementInfo.getId().toString(), _measureUnitInfo.getId().toString());
            }
            if (!tmpMap.isEmpty()) {
                cp.addCustomerParam(BGELEMNET_MEASUREUNIT_IDS, BgAnalyseHelper.encode((byte[])BgAnalyseHelper.getBytes(tmpMap)));
            } else {
                cp.removeCustomerParam(BGELEMNET_MEASUREUNIT_IDS);
            }
        } else {
            cp.removeCustomerParam(BGELEMNET_MEASUREUNIT_IDS);
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            if (request == null) {
                request = new RequestContext();
                request.setClassName(this.getUIHandlerClassName());
                handler.setRequestContext((Serializable)request);
            }
            request.put("ORGUNIT_ID", (Object)this.getCurrOrgUnit().getId().toString());
        }
        return handler;
    }
}

