/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.ma.budget.BgAdjustBillEntryCollection;
import com.kingdee.eas.ma.budget.BgAdjustBillEntryInfo;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.client.BgAnalyseFilterBaseUI;
import com.kingdee.eas.ma.nbudget.BgFlexibleFilterParam;
import com.kingdee.eas.ma.nbudget.BgNAnalyseFacadeFactory;
import com.kingdee.eas.ma.nbudget.client.AbstractBgNAnalyseFlexibleMainUI;
import com.kingdee.eas.ma.nbudget.client.BgNAnalyseFlexibleFilterUI;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgNAnalyseFlexibleMainUI
extends AbstractBgNAnalyseFlexibleMainUI {
    private static final long serialVersionUID = -7761623136353522840L;
    private static final Logger logger = CoreUIObject.getLogger(BgNAnalyseFlexibleMainUI.class);
    private BgNAnalyseFlexibleFilterUI filterUI;
    private static final String FLEXIBLE_ITEM_COL = "flexiblItem";
    private static final String REQ_ORG_COL = "reqOrg";
    private static final String REQ_ITEM_COL = "reqItem";
    private static final String REQ_PERIOD_COL = "reqPeriod";
    private static final String REQ_AMOUNT_COL = "reqAmount";
    private int reqAmountIndex = 4;

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.setEditable(false);
        this.reqAmountIndex = this.tblMain.getColumnIndex(REQ_AMOUNT_COL);
        super.onLoad();
        this.actionExport.setVisible(false);
    }

    public BgAnalyseFilterBaseUI getFilterUI() {
        try {
            if (this.filterUI == null) {
                this.filterUI = new BgNAnalyseFlexibleFilterUI();
            }
        }
        catch (Exception e) {
            logger.error((Object)"getFilterUi:", (Throwable)e);
        }
        return this.filterUI;
    }

    protected int getWidthOfDialog() {
        return 300;
    }

    protected int getHeightOfDialog() {
        return 400;
    }

    public String getUITitle() {
        return this.resHelper.getString("this.title");
    }

    protected String getQueryMainName() {
        return BgNAnalyseFlexibleMainUI.class.getName();
    }

    protected void executeQuery() {
        if (this.defaultFilterParam instanceof BgFlexibleFilterParam) {
            BgFlexibleFilterParam filterParam = (BgFlexibleFilterParam)this.defaultFilterParam;
            this.clearData();
            this.TabPaneMain.setTitleAt(0, filterParam.getCurrOrgUnit().getName());
            Map flexibleData = null;
            try {
                flexibleData = BgNAnalyseFacadeFactory.getRemoteInstance().getFlexibleData(filterParam);
            }
            catch (Exception e) {
                logger.error((Object)"executeQuery", (Throwable)e);
                this.handUIException(e);
            }
            if (flexibleData != null && !flexibleData.isEmpty()) {
                HashMap<String, BigDecimal> elementParam = new HashMap<String, BigDecimal>();
                if (filterParam.getElementMap() != null && !filterParam.getElementMap().isEmpty()) {
                    for (Map.Entry e : filterParam.getElementMap().entrySet()) {
                        BgElementInfo ele = (BgElementInfo)e.getKey();
                        if (ele.getDataType().getValue() == 4 || ele.getDataType().getValue() == 5) continue;
                        elementParam.put(ele.getId().toString(), ((MeasureUnitInfo)e.getValue()).getCoefficient());
                    }
                }
                String flexItem2 = null;
                BgAdjustBillEntryCollection col = null;
                BgAdjustBillEntryInfo entry = null;
                IRow row = null;
                for (String flexItem2 : flexibleData.keySet()) {
                    col = (BgAdjustBillEntryCollection)flexibleData.get(flexItem2);
                    for (int i = 0; i < col.size(); ++i) {
                        entry = col.get(i);
                        row = this.tblMain.addRow();
                        row.getCell(FLEXIBLE_ITEM_COL).setValue((Object)flexItem2.substring(flexItem2.indexOf("_") + 1));
                        row.getCell(REQ_ORG_COL).setValue((Object)entry.getOrgUnit().getName());
                        row.getCell(REQ_ITEM_COL).setValue((Object)entry.getBgItemCmbName());
                        row.getCell(REQ_PERIOD_COL).setValue((Object)entry.getBgPeriod().getNumber());
                        BigDecimal num = entry.getAdjustPass();
                        int decimal = entry.getCurrency().getPrecision();
                        if (elementParam.containsKey(entry.getBgElement().getId().toString())) {
                            num = num.divide((BigDecimal)elementParam.get(entry.getBgElement().getId().toString()), decimal, 4);
                        }
                        row.getCell(REQ_AMOUNT_COL).setValue((Object)BgNationalFormatUIUtil.getDecimalFormat((int)decimal).format(num));
                    }
                }
            }
        }
    }

    protected void clearData() {
        this.TabPaneMain.setTitleAt(0, null);
        this.tblMain.removeRows();
    }
}

