/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDMultiLangArea;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.util.ParmCodingRule;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.ma.budget.client.BgOrgBasedListUI;
import com.kingdee.eas.ma.budget.client.ProgressUI;
import com.kingdee.eas.ma.budget.client.ReCalculateFilterUI;
import com.kingdee.eas.ma.nbudget.client.BgFormCourseListUI;
import com.kingdee.eas.ma.nbudget.client.BgNProcessUI;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.STConverter;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JViewport;
import org.apache.log4j.Logger;

public class BgNCHelper {
    private static final Logger logger = CoreUIObject.getLogger(BgNCHelper.class);

    public static void refreshListUI(CoreUI ui) {
        if (ui == null) {
            return;
        }
        Object listUI = null;
        if (ui instanceof EditUI || ui instanceof BgNProcessUI) {
            listUI = ui.getUIContext().get("Owner");
        } else if (ui instanceof ListUI) {
            listUI = ui;
        } else if (ui instanceof ProgressUI) {
            listUI = ((ReCalculateFilterUI)ui.getUIContext().get("Owner")).getUIContext().get("Owner");
        }
        if (listUI != null && listUI instanceof ListUI) {
            Container parent = ((ListUI)listUI).getParent();
            if (parent != null && parent instanceof JViewport && (parent = ((JViewport)parent).getParent()) != null && parent instanceof KDScrollPane) {
                parent = ((KDScrollPane)parent).getParent();
            }
            if (parent != null && parent instanceof KDTabbedPane) {
                KDTabbedPane tabb = (KDTabbedPane)parent;
                Component component = null;
                int n = tabb.getTabCount();
                for (int i = 0; i < n; ++i) {
                    component = tabb.getComponentAt(i);
                    if (component != null && component instanceof KDScrollPane) {
                        component = ((KDScrollPane)component).getComponent(0);
                    }
                    if (component != null && component instanceof JViewport) {
                        component = ((JViewport)component).getComponent(0);
                    }
                    if (!BgOrgBasedListUI.class.isAssignableFrom(component.getClass()) && !BgFormCourseListUI.class.isAssignableFrom(component.getClass())) continue;
                    try {
                        ((ListUI)component).refreshList();
                        continue;
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex);
                    }
                }
            }
        }
    }

    public static void initBgTxtNameStateAndValue(IObjectValue value, String properName, Component com, String orgid) throws EASBizException, BOSException {
        ICodingRuleManager icr = CodingRuleManagerFactory.getRemoteInstance();
        ParmCodingRule pcr = new ParmCodingRule();
        pcr.setCustomProperty(properName);
        KDTextField txtField = null;
        KDTextArea txtArea = null;
        KDMultiLangBox txtMulField = null;
        KDMultiLangArea txtMulArea = null;
        DataBaseInfo info = null;
        if (!icr.isExist(value, orgid, "sourceType", pcr)) {
            if (com instanceof KDTextField) {
                txtField = (KDTextField)com;
                txtField.setEnabled(true);
            } else if (com instanceof KDTextArea) {
                txtArea = (KDTextArea)com;
                txtArea.setEditable(true);
            } else if (com instanceof KDMultiLangBox) {
                txtMulField = (KDMultiLangBox)com;
                txtMulField.setEnabled(true);
            } else if (com instanceof KDMultiLangArea) {
                txtMulArea = (KDMultiLangArea)com;
                txtMulArea.setEditable(true);
            }
        } else {
            com.setEnabled(false);
            boolean isShowNumber = false;
            CodingRuleInfo codingRuleInfo = icr.getCodingRule(value, orgid, pcr);
            if (codingRuleInfo != null) {
                isShowNumber = codingRuleInfo.isIsAddView();
            }
            com.setEnabled(false);
            if (!isShowNumber) {
                return;
            }
            String number = icr.getNumber(value, null, pcr);
            if (com instanceof KDTextField) {
                txtField = (KDTextField)com;
                txtField.setText(number);
            } else if (com instanceof KDTextArea) {
                txtArea = (KDTextArea)com;
                txtArea.setText(number);
            } else if (com instanceof KDMultiLangBox) {
                if (value instanceof DataBaseInfo) {
                    info = (DataBaseInfo)value;
                    txtMulField = (KDMultiLangBox)com;
                    info.setName(STConverter.tc2sc((String)icr.getNumber((IObjectValue)info, null, pcr)), LocaleUtils.getLocale((String)"L2"));
                    info.setName(STConverter.sc2tc((String)icr.getNumber((IObjectValue)info, null, pcr)), LocaleUtils.getLocale((String)"L3"));
                    UIHelper.loadMultiLangFields((KDMultiLangBox)((KDMultiLangBox)com), (IObjectValue)info, (String)"name");
                }
            } else if (com instanceof KDMultiLangArea && value instanceof DataBaseInfo) {
                info = (DataBaseInfo)value;
                txtMulArea = (KDMultiLangArea)com;
                info.setName(STConverter.tc2sc((String)icr.getNumber((IObjectValue)info, null, pcr)), LocaleUtils.getLocale((String)"L2"));
                info.setName(STConverter.sc2tc((String)icr.getNumber((IObjectValue)info, null, pcr)), LocaleUtils.getLocale((String)"L3"));
                UIHelper.loadMultiLangFields((KDMultiLangBox)((KDMultiLangArea)com), (IObjectValue)info, (String)"name");
            }
        }
    }

    public static String getNameCode(IObjectValue value, String orgId, boolean hasSourceType, String fieldName) throws EASBizException, BOSException {
        String name = null;
        ICodingRuleManager icr = CodingRuleManagerFactory.getRemoteInstance();
        ParmCodingRule pcr = new ParmCodingRule();
        pcr.setCustomProperty(fieldName);
        name = icr.getNumber(value, orgId, "sourceType", fieldName);
        return name;
    }
}

