/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.io.kds.BookToKDSBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.CellActionAfterListener;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.BookDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgExamineFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgGatherHelper;
import com.kingdee.eas.ma.budget.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateFacadeFactory;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.IBgExamineFacade;
import com.kingdee.eas.ma.budget.VOComparator;
import com.kingdee.eas.ma.budget.client.BgExamineXInputUI;
import com.kingdee.eas.ma.budget.client.CtrlSetEditUI;
import com.kingdee.eas.ma.budget.client.NumberExpandInfo;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNFormException;
import com.kingdee.eas.ma.nbudget.BgNTemplateException;
import com.kingdee.eas.ma.nbudget.client.BgNFProcessUI;
import com.kingdee.eas.ma.nbudget.client.Excel2007FileFilter;
import com.kingdee.eas.ma.nbudget.client.ExcelFileFilter;
import com.kingdee.eas.ma.nbudget.client.utils.MeasureUnitCellActionAfterListener;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public final class BgNFCHelper {
    private static final Logger logger = CoreUIObject.getLogger(BgNFCHelper.class);
    public static final String SOURCE_STR = "com.kingdee.eas.ma.nbudget.client.BgNFormResource";
    public static final String SOURCE_OLD = "com.kingdee.eas.ma.budget.client.BgFormResource";
    public static final String SOURCE_ADJ = "com.kingdee.eas.ma.budget.client.BgFormAdjustResource";
    public static final String SOURCE_EXA = "com.kingdee.eas.ma.budget.client.BgExamineCheckResource";
    public static final String SOURCE_IE = "com.kingdee.eas.ma.nbudget.client.BgIEResource";
    public static final String SOURCE_REF = "com.kingdee.eas.ma.budget.client.BgSubmitBySchemeResource";
    public static final String SOURCE_COURSE = "com.kingdee.eas.ma.nbudget.client.BgFormCourseResource";
    public static final String SOURCE_CONFIG = "com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource";
    public static final String SOURCE_CSLFORM = "com.kingdee.eas.ma.nbudget.client.BgCslFormResource";
    public static final String SOURCE_SIM = "com.kingdee.eas.ma.nbudget.client.SimForecastFilterResource";

    public static String getMessageStr(String key) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)SOURCE_STR, (String)key) : "";
    }

    public static String getMessageStr(String sourceStr, String key) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)sourceStr, (String)key) : "";
    }

    public static void showWarning(Component comp, String msg) {
        MsgBox.showWarning((Component)comp, (String)msg);
        SysUtil.abort();
    }

    public static void setFocusTo(Component component) {
        if (component != null) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new FocusEvent(component, 1004));
        }
    }

    public static String getBgFormID(String orgUnitId, String formNumber) throws BOSException {
        String id = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("adjust.id"));
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)formNumber, CompareType.EQUALS));
        view.setFilter(filter);
        BgFormCollection coll = BgFormFactory.getRemoteInstance().getBgFormCollection(view);
        if (coll != null) {
            BgFormInfo info = null;
            for (int i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                if (info.getId() == null || info.getAdjust() == null || info.getAdjust().getId() == null || !info.getId().equals((Object)info.getAdjust().getId())) continue;
                id = info.getId().toString();
                break;
            }
        }
        return id;
    }

    public static void setCurrency(KDComboBox cbo, BOSUuid orgUnitId, boolean isSelBaseCurrency) {
        if (cbo == null) {
            return;
        }
        ICurrency iCurrency = null;
        CurrencyInfo currency = null;
        CurrencyCollection currencyCol = null;
        try {
            iCurrency = CurrencyFactory.getRemoteInstance();
            if (iCurrency == null) {
                return;
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)Boolean.TRUE, CompareType.EQUALS));
            view.setFilter(filter);
            currencyCol = iCurrency.getCurrencyCollection(view, true);
            BgNFCHelper.sortCollection((IObjectCollection)currencyCol, new String[]{"number"});
            cbo.removeAllItems();
            if (currencyCol != null && currencyCol.size() > 0) {
                cbo.addItems(currencyCol.toArray());
            }
            if (isSelBaseCurrency && orgUnitId != null) {
                currency = BgNFCHelper.getBaseCurrency(orgUnitId);
                if (currency != null) {
                    BgNFCHelper.setSelectObject(cbo, currency);
                } else {
                    cbo.setSelectedIndex(0);
                }
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
        }
        catch (EASBizException ex) {
            logger.error((Object)ex);
        }
    }

    public static CurrencyInfo getBaseCurrency(BOSUuid orgUnitId) {
        if (orgUnitId == null) {
            return null;
        }
        ObjectUuidPK pk = null;
        CurrencyInfo currency = null;
        IFullOrgUnit iFullOrgUnit = null;
        try {
            iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
            if (iFullOrgUnit == null) {
                return null;
            }
            pk = new ObjectUuidPK(orgUnitId);
            FullOrgUnitInfo orgUnitInfo = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)pk);
            currency = orgUnitInfo != null && orgUnitInfo.isIsCompanyOrgUnit() ? BgNFCHelper.getOrgBaseCurrency(orgUnitInfo.getId()) : BgNFCHelper.getBaseCurrency(orgUnitInfo.getParent().getId());
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
        }
        catch (EASBizException ex) {
            logger.error((Object)ex);
        }
        return currency;
    }

    public static CurrencyInfo getOrgBaseCurrency(BOSUuid orgUnitId) {
        if (orgUnitId == null) {
            return null;
        }
        ObjectUuidPK pk = null;
        CurrencyInfo currency = null;
        ICompanyOrgUnit iCompany = null;
        try {
            iCompany = CompanyOrgUnitFactory.getRemoteInstance();
            if (iCompany == null) {
                return null;
            }
            pk = new ObjectUuidPK(orgUnitId);
            CompanyOrgUnitInfo company = iCompany.getCompanyOrgUnitInfo((IObjectPK)pk);
            if (company != null) {
                currency = company.getBaseCurrency();
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
        }
        catch (EASBizException ex) {
            logger.error((Object)ex);
        }
        return currency;
    }

    public static void setSelectObject(KDComboBox cbo, Object anObject) {
        if (anObject == null) {
            return;
        }
        if (CoreBaseInfo.class.isInstance(anObject)) {
            CoreBaseInfo newObject = (CoreBaseInfo)anObject;
            for (int i = 0; i < cbo.getItemCount(); ++i) {
                CoreBaseInfo obj = (CoreBaseInfo)cbo.getItemAt(i);
                if (obj == null || !newObject.getId().equals((Object)obj.getId())) continue;
                cbo.setSelectedIndex(i);
                break;
            }
            if (cbo.getItemCount() == 0) {
                cbo.addItem(anObject);
                cbo.setSelectedItem(anObject);
            }
        } else {
            cbo.setSelectedItem(anObject);
        }
    }

    public static void sortCollection(IObjectCollection objCol, String[] strArray) {
        BgNFCHelper.sortCollection(objCol, strArray, true);
    }

    public static void sortCollection(IObjectCollection objCol, String[] strArray, boolean isASC) {
        VOComparator comp = new VOComparator(strArray, isASC);
        Object[] objArray = ((AbstractObjectCollection)objCol).toArray();
        Arrays.sort(objArray, comp);
        objCol.clear();
        for (int i = 0; i < objArray.length; ++i) {
            objCol.addObject((IObjectValue)objArray[i]);
        }
    }

    public static void showGahterInfo(Book book, BgFormInfo tmpInfo, Map formulaMap, BgNFProcessUI ui) throws Exception {
        if (book == null || tmpInfo == null || tmpInfo.getZipData() == null || ui == null) {
            return;
        }
        Book _tmpBook = null;
        Sheet _sheet = null;
        Sheet _tmpSheet = null;
        Row _row = null;
        Row _tmpRow = null;
        Column _column = null;
        Column _tmpColumn = null;
        Cell _cell = null;
        Cell _tmpCell = null;
        String _sheetId = null;
        String _rowId = null;
        String _colId = null;
        String _tmpId = null;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        int rowTmpIndex = 0;
        int colTmpIndex = 0;
        int rowSize = 0;
        int colSize = 0;
        int maxRowIndex = 0;
        int maxColIndex = 0;
        HashMap<Integer, String> rowMap = new HashMap<Integer, String>();
        HashMap<Integer, String> colMap = new HashMap<Integer, String>();
        HashMap<String, Integer> rowIdMap = new HashMap<String, Integer>();
        HashMap<String, Integer> colIdMap = new HashMap<String, Integer>();
        _tmpBook = tmpInfo.getBook();
        int count = _tmpBook.getSheetCount();
        for (int index = 0; index < count; ++index) {
            _tmpSheet = _tmpBook.getSheet(index);
            _sheetId = BgNFSHelper.getSheetSign(_tmpSheet);
            _sheet = BgNFCHelper.getSheetByID(book, _sheetId);
            if (_sheet == null) continue;
            BgGatherHelper.removeCollRowsAndCols((Sheet)_sheet);
            rowCount = _tmpSheet.getMaxRowIndex();
            colCount = _tmpSheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                _tmpRow = _tmpSheet.getRow(rowIndex, false);
                if (_tmpRow == null || !BgNFSHelper.checkHasSign(_tmpRow)) continue;
                _rowId = BgNFSHelper.getRowSign(_tmpRow);
                rowMap.put(new Integer(rowIndex), _rowId);
                rowIdMap.put(_rowId, new Integer(rowIndex));
                maxRowIndex = rowIndex;
            }
            for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                _tmpColumn = _tmpSheet.getColumn(colIndex, false);
                if (_tmpColumn == null || !BgNFSHelper.checkHasSign(_tmpColumn)) continue;
                _colId = BgNFSHelper.getColSign(_tmpColumn);
                colMap.put(new Integer(colIndex), _colId);
                colIdMap.put(_colId, new Integer(colIndex));
                maxColIndex = colIndex;
            }
            rowCount = _sheet.getMaxRowIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                _row = _sheet.getRow(rowIndex, false);
                if (_row == null || !BgNFSHelper.checkHasSign(_row) || !rowIdMap.containsKey(_rowId = BgNFSHelper.getRowSign(_row)) || (rowTmpIndex = ((Integer)rowIdMap.get(_rowId)).intValue()) == rowIndex) continue;
                rowSize = BgNFCHelper.abs(rowTmpIndex, rowIndex);
                int in = rowSize;
                for (int i = 0; i < in; ++i) {
                    BgNFSHelper.addRow(_sheet, rowIndex);
                    ++rowIndex;
                    ++rowCount;
                }
            }
            rowCount = _sheet.getMaxRowIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                _row = _sheet.getRow(rowIndex, false);
                if (_row == null || !rowMap.containsKey(new Integer(rowIndex))) continue;
                _rowId = (String)rowMap.get(new Integer(rowIndex));
                if (BgNFSHelper.checkHasSign(_row)) {
                    _tmpId = BgNFSHelper.getRowSign(_row);
                    if (_rowId.equals(_tmpId)) continue;
                    MsgBox.showWarning((Component)((Object)ui), (String)"row Alias is error!");
                    SysUtil.abort();
                    continue;
                }
                BgNFSHelper.setRowSign(_row, _rowId);
                BgNFSHelper.setRowSource(_row, "DATA_SOURCE_COLLECT");
            }
            if (rowCount <= maxRowIndex) {
                for (rowIndex = rowCount; rowIndex <= maxRowIndex; ++rowIndex) {
                    _row = BgNFSHelper.addRow(_sheet, rowIndex);
                    if (_row == null || !rowMap.containsKey(new Integer(rowIndex))) continue;
                    _rowId = (String)rowMap.get(new Integer(rowIndex));
                    if (BgNFSHelper.checkHasSign(_row)) {
                        _tmpId = BgNFSHelper.getRowSign(_row);
                        if (_rowId.equals(_tmpId)) continue;
                        MsgBox.showWarning((Component)((Object)ui), (String)"row Alias is error!");
                        SysUtil.abort();
                        continue;
                    }
                    BgNFSHelper.setRowSign(_row, _rowId);
                    BgNFSHelper.setRowSource(_row, "DATA_SOURCE_COLLECT");
                }
            }
            colCount = _sheet.getMaxColIndex();
            for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                _column = _sheet.getColumn(colIndex, false);
                if (_column == null || !BgNFSHelper.checkHasSign(_column) || !colIdMap.containsKey(_colId = BgNFSHelper.getColSign(_column)) || (colTmpIndex = ((Integer)colIdMap.get(_colId)).intValue()) == colIndex) continue;
                colSize = BgNFCHelper.abs(colTmpIndex, colIndex);
                int jn = colSize;
                for (int j = 0; j < jn; ++j) {
                    BgNFSHelper.addColumn(_sheet, colIndex);
                    ++colIndex;
                    ++colCount;
                }
            }
            colCount = _sheet.getMaxColIndex();
            for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                _column = _sheet.getColumn(colIndex, false);
                if (!colMap.containsKey(new Integer(colIndex))) continue;
                _colId = (String)colMap.get(new Integer(colIndex));
                if (BgNFSHelper.checkHasSign(_column)) {
                    _tmpId = BgNFSHelper.getColSign(_column);
                    if (_colId.equals(_tmpId)) continue;
                    MsgBox.showWarning((Component)((Object)ui), (String)"col Alias is error!");
                    SysUtil.abort();
                    continue;
                }
                BgNFSHelper.setColSign(_column, _colId);
                BgNFSHelper.setColSource(_column, "DATA_SOURCE_COLLECT");
            }
            if (colCount <= maxColIndex) {
                for (colIndex = colCount; colIndex <= maxColIndex; ++colIndex) {
                    _column = BgNFSHelper.addColumn(_sheet, colIndex);
                    if (!colMap.containsKey(new Integer(colIndex))) continue;
                    _colId = (String)colMap.get(new Integer(colIndex));
                    if (BgNFSHelper.checkHasSign(_column)) {
                        _tmpId = BgNFSHelper.getColSign(_column);
                        if (_colId.equals(_tmpId)) continue;
                        MsgBox.showWarning((Component)((Object)ui), (String)"col Alias is error!");
                        SysUtil.abort();
                        continue;
                    }
                    BgNFSHelper.setColSign(_column, _colId);
                    BgNFSHelper.setColSource(_column, "DATA_SOURCE_COLLECT");
                }
            }
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                _row = _sheet.getRow(rowIndex, false);
                if (_row == null || !BgNFSHelper.checkHasSign(_row)) continue;
                _rowId = BgNFSHelper.getRowSign(_row);
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _column = _sheet.getColumn(colIndex, false);
                    if (_column == null || !BgNFSHelper.checkHasSign(_column)) continue;
                    _colId = BgNFSHelper.getColSign(_column);
                    rowTmpIndex = (Integer)rowIdMap.get(_rowId);
                    colTmpIndex = (Integer)colIdMap.get(_colId);
                    if (rowIndex == rowTmpIndex && colIndex == colTmpIndex) {
                        _tmpCell = _tmpSheet.getCell(rowTmpIndex, colTmpIndex, false);
                        _cell = _sheet.getCell(rowIndex, colIndex, true);
                        BgNFCHelper.copyCell(_tmpCell, _cell);
                        continue;
                    }
                    MsgBox.showWarning((Component)((Object)ui), (String)"col Alias is error!");
                    SysUtil.abort();
                }
            }
        }
    }

    private static Sheet getSheetByID(Book book, String sheetId) {
        return null;
    }

    private static void copyCell(Cell sCell, Cell tCell) {
        if (sCell == null || tCell == null) {
            return;
        }
        String formulaStr = null;
        String[] tmpInfo = null;
        if (BgNFSHelper.checkHasExpression(sCell)) {
            BgNFSHelper.setExpression(tCell, BgNFSHelper.getExpression(sCell));
        }
        if (BgNFSHelper.checkHasFormulaOfCell(sCell)) {
            formulaStr = BgNFSHelper.getFormulaOfCell(sCell);
            if (!BgNFSHelper.checkHasFormulaOfCell(tCell)) {
                BgNFSHelper.setFormulaOfCell(tCell, formulaStr, true);
            }
        } else if (BgNFSHelper.checkHasBgItemInfo(sCell)) {
            tmpInfo = BgNFSHelper.getBgItemInfo(sCell);
            BgNFSHelper.setBgItemInfo(tCell, tmpInfo[1], tmpInfo[2]);
        } else if (BgNFSHelper.checkHasBgPeriodInfo(sCell)) {
            tmpInfo = BgNFSHelper.getBgPeriodInfo(sCell);
            BgNFSHelper.setBgPeriodInfo(tCell, tmpInfo[1]);
        } else if (BgNFSHelper.checkHasBgElementInfo(sCell)) {
            tmpInfo = BgNFSHelper.getBgElementInfo(sCell);
            BgNFSHelper.setBgElementInfo(tCell, tmpInfo[1], tmpInfo[2]);
        } else if (BgNFSHelper.checkHasCurrencyInfo(sCell)) {
            tmpInfo = BgNFSHelper.getCurrencyInfo(sCell);
            BgNFSHelper.setCurrencyInfo(tCell, tmpInfo[1]);
        }
        BgNFCHelper.copyCellValue(sCell, tCell);
    }

    private static void copyCellValue(Cell sCell, Cell tCell) {
        if (sCell.getValue() != Variant.nullVariant) {
            tCell.setValue(sCell.getValue());
        }
    }

    private static int abs(int one, int two) {
        return one > two ? one - two : two - one;
    }

    public static void checkFormulaIsEctype(List formulas) throws EASBizException {
        int index;
        if (formulas == null || formulas.isEmpty()) {
            return;
        }
        String formulaString = null;
        String checkString = null;
        String sheetString = null;
        StringBuffer msg = null;
        String[] parameter = null;
        HashMap checkMap = new HashMap();
        int count = formulas.size();
        for (index = 0; index < count; ++index) {
            parameter = (String[])formulas.get(index);
            if (parameter == null || parameter[0] == null || parameter[1] == null || parameter[2] == null || parameter[3] == null) continue;
            formulaString = parameter[1];
            if (checkMap.containsKey(formulaString)) {
                checkString = formulaString;
                break;
            }
            checkMap.put(formulaString, null);
        }
        try {
            if (!StringUtils.isEmpty(checkString)) {
                msg = new StringBuffer(1024);
                count = formulas.size();
                for (index = 0; index < count; ++index) {
                    parameter = (String[])formulas.get(index);
                    if (parameter == null || parameter[0] == null || parameter[1] == null || parameter[2] == null || parameter[3] == null || !(formulaString = parameter[1]).equals(checkString)) continue;
                    if (sheetString == null || !sheetString.equals(parameter[0])) {
                        sheetString = parameter[0];
                        msg.append(BgNFCHelper.getMessageStr(SOURCE_OLD, "left") + sheetString + BgNFCHelper.getMessageStr(SOURCE_OLD, "right") + BgNFCHelper.getMessageStr(SOURCE_OLD, "checkFormulade"));
                    }
                    msg.append(TableToolkit.xy2range((int)Integer.valueOf(parameter[3]), (int)Integer.valueOf(parameter[2])) + BgNFCHelper.getMessageStr(SOURCE_OLD, "andtwo"));
                }
                msg.delete(msg.length() - 1, msg.length());
                msg.append(BgNFCHelper.getMessageStr(SOURCE_OLD, "checkFormula") + BgNFCHelper.getMessageStr(SOURCE_OLD, "left") + checkString.replaceAll(",\"BgData\",true", "") + BgNFCHelper.getMessageStr(SOURCE_OLD, "right") + BgNFCHelper.getMessageStr(SOURCE_OLD, "checkFormulaEctype"));
                throw new BgFormException(BgFormException.SHOWEXCEPTION, (Object[])new String[]{msg.toString()});
            }
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            checkMap.clear();
        }
    }

    public static void ctrlSet(IUIObject ui, Book book, Map ctrlModeMap, Map ctrlModeCellMap, Map formulaMap) throws Exception {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"ID", null);
        HashMap itemElementToPeriodMap = new HashMap();
        Vector itemAndElement = BgNFCHelper.getCtrlModeFromItemFormula(book, ctrlModeMap, ctrlModeCellMap, formulaMap, false, itemElementToPeriodMap);
        uiContext.put((Object)"ctrlModeMap", (Object)ctrlModeMap);
        uiContext.put((Object)"itemElementToPeriodMap", itemElementToPeriodMap);
        uiContext.put((Object)"itemAndElement", (Object)itemAndElement);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CtrlSetEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        ctrlModeMap = ((CtrlSetEditUI)uiWindow.getUIObject()).getCtrlModeMap();
        if (ctrlModeMap.isEmpty()) {
            return;
        }
        Cell _cell = null;
        Object _obj = null;
        for (String key : ctrlModeCellMap.keySet()) {
            Vector vec = (Vector)ctrlModeCellMap.get(key);
            Map map = null;
            map = ctrlModeMap.containsKey(key) ? (Map)ctrlModeMap.get(key) : new Hashtable();
            if (map.isEmpty()) continue;
            for (int j = 0; j < vec.size(); ++j) {
                _cell = (Cell)vec.get(j);
                if (_cell == null) continue;
                _obj = map.get("isCtrl");
                BgNFSHelper.setIsCtrl(_cell, _obj == null ? BgNConstants.FALSE_STR : _obj.toString(), true);
                _obj = map.get("isFlexCtrl");
                BgNFSHelper.setIsFlexCtrl(_cell, _obj == null ? BgNConstants.FALSE_STR : _obj.toString(), true);
                _obj = map.get("flexCtrlParam");
                BgNFSHelper.setFlexCtrlPara(_cell, _obj == null ? "1.00" : _obj.toString(), true);
                _obj = map.get("periodCtrlPolicy");
                BgNFSHelper.setPeriodCtrlPolicy(_cell, _obj == null ? "-1" : _obj.toString(), true);
                _obj = map.get("isGroupCtrl");
                BgNFSHelper.setIsGroupCtrl(_cell, _obj == null ? BgNConstants.FALSE_STR : _obj.toString(), true);
                _obj = map.get("groupCtrlNo");
                BgNFSHelper.setGroupCtrlNo(_cell, _obj == null ? "-1" : _obj.toString(), true);
                _obj = map.get("isAllowAccess");
                BgNFSHelper.setIsAllowAccess(_cell, _obj == null ? BgNConstants.TRUE_STE : _obj.toString(), true);
            }
        }
    }

    public static void ctrlSetOnlyNotSet(IUIObject ui, Book book, Map ctrlModeMap, Map ctrlModeCellMap, Map formulaMap) throws Exception {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"ID", null);
        HashMap itemElementToPeriodMap = new HashMap();
        Vector itemAndElement = BgNFCHelper.getCtrlModeFromItemFormula(book, ctrlModeMap, ctrlModeCellMap, formulaMap, false, itemElementToPeriodMap);
        uiContext.put((Object)"ctrlModeMap", (Object)ctrlModeMap);
        uiContext.put((Object)"itemAndElement", (Object)itemAndElement);
        uiContext.put((Object)"itemElementToPeriodMap", itemElementToPeriodMap);
        uiContext.put((Object)"isonlyNotSet", (Object)Boolean.TRUE);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CtrlSetEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        ctrlModeMap = ((CtrlSetEditUI)uiWindow.getUIObject()).getCtrlModeMap();
        if (ctrlModeMap.isEmpty()) {
            return;
        }
        Cell _cell = null;
        Object _obj = null;
        for (String key : ctrlModeCellMap.keySet()) {
            Vector vec = (Vector)ctrlModeCellMap.get(key);
            Map map = null;
            map = ctrlModeMap.containsKey(key) ? (Map)ctrlModeMap.get(key) : new Hashtable();
            if (map.isEmpty()) continue;
            for (int j = 0; j < vec.size(); ++j) {
                _cell = (Cell)vec.get(j);
                if (_cell == null) continue;
                _obj = map.get("isCtrl");
                BgNFSHelper.setIsCtrl(_cell, _obj == null ? BgNConstants.FALSE_STR : _obj.toString(), true);
                _obj = map.get("isFlexCtrl");
                BgNFSHelper.setIsFlexCtrl(_cell, _obj == null ? BgNConstants.FALSE_STR : _obj.toString(), true);
                _obj = map.get("flexCtrlParam");
                BgNFSHelper.setFlexCtrlPara(_cell, _obj == null ? "1.00" : _obj.toString(), true);
                _obj = map.get("periodCtrlPolicy");
                BgNFSHelper.setPeriodCtrlPolicy(_cell, _obj == null ? "-1" : _obj.toString(), true);
                _obj = map.get("isGroupCtrl");
                BgNFSHelper.setIsGroupCtrl(_cell, _obj == null ? BgNConstants.FALSE_STR : _obj.toString(), true);
                _obj = map.get("groupCtrlNo");
                BgNFSHelper.setGroupCtrlNo(_cell, _obj == null ? "-1" : _obj.toString(), true);
                _obj = map.get("isAllowAccess");
                BgNFSHelper.setIsAllowAccess(_cell, _obj == null ? BgNConstants.TRUE_STE : _obj.toString(), true);
            }
        }
    }

    public static Vector getCtrlModeFromItemFormula(Book book, Map ctrlModeMap, Map ctrlModeCellMap, Map formulaMap, boolean isView, HashMap itemElementToPeriodMap) throws Exception {
        Vector<String> result = new Vector<String>();
        Sheet _sheet = null;
        Cell _cell = null;
        String _formulaStr = null;
        String[] _parameter = null;
        ItemFormula _itemFormula = null;
        int sheetIndex = 0;
        int sheetSize = 0;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        if (itemElementToPeriodMap == null) {
            itemElementToPeriodMap = new HashMap<String, String>();
        }
        String periodStrlist = null;
        sheetSize = book.getSheetCount();
        for (sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    Vector vec;
                    Map map;
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                    _itemFormula = BgNFSHelper.getItemFormula(_cell);
                    if (!isView && !BgNFSHelper.checkCanEditFormulaOfCell(_cell)) continue;
                    _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                    _parameter = BgNFSHelper.parseFormulaPara(formulaMap, _formulaStr);
                    String itemCombinNumber = _parameter[0];
                    String elementNumber = _parameter[2];
                    String key = itemCombinNumber + "_" + elementNumber;
                    String periodNumber = _parameter[1];
                    if (itemElementToPeriodMap.containsKey(key)) {
                        periodStrlist = (String)itemElementToPeriodMap.get(key);
                        periodStrlist = periodStrlist + "," + periodNumber;
                    } else {
                        periodStrlist = periodNumber;
                        itemElementToPeriodMap.put(key, periodStrlist);
                    }
                    if (!result.contains(key)) {
                        result.add(key);
                    }
                    if (ctrlModeMap.containsKey(key)) {
                        map = (Map)ctrlModeMap.get(key);
                        BgNFCHelper.setCtrlMap(_itemFormula, map);
                        ctrlModeMap.put(key, map);
                    } else {
                        map = new Hashtable();
                        BgNFCHelper.setCtrlMap(_itemFormula, map);
                        ctrlModeMap.put(key, map);
                    }
                    if (ctrlModeCellMap.containsKey(key)) {
                        vec = (Vector)ctrlModeCellMap.get(key);
                        vec.add(_cell);
                        ctrlModeCellMap.put(key, vec);
                        continue;
                    }
                    vec = new Vector();
                    vec.add(_cell);
                    ctrlModeCellMap.put(key, vec);
                }
            }
        }
        return result;
    }

    public static void ctrlView(IUIObject ui, Book book, Map ctrlModeMap, Map ctrlModeCellMap, Map formulaMap) throws Exception {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"ID", null);
        HashMap itemElementToPeriodMap = new HashMap();
        Vector vec = BgNFCHelper.getCtrlModeFromItemFormula(book, ctrlModeMap, ctrlModeCellMap, formulaMap, true, itemElementToPeriodMap);
        uiContext.put((Object)"ctrlModeMap", (Object)ctrlModeMap);
        uiContext.put((Object)"itemElementToPeriodMap", itemElementToPeriodMap);
        uiContext.put((Object)"itemAndElement", (Object)vec);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CtrlSetEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public static void setCtrlMap(ItemFormula itemFormula, Map map) {
        if (itemFormula == null || map == null) {
            return;
        }
        String obj = BgNFSHelper.getIsCtrl(itemFormula);
        Boolean isCtrl = obj == null || StringUtils.isEmpty((String)obj.toString()) ? Boolean.FALSE : new Boolean(obj.toString());
        obj = BgNFSHelper.getIsFlexCtrl(itemFormula);
        Boolean isFlexCtrl = obj == null || StringUtils.isEmpty((String)obj.toString()) ? Boolean.FALSE : new Boolean(obj.toString());
        obj = BgNFSHelper.getFlexCtrlPara(itemFormula);
        BigDecimal flexCtrlParam = obj == null || StringUtils.isEmpty((String)obj.toString()) ? BgNConstants.ONE_POS : new BigDecimal(obj.toString());
        obj = BgNFSHelper.getPeriodCtrlPolicy(itemFormula);
        Integer periodCtrlPolicy = obj == null || StringUtils.isEmpty((String)obj.toString()) ? new Integer(-1) : new Integer(obj.toString());
        obj = BgNFSHelper.getIsGroupCtrl(itemFormula);
        Boolean isGroupCtrl = obj == null || StringUtils.isEmpty((String)obj.toString()) ? Boolean.FALSE : new Boolean(obj.toString());
        obj = BgNFSHelper.getGroupCtrlNo(itemFormula);
        Integer groupNo = null;
        try {
            groupNo = obj == null || StringUtils.isEmpty((String)obj.toString()) ? new Integer(-1) : new Integer(obj.toString());
        }
        catch (Exception e) {
            groupNo = new Integer(-1);
        }
        obj = itemFormula.getExt("isctrl_from_super_collection_form");
        Boolean isctrl_from_super_collection_form = obj == null || StringUtils.isEmpty((String)obj.toString()) ? Boolean.FALSE : new Boolean(obj.toString());
        obj = BgNFSHelper.getIsAllowAccess(itemFormula);
        Boolean isAllowAccess = obj == null || StringUtils.isEmpty((String)obj.toString()) ? Boolean.TRUE : new Boolean(obj.toString());
        map.put("isCtrl", isCtrl);
        map.put("isFlexCtrl", isFlexCtrl);
        map.put("flexCtrlParam", flexCtrlParam);
        map.put("periodCtrlPolicy", periodCtrlPolicy);
        map.put("isGroupCtrl", isGroupCtrl);
        map.put("groupCtrlNo", groupNo);
        map.put("isctrl_from_super_collection_form", isctrl_from_super_collection_form);
        map.put("isAllowAccess", isAllowAccess);
    }

    public static String returnExamineX(BOSUuid[] bgformid, Object owner) {
        String data = null;
        try {
            IBgExamineFacade iBEx = BgExamineFacadeFactory.getRemoteInstance();
            if (iBEx.canExamine(bgformid) && iBEx.examineHadX(bgformid)) {
                UIContext uiContext = new UIContext(owner);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgExamineXInputUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
                uiWindow.show();
                data = ((BgExamineXInputUI)uiWindow.getUIObject()).getData();
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        return data;
    }

    public static void setNumberExpandInfo(Cell cell, NumberExpandInfo expandInfo) {
        if (cell == null) {
            return;
        }
        cell.setUserObject("NEId", (Object)expandInfo.getId());
        cell.setUserObject("NEName", (Object)expandInfo.getName());
        cell.setUserObject("NENum", (Object)expandInfo.getNumber());
        cell.setUserObject("NELNum", (Object)expandInfo.getLongNumber());
        cell.setUserObject("NELevel", (Object)new Integer(expandInfo.getLevel()));
        cell.setUserObject("NELeaf", (Object)new Boolean(expandInfo.isLeaf()));
        cell.setUserObject("NEStatus", (Object)new Boolean(expandInfo.isExpandStatus()));
        cell.setUserObject("NECol", (Object)new Boolean(expandInfo.isCollect()));
        cell.setUserObject("NEHasExpendData", (Object)new Boolean(expandInfo.isHasExpendData()));
        BgNFSHelper.setValue(cell, expandInfo.getName());
    }

    public static NumberExpandInfo getNumberExpandInfo(Cell cell) {
        if (cell == null) {
            return null;
        }
        NumberExpandInfo info = new NumberExpandInfo();
        if (cell.getUserObject("NEName") == null || cell.getUserObject("NEName").getValue() == null) {
            return null;
        }
        if (cell.getUserObject("NEId") != null && cell.getUserObject("NEId").getValue() != null) {
            info.setId(cell.getUserObject("NEId").getValue().toString());
        }
        info.setName(cell.getUserObject("NEName").getValue().toString());
        if (cell.getUserObject("NENum") != null && cell.getUserObject("NENum").getValue() != null) {
            info.setNumber(cell.getUserObject("NENum").getValue().toString());
        }
        info.setLongNumber(cell.getUserObject("NELNum").getValue().toString());
        info.setLevel(((Integer)cell.getUserObject("NELevel").getValue()).intValue());
        info.setLeaf(((Boolean)cell.getUserObject("NELeaf").getValue()).booleanValue());
        info.setExpandStatus(((Boolean)cell.getUserObject("NEStatus").getValue()).booleanValue());
        info.setCollect(((Boolean)cell.getUserObject("NECol").getValue()).booleanValue());
        if (cell.getUserObject("NEHasExpendData") != null) {
            info.setHasExpendData(((Boolean)cell.getUserObject("NEHasExpendData").getValue()).booleanValue());
        }
        return info;
    }

    public static CompanyOrgUnitInfo getCompanyByOrgUnit(OrgUnitInfo orgUnitInfo) throws Exception {
        if (orgUnitInfo == null) {
            return null;
        }
        if (orgUnitInfo.isIsCompanyOrgUnit()) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("name");
            sic.add("number");
            sic.add("isBizUnit");
            sic.add("accountPeriodType.id");
            sic.add("baseExchangeTable.id");
            return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), sic);
        }
        OrgUnitInfo parent = null;
        parent = orgUnitInfo.get("isCompanyOrgUnit") == null ? FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId())) : NewOrgViewFacadeFactory.getRemoteInstance().getParent(orgUnitInfo.getId().toString(), OrgViewType.COSTCENTER);
        if (parent != null) {
            return BgNFCHelper.getCompanyByOrgUnit(parent);
        }
        return null;
    }

    public static KDSBook exportExcel(Map parameter) {
        if (parameter == null || parameter.isEmpty()) {
            return null;
        }
        Book _book = (Book)parameter.get("EXPORT_BOOK");
        Sheet _sheet = null;
        Cell _cell = null;
        KDSBook _kdsBook = null;
        KDSSheet _kdsSheet = null;
        KDSCell _kdsCell = null;
        int _sheetIndex = 0;
        int _sheetSize = _book.getSheetCount();
        int _rowIndex = 0;
        int _rowCount = 0;
        int _colIndex = 0;
        int _colCount = 0;
        Object _obj = null;
        String _formulaStr = null;
        String[] _parameter = null;
        BigDecimal _value = null;
        BigDecimal _tmpCoefficient = null;
        BigDecimal _coefficient = (BigDecimal)parameter.get("EXPORT_COEFFICIENT");
        Map _muMap = (Map)parameter.get("EXPORT_MEASUREUNIT");
        Map _formulaMap = (Map)parameter.get("EXPORT_BGFORMULA");
        boolean _hasData = (Boolean)parameter.get("EXPORT_DATA");
        _kdsBook = BookToKDSBook.traslate((Book)_book);
        for (_sheetIndex = _sheetSize - 1; _sheetIndex >= 0; --_sheetIndex) {
            _sheet = _book.getSheet(_sheetIndex);
            if (_sheet.isHide()) {
                _kdsBook.remove((Object)new Integer(_sheetIndex));
                continue;
            }
            _kdsSheet = _kdsBook.getSheet((Object)new Integer(_sheetIndex));
            _rowCount = _sheet.getMaxRowIndex();
            _colCount = _sheet.getMaxColIndex();
            for (_rowIndex = 0; _rowIndex <= _rowCount; ++_rowIndex) {
                for (_colIndex = 0; _colIndex <= _colCount; ++_colIndex) {
                    _cell = _sheet.getCell(_rowIndex, _colIndex, true);
                    _kdsCell = _kdsSheet.getCell(_rowIndex, _colIndex, true);
                    if (!BgNFSHelper.checkIsEmptyContext(_cell)) {
                        if (!_hasData) continue;
                        _tmpCoefficient = _coefficient;
                        if (BgNFSHelper.checkHasTextOfCell(_cell)) {
                            _kdsSheet.setCellValue(_rowIndex, _colIndex, _cell.getValue().getValue());
                            continue;
                        }
                        if (BgNFSHelper.checkHasPercentage(_cell)) {
                            _kdsCell.setText(_cell.getText());
                            continue;
                        }
                        if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
                            _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                            if (_muMap != null && !_muMap.isEmpty() && _muMap.containsKey((_parameter = BgNFSHelper.parseFormulaPara(_formulaMap, _formulaStr))[2])) {
                                _tmpCoefficient = (BigDecimal)_muMap.get(_parameter[2]);
                            }
                            if ((_obj = _cell.getValue().getValue()) instanceof BigDecimal) {
                                _value = (BigDecimal)_obj;
                            } else if (BgNFSHelper.checkIsNumeric(_cell.getValue())) {
                                try {
                                    _value = new BigDecimal(_cell.getValue().getValue().toString().replaceAll(",", ""));
                                }
                                catch (Exception ex) {
                                    _value = BgNConstants.ZERO;
                                }
                            } else {
                                _value = BgNConstants.ZERO;
                            }
                            _value = _value.divide(_tmpCoefficient, 8, 4);
                            _kdsSheet.setCellValue(_rowIndex, _colIndex, (Object)_value);
                            continue;
                        }
                        if (BgNFSHelper.checkHasGatFormulaOfCell(_cell)) {
                            _formulaStr = BgNFSHelper.getGatFormulaOfCell(_cell);
                            if (_muMap != null && !_muMap.isEmpty() && _muMap.containsKey((_parameter = BgNFSHelper.parseFormulaPara(_formulaMap, _formulaStr))[2])) {
                                _tmpCoefficient = (BigDecimal)_muMap.get(_parameter[2]);
                            }
                            if ((_obj = _cell.getValue().getValue()) instanceof BigDecimal) {
                                _value = (BigDecimal)_obj;
                            } else if (BgNFSHelper.checkIsNumeric(_cell.getValue())) {
                                try {
                                    _value = new BigDecimal(_cell.getValue().getValue().toString().replaceAll(",", ""));
                                }
                                catch (Exception ex) {
                                    _value = BgNConstants.ZERO;
                                }
                            } else {
                                _value = BgNConstants.ZERO;
                            }
                            _value = _value.divide(_tmpCoefficient, 8, 4);
                            _kdsSheet.setCellValue(_rowIndex, _colIndex, (Object)_value);
                            continue;
                        }
                        if (BgNFSHelper.checkHasExpression(_cell)) {
                            BgNFCHelper.exportExpressionValue(_cell, _kdsSheet, _tmpCoefficient, _muMap);
                            continue;
                        }
                        if (BgNFSHelper.checkHasNumbericOfCell(_cell)) {
                            _obj = _cell.getValue().getValue();
                            if (_obj instanceof BigDecimal) {
                                _value = (BigDecimal)_obj;
                                _value = _value.divide(_tmpCoefficient, 8, 4);
                                _kdsSheet.setCellValue(_rowIndex, _colIndex, (Object)_value);
                                continue;
                            }
                            if (!(_obj instanceof String)) continue;
                            String value = _obj.toString();
                            if (_colIndex == 0 && _cell.getUserObject("NELevel") != null) {
                                int level = (Integer)_cell.getUserObject("NELevel").getValue();
                                for (int i = 0; i < level; ++i) {
                                    value = "  " + value;
                                }
                            }
                            _kdsSheet.setCellValue(_rowIndex, _colIndex, (Object)value);
                            continue;
                        }
                        _kdsSheet.setCellValue(_rowIndex, _colIndex, (Object)_cell.getValue().getValue().toString());
                        continue;
                    }
                    _kdsSheet.setCell(_rowIndex, _colIndex, null, _cell.getSSA());
                }
            }
        }
        return _kdsBook;
    }

    public static Book exportExcel2007(Map parameter) {
        if (parameter == null || parameter.isEmpty()) {
            return null;
        }
        Book book = (Book)parameter.get("EXPORT_BOOK");
        Book _book = BgNFCHelper.copyBook2007(book);
        Sheet _sheet = null;
        Cell _cell = null;
        int _sheetIndex = 0;
        int _sheetSize = _book.getSheetCount();
        int _rowIndex = 0;
        int _rowCount = 0;
        int _colIndex = 0;
        int _colCount = 0;
        Object _obj = null;
        String _formulaStr = null;
        String[] _parameter = null;
        BigDecimal _value = null;
        BigDecimal _tmpCoefficient = null;
        BigDecimal _coefficient = (BigDecimal)parameter.get("EXPORT_COEFFICIENT");
        Map _muMap = (Map)parameter.get("EXPORT_MEASUREUNIT");
        Map _formulaMap = (Map)parameter.get("EXPORT_BGFORMULA");
        boolean _hasData = (Boolean)parameter.get("EXPORT_DATA");
        for (_sheetIndex = _sheetSize - 1; _sheetIndex >= 0; --_sheetIndex) {
            _sheet = _book.getSheet(_sheetIndex);
            if (_sheet.isHide()) {
                _book.removeSheet(_sheetIndex);
                continue;
            }
            _rowCount = _sheet.getMaxRowIndex();
            _colCount = _sheet.getMaxColIndex();
            for (_rowIndex = 0; _rowIndex <= _rowCount; ++_rowIndex) {
                for (_colIndex = 0; _colIndex <= _colCount; ++_colIndex) {
                    _cell = _sheet.getCell(_rowIndex, _colIndex, false);
                    if (BgNFSHelper.checkIsEmptyContext(_cell) || !_hasData) continue;
                    _tmpCoefficient = _coefficient;
                    if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
                        _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                        if (_muMap != null && !_muMap.isEmpty() && _muMap.containsKey((_parameter = BgNFSHelper.parseFormulaPara(_formulaMap, _formulaStr))[2])) {
                            _tmpCoefficient = (BigDecimal)_muMap.get(_parameter[2]);
                        }
                        if ((_obj = _cell.getValue().getValue()) instanceof BigDecimal) {
                            _value = (BigDecimal)_obj;
                        } else if (BgNFSHelper.checkIsNumeric(_cell.getValue())) {
                            try {
                                _value = new BigDecimal(_cell.getValue().getValue().toString().replaceAll(",", ""));
                            }
                            catch (Exception ex) {
                                _value = BgNConstants.ZERO;
                            }
                        } else {
                            _value = BgNConstants.ZERO;
                        }
                        _value = _value.divide(_tmpCoefficient, 8, 4);
                        _cell.setValue(new Variant((Object)_value));
                        continue;
                    }
                    if (BgNFSHelper.checkHasGatFormulaOfCell(_cell)) {
                        _formulaStr = BgNFSHelper.getGatFormulaOfCell(_cell);
                        if (_muMap != null && !_muMap.isEmpty() && _muMap.containsKey((_parameter = BgNFSHelper.parseFormulaPara(_formulaMap, _formulaStr))[2])) {
                            _tmpCoefficient = (BigDecimal)_muMap.get(_parameter[2]);
                        }
                        if ((_obj = _cell.getValue().getValue()) instanceof BigDecimal) {
                            _value = (BigDecimal)_obj;
                        } else if (BgNFSHelper.checkIsNumeric(_cell.getValue())) {
                            try {
                                _value = new BigDecimal(_cell.getValue().getValue().toString().replaceAll(",", ""));
                            }
                            catch (Exception ex) {
                                _value = BgNConstants.ZERO;
                            }
                        } else {
                            _value = BgNConstants.ZERO;
                        }
                        _value = _value.divide(_tmpCoefficient, 8, 4);
                        _cell.setValue(new Variant((Object)_value));
                        continue;
                    }
                    if (!BgNFSHelper.checkHasNumbericOfCell(_cell)) continue;
                    _obj = _cell.getValue().getValue();
                    if (_obj instanceof BigDecimal) {
                        _value = (BigDecimal)_obj;
                        _value = _value.divide(_tmpCoefficient, 8, 4);
                        _cell.setValue(new Variant((Object)_value));
                        continue;
                    }
                    if (!(_obj instanceof String)) continue;
                    String value = _obj.toString();
                    if (_colIndex == 0 && _cell.getUserObject("NELevel") != null) {
                        int level = (Integer)_cell.getUserObject("NELevel").getValue();
                        for (int i = 0; i < level; ++i) {
                            value = "  " + value;
                        }
                    }
                    _cell.setValue(new Variant((Object)value));
                }
            }
        }
        return _book;
    }

    private static void exportExpressionValue(Cell cell, KDSSheet kdsSheet, BigDecimal coefficient, Map muMap) {
        Object _obj;
        if (cell == null) {
            return;
        }
        String _expressions = cell.getFormula();
        Expression _expression = null;
        try {
            _expression = ExcelFormulaPaserHelper.parse((String)_expressions);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean re = BgNFCHelper.exportExpressionValue(cell, kdsSheet, _expression, coefficient, muMap);
        if (!re && (_obj = BgNFSHelper.getValue(cell)) != null) {
            BigDecimal _value = null;
            if (_obj instanceof BigDecimal) {
                _value = (BigDecimal)_obj;
                _value = _value.divide(coefficient, 8, 4);
                kdsSheet.setCellValue(cell.getRow(), cell.getCol(), (Object)_value);
            } else {
                try {
                    _value = new BigDecimal(_obj.toString().replaceAll(",", ""));
                    _value = _value.divide(coefficient, 8, 4);
                    kdsSheet.setCellValue(cell.getRow(), cell.getCol(), (Object)_value);
                }
                catch (Exception ex) {
                    kdsSheet.setCellValue(cell.getRow(), cell.getCol(), (Object)_obj.toString());
                }
            }
        }
    }

    private static boolean exportExpressionValue(Cell cell, KDSSheet kdsSheet, Expression expression, BigDecimal coefficient, Map muMap) {
        boolean re = false;
        if (expression instanceof FunctionExpr) {
            String _funcionName = ((FunctionExpr)expression).funcionName;
            if ("bgformula".equalsIgnoreCase(_funcionName) || "bgactuals".equalsIgnoreCase(_funcionName) || "bgbal".equalsIgnoreCase(_funcionName) || "bgadjust".equalsIgnoreCase(_funcionName) || "bgAvlBal".equalsIgnoreCase(_funcionName) || "bgactualext".equalsIgnoreCase(_funcionName)) {
                Object _obj;
                StringExpr _bgelement = (StringExpr)((FunctionExpr)expression).parameters.get(2);
                BigDecimal _coefficient = coefficient;
                BigDecimal _value = null;
                if (muMap.containsKey(_bgelement.value)) {
                    _coefficient = (BigDecimal)muMap.get(_bgelement.value);
                }
                if ((_obj = BgNFSHelper.getValue(cell)) != null) {
                    if (_obj instanceof BigDecimal) {
                        _value = (BigDecimal)_obj;
                        _value = _value.divide(_coefficient, 8, 4);
                    } else {
                        try {
                            _value = new BigDecimal(_obj.toString().replaceAll(",", ""));
                            _value = _value.divide(_coefficient, 8, 4);
                        }
                        catch (Exception ex) {
                            _value = BgNConstants.ZERO;
                        }
                    }
                    kdsSheet.setCellValue(cell.getRow(), cell.getCol(), (Object)_value);
                }
                re = true;
            }
        } else if (expression instanceof BinaryOperationExpr && !(re = BgNFCHelper.exportExpressionValue(cell, kdsSheet, ((BinaryOperationExpr)expression).left, coefficient, muMap))) {
            re = BgNFCHelper.exportExpressionValue(cell, kdsSheet, ((BinaryOperationExpr)expression).right, coefficient, muMap);
        }
        return re;
    }

    public static void importExcel(Map parameter) {
        if (parameter == null || parameter.isEmpty()) {
            return;
        }
        Book _book = (Book)parameter.get("IMPORT_BOOK");
        Sheet _sheet = null;
        Cell _cell = null;
        KDSBook _kdsBook = (KDSBook)parameter.get("IMPORT_KDSBOOK");
        KDSSheet _kdsSheet = null;
        KDSCell _kdsCell = null;
        Object _obj = null;
        String _formulaStr = null;
        String _expression = null;
        String[] _parameter = null;
        BigDecimal _coefficient = (BigDecimal)parameter.get("IMPORT_COEFFICIENT");
        BigDecimal _tmpCoefficient = null;
        BigDecimal _value = null;
        Map _muMap = (Map)parameter.get("IMPORT_MEASUREUNIT");
        Map _formulaMap = (Map)parameter.get("IMPORT_BGFORMULA");
        boolean _hasData = (Boolean)parameter.get("IMPORT_DATA");
        boolean _autoCal = _book.isAutoCalculate();
        _book.setCalculate(false);
        _book.getUndoManager().enable(false);
        _book.setSkipListeners(true);
        if (_book == null || _kdsBook == null) {
            return;
        }
        int _sheetIndex = 0;
        int _sheetSize = _book.getSheetCount();
        for (_sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
            _kdsSheet = _kdsBook.getSheet((Object)new Integer(_sheetIndex));
            _sheet = _book.getSheet(_sheetIndex);
            if (_kdsSheet == null || _sheet == null) continue;
            int _rowCount = _kdsSheet.getRowCount();
            int _colCount = _kdsSheet.getColumnCount();
            for (int _rowIndex = 0; _rowIndex <= _rowCount; ++_rowIndex) {
                for (int _colIndex = 0; _colIndex <= _colCount; ++_colIndex) {
                    _kdsCell = _kdsSheet.getCell(_rowIndex, _colIndex, false);
                    boolean isCreate = _sheet.getCell(_rowIndex, _colIndex, false) == null;
                    _cell = _sheet.getCell(_rowIndex, _colIndex, true);
                    if (_cell.isLocked()) continue;
                    if (!StringUtils.isEmpty((String)_kdsCell.getFormula())) {
                        _expression = _kdsCell.getFormula();
                        if (_expression.charAt(0) != '=') {
                            _expression = "=" + _expression;
                        }
                        BgNFSHelper.setExpression(_cell, _expression);
                    }
                    if (_kdsCell != null && _kdsCell.getValue() != null) {
                        _obj = _kdsCell.getValue();
                        if (_obj instanceof String && StringUtils.isEmpty((String)_obj.toString())) continue;
                        if (_hasData) {
                            _tmpCoefficient = _coefficient;
                            if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
                                _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                                if (_muMap != null && !_muMap.isEmpty() && _muMap.containsKey((_parameter = BgNFSHelper.parseFormulaPara(_formulaMap, _formulaStr))[2])) {
                                    _tmpCoefficient = (BigDecimal)_muMap.get(_parameter[2]);
                                }
                                if (BgNFSHelper.checkIsNumeric(_kdsCell.getValue())) {
                                    try {
                                        _value = new BigDecimal(_kdsCell.getValue().toString().replaceAll(",", ""));
                                    }
                                    catch (Exception ex) {
                                        _value = BgNConstants.ZERO;
                                    }
                                    _value = BgNFCHelper.setHasPercentage(_cell, _kdsCell, _value, _tmpCoefficient, true);
                                    BgNFSHelper.setValue(_cell, _value);
                                } else {
                                    BgNFSHelper.setValue(_cell, BgNConstants.ZERO);
                                }
                            } else if (BgNFSHelper.checkHasGatFormulaOfCell(_cell)) {
                                _formulaStr = BgNFSHelper.getGatFormulaOfCell(_cell);
                                if (_muMap != null && !_muMap.isEmpty() && _muMap.containsKey((_parameter = BgNFSHelper.parseFormulaPara(_formulaMap, _formulaStr))[2])) {
                                    _tmpCoefficient = (BigDecimal)_muMap.get(_parameter[2]);
                                }
                                if (BgNFSHelper.checkIsNumeric(_kdsCell.getValue())) {
                                    try {
                                        _value = new BigDecimal(_kdsCell.getValue().toString().replaceAll(",", ""));
                                    }
                                    catch (Exception ex) {
                                        _value = BgNConstants.ZERO;
                                    }
                                    _value = BgNFCHelper.setHasPercentage(_cell, _kdsCell, _value, _tmpCoefficient, true);
                                    BgNFSHelper.setValue(_cell, _value);
                                } else {
                                    BgNFSHelper.setValue(_cell, BgNConstants.ZERO);
                                }
                            } else if (BgNFSHelper.checkHasExpression(_cell)) {
                                BgNFCHelper.importExpressionValue(_cell, _obj, _tmpCoefficient, _muMap);
                            } else if (BgNFSHelper.checkHasBgItemInfo(_cell) || BgNFSHelper.checkHasBgElementInfo(_cell) || BgNFSHelper.checkHasBgPeriodInfo(_cell) || BgNFSHelper.checkHasCurrencyInfo(_cell)) {
                                BgNFSHelper.setNumberFormat(_cell, "@");
                                BgNFSHelper.setValue(_cell, _kdsCell.getValue().toString());
                            } else if (BgNFSHelper.checkHasNumbericOfCell(_cell) && !BgNFSHelper.checkHasTextOfCell(_cell)) {
                                if (BgNFSHelper.checkIsNumeric(_kdsCell.getValue())) {
                                    try {
                                        _value = new BigDecimal(_kdsCell.getValue().toString().replaceAll(",", ""));
                                    }
                                    catch (Exception ex) {
                                        _value = BgNConstants.ZERO;
                                    }
                                    _value = BgNFCHelper.setHasPercentage(_cell, _kdsCell, _value, _tmpCoefficient, true);
                                    BgNFSHelper.setValue(_cell, _value);
                                } else {
                                    BgNFSHelper.setValue(_cell, _kdsCell.getValue());
                                }
                            } else {
                                String _kdscellFormat = _kdsCell.getSSA().getNumberFormat();
                                if (_kdscellFormat != null && _kdscellFormat.indexOf("%") != -1) {
                                    try {
                                        _value = new BigDecimal(_kdsCell.getValue().toString().replaceAll(",", ""));
                                    }
                                    catch (Exception ex) {
                                        _value = BgNConstants.ZERO;
                                    }
                                    BgNFCHelper.setHasPercentage(_cell, _kdsCell, _value, _tmpCoefficient, false);
                                    BgNFSHelper.setValue(_cell, _value);
                                } else {
                                    BgNFSHelper.setValue(_cell, _kdsCell.getValue());
                                }
                            }
                        } else {
                            BgNFCHelper.setHasPercentage(_cell, _kdsCell, _value, _tmpCoefficient, false);
                            if (BgNFSHelper.checkIsNumeric(_kdsCell.getValue())) {
                                try {
                                    _value = new BigDecimal(_kdsCell.getValue().toString().replaceAll(",", ""));
                                }
                                catch (Exception ex) {
                                    _value = BgNConstants.ZERO;
                                }
                                BgNFSHelper.setValue(_cell, _value);
                            } else {
                                BgNFSHelper.setValue(_cell, _kdsCell.getValue());
                            }
                        }
                    }
                    if (!isCreate || BgNFSHelper.checkIsEmptyCell(_cell)) continue;
                    BgNFSHelper.setCellData(_cell, "USER_EIDT", Boolean.TRUE.toString());
                }
            }
        }
        _book.updatePendingSheet();
        _book.clearEmptyCells();
        _book.setCalculate(_autoCal);
        _book.getUndoManager().enable(true);
        _book.setSkipListeners(false);
    }

    public static void importExcel2007(Map parameter) {
        if (parameter == null || parameter.isEmpty()) {
            return;
        }
        Book _book = (Book)parameter.get("IMPORT_BOOK");
        Sheet _sheet = null;
        Cell _cell = null;
        KDSBook _kdsBook = (KDSBook)parameter.get("IMPORT_KDSBOOK");
        KDSSheet _kdsSheet = null;
        KDSCell _kdsCell = null;
        Object _obj = null;
        String _formulaStr = null;
        String _expression = null;
        String[] _parameter = null;
        BigDecimal _coefficient = (BigDecimal)parameter.get("IMPORT_COEFFICIENT");
        BigDecimal _tmpCoefficient = null;
        BigDecimal _value = null;
        Map _muMap = (Map)parameter.get("IMPORT_MEASUREUNIT");
        Map _formulaMap = (Map)parameter.get("IMPORT_BGFORMULA");
        boolean _hasData = (Boolean)parameter.get("IMPORT_DATA");
        boolean _autoCal = _book.isAutoCalculate();
        _book.setCalculate(false);
        _book.getUndoManager().enable(false);
        _book.setSkipListeners(true);
        if (_book == null || _kdsBook == null) {
            return;
        }
        int _sheetIndex = 0;
        int _sheetSize = _book.getSheetCount();
        for (_sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
            _kdsSheet = _kdsBook.getSheet((Object)new Integer(_sheetIndex));
            _sheet = _book.getSheet(_sheetIndex);
            if (_kdsSheet == null || _sheet == null) continue;
            int _rowCount = _kdsSheet.getExpandedRows() + 1;
            int _colCount = _kdsSheet.getExpandedColumns() + 1;
            for (int _rowIndex = 0; _rowIndex <= _rowCount; ++_rowIndex) {
                for (int _colIndex = 0; _colIndex <= _colCount; ++_colIndex) {
                    _kdsCell = _kdsSheet.getCell(_rowIndex, _colIndex, false);
                    boolean isCreate = _sheet.getCell(_rowIndex, _colIndex, false) == null;
                    _cell = _sheet.getCell(_rowIndex, _colIndex, true);
                    if (_cell.isLocked()) continue;
                    if (!StringUtils.isEmpty((String)_kdsCell.getFormula())) {
                        _expression = _kdsCell.getFormula();
                        if (_expression.charAt(0) != '=') {
                            _expression = "=" + _expression;
                        }
                        BgNFSHelper.setExpression(_cell, _expression);
                    }
                    if (_kdsCell != null && _kdsCell.getValue() != null) {
                        _obj = _kdsCell.getValue();
                        if (_obj instanceof String && StringUtils.isEmpty((String)_obj.toString())) continue;
                        if (_hasData) {
                            _tmpCoefficient = _coefficient;
                            if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
                                _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                                if (_muMap != null && !_muMap.isEmpty() && _muMap.containsKey((_parameter = BgNFSHelper.parseFormulaPara(_formulaMap, _formulaStr))[2])) {
                                    _tmpCoefficient = (BigDecimal)_muMap.get(_parameter[2]);
                                }
                                if (BgNFSHelper.checkIsNumeric(_kdsCell.getValue())) {
                                    try {
                                        _value = new BigDecimal(_kdsCell.getValue().toString().replaceAll(",", ""));
                                    }
                                    catch (Exception ex) {
                                        _value = BgNConstants.ZERO;
                                    }
                                    _value = BgNFCHelper.setHasPercentage(_cell, _kdsCell, _value, _tmpCoefficient, true);
                                    BgNFSHelper.setValue(_cell, _value);
                                } else {
                                    BgNFSHelper.setValue(_cell, BgNConstants.ZERO);
                                }
                            } else if (BgNFSHelper.checkHasGatFormulaOfCell(_cell)) {
                                _formulaStr = BgNFSHelper.getGatFormulaOfCell(_cell);
                                if (_muMap != null && !_muMap.isEmpty() && _muMap.containsKey((_parameter = BgNFSHelper.parseFormulaPara(_formulaMap, _formulaStr))[2])) {
                                    _tmpCoefficient = (BigDecimal)_muMap.get(_parameter[2]);
                                }
                                if (BgNFSHelper.checkIsNumeric(_kdsCell.getValue())) {
                                    try {
                                        _value = new BigDecimal(_kdsCell.getValue().toString().replaceAll(",", ""));
                                    }
                                    catch (Exception ex) {
                                        _value = BgNConstants.ZERO;
                                    }
                                    _value = BgNFCHelper.setHasPercentage(_cell, _kdsCell, _value, _tmpCoefficient, true);
                                    BgNFSHelper.setValue(_cell, _value);
                                } else {
                                    BgNFSHelper.setValue(_cell, BgNConstants.ZERO);
                                }
                            } else if (BgNFSHelper.checkHasExpression(_cell)) {
                                BgNFCHelper.importExpressionValue(_cell, _obj, _tmpCoefficient, _muMap);
                            } else if (BgNFSHelper.checkHasBgItemInfo(_cell) || BgNFSHelper.checkHasBgElementInfo(_cell) || BgNFSHelper.checkHasBgPeriodInfo(_cell) || BgNFSHelper.checkHasCurrencyInfo(_cell)) {
                                BgNFSHelper.setNumberFormat(_cell, "@");
                                BgNFSHelper.setValue(_cell, _kdsCell.getValue().toString());
                            } else if (BgNFSHelper.checkHasNumbericOfCell(_cell) && !BgNFSHelper.checkHasTextOfCell(_cell)) {
                                if (BgNFSHelper.checkIsNumeric(_kdsCell.getValue())) {
                                    try {
                                        _value = new BigDecimal(_kdsCell.getValue().toString().replaceAll(",", ""));
                                    }
                                    catch (Exception ex) {
                                        _value = BgNConstants.ZERO;
                                    }
                                    _value = BgNFCHelper.setHasPercentage(_cell, _kdsCell, _value, _tmpCoefficient, true);
                                    BgNFSHelper.setValue(_cell, _value);
                                } else {
                                    BgNFSHelper.setValue(_cell, _kdsCell.getValue());
                                }
                            } else {
                                String _kdscellFormat = _kdsCell.getSSA().getNumberFormat();
                                if (_kdscellFormat != null && _kdscellFormat.indexOf("%") != -1) {
                                    try {
                                        _value = new BigDecimal(_kdsCell.getValue().toString().replaceAll(",", ""));
                                    }
                                    catch (Exception ex) {
                                        _value = BgNConstants.ZERO;
                                    }
                                    BgNFCHelper.setHasPercentage(_cell, _kdsCell, _value, _tmpCoefficient, false);
                                    BgNFSHelper.setValue(_cell, _value);
                                } else {
                                    BgNFSHelper.setValue(_cell, _kdsCell.getValue());
                                }
                            }
                        } else {
                            BgNFCHelper.setHasPercentage(_cell, _kdsCell, _value, _tmpCoefficient, false);
                            if (BgNFSHelper.checkIsNumeric(_kdsCell.getValue())) {
                                try {
                                    _value = new BigDecimal(_kdsCell.getValue().toString().replaceAll(",", ""));
                                }
                                catch (Exception ex) {
                                    _value = BgNConstants.ZERO;
                                }
                                BgNFSHelper.setValue(_cell, _value);
                            } else {
                                BgNFSHelper.setValue(_cell, _kdsCell.getValue());
                            }
                        }
                    }
                    if (!isCreate || BgNFSHelper.checkIsEmptyCell(_cell)) continue;
                    BgNFSHelper.setCellData(_cell, "USER_EIDT", Boolean.TRUE.toString());
                }
            }
        }
        _book.updatePendingSheet();
        _book.clearEmptyCells();
        _book.setCalculate(_autoCal);
        _book.getUndoManager().enable(true);
        _book.setSkipListeners(false);
    }

    private static BigDecimal setHasPercentage(Cell _cell, KDSCell _kdsCell, BigDecimal _value, BigDecimal _tmpCoefficient, boolean hasMultiply) {
        String kdscellFormat = _kdsCell.getSSA().getNumberFormat();
        if (hasMultiply) {
            if (kdscellFormat != null && kdscellFormat.indexOf("%") != -1) {
                BgNFSHelper.setNumberFormat(_cell, kdscellFormat);
            } else {
                _value = _value.multiply(_tmpCoefficient);
            }
        } else if (kdscellFormat != null && kdscellFormat.indexOf("%") != -1) {
            BgNFSHelper.setNumberFormat(_cell, kdscellFormat);
        }
        return _value;
    }

    private static void importExpressionValue(Cell cell, Object obj, BigDecimal coefficient, Map muMap) {
        if (cell == null || obj == null) {
            return;
        }
        String _expressions = cell.getFormula();
        Expression _expression = null;
        try {
            _expression = ExcelFormulaPaserHelper.parse((String)_expressions);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean re = BgNFCHelper.importExpressionValue(cell, obj, _expression, coefficient, muMap);
        if (!re) {
            Object _obj = obj;
            BigDecimal _value = null;
            if (_obj instanceof BigDecimal) {
                _value = (BigDecimal)_obj;
                _value = _value.divide(coefficient, 8, 4);
            } else {
                try {
                    _value = new BigDecimal(_obj.toString().replaceAll(",", ""));
                    _value = _value.divide(coefficient, 8, 4);
                }
                catch (Exception ex) {
                    BgNFSHelper.setValue(cell, _obj);
                }
            }
        }
    }

    private static boolean importExpressionValue(Cell cell, Object obj, Expression expression, BigDecimal coefficient, Map muMap) {
        boolean re = false;
        if (expression instanceof FunctionExpr) {
            String _funcionName = ((FunctionExpr)expression).funcionName;
            if ("bgformula".equalsIgnoreCase(_funcionName) || "bgactuals".equalsIgnoreCase(_funcionName) || "bgbal".equalsIgnoreCase(_funcionName)) {
                Object _obj;
                StringExpr _bgelement = (StringExpr)((FunctionExpr)expression).parameters.get(2);
                BigDecimal _coefficient = coefficient;
                BigDecimal _value = null;
                if (muMap.containsKey(_bgelement.value)) {
                    _coefficient = (BigDecimal)muMap.get(_bgelement.value);
                }
                if ((_obj = obj) instanceof BigDecimal) {
                    _value = (BigDecimal)_obj;
                    _value = _value.multiply(_coefficient);
                    BgNFSHelper.setValue(cell, _value);
                } else {
                    try {
                        _value = new BigDecimal(_obj.toString().replaceAll(",", ""));
                        _value = _value.multiply(_coefficient);
                        BgNFSHelper.setValue(cell, _value);
                    }
                    catch (Exception ex) {
                        BgNFSHelper.setValue(cell, _obj);
                    }
                }
                re = true;
            }
        } else if (expression instanceof BinaryOperationExpr && !(re = BgNFCHelper.importExpressionValue(cell, obj, ((BinaryOperationExpr)expression).left, coefficient, muMap))) {
            re = BgNFCHelper.importExpressionValue(cell, obj, ((BinaryOperationExpr)expression).right, coefficient, muMap);
        }
        return re;
    }

    public static Book importExcelWithTemplate(Map parameter) throws Exception {
        if (parameter == null || parameter.isEmpty()) {
            return null;
        }
        String excelImportTpye = (String)parameter.get("ExcelImportType");
        Book _book = (Book)parameter.get("IMPORT_BOOK");
        Sheet _sheet = null;
        Cell _cell = null;
        KDSBook _kdsBook = (KDSBook)parameter.get("IMPORT_KDSBOOK");
        KDSSheet _kdsSheet = null;
        KDSCell _kdsCell = null;
        Object _obj = null;
        String _expression = null;
        BigDecimal _value = null;
        boolean _autoCal = _book.isAutoCalculate();
        _book.setCalculate(false);
        _book.getUndoManager().enable(false);
        _book.setSkipListeners(true);
        if (_book == null || _kdsBook == null) {
            return null;
        }
        int _sheetIndex = 0;
        int _sheetSize = _book.getSheetCount();
        for (_sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
            _kdsSheet = _kdsBook.getSheet((Object)new Integer(_sheetIndex));
            _sheet = _book.getSheet(_sheetIndex);
            if (_kdsSheet == null || _sheet == null) continue;
            int _rowCount = _kdsSheet.getRowCount();
            int _colCount = _kdsSheet.getColumnCount();
            for (int _rowIndex = 0; _rowIndex <= _rowCount; ++_rowIndex) {
                for (int _colIndex = 0; _colIndex <= _colCount; ++_colIndex) {
                    _kdsCell = _kdsSheet.getCell(_rowIndex, _colIndex, false);
                    _cell = _sheet.getCell(_rowIndex, _colIndex, true);
                    if (!StringUtils.isEmpty((String)BgNFSHelper.getFormulaOfCell(_cell))) {
                        BgNFSHelper.clearFormulaOfCell(_cell);
                    }
                    if (!StringUtils.isEmpty((String)_cell.getFormula())) {
                        BgNFSHelper.clearExpression(_cell);
                    }
                    if (!excelImportTpye.equals("Number") && !StringUtils.isEmpty((String)_kdsCell.getFormula())) {
                        _expression = _kdsCell.getFormula();
                        if (_expression.charAt(0) != '=') {
                            _expression = "=" + _expression;
                        }
                        BgNFSHelper.setExpression(_cell, _expression);
                    }
                    if (excelImportTpye.equals("Famula") || _kdsCell == null || _kdsCell.getValue() == null) continue;
                    _obj = _kdsCell.getValue();
                    if (BgNFSHelper.checkIsNumeric(_kdsCell.getValue())) {
                        try {
                            _value = new BigDecimal(_kdsCell.getValue().toString().replaceAll(",", ""));
                        }
                        catch (Exception ex) {
                            _value = BgNConstants.ZERO;
                        }
                        BgNFSHelper.setValue(_cell, _value);
                        continue;
                    }
                    BgNFSHelper.setValue(_cell, _kdsCell.getValue());
                }
            }
        }
        _book.updatePendingSheet();
        _book.clearEmptyCells();
        _book.setCalculate(_autoCal);
        _book.getUndoManager().enable(true);
        _book.setSkipListeners(false);
        return _book;
    }

    public static Book importXmlWithTemplate(Map parameter) throws Exception {
        if (parameter == null || parameter.isEmpty()) {
            return null;
        }
        String excelImportTpye = (String)parameter.get("ExcelImportType");
        Book _book = (Book)parameter.get("IMPORT_BOOK");
        if (_book == null) {
            return null;
        }
        Sheet _sheet = null;
        Object _cell = null;
        Object _obj = null;
        Object _expression = null;
        Object _value = null;
        boolean _autoCal = _book.isAutoCalculate();
        HashMap<String, String> bgItemFaumaMap = new HashMap<String, String>();
        HashMap<String, String> bgProideFaumaMap = new HashMap<String, String>();
        HashMap<String, String> bgElementFaumaMap = new HashMap<String, String>();
        HashMap<String, String> bgCurryFaumaMap = new HashMap<String, String>();
        _book.setCalculate(false);
        _book.getUndoManager().enable(false);
        _book.setSkipListeners(true);
        int _sheetIndex = 0;
        int _sheetSize = _book.getSheetCount();
        Object param = null;
        for (_sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
            _sheet = _book.getSheet(_sheetIndex);
            if (_sheet == null) continue;
            Sheet.ICellsIterator it = _sheet.getCellsIterator(null, false, false);
            while (it.hasNext()) {
                Cell cell = it.next();
                String formula = cell.getFormula();
                if (!StringUtils.isEmpty((String)BgNFSHelper.getFormulaOfCell(cell))) {
                    String formulaLine = BgNFSHelper.getFormulaOfCell(cell);
                    String[] params = BgNFSHelper.parseFormulaPara(new HashMap(), formulaLine);
                    bgItemFaumaMap.put("bgItem", params[0]);
                    if (!BgPeriodNVariableHelper.checkCanConvert((String)params[1])) {
                        bgProideFaumaMap.put("bgProide", params[1]);
                    }
                    bgElementFaumaMap.put("bgElement", params[2]);
                    if (params.length == 4) {
                        bgCurryFaumaMap.put("Curry", params[3]);
                    } else if (params.length == 6) {
                        bgCurryFaumaMap.put("Curry", params[5]);
                    }
                }
                if (formula == null || formula.length() <= 0 || formula.charAt(0) != '=') continue;
                if (excelImportTpye.equals("Famula")) {
                    cell.setValue(Variant.nullVariant);
                    cell.setFormula(formula);
                    continue;
                }
                if (!excelImportTpye.equals("Number")) continue;
                cell.removeUserObject("CELL_DATA");
                if (!BgNFSHelper.checkIsNumeric(cell.getValue())) {
                    BgNFSHelper.clearExpression(cell);
                }
                Variant value = cell.getValue();
                cell.setFormula(null);
                cell.setValue(value);
            }
        }
        if (!BgTemplateFacadeFactory.getRemoteInstance().checkHasItem(bgItemFaumaMap)) {
            throw new BgNTemplateException(BgNTemplateException.ITEMFORMUL_RE_EXIT, new String[]{EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"69_BgNFCHelper")});
        }
        if (!BgTemplateFacadeFactory.getRemoteInstance().checkHasProide(bgProideFaumaMap)) {
            throw new BgNTemplateException(BgNTemplateException.ITEMFORMUL_RE_EXIT, new String[]{EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"70_BgNFCHelper")});
        }
        if (!BgTemplateFacadeFactory.getRemoteInstance().checkHasElement(bgElementFaumaMap)) {
            throw new BgNTemplateException(BgNTemplateException.ITEMFORMUL_RE_EXIT, new String[]{EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"71_BgNFCHelper")});
        }
        if (!BgTemplateFacadeFactory.getRemoteInstance().checkHasCurry(bgCurryFaumaMap)) {
            throw new BgNTemplateException(BgNTemplateException.ITEMFORMUL_RE_EXIT, new String[]{EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"72_BgNFCHelper")});
        }
        _book.updatePendingSheet();
        _book.clearEmptyCells();
        _book.setCalculate(_autoCal);
        _book.getUndoManager().enable(true);
        _book.setSkipListeners(false);
        return _book;
    }

    public static boolean isRootTemplate(String templateId) throws BOSException {
        if (templateId == null || "".equals(templateId)) {
            return false;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)templateId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("rootId", (Object)templateId, CompareType.EQUALS));
        view.setFilter(filter);
        BgTemplateCollection coll = BgTemplateFactory.getRemoteInstance().getBgTemplateCollection(view);
        return coll != null && coll.size() > 0;
    }

    public static void exportBookContent(String _filename, Map _parameter, FileFilter fileFilter) throws Exception {
        if (StringUtils.isEmpty((String)_filename) || _parameter == null || _parameter.isEmpty()) {
            throw new BgNFormException(BgNFormException.FILEEXPORTERROR);
        }
        if (fileFilter instanceof ExcelFileFilter) {
            KDSBook _kdsBook = BgNFCHelper.exportExcel(_parameter);
            for (int i = 0; i < _kdsBook.getSheetCount(); ++i) {
                _kdsBook.getSheet((Object)i).setProtection(null);
            }
            ExportManager em = new ExportManager();
            em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"true");
            em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
            em.exportToExcel(_kdsBook, _filename);
        } else if (fileFilter instanceof Excel2007FileFilter) {
            Book _book = BgNFCHelper.exportExcel2007(_parameter);
            BgNFSHelper.stopBookProtection(_book);
            int sheetSize = _book.getSheetCount();
            for (int sheetIndex = sheetSize - 1; sheetIndex >= 0; --sheetIndex) {
                BgNFSHelper.stopSheetProtection(_book.getSheet(sheetIndex).getSheetOption());
            }
            BookDataWrapper bookDataWrapper = new BookDataWrapper(_book);
            bookDataWrapper.setExportFormula(true);
            bookDataWrapper.setExportCustomerFomulas(false);
            bookDataWrapper.setShowValue(true);
            bookDataWrapper.setExportHideCols(true);
            bookDataWrapper.setExportHideRows(true);
            SXSSFExportWrapper booksc = new SXSSFExportWrapper((AbstractDataWrapper)bookDataWrapper);
            booksc.write(_filename);
        }
    }

    public static void importExcel(Map parameter, FileFilter filter) {
        if (parameter == null || parameter.isEmpty()) {
            return;
        }
        boolean isExcel2003 = true;
        if (filter != null && filter instanceof Excel2007FileFilter) {
            isExcel2003 = false;
        }
        Book _book = (Book)parameter.get("IMPORT_BOOK");
        Sheet _sheet = null;
        Cell _cell = null;
        KDSBook _kdsBook = (KDSBook)parameter.get("IMPORT_KDSBOOK");
        KDSSheet _kdsSheet = null;
        KDSCell _kdsCell = null;
        Object _obj = null;
        String _formulaStr = null;
        String _expression = null;
        String[] _parameter = null;
        BigDecimal _coefficient = (BigDecimal)parameter.get("IMPORT_COEFFICIENT");
        BigDecimal _tmpCoefficient = null;
        BigDecimal _value = null;
        Map _muMap = (Map)parameter.get("IMPORT_MEASUREUNIT");
        Map _formulaMap = (Map)parameter.get("IMPORT_BGFORMULA");
        boolean _hasData = (Boolean)parameter.get("IMPORT_DATA");
        boolean _autoCal = _book.isAutoCalculate();
        _book.setCalculate(false);
        _book.getUndoManager().enable(false);
        _book.setSkipListeners(true);
        if (_book == null || _kdsBook == null) {
            return;
        }
        int _sheetIndex = 0;
        int _sheetSize = _book.getSheetCount();
        for (_sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
            _kdsSheet = _kdsBook.getSheet((Object)new Integer(_sheetIndex));
            _sheet = _book.getSheet(_sheetIndex);
            if (_kdsSheet == null || _sheet == null) continue;
            int _rowCount = isExcel2003 ? _kdsSheet.getRowCount() : _kdsSheet.getExpandedRows() + 1;
            int _colCount = isExcel2003 ? _kdsSheet.getColumnCount() : _kdsSheet.getExpandedColumns() + 1;
            for (int _rowIndex = 0; _rowIndex <= _rowCount; ++_rowIndex) {
                for (int _colIndex = 0; _colIndex <= _colCount; ++_colIndex) {
                    _kdsCell = _kdsSheet.getCell(_rowIndex, _colIndex, false);
                    boolean isCreate = _sheet.getCell(_rowIndex, _colIndex, false) == null;
                    _cell = _sheet.getCell(_rowIndex, _colIndex, true);
                    if (_cell.isLocked()) continue;
                    if (!StringUtils.isEmpty((String)_kdsCell.getFormula())) {
                        _expression = _kdsCell.getFormula();
                        if (_expression.charAt(0) != '=') {
                            _expression = "=" + _expression;
                        }
                        BgNFSHelper.setExpression(_cell, _expression);
                    }
                    if (_kdsCell != null && _kdsCell.getValue() != null) {
                        _obj = _kdsCell.getValue();
                        if (_obj instanceof String && StringUtils.isEmpty((String)_obj.toString())) continue;
                        if (_hasData) {
                            _tmpCoefficient = _coefficient;
                            if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
                                _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                                if (_muMap != null && !_muMap.isEmpty() && _muMap.containsKey((_parameter = BgNFSHelper.parseFormulaPara(_formulaMap, _formulaStr))[2])) {
                                    _tmpCoefficient = (BigDecimal)_muMap.get(_parameter[2]);
                                }
                                if (BgNFSHelper.checkIsNumeric(_kdsCell.getValue())) {
                                    try {
                                        _value = new BigDecimal(_kdsCell.getValue().toString().replaceAll(",", ""));
                                    }
                                    catch (Exception ex) {
                                        _value = BgNConstants.ZERO;
                                    }
                                    _value = BgNFCHelper.setHasPercentage(_cell, _kdsCell, _value, _tmpCoefficient, true);
                                    BgNFSHelper.setValue(_cell, _value);
                                } else {
                                    BgNFSHelper.setValue(_cell, BgNConstants.ZERO);
                                }
                            } else if (BgNFSHelper.checkHasGatFormulaOfCell(_cell)) {
                                _formulaStr = BgNFSHelper.getGatFormulaOfCell(_cell);
                                if (_muMap != null && !_muMap.isEmpty() && _muMap.containsKey((_parameter = BgNFSHelper.parseFormulaPara(_formulaMap, _formulaStr))[2])) {
                                    _tmpCoefficient = (BigDecimal)_muMap.get(_parameter[2]);
                                }
                                if (BgNFSHelper.checkIsNumeric(_kdsCell.getValue())) {
                                    try {
                                        _value = new BigDecimal(_kdsCell.getValue().toString().replaceAll(",", ""));
                                    }
                                    catch (Exception ex) {
                                        _value = BgNConstants.ZERO;
                                    }
                                    _value = BgNFCHelper.setHasPercentage(_cell, _kdsCell, _value, _tmpCoefficient, true);
                                    BgNFSHelper.setValue(_cell, _value);
                                } else {
                                    BgNFSHelper.setValue(_cell, BgNConstants.ZERO);
                                }
                            } else if (BgNFSHelper.checkHasExpression(_cell)) {
                                BgNFCHelper.importExpressionValue(_cell, _obj, _tmpCoefficient, _muMap);
                            } else if (BgNFSHelper.checkHasBgItemInfo(_cell) || BgNFSHelper.checkHasBgElementInfo(_cell) || BgNFSHelper.checkHasBgPeriodInfo(_cell) || BgNFSHelper.checkHasCurrencyInfo(_cell)) {
                                BgNFSHelper.setNumberFormat(_cell, "@");
                                BgNFSHelper.setValue(_cell, _kdsCell.getValue().toString());
                            } else if (BgNFSHelper.checkHasNumbericOfCell(_cell) && !BgNFSHelper.checkHasTextOfCell(_cell)) {
                                if (BgNFSHelper.checkIsNumeric(_kdsCell.getValue())) {
                                    try {
                                        _value = new BigDecimal(_kdsCell.getValue().toString().replaceAll(",", ""));
                                    }
                                    catch (Exception ex) {
                                        _value = BgNConstants.ZERO;
                                    }
                                    _value = BgNFCHelper.setHasPercentage(_cell, _kdsCell, _value, _tmpCoefficient, true);
                                    BgNFSHelper.setValue(_cell, _value);
                                } else {
                                    BgNFSHelper.setValue(_cell, _kdsCell.getValue());
                                }
                            } else {
                                String _kdscellFormat = _kdsCell.getSSA().getNumberFormat();
                                if (_kdscellFormat != null && _kdscellFormat.indexOf("%") != -1) {
                                    try {
                                        _value = new BigDecimal(_kdsCell.getValue().toString().replaceAll(",", ""));
                                    }
                                    catch (Exception ex) {
                                        _value = BgNConstants.ZERO;
                                    }
                                    BgNFCHelper.setHasPercentage(_cell, _kdsCell, _value, _tmpCoefficient, false);
                                    BgNFSHelper.setValue(_cell, _value);
                                } else {
                                    BgNFSHelper.setValue(_cell, _kdsCell.getValue());
                                }
                            }
                        } else {
                            BgNFCHelper.setHasPercentage(_cell, _kdsCell, _value, _tmpCoefficient, false);
                            if (BgNFSHelper.checkIsNumeric(_kdsCell.getValue())) {
                                try {
                                    _value = new BigDecimal(_kdsCell.getValue().toString().replaceAll(",", ""));
                                }
                                catch (Exception ex) {
                                    _value = BgNConstants.ZERO;
                                }
                                BgNFSHelper.setValue(_cell, _value);
                            } else {
                                BgNFSHelper.setValue(_cell, _kdsCell.getValue());
                            }
                        }
                    }
                    if (!isCreate || BgNFSHelper.checkIsEmptyCell(_cell)) continue;
                    BgNFSHelper.setCellData(_cell, "USER_EIDT", Boolean.TRUE.toString());
                }
            }
        }
        _book.updatePendingSheet();
        _book.clearEmptyCells();
        _book.setCalculate(_autoCal);
        _book.getUndoManager().enable(true);
        _book.setSkipListeners(false);
    }

    public static boolean verifyIsNumber(String value) {
        boolean result = true;
        try {
            new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            result = false;
        }
        return result;
    }

    public static Frame getFrameAncestor(Component c) {
        for (Component p = c; p != null; p = p.getParent()) {
            if (!(p instanceof Frame)) continue;
            return (Frame)p;
        }
        return null;
    }

    public static Book copyBook2007(Book book) {
        Book _book = Book.Manager.getNewBook(null, (int)book.getSheetCount());
        BgNFSHelper.disableCal(_book);
        BgNFSHelper.disableUndo(_book);
        if (book.getCellActionAfterListener() instanceof MeasureUnitCellActionAfterListener) {
            MeasureUnitCellActionAfterListener listener = (MeasureUnitCellActionAfterListener)book.getCellActionAfterListener();
            if (listener != null) {
                book.setCellActionAfterListener(null);
            }
            int sheetSize = book.getSheetCount();
            for (int sheetIndex = sheetSize - 1; sheetIndex >= 0; --sheetIndex) {
                _book.getSheet(sheetIndex).copySheetFrom(book.getSheet(sheetIndex));
            }
            book.setCellActionAfterListener((CellActionAfterListener)listener);
        } else {
            int sheetSize = book.getSheetCount();
            for (int sheetIndex = sheetSize - 1; sheetIndex >= 0; --sheetIndex) {
                _book.getSheet(sheetIndex).copySheetFrom(book.getSheet(sheetIndex));
            }
        }
        return _book;
    }
}

