/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgAdjustException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormHelper;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgScriptCheckHelper;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.client.AssignSolutionUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgExamineViewUI;
import com.kingdee.eas.ma.budget.client.BgFormAuditIdeaListUI;
import com.kingdee.eas.ma.budget.client.BgFormPeriodEditUI;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.budget.client.BgSelectTransCurrWayUI;
import com.kingdee.eas.ma.budget.client.BgTransCurrencyFilter2UI;
import com.kingdee.eas.ma.budget.client.BgTransCurrencyFilterUI;
import com.kingdee.eas.ma.budget.client.BgTypeSelectorDialog;
import com.kingdee.eas.ma.budget.client.BgVersionUI;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgNFormAdjustListUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFormAdjustProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgNFormAuditProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.ma.view.client.BgReportViewAdjustAuditProcessUI;
import com.kingdee.eas.ma.view.client.BgReportViewAdjustProcessUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class BgNFormAdjustListUI
extends AbstractBgNFormAdjustListUI {
    private static final long serialVersionUID = -7307119952534428536L;
    private static final Logger logger = CoreUIObject.getLogger(BgNFormAdjustListUI.class);
    private CommonQueryDialog cqDialog = null;
    private BgFormPeriodEditUI filterUI = null;
    private Object _filterParam = null;
    private IMetaDataPK mainQueryPk = new MetaDataPK("com.kingdee.eas.ma.budget", "BgElementQuery");

    public BgNFormAdjustListUI() throws Exception {
        this.rbCurrOrgUnit.setSelected(true);
    }

    public boolean checkIsViewBudget() {
        BizEnumValueInfo templatType;
        int index = -1;
        IRow row = null;
        if (this.tblMain.getSelectManager() != null && this.tblMain.getSelectManager().getActiveRowIndex() >= 0) {
            index = this.tblMain.getSelectManager().getActiveRowIndex();
        }
        if (index >= 0 && (templatType = (BizEnumValueInfo)(row = this.tblMain.getRow(index)).getCell("bgTemplate.FormType").getValue()) != null) {
            int _formType = -1;
            _formType = templatType.getInt();
            if (4 == _formType) {
                return true;
            }
        }
        return false;
    }

    protected String getEditUIName() {
        if (this.getSelectedKeyValue() == null) {
            return BgNFormAdjustProcessUI.class.getName();
        }
        if (this.checkIsViewBudget()) {
            return BgReportViewAdjustProcessUI.class.getName();
        }
        return BgNFormAdjustProcessUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    protected IBgForm getBgFormInterface() throws Exception {
        return (IBgForm)this.getBizInterface();
    }

    public String getPermissionNum() {
        return "bg_formAdjust01_list";
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.comboxOrgType.setSelectedItem((Object)OrgViewType.COSTCENTER);
        this.comboxOrgType.setEnabled(false);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getGroupManager().group();
        this.setButtonBySelectRow();
        if (this.isHasFodian()) {
            this.tblMain.getColumn("executeState").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("executeState").getStyleAttributes().setHided(true);
        }
        if (this.rbImmOrgUnit.isSelected() || this.rbAllOrgUnit.isSelected()) {
            this.tblMain.getColumn("orgUnit.name").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("orgUnit.name").getStyleAttributes().setHided(true);
        }
        BgPeriodDialog dialog = new BgPeriodDialog();
        this.prmtBgPeriodBegin.setSelector((KDPromptSelector)dialog);
        this.prmtBgPeriodEnd.setSelector((KDPromptSelector)dialog);
        this.prmtBgType.setSelector((KDPromptSelector)new BgTypeSelectorDialog());
        String strKey = "CTRL_SHIFT_O";
        KeyStroke ks = KeyStroke.getKeyStroke(79, 192, false);
        this.getActionMap().put(strKey, (Action)((Object)this.actionGather));
        this.getInputMap(2).put(ks, strKey);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnReferWork.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnFormAdjust.setIcon(EASResource.getIcon((String)"imgTbtn_budgetadjust"));
        this.btnGather.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.btnFormHistory.setIcon(EASResource.getIcon((String)"imgTbtn_historyedition"));
        this.btnPeriodTrans.setIcon(EASResource.getIcon((String)"imgTbtn_courseweave"));
        this.btnCurrencyTrans.setIcon(EASResource.getIcon((String)"imgTbtn_currencyconversion"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.menuItemReferWork.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.menuItemFormAdjust.setIcon(EASResource.getIcon((String)"imgTbtn_budgetadjust"));
        this.menuItemGather.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.menuItemFormHistory.setIcon(EASResource.getIcon((String)"imgTbtn_historyedition"));
        this.menuItemPeriodTrans.setIcon(EASResource.getIcon((String)"imgTbtn_courseweave"));
        this.menuItemCurrencyTrans.setIcon(EASResource.getIcon((String)"imgTbtn_currencyconversion"));
        this.menuItemEdit.setMnemonic(69);
        if (BgParamCHelper.isStartBasisApproved()) {
            this.actionAudit.setEnabled(true);
            this.btnAudit.setEnabled(true);
            this.btnAudit.setVisible(true);
            this.menuItemAudit.setEnabled(true);
            this.menuItemAudit.setVisible(true);
        } else {
            this.actionAudit.setEnabled(false);
            this.btnAudit.setEnabled(false);
            this.btnAudit.setVisible(false);
            this.menuItemAudit.setEnabled(false);
            this.menuItemAudit.setVisible(false);
        }
        this.btnViewAuditIdea.setIcon(EASResource.getIcon((String)"imgTbtn_multapproveresult"));
        this.btnViewAuditIdea.setEnabled(true);
    }

    private void setButtonBySelectRow() {
        this.actionView.setEnabled(true);
        this.actionEdit.setEnabled(true);
        this.actionRemove.setEnabled(false);
        this.actionFormAdjust.setEnabled(true);
        this.actionFormHistory.setEnabled(true);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"orgUnitInfo", (Object)this.getBGOrgUnitInfo());
        uiContext.put((Object)"OrgUnitCU", (Object)this.getBGOrgUnitInfo().getCU());
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor queryExecutor = null;
        FilterInfo filter = null;
        SorterItemCollection sortCol = new SorterItemCollection();
        if (!viewInfo.getSorter().isEmpty()) {
            sortCol.addObjectCollection((IObjectCollection)viewInfo.getSorter());
        }
        HashSet<Integer> state = new HashSet<Integer>();
        state.add(new Integer(4));
        state.add(new Integer(35));
        state.add(new Integer(2));
        Set orgUnitSet = null;
        if (this.rbImmOrgUnit.isSelected()) {
            filter = this.getImmSelectedQueryFilterInfo(viewInfo);
            orgUnitSet = this.getOrgSet(IMM_ORG);
        } else if (this.rbAllOrgUnit.isSelected()) {
            filter = this.getSelectedQueryFilterInfo(viewInfo);
            orgUnitSet = this.getOrgSet(ALL_ORG);
        } else {
            filter = this.getUnSelectedQueryFilterInfo(viewInfo);
            orgUnitSet = this.getOrgSet(CUR_ORG);
        }
        this.refreshFilter(filter);
        FilterItemInfo item = new FilterItemInfo("state".toLowerCase(), state, CompareType.INCLUDE);
        this.replaceFilterItems(filter, item);
        if (BgParamCHelper.isBgPermissionUsed()) {
            String userId = this.getUserInfo().getId().toString();
            filter = BgPermissionHelper.addBgFormPermission(userId, this.getPermissionOrg(), filter);
        }
        if (orgUnitSet != null && !orgUnitSet.isEmpty()) {
            HashSet<String> adjustSet = new HashSet<String>();
            HashSet<Integer> state1 = new HashSet<Integer>();
            state1.add(new Integer(4));
            state1.add(new Integer(35));
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitSet, CompareType.INCLUDE));
            filter1.getFilterItems().add(new FilterItemInfo("state", state1, CompareType.INCLUDE));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("adjust.id"));
            view.setSelector(selector);
            view.setFilter(filter1);
            try {
                CoreBaseCollection coll = this.getBizInterface().getCollection(view);
                if (coll != null && !coll.isEmpty()) {
                    BgFormInfo info = null;
                    for (int i = 0; i < coll.size(); ++i) {
                        info = (BgFormInfo)coll.get(i);
                        adjustSet.add(info.getAdjust().getId().toString());
                    }
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.toString());
            }
            catch (Exception e) {
                logger.error((Object)e.toString());
            }
            if (adjustSet != null && !adjustSet.isEmpty()) {
                filter.getFilterItems().add(new FilterItemInfo("id", adjustSet, CompareType.NOTINNER));
                if (!StringUtils.isEmpty((String)filter.getMaskString())) {
                    filter.setMaskString(filter.getMaskString() + " and #" + (filter.getFilterItems().size() - 1));
                }
            }
        }
        filter.getFilterItems().add(new FilterItemInfo("bgform.record", (Object)"0", CompareType.INNER));
        filter.setMaskString(filter.getMaskString() + " and #" + (filter.getFilterItems().size() - 1));
        HashSet<Integer> rollTypeSet = new HashSet<Integer>();
        rollTypeSet.add(2);
        rollTypeSet.add(1);
        filter.getFilterItems().add(new FilterItemInfo("entries.rollMethod", rollTypeSet, CompareType.NOTINCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("entries.rollMethod", null, CompareType.IS));
        int size = filter.getFilterItems().size() - 1;
        filter.setMaskString(filter.getMaskString() + " and (#" + (size - 1) + " or #" + size + ")");
        viewInfo.setFilter(filter);
        if (this.rbImmOrgUnit.isSelected() || this.rbAllOrgUnit.isSelected()) {
            this.tblMain.getColumn("orgUnit.name").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("orgUnit.name").getStyleAttributes().setHided(true);
        }
        if (this.isHasFodian()) {
            this.tblMain.getColumn("executeState").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("executeState").getStyleAttributes().setHided(true);
        }
        if (!sortCol.isEmpty()) {
            viewInfo.getSorter().clear();
            viewInfo.getSorter().addObjectCollection((IObjectCollection)sortCol);
        } else if (viewInfo.getSorter().isEmpty()) {
            viewInfo.getSorter().add(new SorterItemInfo("bgScheme.number"));
            viewInfo.getSorter().add(new SorterItemInfo("bgPeriod.number"));
            viewInfo.getSorter().add(new SorterItemInfo("bgItemGroup.number"));
            viewInfo.getSorter().add(new SorterItemInfo("bgItem.number"));
        }
        queryExecutor = super.getQueryExecutor(queryPK, viewInfo);
        return queryExecutor;
    }

    protected String getMessageStr(String key) {
        return this.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormAdjustResource", key);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.openReportView(e, this.getSelectedKeyValue(), null);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkOrgUnitDisable();
        this.checkIsOnCU(true);
        this.processAdjustOfBudgetForm(e);
    }

    @Override
    public void actionFormAdjust_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkOrgUnitDisable();
        this.checkIsOnCU(true);
        this.processAdjustOfBudgetForm(e);
    }

    @Override
    public void actionViewAuditIdea_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewAuditIdea_actionPerformed(e);
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BGFORM_ID", (Object)this.getSelectedKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getModel()).create(BgFormAuditIdeaListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected String getModel() {
        if (this.getUIWindow() instanceof Frame) {
            return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected void processAdjustOfBudgetForm(ActionEvent e) throws Exception {
        String bgFormId = this.getSelectedKeyValue();
        try {
            if (this.checkIsViewBudget()) {
                this.openReport(e, OprtState.EDIT, bgFormId, null, false);
            } else {
                Map resultMap = this.getFacadeInterface().adjustBgForm(BOSUuid.read((String)bgFormId));
                if (resultMap == null) {
                    return;
                }
                IObjectPK pk = (IObjectPK)resultMap.get("pk");
                Boolean isNewAdjustForm = (Boolean)resultMap.get("isNewAdjustForm");
                if (pk == null || isNewAdjustForm == null) {
                    return;
                }
                this.openReport(e, OprtState.EDIT, pk.toString(), null, isNewAdjustForm);
            }
        }
        catch (EASBizException ex) {
            logger.error((Object)this, (Throwable)ex);
            throw ex;
        }
        BgFormHelper.refreshBgFormList((CoreUI)this);
    }

    @Override
    public void actionFormHistory_actionPerformed(ActionEvent e) throws Exception {
        String adjustId;
        String bgFormId;
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null && row.getCell("adjust.id").getValue() != null && (bgFormId = BgVersionUI.showDialogWindow((Component)((Object)this), (String)(adjustId = row.getCell("adjust.id").getValue().toString()), null)) != null) {
            this.openReportView(e, bgFormId, "adjustHistory");
        }
    }

    private void openReportView(ActionEvent e, String bgFormId, String type) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        if (bgFormId == null) {
            uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        } else {
            uiContext.put((Object)"ID", (Object)bgFormId);
        }
        if (type != null) {
            uiContext.put((Object)"bgFormType", (Object)type);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private void openReport(ActionEvent e, String reportState, String id, String type, boolean isNewAdjustForm) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        if (id == null) {
            uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        } else {
            uiContext.put((Object)"ID", (Object)id);
        }
        if (isNewAdjustForm) {
            uiContext.put((Object)"isNewAdjustForm", (Object)isNewAdjustForm);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        this.checkSelected();
        this.checkIsOnCU(true);
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0 && (row = this.tblMain.getRow(rowIndex)) != null) {
            String id = this.getSelectedKeyValue();
            String number = row.getCell("number").getValue().toString();
            int re = MsgBox.showConfirm2((Component)((Object)this), (String)(this.getMessageStr("isRemove") + this.getMessageStr("number") + number + this.getMessageStr("budgetAdjustForm") + this.getMessageStr("interrogation")));
            if (re == 1 || re == 2) {
                return;
            }
            ArrayList<String> bgFormIds = new ArrayList<String>();
            bgFormIds.add(id);
            CtrlUnitInfo _ctrlUnit = SysContext.getSysContext().getCurrentCtrlUnit();
            this.getBgFormInterface().batchRemove(bgFormIds, _ctrlUnit.getId(), this.getUserInfo().getId());
            BgFormHelper.refreshBgFormList((CoreUI)this);
        }
    }

    @Override
    public void actionGather_actionPerformed(ActionEvent e) throws Exception {
        this.actionGather();
    }

    protected void prepareGatherContext(UIContext uiContext) {
        super.prepareGatherContext(uiContext);
        if (uiContext != null) {
            IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
            String _adjustId = row.getCell("adjust.id").getValue().toString();
            uiContext.put((Object)"GATHER_ADJ_FORM_ID", (Object)_adjustId);
        }
    }

    @Override
    public void actionReferWork_actionPerformed(ActionEvent e) throws Exception {
        int re;
        this.checkSelected();
        this.checkOrgUnitDisable();
        this.checkIsOnCU(true);
        if (BgFormHelper.checkInProInst((String)this.getSelectedKeyValue())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"bgFormInWorkNoSubmit"));
            SysUtil.abort();
        }
        if ((re = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"submitFormWork"))) == 1 || re == 2) {
            return;
        }
        IRow bgFormSelectRow = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        final String bgFormSubmitId = bgFormSelectRow.getCell("id").getValue().toString();
        final String bgFormExamineId = bgFormSelectRow.getCell("adjust.id").getValue().toString();
        if (!StringUtils.isEmpty((String)bgFormSubmitId)) {
            if (BgParamCHelper.isCompulsionReportCheck()) {
                boolean isExit = false;
                List check = this.getFormInterface().reportCheck(new BOSUuid[]{BOSUuid.read((String)bgFormSubmitId)});
                if (check.get(0).equals(Boolean.FALSE)) {
                    isExit = true;
                    UIContext uiContext = new UIContext((Object)this);
                    uiContext.put((Object)"String", (Object)check.get(3).toString());
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gr.cslrpt.client.ShowEditorPanelUI", (Map)uiContext, null, OprtState.VIEW, 16);
                    uiWindow.getUIObject().setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"ReportCheckError"));
                    uiWindow.show();
                }
                if (isExit) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"cantSubmitOfCheck"));
                    SysUtil.abort();
                }
            }
            if (this.getBgExamineInterface().canExamine(new BOSUuid[]{BOSUuid.read((String)bgFormExamineId)})) {
                LongTimeDialog dialog = null;
                final String xNum = BgNFCHelper.returnExamineX(new BOSUuid[]{BOSUuid.read((String)bgFormExamineId)}, (Object)this);
                Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
                dialog = win instanceof Frame ? new LongTimeDialog((Frame)win) : (win instanceof Dialog ? new LongTimeDialog((Dialog)win) : null);
                if (dialog != null) {
                    dialog.setLongTimeTask(new ILongTimeTask(){

                        public Object exec() throws Exception {
                            Object[] result = BgNFormAdjustListUI.this.getBgExamineInterface().examines(new BOSUuid[]{BOSUuid.read((String)bgFormExamineId)}, xNum);
                            HashMap<String, Object> bgExamineCheckMap = new HashMap<String, Object>();
                            bgExamineCheckMap.put("BgExamineChecked", result[0]);
                            bgExamineCheckMap.put("BgExamineCheckResult", result[1]);
                            return bgExamineCheckMap;
                        }

                        public void afterExec(Object result) throws Exception {
                            if (result != null && result instanceof HashMap) {
                                BgNFormAdjustListUI.this.openBgExamineViewUI(result);
                                Map bgExamineCheckMap = (Map)result;
                                Boolean bgExCheck = (Boolean)bgExamineCheckMap.get("BgExamineChecked");
                                if (bgExCheck.booleanValue()) {
                                    if (BgNFormAdjustListUI.this.getFacadeInterface().submitAdjustWork(BOSUuid.read((String)bgFormSubmitId))) {
                                        MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"budgetAdjustForm") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"submitToWork") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"pass") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"exclaim")));
                                    } else {
                                        MsgBox.showError((String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"budgetAdjustForm") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"submitToWork") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"nopass") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"exclaim")));
                                    }
                                    BgNFormAdjustListUI.this.tblMain.refresh();
                                } else {
                                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineCheckResource", (String)"cantsubmit"));
                                }
                            } else {
                                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineCheckResource", (String)"error"));
                            }
                        }
                    });
                    dialog.show();
                }
            } else {
                boolean ok = false;
                try {
                    ok = this.getFacadeInterface().submitAdjustWork(BOSUuid.read((String)bgFormSubmitId));
                }
                catch (BOSException exx) {
                    if (exx.getCause() instanceof BgAdjustException) {
                        MsgBox.showInfo((String)exx.getCause().getMessage());
                        SysUtil.abort();
                    }
                    throw exx;
                }
                if (ok) {
                    MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"budgetAdjustForm") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"submitToWork") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"pass") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"exclaim")));
                    this.tblMain.refresh();
                } else {
                    MsgBox.showError((String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"budgetAdjustForm") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"submitToWork") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"nopass") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"exclaim")));
                }
            }
        }
    }

    protected void openBgExamineViewUI(Object obj) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"EXAMINE_DATA", obj);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BgExamineViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionCurrencyTrans_actionPerformed(ActionEvent e) throws Exception {
        this.checkOrgUnitDisable();
        BgScriptCheckHelper.checkCanDo((Component)((Object)this), (String)"CurrencyTrans", (KDTable)this.tblMain);
        UIContext context = new UIContext((Object)this);
        IUIWindow uiSelect = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgSelectTransCurrWayUI.class.getName(), (Map)context, null, null);
        uiSelect.show();
        boolean isCancel = ((BgSelectTransCurrWayUI)uiSelect.getUIObject()).isCancel();
        int selectDimen = ((BgSelectTransCurrWayUI)uiSelect.getUIObject()).getSELECT_DIMEN();
        if (!isCancel) {
            if (selectDimen == 1) {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"BGFORM_ID", (Object)this.getSelectedKeyValue());
                uiContext.put((Object)"ORGUNIT_INFO", (Object)this.getOrgUnitInfo());
                uiContext.put((Object)"selfPanelUiName", (Object)BgTransCurrencyFilterUI.class.getName());
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AssignSolutionUI.class.getName(), (Map)uiContext);
                uiWindow.show();
            } else if (selectDimen == 2) {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"BGFORM_ID", (Object)this.getSelectedKeyValue());
                uiContext.put((Object)"ORGUNIT_INFO", (Object)this.getOrgUnitInfo());
                uiContext.put((Object)"selfPanelUiName", (Object)BgTransCurrencyFilter2UI.class.getName());
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AssignSolutionUI.class.getName(), (Map)uiContext);
                uiWindow.show();
            }
        }
    }

    @Override
    public void actionPeriodTrans_actionPerformed(ActionEvent e) throws Exception {
        this.checkOrgUnitDisable();
        this.cqDialog = this.getCommonQueryDialog();
        if (this.cqDialog.show()) {
            CustomerParams _cp = this.getFilterUI().getCustomerParams();
            this._filterParam = this.getFilterUI().getFilterObject(_cp);
            LongTimeDialog dialog = null;
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new LongTimeDialog((Dialog)win);
            }
            if (dialog == null) {
                return;
            }
            dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    List mutexList = BgNFormAdjustListUI.this.getBgFPEInterface().weave(BgNFormAdjustListUI.this._filterParam, true);
                    return mutexList;
                }

                public void afterExec(Object result) throws Exception {
                    List reList;
                    if (result != null && result instanceof List && (reList = (List)result) != null) {
                        int i;
                        int in;
                        StringBuffer message;
                        String bgFormName;
                        List mutexList = (List)reList.get(0);
                        List succeedList = (List)reList.get(1);
                        if (mutexList != null && !mutexList.isEmpty()) {
                            bgFormName = null;
                            message = new StringBuffer();
                            in = mutexList.size();
                            for (i = 0; i < in; ++i) {
                                bgFormName = (String)mutexList.get(i);
                                message.append(bgFormName + ",");
                            }
                            message.delete(message.length() - 1, message.length());
                            MsgBox.showWarning((String)(message.toString() + BgFormHelper.getMessage((String)"bgFormInfoMutex")));
                        }
                        if (succeedList != null && !succeedList.isEmpty()) {
                            bgFormName = null;
                            message = new StringBuffer();
                            in = succeedList.size();
                            for (i = 0; i < in; ++i) {
                                bgFormName = (String)succeedList.get(i);
                                message.append(bgFormName + ",");
                            }
                            message.delete(message.length() - 1, message.length());
                            MsgBox.showWarning((String)(message.toString() + BgFormHelper.getMessage((String)"bgFormPeriodSucceed")));
                        }
                    }
                }
            });
            dialog.show();
        }
    }

    protected CommonQueryDialog getCommonQueryDialog() throws Exception {
        if (this.cqDialog != null) {
            KDPanel panel = null;
            int in = this.cqDialog.getUserPanels().size();
            for (int i = 0; i < in; ++i) {
                panel = this.cqDialog.getUserPanel(i);
                if (panel == null || !(panel instanceof BgFormPeriodEditUI)) continue;
                ((BgFormPeriodEditUI)panel).restart(this.getOrgUnitInfo());
            }
            return this.cqDialog;
        }
        this.cqDialog = new CommonQueryDialog();
        this.cqDialog.setOwner((Component)((Object)this));
        this.cqDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.cqDialog.setEntityViewInfo(new EntityViewInfo());
        this.cqDialog.setQueryObjectPK(this.mainQueryPk);
        this.cqDialog.setTitle(this.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "bgFormPeriodEdit"));
        this.cqDialog.setWidth(800);
        this.cqDialog.setHeight(620);
        this.cqDialog.addUserPanel((KDPanel)this.getFilterUI());
        this.cqDialog.setShowFilter(false);
        this.cqDialog.setShowSorter(false);
        this.cqDialog.setDisVisiableDefaultView(false);
        return this.cqDialog;
    }

    protected BgFormPeriodEditUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new BgFormPeriodEditUI((Object)this, (Object)this.getOrgUnitInfo());
        }
        return this.filterUI;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        this.checkSelected();
        this.checkOrgUnitDisable();
        this.checkIsOnCU(true);
        String billId = this.getSelectedKeyValue();
        BgClientHelper.isMutex((Component)((Object)this), (String)billId, (String)this.getUserInfo().getId().toString());
        if (BgNFSHelper.checkInProInst(billId)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"bgFormInWorkNoAudit"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"BGFORM_AUDIT_TYPE", (Object)"BGFORM_AUDIT");
        IUIWindow uiWindow = null;
        String uiName = BgNFormAuditProcessUI.class.getName();
        if (this.checkIsViewBudget()) {
            uiName = BgReportViewAdjustAuditProcessUI.class.getName();
        }
        if ((uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(uiName, (Map)uiContext, null, OprtState.EDIT)) != null) {
            uiWindow.show();
        }
    }

    protected void treeOrgUnit_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeOrgUnit_valueChanged(e);
        EntityViewInfo view = null;
        FilterInfo filter = null;
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        FullOrgUnitInfo orgUnitInfo = this.getOrgUnitInfo(node);
        if (orgUnitInfo != null) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
            if (this.isHasFodian()) {
                filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(4), CompareType.NOTEQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(-1), CompareType.NOTEQUALS));
            }
            filter.setMaskString("#0 and #1");
            if (BgSHelper.isBgPermissionUsed()) {
                String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                Set<String> orgSet = new HashSet<String>();
                if (this.getPermissionOrg() != null) {
                    orgSet = this.getPermissionOrg();
                } else {
                    orgSet.add(orgUnitInfo.getId().toString());
                }
                filter = BgPermissionHelper.addBgSchemePermission(userId, orgSet, filter);
            }
            view.setFilter(filter);
            this.prmtBgScheme.setEntityViewInfo(view);
        }
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgScheme_dataChanged(e);
        this.refreshTable();
    }

    @Override
    protected void prmtBgType_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgType_dataChanged(e);
        this.refreshTable();
    }

    @Override
    protected void prmtBgPeriodBegin_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgPeriodBegin_dataChanged(e);
        this.verifyPeriod();
        this.refreshTable();
    }

    @Override
    protected void prmtBgPeriodEnd_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgPeriodEnd_dataChanged(e);
        this.verifyPeriod();
        this.refreshTable();
    }

    private void verifyPeriod() {
        if (this.prmtBgPeriodBegin.getData() != null && this.prmtBgPeriodBegin.getData() instanceof BgPeriodInfo && this.prmtBgPeriodEnd.getData() != null && this.prmtBgPeriodEnd.getData() instanceof BgPeriodInfo) {
            boolean bln;
            BgPeriodInfo beginPeriod = (BgPeriodInfo)this.prmtBgPeriodBegin.getData();
            BgPeriodInfo endPeriod = (BgPeriodInfo)this.prmtBgPeriodEnd.getData();
            if (!beginPeriod.getPeriodType().equals((Object)endPeriod.getPeriodType())) {
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "checkBgPeriodType"));
                SysUtil.abort();
            }
            if (!(bln = BgHelper.compareBgPeriodBegin2End((BgPeriodInfo)beginPeriod, (BgPeriodInfo)endPeriod))) {
                this.prmtBgPeriodEnd.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "checkBgPeriodOrder"));
                SysUtil.abort();
            }
        }
    }

    private void refreshTable() {
        FilterInfo _filter = new FilterInfo();
        this.refreshFilter(_filter);
        this.mainQuery.setFilter(_filter);
        try {
            this.execQuery();
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    private void refreshFilter(FilterInfo filter) {
        BgPeriodInfo _bgPeriodInfo;
        if (filter == null) {
            return;
        }
        Object obj = this.prmtBgScheme.getData();
        if (obj != null) {
            if (obj instanceof BgSchemeInfo) {
                BgSchemeInfo _bgSchemeInfo = (BgSchemeInfo)obj;
                this.replaceFilterItems(filter, new FilterItemInfo("bgScheme.number", (Object)_bgSchemeInfo.getNumber(), CompareType.EQUALS));
            } else if (obj instanceof String) {
                String _name = (String)obj;
                this.replaceFilterItems(filter, new FilterItemInfo("bgScheme.number", (Object)_name, CompareType.EQUALS));
            }
        }
        this.addBgTypeFilterItem(filter, this.prmtBgType.getValue());
        obj = this.prmtBgPeriodBegin.getData();
        if (obj != null && obj instanceof BgPeriodInfo) {
            _bgPeriodInfo = (BgPeriodInfo)obj;
            this.replaceFilterItems(filter, new FilterItemInfo("bgPeriod.beginDate", (Object)_bgPeriodInfo.getBeginDate(), CompareType.GREATER_EQUALS));
        }
        if ((obj = this.prmtBgPeriodEnd.getData()) != null && obj instanceof BgPeriodInfo) {
            _bgPeriodInfo = (BgPeriodInfo)obj;
            this.replaceFilterItems(filter, new FilterItemInfo("bgPeriod.endDate", (Object)_bgPeriodInfo.getEndDate(), CompareType.LESS_EQUALS));
        }
        if (this.prmtBgPeriodBegin.getData() != null || this.prmtBgPeriodEnd.getData() != null) {
            int bgPeriodType = 0;
            bgPeriodType = this.prmtBgPeriodBegin.getData() != null ? ((BgPeriodInfo)this.prmtBgPeriodBegin.getData()).getPeriodType().getValue() : ((BgPeriodInfo)this.prmtBgPeriodEnd.getValue()).getPeriodType().getValue();
            this.replaceFilterItems(filter, new FilterItemInfo("bgPeriod.periodType", (Object)new Integer(bgPeriodType), CompareType.EQUALS));
        }
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            // empty if block
        }
        return re;
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range == null || range.size() == 0) {
            return;
        }
        KDTSelectBlock select = (KDTSelectBlock)range.get(0);
        if (select == null) {
            return;
        }
        rowIndex = select.getBeginRow();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null) {
            BizEnumValueInfo state = (BizEnumValueInfo)row.getCell("state").getValue();
            BizEnumValueInfo dataSource = (BizEnumValueInfo)row.getCell("dataSource").getValue();
            BizEnumValueInfo formType = (BizEnumValueInfo)row.getCell("bgTemplate.FormType").getValue();
            if (formType.getInt() == 4) {
                this.btnCurrencyTrans.setEnabled(false);
                this.menuItemCurrencyTrans.setEnabled(false);
            } else {
                this.btnCurrencyTrans.setEnabled(true);
                this.menuItemCurrencyTrans.setEnabled(true);
            }
            int _state = state.getInt();
            int _source = dataSource.getInt();
            if (_state == 4) {
                this.setAdjustButtAndMenu();
            } else if (_state == 2) {
                this.setApprovedButtAndMenu();
            } else if (_state == 25 || _state == 35) {
                this.setReferringButtAndMenu(_source);
            }
        } else {
            this.setDisableButtAndMenu();
        }
    }

    protected void setDisableButtAndMenu() {
        this.setDisableAction((Action)((Object)this.actionAudit), (JButton)this.btnAudit, (JMenuItem)this.menuItemAudit);
        this.setDisableAction((Action)((Object)this.actionReferWork), (JButton)this.btnReferWork, (JMenuItem)this.menuItemReferWork);
        this.setDisableAction((Action)this.actionEdit, (JButton)this.btnEdit, (JMenuItem)this.menuItemEdit);
        this.setDisableAction((Action)this.actionRemove, (JButton)this.btnRemove, (JMenuItem)this.menuItemRemove);
        this.setDisableAction((Action)((Object)this.actionFormAdjust), (JButton)this.btnFormAdjust, (JMenuItem)this.menuItemFormAdjust);
        this.setDisableAction((Action)((Object)this.actionGather), (JButton)this.btnGather, (JMenuItem)this.menuItemGather);
    }

    protected void setAdjustButtAndMenu() {
        this.actionReferWork.setEnabled(true);
        this.actionEdit.setEnabled(true);
        this.actionRemove.setEnabled(true);
        this.actionFormAdjust.setEnabled(false);
        this.actionGather.setEnabled(true);
        this.btnReferWork.setEnabled(true);
        this.btnEdit.setEnabled(true);
        this.btnRemove.setEnabled(true);
        this.btnFormAdjust.setEnabled(false);
        this.btnGather.setEnabled(true);
        this.menuItemReferWork.setEnabled(true);
        this.menuItemEdit.setEnabled(true);
        this.menuItemRemove.setEnabled(true);
        this.menuItemFormAdjust.setEnabled(false);
        this.menuItemGather.setEnabled(true);
        if (BgParamCHelper.isStartBasisApproved()) {
            this.actionAudit.setEnabled(true);
            this.btnAudit.setEnabled(true);
            this.menuItemAudit.setEnabled(true);
        } else {
            this.actionAudit.setEnabled(false);
            this.btnAudit.setEnabled(false);
            this.menuItemAudit.setEnabled(false);
        }
    }

    protected void setApprovedButtAndMenu() {
        this.setDisableButtAndMenu();
        this.setEnableAction((Action)((Object)this.actionFormAdjust), (JButton)this.btnFormAdjust, (JMenuItem)this.menuItemFormAdjust);
    }

    protected void setReferringButtAndMenu(int dataSource) {
        this.setDisableButtAndMenu();
        this.setEnableAction((Action)((Object)this.actionReferWork), (JButton)this.btnReferWork, (JMenuItem)this.menuItemReferWork);
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        return super.prepareInit();
    }
}

