/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgMeasureUnitInfo;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.nbudget.BgNExpressionHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.client.BgCodeNumberCHelper;
import com.kingdee.eas.ma.nbudget.client.BgNEditUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgNFormEditUI
extends BgNEditUI {
    private static final long serialVersionUID = 7214772548630492085L;
    private static final Logger logger = CoreUIObject.getLogger(BgNFormEditUI.class);
    private boolean hasNameCode = false;
    private boolean isShowNameCode = false;

    public boolean isHasNameCode() {
        return this.hasNameCode;
    }

    public void setHasNameCode(boolean hasNameCode) {
        this.hasNameCode = hasNameCode;
    }

    public boolean isShowNameCode() {
        return this.isShowNameCode;
    }

    public void setShowNameCode(boolean isShowNameCode) {
        this.isShowNameCode = isShowNameCode;
    }

    @Override
    protected void loadData() throws Exception {
        super.loadData();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            String OUID = this.editData.getOrgUnit().getId().toString();
            boolean re = BgCodeNumberCHelper.hasCodeNumber((IObjectValue)this.editData, OUID, "sourceType", "name");
            this.setHasNameCode(re);
            if (this.isHasNameCode()) {
                re = BgCodeNumberCHelper.hasDisplayNumber((IObjectValue)this.editData, OUID, "sourceType", "name");
                this.setShowNameCode(re);
            }
            this.getNameCode();
        }
    }

    @Override
    protected void updateBgFormName() {
        super.updateBgFormName();
        this.getNameCode();
    }

    public void getNameCode() {
        if (this.isHasNameCode()) {
            this.txtName.setEnabled(false);
            if (OprtState.ADDNEW.equals(this.getCcOprtState()) && this.checkCreateName() && this.isShowNameCode()) {
                this.storeFields();
                BgCodeNumberCHelper.applyNumber(this.txtName, (IObjectValue)this.editData, this.editData.getOrgUnit().getId().toString(), "sourceType", this.isHasNameCode(), this.isShowNameCode(), "name");
            }
        }
    }

    @Override
    protected void beforeLoad() throws Exception {
        super.beforeLoad();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.dealCheckInfo();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    public IObjectValue getDataObject() {
        return this.editData;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (StringUtils.isEmpty((String)this.txtName.getText()) && (!this.isHasNameCode() || this.isShowNameCode())) {
            this.txtName.requestFocus();
            BgNFCHelper.showWarning((Component)((Object)this), BgNFCHelper.getMessageStr("noName"));
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            BgPeriodInfo info;
            Object obj;
            if (this.getCodeRule().isHasCodeRule()) {
                if (this.getCodeRule().isHasShowCodeNumber() && StringUtils.isEmpty((String)this.txtNumber.getText())) {
                    this.txtNumber.requestFocus();
                    BgNFCHelper.showWarning((Component)((Object)this), BgNFCHelper.getMessageStr("noNumber"));
                }
            } else if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
                this.txtNumber.requestFocus();
                BgNFCHelper.showWarning((Component)((Object)this), BgNFCHelper.getMessageStr("noNumber"));
            }
            if (this.prmtBgScheme.getData() == null || !(this.prmtBgScheme.getData() instanceof BgSchemeInfo)) {
                this.prmtBgScheme.requestFocus();
                BgNFCHelper.showWarning((Component)((Object)this), BgNFCHelper.getMessageStr("noBgScheme"));
            }
            if (this.comBgTemplate.getSelectedItem() == null || !(this.comBgTemplate.getSelectedItem() instanceof BgTemplateInfo)) {
                this.comBgTemplate.requestFocus();
                BgNFCHelper.showWarning((Component)((Object)this), BgNFCHelper.getMessageStr("noBgTemplate"));
            }
            if (this.comCurrency.getSelectedItem() == null || !(this.comCurrency.getSelectedItem() instanceof CurrencyInfo)) {
                this.comCurrency.requestFocus();
                BgNFCHelper.showWarning((Component)((Object)this), BgNFCHelper.getMessageStr("noCurrency"));
            }
            if (this.prmtBgPeriod.getData() == null || !(this.prmtBgPeriod.getData() instanceof BgPeriodInfo)) {
                this.prmtBgPeriod.requestFocus();
                BgNFCHelper.showWarning((Component)((Object)this), BgNFCHelper.getMessageStr("noPeriod"));
            }
            if (this.getCodeRule().isHasCodeRule()) {
                if (this.getCodeRule().isHasShowCodeNumber() && this.getNFacadeInterface().checkNumberRepeat(this.txtNumber.getText(), ((FullOrgUnitInfo)this.prmtOrgUnit.getData()).getId(), this.editData.getId())) {
                    BgNFCHelper.showWarning((Component)((Object)this), BgNFCHelper.getMessageStr("existNumber"));
                }
            } else if (this.getNFacadeInterface().checkNumberRepeat(this.txtNumber.getText(), ((FullOrgUnitInfo)this.prmtOrgUnit.getData()).getId(), this.editData.getId())) {
                this.txtNumber.requestFocus();
                BgNFCHelper.showWarning((Component)((Object)this), BgNFCHelper.getMessageStr("existNumber"));
            }
            if (this.getNFacadeInterface().checkBgFormInfoRepeat(((FullOrgUnitInfo)this.prmtOrgUnit.getData()).getId(), ((BgSchemeInfo)this.prmtBgScheme.getData()).getId(), ((BgTemplateInfo)this.comBgTemplate.getSelectedItem()).getId(), ((BgPeriodInfo)this.prmtBgPeriod.getData()).getId(), ((CurrencyInfo)this.comCurrency.getSelectedItem()).getId())) {
                BgNFCHelper.showWarning((Component)((Object)this), BgNFCHelper.getMessageStr("existForm"));
            }
            if ((obj = this.prmtBgPeriod.getData()) != null && obj instanceof BgPeriodInfo && (info = (BgPeriodInfo)obj).getPeriodType().getValue() == 8) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"bgFormSelfDefPeriod"));
            }
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.verify(e);
            this.submitBgFormInfo();
            this.setHasSubmit(true);
            this.destroyWindow();
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            super.actionSubmit_actionPerformed(e);
        }
    }

    public void submitBgFormInfo() throws Exception {
        IRow row = null;
        BgTemplateInfo _bgTemplateInfo = null;
        BgMeasureUnitInfo bgMeasureUnit = null;
        _bgTemplateInfo = (BgTemplateInfo)this.comBgTemplate.getSelectedItem();
        Book book = this.verifyBookPermission(_bgTemplateInfo = this.getBgTemplateInfo(_bgTemplateInfo.getId(), true, false));
        if (book == null) {
            book = _bgTemplateInfo.getBook();
        }
        this.dealExtFormula(book);
        this.editData.setData(IOHelper.packBook((Book)book));
        this.editData.setTemplateLastUpdateTime(_bgTemplateInfo.getLastUpdateTime());
        int count = this.tblMeasureUnit.getBody().size();
        for (int index = 0; index < count; ++index) {
            row = this.tblMeasureUnit.getRow(index);
            if (row.getCell(4).getValue() == null || !(row.getCell(4).getValue() instanceof MeasureUnitInfo)) continue;
            bgMeasureUnit = new BgMeasureUnitInfo();
            bgMeasureUnit.setBgForm(this.editData);
            bgMeasureUnit.setBgElement((BgElementInfo)row.getUserObject());
            bgMeasureUnit.setMeasureUnit((MeasureUnitInfo)row.getCell(4).getValue());
            this.editData.getBgMeasureUnit().add(bgMeasureUnit);
        }
    }

    protected void dealExtFormula(Book book) throws Exception {
        BgNExpressionHelper.dealAcctExpressionAtAddNew(book, (IObjectValue)this.editData, 0);
        BgNExpressionHelper.dealAcctItemExpression(null, book, (IObjectValue)this.editData);
        BgNExpressionHelper.dealCashExpressionAtAddNew(book, (IObjectValue)this.editData);
    }

    private Book verifyBookPermission(BgTemplateInfo templateInfo) throws Exception {
        boolean isSheetPer = BgSHelper.isBgSheetPermissionUsed();
        Map sheetPer = null;
        Book _book = templateInfo.getBook();
        Sheet _sheet = null;
        if (isSheetPer) {
            sheetPer = this.addBgSheetPermission(templateInfo.getId().toString());
            String user = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            boolean isShowSheet = false;
            if (_book != null) {
                int sheetIndex = 0;
                int sheetSize = _book.getSheetCount();
                for (sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                    _sheet = _book.getSheet(sheetIndex);
                    if (isShowSheet) break;
                    isShowSheet = this.hideSheet(_sheet, sheetPer, user);
                }
            }
            if (isSheetPer && !isShowSheet) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"67_BgNActualRecordProcessUI"));
                SysUtil.abort();
            }
        }
        return _book;
    }

    private Map addBgSheetPermission(String temId) {
        if (temId == null) {
            return null;
        }
        Map hasPer = new HashMap<String, Object>();
        Map sheetPer = new HashMap();
        try {
            hasPer.put(temId, null);
            hasPer = BgPermissionHelper.getBgTemplateSheetPermission(null, hasPer);
            if (hasPer != null && hasPer.get(temId) != null) {
                sheetPer = (Map)hasPer.get(temId);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return sheetPer;
    }

    private boolean hideSheet(Sheet _sheet, Map sheetPer, String user) {
        String sheetCreater = null;
        if (sheetPer != null && sheetPer.containsKey(BgNFSHelper.getSheetSign(_sheet))) {
            return true;
        }
        sheetCreater = (String)_sheet.getUserObjectValue("SHEET_CREATER_ID");
        return sheetCreater != null && sheetCreater.equals(user);
        {
        }
    }

    public boolean isModify() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            return false;
        }
        return super.isModify();
    }

    protected void dealCheckInfo() throws Exception {
        BgPeriodInfo _bgPeriodInfo;
        BgSchemeInfo _bgSchemeInfo;
        Object obj = this.getUIContext().get("BGFORM_LINK_SCHEME");
        if (obj != null && (_bgSchemeInfo = this.getLinkBgSchemeInfo(obj.toString())) != null) {
            this.prmtBgScheme.setData((Object)_bgSchemeInfo);
        }
        if ((obj = this.getUIContext().get("BGFORM_LINK_TEMPLATE")) != null) {
            this.setSelectBgTemplateInfo(obj.toString());
        }
        if ((obj = this.getUIContext().get("BGFORM_LINK_PERIOD")) != null && (_bgPeriodInfo = this.getLinkBgPeriodInfo(obj.toString())) != null) {
            this.prmtBgPeriod.setData((Object)_bgPeriodInfo);
        }
        if ((obj = this.getUIContext().get("BGFORM_LINK_CURRENCY")) != null) {
            this.setSelectCurrencyInfo(obj.toString());
        }
    }

    protected BgSchemeInfo getLinkBgSchemeInfo(String bgSchemeNumber) throws Exception {
        if (StringUtils.isEmpty((String)bgSchemeNumber)) {
            return null;
        }
        BgSchemeInfo _bgSchemeInfo = null;
        BgSchemeCollection _bgSchemeCol = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.getCcOrgUnitInfo().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)bgSchemeNumber, CompareType.EQUALS));
        view.setFilter(filter);
        IBgScheme ibgScheme = BgSchemeFactory.getRemoteInstance();
        _bgSchemeCol = ibgScheme.getBgSchemeCollection(view);
        if (_bgSchemeCol != null && !_bgSchemeCol.isEmpty()) {
            _bgSchemeInfo = _bgSchemeCol.get(0);
        }
        return _bgSchemeInfo;
    }

    protected void setSelectBgTemplateInfo(String bgTemplateNumber) throws Exception {
        if (StringUtils.isEmpty((String)bgTemplateNumber)) {
            return;
        }
        BgTemplateInfo _bgTemplateInfo = null;
        int in = this.comBgTemplate.getItemCount();
        for (int i = 0; i < in; ++i) {
            _bgTemplateInfo = (BgTemplateInfo)this.comBgTemplate.getItemAt(i);
            if (!bgTemplateNumber.equals(_bgTemplateInfo.getNumber())) continue;
            this.comBgTemplate.setSelectedIndex(i);
            break;
        }
    }

    protected BgPeriodInfo getLinkBgPeriodInfo(String bgPeriodId) throws Exception {
        if (StringUtils.isEmpty((String)bgPeriodId)) {
            return null;
        }
        BgPeriodInfo _bgPeriodInfo = null;
        IBgPeriod ibgPeriod = BgPeriodFactory.getRemoteInstance();
        _bgPeriodInfo = ibgPeriod.getBgPeriodInfo((IObjectPK)new ObjectUuidPK(bgPeriodId));
        return _bgPeriodInfo;
    }

    protected void setSelectCurrencyInfo(String currencyId) throws Exception {
        if (StringUtils.isEmpty((String)currencyId)) {
            return;
        }
        CurrencyInfo _currencyInfo = null;
        int in = this.comCurrency.getItemCount();
        for (int i = 0; i < in; ++i) {
            _currencyInfo = (CurrencyInfo)this.comCurrency.getItemAt(i);
            if (!currencyId.equals(_currencyInfo.getId().toString())) continue;
            this.comCurrency.setSelectedIndex(i);
            break;
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        return super.prepareInit();
    }

    @Override
    public boolean isPrepareDestoryWindow() {
        return true;
    }
}

