/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.ma.budget.BgExamineFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgSchemeNodeCollection;
import com.kingdee.eas.ma.budget.BgSchemeNodeFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgExamineFacade;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.client.BgExamineViewUI;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNFormFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.IBgNFormFacade;
import com.kingdee.eas.ma.nbudget.client.BgNCHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgNReportBySchemeReportUI;
import com.kingdee.eas.ma.nbudget.client.BgNReportBySchemeUI;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class BgNReportBySchemeClientHelper {
    public static final String RESOURCE = "com.kingdee.eas.ma.budget.BgReportBySchemeResource";
    StringBuffer lineNumberHead;
    StringBuffer bgTemplateHead;
    StringBuffer bgPeriodHead;
    StringBuffer stateHead;
    List header = new ArrayList();
    private ListUI listUI;
    private BgSchemeInfo bgSchemeInfo;
    private BgPeriodInfo bgPeriodInfo;
    private OrgUnitInfo orgUnitInfo;
    private boolean hasExamineCheck = false;

    public void setHasExamineCheck(boolean hasExamineCheck) {
        this.hasExamineCheck = hasExamineCheck;
    }

    public boolean isHasExamineCheck() {
        return this.hasExamineCheck;
    }

    private BgNReportBySchemeClientHelper(ListUI listUI, BgSchemeInfo bgSchemeInfo, BgPeriodInfo bgPeriodInfo, OrgUnitInfo orgUnitInfo) {
        this.lineNumberHead = new StringBuffer(String.valueOf(EASResource.getString((String)RESOURCE, (String)"lineNumber")));
        this.bgTemplateHead = new StringBuffer(String.valueOf(EASResource.getString((String)RESOURCE, (String)"bgTemplate")));
        this.bgPeriodHead = new StringBuffer(String.valueOf(EASResource.getString((String)RESOURCE, (String)"bgPeriod")));
        this.stateHead = new StringBuffer(String.valueOf(EASResource.getString((String)RESOURCE, (String)"state")));
        this.header.add(this.lineNumberHead);
        this.header.add(this.bgTemplateHead);
        this.header.add(this.bgPeriodHead);
        this.header.add(this.stateHead);
        this.listUI = listUI;
        this.bgSchemeInfo = bgSchemeInfo;
        this.bgPeriodInfo = bgPeriodInfo;
        this.orgUnitInfo = orgUnitInfo;
    }

    public static void checkCanSigleReport(CoreUI owner, String bgFormId) throws Exception {
        if (bgFormId == null) {
            return;
        }
        boolean result = false;
        String sql = "select a.FIsReportByScheme from T_BG_BgScheme a, T_BG_BgForm b  where a.FID = b.FBgSchemeId and b.fid = '" + bgFormId + "'";
        ISQLExecutor iSql = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = iSql.executeSQL();
        if (rs.next()) {
            result = rs.getBoolean(1);
        }
        if (result) {
            MsgBox.showInfo((Component)owner, (String)EASResource.getString((String)RESOURCE, (String)"formOnlyReportByScheme"));
            SysUtil.abort();
        }
    }

    public static void reportByScheme(ListUI listUI, String bgFormId) throws Exception {
        if (listUI == null || bgFormId == null) {
            return;
        }
        UIContext ctx = new UIContext((Object)listUI);
        ctx.put((Object)"ID", (Object)bgFormId);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgNReportBySchemeUI.class.getName(), (Map)ctx);
        window.show();
        BgNReportBySchemeUI reportUi = (BgNReportBySchemeUI)window.getUIObject();
        if (!reportUi.isOperationSuccess()) {
            return;
        }
        BgSchemeInfo bgSchemeInfo = reportUi.getBgScheme();
        BgPeriodInfo bgPeriodInfo = reportUi.getBgPeriod();
        OrgUnitInfo orgUnitInfo = reportUi.getOrgUnit();
        BgNReportBySchemeClientHelper helper = new BgNReportBySchemeClientHelper(listUI, bgSchemeInfo, bgPeriodInfo, orgUnitInfo);
        helper.startReport();
    }

    private void startReport() throws Exception {
        BgFormCollection bgFormCol = this.queryBgFormAndCheckState(this.bgSchemeInfo, this.bgPeriodInfo);
        this.checkWorkFlow(bgFormCol);
        BOSUuid[] bgFormIds = new BOSUuid[bgFormCol.size()];
        ArrayList<String> bgFormList = new ArrayList<String>();
        for (int i = 0; i < bgFormCol.size(); ++i) {
            bgFormIds[i] = bgFormCol.get(i).getId();
            bgFormList.add(bgFormIds[i].toString());
        }
        if (BgNSHelper.isVerifyOfCourse()) {
            this.examinCheck(bgFormIds, bgFormList);
        } else {
            this.course(bgFormList);
        }
    }

    private void examinCheck(final BOSUuid[] bgFormIds, List bgFormList) throws Exception {
        if (!this.checkReport(bgFormIds)) {
            SysUtil.abort();
        }
        if (this.getBgExamineInterface().canExamine(bgFormIds)) {
            final String xNum = BgNFCHelper.returnExamineX(bgFormIds, this.listUI);
            LongTimeDialog dialog = null;
            Window win = SwingUtilities.getWindowAncestor((Component)this.listUI);
            if (win instanceof Frame) {
                dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new LongTimeDialog((Dialog)win);
            }
            if (dialog == null) {
                return;
            }
            dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    Object[] result = BgNReportBySchemeClientHelper.this.getBgExamineInterface().examines(bgFormIds, xNum);
                    HashMap<String, Object> bgExamineCheckMap = new HashMap<String, Object>();
                    bgExamineCheckMap.put("BgExamineChecked", result[0]);
                    bgExamineCheckMap.put("BgExamineCheckResult", result[1]);
                    return bgExamineCheckMap;
                }

                public void afterExec(Object result) throws Exception {
                    if (result != null && result instanceof HashMap) {
                        Map bgExamineCheckMap = (Map)result;
                        Boolean bgExCheck = (Boolean)bgExamineCheckMap.get("BgExamineChecked");
                        if (bgExCheck.booleanValue()) {
                            BgNReportBySchemeClientHelper.this.setHasExamineCheck(true);
                            if (!StringUtils.isEmpty((String)xNum)) {
                                BgNReportBySchemeClientHelper.this.getFormInterface().saveXNum(bgFormIds, xNum);
                            }
                            BgNReportBySchemeClientHelper.this.listUI.setMessageText(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "checkExamineSucceed"));
                            BgNReportBySchemeClientHelper.this.listUI.showMessage();
                        } else {
                            MsgBox.showInfo((Component)BgNReportBySchemeClientHelper.this.listUI, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "checkExamineError"));
                            BgNReportBySchemeClientHelper.this.openBgExamineViewUI(result);
                            SysUtil.abort();
                        }
                    }
                }
            });
            dialog.show();
        } else {
            this.setHasExamineCheck(true);
        }
        if (this.isHasExamineCheck()) {
            this.course(bgFormList);
        }
    }

    protected void openBgExamineViewUI(Object obj) throws Exception {
        UIContext uiContext = new UIContext((Object)this.listUI);
        uiContext.put((Object)"EXAMINE_DATA", obj);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BgExamineViewUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    private BgFormCollection queryBgFormAndCheckState(BgSchemeInfo bgSchemeInfo, BgPeriodInfo bgPeriodInfo) throws Exception {
        BgFormCollection subCol;
        String key;
        BgFormInfo bgFormInfo;
        BgTemplateInfo bgTemplateInfo;
        HashMap<String, BgTemplateInfo> bgTemplateMap = new HashMap<String, BgTemplateInfo>();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("bgTemplate.id");
        evi.getSelector().add("bgTemplate.number");
        evi.getSelector().add("bgTemplate.name");
        evi.getSelector().add("bgTemplate.rootId");
        evi.getSelector().add("bgTemplate.bgType.id");
        evi.getSelector().add("bgTemplate.bgType.number");
        evi.getSelector().add("bgTemplate.bgType.name");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeInfo.getId().toString(), CompareType.EQUALS));
        BgSchemeNodeCollection nodes = BgSchemeNodeFactory.getRemoteInstance().getBgSchemeNodeCollection(evi);
        if (nodes != null) {
            for (int i = 0; i < nodes.size(); ++i) {
                bgTemplateInfo = nodes.get(i).getBgTemplate();
                if (bgTemplateInfo.getBgType() != null && "BV/FQwEUEADgABtLwKgSXv9s2OA=".equals(bgTemplateInfo.getBgType().getId().toString())) continue;
                bgTemplateMap.put(bgTemplateInfo.getNumber(), bgTemplateInfo);
            }
        }
        if (bgTemplateMap.isEmpty()) {
            MsgBox.showInfo((Component)this.listUI, (String)EASResource.getString((String)RESOURCE, (String)"noTemplateToReport"));
            SysUtil.abort();
        }
        HashMap<String, BgFormCollection> bgFormMap = new HashMap<String, BgFormCollection>();
        evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("state");
        evi.getSelector().add("bgTemplate.id");
        evi.getSelector().add("bgPeriod.id");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeInfo.getId().toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.id", (Object)bgPeriodInfo.getId().toString()));
        HashSet<Integer> state = new HashSet<Integer>();
        state.add(new Integer(15));
        if (!BgParamCHelper.isStartBasisApproved()) {
            state.add(new Integer(3));
        }
        evi.getFilter().getFilterItems().add(new FilterItemInfo("state".toLowerCase(), state, CompareType.NOTINCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"select fadjustId from t_bg_bgform where fstate in ( 4 , 35 )", CompareType.NOTINNER));
        BgFormCollection bgFormCol = BgFormFactory.getRemoteInstance().getBgFormCollection(evi);
        if (bgFormCol != null) {
            for (int i = 0; i < bgFormCol.size(); ++i) {
                bgFormInfo = bgFormCol.get(i);
                key = bgFormInfo.getBgTemplate().getId().toString() + "_" + bgFormInfo.getBgPeriod().getId().toString();
                subCol = null;
                if (!bgFormMap.containsKey(key)) {
                    subCol = new BgFormCollection();
                    bgFormMap.put(key, subCol);
                } else {
                    subCol = (BgFormCollection)bgFormMap.get(key);
                }
                subCol.add(bgFormInfo);
            }
        }
        BgFormStateEnum stateEnum = BgFormStateEnum.Edited;
        if (BgNSHelper.isStartBasisApproved()) {
            stateEnum = BgFormStateEnum.BasisApproved;
        }
        bgFormCol = new BgFormCollection();
        ArrayList content = new ArrayList();
        String bgFormState = null;
        String noFound = EASResource.getString((String)RESOURCE, (String)"noFound");
        boolean hasCanReport1 = false;
        Object[] bgTemplateNumbers = bgTemplateMap.keySet().toArray();
        Arrays.sort(bgTemplateNumbers);
        for (int i = 0; i < bgTemplateNumbers.length; ++i) {
            bgTemplateInfo = (BgTemplateInfo)bgTemplateMap.get(bgTemplateNumbers[i]);
            key = bgTemplateInfo.getId() + "_" + bgPeriodInfo.getId();
            subCol = (BgFormCollection)bgFormMap.get(key);
            hasCanReport1 = false;
            if (subCol == null || subCol.isEmpty()) {
                this.addReport(content, bgTemplateInfo.getName(), bgPeriodInfo.getName(), noFound);
                continue;
            }
            bgFormState = null;
            for (int f = 0; f < subCol.size(); ++f) {
                bgFormInfo = subCol.get(f);
                if (stateEnum.equals((Object)bgFormInfo.getState())) {
                    if (!hasCanReport1) {
                        hasCanReport1 = true;
                    }
                    bgFormCol.add(bgFormInfo);
                    continue;
                }
                if (bgFormState != null) continue;
                bgFormState = bgFormInfo.getState().getAlias();
            }
            if (hasCanReport1) continue;
            this.addReport(content, bgTemplateInfo.getName(), bgPeriodInfo.getName(), bgFormState);
        }
        if (!content.isEmpty()) {
            this.showReportUI(content);
            SysUtil.abort();
        }
        return bgFormCol;
    }

    private void showReportUI(List content) throws UIException {
        MsgBox.showInfo((Component)this.listUI, (String)EASResource.getString((String)RESOURCE, (String)"reportBySchemeFail"));
        UIContext ctx = new UIContext((Object)this.listUI);
        ArrayList<String> baseMessage = new ArrayList<String>();
        baseMessage.add(EASResource.getString((String)RESOURCE, (String)"reportBySchemeMessage"));
        baseMessage.add("");
        baseMessage.add(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"orgUnitMessage"), this.orgUnitInfo));
        baseMessage.add(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"bgSchemeMessage"), this.bgSchemeInfo));
        baseMessage.add(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"bgPeriodMessage"), this.bgPeriodInfo));
        ctx.put((Object)"listHeader", (Object)this.header);
        ctx.put((Object)"listContent", (Object)content);
        ctx.put((Object)"uiTitle", (Object)EASResource.getString((String)RESOURCE, (String)"reportBySchemeTitle"));
        ctx.put((Object)"listBaseMessage", baseMessage);
        UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgNReportBySchemeReportUI.class.getName(), (Map)ctx).show();
    }

    private void addReport(List content, String bgTemplateName, String bgPeriodName, String state) {
        HashMap<StringBuffer, Object> map = new HashMap<StringBuffer, Object>();
        map.put(this.lineNumberHead, content.size() + 1);
        map.put(this.bgTemplateHead, bgTemplateName);
        map.put(this.bgPeriodHead, bgPeriodName);
        map.put(this.stateHead, state);
        content.add(map);
    }

    private void course(List bgFormIdList) throws Exception {
        List _re = this.getNFacadeInterface().courceByScheme(bgFormIdList, null, SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        BgNCHelper.refreshListUI((CoreUI)this.listUI);
        MsgBox.showInfo((Component)this.listUI, (String)EASResource.getString((String)RESOURCE, (String)"reportBySchemeSuccess"));
    }

    private void checkWorkFlow(BgFormCollection bgFormCol) throws Exception {
        for (int i = 0; i < bgFormCol.size(); ++i) {
            String billId = bgFormCol.get(i).getId().toString();
            String billNumber = bgFormCol.get(i).getNumber();
            if (!BgNFSHelper.checkInProInst(billId)) continue;
            MsgBox.showWarning((Component)this.listUI, (String)MessageFormat.format(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "bgFormInWrokErrorInWork"), billNumber));
            SysUtil.abort();
        }
    }

    protected boolean checkReport(BOSUuid[] bgFormIds) throws Exception {
        List nopass;
        if (bgFormIds == null || bgFormIds.length == 0) {
            return false;
        }
        boolean isCheck = true;
        List check = this.getFormInterface().reportCheck(bgFormIds);
        if (Boolean.TRUE.equals(check.get(0))) {
            return isCheck;
        }
        if (Boolean.FALSE.equals(check.get(0))) {
            isCheck = false;
            UIContext uiContext = new UIContext((Object)this.listUI);
            uiContext.put((Object)"String", (Object)check.get(3).toString());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.fi.gr.cslrpt.client.ShowEditorPanelUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        if (check.size() >= 3 && check.get(2) != null && (nopass = (List)check.get(2)).size() > 0) {
            isCheck = false;
            MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "ReportCheckError"));
        }
        return isCheck;
    }

    protected IBgNFormFacade getNFacadeInterface() throws Exception {
        return BgNFormFacadeFactory.getRemoteInstance();
    }

    protected IBgExamineFacade getBgExamineInterface() throws Exception {
        return BgExamineFacadeFactory.getRemoteInstance();
    }

    protected IBgForm getFormInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }
}

