/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgNReportBySchemeUI;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class BgNReportBySchemeUI
extends AbstractBgNReportBySchemeUI {
    private static final long serialVersionUID = 3706023906144656877L;
    private static final Logger logger = CoreUIObject.getLogger(BgNReportBySchemeUI.class);
    private BgSchemeInfo bgScheme;
    private BgPeriodInfo bgPeriod;
    private OrgUnitInfo orgUnitInfo;
    private boolean isOperationSuccess = false;

    public BgSchemeInfo getBgScheme() {
        return this.bgScheme;
    }

    public BgPeriodInfo getBgPeriod() {
        return this.bgPeriod;
    }

    public OrgUnitInfo getOrgUnit() {
        return this.orgUnitInfo;
    }

    public boolean isOperationSuccess() {
        return this.isOperationSuccess;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String bgFormId = (String)this.getUIContext().get("ID");
        if (bgFormId == null) {
            SysUtil.abort();
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("orgUnit.id");
        sic.add("orgUnit.number");
        sic.add("orgUnit.name");
        sic.add("orgUnit.level");
        sic.add("orgUnit.longNumber");
        sic.add("bgScheme.id");
        sic.add("bgScheme.number");
        sic.add("bgScheme.name");
        sic.add("bgScheme.rootId");
        sic.add("bgScheme.isReportByScheme");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.name");
        BgFormInfo bgFormInfo = BgFormFactory.getRemoteInstance().getBgFormInfo((IObjectPK)new ObjectStringPK(bgFormId), sic);
        if (!bgFormInfo.getBgScheme().isIsReportByScheme()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgReportBySchemeResource", (String)"bgSchemeNoReportByScheme"));
            SysUtil.abort();
        }
        if (bgFormInfo.getBgScheme().getId().toString().equals(bgFormInfo.getBgScheme().getRootId().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgReportBySchemeResource", (String)"formNoReportByScheme"));
            SysUtil.abort();
        }
        PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(bgFormInfo.getOrgUnit().getId()), "bg_form37_courseByScheme");
        this.prmtOrgUnit.setData((Object)bgFormInfo.getOrgUnit());
        this.prmtBgScheme.setData((Object)bgFormInfo.getBgScheme());
        this.prmtBgPeriod.setData((Object)bgFormInfo.getBgPeriod());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)bgFormInfo.getOrgUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(-1), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isReportByScheme", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"rootId", CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 and #2");
        if (BgParamCHelper.isBgPermissionUsed()) {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            HashSet<String> orgSet = new HashSet<String>();
            orgSet.add(bgFormInfo.getOrgUnit().getId().toString());
            filter = BgPermissionHelper.addBgSchemePermission(userId, orgSet, filter);
        }
        view.setFilter(filter);
        this.prmtBgScheme.setEntityViewInfo(view);
        BgPeriodDialog dialog = new BgPeriodDialog();
        this.prmtBgPeriod.setSelector((KDPromptSelector)dialog);
        this.prmtBgPeriod.setSelector((KDPromptSelector)dialog);
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.prmtBgScheme.getData();
        BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)this.prmtBgPeriod.getData();
        if (bgSchemeInfo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgReportBySchemeResource", (String)"selectBgScheme"));
            SysUtil.abort();
        }
        if (bgPeriodInfo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgReportBySchemeResource", (String)"selectBgPeriod"));
            SysUtil.abort();
        }
        this.isOperationSuccess = true;
        this.bgScheme = bgSchemeInfo;
        this.bgPeriod = bgPeriodInfo;
        this.orgUnitInfo = (OrgUnitInfo)this.prmtOrgUnit.getData();
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }
}

