/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.AssignSolutionCollection;
import com.kingdee.eas.ma.budget.AssignSolutionFactory;
import com.kingdee.eas.ma.budget.AssignSolutionInfo;
import com.kingdee.eas.ma.budget.AssignSolutionTypeEnum;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateFacadeFactory;
import com.kingdee.eas.ma.budget.OrgUnitUtils;
import com.kingdee.eas.ma.budget.client.AssignSolutionInterface;
import com.kingdee.eas.ma.budget.client.BgSchemeTreeListUI;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.budget.client.SearchKeyEnum;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgOrgTypeViewEnum;
import com.kingdee.eas.ma.nbudget.BgOrgUtils;
import com.kingdee.eas.ma.nbudget.client.AbstractBgNSchemeDispatchByTemplate;
import com.kingdee.eas.ma.nbudget.client.BgNSchemeDispatchClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BgNSchemeDispatchByTemplate
extends AbstractBgNSchemeDispatchByTemplate
implements AssignSolutionInterface {
    private static final long serialVersionUID = -1819748278525103933L;
    private static final Logger logger = CoreUIObject.getLogger(BgNSchemeDispatchByTemplate.class);
    private TreeModel treeModelOld = null;
    private final Hashtable temMap = new Hashtable();
    private final Map tempType = new HashMap();
    private static final String IS_TOGETHER = "isTogether";
    private static final String TEM_MAP = "temMap";
    private static final String CURR_TEMP_ID = "currTempId";
    private static final Color NO_DISPATCHED = Color.BLACK;
    private static final Color DISPATCHED_BY_THIS_SCHEME = Color.RED;
    private static final Color DISPATCHED_BY_OTHER_SCHEME = new Color(0, 128, 0);
    private static final Color NOFINANCE = Color.GRAY;
    private static boolean isFinSelected = false;
    private Set financeOrgSet;
    private Set costCenterIDSet;
    private TreeWillExpandListener listener = null;
    private Map<String, Map<String, Integer>> dispatchInfo = new HashMap<String, Map<String, Integer>>();
    public static final String RES_PATH = "com.kingdee.eas.ma.nbudget.BgSchemeUnAssignResource";
    KDPopupMenu popMenu = new KDPopupMenu();

    public void onLoad() throws Exception {
        this.initOrgUnitTree();
        super.onLoad();
        this.temTable.checkParsed();
        this.temTable.getSelectManager().setSelectMode(10);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.treeViewOrgUnit.setShowButton(false);
        this.treeViewOrgUnit.updateUI();
        BgNSchemeDispatchClientHelper.searchTemplate(this.getSchemeId(), null, null, this.temTable, this.tempType);
        this.chBoxTogether.setSelected(false);
        this.treeOrgUnit.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

            public void nodeStateChange(TreeNodeStateChangeEvent event) {
                BgNSchemeDispatchByTemplate.this.treeOrgUnit_nodeStateChange(event);
            }
        });
        this.orgComboBox.addItem((Object)BgOrgTypeViewEnum.All);
        this.orgComboBox.addItem((Object)BgOrgTypeViewEnum.company);
        this.orgComboBox.addItemListener((ItemListener)new OrgListener());
    }

    private void selectedAllOrg(DefaultKingdeeTreeNode root) {
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            node.setTextColor(NO_DISPATCHED);
            node.setCheckBoxVisible(true);
            node.setCheckBoxEnabled(true);
            if (node.getChildCount() <= 0) continue;
            this.selectedAllOrg(node);
        }
    }

    private void selectedFinanceOrg(DefaultKingdeeTreeNode root) throws BOSException {
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            if (!(node.getUserObject() instanceof OrgStructureInfo)) continue;
            OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
            if (!this.getFinanceOrgSet().contains(oui.getUnit().getId().toString())) {
                node.setTextColor(NOFINANCE);
                node.setCheckBoxVisible(false);
                node.setCheckBoxEnabled(false);
            }
            if (node.getChildCount() <= 0) continue;
            this.selectedFinanceOrg(node);
        }
    }

    protected void treeOrgUnit_nodeStateChange(TreeNodeStateChangeEvent event) {
        if (this.temTable.getSelectManager().getActiveRowIndex() >= 0) {
            String temId = (String)this.temTable.getCell(this.temTable.getSelectManager().getActiveRowIndex(), "id").getValue();
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)event.getNode();
            String orgId = this.getOrgId(node);
            Vector vec = null;
            if (orgId != null && !"".equals(orgId.trim())) {
                if (this.temMap.containsKey(orgId)) {
                    vec = (Vector)this.temMap.get(orgId);
                } else {
                    vec = new Vector();
                    this.temMap.put(orgId, vec);
                }
            }
            if (node.isChecked()) {
                if (vec != null && !vec.contains(temId)) {
                    vec.add(temId);
                }
            } else if (vec != null) {
                vec.remove(temId);
            }
        }
    }

    private String getOrgId(DefaultKingdeeTreeNode node) {
        if (node == null || !node.isCheckBoxVisible() || OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
            return null;
        }
        OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
        if (oui == null || oui.getUnit() == null) {
            return null;
        }
        return oui.getUnit().getId().toString();
    }

    private void initOrgUnitTree() throws Exception {
        BgNSchemeDispatchClientHelper.initComboxOrgType(this.comBoxOrgType);
        this.listener = new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                Map<Object, Object> dispatchInfo = new HashMap();
                String bgTemplateId = BgNSchemeDispatchByTemplate.this.getBgTemplateId();
                if (BgNSchemeDispatchByTemplate.this.getDispatchInfo().containsKey(bgTemplateId)) {
                    dispatchInfo = BgNSchemeDispatchByTemplate.this.getDispatchInfo().get(bgTemplateId);
                }
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                try {
                    OrgUnitUtils.addChildNode((DefaultKingdeeTreeNode)node, dispatchInfo.keySet(), (boolean)false);
                }
                catch (Exception e) {
                    BgNSchemeDispatchByTemplate.this.handUIExceptionAndAbort(e);
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }
        };
        String bgSchemeId = this.getSchemeId();
        BgSchemeInfo bgScheme = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo("select orgUnit.id where id='" + bgSchemeId + "'");
        String orgId = bgScheme.getOrgUnit().getId().toString();
        this.treeModelOld = OrgUnitUtils.getOrgTreeModel((KDTree)this.treeOrgUnit, (String)orgId, (TreeWillExpandListener)this.listener);
        this.treeOrgUnit.setShowCheckBox(true);
        this.treeOrgUnit.setModel(this.treeModelOld);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeModelOld.getRoot();
        root.setCheckBoxVisible(false);
        root.setCheckBoxEnabled(false);
        BgNSchemeDispatchClientHelper.checkEmptyOrgTreeModel(this.treeModelOld);
        this.iniPoppMenu();
    }

    @Override
    public void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        if (this.txtKey.getText() == null || this.txtKey.getText().trim().length() < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"195_BgCtrlSchemeAssignChildUI"));
            this.txtKey.requestFocus();
            return;
        }
        String value = this.txtKey.getText();
        SearchKeyEnum keyEnum = (SearchKeyEnum)this.comboSearchKey.getSelectedItem();
        if (keyEnum.getValue() == 10 || keyEnum.getValue() == 0) {
            this.treeOrgUnitSelectAll((DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot(), null);
        }
        if (keyEnum.getValue() == 10) {
            TreeModel model = BgOrgUtils.clipAndCloneTreeModel(this.treeModelOld, "name", value, true);
            ((DefaultKingdeeTreeNode)model.getRoot()).setCheckBoxVisible(false);
            this.treeOrgUnit.setModel(model);
            if (isFinSelected) {
                this.selectedFinanceOrg((DefaultKingdeeTreeNode)model.getRoot());
            }
        } else if (keyEnum.getValue() == 0) {
            TreeModel model = BgOrgUtils.clipAndCloneTreeModel(this.treeModelOld, "number", value, true);
            ((DefaultKingdeeTreeNode)model.getRoot()).setCheckBoxVisible(false);
            this.treeOrgUnit.setModel(model);
            if (isFinSelected) {
                this.selectedFinanceOrg((DefaultKingdeeTreeNode)model.getRoot());
            }
        } else if (keyEnum.getValue() == 20) {
            BgNSchemeDispatchClientHelper.searchTemplate(this.getSchemeId(), "number", value, this.temTable, this.tempType);
            this.temMap.clear();
        } else if (keyEnum.getValue() == 30) {
            BgNSchemeDispatchClientHelper.searchTemplate(this.getSchemeId(), "name", value, this.temTable, this.tempType);
            this.temMap.clear();
        }
        this.treeOrgUnit.repaint();
        this.temTable_tableSelectChanged(null);
    }

    @Override
    protected void btnSelectNow_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock sb = null;
        int size = this.temTable.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            sb = this.temTable.getSelectManager().get(i);
            int bottom = Math.min(sb.getBottom(), this.temTable.getRowCount() - 1);
            for (int j = sb.getTop(); j <= bottom; ++j) {
                this.temTable.getRow(j).getCell("select").setValue((Object)true);
            }
        }
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        Map temMap = this.rebuildTemMap();
        int templateType = 0;
        for (Vector vec : temMap.values()) {
            if (vec == null || vec.isEmpty()) continue;
            for (int j = 0; j < vec.size(); ++j) {
                Integer type = (Integer)this.tempType.get(vec.get(j));
                if (type != null && type == 2) {
                    templateType |= 2;
                    continue;
                }
                if (type != null && type == 3) {
                    templateType |= 2;
                    continue;
                }
                templateType |= 1;
            }
        }
        Object ui = this.getUIContext().get("Owner");
        if (ui instanceof BgSchemeTreeListUI) {
            BgSchemeTreeListUI bGui = (BgSchemeTreeListUI)ui;
            BgNSchemeDispatchClientHelper.startAssign(bGui, this.getSchemeId(), temMap, templateType);
        }
    }

    private Map rebuildTemMap() throws Exception {
        HashMap<Object, Boolean> selectTem = new HashMap<Object, Boolean>();
        for (int i = 0; i < this.temTable.getRowCount(); ++i) {
            IRow row = this.temTable.getRow(i);
            if (!((Boolean)row.getCell("select").getValue()).booleanValue()) continue;
            selectTem.put(row.getCell("id").getValue(), Boolean.FALSE);
        }
        if (selectTem.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"pleaseSelectTemplateFirst"));
            SysUtil.abort();
        }
        if (this.chBoxTogether.isSelected()) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
            List orgIds = BgNSchemeDispatchClientHelper.traceNode(root, new ArrayList());
            if (orgIds == null || orgIds.isEmpty()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"please.choose.first"));
                SysUtil.abort();
            } else {
                this.temMap.clear();
                Iterator it = orgIds.iterator();
                while (it.hasNext()) {
                    this.temMap.put(it.next(), new Vector(selectTem.keySet()));
                }
            }
        }
        boolean error = false;
        block2: for (Vector vec : this.temMap.values()) {
            if (vec == null || vec.isEmpty()) continue;
            for (String temId : vec) {
                if (!selectTem.containsKey(temId)) {
                    error = true;
                    continue block2;
                }
                selectTem.put(temId, Boolean.TRUE);
            }
        }
        if (error) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"pleaseSelectTem"));
            SysUtil.abort();
        } else if (selectTem.containsValue(Boolean.FALSE)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"pleaseSelectOrg"));
            SysUtil.abort();
        }
        return this.temMap;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        if (this.treeOrgUnit.getSelectionPath() != null) {
            root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getSelectionPath().getLastPathComponent();
        }
        this.treeOrgUnitView(root, true);
        ((DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot()).setChecked(false);
        this.treeOrgUnit.repaint();
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        if (this.treeOrgUnit.getSelectionPath() != null) {
            root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getSelectionPath().getLastPathComponent();
        }
        this.treeOrgUnitView(root, false);
        this.treeOrgUnit.repaint();
    }

    private void treeOrgUnitView(DefaultKingdeeTreeNode root, Boolean isSelected) throws Exception {
        if (root == null) {
            return;
        }
        final DefaultKingdeeTreeNode tmpNode = root;
        final Boolean tmpSelected = isSelected;
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                BgNSchemeDispatchByTemplate.this.treeOrgUnitSelectAll(tmpNode, tmpSelected);
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
    }

    private void treeOrgUnitSelectAll(DefaultKingdeeTreeNode root, Boolean isSelected) throws Exception {
        block6: {
            DefaultKingdeeTreeNode node;
            block5: {
                if (root == null) {
                    return;
                }
                if (isSelected != null && this.canTheNodeBeSelected(root)) {
                    root.setChecked(isSelected.booleanValue());
                    this.treeOrgUnit.fireTreeNodeStateChange((TreeNode)root);
                }
                node = null;
                if (!this.chkIncludeChildren.isSelected()) break block5;
                Enumeration children = root.children();
                while (children.hasMoreElements()) {
                    node = (DefaultKingdeeTreeNode)children.nextElement();
                    if (isSelected != null && this.canTheNodeBeSelected(node)) {
                        node.setChecked(isSelected.booleanValue());
                        this.treeOrgUnit.fireTreeNodeStateChange((TreeNode)node);
                    }
                    if (node.isLeaf()) continue;
                    BgNFSHelper.addChildNode(node);
                    this.treeOrgUnitSelectAll(node, isSelected);
                }
                break block6;
            }
            if (root.getParent() == null) break block6;
            for (int i = 0; i < root.getParent().getChildCount(); ++i) {
                node = (DefaultKingdeeTreeNode)root.getParent().getChildAt(i);
                if (isSelected == null || !this.canTheNodeBeSelected(node)) continue;
                node.setChecked(isSelected.booleanValue());
                this.treeOrgUnit.fireTreeNodeStateChange((TreeNode)node);
            }
        }
    }

    private boolean canTheNodeBeSelected(DefaultKingdeeTreeNode node) {
        return node.isCheckBoxVisible() && node.isCheckBoxEnabled();
    }

    public Map<String, Map<String, Integer>> getDispatchInfo() {
        return this.dispatchInfo;
    }

    @Override
    protected void temTable_tableSelectChanged(KDTSelectEvent e) throws Exception {
        Map<String, Integer> dispatchInfo = null;
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        String schemeId = this.getSchemeId();
        String bgTemplateId = this.getBgTemplateId();
        if (schemeId == null || bgTemplateId == null) {
            return;
        }
        if (this.getDispatchInfo().containsKey(bgTemplateId)) {
            dispatchInfo = this.getDispatchInfo().get(bgTemplateId);
        } else {
            dispatchInfo = BgTemplateFacadeFactory.getRemoteInstance().getDispatchInfo(bgTemplateId, schemeId);
            this.getDispatchInfo().put(bgTemplateId, dispatchInfo);
        }
        this.setColorAndState(root, dispatchInfo, bgTemplateId);
        this.treeOrgUnit.updateUI();
    }

    protected String getBgTemplateId() {
        String bgTemplateId = null;
        if (this.temTable.getSelectManager().getActiveRowIndex() >= 0) {
            bgTemplateId = (String)this.temTable.getCell(this.temTable.getSelectManager().getActiveRowIndex(), "id").getValue();
        }
        return bgTemplateId;
    }

    private Color getColorByDispatchInfo(int dispatchInfo) {
        switch (dispatchInfo) {
            case 2: {
                return DISPATCHED_BY_OTHER_SCHEME;
            }
            case 1: {
                return DISPATCHED_BY_THIS_SCHEME;
            }
        }
        return NO_DISPATCHED;
    }

    private void setColorAndState(DefaultKingdeeTreeNode root, Map assignOrgMap, String tempId) {
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            if (!(node.getUserObject() instanceof OrgStructureInfo)) continue;
            OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
            String orgUnitID = oui.getUnit().getId().toString();
            Vector vec = (Vector)this.temMap.get(orgUnitID);
            node.setChecked(tempId != null && vec != null && vec.contains(tempId));
            int dispInfo = 0;
            if (assignOrgMap != null && assignOrgMap.containsKey(orgUnitID)) {
                dispInfo = (Integer)assignOrgMap.get(orgUnitID);
            }
            node.setTextColor(this.getColorByDispatchInfo(dispInfo));
            if (node.getChildCount() <= 0) continue;
            this.setColorAndState(node, assignOrgMap, tempId);
        }
    }

    @Override
    protected void btnSelectAllTem_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.temTable.getRowCount(); ++i) {
            this.temTable.getRow(i).getCell("select").setValue((Object)Boolean.TRUE);
        }
        this.chBoxTogether.setSelected(true);
    }

    @Override
    protected void btnClearAllTem_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.temTable.getRowCount(); ++i) {
            this.temTable.getRow(i).getCell("select").setValue((Object)Boolean.FALSE);
        }
        this.chBoxTogether.setSelected(false);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        BgNSchemeDispatchClientHelper.setNodeSelect(false, root, true, this.treeOrgUnit);
        this.temMap.clear();
    }

    @Override
    protected void chBoxTogether_actionPerformed(ActionEvent e) throws Exception {
        if (this.chBoxTogether.isSelected()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"togetherNotice"));
        }
    }

    private String getSchemeId() {
        return (String)this.getUIContext().get("ID");
    }

    public boolean cancel() throws Exception {
        this.btnCancel_actionPerformed(null);
        return true;
    }

    public void clear() throws Exception {
        if (this.temMap != null) {
            this.temMap.clear();
        }
        for (int i = 0; i < this.temTable.getRowCount(); ++i) {
            this.temTable.getRow(i).getCell("select").setValue((Object)Boolean.FALSE);
        }
        this.temTable_tableSelectChanged(null);
        this.chBoxTogether.setSelected(false);
    }

    public void clearSolutionList() throws Exception {
    }

    public boolean conferm(Object invokeUi) throws Exception {
        this.btnConfirm_actionPerformed(null);
        return false;
    }

    public AssignSolutionInfo getDefaultSoltuion() throws Exception {
        String objId = null;
        String operateType = null;
        Map uicontext = this.getUIContext();
        if (uicontext.get("ID") != null) {
            objId = (String)uicontext.get("ID");
        }
        if (uicontext.get("operateType") != null) {
            operateType = (String)uicontext.get("operateType");
        }
        StringBuffer oql = new StringBuffer("where isDefaultsolution =1 ");
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        oql.append(" and userId='" + userId + "' ");
        if (objId != null) {
            oql.append(" and relativeObjId='" + objId + "' ");
        }
        if (operateType != null) {
            oql.append(" and oprateObjType='" + operateType + "' ");
        }
        oql.append(" and uiname ='" + BgNSchemeDispatchByTemplate.class.getName() + "'");
        AssignSolutionInfo assignSolutionInfo = null;
        AssignSolutionCollection assignSolutionCol = AssignSolutionFactory.getRemoteInstance().getAssignSolutionCollection(oql.toString());
        if (assignSolutionCol.size() > 0) {
            assignSolutionInfo = assignSolutionCol.get(0);
        }
        return assignSolutionInfo;
    }

    public String getNewConfermLabel() {
        return EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"re.assign");
    }

    public Map getReturnData() throws Exception {
        return null;
    }

    public void reloadSolution(Object o) throws Exception {
        if (o instanceof Map) {
            Map sol = (Map)o;
            if (sol.get(IS_TOGETHER) instanceof Boolean && ((Boolean)sol.get(IS_TOGETHER)).booleanValue()) {
                this.chBoxTogether.setSelected(true);
            } else {
                this.chBoxTogether.setSelected(false);
            }
            this.temMap.clear();
            if (sol.get(TEM_MAP) instanceof Map) {
                this.temMap.putAll((Map)sol.get(TEM_MAP));
            }
            HashSet temIds = new HashSet();
            for (Vector vec : this.temMap.values()) {
                if (vec == null || vec.isEmpty()) continue;
                Iterator it2 = vec.iterator();
                while (it2.hasNext()) {
                    temIds.add(it2.next());
                }
            }
            boolean isSelected = !this.chBoxTogether.isSelected();
            for (int i = 0; i < this.temTable.getRowCount(); ++i) {
                if (temIds.contains(this.temTable.getCell(i, "id").getValue())) {
                    this.temTable.getCell(i, "select").setValue((Object)Boolean.TRUE);
                    if (isSelected) continue;
                    isSelected = true;
                    this.temTable.getSelectManager().select(i, 0);
                    this.temTable_tableSelectChanged(null);
                    continue;
                }
                this.temTable.getCell(i, "select").setValue((Object)Boolean.FALSE);
            }
            if (!this.chBoxTogether.isSelected() && sol.get(CURR_TEMP_ID) instanceof String) {
                String temId = (String)sol.get(CURR_TEMP_ID);
                for (int i = 0; i < this.temTable.getRowCount(); ++i) {
                    if (!temId.equals(this.temTable.getCell(i, "id").getValue())) continue;
                    this.temTable.getSelectManager().select(i, 0);
                    this.temTable_tableSelectChanged(null);
                    break;
                }
            }
        }
    }

    public Object saveSolution() throws Exception {
        HashMap<String, Object> sol = new HashMap<String, Object>();
        sol.put(IS_TOGETHER, new Boolean(this.chBoxTogether.isSelected()));
        if (this.temTable.getSelectManager().getActiveRowIndex() >= 0) {
            sol.put(CURR_TEMP_ID, this.temTable.getCell(this.temTable.getSelectManager().getActiveRowIndex(), "id").getValue());
        }
        sol.put(TEM_MAP, this.rebuildTemMap());
        return sol;
    }

    public AssignSolutionCollection solutionList(AssignSolutionTypeEnum typeEnum) throws Exception {
        StringBuffer oql = new StringBuffer("where solutionType=" + typeEnum.getValue());
        String objId = this.getSchemeId();
        String operateType = null;
        Map uicontext = this.getUIContext();
        if (uicontext.get("operateType") != null) {
            operateType = (String)uicontext.get("operateType");
        }
        if (typeEnum.getValue() == 0) {
            String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            oql.append(" and cuid='" + cuid + "'");
        } else if (typeEnum.getValue() == 2) {
            String orgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            oql.append(" and orgId='" + orgId + "'");
        } else if (typeEnum.getValue() == 1) {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            oql.append(" and userId='" + userId + "' ");
        }
        if (objId != null) {
            oql.append(" and relativeObjId='" + objId + "' ");
        }
        if (operateType != null) {
            oql.append(" and oprateObjType='" + operateType + "' ");
        }
        oql.append(" and uiname ='" + BgNSchemeDispatchByTemplate.class.getName() + "'");
        oql.append(" order by isDefaultsolution desc");
        AssignSolutionCollection asSolutionCol = AssignSolutionFactory.getRemoteInstance().getAssignSolutionCollection(oql.toString());
        return asSolutionCol;
    }

    public void iniPoppMenu() {
        this.treeOrgUnit.addMouseListener((MouseListener)new TreePopupMenuListener());
        KDMenuItem menu = new KDMenuItem();
        menu.setText(EASResource.getString((String)RES_PATH, (String)"selectSon"));
        menu.addActionListener((ActionListener)new TreeMenuListener());
        this.popMenu.add((JMenuItem)menu);
    }

    private ArrayList productArrayList(Object[] obj) {
        if (obj.length == 0) {
            return null;
        }
        ArrayList<Object> array = new ArrayList<Object>();
        for (int i = 0; i < obj.length; ++i) {
            array.add(obj[i]);
        }
        return array;
    }

    private void treeSonSelected(DefaultKingdeeTreeNode root, ArrayList list) {
        if (list.isEmpty()) {
            return;
        }
        if (list.get(list.size() - 1).toString().equals(root.getText()) || list.get(list.size() - 1).toString() == root.getText()) {
            this.selectDowmTree(root);
            return;
        }
        list.remove(0);
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            if (list.get(0).toString() != node.getText() && !list.get(0).toString().equals(node.getText())) continue;
            if (list.isEmpty()) {
                this.selectDowmTree(node);
                return;
            }
            this.treeSonSelected(node, list);
        }
    }

    private void selectDowmTree(DefaultKingdeeTreeNode root) {
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            if (!node.isCheckBoxEnabled()) continue;
            node.setChecked(true);
            this.treeOrgUnit.fireTreeNodeStateChange((TreeNode)node);
        }
    }

    private Set getFinanceOrgSet() throws BOSException {
        if (this.financeOrgSet == null) {
            this.costCenterIDSet = new HashSet();
            BgNFSHelper.getAllCostCenterIDs(this.costCenterIDSet, (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot());
            this.financeOrgSet = BgNFSHelper.getFinanceOrgID(this.costCenterIDSet);
        }
        return this.financeOrgSet;
    }

    private void setFinanceOrgSet(Set financeOrgSet) {
        this.financeOrgSet = financeOrgSet;
    }

    class TreePopupMenuListener
    extends MouseAdapter {
        TreePopupMenuListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                BgNSchemeDispatchByTemplate.this.popMenu.show((Component)BgNSchemeDispatchByTemplate.this.treeOrgUnit, e.getX(), e.getY());
            }
        }
    }

    class TreeMenuListener
    implements ActionListener {
        TreeMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath path = BgNSchemeDispatchByTemplate.this.treeOrgUnit.getSelectionPath();
            if (path == null) {
                return;
            }
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)BgNSchemeDispatchByTemplate.this.treeOrgUnit.getModel().getRoot();
            Object[] obj = path.getPath();
            ArrayList pathList = BgNSchemeDispatchByTemplate.this.productArrayList(obj);
            BgNSchemeDispatchByTemplate.this.treeSonSelected(root, pathList);
            BgNSchemeDispatchByTemplate.this.treeOrgUnit.repaint();
        }
    }

    class OrgListener
    implements ItemListener {
        OrgListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            BgNSchemeDispatchByTemplate.this.txtKey.setText("");
            TreeModel model = BgNSchemeDispatchByTemplate.this.treeModelOld;
            ((DefaultKingdeeTreeNode)model.getRoot()).setCheckBoxVisible(false);
            BgNSchemeDispatchByTemplate.this.treeOrgUnit.setModel(model);
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)BgNSchemeDispatchByTemplate.this.treeOrgUnit.getModel().getRoot();
            String select = null;
            if (e.getStateChange() == 1) {
                select = e.getItem().toString();
                if (BgOrgTypeViewEnum.company.toString() == select || BgOrgTypeViewEnum.company.toString().equals(select)) {
                    try {
                        BgNSchemeDispatchByTemplate.this.selectedFinanceOrg(root);
                    }
                    catch (BOSException e1) {
                        ExceptionHandler.handle((String)"", (Throwable)e1);
                    }
                    isFinSelected = true;
                } else {
                    BgNSchemeDispatchByTemplate.this.selectedAllOrg(root);
                    isFinSelected = false;
                }
            }
            BgNSchemeDispatchByTemplate.this.treeOrgUnit.repaint();
        }
    }
}

