/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.NewOrgUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateFacadeFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.OrgUnitUtils;
import com.kingdee.eas.ma.budget.client.BGReportUI;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.budget.client.SearchKeyEnum;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgSchemeUnAssignFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgSchemeUnAssignInfo;
import com.kingdee.eas.ma.nbudget.client.AbstractBgNSchemeUnAssignUI;
import com.kingdee.eas.ma.nbudget.client.BgNSchemeDispatchClientHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class BgNSchemeUnAssignUI
extends AbstractBgNSchemeUnAssignUI {
    private static final long serialVersionUID = 4377703325332628190L;
    private static final Logger logger = CoreUIObject.getLogger(BgNSchemeUnAssignUI.class);
    private TreeModel orgTree = null;
    private int selectedIndex = -1;
    private Map unAssignInfo = null;
    private String bgSchemeId = null;
    private String bgSchemeNumber = null;
    private Map<String, Map<String, Integer>> dispatchInfo = new HashMap<String, Map<String, Integer>>();
    private TreeWillExpandListener listener = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.comboSearchKey.removeItem((Object)SearchKeyEnum.templeNum);
        this.comboSearchKey.removeItem((Object)SearchKeyEnum.tempName);
        this.initComBoxOrgType();
        this.treeOrgUnit.setModel(null);
        this.treeOrgUnit.setShowCheckBox(true);
        this.unAssignInfo = (Map)this.getUIContext().get("UA_ALL_SUB_SCHEME");
        this.bgSchemeId = this.getUIContext().get("ID").toString();
        this.bgSchemeNumber = (String)this.getUIContext().get("BGSCHEME_INFO");
        this.refreshOrgUnitTree();
        this.initTable((BgTemplateCollection)this.unAssignInfo.get("UA_ALL_SUB_TEMPLATE"));
        this.chBoxTogether.setSelected(false);
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        String temNumber = null;
        if (this.selectedIndex >= 0) {
            IRow row = this.temTable.getRow(this.selectedIndex);
            temNumber = row.getCell("number").getValue().toString();
            this.storeUnAssignInfo(temNumber, this.treeOrgUnit.getModel().getRoot());
        }
        if (temNumber == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSchemeUnAssignResource", (String)"selectTemplate"));
            return;
        }
        HashMap<Object, Boolean> temSelected = new HashMap<Object, Boolean>();
        for (int i = 0; i < this.temTable.getRowCount(); ++i) {
            Boolean selected;
            IRow row = this.temTable.getRow(i);
            if (row == null || row.getCell("number") == null || (selected = (Boolean)row.getCell("select").getValue()) == null || !selected.booleanValue()) continue;
            temSelected.put(row.getCell("number").getValue(), null);
        }
        if (temSelected.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSchemeUnAssignResource", (String)"selectTemplate"));
            return;
        }
        if (this.chBoxTogether.isSelected()) {
            this.reStoreUnAssign(temSelected, this.treeOrgUnit.getModel().getRoot());
        }
        for (Object obj : this.unAssignInfo.values()) {
            BgSchemeUnAssignInfo info;
            String[] temNums;
            if (!(obj instanceof BgSchemeUnAssignInfo) || (temNums = (info = (BgSchemeUnAssignInfo)obj).getKeys()) == null || temNums.length == 0) continue;
            for (int i = 0; i < temNums.length; ++i) {
                BgSchemeUnAssignInfo.BgTemplateUnAssignInfo temp = info.getTemplate(temNums[i]);
                if (!temp.isSelected()) continue;
                if (temSelected.containsKey(temp.getNumber())) {
                    temSelected.put(temp.getNumber(), Boolean.TRUE);
                    continue;
                }
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSchemeUnAssignResource", (String)"orgUnit_template"));
                return;
            }
        }
        Iterator it = temSelected.values().iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSchemeUnAssignResource", (String)"selectOrgUnit"));
            return;
        }
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        final HashMap resMap = new HashMap();
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                return BgSchemeUnAssignFacadeFactory.getRemoteInstance().unAssignByTemplate(BgNSchemeUnAssignUI.this.unAssignInfo);
            }

            public void afterExec(Object result) throws Exception {
                resMap.put("result", result);
            }
        });
        dialog.show();
        if (resMap.get("result") instanceof Map) {
            this.showDetail((Map)resMap.get("result"));
        } else {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSchemeUnAssignResource", (String)"unAssignFail"));
        }
    }

    protected void showDetail(Map result) throws Exception {
        ArrayList<String> head = new ArrayList<String>();
        ArrayList content = new ArrayList();
        String strScheme = EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSchemeUnAssignResource", (String)"bgScheme");
        String strOrgUnit = EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSchemeUnAssignResource", (String)"bgSchemeOrg");
        String strSchemeResult = EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSchemeUnAssignResource", (String)"bgSchemeResult");
        final String strTemplate = EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSchemeUnAssignResource", (String)"bgTemplate");
        String strTemplateResult = EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSchemeUnAssignResource", (String)"bgTemplateResult");
        String success = EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSchemeUnAssignResource", (String)"success");
        String failure = EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSchemeUnAssignResource", (String)"fail");
        head.add(strScheme);
        head.add(strOrgUnit);
        head.add(strSchemeResult);
        head.add(strTemplate);
        head.add(strTemplateResult);
        HashMap<String, String> resMap = new HashMap<String, String>();
        resMap.put("executed", failure + EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSchemeUnAssignResource", (String)"executed"));
        resMap.put("refencedByBgFrom", failure + EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSchemeUnAssignResource", (String)"refencedByBgFrom"));
        resMap.put("refencedByOtherBgScheme", success + EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSchemeUnAssignResource", (String)"refencedByOtherBgScheme"));
        resMap.put("refencedByOtherTemplate", failure + EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSchemeUnAssignResource", (String)"refencedByOtherTemplate"));
        resMap.put("locked", failure + EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSchemeUnAssignResource", (String)"locked"));
        resMap.put("bgSchemeExecuted", failure + EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSchemeUnAssignResource", (String)"bgSchemeExecuted"));
        resMap.put("templateUnAssigned", failure + EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSchemeUnAssignResource", (String)"templateUnAssigned"));
        BgSchemeUnAssignInfo scheme = null;
        BgSchemeUnAssignInfo.BgTemplateUnAssignInfo temp = null;
        HashMap<String, String> sub = null;
        String[] temNums = null;
        for (Object obj : result.values()) {
            if (!(obj instanceof BgSchemeUnAssignInfo) || StringUtils.isEmpty((String)(scheme = (BgSchemeUnAssignInfo)obj).getOrgUnitName()) || (temNums = scheme.getKeys()) == null || temNums.length <= 0) continue;
            for (int i = 0; i < temNums.length; ++i) {
                temp = scheme.getTemplate(temNums[i]);
                if (!temp.isSelected()) continue;
                sub = new HashMap<String, String>();
                sub.put("orgLongNumber", scheme.getOrgUnitLongNumber());
                sub.put(strOrgUnit, scheme.getOrgUnitName());
                sub.put(strScheme, scheme.getBgSchemeNumber());
                sub.put(strTemplate, temp.getNumber());
                if (StringUtils.isEmpty((String)temp.getState())) {
                    sub.put(strTemplateResult, success);
                } else {
                    sub.put(strTemplateResult, (String)resMap.get(temp.getState()));
                }
                sub.put(strSchemeResult, scheme.isDeleted() ? success : failure);
                content.add(sub);
            }
        }
        Collections.sort(content, (Comparator)new Comparator(){

            public int compare(Object arg0, Object arg1) {
                int result = 0;
                Map l = (Map)arg0;
                Map r = (Map)arg1;
                result = ((String)l.get("orgLongNumber")).compareTo((String)r.get("orgLongNumber"));
                if (result == 0) {
                    result = ((String)l.get(strTemplate)).compareTo((String)r.get(strTemplate));
                }
                return result;
            }
        });
        UIContext uc = new UIContext((Object)this);
        uc.put((Object)"LIST_CONTENT", content);
        uc.put((Object)"LIST_HEAD_TITLE", head);
        uc.put((Object)"INVOKE_TIME", (Object)BgNationalFormatUIUtil.getNationalDateTimeFormat().format(new Date()));
        uc.put((Object)"UI_OWNER_TITLE", (Object)this.getUITitle());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BGReportUI.class.getName(), (Map)uc);
        uiWindow.show();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectAll_actionPerformed(e);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        if (this.treeOrgUnit.getSelectionPath() != null) {
            root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getSelectionPath().getLastPathComponent();
        }
        this.treeOrgUnitView(root, true);
        ((DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot()).setChecked(false);
        this.treeOrgUnit.repaint();
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnClearAll_actionPerformed(e);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        if (this.treeOrgUnit.getSelectionPath() != null) {
            root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getSelectionPath().getLastPathComponent();
        }
        this.treeOrgUnitView(root, false);
        this.treeOrgUnit.repaint();
    }

    private void treeOrgUnitView(DefaultKingdeeTreeNode rootNode, Boolean isSelected) throws Exception {
        final DefaultKingdeeTreeNode tmpNode = rootNode;
        final Boolean tmpSelected = isSelected;
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                BgNSchemeUnAssignUI.this.treeOrgUnitSelectAll(tmpNode, tmpSelected);
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
    }

    private void treeOrgUnitSelectAll(DefaultKingdeeTreeNode root, Boolean isSelected) throws Exception {
        if (root == null) {
            return;
        }
        if (isSelected != null && this.canTheNodeBeSelected(root)) {
            root.setChecked(isSelected.booleanValue());
        }
        if (this.chkIncludeChildren.isSelected()) {
            Enumeration children = root.children();
            while (children.hasMoreElements()) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
                if (isSelected != null && this.canTheNodeBeSelected(node)) {
                    node.setChecked(isSelected.booleanValue());
                }
                if (node.isLeaf()) continue;
                BgNFSHelper.addChildNode(node);
                this.treeOrgUnitSelectAll(node, isSelected);
            }
        } else {
            DefaultKingdeeTreeNode node = null;
            for (int i = 0; i < root.getParent().getChildCount(); ++i) {
                node = (DefaultKingdeeTreeNode)root.getParent().getChildAt(i);
                if (isSelected == null || !this.canTheNodeBeSelected(node)) continue;
                node.setChecked(isSelected.booleanValue());
            }
        }
    }

    @Override
    protected void temTable_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.temTable_tableSelectChanged(e);
        this.storeAndShowSelectInfo();
    }

    private void reStoreUnAssign(Map temSelected, Object node) {
        if (temSelected != null && !temSelected.isEmpty() && node instanceof DefaultKingdeeTreeNode) {
            OrgStructureInfo orgUnit;
            String orgUnitId;
            DefaultKingdeeTreeNode currNode = (DefaultKingdeeTreeNode)node;
            boolean isSelected = currNode.isChecked();
            if (currNode.getUserObject() instanceof OrgStructureInfo && this.unAssignInfo.get(orgUnitId = (orgUnit = (OrgStructureInfo)currNode.getUserObject()).getUnit().getId().toString()) instanceof BgSchemeUnAssignInfo) {
                BgSchemeUnAssignInfo scheme = (BgSchemeUnAssignInfo)this.unAssignInfo.get(orgUnitId);
                for (String key : temSelected.keySet()) {
                    BgSchemeUnAssignInfo.BgTemplateUnAssignInfo temp = scheme.getTemplate(key);
                    if (temp == null) {
                        scheme.addTemplate(key, null, "templateUnAssigned");
                        temp = scheme.getTemplate(key);
                    }
                    temp.setSelected(isSelected);
                }
            }
            if (!currNode.isLeaf() && currNode.getChildCount() > 0) {
                for (int i = 0; i < currNode.getChildCount(); ++i) {
                    this.reStoreUnAssign(temSelected, currNode.getChildAt(i));
                }
            }
        }
    }

    public Map<String, Map<String, Integer>> getDispatchInfo() {
        return this.dispatchInfo;
    }

    private void storeAndShowSelectInfo() throws Exception {
        int currIndex = this.temTable.getSelectManager().getActiveRowIndex();
        if (currIndex < 0) {
            return;
        }
        Object node = this.treeOrgUnit.getModel().getRoot();
        String temNumber = null;
        if (this.selectedIndex >= 0 && this.temTable.getRow(this.selectedIndex).getUserObject() != null) {
            temNumber = this.temTable.getCell(this.selectedIndex, "number").getValue().toString();
            this.storeUnAssignInfo(temNumber, node);
        }
        this.selectedIndex = currIndex;
        IRow row = this.temTable.getRow(this.selectedIndex);
        temNumber = row.getCell("number").getValue().toString();
        HashMap dispInfo = null;
        String bgTemplateId = this.getBgTemplateId();
        if (row.getUserObject() instanceof Map) {
            dispInfo = (HashMap)row.getUserObject();
        } else {
            dispInfo = BgTemplateFacadeFactory.getRemoteInstance().getDispatchInfo(bgTemplateId, this.bgSchemeId);
            this.getDispatchInfo().put(bgTemplateId, dispInfo);
            if (dispInfo == null) {
                dispInfo = new HashMap();
            }
            row.setUserObject((Object)dispInfo);
        }
        this.showUnAssignInfo(temNumber, node, dispInfo);
        this.treeOrgUnit.repaint();
    }

    protected String getBgTemplateId() {
        String bgTemplateId = null;
        if (this.temTable.getSelectManager().getActiveRowIndex() >= 0) {
            bgTemplateId = (String)this.temTable.getCell(this.temTable.getSelectManager().getActiveRowIndex(), "id").getValue();
        }
        return bgTemplateId;
    }

    private void storeUnAssignInfo(String temNumber, Object node) {
        if (StringUtils.isEmpty((String)temNumber) || !(node instanceof DefaultKingdeeTreeNode)) {
            return;
        }
        DefaultKingdeeTreeNode currNode = (DefaultKingdeeTreeNode)node;
        if (currNode.getUserObject() instanceof OrgStructureInfo) {
            OrgStructureInfo orgUnit = (OrgStructureInfo)currNode.getUserObject();
            String orgUnitId = orgUnit.getUnit().getId().toString();
            BgSchemeUnAssignInfo scheme = null;
            if (!this.unAssignInfo.containsKey(orgUnitId)) {
                scheme = new BgSchemeUnAssignInfo(orgUnitId, orgUnit.getLongNumber(), orgUnit.getUnit().getName(), this.bgSchemeId, this.bgSchemeNumber, true);
                this.unAssignInfo.put(orgUnitId, scheme);
            } else {
                scheme = (BgSchemeUnAssignInfo)this.unAssignInfo.get(orgUnitId);
            }
            BgSchemeUnAssignInfo.BgTemplateUnAssignInfo temp = scheme.getTemplate(temNumber);
            if (temp == null) {
                scheme.addTemplate(temNumber, null, "templateUnAssigned");
                temp = scheme.getTemplate(temNumber);
            }
            temp.setSelected(currNode.isChecked());
        }
        if (!currNode.isLeaf() && currNode.getChildCount() > 0) {
            for (int i = 0; i < currNode.getChildCount(); ++i) {
                this.storeUnAssignInfo(temNumber, currNode.getChildAt(i));
            }
        }
    }

    private void showUnAssignInfo(String temNumber, Object node, Map dispInfo) {
        if (StringUtils.isEmpty((String)temNumber) || !(node instanceof DefaultKingdeeTreeNode) && dispInfo != null) {
            return;
        }
        DefaultKingdeeTreeNode currNode = (DefaultKingdeeTreeNode)node;
        boolean isExists = false;
        boolean isSelected = false;
        if (currNode.getUserObject() instanceof OrgStructureInfo) {
            BgSchemeUnAssignInfo.BgTemplateUnAssignInfo temp;
            OrgStructureInfo orgUnit = (OrgStructureInfo)currNode.getUserObject();
            BgSchemeUnAssignInfo scheme = null;
            String orgUnitId = orgUnit.getUnit().getId().toString();
            boolean bl = isExists = dispInfo.get(orgUnitId) instanceof Integer && (Integer)dispInfo.get(orgUnitId) == 1;
            if (this.unAssignInfo.containsKey(orgUnitId) && (temp = (scheme = (BgSchemeUnAssignInfo)this.unAssignInfo.get(orgUnitId)).getTemplate(temNumber)) != null) {
                isSelected = temp.isSelected();
            }
        }
        currNode.setTextColor(isExists ? Color.RED : Color.BLACK);
        currNode.setChecked(isSelected);
        if (!currNode.isLeaf() && currNode.getChildCount() > 0) {
            for (int i = 0; i < currNode.getChildCount(); ++i) {
                this.showUnAssignInfo(temNumber, currNode.getChildAt(i), dispInfo);
            }
        }
    }

    @Override
    protected void temTable_tableClicked(KDTMouseEvent e) throws Exception {
        super.temTable_tableClicked(e);
    }

    @Override
    protected void btnSelectAllTem_actionPerformed(ActionEvent e) throws Exception {
        int i;
        super.btnSelectAllTem_actionPerformed(e);
        for (i = 0; i < this.temTable.getRowCount() - 1; ++i) {
            this.temTable.getRow(i).getCell("select").setValue((Object)Boolean.TRUE);
        }
        this.treeOrgUnit.repaint();
        for (i = 0; i < this.temTable.getRowCount() - 1; ++i) {
            this.doAfterConfirm(i);
        }
    }

    @Override
    protected void btnClearAllTem_actionPerformed(ActionEvent e) throws Exception {
        super.btnClearAllTem_actionPerformed(e);
        for (int i = 0; i < this.temTable.getRowCount() - 1; ++i) {
            this.temTable.getRow(i).getCell("select").setValue((Object)Boolean.FALSE);
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        this.setAllTreeNodesUncheckedOrChecked(root, false);
        this.treeOrgUnit.repaint();
    }

    @Override
    protected void chBoxTogether_actionPerformed(ActionEvent e) throws Exception {
        super.chBoxTogether_actionPerformed(e);
        if (this.chBoxTogether.isSelected()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSchemeUnAssignResource", (String)"togetherNotice"));
        }
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnSearch_actionPerformed(e);
        if (this.txtKey.getText() == null || this.txtKey.getText().trim().length() < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"195_BgCtrlSchemeAssignChildUI"));
            this.txtKey.requestFocus();
            return;
        }
        this.treeOrgUnitView((DefaultKingdeeTreeNode)this.orgTree.getRoot(), null);
        String value = this.txtKey.getText();
        SearchKeyEnum keyEnum = (SearchKeyEnum)this.comboSearchKey.getSelectedItem();
        if (keyEnum.getValue() == 10) {
            TreeModel model = NewOrgUtils.clipAndCloneTreeModel((TreeModel)this.orgTree, (String)"name", (String)value, (boolean)true);
            this.treeOrgUnit.setModel(model);
        } else if (keyEnum.getValue() == 0) {
            TreeModel model = NewOrgUtils.clipAndCloneTreeModel((TreeModel)this.orgTree, (String)"number", (String)value, (boolean)true);
            this.treeOrgUnit.setModel(model);
        }
        this.storeAndShowSelectInfo();
    }

    @Override
    protected void btnSelectNow_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectNow_actionPerformed(e);
        KDTSelectBlock sb = null;
        int size = this.temTable.getSelectManager().size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size && i != this.temTable.getRowCount() - 1 - 1; ++i) {
            sb = this.temTable.getSelectManager().get(i);
            int bottom = sb.getBottom();
            for (int j = sb.getTop(); j <= bottom; ++j) {
                this.temTable.getRow(j).getCell("select").setValue((Object)true);
            }
        }
    }

    private void initComBoxOrgType() {
        this.comBoxOrgType.addItem((Object)OrgViewType.COSTCENTER);
        this.comBoxOrgType.setSelectedItem((Object)OrgViewType.COSTCENTER);
        this.comBoxOrgType.setEditable(false);
        this.comBoxOrgType.setEnabled(false);
    }

    private void refreshOrgUnitTree() throws EASBizException, BOSException, SQLException {
        this.treeOrgUnit.setModel(null);
        OrgViewType orgViewType = (OrgViewType)this.comBoxOrgType.getSelectedItem();
        if (orgViewType == null) {
            return;
        }
        try {
            this.listener = new TreeWillExpandListener(){

                @Override
                public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                    Map<Object, Object> dispatchInfo = new HashMap();
                    String bgTemplateId = BgNSchemeUnAssignUI.this.getBgTemplateId();
                    if (BgNSchemeUnAssignUI.this.getDispatchInfo().containsKey(bgTemplateId)) {
                        dispatchInfo = BgNSchemeUnAssignUI.this.getDispatchInfo().get(bgTemplateId);
                    }
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                    try {
                        OrgUnitUtils.addChildNode((DefaultKingdeeTreeNode)node, dispatchInfo.keySet(), (boolean)false);
                    }
                    catch (Exception e) {
                        BgNSchemeUnAssignUI.this.handUIExceptionAndAbort(e);
                    }
                }

                @Override
                public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                }
            };
            BgSchemeInfo bgScheme = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo("select orgUnit.id where id='" + this.bgSchemeId + "'");
            String orgId = bgScheme.getOrgUnit().getId().toString();
            this.orgTree = OrgUnitUtils.getOrgTreeModel((KDTree)this.treeOrgUnit, (String)orgId, (TreeWillExpandListener)this.listener);
            this.treeOrgUnit.setShowCheckBox(true);
            this.treeOrgUnit.setModel(this.orgTree);
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.orgTree.getRoot();
            root.setCheckBoxVisible(false);
            root.setCheckBoxEnabled(false);
            BgNSchemeDispatchClientHelper.checkEmptyOrgTreeModel(this.orgTree);
        }
        catch (Exception err) {
            this.handUIException(err);
        }
    }

    private void initTable(BgTemplateCollection coll) throws Exception {
        this.temTable.checkParsed();
        this.temTable.getSelectManager().setSelectMode(10);
        this.temTable.getColumn(1).setWidth(40);
        this.temTable.removeRows();
        for (int i = 0; i < coll.size(); ++i) {
            BgTemplateInfo info = coll.get(i);
            IRow row = this.temTable.addRow();
            row.getCell("id").setValue((Object)info.getId().toString());
            row.getCell("select").setValue((Object)Boolean.FALSE);
            row.getCell("number").setValue((Object)info.getNumber());
            row.getCell("name").setValue((Object)info.getName());
            row.getCell("creator").setValue((Object)info.getCreator().getName());
            row.getCell("createtime").setValue((Object)info.getCreateTime());
            row.getCell("temType").setValue((Object)info.getFormType());
        }
        IRow row = this.temTable.addRow();
        row.getStyleAttributes().setHided(true);
    }

    private boolean canTheNodeBeSelected(DefaultKingdeeTreeNode node) {
        return node.isCheckBoxVisible() && node.isCheckBoxEnabled();
    }

    private void setAllTreeNodesUncheckedOrChecked(DefaultKingdeeTreeNode rootNode, boolean state) {
        rootNode.setChecked(state);
        Enumeration children = rootNode.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            if (node.isLeaf()) {
                node.setChecked(state);
                continue;
            }
            this.setAllTreeNodesUncheckedOrChecked(node, state);
        }
    }

    private void doAfterConfirm(int rowID) {
        String keyID = this.temTable.getRow(rowID).getCell("id").getValue().toString();
    }
}

