/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgTemMeasureUnitInfo;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.budget.OrgUnitUtils;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgExportHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgNTempletExportUI;
import com.kingdee.eas.ma.nbudget.client.BgExportResultUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgNTemplateToHelperFile;
import com.kingdee.eas.ma.nbudget.client.ExcelFileFilter;
import com.kingdee.eas.ma.nbudget.client.XmlFileFilter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgNTempletExportUI
extends AbstractBgNTempletExportUI {
    private static final long serialVersionUID = 251024242853433389L;
    private static final Logger logger = CoreUIObject.getLogger(BgNTempletExportUI.class);
    private Map bgTemplateIdsMap = null;

    protected static IPermission getPermissionInterface() throws Exception {
        return PermissionFactory.getRemoteInstance();
    }

    protected static IBgTemplate getTempleteInterface() throws Exception {
        return BgTemplateFactory.getRemoteInstance();
    }

    protected String getMessageStr(String key) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgNFormResource", (String)key) : "";
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.rbExcel.setEnabled(false);
        this.rbExcel.setVisible(false);
        this.rbXML.isSelected();
        this.txtFilepath.setText(BgExportHelper.getDefaultDirtory());
        this.bgTemplateIdsMap = (Map)this.getUIContext().get("ORGUNIT_ID");
    }

    protected void verify() throws Exception {
        if (StringUtils.isEmpty((String)this.txtFilepath.getText())) {
            this.txtFilepath.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "selectOutFilepath"));
            SysUtil.abort();
        } else {
            File file = new File(this.txtFilepath.getText());
            if (!file.isDirectory()) {
                this.txtFilepath.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "errorFilepath"));
                SysUtil.abort();
            }
        }
    }

    @Override
    protected void btnSelectPath_actionPerformed(ActionEvent e) throws Exception {
        String path = this.txtFilepath.getText();
        KDFileChooser fc = new KDFileChooser();
        fc.setFileSelectionMode(1);
        fc.setDialogTitle(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "export"));
        if (this.rbExcel.isSelected()) {
            fc.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        } else {
            fc.addChoosableFileFilter((FileFilter)new XmlFileFilter());
        }
        fc.setCurrentDirectory(new File(path));
        if (fc.showSaveDialog((Component)((Object)this)) == 0) {
            File file = fc.getSelectedFile();
            this.txtFilepath.setText(file.getPath());
        }
    }

    @Override
    protected void btnExport_actionPerformed(ActionEvent e) throws Exception {
        int re;
        this.verify();
        if (this.rbExcel.isSelected() && (re = MsgBox.showConfirm2((String)this.getMessageStr("rbSelectExcel"))) != 0) {
            return;
        }
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                IObjectPK pk = LogUtil.beginLog(null, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "batchExport"), (BOSObjectType)new BgFormInfo().getBOSType(), null, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "batchExport"), (String)"bgScheme_export");
                List reList = BgNTempletExportUI.this.exportFile(BgNTempletExportUI.this.txtFilepath.getText(), BgNTempletExportUI.this.bgTemplateIdsMap);
                LogUtil.afterLog(null, (IObjectPK)pk);
                return reList;
            }

            public void afterExec(Object result) throws Exception {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"EXAMINE_DATA", result);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)BgNTempletExportUI.this.getModel()).create(BgExportResultUI.class.getName(), (Map)uiContext);
                uiWindow.show();
            }
        });
        dialog.show();
        this.getUIWindow().close();
    }

    protected String getModel() {
        if (this.getUIWindow() instanceof Frame) {
            return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List exportFile(String filepath, Map bgTemplateIdsMap) throws Exception {
        ArrayList _exportInfoList = new ArrayList();
        HashSet<BOSUuid> _orgPermissionSet = new HashSet<BOSUuid>();
        FullOrgUnitCollection _fullOrgColl = null;
        CostCenterOrgUnitInfo _ccOrgUnitInfo = SysContext.getSysContext().getCurrentCostUnit();
        UserInfo _userInfo = SysContext.getSysContext().getCurrentUserInfo();
        DefaultKingdeeTreeNode root = null;
        try {
            root = (DefaultKingdeeTreeNode)this.getUIContext().get("OrgUnit");
            _fullOrgColl = BgNFSHelper.getOrgPermission((IObjectPK)new ObjectUuidPK(_userInfo.getId()));
            if (_ccOrgUnitInfo != null) {
                for (int i = 0; i < _fullOrgColl.size(); ++i) {
                    _orgPermissionSet.add(_fullOrgColl.get(i).getId());
                }
            }
            this.exportOrgUnitFile(root, _orgPermissionSet, _exportInfoList, filepath, bgTemplateIdsMap);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return _exportInfoList;
    }

    protected void exportOrgUnitFile(DefaultKingdeeTreeNode root, Set permissionSet, List exportInfoList, String filepath, Map bgTemplateIdsMap) throws Exception {
        block8: {
            FullOrgUnitInfo _orgUnitInfo;
            String[] _tmpbgFormInfo;
            String[] _exportInfo;
            String _tmpOrgUnitId;
            block9: {
                OrgStructureInfo _oui;
                if (root == null || OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)root)) {
                    return;
                }
                String _tmpFilepath = null;
                _tmpOrgUnitId = null;
                String _tmpbgFormId = null;
                _exportInfo = null;
                _tmpbgFormInfo = null;
                _orgUnitInfo = null;
                DefaultKingdeeTreeNode _node = null;
                if (root.getChildCount() == 1 && ((DefaultKingdeeTreeNode)root.getChildAt(0)).getUserObject() == null) {
                    OrgUnitUtils.addChildNode((DefaultKingdeeTreeNode)root, null);
                }
                if ((_oui = (OrgStructureInfo)root.getUserObject()).getUnit() == null) break block8;
                _orgUnitInfo = _oui.getUnit();
                _tmpOrgUnitId = _orgUnitInfo.getId().toString();
                if (!permissionSet.contains(_orgUnitInfo.getId())) break block9;
                this.exportDirectory(filepath, _orgUnitInfo);
                if (bgTemplateIdsMap.containsKey(_tmpOrgUnitId)) {
                    if (this.rbExcel.isSelected()) {
                        this.exportExcelFile(_orgUnitInfo, filepath, bgTemplateIdsMap, exportInfoList);
                    } else if (this.rbXML.isSelected()) {
                        this.exportXmlFile(_orgUnitInfo, filepath, bgTemplateIdsMap, exportInfoList);
                    }
                }
                _tmpFilepath = filepath + "/" + _orgUnitInfo.getName().replaceAll(" ", "");
                int in = root.getChildCount();
                for (int i = 0; i < in; ++i) {
                    _node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                    this.exportOrgUnitFile(_node, permissionSet, exportInfoList, _tmpFilepath, bgTemplateIdsMap);
                }
                break block8;
            }
            if (!bgTemplateIdsMap.containsKey(_tmpOrgUnitId)) break block8;
            Map _tmpBgFormIdsMap = (Map)bgTemplateIdsMap.get(_tmpOrgUnitId);
            for (String _tmpbgFormId : _tmpBgFormIdsMap.keySet()) {
                _tmpbgFormInfo = (String[])_tmpBgFormIdsMap.get(_tmpbgFormId);
                _exportInfo = new String[]{_orgUnitInfo.getName(), _tmpbgFormInfo[1] + " - " + _tmpbgFormInfo[2], EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgIEResource", (String)"errorPermission")};
                exportInfoList.add(_exportInfo);
            }
        }
    }

    protected void exportDirectory(String filepath, FullOrgUnitInfo orgUnitInfo) {
        if (StringUtils.isEmpty((String)filepath) || orgUnitInfo == null) {
            return;
        }
        File _file = new File(filepath + "/" + orgUnitInfo.getName().replaceAll(" ", ""));
        if (!_file.exists()) {
            _file.mkdir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportExcelFile(FullOrgUnitInfo orgUnitInfo, String filepath, Map bgTempleteIdsMap, List exportInfoList) {
        if (orgUnitInfo == null || StringUtils.isEmpty((String)filepath)) {
            return;
        }
        String _bgTempleteId2 = null;
        StringBuffer filename = null;
        StringBuffer filename2 = null;
        BgTemplateInfo _bgTemplateInfo = null;
        ExportManager em = null;
        Book _book = null;
        Object _sheet = null;
        Object _cell = null;
        KDSBook _kdsBook = null;
        Object _kdsSheet = null;
        Object _ksCell = null;
        Object _formulaStr = null;
        Object _parameter = null;
        String[] _exportInfo = null;
        Object _value = null;
        Object _coefficient = null;
        Object _tmpCoefficient = null;
        boolean rowIndex = false;
        boolean rowCount = false;
        boolean colIndex = false;
        boolean colCount = false;
        HashMap<String, BigDecimal> _muMap = new HashMap<String, BigDecimal>();
        Map _tmpBgTempleteIdsMap = (Map)bgTempleteIdsMap.get(orgUnitInfo.getId().toString());
        for (String _bgTempleteId2 : _tmpBgTempleteIdsMap.keySet()) {
            try {
                _bgTemplateInfo = BgNTempletExportUI.getTempleteInterface().getBgTemplateInfo((IObjectPK)new ObjectUuidPK(_bgTempleteId2), this.getSelector());
                if (_bgTemplateInfo == null) {
                    return;
                }
                if (_bgTemplateInfo.getBgMeasureUnit() != null) {
                    BgTemMeasureUnitInfo _muInfo2 = null;
                    for (BgTemMeasureUnitInfo _muInfo2 : _bgTemplateInfo.getBgMeasureUnit()) {
                        _muMap.put(_muInfo2.getBgElement().getNumber(), _muInfo2.getMeasureUnit().getCoefficient());
                    }
                }
                filename = new StringBuffer();
                filename.append(orgUnitInfo.getName().trim());
                filename.append("_");
                filename.append(_bgTemplateInfo.getName().trim());
                filename.append("_");
                filename.append(_bgTemplateInfo.getNumber().trim());
                filename.append("_");
                if (_bgTemplateInfo.getBgType() != null) {
                    filename.append(_bgTemplateInfo.getBgType().getName().trim());
                    filename.append("_");
                }
                filename.append(_bgTemplateInfo.getFormType().toString().trim());
                _book = _bgTemplateInfo.getBook();
                BgNFSHelper.disableCal(_book);
                BgNFSHelper.disableUndo(_book);
                HashMap<String, Object> _tmpMap = new HashMap<String, Object>();
                _tmpMap.put("EXPORT_BOOK", _book);
                _tmpMap.put("EXPORT_MEASUREUNIT", _muMap);
                _tmpMap.put("EXPORT_BGFORMULA", null);
                _tmpMap.put("EXPORT_DATA", Boolean.FALSE);
                _kdsBook = BgNFCHelper.exportExcel(_tmpMap);
                em = new ExportManager();
                em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"true");
                em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"true");
                em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
                em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
                if (this.rbDataANDExpression.isSelected()) {
                    em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                    em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
                    em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"true");
                } else if (this.rbDataANDExcelExpression.isSelected()) {
                    em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                    em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
                    em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
                } else if (this.rbData.isSelected()) {
                    em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
                }
                filename.append(".data");
                BgNTemplateToHelperFile.saveDataToFile(_bgTemplateInfo, filepath + ("/" + orgUnitInfo.getName() + "/" + filename.toString()).replaceAll(" ", ""));
                filename2 = new StringBuffer(filename.substring(0, filename.lastIndexOf(".")));
                filename2.append(".xls");
                em.exportToExcel(_kdsBook, filepath + ("/" + orgUnitInfo.getName() + "/" + filename2.toString()).replaceAll(" ", ""));
                _exportInfo = new String[]{orgUnitInfo.getName(), _bgTemplateInfo.getNumber() + " - " + _bgTemplateInfo.getName(), EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgIEResource", (String)"export_succeed")};
                exportInfoList.add(_exportInfo);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                _exportInfo = new String[3];
                _exportInfo[0] = orgUnitInfo.getName();
                if (_bgTemplateInfo != null) {
                    _exportInfo[1] = _bgTemplateInfo.getNumber() + " - " + _bgTemplateInfo.getName();
                }
                _exportInfo[2] = EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgIEResource", (String)"export_error");
                exportInfoList.add(_exportInfo);
            }
            finally {
                _kdsBook = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportXmlFile(FullOrgUnitInfo orgUnitInfo, String filepath, Map bgTempleteIdsMap, List exportInfoList) {
        if (orgUnitInfo == null || StringUtils.isEmpty((String)filepath)) {
            return;
        }
        String _bgTempleteId2 = null;
        StringBuffer filename = null;
        StringBuffer filename2 = null;
        BgTemplateInfo _bgTemplateInfo = null;
        Book _book = null;
        String[] _exportInfo = null;
        Map _tmpBgTempleteIdsMap = (Map)bgTempleteIdsMap.get(orgUnitInfo.getId().toString());
        for (String _bgTempleteId2 : _tmpBgTempleteIdsMap.keySet()) {
            try {
                _bgTemplateInfo = BgNTempletExportUI.getTempleteInterface().getBgTemplateInfo((IObjectPK)new ObjectUuidPK(_bgTempleteId2), this.getSelector());
                if (_bgTemplateInfo == null) {
                    return;
                }
                filename = new StringBuffer();
                filename.append(orgUnitInfo.getName().trim());
                filename.append("_");
                filename.append(_bgTemplateInfo.getName().trim());
                filename.append("_");
                filename.append(_bgTemplateInfo.getNumber().trim());
                filename.append("_");
                if (_bgTemplateInfo.getBgType() != null) {
                    filename.append(_bgTemplateInfo.getBgType().getName().trim());
                    filename.append("_");
                }
                filename.append(_bgTemplateInfo.getFormType().getAlias().trim());
                _book = _bgTemplateInfo.getBook();
                BgNFSHelper.disableCal(_book);
                BgNFSHelper.disableUndo(_book);
                filename.append(".data");
                BgNTemplateToHelperFile.saveDataToFile(_bgTemplateInfo, filepath + ("/" + orgUnitInfo.getName() + "/" + filename.toString()).replaceAll(" ", ""));
                filename2 = new StringBuffer(filename.substring(0, filename.lastIndexOf(".")));
                filename2.append(".xml");
                if (_bgTemplateInfo.getFormType().getValue() == 1) {
                    HashMap sheetInfo = new HashMap();
                    for (int i = 0; i < _book.getSheetCount(); ++i) {
                        Sheet sheet = _book.getSheet(i);
                        HashMap<String, Object> subSheet = new HashMap<String, Object>();
                        subSheet.put("SHEET_NAME_ID", sheet.getID());
                        subSheet.put("SHEET_COL_IDS", BgNFSHelper.getColIDMapInfo(sheet));
                        subSheet.put("SHEET_ROW_IDS", BgNFSHelper.getRowIDMapInfo(sheet));
                        sheetInfo.put(sheet.getSheetName(), subSheet);
                    }
                    _book.setUserObject("SHEET_INFO_IMPORT", (Object)Base64.encodeBytes((byte[])BgAnalyseHelper.getBytes(sheetInfo)));
                }
                IOHelper.saveToFile((Book)_book, (String)(filepath + ("/" + orgUnitInfo.getName() + "/" + filename2.toString()).replaceAll(" ", "")));
                _exportInfo = new String[]{orgUnitInfo.getName(), _bgTemplateInfo.getNumber() + " - " + _bgTemplateInfo.getName(), EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgIEResource", (String)"export_succeed")};
                exportInfoList.add(_exportInfo);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                _exportInfo = new String[3];
                _exportInfo[0] = orgUnitInfo.getName();
                if (_bgTemplateInfo != null) {
                    _exportInfo[1] = _bgTemplateInfo.getNumber() + " - " + _bgTemplateInfo.getName();
                }
                _exportInfo[2] = EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgIEResource", (String)"export_error");
                exportInfoList.add(_exportInfo);
            }
            finally {
                _book = null;
            }
        }
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("bgType.*"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("isAllowChange"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("mapData"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("bgMeasureUnit"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.*"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.*"));
        sic.add(new SelectorItemInfo("defaultMeasureUnit.*"));
        sic.add(new SelectorItemInfo("formType"));
        sic.add("*");
        return sic;
    }
}

