/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgFacadeFactory;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.BgTemplateFacadeFactory;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgFacade;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgExportHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgNTempletImportUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgNTemplateImportResultUI;
import com.kingdee.eas.ma.nbudget.client.BgNTemplateToHelperFile;
import com.kingdee.eas.ma.nbudget.client.ExcelFileFilter;
import com.kingdee.eas.ma.nbudget.client.XmlFileFilter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.eas.util.encryptalgorithm.Base64;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class BgNTempletImportUI
extends AbstractBgNTempletImportUI {
    private static final Logger logger = CoreUIObject.getLogger(BgNTempletImportUI.class);
    private IPermission iPermission = null;
    private IFullOrgUnit ifullOrgUnit = null;

    protected String getMessageStr(String key) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgNFormResource", (String)key) : "";
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.rbXML.isSelected();
        this.rbExcel.setEnabled(false);
        this.rbExcel.setVisible(false);
        this.txtFilepath.setText(BgExportHelper.getDefaultDirtory());
    }

    protected void verify() throws Exception {
        if (StringUtils.isEmpty((String)this.txtFilepath.getText())) {
            this.txtFilepath.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "selectOutFilepath"));
            SysUtil.abort();
        } else {
            File file = new File(this.txtFilepath.getText());
            if (!file.isDirectory()) {
                this.txtFilepath.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "errorFilepath"));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnSelectPath_actionPerformed(ActionEvent e) throws Exception {
        String path = this.txtFilepath.getText();
        KDFileChooser fc = new KDFileChooser();
        fc.setFileSelectionMode(1);
        fc.setDialogTitle(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "import"));
        if (this.rbExcel.isSelected()) {
            fc.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        } else {
            fc.addChoosableFileFilter((FileFilter)new XmlFileFilter());
        }
        fc.setCurrentDirectory(new File(path));
        if (fc.showSaveDialog((Component)((Object)this)) == 0) {
            File file = fc.getSelectedFile();
            this.txtFilepath.setText(file.getPath());
        }
    }

    @Override
    protected void btnImport_actionPerformed(ActionEvent e) throws Exception {
        super.btnImport_actionPerformed(e);
        this.verify();
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                Map result = null;
                try {
                    result = BgNTempletImportUI.this.importFile(BgNTempletImportUI.this.txtFilepath.getText());
                }
                catch (Exception ex) {
                    BgNTempletImportUI.this.handUIExceptionAndAbort(ex);
                }
                return result;
            }

            public void afterExec(Object result) throws Exception {
                if (result != null && result instanceof Map) {
                    BgNTempletImportUI.this.openImportResultViewUI(result);
                }
            }
        });
        dialog.show();
        this.getUIWindow().close();
    }

    protected void openImportResultViewUI(Object obj) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"EXAMINE_DATA", obj);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.openImportResultModel()).create(BgNTemplateImportResultUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    protected String openImportResultModel() {
        if (this.getUIWindow() instanceof Frame) {
            return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    public Map importFile(String filepath) throws Exception {
        HashSet<BOSUuid> orgRangesSet = new HashSet<BOSUuid>();
        HashMap<String, Cloneable> resultMap = new HashMap<String, Cloneable>();
        HashMap dataMap = new HashMap();
        ArrayList orgUnitList = new ArrayList();
        HashMap imOrgUnitMap = new HashMap();
        HashMap imOrgFileMap = new HashMap();
        UserInfo userInfo = null;
        FullOrgUnitCollection orgRangesColl = null;
        TreeModel model = null;
        DefaultKingdeeTreeNode root = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("rootId");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        resultMap.put("IMPORT_ORGUNIT_LIST", orgUnitList);
        resultMap.put("IMPORT_ORGUNIT_INFO", imOrgUnitMap);
        resultMap.put("IMPORT_ORGUNIT_FILES", imOrgFileMap);
        CostCenterOrgUnitInfo _ccOrgUnitInfo = SysContext.getSysContext().getCurrentCostUnit();
        userInfo = SysContext.getSysContext().getCurrentUserInfo();
        FullOrgUnitCollection orgCol = this.getBgFacadeInterface().getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.CostCenter, null, "bg_template02_addNew");
        model = BgNFSHelper.getOrgTreeModel(_ccOrgUnitInfo.getId().toString(), null);
        root = (DefaultKingdeeTreeNode)this.getUIContext().get("OrgUnit");
        orgRangesColl = BgNFSHelper.getOrgPermission((IObjectPK)new ObjectUuidPK(userInfo.getId()));
        for (int i = 0; i < orgRangesColl.size(); ++i) {
            orgRangesSet.add(orgRangesColl.get(i).getId());
        }
        this.importOrgUnitFile(root, filepath, orgRangesSet, resultMap, dataMap, orgCol);
        return resultMap;
    }

    private void importOrgUnitFile(DefaultKingdeeTreeNode node, String filepath, Set orgRangeSet, Map resultMap, Map dataMap, FullOrgUnitCollection orgCol) throws Exception {
        OrgStructureInfo oui;
        FullOrgUnitInfo orgUnitInfo = null;
        FullOrgUnitInfo _tmpOrgUnitInfo = null;
        if (node != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node) && (oui = (OrgStructureInfo)node.getUserObject()) != null && oui.getUnit() != null && orgRangeSet.contains((orgUnitInfo = oui.getUnit()).getId())) {
            File _file = null;
            File _tmpFile2 = null;
            File[] _files = null;
            _file = new File(filepath);
            if (_file.exists() && _file.isDirectory()) {
                for (File _tmpFile2 : _file.listFiles()) {
                    if (_tmpFile2 == null || !_tmpFile2.isDirectory() || !_tmpFile2.getName().equalsIgnoreCase(orgUnitInfo.getName().trim())) continue;
                    if (orgUnitInfo.getCU() == null) {
                        _tmpOrgUnitInfo = this.getFullOrgUnitInterface().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), this.getOrgUnitCUIdSelector());
                        orgUnitInfo.setCU(_tmpOrgUnitInfo.getCU());
                    }
                    String _tmpFilepath = filepath + "/" + orgUnitInfo.getName().trim();
                    if (this.rbExcel.isSelected()) {
                        this.importExcelFile(_tmpFilepath, orgUnitInfo, resultMap, dataMap, orgCol);
                    } else if (this.rbXML.isSelected()) {
                        this.importXMLlFile(_tmpFilepath, orgUnitInfo, resultMap, dataMap, orgCol);
                    }
                    for (int i = 0; i < node.getChildCount(); ++i) {
                        DefaultKingdeeTreeNode _node = (DefaultKingdeeTreeNode)node.getChildAt(i);
                        this.importOrgUnitFile(_node, _tmpFilepath, orgRangeSet, resultMap, dataMap, orgCol);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importExcelFile(String filepath, FullOrgUnitInfo fullOrgUnitInfo, Map resultMap, Map dataMap, FullOrgUnitCollection orgCol) throws BOSException {
        File _file = null;
        File _tmpFile = null;
        File[] _files = null;
        List orgUnitList = (List)resultMap.get("IMPORT_ORGUNIT_LIST");
        Map imOrgUnitMap = (Map)resultMap.get("IMPORT_ORGUNIT_INFO");
        Map imOrgFileMap = (Map)resultMap.get("IMPORT_ORGUNIT_FILES");
        HashMap imFileResultMap = new HashMap();
        ArrayList<String> imFileName = new ArrayList<String>();
        ArrayList<String> imFileResult = new ArrayList<String>();
        imFileResultMap.put("IMPORT_FILES_NAME", imFileName);
        imFileResultMap.put("IMPORT_FILES_RESULT", imFileResult);
        String _orgUnitId = fullOrgUnitInfo.getId().toString();
        String _succeed = BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "import_succeed");
        orgUnitList.add(_orgUnitId);
        imOrgUnitMap.put(_orgUnitId, fullOrgUnitInfo.getName());
        imOrgFileMap.put(_orgUnitId, imFileResultMap);
        _file = new File(filepath);
        OrgUnitInfo orgUnitInfohas = null;
        if (_file.getName().equals(fullOrgUnitInfo.getName().trim())) {
            orgUnitInfohas = this.checkHasPermmision(_file.getName(), orgCol);
        }
        List list = null;
        if (orgUnitInfohas != null) {
            list = BgTemplateFacadeFactory.getRemoteInstance().getTemplateNumbers(orgUnitInfohas.getId().toString());
        }
        if (_file.exists() && _file.isDirectory() && orgUnitInfohas != null) {
            _files = _file.listFiles();
            if (!_file.getName().equals(fullOrgUnitInfo.getName().trim())) {
                imFileName.add(this.getMessageStr("bgNtemplaetExportOrgs") + _file.getName());
                imFileResult.add(this.getMessageStr("bgNtemplaetExportNotOrgs"));
            }
            BgTemplateInfo bgTemplateInfo = null;
            File file = null;
            int count = _files.length;
            for (int index = 0; index < count; ++index) {
                _tmpFile = _files[index];
                try {
                    if (!this.checkFilenameData(_tmpFile)) continue;
                    bgTemplateInfo = BgNTemplateToHelperFile.getDataToFile(_tmpFile.toString());
                    file = this.getFile(_files, _tmpFile.getName());
                    if (file == null) continue;
                    if (!file.getName().substring(file.getName().lastIndexOf(".")).equals(".xls")) {
                        imFileName.add(this.getMessageStr("bgNtemplaetExportWaringFile"));
                        imFileResult.add(this.getMessageStr("bgNtemplaetImportFaild"));
                        break;
                    }
                    if (list.contains(bgTemplateInfo.getNumber())) {
                        imFileName.add(file.getName());
                        imFileResult.add(this.getMessageStr("bgNtemplaetImportTemplateHave"));
                        continue;
                    }
                    if (bgTemplateInfo.getFormType().equals((Object)BgTemFormTypeEnum.SCRIPTFORM) && !BgNSHelper.isCanUseScript()) {
                        imFileName.add(file.getName());
                        imFileResult.add(this.getMessageStr("bgNtemplaetImportWorkNotOpen"));
                        continue;
                    }
                    KDSBook kdsBook = POIXlsReader.parse((String)file.getPath());
                    Book _book = bgTemplateInfo.getBook();
                    bgTemplateInfo.getBook().clear();
                    HashMap<String, Object> _tmpMap = new HashMap<String, Object>();
                    _tmpMap.put("IMPORT_BOOK", _book);
                    _tmpMap.put("IMPORT_KDSBOOK", kdsBook);
                    if (this.rbAllData.isSelected()) {
                        _tmpMap.put("ExcelImportType", "ALLDATA");
                    } else if (this.rbNumber.isSelected()) {
                        _tmpMap.put("ExcelImportType", "Number");
                    } else {
                        _tmpMap.put("ExcelImportType", "Famula");
                    }
                    bgTemplateInfo.setBook(null);
                    bgTemplateInfo.setBook(BgNFCHelper.importExcelWithTemplate(_tmpMap));
                    BgTemplateFactory.getRemoteInstance().addnew((CoreBaseInfo)bgTemplateInfo);
                    imFileName.add(file.getName());
                    imFileResult.add(_succeed);
                }
                catch (Exception ex) {
                    if (file != null) {
                        imFileName.add(file.getName());
                    }
                    imFileResult.add(this.getMessageStr("bgnTemplateImportException") + ex.getMessage());
                    logger.error((Object)ex);
                }
                continue;
            }
        } else {
            imFileName.add(this.getMessageStr("bgNtemplaetExportOrgs") + _file.getName());
            imFileResult.add(this.getMessageStr("bgNtemplateImportNotAddNewPermission"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importXMLlFile(String filepath, FullOrgUnitInfo fullOrgUnitInfo, Map resultMap, Map dataMap, FullOrgUnitCollection orgCol) throws BOSException, EASBizException {
        File _file = null;
        File _tmpFile = null;
        File[] _files = null;
        List orgUnitList = (List)resultMap.get("IMPORT_ORGUNIT_LIST");
        Map imOrgUnitMap = (Map)resultMap.get("IMPORT_ORGUNIT_INFO");
        Map imOrgFileMap = (Map)resultMap.get("IMPORT_ORGUNIT_FILES");
        HashMap imFileResultMap = new HashMap();
        ArrayList<String> imFileName = new ArrayList<String>();
        ArrayList<String> imFileResult = new ArrayList<String>();
        imFileResultMap.put("IMPORT_FILES_NAME", imFileName);
        imFileResultMap.put("IMPORT_FILES_RESULT", imFileResult);
        String _orgUnitId = fullOrgUnitInfo.getId().toString();
        String _succeed = BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "import_succeed");
        orgUnitList.add(_orgUnitId);
        imOrgUnitMap.put(_orgUnitId, fullOrgUnitInfo.getName());
        imOrgFileMap.put(_orgUnitId, imFileResultMap);
        _file = new File(filepath);
        OrgUnitInfo orgUnitInfohas = null;
        if (_file.getName().equals(fullOrgUnitInfo.getName().trim())) {
            orgUnitInfohas = this.checkHasPermmision(_file.getName(), orgCol);
        }
        List list = null;
        if (orgUnitInfohas != null) {
            list = BgTemplateFacadeFactory.getRemoteInstance().getTemplateNumbers(orgUnitInfohas.getId().toString());
        }
        if (_file.exists() && _file.isDirectory() && orgUnitInfohas != null) {
            _files = _file.listFiles();
            if (!_file.getName().equals(fullOrgUnitInfo.getName().trim())) {
                imFileName.add(this.getMessageStr("bgNtemplaetExportOrgs") + _file.getName());
                imFileResult.add(this.getMessageStr("bgNtemplaetExportNotOrgs"));
            }
            BgTemplateInfo bgTemplateInfo = null;
            File file = null;
            CoreBaseCollection bgc = new CoreBaseCollection();
            int count = _files.length;
            for (int index = 0; index < count; ++index) {
                _tmpFile = _files[index];
                try {
                    if (!this.checkFilenameData(_tmpFile)) continue;
                    bgTemplateInfo = BgNTemplateToHelperFile.getDataToFile(_tmpFile.toString());
                    file = this.getFile(_files, _tmpFile.getName());
                    if (file == null) continue;
                    if (!file.getName().substring(file.getName().lastIndexOf(".")).equals(".xml")) {
                        imFileName.add(this.getMessageStr("bgNtemplaetExportWaringFile"));
                        imFileResult.add(this.getMessageStr("bgNtemplaetImportFaild"));
                        break;
                    }
                    if (list.contains(bgTemplateInfo.getNumber())) {
                        imFileName.add(file.getName());
                        imFileResult.add(this.getMessageStr("bgNtemplaetImportTemplateHave"));
                        continue;
                    }
                    if (bgTemplateInfo.getFormType().equals((Object)BgTemFormTypeEnum.SCRIPTFORM) && !BgNSHelper.isCanUseScript()) {
                        imFileName.add(file.getName());
                        imFileResult.add(this.getMessageStr("bgNtemplaetImportWorkNotOpen"));
                        continue;
                    }
                    Book book = IOHelper.loadFile((String)file.getPath());
                    Map sheetInfo = this.getBookUserObject(book, "SHEET_INFO_IMPORT");
                    for (int i = 0; i < book.getSheetCount(); ++i) {
                        Sheet sheet = book.getSheet(i);
                        String sheetName = book.getSheetName(i);
                        Map subSheet = (Map)sheetInfo.get(sheetName);
                        if (subSheet == null || subSheet.isEmpty()) continue;
                        String id2 = null;
                        Integer num = null;
                        Map id_num = (Map)subSheet.get("SHEET_ROW_IDS");
                        if (id_num != null) {
                            for (String id2 : id_num.keySet()) {
                                num = (Integer)id_num.get(id2);
                                BgNFSHelper.setRowSign(sheet.getRow(num.intValue(), true), id2);
                            }
                        }
                        if ((id_num = (Map)subSheet.get("SHEET_COL_IDS")) != null) {
                            for (String id2 : id_num.keySet()) {
                                num = (Integer)id_num.get(id2);
                                BgNFSHelper.setColSign(sheet.getColumn(num.intValue(), true), id2);
                            }
                        }
                        sheet.setID((String)subSheet.get("SHEET_NAME_ID"));
                    }
                    HashMap<String, Object> _tmpMap = new HashMap<String, Object>();
                    _tmpMap.put("IMPORT_BOOK", book);
                    if (this.rbAllData.isSelected()) {
                        _tmpMap.put("ExcelImportType", "ALLDATA");
                    } else if (this.rbNumber.isSelected()) {
                        _tmpMap.put("ExcelImportType", "Number");
                    } else {
                        _tmpMap.put("ExcelImportType", "Famula");
                    }
                    bgTemplateInfo.getBook().clear();
                    bgTemplateInfo.setBook(null);
                    bgTemplateInfo.setBook(BgNFCHelper.importXmlWithTemplate(_tmpMap));
                    if (bgTemplateInfo.getId() != null) {
                        bgTemplateInfo.setId(null);
                    }
                    if (bgTemplateInfo.getRootId() != null) {
                        bgTemplateInfo.setRootId(null);
                    }
                    bgTemplateInfo.setParent(bgTemplateInfo);
                    bgc.add((CoreBaseInfo)bgTemplateInfo);
                    imFileName.add(file.getName());
                    imFileResult.add(_succeed);
                }
                catch (Exception ex) {
                    if (file != null) {
                        imFileName.add(file.getName());
                    }
                    imFileResult.add(this.getMessageStr("bgnTemplateImportException") + ex.getMessage());
                    logger.error((Object)ex);
                }
                continue;
            }
            BgTemplateFactory.getRemoteInstance().addnewBatchData(bgc);
        } else {
            imFileName.add(this.getMessageStr("bgNtemplaetExportOrgs") + _file.getName());
            imFileResult.add(this.getMessageStr("bgNtemplateImportNotAddNewPermission"));
        }
    }

    protected Map getBookUserObject(Book book, String key) {
        if (book != null && book.getUserObjectValue(key) instanceof String) {
            return (Map)BgAnalyseHelper.getObject((byte[])Base64.decode((String)((String)book.getUserObjectValue(key))));
        }
        return new HashMap();
    }

    private File getFile(File[] _files, String fileName) {
        for (int i = 0; i < _files.length; ++i) {
            String name;
            if (!_files[i].isFile() || !(name = _files[i].getName().substring(0, _files[i].getName().lastIndexOf("."))).equals(fileName.substring(0, fileName.lastIndexOf("."))) || this.checkFilenameData(_files[i])) continue;
            return _files[i];
        }
        return null;
    }

    private OrgUnitInfo checkHasPermmision(String diretoryName, FullOrgUnitCollection orgCol) {
        FullOrgUnitInfo orgUnitInfo = null;
        for (int i = 0; i < orgCol.size(); ++i) {
            orgUnitInfo = orgCol.get(i);
            if (!diretoryName.equals(orgUnitInfo.getName().trim())) continue;
            return orgUnitInfo;
        }
        return null;
    }

    private boolean checkFilenameData(File file) {
        boolean flage = false;
        if (file == null || StringUtils.isEmpty((String)file.getName()) || file.isDirectory()) {
            return false;
        }
        String _filename = file.getName();
        String postfix = null;
        if (_filename.indexOf(".") != -1) {
            postfix = _filename.substring(_filename.lastIndexOf("."));
        }
        if (postfix != null && postfix.equalsIgnoreCase(".data")) {
            flage = true;
        }
        return flage;
    }

    private boolean checkFileDirectoryWithOrgName(File file, FullOrgUnitInfo orgUnitInfo) {
        if (file == null || StringUtils.isEmpty((String)file.getName()) || orgUnitInfo == null || StringUtils.isEmpty((String)orgUnitInfo.getName())) {
            return false;
        }
        String _filename = file.getName();
        return _filename.equals(orgUnitInfo.getName());
    }

    protected IBgFacade getBgFacadeInterface() throws Exception {
        return BgFacadeFactory.getRemoteInstance();
    }

    protected IPermission getPermissionInterface() throws Exception {
        if (this.iPermission == null) {
            this.iPermission = PermissionFactory.getRemoteInstance();
        }
        return this.iPermission;
    }

    protected IFullOrgUnit getFullOrgUnitInterface() throws Exception {
        if (this.ifullOrgUnit == null) {
            this.ifullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        }
        return this.ifullOrgUnit;
    }

    private SelectorItemCollection getOrgUnitCUIdSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("CU.id");
        sic.add("CU.name");
        return sic;
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }
}

