/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.nbudget.BgElimContext;
import com.kingdee.eas.ma.nbudget.BgEliminationHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNWorkPaperFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgNWorkPaperHelper;
import com.kingdee.eas.ma.nbudget.BgWorkPaperInfo;
import com.kingdee.eas.ma.nbudget.client.BgWorkPaperProcessUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgNWorkPaperCalUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.nbudget.client.BgNWorkPaperCalUtil");

    public void calculateReport(BgWorkPaperProcessUI own, Book book, BgWorkPaperInfo info) {
        this.calculateSheets(book, info);
    }

    private void calculateSheets(Book book, BgWorkPaperInfo info) {
        this.clearCellData(book);
        List orgList = (List)book.getUserObjectValue("WORK_PAPER_SINGLE_ORG_ID");
        HashMap itemMap = new HashMap();
        HashMap formulas = new HashMap();
        HashMap colMap = new HashMap();
        HashMap manulElim = new HashMap();
        Map tempMap = null;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            if (!sheet.isEnableCalculation()) continue;
            tempMap = BgNWorkPaperHelper.getItemFormulas(sheet);
            itemMap.put(sheet.getID(), tempMap.get("WORK_PAPER_ITEM_POINTS"));
            colMap.put(sheet.getID(), tempMap.get("WORK_PAPER_COL_POINTS"));
            formulas.put(sheet.getID(), tempMap.get("WORK_PAPER_FORMULAS"));
            manulElim.put(sheet.getID(), tempMap.get("WORK_PAPER_MANULELIM"));
        }
        if (formulas.size() > 0) {
            try {
                Map sumMap = BgNWorkPaperFacadeFactory.getRemoteInstance().calculate(BgElimContext.getInstance().getCurMappedOrgUnit().getId().toString(), info.getOrgUnit().getId().toString(), info.getBgScheme().getId().toString(), info.getDataType().getValue(), formulas, orgList);
                this.fillManulElim(sumMap, manulElim, info.getBgPeriod().getNumber(), info.getCurrency().getNumber());
                this.fillData(book, sumMap, colMap, itemMap);
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    private void fillManulElim(Map sumMap, Map manulElim, String periodNumber, String currencyNumber) {
        if (sumMap == null || manulElim == null || manulElim.isEmpty() || StringUtils.isEmpty((String)periodNumber) || StringUtils.isEmpty((String)currencyNumber)) {
            return;
        }
        Map paramMap = null;
        Map srcMap = null;
        String sheetId2 = null;
        String elementNumber = null;
        String itemNumber = null;
        String formula = null;
        String[] params2 = null;
        BigDecimal value = null;
        String conKey = String.valueOf(4);
        for (String sheetId2 : manulElim.keySet()) {
            if (!(manulElim.get(sheetId2) instanceof Map) || (paramMap = (Map)manulElim.get(sheetId2)) == null || paramMap.isEmpty()) continue;
            Map formulaMap = BgNWorkPaperHelper.getSubMap(sumMap, sheetId2);
            for (String[] params2 : paramMap.keySet()) {
                if (!(paramMap.get(params2) instanceof BigDecimal)) continue;
                value = (BigDecimal)paramMap.get(params2);
                if (params2 == null || params2.length != 2) continue;
                elementNumber = params2[1];
                itemNumber = params2[0];
                params2 = new String[6];
                params2[4] = "true";
                params2[5] = currencyNumber;
                params2[3] = "BgData";
                params2[2] = elementNumber;
                params2[0] = itemNumber;
                params2[1] = periodNumber;
                formula = BgNFSHelper.getFormulaFromParam(params2);
                if (StringUtils.isEmpty((String)formula)) continue;
                srcMap = BgNWorkPaperHelper.getSubMap(formulaMap, formula);
                if (srcMap.get(conKey) instanceof BigDecimal) {
                    value = value.add((BigDecimal)srcMap.get(conKey));
                }
                srcMap.put(conKey, value);
            }
        }
    }

    private void fillData(Book book, Map sumMap, Map colMap, Map itemMap) {
        if (book != null && sumMap != null && !sumMap.isEmpty()) {
            Sheet sheet = null;
            Cell cell = null;
            int rowIndex = -1;
            int colIndex = -1;
            String[] params = null;
            String sheetId2 = null;
            String formula2 = null;
            String itemNumber = null;
            String elementNumber = null;
            String srcType2 = null;
            String orgId2 = null;
            Map formulaMap = null;
            Map srcMap = null;
            Map orgMap = null;
            Map subItemMap = null;
            Map subColMap = null;
            String single = String.valueOf(1);
            for (String sheetId2 : sumMap.keySet()) {
                sheet = book.getSheetByID(sheetId2);
                if (sheet == null) continue;
                formulaMap = (Map)sumMap.get(sheetId2);
                subItemMap = (Map)itemMap.get(sheetId2);
                subColMap = (Map)colMap.get(sheetId2);
                for (String formula2 : formulaMap.keySet()) {
                    params = BgNFSHelper.parseFormulaPara(formula2);
                    elementNumber = null;
                    itemNumber = null;
                    if (params != null) {
                        if (params.length == 4) {
                            elementNumber = params[2];
                            itemNumber = params[0];
                        } else {
                            elementNumber = params[2];
                            itemNumber = params[0];
                        }
                    }
                    if (StringUtils.isEmpty(elementNumber) || StringUtils.isEmpty(itemNumber) || subItemMap == null || !subItemMap.containsKey(itemNumber)) continue;
                    rowIndex = (Integer)subItemMap.get(itemNumber);
                    srcMap = (Map)formulaMap.get(formula2);
                    if (srcMap == null || srcMap.isEmpty()) continue;
                    for (String srcType2 : srcMap.keySet()) {
                        String colKey;
                        orgId2 = null;
                        if (single.equals(srcType2)) {
                            if (!(srcMap.get(srcType2) instanceof Map) || (orgMap = (Map)srcMap.get(srcType2)) == null || orgMap.isEmpty()) continue;
                            for (String orgId2 : orgMap.keySet()) {
                                colKey = BgNWorkPaperHelper.getColKey(elementNumber, srcType2, orgId2);
                                if (!(orgMap.get(orgId2) instanceof BigDecimal) || subColMap == null || !subColMap.containsKey(colKey)) continue;
                                colIndex = (Integer)subColMap.get(colKey);
                                cell = sheet.getCell(rowIndex, colIndex, true);
                                this.setCellValue(cell, orgMap.get(orgId2));
                            }
                            continue;
                        }
                        if (!(srcMap.get(srcType2) instanceof BigDecimal)) continue;
                        colKey = BgNWorkPaperHelper.getColKey(elementNumber, srcType2, null);
                        if (subColMap == null || !subColMap.containsKey(colKey)) continue;
                        colIndex = (Integer)subColMap.get(colKey);
                        cell = sheet.getCell(rowIndex, colIndex, true);
                        this.setCellValue(cell, srcMap.get(srcType2));
                    }
                }
            }
        }
    }

    protected void setCellValue(Cell cell, Object obj) {
        if (cell != null && !cell.hasFormula()) {
            if (obj == null) {
                cell.setValue(Variant.nullVariant);
            } else if (obj instanceof BigDecimal) {
                cell.setValue(new Variant((Object)((BigDecimal)obj)));
            } else {
                cell.setValue(new Variant(obj));
            }
        }
    }

    private void clearCellData(Book book) {
        Sheet sheet = null;
        Variant value = null;
        int iLeft = 0;
        int iTop = 0;
        int n = book.getSheetCount();
        for (int i = 0; i < n; ++i) {
            HashMap base;
            sheet = book.getSheet(i);
            if (sheet == null || !sheet.isEnableCalculation() || (base = BgEliminationHelper.getBasePosition(sheet)) == null) continue;
            iTop = (Integer)base.get("top");
            iLeft = (Integer)base.get("left");
            int rowCount = sheet.getMaxRowIndex();
            for (int row = 0; row <= rowCount; ++row) {
                if (row == iTop || BgNWorkPaperHelper.getItemNumber(sheet.getRow(row, false)) == null) continue;
                int colCount = sheet.getMaxColIndex();
                for (int col = 0; col <= colCount; ++col) {
                    Cell cell;
                    if (col == iLeft || (cell = sheet.getCell(row, col, false)) == null || cell.hasFormula() || (value = cell.getValue()) == null || BgNWorkPaperHelper.getDataColMap(sheet.getColumn(col, false)) == null || String.valueOf(5).equals(BgNWorkPaperHelper.getSrcType(sheet.getColumn(col, false)))) continue;
                    cell.setValue(Variant.nullVariant);
                }
            }
        }
    }
}

