/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.nbudget.BgElimContext;
import com.kingdee.eas.ma.nbudget.BgEliminationHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNWorkPaperHelper;
import com.kingdee.eas.ma.nbudget.BgWorkPaperFactory;
import com.kingdee.eas.ma.nbudget.BgWorkPaperInfo;
import com.kingdee.eas.ma.nbudget.BgWorkPaperMeasureUnitCollection;
import com.kingdee.eas.ma.nbudget.BgWorkPaperMeasureUnitInfo;
import com.kingdee.eas.ma.nbudget.BgWorkPaperStateEnum;
import com.kingdee.eas.ma.nbudget.BgWorkTemMeasureUnitInfo;
import com.kingdee.eas.ma.nbudget.BgWorkTemplateInfo;
import com.kingdee.eas.ma.nbudget.IBgWorkPaper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgNWorkPaperEditUI;
import com.kingdee.eas.ma.nbudget.client.BgCodeNumberCHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class BgNWorkPaperEditUI
extends AbstractBgNWorkPaperEditUI {
    private static final long serialVersionUID = -5003406890984945752L;
    private static final Logger logger = CoreUIObject.getLogger(BgNWorkPaperEditUI.class);
    private boolean isSubmit = false;
    private Map elementMap = null;
    private boolean hasProperty = false;
    private boolean hasCodeNumber = false;
    private boolean hasShowCodeNumber = false;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.beforeOnLoad();
        super.onLoad();
        this.afterOnLoad();
    }

    protected void beforeOnLoad() throws Exception {
        this.setUITitle(this.getUITitle() + " - " + this.getOperStateMsg());
    }

    protected void afterOnLoad() throws Exception {
        this.initBgSchemeF7();
        this.initBgWorkTemplateF7();
        this.initBgPeriodF7();
        this.initCurrencyF7();
        this.initMeasureUnitInfo();
    }

    protected void loadData() throws Exception {
        super.loadData();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            String OUID = this.editData.getOrgUnit().getId().toString();
            boolean re = BgCodeNumberCHelper.hasCodeNumber((IObjectValue)this.editData, OUID, "sourceType");
            if (re) {
                this.setHasProperty(true);
            } else {
                this.setHasProperty(false);
                re = BgCodeNumberCHelper.hasCodeNumber((IObjectValue)this.editData, OUID);
            }
            this.setHasCodeNumber(re);
            if (this.isHasCodeNumber()) {
                re = this.isHasProperty() ? BgCodeNumberCHelper.hasDisplayNumber((IObjectValue)this.editData, OUID, "sourceType") : BgCodeNumberCHelper.hasDisplayNumber((IObjectValue)this.editData, OUID);
                this.setHasShowCodeNumber(re);
            }
            if (this.isHasCodeNumber()) {
                this.txtNumber.setEnabled(false);
            } else {
                this.txtNumber.setEnabled(true);
            }
            this.getNumberByCodingRule((IObjectValue)this.editData, OUID);
        }
    }

    protected void getNumberByCodingRule(IObjectValue caller, String orgId) {
        if (this.isHasCodeNumber() && this.isHasShowCodeNumber()) {
            if (this.isHasProperty()) {
                BgCodeNumberCHelper.applyNumber(this.txtNumber, (IObjectValue)this.editData, orgId, "sourceType", this.isHasCodeNumber(), this.isHasShowCodeNumber());
            } else {
                BgCodeNumberCHelper.applyNumber(this.txtNumber, (IObjectValue)this.editData, orgId, this.isHasCodeNumber(), this.isHasShowCodeNumber());
            }
        }
    }

    protected void prepareNumber(IObjectValue caller, String number) {
        if (number != null && number.length() > 0) {
            caller.put("number", (Object)number);
            this.txtNumber.setText(number);
        }
    }

    protected void setNumberTextEnabled() {
        this.txtNumber.setEnabled(true);
    }

    protected void initBgSchemeF7() throws Exception {
        String orgUnitId = null;
        OrgUnitInfo orgUnit = BgElimContext.getInstance().getCurMappedOrgUnit();
        orgUnitId = orgUnit != null ? orgUnit.getId().toString() : "NONE_ORGUNIT_ID";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.Id", (Object)orgUnitId));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        view.setFilter(filter);
        view.setSorter(sorter);
        this.prmtBgScheme.setEntityViewInfo(view);
    }

    protected void initBgPeriodF7() throws Exception {
        BgPeriodDialog bgPeriodDialog = new BgPeriodDialog((CoreUIObject)this);
        this.prmtBgPeriod.setSelector((KDPromptSelector)bgPeriodDialog);
    }

    protected void initMeasureUnitInfo() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> dataType = new HashSet<Integer>();
        dataType.add(new Integer(0));
        dataType.add(new Integer(1));
        dataType.add(new Integer(2));
        filter.getFilterItems().add(new FilterItemInfo("dataType", dataType, CompareType.INCLUDE));
        view.setFilter(filter);
        SorterItemCollection sic = new SorterItemCollection();
        SorterItemInfo sort = new SorterItemInfo("number");
        sic.add(sort);
        view.setSorter(sic);
        IRow row = null;
        BgElementInfo eInfo2 = null;
        BgElementCollection bgECol = null;
        this.tblMeasureUnit.setRefresh(false);
        this.tblMeasureUnit.checkParsed();
        bgECol = this.getBgElementInterface().getBgElementCollection(view);
        this.elementMap = new HashMap();
        if (bgECol != null && !bgECol.isEmpty()) {
            this.tblMeasureUnit.getColumn(0).getStyleAttributes().setLocked(true);
            this.tblMeasureUnit.getColumn(1).getStyleAttributes().setLocked(true);
            this.tblMeasureUnit.getColumn(2).getStyleAttributes().setLocked(true);
            this.tblMeasureUnit.getColumn(3).getStyleAttributes().setLocked(true);
            for (BgElementInfo eInfo2 : bgECol) {
                this.elementMap.put(eInfo2.getNumber(), eInfo2);
                row = this.tblMeasureUnit.addRow();
                row.getCell(0).setValue((Object)eInfo2.getId().toString());
                row.getCell(1).setValue((Object)eInfo2.getNumber());
                row.getCell(2).setValue((Object)eInfo2.getName());
                row.getCell(3).setValue((Object)eInfo2.getDataType().getAlias());
                row.setUserObject((Object)eInfo2);
            }
        }
        this.tblMeasureUnit.setRefresh(false);
        this.tblMeasureUnit.reLayoutAndPaint();
        EntityViewInfo muView = new EntityViewInfo();
        FilterInfo muFilter = new FilterInfo();
        muFilter.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        muView.setFilter(muFilter);
        muView.getSorter().add(new SorterItemInfo("coefficient"));
        MeasureUnitInfo muInfo2 = null;
        MeasureUnitCollection muCol = null;
        KDTDefaultCellEditor editor = null;
        KDComboBox comboBox = new KDComboBox();
        DefaultComboBoxModel<MeasureUnitInfo> model = new DefaultComboBoxModel<MeasureUnitInfo>();
        try {
            muCol = this.getMeasureUnitInterface().getMeasureUnitCollection(muView);
            this.cbxMeasureUnit.removeAllItems();
            if (muCol != null && !muCol.isEmpty()) {
                for (MeasureUnitInfo muInfo2 : muCol) {
                    this.cbxMeasureUnit.addItem((Object)muInfo2);
                    model.addElement(muInfo2);
                }
            }
            comboBox.setModel(model);
            editor = new KDTDefaultCellEditor((JComboBox)comboBox);
            this.tblMeasureUnit.getColumn(4).setEditor((ICellEditor)editor);
            if (!OprtState.ADDNEW.equals(this.getOprtState())) {
                if (this.editData.getMeasureUnit() != null) {
                    BgNFCHelper.setSelectObject(this.cbxMeasureUnit, this.editData.getMeasureUnit());
                }
                this.loadMeasureUnitInfo(this.editData);
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.verify(e);
            String msg = BgWorkPaperFactory.getRemoteInstance().checkHasExist(this.editData.getOrgUnit().getId().toString(), this.editData.getBgScheme().getId().toString(), this.editData.getBgWorkTemplate().getId().toString(), this.editData.getBgPeriod().getId().toString(), this.editData.getCurrency().getId().toString(), this.editData.getDataType().getValue(), this.editData.getNumber());
            if (!StringUtils.isEmpty((String)msg)) {
                BgNFCHelper.showWarning((Component)((Object)this), BgNWorkPaperHelper.getWorkPaperMsg(msg));
            }
            this.editData.put("BgCostCenterNum", BgElimContext.getInstance().getCurMappedOrgUnit());
            this.submitBgWorkPaperInfo();
            this.isSubmit = true;
            this.destroyWindow();
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            super.actionSubmit_actionPerformed(e);
        }
    }

    public boolean isModify() {
        return super.isModify();
    }

    private void submitBgWorkPaperInfo() throws Exception {
        this.storeFields();
        this.converBook();
        IRow row = null;
        BgWorkPaperMeasureUnitCollection muc = this.editData.getWorkPaperMeasureUnit();
        muc.clear();
        BgWorkPaperMeasureUnitInfo mu = null;
        BOSUuid id = null;
        int count = this.tblMeasureUnit.getBody().size();
        for (int index = 0; index < count; ++index) {
            row = this.tblMeasureUnit.getRow(index);
            if (!(row.getCell(4).getValue() instanceof MeasureUnitInfo)) continue;
            mu = new BgWorkPaperMeasureUnitInfo();
            mu.setBgWorkPaper(this.editData);
            mu.setBgElement((BgElementInfo)row.getUserObject());
            mu.setMeasureUnit((MeasureUnitInfo)row.getCell(4).getValue());
            id = row.getCell("id").getValue() instanceof BOSUuid ? (BOSUuid)row.getCell("id").getValue() : (row.getCell("id").getValue() instanceof String ? BOSUuid.read((String)((String)row.getCell("id").getValue())) : BOSUuid.create((BOSObjectType)mu.getBOSType()));
            mu.setId(id);
            muc.add(mu);
        }
        this.editData.copyNewToOld();
    }

    protected void converBook() throws Exception {
        BgWorkTemplateInfo template = BgNWorkPaperHelper.getWorkTemplate(this.prmtBgWorkTemplate.getData(), 2, null);
        Book paperBook = null;
        if (template != null) {
            paperBook = IOHelper.unpackBook((byte[])template.getData());
            BgNFSHelper.disableCal(paperBook);
            BgNFSHelper.disableUndo(paperBook);
            BgElimContext ctx = BgElimContext.getInstance();
            OrgTreeInfo treeInfo = ctx.getCurOrgBound();
            FullOrgUnitInfo currCompany = this.editData.getOrgUnit();
            DefaultKingdeeTreeNode rootNode = BgEliminationHelper.getUnionDebtTree((OrgUnitInfo)currCompany, treeInfo, false, false);
            List orgList = this.traceOrgTree(rootNode, null);
            Sheet sheet = null;
            Column col = null;
            Cell cell = null;
            String[] params = null;
            String period = this.editData.getBgPeriod().getNumber();
            String currency = this.editData.getCurrency().getNumber();
            for (int sIndex = 0; sIndex < paperBook.getSheetCount(); ++sIndex) {
                sheet = paperBook.getSheet(sIndex);
                for (int cIndex = sheet.getMaxColIndex(); cIndex >= 0; --cIndex) {
                    col = sheet.getColumn(cIndex, false);
                    if (BgNWorkPaperHelper.isSingleCol(col)) {
                        BgNWorkPaperHelper.insertCol(sheet, cIndex, orgList, true, this.elementMap);
                        continue;
                    }
                    if (!BgNWorkPaperHelper.isConSolidCol(col)) continue;
                    for (int rIndex = 0; rIndex <= sheet.getMaxRowIndex(); ++rIndex) {
                        cell = sheet.getCell(rIndex, cIndex, false);
                        params = BgNFSHelper.parseFormulaPara(BgNFSHelper.getFormulaOfCell(cell));
                        if (params == null) continue;
                        if (params.length == 6) {
                            params[1] = period;
                            params[5] = currency;
                            BgNFSHelper.setFormulaOfCell(cell, BgNFSHelper.getFormulaFromParam(params));
                            continue;
                        }
                        if (params.length != 4) continue;
                        params[1] = period;
                        params[3] = currency;
                        BgNFSHelper.setFormulaOfCell(cell, BgNFSHelper.getFormulaFromParam(params));
                    }
                }
            }
            ArrayList<String> orgIds = new ArrayList<String>();
            for (int i = 0; i < orgList.size(); ++i) {
                if (!(orgList.get(i) instanceof OrgUnitInfo)) continue;
                orgIds.add(((OrgUnitInfo)orgList.get(i)).getId().toString());
            }
            paperBook.setUserObject("WORK_PAPER_SINGLE_ORG_ID", orgIds);
        } else {
            paperBook = Book.Manager.getNewBook();
        }
        this.editData.setBook(paperBook);
    }

    private List traceOrgTree(DefaultKingdeeTreeNode node, List orgList) {
        if (orgList == null) {
            orgList = new ArrayList<FullOrgUnitInfo>();
        }
        DefaultKingdeeTreeNode sub = null;
        OrgStructureInfo orgStruct = null;
        if (!node.isLeaf()) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                sub = (DefaultKingdeeTreeNode)node.getChildAt(i);
                orgStruct = (OrgStructureInfo)sub.getUserObject();
                orgList.add(orgStruct.getUnit());
            }
        }
        return orgList;
    }

    protected void fillWorkTemplateMeasureUnit(BgWorkTemplateInfo template) {
        HashMap<String, BgWorkPaperMeasureUnitInfo> measureUnit = null;
        if (template == null) {
            this.cbxMeasureUnit.setSelectedIndex(-1);
        } else {
            BgNFCHelper.setSelectObject(this.cbxMeasureUnit, template.getDefaultMeasureUnit());
            if (template.getBgMeasureUnit() != null && !template.getBgMeasureUnit().isEmpty()) {
                measureUnit = new HashMap<String, BgWorkPaperMeasureUnitInfo>();
                BgWorkTemMeasureUnitInfo tmu = null;
                BgWorkPaperMeasureUnitInfo pmu = null;
                for (int i = 0; i < template.getBgMeasureUnit().size(); ++i) {
                    tmu = template.getBgMeasureUnit().get(i);
                    pmu = new BgWorkPaperMeasureUnitInfo();
                    pmu.setBgElement(tmu.getBgElement());
                    pmu.setMeasureUnit(tmu.getMeasureUnit());
                    measureUnit.put(pmu.getBgElement().getId().toString(), pmu);
                }
            }
        }
        this.resetMeasureUnitMap(measureUnit);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            if (this.txtNumber.isEnabled()) {
                this.txtNumber.setText(this.txtNumber.getText().trim());
            }
            if (this.isHasCodeNumber()) {
                String msg;
                if (this.isHasShowCodeNumber() && StringUtils.isEmpty((String)this.txtNumber.getText())) {
                    this.txtNumber.requestFocus();
                    BgNFCHelper.showWarning((Component)((Object)this), BgNWorkPaperHelper.getWorkPaperMsg("noNumber"));
                }
                if (this.isHasShowCodeNumber() && !StringUtil.isEmpty((String)(msg = ((IBgWorkPaper)this.getBizInterface()).checkNumber(this.editData.getOrgUnit().getId().toString(), this.txtNumber.getText().trim())))) {
                    BgNFCHelper.showWarning((Component)((Object)this), BgNWorkPaperHelper.getWorkPaperMsg(msg));
                }
            } else {
                String msg;
                if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
                    this.txtNumber.requestFocus();
                    BgNFCHelper.showWarning((Component)((Object)this), BgNWorkPaperHelper.getWorkPaperMsg("noNumber"));
                }
                if (!BgNWorkPaperHelper.checkNumber(this.txtNumber.getText())) {
                    this.txtNumber.requestFocus();
                    BgNFCHelper.showWarning((Component)((Object)this), BgNWorkPaperHelper.getWorkPaperMsg("numberError"));
                }
                if (!StringUtil.isEmpty((String)(msg = ((IBgWorkPaper)this.getBizInterface()).checkNumber(this.editData.getOrgUnit().getId().toString(), this.txtNumber.getText().trim())))) {
                    BgNFCHelper.showWarning((Component)((Object)this), BgNWorkPaperHelper.getWorkPaperMsg(msg));
                }
            }
            if (StringUtils.isEmpty((String)this.txtName.getText()) && this.txtName.isEnabled()) {
                this.txtName.requestFocus();
                BgNFCHelper.showWarning((Component)((Object)this), BgNWorkPaperHelper.getWorkPaperMsg("noName"));
            }
            if (this.prmtBgScheme.getData() == null || !(this.prmtBgScheme.getData() instanceof BgSchemeInfo)) {
                this.prmtBgScheme.requestFocus();
                BgNFCHelper.showWarning((Component)((Object)this), BgNWorkPaperHelper.getWorkPaperMsg("noBgScheme"));
            }
            if (!(this.prmtBgWorkTemplate.getData() instanceof BgWorkTemplateInfo)) {
                this.prmtBgWorkTemplate.requestFocus();
                BgNFCHelper.showWarning((Component)((Object)this), BgNWorkPaperHelper.getWorkPaperMsg("noWorkTemplate"));
            }
            if (this.prmtBgPeriod.getData() == null || !(this.prmtBgPeriod.getData() instanceof BgPeriodInfo)) {
                this.prmtBgPeriod.requestFocus();
                BgNFCHelper.showWarning((Component)((Object)this), BgNWorkPaperHelper.getWorkPaperMsg("noPeriod"));
            }
            if (!(this.prmtCurrency.getData() instanceof CurrencyInfo)) {
                this.prmtCurrency.requestFocus();
                BgNFCHelper.showWarning((Component)((Object)this), BgNWorkPaperHelper.getWorkPaperMsg("noCurrency"));
            }
        }
    }

    protected void loadMeasureUnitInfo(BgWorkPaperInfo info) throws Exception {
        BgWorkPaperMeasureUnitInfo mu = null;
        HashMap<BOSUuid, BgWorkPaperMeasureUnitInfo> bgElementMuMap = null;
        if (info.getWorkPaperMeasureUnit() != null || !info.getWorkPaperMeasureUnit().isEmpty()) {
            bgElementMuMap = new HashMap<BOSUuid, BgWorkPaperMeasureUnitInfo>();
            for (int i = 0; i < info.getWorkPaperMeasureUnit().size(); ++i) {
                mu = info.getWorkPaperMeasureUnit().get(i);
                bgElementMuMap.put(mu.getBgElement().getId(), mu);
            }
        }
        this.resetMeasureUnitMap(bgElementMuMap);
    }

    protected void resetMeasureUnitMap(Map map) {
        IRow row = null;
        BgElementInfo bgElementInfo = null;
        int rowCount = this.tblMeasureUnit.getRowCount();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            row = this.tblMeasureUnit.getRow(rowIndex);
            bgElementInfo = (BgElementInfo)row.getUserObject();
            BgWorkPaperMeasureUnitInfo mu = null;
            if (map != null && map.get(bgElementInfo.getId().toString()) instanceof BgWorkPaperMeasureUnitInfo) {
                mu = (BgWorkPaperMeasureUnitInfo)map.get(bgElementInfo.getId().toString());
                row.getCell(4).setValue((Object)mu.getMeasureUnit());
                row.getCell("id").setValue((Object)mu.getId());
                continue;
            }
            row.getCell("id").setValue(null);
            row.getCell(4).setValue(null);
        }
    }

    protected void initCurrencyF7() throws Exception {
    }

    protected void initBgWorkTemplateF7() throws Exception {
        String orgUnitId = BgElimContext.getInstance().getCurOrgBound().getId().toString();
        if (StringUtils.isEmpty((String)orgUnitId)) {
            orgUnitId = "NONE_ORGUNIT_ID";
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        view.setFilter(filter);
        view.setSorter(sorter);
        this.prmtBgWorkTemplate.setEntityViewInfo(view);
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    @Override
    protected void prmtBgPeriod_dataChanged(DataChangeEvent e) throws Exception {
        this.makeName();
    }

    @Override
    protected void prmtBgWorkTemplate_dataChanged(DataChangeEvent e) throws Exception {
        this.makeName();
        this.fillWorkTemplateMeasureUnit(BgNWorkPaperHelper.getWorkTemplate(this.prmtBgWorkTemplate.getData(), 1, null));
    }

    protected void makeName() {
        if (this.txtName.isEnabled() && this.prmtOrgUnit.getData() instanceof FullOrgUnitInfo && this.prmtBgPeriod.getData() instanceof BgPeriodInfo && this.prmtBgWorkTemplate.getData() instanceof BgWorkTemplateInfo) {
            StringBuffer name = new StringBuffer();
            name.append(((FullOrgUnitInfo)this.prmtOrgUnit.getData()).getName());
            name.append("-");
            name.append(((BgPeriodInfo)this.prmtBgPeriod.getData()).getName());
            name.append("-");
            name.append(((BgWorkTemplateInfo)this.prmtBgWorkTemplate.getData()).getName());
            if (name.length() > this.txtName.getMaxLength()) {
                this.txtName.setText(name.substring(0, this.txtName.getMaxLength()));
            } else {
                this.txtName.setText(name.toString());
            }
        }
    }

    protected IObjectValue createNewData() {
        BgWorkPaperInfo info = new BgWorkPaperInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setState(BgWorkPaperStateEnum.EDIT);
        info.setStartDate(new Date());
        info.setEndDate(info.getStartDate());
        info.setSourceType(RptSrcTypeEnum.BGFORMREPORT);
        FullOrgUnitInfo org = (FullOrgUnitInfo)this.getUIContext().get("ORG_UNIT");
        info.setOrgUnit(org);
        info.setCU(org.getCU());
        CompanyOrgUnitInfo companyInfo = null;
        try {
            companyInfo = BgNWorkPaperHelper.getCompanyByOrgUnit(null, (OrgUnitInfo)info.getOrgUnit());
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        if (companyInfo != null) {
            info.setCompany(companyInfo);
        } else {
            info.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        }
        try {
            BgElimContext ctx = BgElimContext.getInstance();
            info.setDataType(ctx.getCurBgDataType());
            BgSchemeInfo bgscheme = ctx.getCurBgScheme();
            info.setBgScheme(bgscheme);
            if (bgscheme instanceof BgSchemeInfo) {
                this.prmtBgScheme.setEnabled(false);
            } else {
                this.prmtBgScheme.setEnabled(true);
            }
            BgPeriodInfo period = ctx.getCurBgPeriod();
            info.setBgPeriod(period);
            if (period instanceof BgPeriodInfo) {
                this.prmtBgPeriod.setEnabled(false);
            } else {
                this.prmtBgPeriod.setEnabled(true);
            }
            info.setOrgTree(ctx.getCurOrgBound());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgWorkPaperFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return super.getSelectors();
    }

    public boolean isSubmit() {
        return this.isSubmit;
    }

    protected String getMessageStr(String key) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgNFormResource", (String)key) : "";
    }

    protected IMeasureUnit getMeasureUnitInterface() throws Exception {
        return MeasureUnitFactory.getRemoteInstance();
    }

    protected IBgElement getBgElementInterface() throws Exception {
        return BgElementFactory.getRemoteInstance();
    }

    protected String getOperStateMsg() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            return this.getMessageStr(this.getOprtState());
        }
        return null;
    }

    public boolean isHasProperty() {
        return this.hasProperty;
    }

    public void setHasProperty(boolean hasProperty) {
        this.hasProperty = hasProperty;
    }

    public boolean isHasCodeNumber() {
        return this.hasCodeNumber;
    }

    public void setHasCodeNumber(boolean hasCodeNumber) {
        this.hasCodeNumber = hasCodeNumber;
    }

    public boolean isHasShowCodeNumber() {
        return this.hasShowCodeNumber;
    }

    public void setHasShowCodeNumber(boolean hasShowCodeNumber) {
        this.hasShowCodeNumber = hasShowCodeNumber;
    }
}

