/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.excel.impl.facade.editor.CellTextEditor;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.IBgCellValueProvider;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;

public class BgNumberCellTextEditor
extends CellTextEditor {
    private IBgCellValueProvider provider = null;

    public BgNumberCellTextEditor() {
    }

    public BgNumberCellTextEditor(IBgCellValueProvider provider) {
        this.provider = provider;
    }

    protected IBgCellValueProvider getValueProvider() {
        return this.provider;
    }

    public String getText() {
        String _text = super.getText();
        if (!StringUtils.isEmpty((String)_text) && !BgNFSHelper.checkIsExpression(_text)) {
            Cell _cell = this._sheet.getCell(this._rowIndex, this._colIndex, false);
            if (_cell != null) {
                if (!BgNFSHelper.checkHasPercentage(_cell) && !BgNFSHelper.checkHasTextOfCell(_cell)) {
                    if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
                        _text = this.updateMeasureUnitValue(_text);
                    } else if (BgNFSHelper.getBgItemInfo(_cell) == null && BgNFSHelper.getBgElementInfo(_cell) == null && BgNFSHelper.getBgPeriodInfo(_cell) == null && BgNFSHelper.checkHasNumbericOfCell(_cell)) {
                        _text = this.updateMeasureUnitValue(_text);
                    }
                }
            } else {
                _text = this.updateMeasureUnitValue(_text);
            }
        }
        return _text;
    }

    protected String updateMeasureUnitValue(String _text) {
        BigDecimal _value = null;
        _value = this.getValueProvider().getMeasureUnitMap().isEmpty() ? this.updateDefMeasureUnitValue(_text) : this.updateBgMeasureUnitValue(_text);
        if (_value != null) {
            _text = CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)_value);
        }
        return _text;
    }

    protected BigDecimal updateDefMeasureUnitValue(String _text) {
        BigDecimal _value = null;
        BigDecimal _coefficient = null;
        try {
            _value = new BigDecimal(_text.trim().replaceAll(",", ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (_value != null && this.getValueProvider().getMeasureUnit() != null && (_coefficient = this.getValueProvider().getMeasureUnit().getCoefficient()) != null) {
            _value = _value.multiply(_coefficient);
        }
        return _value;
    }

    protected BigDecimal updateBgMeasureUnitValue(String _text) {
        String _formulaStr = null;
        String _bgElementNumber = null;
        String _tmpStr = null;
        String[] _parameter = null;
        BigDecimal _value = null;
        BigDecimal _coefficient = null;
        _tmpStr = _text.trim().replaceAll(",", "");
        try {
            _value = new BigDecimal(_tmpStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (_value != null) {
            if (this.getValueProvider().getMeasureUnit() != null) {
                _coefficient = this.getValueProvider().getMeasureUnit().getCoefficient();
            }
            Cell _cell = this._sheet.getCell(this._rowIndex, this._colIndex, false);
            _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
            _parameter = BgNFSHelper.parseFormulaPara(this.getValueProvider().getFormulaMap(), _formulaStr);
            if (_parameter != null && !StringUtils.isEmpty((String)_parameter[2])) {
                _bgElementNumber = _parameter[2];
                if (this.getValueProvider().getMeasureUnitMap().containsKey(_bgElementNumber)) {
                    _coefficient = (BigDecimal)this.getValueProvider().getMeasureUnitMap().get(_bgElementNumber);
                }
                if (_coefficient != null) {
                    _value = _value.multiply(_coefficient);
                }
            } else if (_coefficient != null) {
                _value = _value.multiply(_coefficient);
            }
        }
        return _value;
    }

    public String getCellText(Cell cell) {
        String _text = super.getCellText(cell);
        if (!StringUtils.isEmpty((String)_text) && !BgNFSHelper.checkIsExpression(_text)) {
            Cell _cell = this._sheet.getCell(this._rowIndex, this._colIndex, false);
            if (_cell != null) {
                if (!BgNFSHelper.checkHasPercentage(_cell) && !BgNFSHelper.checkHasTextOfCell(_cell)) {
                    if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
                        _text = this.getMeasureUnitDisplayValue(_text);
                    } else if (BgNFSHelper.checkHasNumbericOfCell(_cell)) {
                        _text = this.getMeasureUnitDisplayValue(_text);
                    }
                }
            } else {
                _text = this.getMeasureUnitDisplayValue(_text);
            }
        }
        return _text;
    }

    protected String getMeasureUnitDisplayValue(String _text) {
        BigDecimal _value = null;
        _value = this.getValueProvider().getMeasureUnitMap().isEmpty() ? this.getDefMeasureUnitDisplayValue(_text) : this.getBgMeasureUnitDisplayValue(_text);
        if (_value != null) {
            _text = CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)_value);
        }
        return _text;
    }

    protected BigDecimal getDefMeasureUnitDisplayValue(String _text) {
        BigDecimal _value = null;
        BigDecimal _coefficient = null;
        try {
            _value = new BigDecimal(_text.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (_value != null && this.getValueProvider().getMeasureUnit() != null) {
            _coefficient = this.getValueProvider().getMeasureUnit().getCoefficient();
            _value = _value.divide(_coefficient, 8, 4);
        }
        return _value;
    }

    protected BigDecimal getBgMeasureUnitDisplayValue(String _text) {
        String _formulaStr = null;
        String _bgElementNumber = null;
        String[] _parameter = null;
        BigDecimal _value = null;
        BigDecimal _coefficient = null;
        try {
            _value = new BigDecimal(_text.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (_value != null) {
            if (this.getValueProvider().getMeasureUnit() != null) {
                _coefficient = this.getValueProvider().getMeasureUnit().getCoefficient();
            }
            Cell _cell = this._sheet.getCell(this._rowIndex, this._colIndex, false);
            _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
            _parameter = BgNFSHelper.parseFormulaPara(this.getValueProvider().getFormulaMap(), _formulaStr);
            if (_parameter != null && !StringUtils.isEmpty((String)_parameter[2])) {
                _bgElementNumber = _parameter[2];
                if (this.getValueProvider().getMeasureUnitMap().containsKey(_bgElementNumber)) {
                    _coefficient = (BigDecimal)this.getValueProvider().getMeasureUnitMap().get(_bgElementNumber);
                }
                if (_coefficient != null) {
                    _value = _value.divide(_coefficient, 8, 4);
                }
            } else if (_coefficient != null) {
                _value = _value.divide(_coefficient, 8, 4);
            }
        }
        return _value;
    }
}

