/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BgOrgMappingInfo;
import com.kingdee.eas.ma.budget.client.BgCostCenterBaseF7;
import com.kingdee.eas.ma.budget.client.NumberExpandInfo;
import com.kingdee.eas.ma.budget.client.NumberExpendRender;
import com.kingdee.eas.ma.nbudget.BgAreaException;
import com.kingdee.eas.ma.nbudget.BgAreaFacadeFactory;
import com.kingdee.eas.ma.nbudget.IBgAreaFacade;
import com.kingdee.eas.ma.nbudget.client.AbstractBgOrgUnitSetUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class BgOrgUnitSetUI
extends AbstractBgOrgUnitSetUI {
    private static final long serialVersionUID = -2803601851272044841L;
    private static final Logger logger = CoreUIObject.getLogger(BgOrgUnitSetUI.class);
    private static final String SOURCE_STR = "com.kingdee.eas.ma.nbudget.client.BgAreaResource";
    private NumberExpendRender expendRender = null;
    private boolean isModify = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.expendRender = new NumberExpendRender();
        this.tblMain.getColumn(1).setRenderer((IBasicRender)this.expendRender);
        this.tblMain.getColumn(0).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(1).getStyleAttributes().setLocked(true);
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        prmtSelect.setEditable(false);
        BgCostCenterBaseF7 orgView = new BgCostCenterBaseF7((IUIObject)this);
        orgView.setTitle(BgAnalyseHelper.getMessage((String)"orgUnitTitle"));
        orgView.setCuID(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
        orgView.setMultiSelect(false);
        orgView.setReturnSuperior(false);
        prmtSelect.setSelector((KDPromptSelector)orgView);
        this.tblMain.getColumn(2).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
        this.comArea_actionPerformed(null);
        this.tblMain.addKDTPropertyChangeListener(new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent evt) {
                BgOrgUnitSetUI.this.setModify(true);
            }
        });
    }

    public static Object[] convertToNewOrgTreeInfo(Object[] orgTreeCol) {
        ArrayList<NewOrgTreeInfo> res = new ArrayList<NewOrgTreeInfo>();
        if (orgTreeCol != null && orgTreeCol.length > 0) {
            for (int i = 0; i < orgTreeCol.length; ++i) {
                if (!(orgTreeCol[i] instanceof OrgTreeInfo)) continue;
                res.add(new NewOrgTreeInfo((OrgTreeInfo)orgTreeCol[i]));
            }
        }
        return res.toArray();
    }

    protected void init() throws Exception {
        this.comArea.removeAllItems();
        this.comArea.addItem((Object)BgNFCHelper.getMessageStr(SOURCE_STR, "all"));
        this.comArea.addItems(BgOrgUnitSetUI.convertToNewOrgTreeInfo(this.getAreaFacade().getOrgTreeInfo(null).toArray()));
        this.comArea.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BgOrgUnitSetUI.this.comArea_actionPerformed(e);
                }
                catch (Exception ex) {
                    BgOrgUnitSetUI.this.handUIException(ex);
                }
            }
        });
        AbstractAction actionSave2 = new AbstractAction(){
            private static final long serialVersionUID = 8707818271853932164L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BgOrgUnitSetUI.this.actionSave_actionPerformed(e);
                }
                catch (Exception ex) {
                    BgOrgUnitSetUI.this.handleException(ex);
                }
            }
        };
        String strKey = "CTRL_S";
        KeyStroke ks = KeyStroke.getKeyStroke(83, 192, false);
        this.getActionMap().put(strKey, actionSave2);
        this.getInputMap(2).put(ks, strKey);
        ActionMap map = this.tblMain.getActionMap();
        map.remove("Cut");
        map.remove("Paste");
        map.remove("Copy");
        map.remove("Delete");
    }

    public IBgAreaFacade getAreaFacade() throws Exception {
        return BgAreaFacadeFactory.getRemoteInstance();
    }

    public void setModify(boolean isModify) {
        this.isModify = isModify;
    }

    public boolean isModify() {
        return this.isModify;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.comArea.setLimitedSize(false);
        this.comArea.setComboPopupWidth(300);
    }

    protected void comArea_actionPerformed(ActionEvent e) throws Exception {
        Object obj = this.comArea.getSelectedItem();
        if (obj != null) {
            int _result;
            if (this.isModify() && (_result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)SOURCE_STR, (String)"beforeSelect"))) == 0) {
                try {
                    this.actionSave_actionPerformed(null);
                }
                catch (Exception ex) {
                    this.handUIExceptionAndAbort(ex);
                }
            }
            this.tblMain.removeRows();
            OrgTreeInfo orgTreeInfo = null;
            NewOrgTreeInfo newOrgTree = null;
            if (obj instanceof String) {
                int i;
                IBgAreaFacade ibgAreaFacade = BgAreaFacadeFactory.getRemoteInstance();
                Map unionMap = null;
                ArrayList<String> unionIdList = new ArrayList<String>();
                int in = this.comArea.getItemCount();
                for (i = 0; i < in; ++i) {
                    obj = this.comArea.getItemAt(i);
                    if (obj instanceof OrgTreeInfo) {
                        orgTreeInfo = (OrgTreeInfo)obj;
                        unionIdList.add(orgTreeInfo.getId().toString());
                        continue;
                    }
                    if (!(obj instanceof NewOrgTreeInfo)) continue;
                    newOrgTree = (NewOrgTreeInfo)obj;
                    unionIdList.add(newOrgTree.getOrgTreeInfo().getId().toString());
                }
                unionMap = ibgAreaFacade.getUnionInfo(unionIdList);
                in = this.comArea.getItemCount();
                for (i = 0; i < in; ++i) {
                    obj = this.comArea.getItemAt(i);
                    if (!(obj instanceof OrgTreeInfo) && !(obj instanceof NewOrgTreeInfo)) continue;
                    orgTreeInfo = obj instanceof NewOrgTreeInfo ? ((NewOrgTreeInfo)obj).getOrgTreeInfo() : (OrgTreeInfo)obj;
                    List unionList = ibgAreaFacade.getUnionCollection(orgTreeInfo.getId());
                    this.builderAreaInfo(orgTreeInfo, unionList, unionMap);
                }
            } else if (obj instanceof OrgTreeInfo || obj instanceof NewOrgTreeInfo) {
                orgTreeInfo = obj instanceof NewOrgTreeInfo ? ((NewOrgTreeInfo)obj).getOrgTreeInfo() : (OrgTreeInfo)obj;
                ArrayList<String> unionIdList = new ArrayList<String>();
                unionIdList.add(orgTreeInfo.getId().toString());
                IBgAreaFacade ibgAreaFacade = BgAreaFacadeFactory.getRemoteInstance();
                List unionList = ibgAreaFacade.getUnionCollection(orgTreeInfo.getId());
                Map unionMap = ibgAreaFacade.getUnionInfo(unionIdList);
                this.builderAreaInfo(orgTreeInfo, unionList, unionMap);
            }
        }
        this.setModify(false);
    }

    protected void builderAreaInfo(OrgTreeInfo orgTreeInfo, List unionList, Map unionMap) {
        if (orgTreeInfo == null || unionList == null || unionList.isEmpty()) {
            return;
        }
        IRow _row = null;
        String _areaId = null;
        String _unitId = null;
        String _key = null;
        String _orgTreeStr = null;
        OrgUnitInfo _unitInfo = null;
        OrgUnitInfo _tmpInfo = null;
        CostCenterOrgUnitInfo _ccOrgUnitInfo = null;
        NumberExpandInfo _expandInfo = null;
        _areaId = orgTreeInfo.getId().toString();
        int _rowBegin = this.tblMain.getRowCount();
        int in = unionList.size();
        for (int i = 0; i < in; ++i) {
            _unitInfo = (OrgUnitInfo)unionList.get(i);
            _unitId = _unitInfo.getId().toString();
            _row = this.tblMain.addRow();
            _orgTreeStr = orgTreeInfo.getStartDate() != null ? new StringBuffer(orgTreeInfo.getName() == null ? "" : orgTreeInfo.getName()).append(" (").append(BgNFCHelper.getMessageStr(SOURCE_STR, "startdate")).append(new SimpleDateFormat(BgNationalFormatUIUtil.getNationalDateFormatString()).format(orgTreeInfo.getStartDate())).append(")").toString() : orgTreeInfo.getName();
            _row.getCell(0).setValue((Object)_orgTreeStr);
            _row.getCell(1).setValue((Object)_unitInfo.getName());
            if (i < in - 1) {
                _tmpInfo = (OrgUnitInfo)unionList.get(i + 1);
                _expandInfo = new NumberExpandInfo();
                _expandInfo.setId(_unitId);
                _expandInfo.setName(_unitInfo.getName());
                _expandInfo.setNumber(_unitInfo.getNumber());
                _expandInfo.setLongNumber(_unitInfo.getLongNumber());
                _expandInfo.setLevel(_unitInfo.getLongNumber().split("!").length);
                if (_tmpInfo.getLongNumber().startsWith(_unitInfo.getLongNumber() + "!")) {
                    _expandInfo.setLeaf(false);
                } else {
                    _expandInfo.setLeaf(true);
                }
                _expandInfo.setExpandStatus(true);
            } else {
                _expandInfo = new NumberExpandInfo();
                _expandInfo.setId(_unitId);
                _expandInfo.setName(_unitInfo.getName());
                _expandInfo.setNumber(_unitInfo.getNumber());
                _expandInfo.setLongNumber(_unitInfo.getLongNumber());
                _expandInfo.setLevel(_unitInfo.getLongNumber().split("!").length);
                _expandInfo.setLeaf(true);
                _expandInfo.setExpandStatus(true);
            }
            _row.getCell(1).setValue((Object)_expandInfo);
            _row.getCell(0).setUserObject((Object)orgTreeInfo);
            _row.getCell(1).setUserObject((Object)_unitInfo);
            _key = _areaId + "_" + _unitId;
            if (unionMap == null || !unionMap.containsKey(_key)) continue;
            _ccOrgUnitInfo = (CostCenterOrgUnitInfo)unionMap.get(_key);
            _row.getCell(2).setValue((Object)_ccOrgUnitInfo);
        }
        if (_row != null) {
            this.tblMain.getMergeManager().mergeBlock(_rowBegin, 0, _row.getRowIndex(), 0);
        }
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 1 && e.getColIndex() == 1) {
            NumberExpandInfo expandInfo;
            int rowIndex = e.getRowIndex();
            if (this.tblMain.getRowCount() <= 0) {
                return;
            }
            if (this.tblMain.getRow(rowIndex) != null && this.tblMain.getRow(rowIndex).getCell(1) != null && this.expendRender.inRect(expandInfo = (NumberExpandInfo)this.tblMain.getRow(rowIndex).getCell(1).getValue(), e.getX(), e.getY())) {
                this.setTreeDisplayStyle(this.tblMain.getRow(rowIndex), expandInfo);
            }
        }
    }

    private void setTreeDisplayStyle(IRow row, NumberExpandInfo expandInfo) {
        if (!expandInfo.isLeaf()) {
            this.tblMain.setRefresh(false);
            this.expandTable(row, expandInfo);
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        }
    }

    private void expandTable(IRow row, NumberExpandInfo parentExpandInfo) {
        if (row == null || parentExpandInfo == null) {
            return;
        }
        IRow child = null;
        String longNumber = null;
        NumberExpandInfo expandInfo = null;
        String parentLongNumber = parentExpandInfo.getLongNumber();
        boolean isExpandStatus = parentExpandInfo.isExpandStatus();
        if (isExpandStatus) {
            parentExpandInfo.setExpandStatus(false);
            int rowCount = this.tblMain.getRowCount();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell(1).getValue()).getLongNumber()).startsWith(parentLongNumber + "!"); ++rowIndex) {
                child.getStyleAttributes().setHided(true);
            }
        } else {
            parentExpandInfo.setExpandStatus(true);
            int rowCount = this.tblMain.getRowCount();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell(1).getValue()).getLongNumber()).startsWith(parentLongNumber + "!"); ++rowIndex) {
                child.getStyleAttributes().setHided(false);
                if (expandInfo.isLeaf()) continue;
                expandInfo.setExpandStatus(true);
            }
        }
    }

    protected void verify() throws Exception {
        String _key = null;
        HashSet<String> orgUnitSet = new HashSet<String>();
        IRow row = null;
        OrgTreeInfo _orgTreeInfo = null;
        CostCenterOrgUnitInfo _ccOrgUnitInfo = null;
        int in = this.tblMain.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell(2).getValue() != null && row.getCell(2).getValue() instanceof CostCenterOrgUnitInfo) {
                _orgTreeInfo = (OrgTreeInfo)row.getCell(0).getUserObject();
                _ccOrgUnitInfo = (CostCenterOrgUnitInfo)row.getCell(2).getValue();
                _key = _orgTreeInfo.getId().toString() + "_" + _ccOrgUnitInfo.getId().toString();
                if (orgUnitSet.contains(_key)) {
                    this.tblMain.getSelectManager().select(i, 2);
                    orgUnitSet.clear();
                    throw new BgAreaException(BgAreaException.ORGUNITREPEAT);
                }
                orgUnitSet.add(_key);
                continue;
            }
            row.getCell(2).setValue(null);
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        IRow row = null;
        OrgTreeInfo _orgTreeInfo = null;
        OrgUnitInfo _unitInfo = null;
        CostCenterOrgUnitInfo _ccOrgUnitInfo = null;
        ArrayList<String[]> areaList = new ArrayList<String[]>();
        String[] areaInfo = null;
        int in = this.tblMain.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.tblMain.getRow(i);
            areaInfo = new String[3];
            _orgTreeInfo = (OrgTreeInfo)row.getCell(0).getUserObject();
            _unitInfo = (OrgUnitInfo)row.getCell(1).getUserObject();
            areaInfo[0] = _orgTreeInfo.getId().toString();
            areaInfo[1] = _unitInfo.getId().toString();
            if (row.getCell(2).getValue() != null) {
                _ccOrgUnitInfo = (CostCenterOrgUnitInfo)row.getCell(2).getValue();
                areaInfo[2] = _ccOrgUnitInfo.getId().toString();
            }
            areaList.add(areaInfo);
        }
        BgOrgMappingInfo orgMappingInfo = new BgOrgMappingInfo();
        String msg = BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgNFormResource", "orgunitmapping");
        IObjectPK pk = LogUtil.beginLog(null, (String)msg, (BOSObjectType)orgMappingInfo.getBOSType(), null, (String)msg, (String)"bg_orgmapping_save");
        IBgAreaFacade ibgAreaFacade = BgAreaFacadeFactory.getRemoteInstance();
        if (ibgAreaFacade.updateArea(areaList)) {
            this.setMessageText(BgNFCHelper.getMessageStr(SOURCE_STR, "success"));
            this.showMessage();
            this.setModify(false);
        }
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    protected boolean checkBeforeWindowClosing() {
        boolean re = super.checkBeforeWindowClosing();
        if (re && this.isModify()) {
            int _result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)SOURCE_STR, (String)"beforeSave"));
            if (_result == 0) {
                try {
                    IPermission iPer = PermissionFactory.getRemoteInstance();
                    UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
                    String orgUnitId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
                    iPer.checkFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(orgUnitId), "bg_orgmapping_save");
                    this.actionSave_actionPerformed(null);
                }
                catch (Exception ex) {
                    this.handUIExceptionAndAbort(ex);
                }
            } else if (_result == 2) {
                re = false;
            }
        }
        return re;
    }

    private static class NewOrgTreeInfo {
        private OrgTreeInfo orgTreeInfo;

        public NewOrgTreeInfo(OrgTreeInfo orgTreeInfo) {
            this.orgTreeInfo = orgTreeInfo;
            if (orgTreeInfo.getName() == null) {
                orgTreeInfo.setName("");
            }
        }

        public OrgTreeInfo getOrgTreeInfo() {
            return this.orgTreeInfo;
        }

        public String toString() {
            if (this.orgTreeInfo == null) {
                return null;
            }
            return new StringBuffer().append(this.orgTreeInfo.getName()).append(" (").append(BgNFCHelper.getMessageStr(BgOrgUnitSetUI.SOURCE_STR, "startdate")).append(BgNationalFormatUIUtil.getNationalDateFormat().format(this.orgTreeInfo.getStartDate())).append(")").toString();
        }
    }
}

