/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.print.PrintBookTrans;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.IDObject;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.ZipKDF;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.ma.budget.BgAnalyseFacadeFactory;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.IBgAnalyseFacade;
import com.kingdee.eas.ma.budget.PrintConfigInfo;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.nbudget.BgNFormException;
import com.kingdee.eas.ma.nbudget.client.AbstractBgPredictDataMakeResultUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.ExcelFileFilter;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.math.BigDecimal;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgPredictDataMakeResultUI
extends AbstractBgPredictDataMakeResultUI {
    private static final long serialVersionUID = 3504871312104607000L;
    private static final Logger logger = CoreUIObject.getLogger(BgPredictDataMakeResultUI.class);
    public static final String STRRESOURCE = "com.kingdee.eas.ma.nbudget.BgPredictItemResource";
    protected SpreadContext sc;
    private BOSUuid solutionId = null;
    private CurrencyInfo currency = null;

    public void onShow() throws Exception {
        super.onShow();
        this.setUITitle(EASResource.getString((String)STRRESOURCE, (String)"makeResultTitle"));
        this.initWorkButton();
        this.initDataMakeResult();
    }

    public CurrencyInfo getCurrency() {
        return this.currency;
    }

    public void setCurrency(CurrencyInfo currency) {
        this.currency = currency;
    }

    protected BOSUuid getSolutionId() {
        return this.solutionId;
    }

    protected void setSolutionId(BOSUuid solutionId) {
        this.solutionId = solutionId;
    }

    protected boolean hasSpreadContext() {
        return false;
    }

    protected SpreadContext getSpreadContext() {
        return null;
    }

    protected KDTable getMainTabPane() {
        return this.tblMakeResult;
    }

    protected IBgAnalyseFacade getInterface() throws Exception {
        return BgAnalyseFacadeFactory.getRemoteInstance();
    }

    @Override
    protected void btnPrint_actionPerformed(ActionEvent e) throws Exception {
        super.btnPrint_actionPerformed(e);
        if (this.hasSpreadContext()) {
            SpreadContext sc = this.getSpreadContext();
            if (sc != null) {
                sc.getPrintManager().print();
            }
        } else {
            KDTable _obj = this.tblMakeResult;
            if (_obj == null || !(_obj instanceof KDTable)) {
                return;
            }
            KDTable _table = _obj;
            this.preparePrintPage(_table);
            _table.getPrintManager().print();
        }
    }

    @Override
    protected void btnPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.btnPrintPreview_actionPerformed(e);
        if (this.hasSpreadContext()) {
            SpreadContext sc = this.getSpreadContext();
            if (sc != null) {
                sc.getPrintManager().printPreview();
            }
        } else {
            KDTable _obj = this.tblMakeResult;
            if (_obj == null || !(_obj instanceof KDTable)) {
                return;
            }
            KDTable _table = _obj;
            _table.getDataRequestManager().setDataRequestMode(0);
            this.preparePrintPage(_table);
            _table.getPrintManager().printPreview();
        }
        this.setPrintConfigInfo();
    }

    protected int getSheetSize() {
        int sheetSize = 0;
        Component obj = null;
        int in = this.getMainTabPane().getRowCount();
        for (int i = 0; i < in; ++i) {
            obj = this.getMainTabPane().getComponent(i);
            if (obj instanceof KDTable) {
                sheetSize = 1;
                continue;
            }
            if (!(obj instanceof KDPanel)) continue;
            KDPanel panel = (KDPanel)obj;
            int jn = panel.getComponentCount();
            for (int j = 0; j < jn; ++j) {
                obj = panel.getComponent(j);
                if (!(obj instanceof KDTable)) continue;
                ++sheetSize;
            }
        }
        return sheetSize;
    }

    protected Object getSheet(int index) {
        Component obj = null;
        KDTable sheet = null;
        obj = this.getMainTabPane().getComponent(index);
        if (obj instanceof KDTable) {
            return (KDTable)obj;
        }
        if (obj instanceof KDPanel) {
            KDPanel panel = (KDPanel)obj;
            int n = panel.getComponentCount();
            for (int i = 0; i < n; ++i) {
                obj = panel.getComponent(i);
                if (!(obj instanceof KDTable)) continue;
                sheet = (KDTable)obj;
            }
        }
        return sheet;
    }

    protected void setPrintConfigInfo() throws Exception {
        if (this.solutionId == null) {
            return;
        }
        Book _book = null;
        KDF _kdf = null;
        KDTable _table = null;
        PrintConfigInfo printConfigInfo = new PrintConfigInfo();
        if (this.hasSpreadContext() && this.getSpreadContext() != null) {
            if (this.getSpreadContext().getBook() != null) {
                int sheetSize = this.getSpreadContext().getBook().getSheetCount();
                _book = Book.Manager.getNewBook((String)"PRINT", (int)sheetSize);
                PrintBookTrans.copyPrintSetup((Book)this.getSpreadContext().getBook(), (Book)_book);
                printConfigInfo.setData(IOHelper.packBook((Book)_book));
            }
        } else {
            _kdf = new KDF();
            int in = this.getSheetSize();
            for (int i = 0; i < in; ++i) {
                _table = (KDTable)this.getSheet(i);
                _kdf.addTable((IDObject)_table);
                _table.getPrintManager().saveToKDF(_kdf);
            }
            printConfigInfo.setData(ZipKDF.pack((KDF)_kdf));
        }
        this.getInterface().setPrintConfig(this.solutionId.toString(), (Object)printConfigInfo);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
        if (this.hasSpreadContext()) {
            File file;
            KDFileChooser fc = new KDFileChooser();
            fc.setDialogTitle(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "fileExport"));
            fc.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
            fc.setAcceptAllFileFilterUsed(false);
            fc.setSelectedFile(new File(BgAnalyseHelper.getDefaultFileName()));
            if (fc.showSaveDialog((Component)((Object)this)) == 0 && (file = fc.getSelectedFile()) != null) {
                if (file.exists()) {
                    int re = MsgBox.showConfirm3((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "existsFile"));
                    if (re == 1 || re == 2) {
                        return;
                    }
                    file.delete();
                }
                try {
                    this.exportBookContent(file);
                }
                catch (Exception ex) {
                    throw new BgNFormException(BgNFormException.FILEEXPORTERROR);
                }
            }
        } else {
            KDTable _obj = this.tblMakeResult;
            if (_obj == null || !(_obj instanceof KDTable)) {
                return;
            }
            KDTable _table = _obj;
            BgClientHelper.exportTableToExcel((Component)((Object)this), (KDTable)_table);
        }
    }

    protected void exportBookContent(File file) throws Exception {
        String numFormater = this.getNumberFormat();
        Book _book = this.sc.getBook();
        Sheet _sheet = null;
        Cell _cell = null;
        KDSBook _kdsBook = null;
        KDSSheet _kdsSheet = null;
        KDSCell _kdsCell = null;
        int _sheetIndex = 0;
        int _sheetSize = _book.getSheetCount();
        int _rowIndex = 0;
        int _rowCount = 0;
        int _colIndex = 0;
        int _colCount = 0;
        String _filename = file.getPath();
        _kdsBook = new KDSBook(_filename);
        for (_sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
            _sheet = _book.getSheet(_sheetIndex);
            _kdsSheet = new KDSSheet(_kdsBook, _sheet.getSheetName());
            _kdsBook.addSheet(null, _kdsSheet);
            _rowCount = _sheet.getMaxRowIndex();
            _colCount = _sheet.getMaxColIndex();
            for (_rowIndex = 0; _rowIndex <= _rowCount; ++_rowIndex) {
                for (_colIndex = 0; _colIndex <= _colCount; ++_colIndex) {
                    _cell = _sheet.getCell(_rowIndex, _colIndex, false);
                    if (_cell == null) {
                        _kdsCell = _kdsSheet.getCell(_rowIndex, _colIndex, true);
                        continue;
                    }
                    StyleAttributes ssa = Styles.getEmptySA();
                    _cell.getSheet().getRange(_cell).getStyle(ssa);
                    if (_cell == null || _cell.getValue() == Variant.nullVariant) continue;
                    Variant value = _cell.getValue();
                    if (value.getValue() instanceof BigDecimal) {
                        if (StringUtils.isEmpty((String)ssa.getNumberFormat())) {
                            ssa.setNumberFormat(numFormater);
                        }
                        ssa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    }
                    _kdsCell = _kdsSheet.setCell(_rowIndex, _colIndex, (Object)value, (ShareStyleAttributes)ssa);
                }
            }
        }
        ExportManager em = new ExportManager();
        em.exportToExcel(_kdsBook, _filename);
    }

    public String getNumberFormat() {
        int prec = 2;
        if (this.getCurrency() != null) {
            prec = this.getCurrency().getPrecision();
        }
        StringBuffer sb = new StringBuffer("#,##0.");
        for (int i = 0; i < prec; ++i) {
            sb.append("0");
        }
        return sb.toString();
    }

    public void initDataMakeResult() {
        int i;
        IRow row = null;
        List list = null;
        KDTMergeManager mm = null;
        String name = this.getUIContext().get("name").toString();
        String date = this.getUIContext().get("date").toString();
        String[] header = (String[])this.getUIContext().get("header");
        list = (List)this.getUIContext().get("xdresult");
        String[] str = new String[]{EASResource.getString((String)STRRESOURCE, (String)"makeResultInfo1"), EASResource.getString((String)STRRESOURCE, (String)"makeResultInfo2") + name, EASResource.getString((String)STRRESOURCE, (String)"makeResultInfo3") + date};
        for (i = 0; i < 8; ++i) {
            this.tblMakeResult.addColumn();
        }
        this.tblMakeResult.addHeadRow();
        for (i = 1; i < 4; ++i) {
            row = this.tblMakeResult.addRow();
            row.getCell(0).setValue((Object)str[i - 1]);
        }
        mm = this.tblMakeResult.getMergeManager();
        mm.mergeBlock(0, 0, 0, 7, 4);
        mm.mergeBlock(1, 0, 1, 7, 4);
        mm.mergeBlock(2, 0, 2, 7, 4);
        this.tblMakeResult.addRow();
        row = this.tblMakeResult.addRow();
        for (i = 0; i < header.length; ++i) {
            row.getCell(i).setValue((Object)header[i]);
        }
        for (i = 0; i < list.size(); ++i) {
            row = this.tblMakeResult.addRow();
            if (list.get(i) == null) continue;
            String[] bgPredictDataMake = (String[])list.get(i);
            for (int j = 0; j < header.length; ++j) {
                row.getCell(j).setValue((Object)bgPredictDataMake[j]);
            }
        }
        this.tblMakeResult.getStyleAttributes().setLocked(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
    }
}

