/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.util.UIConfigUtility;
import com.kingdee.eas.ma.budget.BgAnalyseFacadeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgAnalyseFacade;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgPredictItemListFacadeFactory;
import com.kingdee.eas.ma.nbudget.client.AbstractBgPredictItemPredictDataMakeUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgPredictDataMakeResultUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgPredictItemPredictDataMakeUI
extends AbstractBgPredictItemPredictDataMakeUI {
    private static final long serialVersionUID = 1862052119938588879L;
    private static final Logger logger = CoreUIObject.getLogger(BgPredictItemPredictDataMakeUI.class);
    String[] orgUnitIDs = null;
    String[] bgPreidctFormRecordIDs = null;
    FilterItemInfo filterItemInfo = null;
    String bgPeriod = null;
    IRowSet irs = null;
    int recordNumber = 0;
    private Map dataMake = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String bgPredictMakeID = (String)this.getUIContext().get("BgPredictDataMakes");
        Map map = BgPredictItemListFacadeFactory.getRemoteInstance().readPeriod(bgPredictMakeID);
        String bgPeriodType = (String)map.get("PeriodType");
        String[] bgPeriodTypes = bgPeriodType.split(",");
        if (bgPeriodType != null) {
            block6: for (int i = 0; i < bgPeriodTypes.length; ++i) {
                int type = Integer.parseInt(bgPeriodTypes[i]);
                switch (type) {
                    case 1: {
                        this.kbYear.setSelected(true);
                        continue block6;
                    }
                    case 2: {
                        this.kbHarfYear.setSelected(true);
                        continue block6;
                    }
                    case 3: {
                        this.kbSeason.setSelected(true);
                        continue block6;
                    }
                    case 4: {
                        this.kbMonth.setSelected(true);
                        continue block6;
                    }
                }
            }
        }
        this.init();
    }

    protected void init() throws Exception {
        this.initFilterOfSchemeAndTemplate();
        this.initCheckBox();
        this.kDTextArea1.setEnabled(false);
        this.kDTextArea1.setEditable(false);
        this.kDTextArea1.setCustomForegroundColor(Color.gray);
        this.kDTextArea1.setText("\r\n" + EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgPredictItemResource", (String)"makedatamsg1") + "\r\n" + EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgPredictItemResource", (String)"makedatamsg2") + "\r\n" + EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgPredictItemResource", (String)"makedatamsg3"));
    }

    private void initFilterOfSchemeAndTemplate() {
        String orgid = "";
        String idtmp = "";
        this.orgUnitIDs = ((String)this.getUIContext().get("OrgUnit")).split(",");
        HashSet<String> orgUnits = new HashSet<String>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        for (int i = 0; i < this.orgUnitIDs.length; ++i) {
            orgUnits.add(this.orgUnitIDs[i]);
            orgid = "".equals(orgid) ? "'" + this.orgUnitIDs[i] + "'" : orgid + ",'" + this.orgUnitIDs[i] + "'";
        }
        idtmp = "select frootid  from T_BG_BgScheme where forgunitid in(" + orgid + ")";
        evi.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("id ", (Object)idtmp, CompareType.INNER));
        this.prmtBgScheme.setEditFormat("$name$");
        this.prmtBgScheme.setDisplayFormat("$name$");
        this.prmtBgScheme.setCommitFormat("$id$");
        this.prmtBgScheme.setEntityViewInfo(evi);
        this.prmtBgTemplate.setEditFormat("$name$");
        this.prmtBgTemplate.setDisplayFormat("$name$");
        this.prmtBgTemplate.setCommitFormat("$id$");
        this.prmtBgTemplate.setEntityViewInfo(evi);
        this.prmtBgScheme.setEnabledMultiSelection(true);
    }

    private void initCheckBox() {
        this.kbYear.setSelected(false);
        this.kbHarfYear.setSelected(false);
        this.kbSeason.setSelected(false);
        this.kbMonth.setSelected(false);
    }

    public boolean[] getPeriodType() {
        boolean[] periodType = new boolean[]{this.kbYear.getSelected() == 32, this.kbHarfYear.getSelected() == 32, this.kbSeason.getSelected() == 32, this.kbMonth.getSelected() == 32};
        return periodType;
    }

    public boolean getFormPeriodTypeRequired() {
        boolean[] periodType = this.getPeriodType();
        for (int i = 0; i < 4; ++i) {
            if (!periodType[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgScheme_dataChanged(e);
        Object[] obj = (Object[])this.prmtBgScheme.getData();
        boolean value = false;
        if (obj == null) {
            return;
        }
        for (int i = 0; i < obj.length; ++i) {
            if (obj[i] == null) continue;
            value = true;
        }
        if (value) {
            this.removeTemplateFilter();
            HashSet<String> subOrgUnits = new HashSet<String>();
            BOSUuid[] orgUnitIds = new BOSUuid[this.orgUnitIDs.length];
            for (int i = 0; i < this.orgUnitIDs.length; ++i) {
                orgUnitIds[i] = BOSUuid.read((String)this.orgUnitIDs[i]);
            }
            EntityViewInfo evi = new EntityViewInfo();
            for (int i = 0; i < obj.length; ++i) {
                BgTemplateCollection templateCollection = this.getBgTemplateInfo(((BgSchemeInfo)obj[i]).getId(), orgUnitIds);
                for (int j = 0; j < templateCollection.size(); ++j) {
                    subOrgUnits.add(templateCollection.get(j).getId().toString());
                }
            }
            FilterInfo filterInfo = new FilterInfo();
            evi.setFilter(filterInfo);
            filterInfo.getFilterItems().add(new FilterItemInfo("id", subOrgUnits, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("formType", (Object)4, CompareType.NOTEQUALS));
            this.prmtBgTemplate.setEntityViewInfo(evi);
        }
    }

    private void removeTemplateFilter() {
        EntityViewInfo evi = this.prmtBgTemplate.getEntityViewInfo();
        FilterInfo filterInfo = evi.getFilter();
        filterInfo.getFilterItems().remove(this.filterItemInfo);
    }

    protected BgTemplateCollection getBgTemplateInfo(BOSUuid bgSchemeId, BOSUuid[] orgUnitIds) throws Exception {
        return this.getInterface().getCommonBgTemplate(bgSchemeId, orgUnitIds);
    }

    protected IBgAnalyseFacade getInterface() throws Exception {
        return BgAnalyseFacadeFactory.getRemoteInstance();
    }

    @Override
    public void prmtBgTemplate_dataChanged(DataChangeEvent e) throws Exception {
        Object obj = this.prmtBgTemplate.getData();
        this.kbYear.setSelected(false);
        this.kbHarfYear.setSelected(false);
        this.kbSeason.setSelected(false);
        this.kbMonth.setSelected(false);
        if (obj != null && obj instanceof BgTemplateInfo) {
            String bgPredictMakeID = (String)this.getUIContext().get("BgPredictDataMakes");
            Map map = BgPredictItemListFacadeFactory.getRemoteInstance().readPeriod(bgPredictMakeID);
            String bgPeriodType = (String)map.get("PeriodType");
            String[] bgPeriodTypes = bgPeriodType.split(",");
            block6: for (int i = 0; i < bgPeriodTypes.length; ++i) {
                int type = Integer.parseInt(bgPeriodTypes[i]);
                switch (type) {
                    case 1: {
                        this.kbYear.setSelected(true);
                        continue block6;
                    }
                    case 2: {
                        this.kbHarfYear.setSelected(true);
                        continue block6;
                    }
                    case 3: {
                        this.kbSeason.setSelected(true);
                        continue block6;
                    }
                    case 4: {
                        this.kbMonth.setSelected(true);
                        continue block6;
                    }
                }
            }
        }
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        String bgSchemeID = "";
        String bgTemplateID = null;
        String bgTemplateName = null;
        String bgSchemeName = "";
        String tmpBgPreidctFormRecordIDs = (String)this.getUIContext().get("BgPredictDataMakes");
        Object[] objBgScheme = null;
        Object objBgTemplate = null;
        Object obj = null;
        final HashMap<String, Object> map = new HashMap<String, Object>();
        String newMakeRecord = null;
        obj = this.prmtBgTemplate.getData();
        if (obj != null && obj instanceof BgTemplateInfo) {
            if (!this.getFormPeriodTypeRequired()) {
                MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.SimForecastFilterResource", "formPeriodType"));
                return;
            }
            boolean[] bgPeriodType = this.getPeriodType();
            newMakeRecord = BgPredictItemListFacadeFactory.getRemoteInstance().makeRecord(bgPeriodType, tmpBgPreidctFormRecordIDs);
            bgTemplateID = ((BgTemplateInfo)obj).getId().toString();
            bgTemplateName = ((BgTemplateInfo)obj).getName().toString();
        }
        if ((objBgScheme = (Object[])this.prmtBgScheme.getData()) == null) {
            this.prmtBgScheme.requestFocus();
            MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.SimForecastFilterResource", "schemeselect"));
            return;
        }
        for (int i = 0; i < objBgScheme.length; ++i) {
            if (objBgScheme[0] == null) {
                this.prmtBgScheme.requestFocus();
                MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.SimForecastFilterResource", "schemeselect"));
                return;
            }
            if (objBgScheme[i] == null || !(objBgScheme[i] instanceof BgSchemeInfo)) continue;
            bgSchemeID = bgSchemeID + ((BgSchemeInfo)objBgScheme[i]).getId().toString() + ",";
            bgSchemeName = bgSchemeName + ((BgSchemeInfo)objBgScheme[i]).getName().toString() + ",";
        }
        if (newMakeRecord != null && !newMakeRecord.equals("")) {
            map.put("predictRecordID", newMakeRecord);
            map.put("bgSchemeID", bgSchemeID);
            map.put("bgTemplateID", bgTemplateID);
            map.put("bgTemplateName", bgTemplateName);
            map.put("bgSchemeName", bgSchemeName);
        } else if (tmpBgPreidctFormRecordIDs != null && !tmpBgPreidctFormRecordIDs.equals("")) {
            map.put("predictRecordID", tmpBgPreidctFormRecordIDs);
            map.put("bgSchemeID", bgSchemeID);
            map.put("bgTemplateID", bgTemplateID);
            map.put("bgTemplateName", bgTemplateName);
            map.put("bgSchemeName", bgSchemeName);
        } else {
            return;
        }
        map.put("selectPeriodType", this.getPeriodType());
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                Map result = BgPredictItemListFacadeFactory.getRemoteInstance().predictDataMake(map);
                return result;
            }

            public void afterExec(Object result) throws Exception {
                BgPredictItemPredictDataMakeUI.this.viewMake((Map)result);
            }
        });
        dialog.show();
        ListUI ui = this.getListUI(this.getUIContext().get("Owner"));
        ui.refreshList();
        this.uiWindow.close();
    }

    private void viewMake(Map map) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"name", map.get("name"));
        uiContext.put((Object)"date", map.get("date"));
        uiContext.put((Object)"header", map.get("header"));
        uiContext.put((Object)"xdresult", map.get("makeResult"));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(BgPredictDataMakeResultUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private ListUI getListUI(Object obj) {
        if (obj instanceof ListUI) {
            return (ListUI)obj;
        }
        Component c = (Component)obj;
        return this.getListUI(c.getParent());
    }

    protected String getEditUIModal() {
        String openModel = UIConfigUtility.getOpenModel();
        if (openModel != null) {
            return openModel;
        }
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiWindow.close();
    }
}

