/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTCellSelectAction;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgAdjustTypeEnum;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgFormHelper;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.BgReqAdjustBillEntryInfo;
import com.kingdee.eas.ma.nbudget.BgRequestAdjustBillException;
import com.kingdee.eas.ma.nbudget.BgRequestAdjustBillFactory;
import com.kingdee.eas.ma.nbudget.BgRequestAdjustBillInfo;
import com.kingdee.eas.ma.nbudget.BgRequestAdjustStateEnum;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillEntryCollection;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillEntryFactory;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillEntryInfo;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillFactory;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillInfo;
import com.kingdee.eas.ma.nbudget.IBgRequestAdjustBill;
import com.kingdee.eas.ma.nbudget.IBudgetRequestBill;
import com.kingdee.eas.ma.nbudget.client.AbstractBgRequestAdjustBillEditUI;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComboBox;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class BgRequestAdjustBillEditUI
extends AbstractBgRequestAdjustBillEditUI {
    private static final long serialVersionUID = -1537422711691769263L;
    private static final Logger logger = CoreUIObject.getLogger(BgRequestAdjustBillEditUI.class);
    private static final String RESOURCESTR = "com.kingdee.eas.ma.nbudget.client.BgRequestAdjustBillResource";
    private Map paramValue = null;
    protected Map rpcDataMap = null;
    protected Map adjustInfo = new HashMap();
    protected Map bgItemsInfo = new HashMap();
    protected FullOrgUnitInfo OrgUnitInfo = null;
    protected BgSchemeInfo bgSchemeRootInfo = null;
    protected boolean hasCodeNumber = false;
    protected boolean hasCodeShowOfAddNew = false;
    private boolean isUseIntermitNumber = false;
    protected String bgItemNumColIndex = "bgItemNum";
    protected String bgItemNameColIndex = "bgItemName";
    protected String formulaColIndex = "formula";
    protected String adjustTypeColIndex = "adjustType";
    protected String adjustBeforeColIndex = "adjustBefore";
    protected String adjustApplyColIndex = "adjustApply";
    protected String adjustPassColIndex = "adjustPass";
    protected String adjustAfterColIndex = "adjustAfter";
    protected String adjustGroupColIndex = "adjustGroup";
    protected String adjustCauseColIndex = "adjustCause";
    protected String currencyColIndex = "currency";
    protected String bgElementColIndex = "bgElement";
    protected String requestBillApplyColIndex = "requestBillApply";
    protected static final String STATUS_AUDIT = "AUDIT";

    public void onLoad() throws Exception {
        super.onLoad();
        String CurrOprtState = this.getOprtState();
        if (!CurrOprtState.equals(OprtState.ADDNEW)) {
            this.txtNumber.setEnabled(false);
            if (this.editData.getState().equals((Object)BgRequestAdjustStateEnum.APPROVED)) {
                this.btnAntiAudit.setEnabled(true);
            }
        }
        this.btnAudit.setEnabled(this.editData.getState().equals((Object)BgRequestAdjustStateEnum.ADJUST));
        this.paramValue = (Map)this.rpcDataMap.get("paramValue");
        this.initSystemInfo();
        this.prmtBgReqBill.setEnabled(false);
        this.btnPnlInsertLine.setEnabled(false);
        this.btnInsertLine.setEnabled(false);
        this.btnAddLine.setEnabled(false);
    }

    protected void initSystemInfo() throws EASBizException, BOSException {
        block6: {
            block5: {
                String CurrOprtState;
                this.OrgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("ORGUNIT");
                this.prmtBgReqBill.setQueryInfo("com.kingdee.eas.ma.nbudget.app.BgRequestBillF7Query");
                this.prmtBgReqBill.setDisplayFormat("$number$");
                this.prmtBgReqBill.setEditFormat("$number$");
                this.prmtBgReqBill.setCommitFormat("$number$");
                this.prmtBgScheme.addDataChangeListener(new DataChangeListener(){

                    public void dataChanged(DataChangeEvent eventObj) {
                        if (BgRequestAdjustBillEditUI.this.prmtBgScheme.getData() != null) {
                            BgRequestAdjustBillEditUI.this.prmtBgReqBill.setEnabled(true);
                        } else {
                            BgRequestAdjustBillEditUI.this.prmtBgReqBill.setEnabled(false);
                        }
                        BgRequestAdjustBillEditUI.this.initBgRequestBillInfo((BgSchemeInfo)BgRequestAdjustBillEditUI.this.prmtBgScheme.getData());
                    }
                });
                this.prmtBgScheme.addPreChangeListener(new PreChangeListener(){

                    public void preChange(PreChangeEvent e) {
                        BgRequestAdjustBillEditUI.this.currentlyBgScheme_willShow(e);
                    }
                });
                this.prmtBgReqBill.addPreChangeListener(new PreChangeListener(){

                    public void preChange(PreChangeEvent e) {
                        BgRequestAdjustBillEditUI.this.currentlyBgRequestBill_willShow(e);
                    }
                });
                this.prmtBgReqBill.addDataChangeListener(new DataChangeListener(){

                    public void dataChanged(DataChangeEvent eventObj) {
                        BgRequestAdjustBillEditUI.this.loadBgRequestBillInfo((BudgetRequestBillInfo)BgRequestAdjustBillEditUI.this.prmtBgReqBill.getData());
                    }
                });
                if (this.getDetailTable() != null) {
                    this.getDetailTable().getColumn(this.bgItemNameColIndex).getStyleAttributes().setLocked(true);
                    this.getDetailTable().getColumn(this.bgElementColIndex).getStyleAttributes().setLocked(true);
                    this.getDetailTable().getColumn(this.currencyColIndex).getStyleAttributes().setLocked(true);
                    this.getDetailTable().getColumn(this.adjustBeforeColIndex).getStyleAttributes().setLocked(true);
                    this.getDetailTable().getColumn(this.adjustAfterColIndex).getStyleAttributes().setLocked(true);
                }
                if (!(CurrOprtState = this.getOprtState()).equals(OprtState.ADDNEW) && !CurrOprtState.equals(OprtState.EDIT) && !CurrOprtState.equals("FINDVIEW") && !CurrOprtState.equals(STATUS_AUDIT)) break block5;
                String CUID = this.editData.getCU().getId().toString();
                boolean hasCodeRule = false;
                if (this.rpcDataMap.get("hasCodeRule") instanceof Boolean) {
                    hasCodeRule = (Boolean)this.rpcDataMap.get("hasCodeRule");
                }
                if (!hasCodeRule) break block6;
                this.txtNumber.setEnabled(false);
                this.hasCodeNumber = true;
                if (!this.hasCodeNumber) break block6;
                this.hasCodeShowOfAddNew = BgHelper.hasDisplayNumber((CoreBaseInfo)this.editData, (String)CUID, null);
                break block6;
            }
            this.txtNumber.setEnabled(false);
            this.actionAddLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
            this.actionDeleteLine.setEnabled(false);
            this.workbtnRemoveLine.setEnabled(false);
            if (!this.editData.getState().equals((Object)BgRequestAdjustStateEnum.ADJUST)) {
                this.btnRemove.setEnabled(false);
            }
            if (this.editData.getState().getValue() != 1) {
                this.actionAddNew.setEnabled(false);
                this.actionEdit.setEnabled(false);
            }
            int n = this.getDetailTable().getColumnCount();
            for (int i = 0; i < n; ++i) {
                this.getDetailTable().getColumn(i).getStyleAttributes().setLocked(true);
            }
        }
        this.initSelectInfo();
    }

    protected void initBgRequestBillInfo(BgSchemeInfo bgSchemeInfo) {
        if (this.OrgUnitInfo == null || bgSchemeInfo == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.rootid", (Object)bgSchemeInfo.getRootId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.OrgUnitInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(5), CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtBgReqBill.setEntityViewInfo(view);
    }

    protected void loadBgRequestBillInfo(BudgetRequestBillInfo bgReqBillInfo) {
        if (bgReqBillInfo == null || bgReqBillInfo.getBgEnties() == null || bgReqBillInfo.getReqOrgUnit() == null) {
            return;
        }
        this.editData.setCloseDate(bgReqBillInfo.getBgEndDate());
        FullOrgUnitInfo reqOrg = null;
        ObjectUuidPK orgPK = new ObjectUuidPK(bgReqBillInfo.getReqOrgUnit().getId().toString());
        try {
            reqOrg = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)orgPK);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.editData.setReqOrgUnit(reqOrg);
        this.prmtReqOrgUnit.setData((Object)reqOrg);
        Object currencyPK = null;
        CurrencyInfo currency = null;
        BudgetRequestBillEntryInfo reqEntryInfo = null;
        BgReqAdjustBillEntryInfo adjustEntryInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("bgEnties.id");
        sic.add("bgEnties.bgItemNumber");
        sic.add("bgEnties.bgItemName");
        sic.add("bgEnties.bgElement.name");
        sic.add("bgEnties.currency.id");
        sic.add("bgEnties.currency.name");
        sic.add("bgEnties.currency.precision");
        sic.add("bgEnties.formula");
        sic.add("bgEnties.applyValue");
        BudgetRequestBillInfo billInfo = null;
        try {
            billInfo = BudgetRequestBillFactory.getRemoteInstance().getBudgetRequestBillInfo((IObjectPK)new ObjectUuidPK(bgReqBillInfo.getId().toString()), sic);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (billInfo == null) {
            billInfo = bgReqBillInfo;
        }
        BudgetRequestBillEntryCollection entryColl = billInfo.getBgEnties();
        for (int i = 0; i < entryColl.size(); ++i) {
            reqEntryInfo = entryColl.get(i);
            String bgItemNum = reqEntryInfo.getBgItemNumber();
            String bgItemName = reqEntryInfo.getBgItemName();
            String bgElementName = reqEntryInfo.getBgElement().getName();
            String CurrencyName = reqEntryInfo.getCurrency().getName();
            String formula = reqEntryInfo.getFormula();
            currency = reqEntryInfo.getCurrency();
            BigDecimal applyValue = reqEntryInfo.getApplyValue();
            this.addLine(this.getDetailTable());
            IRow row = this.getDetailTable().getRow(i);
            adjustEntryInfo = (BgReqAdjustBillEntryInfo)row.getUserObject();
            adjustEntryInfo.setCurrency(currency);
            int precision = currency.getPrecision();
            row.getCell(this.bgItemNumColIndex).setValue((Object)bgItemNum);
            row.getCell(this.bgItemNameColIndex).setValue((Object)bgItemName);
            row.getCell(this.bgElementColIndex).setValue((Object)bgElementName);
            row.getCell(this.currencyColIndex).setValue((Object)CurrencyName);
            row.getCell(this.formulaColIndex).setValue((Object)formula);
            row.getCell(this.currencyColIndex).setValue((Object)currency);
            row.getCell(this.requestBillApplyColIndex).setValue((Object)applyValue.setScale(precision, 4));
            row.getCell("reqBillEntryId").setValue((Object)reqEntryInfo.getId());
            row.getCell(this.adjustBeforeColIndex).setValue((Object)applyValue.setScale(precision, 4));
        }
    }

    protected void currentlyBgScheme_willShow(PreChangeEvent e) {
        if (this.prmtBgScheme.getData() != null && this.prmtBgReqBill.getValue() != null) {
            int re;
            if (e.getOldData() == null) {
                return;
            }
            if (e.getOldData().equals(e.getData())) {
                e.setResult(0);
                SysUtil.abort();
            }
            if ((re = MsgBox.showConfirm2((String)EASResource.getString((String)RESOURCESTR, (String)"isRestartBgRequesetBill"))) == 1 || re == 2) {
                e.setResult(0);
                SysUtil.abort();
            }
            if (this.prmtBgReqBill.getValue() != null) {
                this.prmtBgReqBill.setValue(null);
                this.prmtBgReqBill.requestFocus();
            }
            if (this.getDetailTable() != null) {
                this.getDetailTable().removeRows();
                this.editData.getEntry().clear();
            }
        }
    }

    protected void currentlyBgRequestBill_willShow(PreChangeEvent e) {
        if (this.prmtBgScheme.getData() != null) {
            if (this.prmtBgReqBill.getData() != null) {
                int re;
                if (e.getOldData() == null) {
                    return;
                }
                if (e.getOldData().equals(e.getData())) {
                    e.setResult(0);
                    SysUtil.abort();
                }
                if ((re = MsgBox.showConfirm2((String)EASResource.getString((String)RESOURCESTR, (String)"isRestartBgRequesetBill"))) == 1 || re == 2) {
                    e.setResult(0);
                    SysUtil.abort();
                }
            }
            if (this.getDetailTable() != null) {
                this.getDetailTable().removeRows();
                this.editData.getEntry().clear();
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCESTR, (String)"isCantNullOfBgScheme"));
            SysUtil.abort();
            this.prmtBgScheme.requestFocus();
        }
    }

    protected void getRPCData() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        IBgRequestAdjustBill iBgRequestAdjustBill = BgRequestAdjustBillFactory.getRemoteInstance();
        if (this.editData != null && this.editData.getId() != null) {
            params.put("bgReqAdjustBillId", this.editData.getId().toString());
        }
        params.put("billInfo", this.editData);
        params.put("cuid", this.editData.getCU().getId().toString());
        this.rpcDataMap = iBgRequestAdjustBill.getRPCDataMap(params);
    }

    protected void initSelectInfo() throws EASBizException, BOSException {
        KDComboBox comSelect = null;
        KDFormattedTextField formattedTextField = null;
        this.initCuuentlyBgSchemeInfo((FullOrgUnitInfo)this.prmtOrgUnit.getData());
        this.initBgRequestBillInfo((BgSchemeInfo)this.prmtBgScheme.getData());
        comSelect = new KDComboBox();
        comSelect.addItems(BgAdjustTypeEnum.getEnumList().toArray());
        this.kdtEntry.getColumn(this.adjustTypeColIndex).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comSelect));
        formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        formattedTextField.setPrecision(10);
        formattedTextField.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
        formattedTextField.setMinimumValue((Comparable)GlUtils.minBigDecimal);
        this.kdtEntry.getColumn(this.adjustBeforeColIndex).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
        this.kdtEntry.getColumn(this.adjustApplyColIndex).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
        this.kdtEntry.getColumn(this.adjustPassColIndex).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
        this.kdtEntry.getColumn(this.adjustAfterColIndex).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
        KDTextArea adjustCauseArea = new KDTextArea();
        adjustCauseArea.setMaxLength(80);
        this.kdtEntry.getColumn(this.adjustCauseColIndex).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextArea)adjustCauseArea));
        formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        formattedTextField.setPrecision(BgConstants.BIGZERO.intValue());
        formattedTextField.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
        formattedTextField.setMinimumValue((Comparable)GlUtils.minBigDecimal);
        this.kdtEntry.getColumn(this.adjustGroupColIndex).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
    }

    protected void initCuuentlyBgSchemeInfo(FullOrgUnitInfo orgUnitInfo) {
        if (orgUnitInfo == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
        filter.setMaskString(" #0 ");
        if (BgParamCHelper.isFodian()) {
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(4), CompareType.NOTEQUALS));
        }
        if (BgSHelper.isBgPermissionUsed((Map)this.paramValue)) {
            HashSet<String> orgSet = new HashSet<String>();
            if (orgUnitInfo != null) {
                orgSet.add(orgUnitInfo.getId().toString());
            } else {
                orgSet.add("000000000000000000000000000");
            }
            String user = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            filter = BgPermissionHelper.addBgSchemePermission(user, orgSet, filter);
        }
        view.setFilter(filter);
        this.prmtBgScheme.setEntityViewInfo(view);
    }

    @Override
    protected void kdtEntry_editStopped(KDTEditEvent e) throws Exception {
        super.kdtEntry_editStopped(e);
        int colIndex = e.getColIndex();
        if (colIndex == this.getDetailTable().getColumn(this.adjustApplyColIndex).getColumnIndex()) {
            this.processApplyValue(e);
        } else if (colIndex == this.getDetailTable().getColumn(this.adjustPassColIndex).getColumnIndex()) {
            this.processPassValue(e);
        }
    }

    protected void processApplyValue(KDTEditEvent e) {
        BigDecimal value = null;
        BigDecimal apply = null;
        BigDecimal after = null;
        IRow row = this.getDetailTable().getRow(e.getRowIndex());
        BgReqAdjustBillEntryInfo entry = (BgReqAdjustBillEntryInfo)row.getUserObject();
        try {
            value = new BigDecimal(row.getCell(this.adjustBeforeColIndex).getValue().toString().trim());
            apply = e.getValue() == null ? BgConstants.BIGZERO : new BigDecimal(e.getValue().toString().trim());
        }
        catch (Exception ex) {
            value = BgConstants.BIGZERO;
            apply = BgConstants.BIGZERO;
        }
        after = value.add(apply).setScale(10, 4);
        if (entry != null && entry.getCurrency() != null) {
            int precision = entry.getCurrency().getPrecision();
            row.getCell(this.adjustApplyColIndex).setValue((Object)apply.setScale(precision, 4));
            row.getCell(this.adjustPassColIndex).setValue((Object)apply.setScale(precision, 4));
            row.getCell(this.adjustAfterColIndex).setValue((Object)after.setScale(precision, 4));
        } else {
            row.getCell(this.adjustApplyColIndex).setValue((Object)apply);
            row.getCell(this.adjustPassColIndex).setValue((Object)apply);
            row.getCell(this.adjustAfterColIndex).setValue((Object)after);
        }
    }

    protected void processPassValue(KDTEditEvent e) {
        BigDecimal value = null;
        BigDecimal pass = null;
        BigDecimal after = null;
        IRow row = this.getDetailTable().getRow(e.getRowIndex());
        BgReqAdjustBillEntryInfo entry = (BgReqAdjustBillEntryInfo)row.getUserObject();
        try {
            value = new BigDecimal(row.getCell(this.adjustBeforeColIndex).getValue().toString().trim());
            pass = e.getValue() == null ? BgConstants.BIGZERO : new BigDecimal(e.getValue().toString().trim());
        }
        catch (Exception ex) {
            value = BgConstants.BIGZERO;
            pass = BgConstants.BIGZERO;
        }
        after = entry != null && entry.getCurrency() != null ? value.add(pass).setScale(entry.getCurrency().getPrecision(), 4) : value.add(pass).setScale(10, 4);
        if (entry != null && entry.getCurrency() != null) {
            int precision = entry.getCurrency().getPrecision();
            row.getCell(this.adjustPassColIndex).setValue((Object)pass.setScale(precision, 4));
            row.getCell(this.adjustAfterColIndex).setValue((Object)after.setScale(precision, 4));
        } else {
            row.getCell(this.adjustPassColIndex).setValue((Object)pass);
            row.getCell(this.adjustAfterColIndex).setValue((Object)after);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.separatorFile1.setVisible(false);
        this.separatorFW1.setVisible(false);
        this.separatorFW2.setVisible(false);
        this.separatorFW3.setVisible(false);
        this.separatorFW4.setVisible(false);
        this.separatorFW5.setVisible(false);
        this.separatorFW6.setVisible(false);
        this.separatorFW7.setVisible(false);
        this.separatorFW8.setVisible(false);
        this.separatorFW9.setVisible(false);
        this.actionAddLine.setEnabled(false);
        this.actionInsertLine.setEnabled(false);
        this.actionRemoveLine.setEnabled(false);
        this.actionCopy.setEnabled(false);
        this.actionFirst.setEnabled(false);
        this.actionPre.setEnabled(false);
        this.actionNext.setEnabled(false);
        this.actionLast.setEnabled(false);
        this.actionCreateFrom.setEnabled(false);
        this.actionCopyFrom.setEnabled(false);
        this.actionTraceUp.setEnabled(false);
        this.actionTraceDown.setEnabled(false);
        this.actionMultiapprove.setEnabled(false);
        this.actionNextPerson.setEnabled(false);
        this.actionPrint.setEnabled(false);
        this.actionPrintPreview.setEnabled(false);
        this.btnCopy.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnCreateFrom.setVisible(false);
        this.btnCopyFrom.setVisible(false);
        this.btnTraceUp.setVisible(false);
        this.btnTraceDown.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.btnNextPerson.setVisible(false);
        this.btnPrint.setVisible(true);
        this.btnPrint.setEnabled(true);
        this.btnPrintPreview.setVisible(true);
        this.btnPrintPreview.setEnabled(true);
        this.menuItemPrint.setVisible(false);
        this.menuItemPrintPreview.setVisible(false);
        this.menuItemCreateFrom.setVisible(false);
        this.menuItemCreateTo.setVisible(false);
        this.menuItemCopyFrom.setVisible(false);
        this.menuView.setVisible(false);
        this.workbtnRemoveLine.setEnabled(true);
        this.workbtnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnPnlInsertLine.setEnabled(true);
        this.btnPnlInsertLine.setText("");
        this.btnPnlInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.menuWorkflow.setVisible(false);
        this.btnWorkFlowG.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnAntiAudit.setVisible(false);
        this.actionSubmit.setEnabled(true);
        this.actionSubmit.setVisible(true);
        this.btnSubmit.setEnabled(true);
        this.btnSubmit.setVisible(true);
        this.menuSubmitOption.setEnabled(false);
        this.menuSubmitOption.setVisible(false);
        this.menuItemSubmit.setVisible(true);
        this.actionPrint.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setEnabled(false);
        this.actionPrintPreview.setVisible(false);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("reqDate"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("bgScheme.id"));
        sic.add(new SelectorItemInfo("bgScheme.name"));
        sic.add(new SelectorItemInfo("bgScheme.number"));
        sic.add(new SelectorItemInfo("bgScheme.rootId"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("reqOrgUnit.id"));
        sic.add(new SelectorItemInfo("reqOrgUnit.name"));
        sic.add(new SelectorItemInfo("reqOrgUnit.number"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("bgRequestBill.id"));
        sic.add(new SelectorItemInfo("bgRequestBill.number"));
        sic.add(new SelectorItemInfo("entry.bgItemId"));
        sic.add(new SelectorItemInfo("entry.adjustBefore"));
        sic.add(new SelectorItemInfo("entry.adjustApply"));
        sic.add(new SelectorItemInfo("entry.adjustPass"));
        sic.add(new SelectorItemInfo("entry.adjustAfter"));
        sic.add(new SelectorItemInfo("entry.adjustGroup"));
        sic.add(new SelectorItemInfo("entry.adjustCause"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.number"));
        sic.add(new SelectorItemInfo("entry.adjustType"));
        sic.add(new SelectorItemInfo("entry.orgUnit.id"));
        sic.add(new SelectorItemInfo("entry.orgUnit.name"));
        sic.add(new SelectorItemInfo("entry.orgUnit.number"));
        sic.add(new SelectorItemInfo("entry.currency.id"));
        sic.add(new SelectorItemInfo("entry.currency.name"));
        sic.add(new SelectorItemInfo("entry.currency.number"));
        sic.add(new SelectorItemInfo("entry.currency.precision"));
        sic.add(new SelectorItemInfo("entry.requestBillApply"));
        sic.add(new SelectorItemInfo("entry.reqBillEntryId"));
        return sic;
    }

    protected IObjectValue createNewData() {
        BgRequestAdjustBillInfo bgReqAdjustBillInfo = new BgRequestAdjustBillInfo();
        bgReqAdjustBillInfo.setId(BOSUuid.create((BOSObjectType)bgReqAdjustBillInfo.getBOSType()));
        bgReqAdjustBillInfo.setCU((CtrlUnitInfo)this.getUIContext().get("ORGUNIT_CU"));
        bgReqAdjustBillInfo.setOrgUnit((FullOrgUnitInfo)this.getUIContext().get("ORGUNIT"));
        bgReqAdjustBillInfo.setState(BgRequestAdjustStateEnum.ADJUST);
        bgReqAdjustBillInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        bgReqAdjustBillInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        String CUID = bgReqAdjustBillInfo.getOrgUnit().getId().toString();
        this.hasCodeNumber = BgHelper.hasNumber((CoreBaseInfo)bgReqAdjustBillInfo, (String)CUID, null);
        if (this.hasCodeNumber) {
            this.hasCodeShowOfAddNew = BgHelper.hasDisplayNumber((CoreBaseInfo)bgReqAdjustBillInfo, (String)CUID, null);
            if (this.hasCodeShowOfAddNew) {
                this.getNumberByCodingRule((IObjectValue)bgReqAdjustBillInfo, CUID);
            }
        } else {
            this.isUseIntermitNumber = BgHelper.isUseIntermitNumber((CoreBaseInfo)bgReqAdjustBillInfo, (String)CUID, null);
            if (this.isUseIntermitNumber) {
                String num = "";
                bgReqAdjustBillInfo.setNumber(num);
                this.txtNumber.setText(num);
                this.txtNumber.setEnabled(false);
            }
        }
        return bgReqAdjustBillInfo;
    }

    protected IObjectValue createNewDetailData(KDTable arg0) {
        BgReqAdjustBillEntryInfo entry = new BgReqAdjustBillEntryInfo();
        entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
        entry.setAdjustGroup(0);
        entry.setAdjustBefore(BgConstants.BIGZERO);
        entry.setAdjustApply(BgConstants.BIGZERO);
        entry.setAdjustPass(BgConstants.BIGZERO);
        entry.setAdjustAfter(BgConstants.BIGZERO);
        entry.setAdjustType(BgAdjustTypeEnum.VALUEADD);
        return entry;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgRequestAdjustBillFactory.getRemoteInstance();
    }

    protected IBgRequestAdjustBill getInterface() throws Exception {
        return BgRequestAdjustBillFactory.getRemoteInstance();
    }

    public CoreBillBaseInfo getEditData() {
        return this.editData;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.getRPCData();
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        this.afterLoadFields();
        this.setButtAndMenuState();
    }

    private void setButtAndMenuState() {
        if (this.editData != null && this.editData.getState() != null) {
            int bgBillStateEnumValue = this.editData.getState().getValue();
            switch (bgBillStateEnumValue) {
                case 1: {
                    this.setAdjustButtAndMenu();
                    break;
                }
                case 3: {
                    this.setAllEnabledButtAndMenu();
                    break;
                }
                case 7: {
                    this.setAllEnabledButtAndMenu();
                    break;
                }
                case 9: {
                    this.setAllEnabledButtAndMenu();
                }
            }
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.hasCodeNumber) {
                this.txtNumber.setEditable(false);
            } else {
                this.txtNumber.setEnabled(true);
                this.txtNumber.setEditable(true);
            }
        }
    }

    protected void afterLoadFields() {
        if (this.getDetailTable() != null && this.getDetailTable().getBody().size() > 0) {
            IRow row = null;
            BgReqAdjustBillEntryInfo entry = null;
            int i = 0;
            int n = this.getDetailTable().getBody().size();
            BudgetRequestBillEntryCollection reqBillEntryCollection = null;
            HashMap<String, String> reqBillElementMap = new HashMap<String, String>();
            try {
                HashSet<BOSUuid> reqBillEntryIdSet = new HashSet<BOSUuid>();
                for (i = 0; i < n; ++i) {
                    row = this.getDetailTable().getRow(i);
                    entry = (BgReqAdjustBillEntryInfo)row.getUserObject();
                    if (entry == null) continue;
                    reqBillEntryIdSet.add(entry.getReqBillEntryId());
                }
                EntityViewInfo view = new EntityViewInfo();
                view.getSelector().add("id");
                view.getSelector().add("bgElement.name");
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", reqBillEntryIdSet, CompareType.INCLUDE));
                view.setFilter(filterInfo);
                reqBillEntryCollection = BudgetRequestBillEntryFactory.getRemoteInstance().getBudgetRequestBillEntryCollection(view);
                for (int j = 0; j < reqBillEntryCollection.size(); ++j) {
                    reqBillElementMap.put(reqBillEntryCollection.get(j).getId().toString(), reqBillEntryCollection.get(j).getBgElement().getName());
                }
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
            for (i = 0; i < n; ++i) {
                row = this.getDetailTable().getRow(i);
                entry = (BgReqAdjustBillEntryInfo)row.getUserObject();
                if (entry == null) continue;
                row.getCell(this.bgElementColIndex).setValue(reqBillElementMap.get(entry.getReqBillEntryId().toString()));
                int precision = entry.getCurrency().getPrecision();
                row.getCell("adjustBefore").setValue((Object)entry.getAdjustBefore().setScale(precision, 4));
                row.getCell("adjustApply").setValue((Object)entry.getAdjustApply().setScale(precision, 4));
                row.getCell("adjustPass").setValue((Object)entry.getAdjustPass().setScale(precision, 4));
                row.getCell("adjustAfter").setValue((Object)entry.getAdjustAfter().setScale(precision, 4));
            }
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (!this.hasCodeNumber && this.txtNumber.getText().trim().length() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCESTR, (String)"isCantNullOfNumber"));
            this.txtNumber.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtOrgUnit.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCESTR, (String)"isCantNullOfCenterOrgUnit"));
            this.prmtOrgUnit.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtBgScheme.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCESTR, (String)"isCantNullOfBgScheme"));
            this.prmtBgScheme.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtBgReqBill.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCESTR, (String)"isCantNullOfBgReqBill"));
            this.prmtBgReqBill.requestFocus();
            SysUtil.abort();
        }
    }

    protected void initTableKeyStroke(KDTable table, boolean isDownArrow) {
        super.initTableKeyStroke(table, isDownArrow);
        ActionMap actionMap = table.getActionMap();
        Action action = actionMap.get("SelectDownCell");
        if (action instanceof KDTCellSelectAction) {
            ((KDTCellSelectAction)action).setAddRow(false);
        }
        KDTableHelper.updateEnterWithTab((KDTable)table, (boolean)false, null);
    }

    protected KDTable getDetailTable() {
        return this.kdtEntry;
    }

    @Override
    public void actionDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteLine_actionPerformed(e);
        if (this.getDetailTable() != null) {
            this.removeLine(this.getDetailTable());
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        IBudgetRequestBill iBudgetRequestBill = BudgetRequestBillFactory.getRemoteInstance();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("state");
        BudgetRequestBillInfo requestBillInfo = iBudgetRequestBill.getBudgetRequestBillInfo((IObjectPK)new ObjectUuidPK(((BudgetRequestBillInfo)this.prmtBgReqBill.getData()).getId().toString()), sic);
        int state = -1;
        if (requestBillInfo.getState() != null && (state = requestBillInfo.getState().getValue()) != -1 && state != 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"checkBeforeDel"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.beforeSave();
        super.actionSave_actionPerformed(e);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.txtNumber.setEditable(false);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.hasCodeNumber) {
            this.txtNumber.setEditable(false);
        } else {
            this.txtNumber.setEnabled(true);
            this.txtNumber.setEditable(true);
        }
        super.actionAddNew_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.actionSave_actionPerformed(e);
        if (BgFormHelper.checkInProInst((String)this.editData.getId().toString())) {
            throw new BgRequestAdjustBillException(BgRequestAdjustBillException.SUBMITBILLINWORK);
        }
        int re = MsgBox.showConfirm2((String)EASResource.getString((String)RESOURCESTR, (String)"isSubmitReferWorking"));
        if (re == 2 || re == 1) {
            return;
        }
        if (this.getInterface().submitRefer(this.editData.getId())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCESTR, (String)"submitReferWoring"));
        }
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getInterface().antiAuditBill(this.editData.getId())) {
            this.editData.setState(BgRequestAdjustStateEnum.ADJUST);
            this.editData.setAuditor(null);
            this.editData.setBizDate(null);
            this.prmtAuditor.setData(null);
            this.btnAntiAudit.setEnabled(false);
            this.btnAudit.setEnabled(true);
            this.actionEdit_actionPerformed(e);
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.actionSave_actionPerformed(e);
        if (this.getInterface().auditBill(this.editData.getId())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCESTR, (String)"submitAuditOk"));
            this.getUIWindow().close();
        } else {
            this.getInterface().updateEditState(this.editData.getId());
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        String CUID = this.editData.getCU().getId().toString();
        boolean hasCodeRule = false;
        if (this.rpcDataMap.get("hasCodeRule") instanceof Boolean) {
            hasCodeRule = (Boolean)this.rpcDataMap.get("hasCodeRule");
        }
        if (hasCodeRule) {
            this.txtNumber.setEnabled(false);
            this.hasCodeNumber = true;
            if (this.hasCodeNumber) {
                this.hasCodeShowOfAddNew = BgHelper.hasDisplayNumber((CoreBaseInfo)this.editData, (String)CUID, null);
            }
        }
        int n = this.getDetailTable().getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.getDetailTable().getColumn(i).getStyleAttributes().setLocked(false);
        }
        if (this.getDetailTable() != null) {
            this.getDetailTable().getColumn(this.bgItemNameColIndex).getStyleAttributes().setLocked(true);
            this.getDetailTable().getColumn(this.adjustBeforeColIndex).getStyleAttributes().setLocked(true);
            this.getDetailTable().getColumn(this.adjustAfterColIndex).getStyleAttributes().setLocked(true);
        }
        this.setButtAndMenuState();
    }

    private void setAdjustButtAndMenu() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.actionAddLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(true);
            this.actionDeleteLine.setEnabled(true);
            this.btnRemoveLine.setEnabled(true);
            this.workbtnRemoveLine.setEnabled(true);
            this.actionEdit.setEnabled(false);
            this.actionSave.setEnabled(true);
            this.actionRemove.setEnabled(false);
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            this.actionAddLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(true);
            this.actionDeleteLine.setEnabled(true);
            this.btnRemoveLine.setEnabled(true);
            this.workbtnRemoveLine.setEnabled(true);
            this.actionEdit.setEnabled(false);
            this.actionSave.setEnabled(true);
            this.actionRemove.setEnabled(true);
        } else {
            this.actionAddLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
            this.actionDeleteLine.setEnabled(false);
            this.btnRemoveLine.setEnabled(false);
            this.workbtnRemoveLine.setEnabled(false);
            this.actionEdit.setEnabled(true);
            this.actionSave.setEnabled(false);
            this.actionRemove.setEnabled(true);
        }
        this.actionAddNew.setEnabled(true);
        this.actionAudit.setEnabled(true);
        this.btnAudit.setEnabled(true);
    }

    private void setAllEnabledButtAndMenu() {
        this.actionAddNew.setEnabled(true);
        this.actionEdit.setEnabled(false);
        this.actionSave.setEnabled(false);
        this.actionRemove.setEnabled(false);
        this.actionAddLine.setEnabled(false);
        this.actionInsertLine.setEnabled(false);
        this.actionRemoveLine.setEnabled(false);
        this.workbtnRemoveLine.setEnabled(false);
        this.btnRemoveLine.setEnabled(false);
        this.actionAudit.setEnabled(false);
        this.btnAudit.setEnabled(false);
    }

    protected void beforeSave() throws Exception {
        if (this.getDetailTable().getBody().size() <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCESTR, (String)"entryIsNull"));
            SysUtil.abort();
        }
        if (this.prmtBgReqBill.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCESTR, (String)"isCantNullOfBgReqBill"));
            this.prmtBgReqBill.requestFocus();
            SysUtil.abort();
        } else {
            int i;
            IBudgetRequestBill iBudgetRequestBill = BudgetRequestBillFactory.getRemoteInstance();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("bgEnties.applyValue");
            sic.add("bgEnties.id");
            BudgetRequestBillInfo requestBillInfo = iBudgetRequestBill.getBudgetRequestBillInfo((IObjectPK)new ObjectUuidPK(((BudgetRequestBillInfo)this.prmtBgReqBill.getData()).getId().toString()), sic);
            BudgetRequestBillEntryCollection requestBillEntryCol = requestBillInfo.getBgEnties();
            HashMap<String, BigDecimal> requestBillEntryMap = new HashMap<String, BigDecimal>();
            for (i = 0; i < requestBillEntryCol.size(); ++i) {
                BudgetRequestBillEntryInfo entryInfo = requestBillEntryCol.get(i);
                requestBillEntryMap.put(entryInfo.getId().toString(), entryInfo.getApplyValue());
            }
            for (i = 0; i < this.getDetailTable().getRowCount(); ++i) {
                IRow row = this.getDetailTable().getRow(i);
                int precision = ((CurrencyInfo)row.getCell(this.currencyColIndex).getValue()).getPrecision();
                if (requestBillEntryMap.get(row.getCell("reqBillEntryId").getValue().toString()) == null) continue;
                row.getCell(this.adjustBeforeColIndex).setValue((Object)((BigDecimal)requestBillEntryMap.get(row.getCell("reqBillEntryId").getValue().toString())).setScale(precision, 4));
                row.getCell(this.requestBillApplyColIndex).setValue((Object)((BigDecimal)requestBillEntryMap.get(row.getCell("reqBillEntryId").getValue().toString())).setScale(precision, 4));
                row.getCell(this.adjustAfterColIndex).setValue((Object)((BigDecimal)row.getCell(this.adjustBeforeColIndex).getValue()).add((BigDecimal)row.getCell(this.adjustPassColIndex).getValue()).setScale(precision, 4));
            }
        }
        this.checkBgAdjustBillApplyData();
    }

    protected void checkBgAdjustBillApplyData() throws Exception {
        IRow row = null;
        BigDecimal value = null;
        BigDecimal tempValue = null;
        int groupNo = 0;
        int rowCount = 0;
        Integer groupNum = null;
        String groupStr2 = null;
        HashMap<String, BigDecimal> valueMap = new HashMap<String, BigDecimal>();
        HashMap<String, Integer> groupMap = new HashMap<String, Integer>();
        rowCount = this.getDetailTable().getBody().size();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            row = this.getDetailTable().getRow(rowIndex);
            if (row == null) continue;
            if (row.getCell(this.bgItemNameColIndex).getValue() == null) {
                this.getDetailTable().removeRow(rowIndex);
                --rowIndex;
                --rowCount;
                continue;
            }
            if (row.getCell(this.adjustApplyColIndex).getValue() != null) {
                value = new BigDecimal(row.getCell(this.adjustApplyColIndex).getValue().toString());
                if (value.doubleValue() == 0.0) {
                    this.getDetailTable().getSelectManager().select(rowIndex, row.getCell(this.adjustApplyColIndex).getColumnIndex());
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCESTR, (String)"valueApplyIsCantZero"));
                    SysUtil.abort();
                }
                if (value.add(tempValue = new BigDecimal(row.getCell(this.adjustBeforeColIndex).getValue().toString())).doubleValue() < 0.0) {
                    this.getDetailTable().getSelectManager().select(rowIndex, row.getCell(this.adjustBeforeColIndex).getColumnIndex());
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCESTR, (String)"valueIsCanMin"));
                    SysUtil.abort();
                }
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCESTR, (String)"valueApplyIsCantNull"));
                SysUtil.abort();
            }
            if (row.getCell(this.adjustGroupColIndex).getValue() == null || row.getCell(this.adjustGroupColIndex).getValue().toString().trim().length() == 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCESTR, (String)"GroupNoIsCantNull"));
                SysUtil.abort();
            }
            if (row.getCell(this.adjustTypeColIndex).getValue() != null) {
                BgAdjustTypeEnum type = (BgAdjustTypeEnum)row.getCell(this.adjustTypeColIndex).getValue();
                groupNo = Integer.parseInt(row.getCell(this.adjustGroupColIndex).getValue().toString());
                if (type.getValue() == "2") {
                    if (groupNo <= 0) {
                        this.getDetailTable().getSelectManager().select(rowIndex, row.getCell(this.adjustGroupColIndex).getColumnIndex());
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCESTR, (String)"GroupNoIsMin"));
                        SysUtil.abort();
                    } else {
                        groupStr2 = String.valueOf(groupNo);
                        BigDecimal passValue = new BigDecimal(row.getCell(this.adjustPassColIndex).getValue().toString());
                        if (valueMap.containsKey(groupStr2)) {
                            tempValue = (BigDecimal)valueMap.get(groupStr2);
                            valueMap.put(groupStr2, tempValue.add(passValue));
                        } else {
                            valueMap.put(groupStr2, passValue);
                        }
                        if (groupMap.containsKey(groupStr2)) {
                            groupNum = (Integer)groupMap.get(groupStr2);
                            groupMap.put(groupStr2, new Integer(groupNum + 1));
                        } else {
                            groupMap.put(groupStr2, new Integer(1));
                        }
                    }
                } else if (type.getValue() == "1") {
                    if (groupNo != 0) {
                        this.getDetailTable().getSelectManager().select(rowIndex, row.getCell(this.adjustGroupColIndex).getColumnIndex());
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCESTR, (String)"GroupNoIsZero"));
                        SysUtil.abort();
                    }
                    if (value == null || value.compareTo(new BigDecimal(0)) < 0) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCESTR, (String)"addValueIsMin"));
                        SysUtil.abort();
                    }
                }
            }
            if (row.getCell(this.bgItemNameColIndex).getValue() == null) {
                this.getDetailTable().getSelectManager().select(rowIndex, row.getCell(this.bgItemNameColIndex).getColumnIndex());
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCESTR, (String)"isCantNullOfBgItem"));
                SysUtil.abort();
            }
            BigDecimal reqApplyValue = new BigDecimal(row.getCell(this.requestBillApplyColIndex).getValue().toString());
            Object applyObj = row.getCell(this.adjustApplyColIndex).getValue();
            if (applyObj == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCESTR, (String)"isCantNullOfAdjustApply"));
                SysUtil.abort();
            }
            BigDecimal adjustApplyValue = new BigDecimal(applyObj.toString());
            BOSUuid entryId = (BOSUuid)row.getCell("reqBillEntryId").getValue();
            BigDecimal useValue = new BigDecimal(0);
            useValue = this.getInterface().getBOTPValue(((BudgetRequestBillInfo)this.prmtBgReqBill.getData()).getId(), entryId);
            if (reqApplyValue.add(adjustApplyValue).compareTo(useValue) != -1) continue;
            String itemName = row.getCell(this.bgItemNameColIndex).getValue().toString();
            Object[] params = new Object[]{itemName, reqApplyValue, useValue, reqApplyValue.subtract(useValue)};
            throw new BgRequestAdjustBillException(BgRequestAdjustBillException.CANTREQADJUSTVALUE, params);
        }
        for (String groupStr2 : valueMap.keySet()) {
            value = (BigDecimal)valueMap.get(groupStr2);
            if (value.doubleValue() == 0.0) continue;
            throw new BgRequestAdjustBillException(BgRequestAdjustBillException.CHECKGROUPPASSVALUEISNOTZERO, new String[]{groupStr2});
        }
        for (String groupStr2 : groupMap.keySet()) {
            groupNum = (Integer)groupMap.get(groupStr2);
            if (groupNum > 1) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCESTR, (String)"GroupNoNumberIsMin"));
            SysUtil.abort();
        }
    }
}

