/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.client.ProgressPatchUI;
import com.kingdee.eas.ma.nbudget.BgNFFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgSchemeDispatchUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class BgSchemeDispatchUI
extends AbstractBgSchemeDispatchUI {
    private static final long serialVersionUID = -3736114016463395835L;
    private static final Logger logger = CoreUIObject.getLogger(BgSchemeDispatchUI.class);
    private String dispatchSchemeId = null;
    private Map dispatchInfo = null;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnTableSel.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnTableUnSel.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnOrgSel.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnOrgUnSel.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initData();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblTemplate.getSelectManager().select(0, 0);
    }

    protected void initData() {
        this.setDispatchInfo(new Hashtable());
        this.initBgTemplateInfo();
        this.initOrgUnitInfo();
    }

    protected void initBgTemplateInfo() {
        this.setDispatchSchemeId((String)this.getUIContext().get("BGSCHEME_ID"));
        if (!StringUtils.isEmpty((String)this.getDispatchSchemeId())) {
            IRow row = null;
            BgTemplateInfo templateInfo = null;
            this.tblTemplate.checkParsed();
            this.tblTemplate.getSelectManager().setSelectMode(2);
            BgTemplateCollection collection = null;
            try {
                collection = this.getBgSchemeInterface().getTemplateByScheme(this.getDispatchSchemeId());
                if (collection != null) {
                    int in = collection.size();
                    for (int i = 0; i < in; ++i) {
                        templateInfo = collection.get(i);
                        row = this.tblTemplate.addRow();
                        row.getCell(0).setValue((Object)Boolean.FALSE);
                        row.getCell(1).setValue((Object)templateInfo.getId().toString());
                        row.getCell(2).setValue((Object)templateInfo.getNumber());
                        row.getCell(3).setValue((Object)templateInfo.getName());
                        row.setUserObject((Object)templateInfo);
                    }
                }
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
    }

    protected void initOrgUnitInfo() {
        TreeModel treeModel = null;
        CostCenterOrgUnitInfo cco = null;
        DefaultKingdeeTreeNode root = null;
        this.orgTree.setShowCheckBox(true);
        try {
            String orgUnitId = (String)this.getUIContext().get("ORGUNIT_ID");
            if (StringUtils.isEmpty((String)orgUnitId)) {
                cco = SysContext.getSysContext().getCurrentCostUnit();
                orgUnitId = BgNFFacadeFactory.getRemoteInstance().firstCostCenterAndCU(cco.getId()).toString();
            }
            treeModel = BgNFSHelper.getOrgTreeModel(orgUnitId, this.orgTree);
            root = (DefaultKingdeeTreeNode)treeModel.getRoot();
            root.setCheckBoxVisible(false);
            this.orgTree.setModel(treeModel);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        for (int i = 0; i < this.orgTree.getRowCount(); ++i) {
            this.orgTree.expandRow(i);
        }
    }

    protected IBgScheme getBgSchemeInterface() throws Exception {
        return BgSchemeFactory.getRemoteInstance();
    }

    public void checkSelected() {
        if (this.tblTemplate.getRowCount() == 0 || this.tblTemplate.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    public String getDispatchSchemeId() {
        return this.dispatchSchemeId;
    }

    public void setDispatchSchemeId(String dispatchSchemeId) {
        this.dispatchSchemeId = dispatchSchemeId;
    }

    public Map getDispatchInfo() {
        return this.dispatchInfo;
    }

    public void setDispatchInfo(Map dispatchInfo) {
        this.dispatchInfo = dispatchInfo;
    }

    protected List queryBgTemplateIds() throws Exception {
        IRow row = null;
        ArrayList<Object> bgTemplateIds = new ArrayList<Object>();
        int in = this.tblTemplate.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.tblTemplate.getRow(i);
            bgTemplateIds.add(row.getCell(1).getValue());
        }
        return bgTemplateIds;
    }

    protected BgTemplateInfo getSelectedBgTemplateInfo() {
        this.checkSelected();
        BgTemplateInfo templateInfo = null;
        int rowIndex = this.tblTemplate.getSelectManager().getActiveRowIndex();
        IRow row = this.tblTemplate.getRow(rowIndex);
        if (row != null) {
            templateInfo = (BgTemplateInfo)row.getUserObject();
        }
        return templateInfo;
    }

    protected BgTemplateInfo getSelectedBgTemplateInfo(int rowIndex) {
        if (rowIndex < 0) {
            return null;
        }
        BgTemplateInfo templateInfo = null;
        IRow row = this.tblTemplate.getRow(rowIndex);
        if (row != null) {
            templateInfo = (BgTemplateInfo)row.getUserObject();
        }
        return templateInfo;
    }

    protected boolean checkSelectedTemplateInfo() {
        int rowIndex = this.tblTemplate.getSelectManager().getActiveRowIndex();
        IRow row = this.tblTemplate.getRow(rowIndex);
        Boolean re = (Boolean)row.getCell(0).getValue();
        return re;
    }

    protected boolean checkSelectedTemplateInfo(int rowIndex) {
        if (rowIndex >= 0) {
            IRow row = this.tblTemplate.getRow(rowIndex);
            Boolean re = (Boolean)row.getCell(0).getValue();
            return re;
        }
        return false;
    }

    protected boolean checkSelectedOrgUnitInfo() {
        DefaultKingdeeTreeNode _node = (DefaultKingdeeTreeNode)this.orgTree.getLastSelectedPathComponent();
        return _node != null && _node.isChecked();
    }

    protected FullOrgUnitInfo getSelectedOrgUnitInfo() {
        OrgStructureInfo oui;
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.orgTree.getLastSelectedPathComponent();
        if (node != null && (oui = (OrgStructureInfo)node.getUserObject()) != null && oui.getUnit() != null) {
            return oui.getUnit();
        }
        return null;
    }

    protected List queryOrgUnit() throws Exception {
        ArrayList orgUnitIds = new ArrayList();
        this.queryOrgUnit(orgUnitIds, (DefaultKingdeeTreeNode)this.orgTree.getModel().getRoot());
        return orgUnitIds;
    }

    protected void queryOrgUnit(List orgUnitIds, DefaultKingdeeTreeNode root) throws Exception {
        if (orgUnitIds == null || root == null) {
            return;
        }
        DefaultKingdeeTreeNode _node = null;
        OrgStructureInfo _osi = null;
        FullOrgUnitInfo unitInfo = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            _node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (_node != null && _node.isChecked()) {
                _osi = (OrgStructureInfo)_node.getUserObject();
                unitInfo = _osi.getUnit();
                orgUnitIds.add(unitInfo.getId().toString());
            }
            this.queryOrgUnit(orgUnitIds, _node);
        }
    }

    protected void setSelectedOrgUnit(boolean setSelected) throws Exception {
        this.setSelectedOrgUnit((DefaultKingdeeTreeNode)this.orgTree.getModel().getRoot(), setSelected);
    }

    protected void setSelectedOrgUnit(DefaultKingdeeTreeNode root, boolean setSelected) throws Exception {
        if (root == null) {
            return;
        }
        DefaultKingdeeTreeNode _node = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            _node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (_node != null) {
                if (setSelected) {
                    _node.setChecked(true);
                } else {
                    _node.setChecked(false);
                }
            }
            this.setSelectedOrgUnit(_node, setSelected);
        }
    }

    protected void setSelectedOrgUnit(Set orgUnitIds) throws Exception {
        this.setSelectedOrgUnit((DefaultKingdeeTreeNode)this.orgTree.getModel().getRoot(), orgUnitIds);
    }

    protected void setSelectedOrgUnit(DefaultKingdeeTreeNode root, Set orgUnitIds) throws Exception {
        if (root == null) {
            return;
        }
        DefaultKingdeeTreeNode _node = null;
        OrgStructureInfo _osi = null;
        FullOrgUnitInfo unitInfo = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            _node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (_node != null) {
                _osi = (OrgStructureInfo)_node.getUserObject();
                unitInfo = _osi.getUnit();
                if (orgUnitIds.contains(unitInfo.getId().toString())) {
                    _node.setChecked(true);
                } else {
                    _node.setChecked(false);
                }
            }
            this.setSelectedOrgUnit(_node, orgUnitIds);
        }
    }

    protected void saveSelectedInfo() throws Exception {
        BgTemplateInfo templateInfo = this.getSelectedBgTemplateInfo();
        if (templateInfo != null) {
            if (this.checkSelectedTemplateInfo()) {
                this.addTemplateInfo(templateInfo.getId().toString(), this.queryOrgUnit());
            } else {
                this.removeTemplateInfo(templateInfo.getId().toString());
            }
        }
    }

    protected void saveSelectedInfo(KDTSelectEvent e) throws Exception {
        BgTemplateInfo templateInfo;
        if (e != null && e.getPrevSelectBlock() != null && (templateInfo = this.getSelectedBgTemplateInfo(e.getPrevSelectBlock().getTop())) != null) {
            if (this.checkSelectedTemplateInfo(e.getPrevSelectBlock().getTop())) {
                this.addTemplateInfo(templateInfo.getId().toString(), this.queryOrgUnit());
            } else {
                this.removeTemplateInfo(templateInfo.getId().toString());
            }
        }
    }

    protected void loadSelectedInfo(KDTSelectEvent e) throws Exception {
        this.checkSelected();
        if (e != null && e.getSelectBlock() != null) {
            if (this.checkSelectedTemplateInfo(e.getSelectBlock().getTop())) {
                BgTemplateInfo templateInfo = this.getSelectedBgTemplateInfo(e.getSelectBlock().getTop());
                String _bgTemplateId = templateInfo.getId().toString();
                if (templateInfo != null && this.getDispatchInfo().containsKey(_bgTemplateId)) {
                    Set _tmpSet = (Set)this.getDispatchInfo().get(_bgTemplateId);
                    this.setSelectedOrgUnit(_tmpSet);
                } else {
                    this.setSelectedOrgUnit(false);
                }
            } else {
                this.setSelectedOrgUnit(false);
            }
            this.orgTree.repaint();
        }
    }

    protected void removeTemplateInfo(String bgTemplateId) {
        if (StringUtils.isEmpty((String)bgTemplateId)) {
            return;
        }
        Set _tmpSet = null;
        if (this.getDispatchInfo().containsKey(bgTemplateId)) {
            _tmpSet = (Set)this.getDispatchInfo().get(bgTemplateId);
        } else {
            _tmpSet = new HashSet();
            this.getDispatchInfo().put(bgTemplateId, _tmpSet);
        }
        _tmpSet.clear();
    }

    protected void addTemplateInfo(String bgTemplateId, List orgUnitIds) {
        if (StringUtils.isEmpty((String)bgTemplateId) || orgUnitIds == null) {
            return;
        }
        String _orgUnitId = null;
        Set<String> _tmpSet = null;
        if (this.getDispatchInfo().containsKey(bgTemplateId)) {
            _tmpSet = (Set)this.getDispatchInfo().get(bgTemplateId);
        } else {
            _tmpSet = new HashSet();
            this.getDispatchInfo().put(bgTemplateId, _tmpSet);
        }
        int in = orgUnitIds.size();
        for (int i = 0; i < in; ++i) {
            _orgUnitId = (String)orgUnitIds.get(i);
            _tmpSet.add(_orgUnitId);
        }
    }

    @Override
    protected void btnTableSel_actionPerformed(ActionEvent e) throws Exception {
        super.btnTableSel_actionPerformed(e);
        IRow row = null;
        int in = this.tblTemplate.getBody().size();
        for (int i = 0; i < in; ++i) {
            row = this.tblTemplate.getRow(i);
            if (row == null) continue;
            row.getCell(0).setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    protected void btnTableUnSel_actionPerformed(ActionEvent e) throws Exception {
        super.btnTableUnSel_actionPerformed(e);
        IRow row = null;
        this.getDispatchInfo().clear();
        int in = this.tblTemplate.getBody().size();
        for (int i = 0; i < in; ++i) {
            row = this.tblTemplate.getRow(i);
            if (row == null) continue;
            row.getCell(0).setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    protected void btnOrgSel_actionPerformed(ActionEvent e) throws Exception {
        super.btnOrgSel_actionPerformed(e);
        BgTemplateInfo templateInfo = this.getSelectedBgTemplateInfo();
        if (templateInfo != null) {
            this.addTemplateInfo(templateInfo.getId().toString(), this.queryOrgUnit());
            this.setSelectedOrgUnit(true);
            this.orgTree.repaint();
        }
    }

    @Override
    protected void btnOrgUnSel_actionPerformed(ActionEvent e) throws Exception {
        super.btnOrgUnSel_actionPerformed(e);
        BgTemplateInfo templateInfo = this.getSelectedBgTemplateInfo();
        if (templateInfo != null) {
            this.removeTemplateInfo(templateInfo.getId().toString());
            this.setSelectedOrgUnit(false);
            this.orgTree.repaint();
        }
    }

    @Override
    protected void tblTemplate_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblTemplate_tableSelectChanged(e);
        this.saveSelectedInfo(e);
        this.loadSelectedInfo(e);
    }

    @Override
    protected void tblTemplate_editValueChanged(KDTEditEvent e) throws Exception {
        BgTemplateInfo templateInfo;
        Boolean re;
        super.tblTemplate_editValueChanged(e);
        if (e.getColIndex() == 0 && e.getValue() instanceof Boolean && !(re = (Boolean)e.getValue()).booleanValue() && (templateInfo = this.getSelectedBgTemplateInfo()) != null) {
            this.removeTemplateInfo(templateInfo.getId().toString());
            this.setSelectedOrgUnit(false);
            this.orgTree.repaint();
        }
    }

    @Override
    protected void btnDispatch_actionPerformed(ActionEvent e) throws Exception {
        super.btnDispatch_actionPerformed(e);
        this.saveSelectedInfo();
        int re = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"98_BgSchemeDispatchUI"));
        if (re == 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"BGSCHEME_ID", (Object)this.getDispatchSchemeId());
            uiContext.put((Object)"DISPATCH_INFO", (Object)this.getDispatchInfo());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ProgressPatchUI.class.getName(), (Map)uiContext);
            uiWindow.show();
        }
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            BgNSHelper.objClear(this.getDispatchInfo());
        }
        return re;
    }
}

