/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgFillHelper;
import com.kingdee.eas.ma.budget.analysiscolumn.DataDealCenter;
import com.kingdee.eas.ma.budget.analysiscolumn.util.AnalysisColumnTool;
import com.kingdee.eas.ma.nbudget.BgAreaFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgSelfAnalyseOrgTypeEnum;
import com.kingdee.eas.ma.nbudget.BgSelfDefineAnalysisEnum;
import com.kingdee.eas.ma.nbudget.BgSelfDefineFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgSelfDefineObjInfo;
import com.kingdee.eas.ma.nbudget.IBgAreaFacade;
import com.kingdee.eas.ma.nbudget.IBgSelfDefineFacade;
import com.kingdee.eas.ma.nbudget.client.AbstractBgSelfAnalysisSubOrgViewUI;
import com.kingdee.eas.ma.nbudget.client.BgSelfDefineFormProcessUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgSelfAnalysisSubOrgViewUI
extends AbstractBgSelfAnalysisSubOrgViewUI {
    private Map cachedDataMap = new HashMap();
    private BgTreeRender render = new BgTreeRender();
    private static final long serialVersionUID = 6427221882622154599L;
    private static final Logger logger = CoreUIObject.getLogger(BgSelfAnalysisSubOrgViewUI.class);
    public static final String COST_ORG_ARY_MAP = "CostOrgAryMap";
    public static final String COST_ORG_ARY = "CostOrgAry";
    public static final String UPPER_COST_ORG_ARY = "UpperCostOrgAry";
    public static final String DATA_ARY = "DataAry";
    public static final String DATA_TYPE = "DataType";
    public static final String BG_FORM_PERIOD_ID = "BgFormPeriod";
    public static final String BG_FORM_TEMPLATE_ID = "BG_FORM_TEMPLATE_ID";

    public void onLoad() throws Exception {
        super.onLoad();
        this.inputValue();
        this.addOrgTree();
        this.addTableListener();
        this.initGroupType();
    }

    private void initGroupType() throws Exception {
        this.comGroupOrg.setEnabled(false);
        this.comGroupOrg.addItems(this.getAreaFacade().getOrgTreeInfo(null).toArray());
    }

    private void inputValue() throws BOSException {
        String[] strAry = (String[])this.getUIContext().get(DATA_ARY);
        String bgItem = strAry[0];
        String[] bgItemAry = BgFillHelper.parseStrFormulaToArray((String)bgItem);
        this.txtBgItemNumber.setText(bgItemAry[0]);
        String bgItemName = this.getBgSelfDefineFacade().getBgItemNameByNum(bgItemAry[0], this.getOrgUnitInfo().getId().toString());
        this.txtBgItemName.setText(bgItemName);
        this.txtBgElementName.setText(bgItemAry[2]);
        String dataType = this.getUIContext().get(DATA_TYPE).toString();
        if ("ActualData".equals(dataType)) {
            this.txtBgDataType.setText(BgSelfDefineAnalysisEnum.ActualData.getAlias());
        } else if ("BugdetData".equals(dataType)) {
            this.txtBgDataType.setText(BgSelfDefineAnalysisEnum.BugdetData.getAlias());
        } else if ("AdjustData".equals(dataType)) {
            this.txtBgDataType.setText(BgSelfDefineAnalysisEnum.AdjustData.getAlias());
        }
    }

    @Override
    public void actionViewSubForm_actionPerformed(ActionEvent e) throws Exception {
        int index = this.tblMain.getSelectManager().getActiveRowIndex();
        if (index != -1) {
            int bgFormIDIndex = this.tblMain.getColumnIndex("bgform.id");
            IRow row = this.tblMain.getRow(index);
            Object bgFormIDObj = row.getCell(bgFormIDIndex).getValue();
            if (bgFormIDObj != null) {
                String bgFormID = bgFormIDObj.toString();
                if (!"".equals(bgFormID)) {
                    NumberExpandInfo expandInfo = (NumberExpandInfo)row.getCell(0).getValue();
                    OrgUnitInfo costInfo = this.transformExpandInfoToCostCenterOrgInfo(expandInfo);
                    UIContext uiContext = new UIContext((Object)this);
                    uiContext.put((Object)"ID", (Object)bgFormID);
                    uiContext.put((Object)"CurrentOrgInfo", (Object)costInfo);
                    uiContext.put((Object)"DefaultOrgInfo", (Object)costInfo);
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgSelfDefineFormProcessUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
                    uiWindow.show();
                } else {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.NewAnalysisResource", (String)"Org_Without_Self_Define_Form"));
                }
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.NewAnalysisResource", (String)"Org_Without_Self_Define_Form"));
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.NewAnalysisResource", (String)"Please_ Select"));
        }
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    private void addTableListener() {
        this.tblMain.setEditable(false);
        this.tblMain.getSelectManager().setSelectMode(1);
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                NumberExpandInfo expandInfo;
                int rowIndex;
                IRow row;
                if (e.getColIndex() == 0 && e.getClickCount() == 1 && (row = BgSelfAnalysisSubOrgViewUI.this.tblMain.getRow(rowIndex = e.getRowIndex())).getCell(0).getValue() != null && row.getCell(0).getValue() instanceof NumberExpandInfo && (expandInfo = (NumberExpandInfo)row.getCell(0).getValue()) != null && BgSelfAnalysisSubOrgViewUI.this.render != null && BgSelfAnalysisSubOrgViewUI.this.render.inRect(expandInfo, e.getX(), e.getY())) {
                    BgSelfAnalysisSubOrgViewUI.this.setTreeDisplayStyle(row, expandInfo);
                }
            }
        });
    }

    protected void setTreeDisplayStyle(IRow row, NumberExpandInfo expandInfo) {
        this.tblMain.setRefresh(false);
        this.expandTable(row, expandInfo);
        this.tblMain.setRefresh(true);
        this.tblMain.reLayoutAndPaint();
    }

    private void expandTable(IRow row, NumberExpandInfo parentExpandInfo) {
        if (row == null || parentExpandInfo == null) {
            return;
        }
        IRow child = null;
        NumberExpandInfo expandInfo = null;
        String longnumber = null;
        String plongnumber = null;
        plongnumber = parentExpandInfo.getLongNumber();
        if (parentExpandInfo.isExpandStatus()) {
            parentExpandInfo.setExpandStatus(false);
            int rowCount = this.tblMain.getBody().size();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount; ++rowIndex) {
                child = this.tblMain.getRow(rowIndex);
                if (child.getCell(0).getValue() == null || !(child.getCell(0).getValue() instanceof NumberExpandInfo)) continue;
                expandInfo = (NumberExpandInfo)child.getCell(0).getValue();
                longnumber = expandInfo.getLongNumber();
                if (longnumber.startsWith(plongnumber + "!")) {
                    child.getStyleAttributes().setHided(true);
                    continue;
                }
                break;
            }
        } else {
            int rowIndex;
            parentExpandInfo.setExpandStatus(true);
            int rowCount = this.tblMain.getBody().size();
            if (rowIndex >= rowCount - 1) {
                this.addChildRowByOrgUnitParentInfo(this.tblMain, rowIndex, parentExpandInfo);
            } else {
                for (rowIndex = row.getRowIndex(); rowIndex < rowCount - 1; ++rowIndex) {
                    child = this.tblMain.getRow(rowIndex);
                    if (child.getCell(0).getValue() != null && child.getCell(0).getValue() instanceof NumberExpandInfo) {
                        expandInfo = (NumberExpandInfo)child.getCell(0).getValue();
                        longnumber = expandInfo.getLongNumber();
                        if (longnumber.startsWith(plongnumber + "!")) {
                            child.getStyleAttributes().setHided(false);
                            if (expandInfo.isLeaf()) continue;
                            expandInfo.setExpandStatus(false);
                            continue;
                        }
                        if (rowIndex != row.getRowIndex()) break;
                        this.addChildRowByOrgUnitParentInfo(this.tblMain, rowIndex, parentExpandInfo);
                        break;
                    }
                    if (rowIndex != row.getRowIndex()) continue;
                    this.addChildRowByOrgUnitParentInfo(this.tblMain, rowIndex, parentExpandInfo);
                }
            }
        }
    }

    private void addChildRowByOrgUnitParentInfo(KDTable table, int beginRow, NumberExpandInfo parentExpandInfo) {
        OrgUnitInfo[] array = this.getOrgUnitCol();
        Map map = this.getOrgAryMap(array);
        String[] strAry = (String[])this.getUIContext().get(DATA_ARY);
        String parentLN = parentExpandInfo.getLongNumber();
        Object obj = map.get(parentLN);
        if (obj == null) {
            return;
        }
        AnalysisColumnTool.SubNode subNode = (AnalysisColumnTool.SubNode)obj;
        List subNodeList = this.getSubNodeList(subNode.getSubNodeList(), array);
        int num = subNodeList.size();
        for (int i = 0; i < num; ++i) {
            OrgUnitInfo info = (OrgUnitInfo)subNodeList.get(i);
            this.fillCacheDataMap(info, strAry[2], strAry[0]);
            NumberExpandInfo expandInfo = this.copyOrgUnitInfoToExpendInfo(info, map);
            int rowIndex = beginRow + i + 1;
            IRow row = table.addRow(rowIndex);
            row.getCell(0).setValue((Object)expandInfo);
            this.fillDataToRow(row, info);
        }
    }

    private Map getOrgAryMap(OrgUnitInfo[] array) {
        Map map = new HashMap();
        map = this.combOrgType.getSelectedItem().equals((Object)BgSelfAnalyseOrgTypeEnum.costCenter) ? (Map)this.getUIContext().get(COST_ORG_ARY_MAP) : AnalysisColumnTool.dealWithOrgUnit((OrgUnitInfo[])array);
        return map;
    }

    private OrgUnitInfo[] getOrgUnitCol() {
        OrgUnitInfo[] orgUnitColl = null;
        try {
            if (this.combOrgType.getSelectedItem().equals((Object)BgSelfAnalyseOrgTypeEnum.costCenter)) {
                orgUnitColl = (OrgUnitInfo[])this.getUIContext().get(COST_ORG_ARY);
            } else {
                Object obj = this.comGroupOrg.getSelectedItem();
                IBgAreaFacade ibgAreaFacade = BgAreaFacadeFactory.getRemoteInstance();
                List unionList = ibgAreaFacade.getUnionCollection(((OrgTreeInfo)obj).getId());
                ArrayList<String> unionIdList = new ArrayList<String>();
                unionIdList.add(((OrgTreeInfo)obj).getId().toString());
                Map unionMap = ibgAreaFacade.getUnionInfo(unionIdList);
                orgUnitColl = new OrgUnitInfo[unionList.size()];
                int i = 0;
                Iterator ite = unionList.iterator();
                while (ite.hasNext()) {
                    orgUnitColl[i] = (OrgUnitInfo)ite.next();
                    String mapId = ((OrgTreeInfo)obj).getId().toString() + "_" + orgUnitColl[i].getId().toString();
                    if (unionMap.containsKey(mapId)) {
                        OrgUnitInfo orgInfo = (OrgUnitInfo)unionMap.get(mapId);
                        orgUnitColl[i].setId(orgInfo.getId());
                    } else {
                        orgUnitColl[i].setId(null);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            MsgBox.showInfo((String)("orgUnitCollerror!" + e.toString()));
        }
        return orgUnitColl;
    }

    private void fillDataToRow(IRow row, OrgUnitInfo costInfo) {
        BigDecimal coefficient = (BigDecimal)this.getUIContext().get("coefficient");
        String dataType = this.getUIContext().get(DATA_TYPE).toString();
        String bgTemplateID = this.getUIContext().get(BG_FORM_TEMPLATE_ID).toString();
        String bgPeriodID = this.getUIContext().get(BG_FORM_PERIOD_ID).toString();
        if (costInfo.getId() == null) {
            return;
        }
        String orgUnitID = costInfo.getId().toString();
        Object obj = this.cachedDataMap.get(orgUnitID);
        if (obj != null) {
            BgSelfDefineObjInfo info = (BgSelfDefineObjInfo)obj;
            BigDecimal val = new BigDecimal("0.00");
            if ("ActualData".equals(dataType)) {
                val = info.getActualVal();
            } else if ("BugdetData".equals(dataType)) {
                val = info.getBudgetVal();
            } else if ("AdjustData".equals(dataType)) {
                val = info.getPastVal();
            }
            int bgformIDIndex = this.tblMain.getColumnIndex("bgform.id");
            String bgFormID = "";
            try {
                bgFormID = this.getBgSelfDefineFacade().getAnalysisFormID(bgTemplateID, orgUnitID, bgPeriodID);
            }
            catch (BOSException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            row.getCell(bgformIDIndex).setValue((Object)bgFormID);
            int dataIndex = this.tblMain.getColumnIndex("data");
            row.getCell(dataIndex).setValue((Object)DataDealCenter.decFormat.format(val.divide(coefficient, 2, 6)));
        }
    }

    private void addOrgTree() {
        this.tblMain.checkParsed();
        IRow row = this.tblMain.addRow();
        IColumn column = this.tblMain.addColumn(0);
        column.setWidth(250);
        column.setRenderer((IBasicRender)this.render);
        OrgUnitInfo info = this.getOrgUnitInfo();
        if (info == null) {
            this.tblMain.removeRows();
            return;
        }
        String[] strAry = (String[])this.getUIContext().get(DATA_ARY);
        this.fillCacheDataMap(info, strAry[2], strAry[0]);
        this.fillDataToRow(row, info);
        this.addExpandInfo(this.tblMain.getCell(0, column.getColumnIndex()), info);
    }

    private OrgUnitInfo getOrgUnitInfo() {
        OrgUnitInfo orgUnitInfo = null;
        OrgStructureInfo structureInfo = null;
        try {
            String orgId = (String)this.getUIContext().get(UPPER_COST_ORG_ARY);
            if (orgId != null) {
                if (this.combOrgType.getSelectedItem().equals((Object)BgSelfAnalyseOrgTypeEnum.costCenter)) {
                    orgUnitInfo = CostCenterOrgUnitFactory.getRemoteInstance().getOrgUnitInfo("select id, name, number, longNumber, level where id = '" + orgId + "'");
                } else {
                    Object obj = this.comGroupOrg.getSelectedItem();
                    if (obj == null) {
                        return null;
                    }
                    String orgTreeId = ((OrgTreeInfo)obj).getId().toString();
                    if ((orgId = this.getJCArea(orgId, orgTreeId)) == null) {
                        throw new ObjectNotFoundException();
                    }
                    structureInfo = OrgStructureFactory.getRemoteInstance().getOrgStructureInfo("select unit.id, unit.name, unit.number, longNumber  where unit.id = '" + orgId + "' and tree.id = '" + orgTreeId + "'");
                    orgUnitInfo = new OrgUnitInfo();
                    orgUnitInfo.setId(BOSUuid.read((String)((String)this.getUIContext().get(UPPER_COST_ORG_ARY))));
                    orgUnitInfo.setName(structureInfo.getUnit().getName());
                    orgUnitInfo.setNumber(structureInfo.getUnit().getNumber());
                    orgUnitInfo.setLongNumber(structureInfo.getLongNumber());
                }
            }
        }
        catch (Exception e) {
            if (e instanceof ObjectNotFoundException) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"99_BgSelfAnalysisSubOrgViewUI"));
                return null;
            }
            MsgBox.showInfo((String)("orgUniterror!" + e.toString()));
        }
        return orgUnitInfo;
    }

    private String getJCArea(String orgId, String orgTreeId) throws Exception {
        String id = this.getAreaFacade().getUnionId(orgTreeId, orgId);
        return id;
    }

    private void fillCacheDataMap(OrgUnitInfo costOrgInfo, String bgSchemeNum, String bgItem) {
        if (costOrgInfo.getId() == null) {
            return;
        }
        String orgUnitID = costOrgInfo.getId().toString();
        ArrayList orgUnitIDList = new ArrayList(this.cachedDataMap.keySet());
        if (!orgUnitIDList.contains(orgUnitID)) {
            Map map = null;
            try {
                map = this.getBgSelfDefineFacade().getValueByFormula(orgUnitID, bgSchemeNum, bgItem);
            }
            catch (BOSException ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
            }
            this.cachedDataMap.putAll(map);
        }
    }

    private IBgSelfDefineFacade getBgSelfDefineFacade() throws BOSException {
        return BgSelfDefineFacadeFactory.getRemoteInstance();
    }

    private void addExpandInfo(ICell cell, OrgUnitInfo orgUnitInfo) {
        if (cell == null) {
            return;
        }
        NumberExpandInfo expandInfo = new NumberExpandInfo();
        if (orgUnitInfo.getId() != null) {
            expandInfo.setId(orgUnitInfo.getId().toString());
        } else {
            expandInfo.setId("123");
        }
        expandInfo.setName(orgUnitInfo.getName());
        expandInfo.setNumber(orgUnitInfo.getNumber());
        expandInfo.setLongNumber(orgUnitInfo.getLongNumber());
        expandInfo.setLevel(0);
        expandInfo.setExpandStatus(false);
        expandInfo.setLeaf(false);
        cell.setValue((Object)expandInfo);
    }

    private List getSubNodeList(List subNodeLNList, OrgUnitInfo[] ary) {
        ArrayList<OrgUnitInfo> subNodeList = new ArrayList<OrgUnitInfo>();
        for (OrgUnitInfo tempInfo : ary) {
            String tempLN = tempInfo.getLongNumber();
            if (!subNodeLNList.contains(tempLN)) continue;
            subNodeList.add(tempInfo);
        }
        return subNodeList;
    }

    private NumberExpandInfo copyOrgUnitInfoToExpendInfo(OrgUnitInfo orgUnitInfo, Map map) {
        NumberExpandInfo expandInfo = new NumberExpandInfo();
        if (orgUnitInfo.getId() != null) {
            expandInfo.setId(orgUnitInfo.getId().toString());
        } else {
            expandInfo.setId("123");
        }
        expandInfo.setName(orgUnitInfo.getName());
        expandInfo.setNumber(orgUnitInfo.getNumber());
        expandInfo.setLevel(orgUnitInfo.getLevel());
        String longNumber = orgUnitInfo.getLongNumber();
        expandInfo.setLongNumber(longNumber);
        if (map.get(longNumber) != null) {
            expandInfo.setLeaf(false);
        } else {
            expandInfo.setLeaf(true);
        }
        return expandInfo;
    }

    private OrgUnitInfo transformExpandInfoToCostCenterOrgInfo(NumberExpandInfo expandInfo) {
        OrgUnitInfo info = new OrgUnitInfo();
        info.setId(BOSUuid.read((String)expandInfo.getId()));
        info.setName(expandInfo.getName());
        info.setNumber(expandInfo.getNumber());
        info.setLevel(expandInfo.getLevel());
        String longNumber = expandInfo.getLongNumber();
        info.setLongNumber(longNumber);
        return info;
    }

    public boolean destroyWindow() {
        this.cachedDataMap.clear();
        return super.destroyWindow();
    }

    @Override
    protected void combOrgType_actionPerformed(ActionEvent e) throws Exception {
        if (this.combOrgType.getSelectedItem().equals((Object)BgSelfAnalyseOrgTypeEnum.costCenter)) {
            this.comGroupOrg.setEnabled(false);
            this.comGroupOrg.setEditable(false);
        } else {
            this.comGroupOrg.setEnabled(true);
            this.comGroupOrg.setEditable(false);
        }
        this.inputDataAgain();
    }

    @Override
    protected void comGroupOrg_itemStateChanged(ItemEvent e) throws Exception {
    }

    @Override
    protected void comGroupOrg_actionPerformed(ActionEvent e) throws Exception {
        if (this.comGroupOrg.isEnabled()) {
            this.inputDataAgain();
        }
    }

    private void inputDataAgain() {
        this.tblMain.removeRows();
        this.tblMain.removeColumn(0);
        this.addOrgTree();
    }

    private IBgAreaFacade getAreaFacade() throws Exception {
        return BgAreaFacadeFactory.getRemoteInstance();
    }

    private class BgTreeRender
    implements IBasicRender {
        private int TABSIZE = 8;
        private int ICONSIZE = 10;
        private int margin = 2;
        protected SimpleTextRender simpleRender = new SimpleTextRender();
        protected HashMap acctIdToPos = new HashMap();

        private BgTreeRender() {
        }

        protected void drawExpanded(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
        }

        protected void drawCollapsed(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
            g.drawLine(x + this.ICONSIZE / 2, y + this.margin, x + this.ICONSIZE / 2, y + this.margin + lineSize);
        }

        protected void drawLeaf(Graphics g, int x, int y) {
            int lineSize = this.ICONSIZE - 2 * this.margin;
        }

        public boolean inRect(NumberExpandInfo numberExpandInfo, int x, int y) {
            String acctId = numberExpandInfo.getNumber();
            Rectangle rec = (Rectangle)this.acctIdToPos.get(acctId);
            if (rec != null) {
                return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
            }
            return false;
        }

        public void draw(Graphics graphics, Shape clip, Object obj, Style style) {
            if (obj instanceof NumberExpandInfo) {
                NumberExpandInfo numberExpandInfo = (NumberExpandInfo)obj;
                int ident = numberExpandInfo.getLevel() * this.TABSIZE;
                Rectangle rect = clip.getBounds();
                int x = rect.x + ident;
                int y = rect.y + (rect.height - this.ICONSIZE) / 2;
                Rectangle iconRect = new Rectangle(x, y, this.ICONSIZE, this.ICONSIZE);
                this.acctIdToPos.put(numberExpandInfo.getNumber(), iconRect);
                this.simpleRender.draw(graphics, (Shape)new Rectangle(x + this.ICONSIZE + this.TABSIZE, rect.y, rect.width - x - this.ICONSIZE - this.TABSIZE, rect.height), numberExpandInfo.getName(), style);
                this.paintIcon(graphics, numberExpandInfo, iconRect);
            } else if (obj != null) {
                this.simpleRender.draw(graphics, clip, obj.toString(), style);
            }
        }

        private void paintIcon(Graphics graphics, NumberExpandInfo numberExpandInfo, Rectangle iconRect) {
            if (numberExpandInfo.isLeaf()) {
                this.drawLeaf(graphics, iconRect.x, iconRect.y);
            } else if (numberExpandInfo.isExpandStatus()) {
                this.drawExpanded(graphics, iconRect.x, iconRect.y);
            } else if (!numberExpandInfo.isExpandStatus()) {
                this.drawCollapsed(graphics, iconRect.x, iconRect.y);
            }
        }
    }

    private class NumberExpandInfo {
        private String id = null;
        private String number = null;
        private String name = null;
        private String longNumber = null;
        private boolean isExpandStatus = false;
        private int level = 0;
        private boolean isLeaf = false;
        private boolean isEffective = true;

        private NumberExpandInfo() {
        }

        public boolean isExpandStatus() {
            return this.isExpandStatus;
        }

        public void setExpandStatus(boolean isExpandStatus) {
            this.isExpandStatus = isExpandStatus;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getLongNumber() {
            return this.longNumber;
        }

        public void setLongNumber(String longNumber) {
            this.longNumber = longNumber;
        }

        public String toString() {
            return this.name;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public void setLeaf(boolean isLeaf) {
            this.isLeaf = isLeaf;
        }

        public boolean isEffective() {
            return this.isEffective;
        }

        public void setEffective(boolean isEffective) {
            this.isEffective = isEffective;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

