/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.ma.budget.BgAnalyseFacadeFactory;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.IBgAnalyseFacade;
import com.kingdee.eas.ma.budget.client.BgCostCenterOrgViewF7;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.nbudget.BgItemSimForecastParam;
import com.kingdee.eas.ma.nbudget.BgPredictDataSourceTypeEnum;
import com.kingdee.eas.ma.nbudget.BgPredictExpressionCollection;
import com.kingdee.eas.ma.nbudget.BgPredictExpressionFactory;
import com.kingdee.eas.ma.nbudget.BgPredictExpressionInfo;
import com.kingdee.eas.ma.nbudget.BgSimforecastFilterParam;
import com.kingdee.eas.ma.nbudget.IBgPredictExpression;
import com.kingdee.eas.ma.nbudget.client.AbstractBgSimForecastFilterUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgSchemeFilterUI;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgSimForecastFilterUI
extends AbstractBgSimForecastFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BgSimForecastFilterUI.class);
    private OrgUnitInfo defOrgUnitInfo = null;
    Map map = new HashMap();
    private OrgUnitInfo currOrgUnit = SysContext.getSysContext().getCurrentOrgUnit();
    private CtrlUnitInfo currCU = SysContext.getSysContext().getCurrentCtrlUnit();
    private CurrencyInfo currencyInfo = null;
    private BgSimforecastFilterParam simFilterParam;
    boolean isBGNFormProcess = true;
    boolean isCustomerParams = false;
    FilterItemInfo filterItemInfo = null;
    CommonQueryDialog cqDialog = null;
    private final String NEW_SCHEME_KEY = "NEW_SCHEME_KEY";
    protected Object ui = null;

    public BgSimForecastFilterUI() throws Exception {
    }

    public BgSimForecastFilterUI(Object ui) throws Exception {
        this.ui = ui;
    }

    public boolean setCqDialog(CommonQueryDialog cqDialog) {
        if (cqDialog != null) {
            this.cqDialog = cqDialog;
            return true;
        }
        return false;
    }

    public void setBGNFormProcess(boolean isBGNFormProcess) {
        this.isBGNFormProcess = isBGNFormProcess;
    }

    public BgSimForecastFilterUI(Object ui, Object orgUnitInfo, Map map) throws Exception {
        this.ui = ui;
        this.map = map;
        if (map.get("OrgUnit") != null) {
            this.setBGNFormProcess(true);
        } else if (map.get("CurOrgUnit") != null) {
            this.setBGNFormProcess(false);
        }
        this.defOrgUnitInfo = orgUnitInfo != null && orgUnitInfo instanceof OrgUnitInfo ? (OrgUnitInfo)orgUnitInfo : SysContext.getSysContext().getCurrentCostUnit();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public String getUITitle() {
        return BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.SimForecastFilterResource", "simForecastFilterTitle");
    }

    protected FilterParam createNewFilterParam() {
        return new BgItemSimForecastParam();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initFilter();
    }

    protected boolean hasNewScheme() {
        return false;
    }

    public BgSimForecastFilterUI getDataSimFilter() {
        return this;
    }

    public OrgUnitInfo[] getOrgUnitInfo() {
        Object obj = this.prmtOrgUnit.getData();
        OrgUnitInfo[] orgUnits = null;
        if (obj instanceof OrgUnitInfo[]) {
            orgUnits = (OrgUnitInfo[])obj;
        } else if (obj instanceof OrgUnitInfo) {
            orgUnits = new OrgUnitInfo[]{(OrgUnitInfo)obj};
        }
        return orgUnits;
    }

    public BgTemplateInfo[] getTemplate() {
        Object[] obj2 = null;
        Object obj = this.prmtTemplate.getData();
        BgTemplateInfo[] templates = null;
        if (obj instanceof Object[]) {
            obj2 = (Object[])obj;
            templates = new BgTemplateInfo[obj2.length];
            for (int i = 0; i < obj2.length; ++i) {
                templates[i] = (BgTemplateInfo)obj2[i];
            }
        } else if (obj instanceof Object) {
            templates = new BgTemplateInfo[]{(BgTemplateInfo)obj};
        }
        return templates;
    }

    public int getHistoryDataType() {
        return this.comHistoryDataType.getSelectedIndex();
    }

    protected void initFilter() throws Exception {
        this.initOrgUnit();
        this.initMeans();
        this.initCurrency();
        this.initSuceme();
        this.initTemplate();
        this.initBgPeriod();
        this.initHistoryDataType();
        this.initCheckBox();
    }

    private void initMeans() throws BOSException {
        this.comMeans.removeAllItems();
        IBgPredictExpression predict = BgPredictExpressionFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        SorterItemCollection sort = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("name");
        sort.add(sortInfo);
        evi.setSorter(sort);
        BgPredictExpressionCollection predictCollection = predict.getBgPredictExpressionCollection(evi);
        this.comMeans.addItems(predictCollection.toArray());
        this.comMeans.setSelectedIndex(0);
    }

    private void initCheckBox() {
        if (this.map.get("periodType") != null) {
            RptPeriodTypeEnum type = (RptPeriodTypeEnum)this.map.get("periodType");
            switch (type.getValue()) {
                case 6: {
                    this.kDCheckBoxYear.setSelected(true);
                    this.kDCheckBoxYear2.setSelected(true);
                    break;
                }
                case 5: {
                    this.kDCheckBoxHalfYear.setSelected(true);
                    this.kDCheckBoxHalfYear2.setSelected(true);
                    break;
                }
                case 4: {
                    this.kDCheckBoxSeason.setSelected(true);
                    this.kDCheckBoxSeason2.setSelected(true);
                    break;
                }
                case 3: {
                    this.kDCheckBoxMonth.setSelected(true);
                    this.kDCheckBoxMonth2.setSelected(true);
                    break;
                }
            }
            this.kDCheckBoxYear2.setEnabled(false);
            this.kDCheckBoxHalfYear2.setEnabled(false);
            this.kDCheckBoxSeason2.setEnabled(false);
            this.kDCheckBoxMonth2.setEnabled(false);
        }
    }

    private void initTemplate() {
        if (this.map.get("Template") != null) {
            this.prmtTemplate.setData(this.map.get("Template"));
            this.prmtTemplate.setEnabled(false);
            this.prmtTemplate.setReadOnly(true);
            this.prmtTemplate.setDisplay(true);
            this.prmtTemplate.setRequired(false);
        }
        this.prmtTemplate.setEditable(false);
    }

    private void initSuceme() {
        if (this.map.get("Scheme") != null) {
            this.prmtSchemeNew.setData(this.map.get("Scheme"));
            this.prmtSchemeNew.setEnabled(false);
            this.prmtSchemeNew.setReadOnly(true);
            this.prmtSchemeNew.setDisplay(true);
            this.prmtSchemeNew.setRequired(false);
        }
        this.prmtSchemeNew.setEditable(false);
    }

    private void initHistoryDataType() {
        this.comHistoryDataType.removeAllItems();
        this.comHistoryDataType.addItems(BgPredictDataSourceTypeEnum.getEnumList().toArray());
        this.comHistoryDataType.setSelectedIndex(0);
    }

    private void initCurrency() {
        CurrencyInfo currencyInfo = null;
        OrgUnitInfo unitInfo = this.getCurrOrgUnit();
        BgNFCHelper.setCurrency(this.comCurrency, null, false);
        if (unitInfo != null) {
            currencyInfo = BgNFCHelper.getBaseCurrency(unitInfo.getId());
            BgNFCHelper.setSelectObject(this.comCurrency, currencyInfo);
            this.setCurrencyInfo(currencyInfo);
        }
        if (this.ui != null) {
            Method method = null;
            try {
                BgSimforecastFilterParam filterParam;
                method = this.ui.getClass().getMethod("getFilterParam", null);
                if (method != null && (filterParam = (BgSimforecastFilterParam)method.invoke(this.ui, null)) != null) {
                    BgNFCHelper.setSelectObject(this.comCurrency, filterParam.getCurrencyId());
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
        if (this.map.get("Currency") != null) {
            this.comCurrency.setEnabled(false);
        }
    }

    public OrgUnitInfo getCurrOrgUnit() {
        return this.currOrgUnit;
    }

    public void setCurrencyInfo(CurrencyInfo currencyInfo) {
        this.currencyInfo = currencyInfo;
    }

    private void initOrgUnit() {
        HashSet<String> checkedOrgIds = new HashSet<String>();
        if (this.map.get("OrgUnit") != null) {
            checkedOrgIds.add(((OrgUnitInfo)this.map.get("OrgUnit")).getId().toString());
        } else if (this.map.get("CurOrgUnit") != null) {
            checkedOrgIds.add(((OrgUnitInfo)this.map.get("CurOrgUnit")).getId().toString());
        } else {
            checkedOrgIds.add((String)this.currOrgUnit.getId());
        }
        BgCostCenterOrgViewF7 orgView = new BgCostCenterOrgViewF7((IUIObject)this);
        orgView.setTitle(BgAnalyseHelper.getMessage((String)"orgUnitTitle"));
        orgView.setCheckedOrgIDs(checkedOrgIds);
        if (this.map.get("CurOrgUnit") != null) {
            orgView.setCuID(((FullOrgUnitInfo)this.map.get("CurOrgUnit")).getId().toString());
        }
        if (this.map.get("OrgUnit") != null) {
            orgView.setCuID(this.getCurrOrgUnit().getId().toString());
        }
        orgView.setMultiSelect(this.isMultiSelect());
        orgView.setReturnSuperior(false);
        if (this.ui != null) {
            orgView.setUIActionPK((IMetaDataPK)new MetaDataPK(this.ui.getClass().getName()), (IMetaDataPK)new MetaDataPK("ActionOnLoad"));
        }
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgView);
        if (this.ui != null) {
            Method method = null;
            try {
                BgSimforecastFilterParam filterParam;
                method = this.ui.getClass().getMethod("getFilterParam", null);
                if (method != null && (filterParam = (BgSimforecastFilterParam)method.invoke(this.ui, null)) != null) {
                    this.prmtOrgUnit.setData((Object)filterParam.getOrgUnits());
                    return;
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
        if (this.map.get("OrgUnit") != null) {
            this.prmtOrgUnit.setData(this.map.get("OrgUnit"));
            this.prmtOrgUnit.setEnabled(false);
            this.prmtOrgUnit.setReadOnly(true);
            this.prmtOrgUnit.setDisplay(true);
            this.prmtOrgUnit.setRequired(false);
        } else if (this.map.get("CurOrgUnit") != null) {
            this.prmtOrgUnit.setData(this.map.get("CurOrgUnit"));
            this.prmtOrgUnit.setVisible(true);
        } else {
            this.prmtOrgUnit.setData((Object)this.currOrgUnit);
        }
        this.prmtOrgUnit.setEditable(false);
    }

    protected boolean isMultiSelect() {
        return true;
    }

    protected boolean isReturnSuperior() {
        return true;
    }

    protected void initBgPeriod() throws Exception {
        BgPeriodDialog bgPeriodDialog = new BgPeriodDialog((CoreUIObject)this);
        this.prmtBgPeriodBegin.setSelector((KDPromptSelector)bgPeriodDialog);
        this.prmtBgPeriodEnd.setSelector((KDPromptSelector)bgPeriodDialog);
        this.prmtBgPeriodBegin.setEditable(false);
        this.prmtBgPeriodEnd.setEditable(false);
        if (this.map.get("Period") != null) {
            BgPeriodInfo period = new BgPeriodInfo();
            period = (BgPeriodInfo)this.map.get("Period");
            this.prmtBgPeriodBegin.setData((Object)period);
            this.prmtBgPeriodEnd.setData((Object)period);
        }
    }

    public void clear() {
        super.clear();
        if (this.comHistoryDataType.getItemCount() > 0) {
            this.comHistoryDataType.setSelectedIndex(0);
        }
        if (this.comMeans.getItemCount() > 0) {
            this.comMeans.setSelectedIndex(0);
        }
        if (this.map.get("CurOrgUnit") != null) {
            this.kDCheckBoxYear.setSelected(false);
            this.kDCheckBoxHalfYear.setSelected(false);
            this.kDCheckBoxSeason.setSelected(false);
            this.kDCheckBoxMonth.setSelected(false);
            this.prmtBgPeriodBegin.setData(null);
            this.prmtBgPeriodEnd.setData(null);
            this.prmtSchemeNew.setData(null);
            this.prmtTemplate.setData(null);
            this.kDCheckBoxYear2.setSelected(false);
            this.kDCheckBoxHalfYear2.setSelected(false);
            this.kDCheckBoxSeason2.setSelected(false);
            this.kDCheckBoxMonth2.setSelected(false);
            try {
                this.initFilter();
            }
            catch (Exception e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        }
    }

    public void restart(OrgUnitInfo orgUnitInfo) throws Exception {
        this.clear();
    }

    public boolean verify() {
        boolean re = super.verify();
        if (re) {
            if (this.comMeans.getSelectedItem() == null) {
                this.comMeans.requestFocus();
                MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.SimForecastFilterResource", "noMeans"));
                return false;
            }
            if (this.comHistoryDataType.getSelectedItem() == null) {
                this.comHistoryDataType.requestFocus();
                MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.SimForecastFilterResource", "noHistoryDataType"));
                return false;
            }
            Object obj = this.prmtOrgUnit.getData();
            if (obj == null || obj instanceof String) {
                this.prmtOrgUnit.requestFocus();
                MsgBox.showWarning((String)BgAnalyseHelper.getMessage((String)"selectOrgUnit"));
                return false;
            }
            Object obj1 = this.prmtSchemeNew.getData();
            if (obj1 == null || obj1 instanceof String) {
                this.prmtSchemeNew.requestFocus();
                MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.SimForecastFilterResource", "noScheme"));
                return false;
            }
            Object obj2 = this.prmtTemplate.getData();
            if (obj2 == null || obj2 instanceof String) {
                this.prmtTemplate.requestFocus();
                MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.SimForecastFilterResource", "noTemplate"));
                return false;
            }
            if (this.comCurrency.getSelectedItem() == null) {
                this.comCurrency.requestFocus();
                MsgBox.showWarning((String)BgAnalyseHelper.getMessage((String)"selectCurrency"));
                return false;
            }
            if (this.prmtBgPeriodBegin.getData() == null || this.prmtBgPeriodEnd.getData() == null) {
                this.prmtBgPeriodBegin.requestFocus();
                MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.SimForecastFilterResource", "noPeriod"));
                return false;
            }
            if (!this.getPeriodTypeRequired()) {
                MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.SimForecastFilterResource", "noPeriodType"));
                return false;
            }
            if (this.prmtBgPeriodBegin.getData() instanceof BgPeriodInfo && this.prmtBgPeriodEnd.getData() instanceof BgPeriodInfo) {
                BgPeriodInfo begin = (BgPeriodInfo)this.prmtBgPeriodBegin.getData();
                BgPeriodInfo end = (BgPeriodInfo)this.prmtBgPeriodEnd.getData();
                if (!begin.getPeriodType().equals((Object)end.getPeriodType())) {
                    this.prmtBgPeriodBegin.requestFocus();
                    MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.SimForecastFilterResource", "periodError"));
                    return false;
                }
                if (end.getBeginDate().compareTo(begin.getBeginDate()) == -1) {
                    this.prmtBgPeriodBegin.requestFocus();
                    MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.SimForecastFilterResource", "periodError2"));
                    return false;
                }
                if (!this.getPeriodTypeAndBound()) {
                    this.prmtBgPeriodBegin.requestFocus();
                    MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.SimForecastFilterResource", "periodTypeAndBound"));
                    return false;
                }
            }
            if (!this.getFormPeriodTypeRequired()) {
                MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.SimForecastFilterResource", "formPeriodType"));
                return false;
            }
        }
        return re;
    }

    public boolean[] getPeriodType() {
        boolean[] periodType = new boolean[]{this.kDCheckBoxYear.getSelected() == 32, this.kDCheckBoxHalfYear.getSelected() == 32, this.kDCheckBoxSeason.getSelected() == 32, this.kDCheckBoxMonth.getSelected() == 32};
        return periodType;
    }

    public boolean[] getFormPeriodType() {
        boolean[] periodType = new boolean[]{this.kDCheckBoxYear2.getSelected() == 32, this.kDCheckBoxHalfYear2.getSelected() == 32, this.kDCheckBoxSeason2.getSelected() == 32, this.kDCheckBoxMonth2.getSelected() == 32};
        return periodType;
    }

    public boolean getPeriodTypeRequired() {
        boolean[] periodType = this.getPeriodType();
        for (int i = 0; i < 4; ++i) {
            if (!periodType[i]) continue;
            return true;
        }
        return false;
    }

    public boolean getFormPeriodTypeRequired() {
        boolean[] periodType = this.getFormPeriodType();
        for (int i = 0; i < 4; ++i) {
            if (!periodType[i]) continue;
            return true;
        }
        return false;
    }

    public boolean getPeriodTypeAndBound() {
        BgPeriodInfo periodbegin = (BgPeriodInfo)this.prmtBgPeriodBegin.getData();
        BgPeriodInfo periodend = (BgPeriodInfo)this.prmtBgPeriodEnd.getData();
        Date beginDate = periodbegin.getBeginDate();
        Date endDate = periodend.getEndDate();
        boolean[] periodType = this.getPeriodType();
        int months = endDate.getMonth() - beginDate.getMonth() + 1;
        if (months < 3 && (periodType[0] || periodType[1] || periodType[2])) {
            return false;
        }
        if (months < 6 && (periodType[0] || periodType[1])) {
            return false;
        }
        return months >= 12 || !periodType[0];
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.prmtOrgUnit.isReadOnly()) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            OrgUnitInfo _currOrgUnit = SysContext.getSysContext().getCurrentOrgUnit();
            evi.setFilter(filterInfo);
            Set subOrgUnits = new HashSet();
            Set checkOrgIds = new HashSet();
            subOrgUnits = this.getOrgUnitsToBosID();
            BgSchemeCollection bgSchemeCol = null;
            BOSUuid[] orgids = this.getOrgUnitIds();
            if (subOrgUnits != null) {
                int i;
                HashSet<String> schemes = new HashSet<String>();
                for (i = 0; i < orgids.length; ++i) {
                    if (_currOrgUnit.getId().toString().equals(orgids[0].toString())) continue;
                    _currOrgUnit.setId(orgids[0]);
                }
                bgSchemeCol = this.getBgSchemeInfo(this.currOrgUnit.getId(), subOrgUnits);
                for (i = 0; i < bgSchemeCol.size(); ++i) {
                    schemes.add(bgSchemeCol.get(i).getId().toString());
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("id", schemes, CompareType.INCLUDE));
            }
            checkOrgIds = this.getOrgUnitsToBosIDForString();
            BgCostCenterOrgViewF7 orgView = (BgCostCenterOrgViewF7)this.prmtOrgUnit.getSelector();
            orgView.setCheckedOrgIDs(checkOrgIds);
            this.prmtOrgUnit.setSelector((KDPromptSelector)orgView);
            this.prmtSchemeNew.setData(null);
            this.prmtSchemeNew.setEntityViewInfo(evi);
            this.setTemplateFilter();
            if (this.cqDialog != null) {
                BgSchemeFilterUI schemePanel = (BgSchemeFilterUI)this.cqDialog.getUserPanel(1);
                schemePanel.initFilter(evi);
            }
        }
        super.prmtOrgUnit_dataChanged(e);
    }

    protected BgSchemeCollection getBgSchemeInfo(BOSUuid currCCOrgUnitId, Set subOrgUnits) throws Exception {
        return this.getInterface().getCommonBgScheme(currCCOrgUnitId, subOrgUnits, true);
    }

    private void setTemplateFilter() {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        evi.setFilter(filterInfo);
        this.filterItemInfo = new FilterItemInfo("id", (Object)"-1");
        filterInfo.getFilterItems().add(this.filterItemInfo);
        this.prmtTemplate.setData(null);
        this.prmtTemplate.setEntityViewInfo(evi);
    }

    public Set getOrgUnits() {
        Object obj = this.prmtOrgUnit.getData();
        HashSet<String> subOrgUnits = null;
        if (obj != null && !(obj instanceof String)) {
            OrgUnitInfo[] orgUnits = null;
            OrgUnitInfo _currOrgUnit = null;
            OrgUnitInfo _tmpOrgUnit2 = null;
            if (obj instanceof OrgUnitInfo) {
                orgUnits = new OrgUnitInfo[]{(OrgUnitInfo)obj};
            } else if (obj instanceof OrgUnitInfo[]) {
                orgUnits = (OrgUnitInfo[])obj;
            }
            subOrgUnits = new HashSet<String>();
            if (orgUnits != null && orgUnits.length >= 1) {
                _currOrgUnit = this.getCurrOrgUnit();
                if (!_currOrgUnit.getId().equals((Object)orgUnits[0].getId())) {
                    _currOrgUnit = orgUnits[0];
                }
                for (OrgUnitInfo _tmpOrgUnit2 : orgUnits) {
                    subOrgUnits.add(_tmpOrgUnit2.getId().toString());
                }
            }
        }
        return subOrgUnits;
    }

    public Set getOrgUnitsToBosID() {
        Object obj = this.prmtOrgUnit.getData();
        HashSet<BOSUuid> subOrgUnits = null;
        if (obj != null && !(obj instanceof String)) {
            OrgUnitInfo[] orgUnits = null;
            OrgUnitInfo _currOrgUnit = null;
            OrgUnitInfo _tmpOrgUnit2 = null;
            if (obj instanceof OrgUnitInfo) {
                orgUnits = new OrgUnitInfo[]{(OrgUnitInfo)obj};
            } else if (obj instanceof OrgUnitInfo[]) {
                orgUnits = (OrgUnitInfo[])obj;
            }
            subOrgUnits = new HashSet<BOSUuid>();
            if (orgUnits != null && orgUnits.length >= 1) {
                _currOrgUnit = this.getCurrOrgUnit();
                if (!_currOrgUnit.getId().equals((Object)orgUnits[0].getId())) {
                    _currOrgUnit = orgUnits[0];
                }
                for (OrgUnitInfo _tmpOrgUnit2 : orgUnits) {
                    subOrgUnits.add(_tmpOrgUnit2.getId());
                }
            }
        }
        return subOrgUnits;
    }

    public Set getOrgUnitsToBosIDForString() {
        Object obj = this.prmtOrgUnit.getData();
        HashSet<String> subOrgUnits = null;
        if (obj != null && !(obj instanceof String)) {
            OrgUnitInfo[] orgUnits = null;
            OrgUnitInfo _currOrgUnit = null;
            OrgUnitInfo _tmpOrgUnit2 = null;
            if (obj instanceof OrgUnitInfo) {
                orgUnits = new OrgUnitInfo[]{(OrgUnitInfo)obj};
            } else if (obj instanceof OrgUnitInfo[]) {
                orgUnits = (OrgUnitInfo[])obj;
            }
            subOrgUnits = new HashSet<String>();
            if (orgUnits != null && orgUnits.length >= 1) {
                _currOrgUnit = this.getCurrOrgUnit();
                if (!_currOrgUnit.getId().equals((Object)orgUnits[0].getId())) {
                    _currOrgUnit = orgUnits[0];
                }
                for (OrgUnitInfo _tmpOrgUnit2 : orgUnits) {
                    subOrgUnits.add(_tmpOrgUnit2.getId().toString());
                }
            }
        }
        return subOrgUnits;
    }

    protected BgTemplateCollection getBgTemplateInfo(BOSUuid bgSchemeId, BOSUuid[] orgUnitIds) throws Exception {
        return this.getInterface().getCommonBgTemplate(bgSchemeId, orgUnitIds);
    }

    protected IBgAnalyseFacade getInterface() throws Exception {
        return BgAnalyseFacadeFactory.getRemoteInstance();
    }

    protected void comDateType_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void comForecastFunction_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void comHistoryDataType_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void prmtScheme_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.prmtSchemeNew.isReadOnly()) {
            Object _obj = this.prmtSchemeNew.getData();
            this.removeTemplateFilter();
            HashSet<String> subOrgUnits = new HashSet<String>();
            BOSUuid[] orgUnitIds = this.getOrgUnitIds();
            EntityViewInfo evi = new EntityViewInfo();
            if (_obj != null) {
                BgTemplateCollection templateCollection = this.getBgTemplateInfo(((BgSchemeInfo)_obj).getId(), orgUnitIds);
                for (int i = 0; i < templateCollection.size(); ++i) {
                    subOrgUnits.add(templateCollection.get(i).getId().toString());
                }
                FilterInfo filterInfo = new FilterInfo();
                evi.setFilter(filterInfo);
                filterInfo.getFilterItems().add(new FilterItemInfo("id", subOrgUnits, CompareType.INCLUDE));
                filterInfo.getFilterItems().add(new FilterItemInfo("formType", (Object)4, CompareType.NOTEQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("formType", (Object)3, CompareType.NOTEQUALS));
            }
            this.prmtTemplate.setData(null);
            this.prmtTemplate.setEntityViewInfo(evi);
        }
    }

    private void removeTemplateFilter() {
        EntityViewInfo evi = this.prmtTemplate.getEntityViewInfo();
        FilterInfo filterInfo = evi.getFilter();
        filterInfo.getFilterItems().remove(this.filterItemInfo);
    }

    protected BOSUuid[] getOrgUnitIds() throws Exception {
        BOSUuid[] orgUnitIds = null;
        Object obj = this.prmtOrgUnit.getData();
        if (obj != null && !(obj instanceof String)) {
            OrgUnitInfo[] orgUnits = null;
            OrgUnitInfo _tmpOrgUnit2 = null;
            if (obj instanceof OrgUnitInfo) {
                orgUnitIds = new BOSUuid[]{((OrgUnitInfo)obj).getId()};
            } else if (obj instanceof OrgUnitInfo[]) {
                orgUnits = (OrgUnitInfo[])obj;
                orgUnitIds = new BOSUuid[orgUnits.length];
                for (OrgUnitInfo _tmpOrgUnit2 : orgUnits) {
                    orgUnitIds[i] = _tmpOrgUnit2.getId();
                }
            }
        }
        return orgUnitIds;
    }

    @Override
    protected void prmtBgPeriodBegin_NewdataChanged(DataChangeEvent e) throws Exception {
        if (!this.isCustomerParams) {
            this.prmtBgPeriodEnd.setData(this.prmtBgPeriodBegin.getData());
            BgPeriodInfo begin = (BgPeriodInfo)this.prmtBgPeriodBegin.getData();
            BgPeriodInfo end = (BgPeriodInfo)this.prmtBgPeriodEnd.getData();
            if (begin != null && end != null) {
                if (end.getBeginDate().compareTo(begin.getBeginDate()) == -1) {
                    this.prmtBgPeriodBegin.requestFocus();
                    MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.SimForecastFilterResource", "periodError2"));
                } else if (!begin.getPeriodType().equals((Object)end.getPeriodType())) {
                    this.prmtBgPeriodBegin.requestFocus();
                    MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.SimForecastFilterResource", "periodError"));
                } else if (end.getPeriodType() != null) {
                    BgPeriodEnum type = begin.getPeriodType();
                    this.kDCheckBoxYear.setSelected(false);
                    this.kDCheckBoxHalfYear.setSelected(false);
                    this.kDCheckBoxSeason.setSelected(false);
                    this.kDCheckBoxMonth.setSelected(false);
                    if (!this.isBGNFormProcess) {
                        this.kDCheckBoxYear2.setSelected(false);
                        this.kDCheckBoxHalfYear2.setSelected(false);
                        this.kDCheckBoxSeason2.setSelected(false);
                        this.kDCheckBoxMonth2.setSelected(false);
                    }
                    switch (type.getValue()) {
                        case 1: {
                            this.kDCheckBoxYear.setSelected(true);
                            if (this.isBGNFormProcess) break;
                            this.kDCheckBoxYear2.setSelected(true);
                            break;
                        }
                        case 2: {
                            this.kDCheckBoxHalfYear.setSelected(true);
                            if (this.isBGNFormProcess) break;
                            this.kDCheckBoxHalfYear2.setSelected(true);
                            break;
                        }
                        case 3: {
                            this.kDCheckBoxSeason.setSelected(true);
                            if (this.isBGNFormProcess) break;
                            this.kDCheckBoxSeason2.setSelected(true);
                            break;
                        }
                        case 4: {
                            this.kDCheckBoxMonth.setSelected(true);
                            if (this.isBGNFormProcess) break;
                            this.kDCheckBoxMonth2.setSelected(true);
                            break;
                        }
                    }
                }
            }
        }
        this.isCustomerParams = false;
    }

    @Override
    protected void prmtBgPeriodEnd_NewdataChanged(DataChangeEvent e) throws Exception {
        BgPeriodInfo begin = (BgPeriodInfo)this.prmtBgPeriodBegin.getData();
        BgPeriodInfo end = (BgPeriodInfo)this.prmtBgPeriodEnd.getData();
        if (begin != null && end != null) {
            if (end.getBeginDate().compareTo(begin.getBeginDate()) == -1) {
                this.prmtBgPeriodEnd.requestFocus();
                MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.SimForecastFilterResource", "periodError2"));
            } else if (!begin.getPeriodType().equals((Object)end.getPeriodType())) {
                this.prmtBgPeriodEnd.requestFocus();
                MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.SimForecastFilterResource", "periodError"));
            } else if (begin.getPeriodType() != null) {
                BgPeriodEnum type = begin.getPeriodType();
                this.kDCheckBoxYear.setSelected(false);
                this.kDCheckBoxHalfYear.setSelected(false);
                this.kDCheckBoxSeason.setSelected(false);
                this.kDCheckBoxMonth.setSelected(false);
                if (!this.isBGNFormProcess) {
                    this.kDCheckBoxYear2.setSelected(false);
                    this.kDCheckBoxHalfYear2.setSelected(false);
                    this.kDCheckBoxSeason2.setSelected(false);
                    this.kDCheckBoxMonth2.setSelected(false);
                }
                switch (type.getValue()) {
                    case 1: {
                        this.kDCheckBoxYear.setSelected(true);
                        if (this.isBGNFormProcess) break;
                        this.kDCheckBoxYear2.setSelected(true);
                        break;
                    }
                    case 2: {
                        this.kDCheckBoxHalfYear.setSelected(true);
                        if (this.isBGNFormProcess) break;
                        this.kDCheckBoxHalfYear2.setSelected(true);
                        break;
                    }
                    case 3: {
                        this.kDCheckBoxSeason.setSelected(true);
                        if (this.isBGNFormProcess) break;
                        this.kDCheckBoxSeason2.setSelected(true);
                        break;
                    }
                    case 4: {
                        this.kDCheckBoxMonth.setSelected(true);
                        if (this.isBGNFormProcess) break;
                        this.kDCheckBoxMonth2.setSelected(true);
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void actionCheckBox_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isBGNFormProcess) {
            if (this.kDCheckBoxYear.getSelected() == 32) {
                this.kDCheckBoxYear2.setSelected(true);
            } else {
                this.kDCheckBoxYear2.setSelected(false);
            }
        }
    }

    @Override
    public void actionCheckBox2_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isBGNFormProcess) {
            if (this.kDCheckBoxHalfYear.getSelected() == 32) {
                this.kDCheckBoxHalfYear2.setSelected(true);
            } else {
                this.kDCheckBoxHalfYear2.setSelected(false);
            }
        }
    }

    @Override
    public void actionCheckBox3_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isBGNFormProcess) {
            if (this.kDCheckBoxSeason.getSelected() == 32) {
                this.kDCheckBoxSeason2.setSelected(true);
            } else {
                this.kDCheckBoxSeason2.setSelected(false);
            }
        }
    }

    @Override
    public void actionCheckBox4_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isBGNFormProcess) {
            if (this.kDCheckBoxMonth.getSelected() == 32) {
                this.kDCheckBoxMonth2.setSelected(true);
            } else {
                this.kDCheckBoxMonth2.setSelected(false);
            }
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        BgSimforecastFilterParam param = null;
        param = this.getSimFilterParam();
        BgPredictExpressionInfo preInfo = (BgPredictExpressionInfo)this.comMeans.getSelectedItem();
        param.setMeansId(preInfo.getId().toString());
        param.setHistoryTypeId(this.comHistoryDataType.getSelectedIndex());
        if (!this.isBGNFormProcess) {
            OrgUnitInfo[] orgUnits = null;
            Object obj = this.prmtOrgUnit.getData();
            if (obj != null && !(obj instanceof String)) {
                if (obj instanceof OrgUnitInfo) {
                    orgUnits = new OrgUnitInfo[]{(OrgUnitInfo)obj};
                } else if (obj instanceof OrgUnitInfo[]) {
                    orgUnits = (OrgUnitInfo[])obj;
                }
            }
            param.setOrgUnits(orgUnits);
            param.setBgScheme((BgSchemeInfo)this.prmtSchemeNew.getData());
            BgTemplateInfo[] templates = null;
            Object[] obj2 = null;
            Object obj1 = this.prmtTemplate.getData();
            if (obj1 != null && !(obj1 instanceof String)) {
                if (obj1 instanceof BgTemplateInfo) {
                    templates = new BgTemplateInfo[]{(BgTemplateInfo)obj1};
                } else if (obj1 instanceof Object[]) {
                    obj2 = (Object[])obj1;
                    templates = new BgTemplateInfo[obj2.length];
                    for (int i = 0; i < obj2.length; ++i) {
                        templates[i] = (BgTemplateInfo)obj2[i];
                    }
                }
            }
            param.setBgTypes(templates);
            CurrencyInfo curr = (CurrencyInfo)this.comCurrency.getSelectedItem();
            param.setCurrencyId(curr.getId().toString());
        }
        param.setBgPeriodBegin((BgPeriodInfo)this.prmtBgPeriodBegin.getData());
        param.setBgPeriodEnd((BgPeriodInfo)this.prmtBgPeriodEnd.getData());
        param.setIsYear(this.kDCheckBoxYear.isSelected());
        param.setIsHalfYear(this.kDCheckBoxHalfYear.isSelected());
        param.setIsSeason(this.kDCheckBoxSeason.isSelected());
        param.setIsMonth(this.kDCheckBoxMonth.isSelected());
        param.setIsYear2(this.kDCheckBoxYear2.isSelected());
        param.setIsHalfYear2(this.kDCheckBoxHalfYear2.isSelected());
        param.setIsSeason2(this.kDCheckBoxSeason2.isSelected());
        param.setIsMonth2(this.kDCheckBoxMonth2.isSelected());
        this.setFilterObject(cp, param);
        return cp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilterObject(CustomerParams cp, Object param, String key) {
        if (cp == null || param == null) {
            return;
        }
        byte[] objByte = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream out = null;
        try {
            baos = new ByteArrayOutputStream();
            out = new ObjectOutputStream(baos);
            out.writeObject(param);
            objByte = ZipUtil.pack((ByteArrayOutputStream)baos);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception exception) {}
        }
        if (key == null || key.length() == 0) {
            cp.addCustomerParam("FilterParam", Base64.encodeBytes((byte[])objByte));
        } else {
            cp.addCustomerParam(key, Base64.encodeBytes((byte[])objByte));
        }
    }

    public void setFilterObject(CustomerParams cp, Object param) {
        this.setFilterObject(cp, param, null);
    }

    protected BgSimforecastFilterParam getSimFilterParam() {
        if (this.simFilterParam == null) {
            this.simFilterParam = new BgSimforecastFilterParam();
        }
        return this.simFilterParam;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.isCustomerParams = true;
        FilterParam param = (FilterParam)this.getFilterObject(cp);
        if (param == null || !(param instanceof BgSimforecastFilterParam)) {
            return;
        }
        this.simFilterParam = (BgSimforecastFilterParam)param;
        String meansId = this.simFilterParam.getMeansId();
        for (int i = 0; i < this.comMeans.getItemCount(); ++i) {
            if (!meansId.equals(((BgPredictExpressionInfo)this.comMeans.getItemAt(i)).getId().toString())) continue;
            this.comMeans.setSelectedIndex(i);
            break;
        }
        int historyType = this.simFilterParam.getHistoryTypeId();
        this.comHistoryDataType.setSelectedIndex(historyType);
        if (!this.isBGNFormProcess) {
            this.prmtOrgUnit.setValue((Object)this.simFilterParam.getOrgUnits());
            this.prmtSchemeNew.setValue((Object)this.simFilterParam.getBgScheme());
            this.prmtTemplate.setValue((Object)this.simFilterParam.getBgTypes());
            String currId = this.simFilterParam.getCurrencyId();
            for (int i = 0; i < this.comCurrency.getItemCount(); ++i) {
                if (!currId.equals(((CurrencyInfo)this.comCurrency.getItemAt(i)).getId().toString())) continue;
                this.comCurrency.setSelectedIndex(i);
                break;
            }
        }
        this.prmtBgPeriodBegin.setValue((Object)this.simFilterParam.getBgPeriodBegin());
        this.prmtBgPeriodEnd.setValue((Object)this.simFilterParam.getBgPeriodEnd());
        this.kDCheckBoxYear.setSelected(this.simFilterParam.getIsYear());
        this.kDCheckBoxHalfYear.setSelected(this.simFilterParam.getIsHalfYear());
        this.kDCheckBoxSeason.setSelected(this.simFilterParam.getIsSeason());
        this.kDCheckBoxMonth.setSelected(this.simFilterParam.getIsMonth());
        if (this.kDCheckBoxYear2.isEnabled()) {
            this.kDCheckBoxYear2.setSelected(this.simFilterParam.getIsYear2());
        }
        if (this.kDCheckBoxHalfYear2.isEnabled()) {
            this.kDCheckBoxHalfYear2.setSelected(this.simFilterParam.getIsHalfYear2());
        }
        if (this.kDCheckBoxSeason2.isEnabled()) {
            this.kDCheckBoxSeason2.setSelected(this.simFilterParam.getIsSeason2());
        }
        if (this.kDCheckBoxMonth2.isEnabled()) {
            this.kDCheckBoxMonth2.setSelected(this.simFilterParam.getIsMonth2());
        }
        this.isCustomerParams = true;
    }

    public Object getFilterObject(CustomerParams cp) {
        return this.getFilterObject(cp, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFilterObject(CustomerParams cp, String key) {
        if (cp == null) {
            return null;
        }
        FilterParam param = null;
        String objStr = null;
        objStr = key == null || key.length() == 0 ? cp.getCustomerParam("FilterParam") : cp.getCustomerParam(key);
        if (objStr == null) {
            return null;
        }
        byte[] objByte = Base64.decode((String)objStr);
        InputStream is = null;
        ObjectInputStream bais = null;
        try {
            is = ZipUtil.unpack((byte[])objByte);
            bais = new ObjectInputStream(is);
            param = (FilterParam)bais.readObject();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (bais != null) {
                    bais.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        return param;
    }
}

