/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.analysiscolumn.listener.ICustomerQueryConditionChangeListener;
import com.kingdee.eas.ma.nbudget.BgPredictDataSourceTypeEnum;
import com.kingdee.eas.ma.nbudget.BgPredictExpressionCollection;
import com.kingdee.eas.ma.nbudget.BgPredictExpressionFactory;
import com.kingdee.eas.ma.nbudget.BgPredictExpressionInfo;
import com.kingdee.eas.ma.nbudget.BgSimulatePerdictDataFilterParam;
import com.kingdee.eas.ma.nbudget.BgSimulatePredictFilterParams;
import com.kingdee.eas.ma.nbudget.client.AbstractBgSimulatePredictDataAnalyseFilter2UI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class BgSimulatePredictDataAnalyseFilter2UI
extends AbstractBgSimulatePredictDataAnalyseFilter2UI
implements ICustomerQueryConditionChangeListener {
    private static final long serialVersionUID = -6874981663657637779L;
    private static final Logger logger = CoreUIObject.getLogger(BgSimulatePredictDataAnalyseFilter2UI.class);
    private BgSimulatePerdictDataFilterParam ownFilterParam;

    public boolean verify() {
        boolean re = super.verify();
        if (!this.kDCheckBox2.isSelected() && this.kDTable21.getRowCount() == 0) {
            re = false;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgSimulationResource", (String)"analyseDimension"));
            SysUtil.abort();
        }
        if (this.kDTable21.getRowCount() != 0) {
            int i;
            re = false;
            for (i = 0; i < this.kDTable21.getRowCount(); ++i) {
                if (this.kDTable21.getRow(i).getCell("method").getValue() == null) continue;
                re = true;
            }
            if (!re) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgSimulationResource", (String)"method"));
                return re;
            }
            i = 0;
            if (i < this.kDTable21.getRowCount()) {
                String s1 = this.kDTable21.getRow(i).getCell("method").getValue().toString().trim() + this.kDTable21.getRow(i).getCell("datatype").getValue().toString().trim();
                for (int j = i + 1; j < this.kDTable21.getRowCount() - i; ++j) {
                    String s2 = "";
                    if (this.kDTable21.getRow(j).getCell("method").getValue() != null) {
                        s2 = this.kDTable21.getRow(j).getCell("method").getValue().toString().trim() + this.kDTable21.getRow(j).getCell("datatype").getValue().toString().trim();
                    }
                    if (!s2.equals(s1)) continue;
                    re = false;
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgSimulationResource", (String)"same"));
                }
                return re;
            }
        }
        return re;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDWorkButton1.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.kDWorkButton2.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.kDWorkButton1.setEnabled(true);
        this.kDWorkButton2.setEnabled(true);
        this.kDWorkButton1.setText(null);
        this.kDWorkButton2.setText(null);
        this.kDCheckBox2.setSelected(true);
    }

    public void setPanelName(String panelName) {
        panelName = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"analyse");
        super.setPanelName(panelName);
    }

    public void clear() {
        this.kDTable21.removeRows();
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
        if (this.kDTable21.getRowCount() != 0) {
            for (int i = 0; i < this.kDTable21.getRowCount(); ++i) {
                if (this.kDTable21.getRow(i).getCell("method").getValue() != null) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgSimulationResource", (String)"method"));
                return;
            }
        }
        this.kDTable21.addRow();
        int rowIndex = this.kDTable21.getRowCount() - 1;
        this.inputItemsEditor(rowIndex);
        this.kDTable21.getRow(rowIndex).getCell("datatype").setValue((Object)BgPredictDataSourceTypeEnum.BudgetData);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        this.ownFilterParam = this.getOwnFilterParam();
        int rowNum = this.kDTable21.getRowCount();
        if (rowNum > 0) {
            HashMap map1 = new HashMap();
            HashMap<String, BgPredictDataSourceTypeEnum> map = new HashMap<String, BgPredictDataSourceTypeEnum>();
            for (int i = 0; i < rowNum; ++i) {
                IRow row = this.kDTable21.getRow(i);
                if (row.getCell("method").getValue() == null) continue;
                BgPredictExpressionInfo bgPredictExpressionInfo = (BgPredictExpressionInfo)row.getCell("method").getValue();
                BgPredictDataSourceTypeEnum bgPredictDataSourceTypeEnum = (BgPredictDataSourceTypeEnum)((Object)row.getCell("datatype").getValue());
                map.put(bgPredictExpressionInfo.getId() + "@" + i, bgPredictDataSourceTypeEnum);
            }
            this.ownFilterParam.setBgPredictMethodMap(map);
            try {
                this.setFilterObject(cp, BgSimulatePredictFilterParams.getMethoder(map), "perdictMethods");
            }
            catch (Exception e) {
                logger.error((Object)"error", (Throwable)e);
            }
        } else {
            this.ownFilterParam.setBgPredictMethodMap(null);
            this.setFilterObject(cp, "", "perdictMethods");
        }
        boolean isform = this.kDCheckBox2.isSelected();
        this.ownFilterParam.setBgData(isform);
        this.setFilterObject(cp, Boolean.toString(isform), "budgetData");
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.clear();
        String bb = cp.getCustomerParam("budgetData").trim();
        this.kDCheckBox2.setSelected(Boolean.valueOf(bb).booleanValue());
        Map map2 = BgSimulatePredictFilterParams.decodeMethoder(cp.getCustomerParam("perdictMethods"));
        if (map2 != null && map2.size() > 0 && !map2.containsValue("")) {
            this.kDTable21.removeRows();
            this.kDTable21.checkParsed();
            Set set = map2.keySet();
            ArrayList list = new ArrayList(set);
            int num = list.size();
            for (int i = 0; i < num; ++i) {
                String uuid = (String)list.get(i);
                String uuid2 = uuid.substring(0, uuid.indexOf("@"));
                try {
                    BgPredictExpressionInfo element = (BgPredictExpressionInfo)BgPredictExpressionFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)uuid2)));
                    BgPredictDataSourceTypeEnum measureUnit = (BgPredictDataSourceTypeEnum)((Object)map2.get(uuid));
                    IRow row = this.kDTable21.addRow(i);
                    row.getCell("method").setValue((Object)element);
                    row.getCell("datatype").setValue((Object)measureUnit);
                    continue;
                }
                catch (EASBizException e) {
                    logger.error((Object)"budget error:", (Throwable)e);
                    continue;
                }
                catch (BOSException e) {
                    logger.error((Object)"budget error:", (Throwable)e);
                    continue;
                }
                catch (UuidException e) {
                    logger.error((Object)"budget error:", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.kDTable21.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"37_BgDataAnalyseFilterUI"));
            return;
        }
        super.actionRemoveLine_actionPerformed(e);
        int index = this.kDTable21.getSelectManager().getActiveRowIndex();
        this.kDTable21.removeRow(index);
    }

    @Override
    protected void kDTable21_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int rowIndex = this.kDTable21.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0) {
            KDTEditEvent event = new KDTEditEvent((Object)this.kDTable21);
            event.setRowIndex(rowIndex);
            event.setColIndex(this.kDTable21.getColumnIndex("method"));
            this.kDTable21_editStopped(event);
        }
    }

    @Override
    protected void kDTable21_editStarting(KDTEditEvent e) throws Exception {
        super.kDTable21_editStarting(e);
        int colIndex = e.getColIndex();
        int curRow = e.getRowIndex();
        IRow iRow = this.kDTable21.getRow(curRow);
        if (iRow.getCell("datatype").getEditor() == null) {
            this.inputItemsEditor(curRow);
        }
    }

    @Override
    protected void kDTable21_editStopped(KDTEditEvent e) throws Exception {
        IRow iRow;
        int colIndex = e.getColIndex();
        int curRow = e.getRowIndex();
        if (colIndex == this.kDTable21.getColumnIndex("method")) {
            iRow = this.kDTable21.getRow(curRow);
            ICell iCell = iRow.getCell("method");
            ICell iItems = iRow.getCell("datatype");
            if (iCell == null || iCell.getValue() == null) {
                return;
            }
            BgPredictExpressionInfo itemGroupInfo = (BgPredictExpressionInfo)iCell.getValue();
            if (iItems.getEditor() == null) {
                this.inputItemsEditor(curRow);
            }
        }
        if (colIndex == this.kDTable21.getColumnIndex("datatype")) {
            iRow = this.kDTable21.getRow(curRow);
            ICell iItems = iRow.getCell("datatype");
            Object[] itemColl = null;
            String[] itemNums = null;
            String item = null;
            if (iItems == null || iItems.getValue() == null || !(iItems.getValue() instanceof Object[])) {
                return;
            }
            itemColl = (Object[])iItems.getValue();
            itemNums = new String[itemColl.length];
            for (int i = 0; i < itemColl.length; ++i) {
                itemNums[i] = ((BgItemInfo)itemColl[i]).getNumber();
            }
            item = BgHelper.tranArray2String((String[])itemNums);
            iItems.setValue((Object)item);
        }
    }

    private void inputItemsEditor(int rowIndex) {
        KDTDefaultCellEditor editor0 = null;
        KDComboBox comboBox0 = new KDComboBox();
        DefaultComboBoxModel<BgPredictExpressionInfo> model0 = new DefaultComboBoxModel<BgPredictExpressionInfo>();
        BgPredictExpressionCollection methodCollection = null;
        try {
            methodCollection = BgPredictExpressionFactory.getRemoteInstance().getBgPredictExpressionCollection();
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        int in = methodCollection.size();
        for (int i = 0; i < in; ++i) {
            model0.addElement(methodCollection.get(i));
        }
        comboBox0.setModel(model0);
        editor0 = new KDTDefaultCellEditor((JComboBox)comboBox0);
        this.kDTable21.checkParsed();
        this.kDTable21.getColumn(0).setEditor((ICellEditor)editor0);
        KDTDefaultCellEditor editor = null;
        KDComboBox comboBox = new KDComboBox();
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        Iterator i = BgPredictDataSourceTypeEnum.iterator();
        while (i.hasNext()) {
            model.addElement(i.next());
        }
        comboBox.setModel(model);
        editor = new KDTDefaultCellEditor((JComboBox)comboBox);
        this.kDTable21.checkParsed();
        this.kDTable21.getColumn(1).setEditor((ICellEditor)editor);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void setFilterObject(CustomerParams cp, Object param, String key) {
        cp.addCustomerParam(key, param.toString());
    }

    public BgSimulatePerdictDataFilterParam getOwnFilterParam() {
        if (this.ownFilterParam == null) {
            this.ownFilterParam = new BgSimulatePerdictDataFilterParam();
        }
        return this.ownFilterParam;
    }

    public void setOwnFilterParam(BgSimulatePerdictDataFilterParam ownFilterParam) {
        this.ownFilterParam = ownFilterParam;
    }

    public void change(Object newObj) {
    }
}

