/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgSimulatePredictDataAnalyseProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgSimulatePredictDataAnalyseFilterUI;
import com.kingdee.eas.ma.nbudget.client.BgSimulationPredictDataAnalyseFormUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgSimulatePredictDataAnalyseProcessUI
extends AbstractBgSimulatePredictDataAnalyseProcessUI {
    private static final Logger logger = CoreUIObject.getLogger(BgSimulatePredictDataAnalyseProcessUI.class);
    private Vector ItemFormulas = new Vector();
    private Map items = new HashMap();
    private BgSimulatePredictDataAnalyseFilterUI filterUI = null;
    private Map hadItem = new HashMap();
    private BgFormInfo bgFormInfo = null;

    public BgSimulatePredictDataAnalyseProcessUI() throws Exception {
        this.btnSelecItem.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnValueFormulaSwitch.setVisible(false);
        this.btnValueFormulaSwitch.setEnabled(false);
    }

    @Override
    protected void initWorkButton() {
        ToolBarManager toolBarManager = this.getSpreadManager().getSpreadContainer().getToolBarManager();
        toolBarManager.getToolBar("style").setVisible(false);
        KDToolBar commonToolBar = toolBarManager.getToolBar("common");
        for (Component comp : commonToolBar.getComponents()) {
            this.setBtnUnVisbile(comp);
        }
        this.actionSelectItem.setVisible(true);
        this.actionSelectItem.setEnabled(true);
        this.btnSelecItem.setVisible(true);
        this.btnSelecItem.setEnabled(true);
    }

    private void setBtnUnVisbile(Component comp) {
        comp.setVisible(false);
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    public void onShow() {
        super.onShow();
        Book book = this.getBook();
        int i = 0;
        for (int n = book.getSheetCount(); n > i; --n) {
            book.getSheet(n - 1).getRange(0, 0).select();
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().get("selectOwner") != null) {
            this.filterUI = (BgSimulatePredictDataAnalyseFilterUI)((Object)this.getUIContext().get("selectOwner"));
        }
        if (this.getUIContext().get("bgFormInfo") != null) {
            this.bgFormInfo = (BgFormInfo)this.getUIContext().get("bgFormInfo");
        }
        int maxRow = -1;
        int maxCol = -1;
        if (this.filterUI != null) {
            String formulaString = null;
            Sheet sheet = null;
            for (int n = 0; n < this.getBook().getSheetCount(); ++n) {
                sheet = this.getBook().getSheet(n);
                if (sheet == null) continue;
                Range range = sheet.getSelectionRange();
                for (int i = 0; i < range.size(); ++i) {
                    CellBlock block = range.getBlock(i);
                    maxRow = sheet.getMaxRowIndex() + 1;
                    maxCol = sheet.getMaxColIndex() + 1;
                    if (maxRow > block.getRow2()) {
                        maxRow = block.getRow2();
                    }
                    if (maxCol > block.getCol2()) {
                        maxCol = block.getCol2();
                    }
                    for (int j = block.getRow(); j <= maxRow; ++j) {
                        for (int k = block.getCol(); k <= maxCol; ++k) {
                            Cell cell = sheet.getCell(j, k, true);
                            if (!BgNFSHelper.checkHasItemFormula(cell) || (formulaString = BgNFSHelper.getFormulaOfCell(cell)) == null || formulaString.trim().length() <= 0) continue;
                            this.formulaParse(formulaString);
                        }
                    }
                }
            }
            if (this.ItemFormulas == null || this.ItemFormulas.size() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"noBgItem"));
            } else if (this.ItemFormulas != null || this.ItemFormulas.size() > 0) {
                String orgUnitId = null;
                if (this.bgFormInfo != null && this.bgFormInfo.getOrgUnit() != null) {
                    orgUnitId = this.bgFormInfo.getOrgUnit().getId().toString();
                }
                this.filterUI.setItemString(this.ItemFormulas, this.items, orgUnitId);
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"submitSuccess"));
                super.actionExitCurrent_actionPerformed(null);
                if (this.getUIContext().get("Owner") instanceof BgSimulationPredictDataAnalyseFormUI) {
                    BgSimulationPredictDataAnalyseFormUI formUI = (BgSimulationPredictDataAnalyseFormUI)((Object)this.getUIContext().get("Owner"));
                    formUI.actionExitCurrent_actionPerformed(null);
                }
            }
        }
    }

    private void formulaParse(String formulas) {
        String[] item = null;
        try {
            List list = new ArrayList();
            list = TableToolkit.parseFormula((String)("=" + formulas.toString()), (boolean)false);
            FormulaHint hint = (FormulaHint)list.get(0);
            String[] params = hint.getParams();
            if (params[0] != null && params[0].trim().toString().length() != 0) {
                if (this.hadItem.containsKey(params[0])) {
                    return;
                }
                this.ItemFormulas.add(params[0]);
                this.hadItem.put(params[0], null);
                item = params[0].split(",");
                for (int i = 0; i < item.length; ++i) {
                    this.items.put(item[i], null);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
    }

    protected void disposeUIWindow() {
        super.disposeUIWindow();
    }

    @Override
    public void actionSelectItem_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().get("selectOwner") != null) {
            this.filterUI = (BgSimulatePredictDataAnalyseFilterUI)((Object)this.getUIContext().get("selectOwner"));
        }
        if (this.getUIContext().get("bgFormInfo") != null) {
            this.bgFormInfo = (BgFormInfo)this.getUIContext().get("bgFormInfo");
        }
        int maxRow = -1;
        int maxCol = -1;
        if (this.filterUI != null) {
            String formulaString = null;
            Sheet sheet = null;
            for (int n = 0; n < this.getBook().getSheetCount(); ++n) {
                sheet = this.getBook().getSheet(n);
                if (sheet == null) continue;
                Range range = sheet.getSelectionRange();
                for (int i = 0; i < range.size(); ++i) {
                    CellBlock block = range.getBlock(i);
                    maxRow = sheet.getMaxRowIndex() + 1;
                    maxCol = sheet.getMaxColIndex() + 1;
                    if (maxRow > block.getRow2()) {
                        maxRow = block.getRow2();
                    }
                    if (maxCol > block.getCol2()) {
                        maxCol = block.getCol2();
                    }
                    for (int j = block.getRow(); j <= maxRow; ++j) {
                        for (int k = block.getCol(); k <= maxCol; ++k) {
                            Cell cell = sheet.getCell(j, k, true);
                            if (!BgNFSHelper.checkHasItemFormula(cell) || (formulaString = BgNFSHelper.getFormulaOfCell(cell)) == null || formulaString.trim().length() <= 0) continue;
                            this.formulaParse(formulaString);
                        }
                    }
                }
            }
            if (this.ItemFormulas == null || this.ItemFormulas.size() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"noBgItem"));
            } else if (this.ItemFormulas != null || this.ItemFormulas.size() > 0) {
                String orgUnitId = null;
                orgUnitId = this.getBgFormInfo().getOrgUnit().getId().toString();
                if (orgUnitId == null && this.bgFormInfo != null && this.bgFormInfo.getOrgUnit() != null) {
                    orgUnitId = this.bgFormInfo.getOrgUnit().getId().toString();
                }
                this.filterUI.setItemString(this.ItemFormulas, this.items, orgUnitId);
                this.filterUI.setbgformid((String)this.getUIContext().get("bgformid"));
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"submitSuccess"));
                super.actionExitCurrent_actionPerformed(null);
                if (this.getUIContext().get("Owner") instanceof BgSimulationPredictDataAnalyseFormUI) {
                    BgSimulationPredictDataAnalyseFormUI formUI = (BgSimulationPredictDataAnalyseFormUI)((Object)this.getUIContext().get("Owner"));
                    formUI.actionExitCurrent_actionPerformed(null);
                }
            }
        }
    }
}

