/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.print.printjob.table.ITableForPrint;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.budget.client.NewBgItemForEnumDialog;
import com.kingdee.eas.ma.nbudget.BgEnumerateHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgTemEnumerateEditUI;
import com.kingdee.eas.ma.nbudget.client.BgEnumerateExampleUI;
import com.kingdee.eas.ma.nbudget.client.BgNTemplateProcessUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class BgTemEnumerateEditUI
extends AbstractBgTemEnumerateEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BgTemEnumerateEditUI.class);
    private int row = -1;
    private int row2 = -1;
    private int col = -1;
    private int col2 = -1;
    private Map enumMap = null;
    private BgNTemplateProcessUI bgTemProcessUI;
    private Sheet sheet = null;
    private Map rowMap = new HashMap();
    private Map colMap = new HashMap();

    public void onLoad() throws Exception {
        super.onLoad();
        this.initFirstBtn();
        this.init();
        this.initData();
    }

    private void init() {
        this.tblItem.getSelectManager().setSelectMode(10);
        this.tblCollect.getSelectManager().setSelectMode(10);
        Icon bg = EASResource.getIcon((String)"imgGuide_pic338");
        this.kDLFirst.setIcon(bg);
        this.kDLThird.setIcon(bg);
        this.kDLSecond.setIcon(bg);
        Icon addLine = EASResource.getIcon((String)"imgTbtn_addline");
        Icon remLine = EASResource.getIcon((String)"imgTbtn_deleteline");
        this.btnItemAddLine.setIcon(addLine);
        this.btnCollectAddLine.setIcon(addLine);
        this.btnItemRemoveLine.setIcon(remLine);
        this.btnCollectRemoveLine.setIcon(remLine);
        NewBgItemForEnumDialog bgItemF7 = new NewBgItemForEnumDialog((IUIObject)this);
        KDBizPromptBox prmtSelect = null;
        prmtSelect = new KDBizPromptBox();
        prmtSelect.setEditable(false);
        prmtSelect.setSelector((KDPromptSelector)bgItemF7);
        prmtSelect.setDisplayFormat("$name$");
        this.tblItem.checkParsed();
        this.tblCollect.checkParsed();
        this.tblItem.getColumn("item").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
        this.tblItem.addRow();
        this.tblCollect.addRow();
        this.toolBar.setVisible(false);
        this.menuBar.setVisible(false);
    }

    private void initData() {
        this.sheet = (Sheet)this.getUIContext().get("Sheet");
        this.enumMap = (HashMap)this.getUIContext().get("EnumerAteArea");
        Vector selV = (Vector)this.getUIContext().get("EnumSelectArea");
        String selStr = null;
        if (selV != null) {
            selStr = selV.get(0).toString();
            this.KDTEnumArea.setText(selStr);
            this.row = (Integer)selV.get(1);
            this.row2 = (Integer)selV.get(2);
            this.col = (Integer)selV.get(3);
            this.col2 = (Integer)selV.get(4);
            this.tblCollect.getCell(0, 0).setValue((Object)selStr);
            this.tblItem.getRow(0).getCell("itemArea").setValue((Object)selStr);
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    public void actionEnumExample_actionPerformed(ActionEvent e) throws Exception {
        UIContext uicon = new UIContext();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BgEnumerateExampleUI.class.getName(), (Map)uicon, null, null);
        uiWindow.show();
    }

    @Override
    public void actionFirstNext_actionPerformed(ActionEvent e) throws Exception {
        this.initSecondBtn();
    }

    private void initSecondBtn() {
        this.kDPEnumerateArea.setVisible(false);
        this.kDPEnumerateArea.setEnabled(false);
        this.kDPEnumerateItem.setVisible(true);
        this.kDPEnumerateItem.setEnabled(true);
        this.kDPCollectArea.setVisible(false);
        this.kDPCollectArea.setEnabled(false);
        this.btnSecondCancel.setEnabled(true);
        this.btnSecondPrevious.setEnabled(true);
        this.btnSecondNext.setEnabled(true);
        this.btnSecondFinish.setEnabled(false);
        this.btnItemAddLine.setEnabled(true);
        this.btnItemRemoveLine.setEnabled(true);
    }

    @Override
    public void actionItemAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.tblItem.addRow();
    }

    @Override
    public void actionItemRemLine_actionPerformed(ActionEvent e) throws Exception {
        KDTRange range = this.tblItem.getSelectManager().toRange();
        if (range != null) {
            int rowCount = range.size();
            for (int i = 0; i < rowCount; ++i) {
                int rowEnd;
                KDTSelectBlock block = (KDTSelectBlock)range.get(i);
                int rowBegin = block.getBeginRow();
                for (int j = rowEnd = block.getEndRow(); j >= rowBegin; --j) {
                    this.tblItem.removeRow(j);
                }
            }
        }
    }

    @Override
    public void actionSecondPrevious_actionPerformed(ActionEvent e) throws Exception {
        this.initFirstBtn();
    }

    private void initFirstBtn() {
        this.kDPEnumerateArea.setVisible(true);
        this.kDPEnumerateArea.setEnabled(true);
        this.kDPEnumerateItem.setVisible(false);
        this.kDPEnumerateItem.setEnabled(false);
        this.kDPCollectArea.setVisible(false);
        this.kDPCollectArea.setEnabled(false);
        this.btnEnumExample.setVisible(true);
        this.btnEnumExample.setEnabled(true);
        this.btnFirstCancel.setEnabled(true);
        this.btnFirstPrevious.setEnabled(false);
        this.btnFirstNext.setEnabled(true);
        this.btnFirstFinish.setEnabled(false);
    }

    @Override
    public void actionSecondNext_actionPerformed(ActionEvent e) throws Exception {
        this.initThirdBtn();
    }

    private void initThirdBtn() {
        this.kDPEnumerateArea.setVisible(false);
        this.kDPEnumerateArea.setEnabled(false);
        this.kDPEnumerateItem.setVisible(false);
        this.kDPEnumerateItem.setEnabled(false);
        this.kDPCollectArea.setVisible(true);
        this.kDPCollectArea.setEnabled(true);
        this.btnThirdCancel.setEnabled(true);
        this.btnThirdPrevious.setEnabled(true);
        this.btnThirdNext.setEnabled(false);
        this.btnThirdFinish.setEnabled(true);
        this.btnCollectAddLine.setEnabled(true);
        this.btnCollectRemoveLine.setEnabled(true);
    }

    @Override
    public void actionFinish_actionPerformed(ActionEvent e) throws Exception {
        String key;
        Map vEnum;
        String errorStr;
        HashMap newEnum = new HashMap();
        if (this.verifyEnumArea(newEnum)) {
            return;
        }
        this.bgTemProcessUI = (BgNTemplateProcessUI)this.getUIContext().get("Owner");
        String sheetId = this.sheet.getID();
        if (this.enumMap == null) {
            this.enumMap = new HashMap();
        }
        if ((errorStr = BgEnumerateHelper.errorStr(vEnum = (Map)newEnum.get(key = newEnum.keySet().iterator().next().toString()), (Map)this.enumMap.get(sheetId), this.sheet)) != null && errorStr.length() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)errorStr);
            return;
        }
        if (this.enumMap.containsKey(sheetId)) {
            ((Map)this.enumMap.get(sheetId)).put(key, newEnum.get(key));
        } else {
            this.enumMap.put(sheetId, newEnum);
        }
        this.bgTemProcessUI.setSign(sheetId, this.rowMap, this.colMap);
        this.bgTemProcessUI.setCellEnumerate(sheetId, this.KDTEnumArea.getText(), newEnum);
        this.bgTemProcessUI.setEnumerateArea(this.enumMap);
        this.getUIWindow().close();
    }

    private boolean verifyEnumArea(HashMap newEnum) {
        ArrayList enumCollArea = new ArrayList();
        if (this.getEnumCollArea(enumCollArea)) {
            // empty if block
        }
        HashMap enumItemArea = new HashMap();
        this.getEnumItemArea(enumItemArea);
        if (enumItemArea == null || enumItemArea.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgEnumerateResource", (String)"itemAreaError"));
            return true;
        }
        String key = null;
        String enumAreaStr = "";
        enumAreaStr = this.KDTEnumArea.getText();
        ITableForPrint.IBlock enumBlock = BgEnumerateHelper.creatBlock(enumAreaStr);
        if (enumBlock == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgEnumerateResource", (String)"enumAreaError"));
            return true;
        }
        Row beginRow = this.sheet.getRow(enumBlock.getRow(), true);
        Column beginCol = this.sheet.getColumn(enumBlock.getCol(), true);
        this.addSignWithRowAndCol(beginRow, beginCol);
        Row endRow = this.sheet.getRow(enumBlock.getRow2(), true);
        Column endCol = this.sheet.getColumn(enumBlock.getCol2(), true);
        this.addSignWithRowAndCol(endRow, endCol);
        key = BgNFSHelper.getRowSign(this.sheet.getRow(enumBlock.getRow(), false)) + BgNFSHelper.getColSign(this.sheet.getColumn(enumBlock.getCol(), false));
        HashMap<String, Object> enumArea = new HashMap<String, Object>();
        enumArea.put("AreaRowId", BgNFSHelper.getRowSign(this.sheet.getRow(enumBlock.getRow(), false)));
        enumArea.put("AreaColId", BgNFSHelper.getColSign(this.sheet.getColumn(enumBlock.getCol(), false)));
        enumArea.put("AreaRow1Id", BgNFSHelper.getRowSign(this.sheet.getRow(enumBlock.getRow2(), false)));
        enumArea.put("AreaCol1Id", BgNFSHelper.getColSign(this.sheet.getColumn(enumBlock.getCol2(), false)));
        enumArea.put("EnumItemArea", enumItemArea);
        enumArea.put("EnumCollArea", enumCollArea);
        newEnum.put(key, enumArea);
        return false;
    }

    private boolean getEnumItemArea(Map enumItemArea) {
        HashMap<String, Object> itemAndGroup = null;
        boolean isSame = false;
        try {
            String itemAGroup = null;
            BgItemGroupInfo itemGroup = null;
            BgItemCollection coll = null;
            HashSet<String> itemS = null;
            String itemArea = null;
            ITableForPrint.IBlock itemBlock = null;
            Vector item = null;
            String key = null;
            HashMap hadArea = new HashMap();
            for (int i = 0; i < this.tblItem.getRowCount(); ++i) {
                itemAndGroup = new HashMap<String, Object>();
                if (this.tblItem.getRow(i).getCell("itemArea").getValue() == null || (itemArea = this.tblItem.getRow(i).getCell("itemArea").getValue().toString()) == null || (itemBlock = BgEnumerateHelper.creatBlock(itemArea)).toString() == null) continue;
                key = BgNFSHelper.getRowSign(this.sheet.getRow(itemBlock.getRow(), false)) + BgNFSHelper.getColSign(this.sheet.getColumn(itemBlock.getCol(), false));
                if (hadArea.containsKey(key)) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgEnumerateResource", (String)"sameItemAreaError"));
                    isSame = true;
                    break;
                }
                hadArea.put(key, null);
                item = (Vector)this.tblItem.getRow(i).getCell("itemObject").getValue();
                if (item != null && !item.isEmpty()) {
                    itemAGroup = (String)item.get(0);
                    itemAndGroup.put("ItemAndGroup", itemAGroup);
                    itemGroup = (BgItemGroupInfo)item.get(1);
                    coll = item.size() >= 3 ? (BgItemCollection)item.get(2) : null;
                    itemAndGroup.put("BgItemGroup", itemGroup.getNumber());
                    itemS = new HashSet<String>();
                    for (int j = 0; coll != null && j < coll.size(); ++j) {
                        itemS.add(coll.get(j).getNumber());
                    }
                    if (!itemS.isEmpty()) {
                        itemAndGroup.put("BgItem", itemS);
                    }
                }
                Row beginRow = this.sheet.getRow(itemBlock.getRow(), true);
                Column beginCol = this.sheet.getColumn(itemBlock.getCol(), true);
                this.addSignWithRowAndCol(beginRow, beginCol);
                Row endRow = this.sheet.getRow(itemBlock.getRow2(), true);
                Column endCol = this.sheet.getColumn(itemBlock.getCol2(), true);
                this.addSignWithRowAndCol(endRow, endCol);
                itemAndGroup.put("AreaRowId", BgNFSHelper.getRowSign(this.sheet.getRow(itemBlock.getRow(), false)));
                itemAndGroup.put("AreaColId", BgNFSHelper.getColSign(this.sheet.getColumn(itemBlock.getCol(), false)));
                itemAndGroup.put("AreaRow1Id", BgNFSHelper.getRowSign(this.sheet.getRow(itemBlock.getRow2(), false)));
                itemAndGroup.put("AreaCol1Id", BgNFSHelper.getColSign(this.sheet.getColumn(itemBlock.getCol2(), false)));
                enumItemArea.put(key, itemAndGroup);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (isSame) {
            SysUtil.abort();
        }
        return false;
    }

    private boolean getEnumCollArea(List enumCollArea) {
        HashMap<String, String> collArea = null;
        boolean isError = true;
        try {
            String area = null;
            ITableForPrint.IBlock collBlock = null;
            for (int i = 0; i < this.tblCollect.getRowCount(); ++i) {
                collArea = new HashMap<String, String>();
                area = this.tblCollect.getRow(i).getCell("collectArea").getValue().toString();
                if (area == null || (collBlock = BgEnumerateHelper.creatBlock(area)).toString() == null) continue;
                Row beginRow = this.sheet.getRow(collBlock.getRow(), true);
                Column beginCol = this.sheet.getColumn(collBlock.getCol(), true);
                this.addSignWithRowAndCol(beginRow, beginCol);
                Row endRow = this.sheet.getRow(collBlock.getRow2(), true);
                Column endCol = this.sheet.getColumn(collBlock.getCol2(), true);
                this.addSignWithRowAndCol(endRow, endCol);
                collArea.put("AreaRowId", BgNFSHelper.getRowSign(this.sheet.getRow(collBlock.getRow(), false)));
                collArea.put("AreaColId", BgNFSHelper.getColSign(this.sheet.getColumn(collBlock.getCol(), false)));
                collArea.put("AreaRow1Id", BgNFSHelper.getRowSign(this.sheet.getRow(collBlock.getRow2(), false)));
                collArea.put("AreaCol1Id", BgNFSHelper.getColSign(this.sheet.getColumn(collBlock.getCol2(), false)));
                enumCollArea.add(collArea);
                isError = false;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            SysUtil.abort();
        }
        return isError;
    }

    @Override
    public void actionThirdPrevious_actionPerformed(ActionEvent e) throws Exception {
        this.initSecondBtn();
    }

    @Override
    public void actionCollAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.tblCollect.addRow();
    }

    @Override
    public void actionCollRemLine_actionPerformed(ActionEvent e) throws Exception {
        KDTRange range = this.tblCollect.getSelectManager().toRange();
        if (range != null) {
            int rowCount = range.size();
            for (int i = 0; i < rowCount; ++i) {
                int rowEnd;
                KDTSelectBlock block = (KDTSelectBlock)range.get(i);
                int rowBegin = block.getBeginRow();
                for (int j = rowEnd = block.getEndRow(); j >= rowBegin; --j) {
                    this.tblCollect.removeRow(j);
                }
            }
        }
    }

    @Override
    protected void tblItem_editStopped(KDTEditEvent e) throws Exception {
        ICell cell;
        if (e.getColIndex() == this.tblItem.getColumnIndex("item") && (cell = this.tblItem.getCell(e.getRowIndex(), e.getColIndex())).getValue() != null && cell.getValue() instanceof Vector) {
            this.tblItem.getCell(e.getRowIndex(), "itemObject").setValue(cell.getValue());
            String str = ((Vector)cell.getValue()).get(0).toString();
            cell.setValue((Object)str);
        }
    }

    private void addSignWithRowAndCol(Row beginRow, Column beginCol) {
        String rSign = null;
        if (!BgNFSHelper.checkHasSign(beginRow)) {
            rSign = BOSUuid.create((String)"BBBCCAAA").toString();
            BgNFSHelper.setRowSign(beginRow, rSign);
            this.rowMap.put(new Integer(beginRow.getRow()), rSign);
        }
        String cSign = null;
        if (!BgNFSHelper.checkHasSign(beginCol)) {
            cSign = BOSUuid.create((String)"BBBCCAAA").toString();
            BgNFSHelper.setColSign(beginCol, cSign);
            this.colMap.put(new Integer(beginCol.getCol()), cSign);
        }
    }
}

