/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.print.printjob.table.ITableForPrint;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.client.NewBgItemForEnumDialog;
import com.kingdee.eas.ma.nbudget.BgEnumerateHelper;
import com.kingdee.eas.ma.nbudget.BgEnumerateInfo;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgTemEnumerateUpdateUI;
import com.kingdee.eas.ma.nbudget.client.BgNTemplateProcessUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class BgTemEnumerateUpdateUI
extends AbstractBgTemEnumerateUpdateUI {
    private static final Logger logger = CoreUIObject.getLogger(BgTemEnumerateUpdateUI.class);
    private Sheet sheet = null;
    private BgNTemplateProcessUI bgTemProcessUI;
    private Map enumMap = null;
    private Map rowMap = new HashMap();
    private Map colMap = new HashMap();
    private String oldKey = null;
    private String oldEnumArea = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initBtn();
        this.inputArea();
    }

    private void initBtn() {
        this.tblItem.getSelectManager().setSelectMode(10);
        this.tblColl.getSelectManager().setSelectMode(10);
        Icon addLine = EASResource.getIcon((String)"imgTbtn_addline");
        Icon remLine = EASResource.getIcon((String)"imgTbtn_deleteline");
        this.btnItemAddLine.setIcon(addLine);
        this.btnCollAddLine.setIcon(addLine);
        this.btnItemRemLine.setIcon(remLine);
        this.btnCollRemLine.setIcon(remLine);
        NewBgItemForEnumDialog bgItemF7 = new NewBgItemForEnumDialog((IUIObject)this);
        KDBizPromptBox prmtSelect = null;
        prmtSelect = new KDBizPromptBox();
        prmtSelect.setEditable(false);
        prmtSelect.setSelector((KDPromptSelector)bgItemF7);
        prmtSelect.setDisplayFormat("$name$");
        this.tblItem.checkParsed();
        this.tblColl.checkParsed();
        this.tblItem.getColumn("item").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
        this.btnItemAddLine.setEnabled(true);
        this.btnCollAddLine.setEnabled(true);
        this.btnItemRemLine.setEnabled(true);
        this.btnCollRemLine.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.btnConfirm.setEnabled(true);
    }

    private void inputArea() {
        this.sheet = (Sheet)this.getUIContext().get("Sheet");
        this.enumMap = (HashMap)this.getUIContext().get("EnumerAteArea");
        HashMap enumSelectArea = (HashMap)this.getUIContext().get("EnumSelectArea");
        BgEnumerateInfo enumInfo = new BgEnumerateInfo(enumSelectArea, this.sheet, true, true);
        this.oldKey = enumInfo.getKey();
        this.oldEnumArea = enumInfo.getEnumName();
        String area = enumInfo.getEnumName();
        if (area == null) {
            return;
        }
        this.kDTEnumArea.setText(area);
        List enumCollArea = enumInfo.getCollArea();
        String enumColl = null;
        IRow collRow = null;
        if (enumCollArea != null) {
            Iterator ite = enumCollArea.iterator();
            while (ite.hasNext()) {
                enumColl = ite.next().toString();
                collRow = this.tblColl.addRow();
                collRow.getCell(0).setValue((Object)enumColl);
            }
        }
        Map enumItemArea = enumInfo.getItemArea();
        String itemArea2 = null;
        IRow itemRow = null;
        String item = null;
        if (enumItemArea == null) {
            return;
        }
        for (String itemArea2 : enumItemArea.keySet()) {
            itemRow = this.tblItem.addRow();
            itemRow.getCell("itemArea").setValue((Object)itemArea2);
            item = (String)enumItemArea.get(itemArea2);
            itemRow.getCell("item").setValue((Object)item);
            this.addObjectToItem(itemRow, item);
        }
    }

    private void addObjectToItem(IRow itemRow, String item) {
        if (item == null) {
            return;
        }
        Vector<String> obj = new Vector<String>();
        obj.add(item);
        BgItemInfo itemInfo = null;
        BgItemCollection itemColl = new BgItemCollection();
        BgItemGroupInfo itemGroupInfo = null;
        String[] items = item.split(":");
        String[] ite = null;
        for (int i = 0; i < items.length; ++i) {
            if (i == 0) {
                itemGroupInfo = new BgItemGroupInfo();
                itemGroupInfo.setNumber(items[0]);
                obj.add((String)itemGroupInfo);
                continue;
            }
            ite = items[i].split(",");
            for (int j = 0; ite != null && j < ite.length; ++j) {
                itemInfo = new BgItemInfo();
                itemInfo.setNumber(ite[j]);
                itemColl.add(itemInfo);
            }
        }
        if (itemColl.size() > 0) {
            obj.add((String)itemColl);
        }
        itemRow.getCell("itemObject").setValue(obj);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionItemAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.tblItem.addRow();
    }

    @Override
    public void actionItemRemLine_actionPerformed(ActionEvent e) throws Exception {
        KDTRange range = this.tblItem.getSelectManager().toRange();
        if (range != null) {
            int rowCount = range.size();
            for (int i = 0; i < rowCount; ++i) {
                int rowEnd;
                KDTSelectBlock block = (KDTSelectBlock)range.get(i);
                int rowBegin = block.getBeginRow();
                for (int j = rowEnd = block.getEndRow(); j >= rowBegin; --j) {
                    this.tblItem.removeRow(j);
                }
            }
        }
    }

    @Override
    public void actionCollAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.tblColl.addRow();
    }

    @Override
    public void actionCollRemLine_actionPerformed(ActionEvent e) throws Exception {
        KDTRange range = this.tblColl.getSelectManager().toRange();
        if (range != null) {
            int rowCount = range.size();
            for (int i = 0; i < rowCount; ++i) {
                int rowEnd;
                KDTSelectBlock block = (KDTSelectBlock)range.get(i);
                int rowBegin = block.getBeginRow();
                for (int j = rowEnd = block.getEndRow(); j >= rowBegin; --j) {
                    this.tblColl.removeRow(j);
                }
            }
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        HashMap newEnum = new HashMap();
        if (this.verifyEnumArea(newEnum)) {
            return;
        }
        this.bgTemProcessUI = (BgNTemplateProcessUI)this.getUIContext().get("Owner");
        String sheetId = this.sheet.getID();
        if (this.enumMap == null) {
            this.enumMap = new HashMap();
        }
        if (this.enumMap.containsKey(sheetId)) {
            ((Map)this.enumMap.get(sheetId)).remove(this.oldKey);
            String key = newEnum.keySet().iterator().next().toString();
            Map vEnum = (Map)newEnum.get(key);
            String errorStr = BgEnumerateHelper.errorStr(vEnum, (Map)this.enumMap.get(sheetId), this.sheet);
            if (errorStr != null && errorStr.length() > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)errorStr);
                return;
            }
            ((Map)this.enumMap.get(sheetId)).put(key, newEnum.get(key));
        } else {
            String key = newEnum.keySet().iterator().next().toString();
            Map vEnum = (Map)newEnum.get(key);
            String errorStr = BgEnumerateHelper.errorStr(vEnum, (Map)this.enumMap.get(sheetId), this.sheet);
            if (errorStr != null && errorStr.length() > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)errorStr);
                return;
            }
            this.enumMap.put(sheetId, newEnum);
        }
        this.bgTemProcessUI.clearEnumerate(sheetId, this.oldEnumArea);
        this.bgTemProcessUI.setSign(sheetId, this.rowMap, this.colMap);
        this.bgTemProcessUI.setCellEnumerate(sheetId, this.kDTEnumArea.getText(), newEnum, this.oldEnumArea);
        this.bgTemProcessUI.setEnumerateArea(this.enumMap);
        this.getUIWindow().close();
    }

    private boolean verifyEnumArea(HashMap newEnum) {
        ArrayList enumCollArea = new ArrayList();
        if (this.getEnumCollArea(enumCollArea)) {
            // empty if block
        }
        HashMap enumItemArea = new HashMap();
        this.getEnumItemArea(enumItemArea);
        if (enumItemArea == null || enumItemArea.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgEnumerateResource", (String)"itemAreaError"));
            return true;
        }
        String key = null;
        String enumAreaStr = "";
        enumAreaStr = this.kDTEnumArea.getText();
        ITableForPrint.IBlock enumBlock = BgEnumerateHelper.creatBlock(enumAreaStr);
        if (enumBlock == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgEnumerateResource", (String)"enumAreaError"));
            return true;
        }
        Row beginRow = this.sheet.getRow(enumBlock.getRow(), true);
        Column beginCol = this.sheet.getColumn(enumBlock.getCol(), true);
        this.addSignWithRowAndCol(beginRow, beginCol);
        Row endRow = this.sheet.getRow(enumBlock.getRow2(), true);
        Column endCol = this.sheet.getColumn(enumBlock.getCol2(), true);
        this.addSignWithRowAndCol(endRow, endCol);
        key = BgNFSHelper.getRowSign(this.sheet.getRow(enumBlock.getRow(), false)) + BgNFSHelper.getColSign(this.sheet.getColumn(enumBlock.getCol(), false));
        HashMap<String, Object> enumArea = new HashMap<String, Object>();
        enumArea.put("AreaRowId", BgNFSHelper.getRowSign(this.sheet.getRow(enumBlock.getRow(), false)));
        enumArea.put("AreaColId", BgNFSHelper.getColSign(this.sheet.getColumn(enumBlock.getCol(), false)));
        enumArea.put("AreaRow1Id", BgNFSHelper.getRowSign(this.sheet.getRow(enumBlock.getRow2(), false)));
        enumArea.put("AreaCol1Id", BgNFSHelper.getColSign(this.sheet.getColumn(enumBlock.getCol2(), false)));
        enumArea.put("EnumItemArea", enumItemArea);
        enumArea.put("EnumCollArea", enumCollArea);
        newEnum.put(key, enumArea);
        return false;
    }

    private void addSignWithRowAndCol(Row beginRow, Column beginCol) {
        String rSign = null;
        if (!BgNFSHelper.checkHasSign(beginRow)) {
            rSign = BOSUuid.create((String)"BBBCCAAA").toString();
            BgNFSHelper.setRowSign(beginRow, rSign);
            this.rowMap.put(new Integer(beginRow.getRow()), rSign);
        }
        String cSign = null;
        if (!BgNFSHelper.checkHasSign(beginCol)) {
            cSign = BOSUuid.create((String)"BBBCCAAA").toString();
            BgNFSHelper.setColSign(beginCol, cSign);
            this.colMap.put(new Integer(beginCol.getCol()), cSign);
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    protected void tblItem_editStopped(KDTEditEvent e) throws Exception {
        if (e.getColIndex() == this.tblItem.getColumnIndex("item")) {
            ICell cell = this.tblItem.getCell(e.getRowIndex(), e.getColIndex());
            if (cell.getValue() != null && cell.getValue() instanceof Vector) {
                this.tblItem.getCell(e.getRowIndex(), "itemObject").setValue(cell.getValue());
                String str = ((Vector)cell.getValue()).get(0).toString();
                cell.setValue((Object)str);
            } else {
                this.tblItem.getCell(e.getRowIndex(), "itemObject").setValue(null);
            }
        }
    }

    private boolean getEnumCollArea(List enumCollArea) {
        HashMap<String, String> collArea = null;
        boolean isError = true;
        try {
            String area = null;
            ITableForPrint.IBlock collBlock = null;
            for (int i = 0; i < this.tblColl.getRowCount(); ++i) {
                collArea = new HashMap<String, String>();
                area = this.tblColl.getRow(i).getCell(0).getValue().toString();
                if (area == null || (collBlock = BgEnumerateHelper.creatBlock(area)).toString() == null) continue;
                Row beginRow = this.sheet.getRow(collBlock.getRow(), true);
                Column beginCol = this.sheet.getColumn(collBlock.getCol(), true);
                this.addSignWithRowAndCol(beginRow, beginCol);
                Row endRow = this.sheet.getRow(collBlock.getRow2(), true);
                Column endCol = this.sheet.getColumn(collBlock.getCol2(), true);
                this.addSignWithRowAndCol(endRow, endCol);
                collArea.put("AreaRowId", BgNFSHelper.getRowSign(this.sheet.getRow(collBlock.getRow(), false)));
                collArea.put("AreaColId", BgNFSHelper.getColSign(this.sheet.getColumn(collBlock.getCol(), false)));
                collArea.put("AreaRow1Id", BgNFSHelper.getRowSign(this.sheet.getRow(collBlock.getRow2(), false)));
                collArea.put("AreaCol1Id", BgNFSHelper.getColSign(this.sheet.getColumn(collBlock.getCol2(), false)));
                enumCollArea.add(collArea);
                isError = false;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            SysUtil.abort();
        }
        return isError;
    }

    private boolean getEnumItemArea(Map enumItemArea) {
        HashMap<String, Object> itemAndGroup = null;
        boolean isSame = false;
        try {
            String itemAGroup = null;
            BgItemGroupInfo itemGroup = null;
            BgItemCollection coll = null;
            HashSet<String> itemS = null;
            String itemArea = null;
            ITableForPrint.IBlock itemBlock = null;
            Vector item = null;
            String key = null;
            HashMap hadArea = new HashMap();
            for (int i = 0; i < this.tblItem.getRowCount(); ++i) {
                itemAndGroup = new HashMap<String, Object>();
                itemArea = this.tblItem.getRow(i).getCell("itemArea").getValue().toString();
                if (itemArea == null || (itemBlock = BgEnumerateHelper.creatBlock(itemArea)).toString() == null) continue;
                key = BgNFSHelper.getRowSign(this.sheet.getRow(itemBlock.getRow(), false)) + BgNFSHelper.getColSign(this.sheet.getColumn(itemBlock.getCol(), false));
                if (hadArea.containsKey(key)) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgEnumerateResource", (String)"sameItemAreaError"));
                    isSame = true;
                    break;
                }
                hadArea.put(key, null);
                item = (Vector)this.tblItem.getRow(i).getCell("itemObject").getValue();
                if (item != null && !item.isEmpty()) {
                    itemAGroup = (String)item.get(0);
                    itemAndGroup.put("ItemAndGroup", itemAGroup);
                    itemGroup = (BgItemGroupInfo)item.get(1);
                    coll = item.size() >= 3 ? (BgItemCollection)item.get(2) : null;
                    itemAndGroup.put("BgItemGroup", itemGroup.getNumber());
                    itemS = new HashSet<String>();
                    for (int j = 0; coll != null && j < coll.size(); ++j) {
                        itemS.add(coll.get(j).getNumber());
                    }
                    if (!itemS.isEmpty()) {
                        itemAndGroup.put("BgItem", itemS);
                    }
                }
                Row beginRow = this.sheet.getRow(itemBlock.getRow(), true);
                Column beginCol = this.sheet.getColumn(itemBlock.getCol(), true);
                this.addSignWithRowAndCol(beginRow, beginCol);
                Row endRow = this.sheet.getRow(itemBlock.getRow2(), true);
                Column endCol = this.sheet.getColumn(itemBlock.getCol2(), true);
                this.addSignWithRowAndCol(endRow, endCol);
                itemAndGroup.put("AreaRowId", BgNFSHelper.getRowSign(this.sheet.getRow(itemBlock.getRow(), false)));
                itemAndGroup.put("AreaColId", BgNFSHelper.getColSign(this.sheet.getColumn(itemBlock.getCol(), false)));
                itemAndGroup.put("AreaRow1Id", BgNFSHelper.getRowSign(this.sheet.getRow(itemBlock.getRow2(), false)));
                itemAndGroup.put("AreaCol1Id", BgNFSHelper.getColSign(this.sheet.getColumn(itemBlock.getCol2(), false)));
                enumItemArea.put(key, itemAndGroup);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (isSame) {
            SysUtil.abort();
        }
        return false;
    }
}

