/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgUpgradeFacadeFactory;
import com.kingdee.eas.ma.nbudget.IBgUpgradeFacade;
import com.kingdee.eas.ma.nbudget.client.AbstractBgUpgradeUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFormListUI;
import com.kingdee.eas.ma.nbudget.client.BgNTemplateListUI;
import com.kingdee.eas.ma.nbudget.client.ExcelFileFilter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgUpgradeUI
extends AbstractBgUpgradeUI {
    private static final long serialVersionUID = 5546170366978996358L;
    private static final Logger logger = CoreUIObject.getLogger(BgUpgradeUI.class);
    private static String kdf_magic = "###PACKER4.0.1###";
    private static String kds_magic = "###KDSpread1.0###";
    private ICoreBase ibizInterface = null;
    private List ids = null;

    public void onLoad() throws Exception {
        super.onLoad();
        Object obj = this.getUIContext().get("IDS");
        if (obj != null && obj instanceof List) {
            this.ids = (List)obj;
        }
        if ((obj = this.getUIContext().get("Owner")) != null) {
            if (obj instanceof BgNFormListUI) {
                this.ibizInterface = this.getFormInterface();
            } else if (obj instanceof BgNTemplateListUI) {
                this.ibizInterface = this.getTemplateInterface();
            }
        }
        this.initData();
    }

    protected IBgUpgradeFacade getInterface() throws Exception {
        return BgUpgradeFacadeFactory.getRemoteInstance();
    }

    protected IBgForm getFormInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    protected IBgTemplate getTemplateInterface() throws Exception {
        return BgTemplateFactory.getRemoteInstance();
    }

    protected void initData() throws Exception {
        HashSet idsSet = new HashSet();
        int size = this.ids.size();
        for (int index = 0; index < size; ++index) {
            idsSet.add(this.ids.get(index));
        }
        this.loadData(idsSet);
    }

    protected void loadData(Set idsSet) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idsSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add("id");
        view.getSelector().add("name");
        view.getSelector().add("number");
        view.getSelector().add("data");
        IRow row = null;
        String id = null;
        String name = null;
        String number = null;
        byte[] data = null;
        IObjectValue model2 = null;
        CoreBaseCollection cbc = this.ibizInterface.getCollection(view);
        this.tblMain.setRefresh(false);
        this.tblMain.checkParsed(true);
        this.tblMain.removeRows();
        if (cbc != null && !cbc.isEmpty()) {
            for (IObjectValue model2 : cbc) {
                id = model2.get("id").toString();
                name = model2.get("name").toString();
                number = model2.get("number").toString();
                data = (byte[])model2.get("data");
                row = this.tblMain.addRow();
                row.getCell(2).setValue((Object)id);
                row.getCell(3).setValue((Object)number);
                row.getCell(4).setValue((Object)name);
                row.getCell(6).setValue((Object)(id + ".bin"));
                row.setUserObject((Object)model2);
                this.checkFormat(row, data);
            }
        }
        this.tblMain.setRefresh(true);
    }

    @Override
    protected void btnSelectDir_actionPerformed(ActionEvent e) throws Exception {
        String path = this.txtBackupDir.getText();
        KDFileChooser fc = new KDFileChooser();
        fc.setFileSelectionMode(1);
        fc.setDialogTitle(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "export"));
        fc.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        fc.setCurrentDirectory(new File(path));
        if (fc.showSaveDialog((Component)((Object)this)) == 0) {
            File file = fc.getSelectedFile();
            this.txtBackupDir.setText(file.getPath());
        }
    }

    @Override
    protected void btnUpgrade_actionPerformed(ActionEvent e) throws Exception {
        if (this.chkBackup.isSelected()) {
            this.verify();
        }
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                IRow row = null;
                IObjectValue model = null;
                boolean isBackup = BgUpgradeUI.this.chkBackup.isSelected();
                String billId = null;
                String folder = BgUpgradeUI.this.txtBackupDir.getText();
                byte[] data = null;
                IBgUpgradeFacade ibgUpgradeFacade = BgUpgradeFacadeFactory.getRemoteInstance();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("name");
                sic.add("number");
                sic.add("data");
                int size = BgUpgradeUI.this.tblMain.getRowCount();
                for (int index = 0; index < size; ++index) {
                    row = BgUpgradeUI.this.tblMain.getRow(index);
                    if (!((Boolean)row.getCell(0).getValue()).booleanValue() || ((Boolean)row.getCell(1).getUserObject()).booleanValue()) continue;
                    model = (IObjectValue)row.getUserObject();
                    billId = model.get("id").toString();
                    data = model.getBytes("data");
                    if (isBackup) {
                        BgAnalyseHelper.saveToFile((String)(folder + File.separator + billId + ".bin"), (byte[])data, (int)4096);
                    }
                    ibgUpgradeFacade.upgradeModelInfo(billId);
                    model = BgUpgradeUI.this.ibizInterface.getValue((IObjectPK)new ObjectUuidPK(billId), sic);
                    row.setUserObject((Object)model);
                    data = model.getBytes("data");
                    BgUpgradeUI.this.checkFormat(row, data);
                }
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
    }

    @Override
    protected void btnRecover_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                IRow row = null;
                IObjectValue model = null;
                File file = null;
                String billId = null;
                String filepath = null;
                String folder = BgUpgradeUI.this.txtBackupDir.getText();
                byte[] data = null;
                IBgUpgradeFacade ibgUpgradeFacade = BgUpgradeFacadeFactory.getRemoteInstance();
                int size = BgUpgradeUI.this.tblMain.getRowCount();
                for (int index = 0; index < size; ++index) {
                    row = BgUpgradeUI.this.tblMain.getRow(index);
                    if (!((Boolean)row.getCell(0).getValue()).booleanValue() || !((Boolean)row.getCell(1).getUserObject()).booleanValue()) continue;
                    model = (IObjectValue)row.getUserObject();
                    billId = model.get("id").toString();
                    filepath = folder + File.separator + billId + ".bin";
                    file = new File(filepath);
                    if (file == null || !file.isFile()) continue;
                    data = BgAnalyseHelper.loadFormFile((String)filepath);
                    model.setBytes("data", data);
                    ibgUpgradeFacade.recoverModelInfo(model);
                    row.setUserObject((Object)model);
                    BgUpgradeUI.this.checkFormat(row, data);
                }
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
    }

    @Override
    protected void btnAuto_actionPerformed(ActionEvent e) throws Exception {
        IRow row = null;
        int size = this.tblMain.getRowCount();
        for (int index = 0; index < size; ++index) {
            row = this.tblMain.getRow(index);
            if (((Boolean)row.getCell(1).getUserObject()).booleanValue()) {
                row.getCell(0).setValue((Object)Boolean.FALSE);
                continue;
            }
            row.getCell(0).setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    protected void btnAntonym_actionPerformed(ActionEvent e) throws Exception {
        IRow row = null;
        int size = this.tblMain.getRowCount();
        for (int index = 0; index < size; ++index) {
            row = this.tblMain.getRow(index);
            if (((Boolean)row.getCell(0).getValue()).booleanValue()) {
                row.getCell(0).setValue((Object)Boolean.FALSE);
                continue;
            }
            row.getCell(0).setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        int size = this.tblMain.getRowCount();
        for (int index = 0; index < size; ++index) {
            this.tblMain.getRow(index).getCell(0).setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    protected void btnClear_actionPerformed(ActionEvent e) throws Exception {
        int size = this.tblMain.getRowCount();
        for (int index = 0; index < size; ++index) {
            this.tblMain.getRow(index).getCell(0).setValue((Object)Boolean.FALSE);
        }
    }

    protected void verify() throws Exception {
        if (StringUtils.isEmpty((String)this.txtBackupDir.getText())) {
            this.txtBackupDir.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "selectFilepath"));
            SysUtil.abort();
        } else {
            File file = new File(this.txtBackupDir.getText());
            if (!file.isDirectory()) {
                this.txtBackupDir.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "errorFilepath"));
                SysUtil.abort();
            }
        }
    }

    protected void checkFormat(IRow row, byte[] data) {
        if (data == null || data.length < 17) {
            row.getCell(1).setValue((Object)"Unknow");
            row.getCell(5).setValue((Object)"0KB");
            return;
        }
        int size = data.length;
        String magic_str = new String(data, 0, 17);
        if (magic_str.equalsIgnoreCase(kdf_magic)) {
            row.getCell(0).setValue((Object)Boolean.FALSE);
            row.getCell(1).setValue((Object)"KDF");
            row.getCell(1).setUserObject((Object)Boolean.FALSE);
            row.getStyleAttributes().setBackground(Color.WHITE);
        } else if (magic_str.equalsIgnoreCase(kds_magic)) {
            row.getCell(0).setValue((Object)Boolean.FALSE);
            row.getCell(1).setValue((Object)"KDS");
            row.getCell(1).setUserObject((Object)Boolean.TRUE);
            row.getStyleAttributes().setBackground(new Color(230, 230, 230));
        } else {
            row.getCell(1).setValue((Object)"Unknow");
        }
        row.getCell(5).setValue((Object)(size / 1024 + "KB"));
    }
}

