/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.BookDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.newrpt.SpreadHelper;
import com.kingdee.eas.fi.newrpt.client.designer.io.WizzardIO;
import com.kingdee.eas.fi.newrpt.client.designer.render.DefaultItemRenderProvider;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgGatherFacadeFactory;
import com.kingdee.eas.ma.budget.BgGatherHelper;
import com.kingdee.eas.ma.budget.IBgGatherFacade;
import com.kingdee.eas.ma.budget.client.BgEnumerateRender;
import com.kingdee.eas.ma.nbudget.BgExportHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNEnumGatherInfo;
import com.kingdee.eas.ma.nbudget.BgNEnumItemInfo;
import com.kingdee.eas.ma.nbudget.BgNEnumerateHelper;
import com.kingdee.eas.ma.nbudget.BgNEnumerateInfo;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNFormException;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.BudgetDisplayValueProvider;
import com.kingdee.eas.ma.nbudget.client.AbstractBgViewGatherUI;
import com.kingdee.eas.ma.nbudget.client.BgNActualRecordProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFormActualProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgNFormProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgUserCellDisplayProvider;
import com.kingdee.eas.ma.nbudget.client.BudgetCourseProvider;
import com.kingdee.eas.ma.nbudget.client.Excel2007FileFilter;
import com.kingdee.eas.ma.nbudget.client.ExcelFileFilter;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgViewGatherUI
extends AbstractBgViewGatherUI {
    private static final long serialVersionUID = 2646536436610660105L;
    private static final Logger logger = CoreUIObject.getLogger(BgViewGatherUI.class);
    private Map measureUnitMap = null;
    private Map currencyMap = null;
    private Map formulaMap = null;
    private String HAS_REMOVE = "HAS_REMOVE";
    private int VIEW_MODE = 0;
    private boolean hasBudget = true;
    private boolean hasTmpData = false;
    private Map orgUnitMap = null;
    private List orgUnitSort = null;
    private Map bgSchemeMap = null;
    private Map bgFormIdsMap = null;
    private KDFileChooser fc = null;
    private String name = null;

    @Override
    public void onShow() throws Exception {
        super.onShow();
        Book book = this.getBook();
        for (int i = book.getSheetCount() - 1; i >= 0; --i) {
            book.getISheet(i).setSelected(false);
        }
        book.activeSheet(0);
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.initView();
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
    }

    protected void initView() throws Exception {
        Object _obj = null;
        _obj = this.getUIContext().get("Owner");
        this.VIEW_MODE = 0;
        if (_obj != null) {
            if (_obj instanceof BgNFormProcessUI) {
                this.VIEW_MODE = 0;
            } else if (_obj instanceof BgNFormActualProcessUI) {
                this.VIEW_MODE = 1;
            } else if (_obj instanceof BgNActualRecordProcessUI) {
                this.VIEW_MODE = 2;
            }
        }
        if ((_obj = this.getUIContext().get("GATHER_VIEW")) != null) {
            if ("GATHER_VIEW_COMPANY".equals(_obj)) {
                this.viewCompany();
            } else if ("GATHER_VIEW_CI".equals(_obj)) {
                this.viewCI();
            } else if ("GATHER_VIEW_IC".equals(_obj)) {
                this.viewIC();
            }
        }
    }

    @Override
    protected void initBook() throws Exception {
        super.initBook();
        Object _obj = null;
        _obj = this.getUIContext().get("GATHER_DATA_TYPE");
        if (_obj != null && _obj instanceof Boolean) {
            if (((Boolean)_obj).booleanValue()) {
                this.setHasBudget(true);
            } else {
                this.setHasBudget(false);
            }
        }
        if ((_obj = this.getUIContext().get("IS_GATHER_ADJUST")) != null && _obj instanceof Boolean) {
            if (((Boolean)_obj).booleanValue()) {
                this.setHasTmpData(true);
            } else {
                this.setHasTmpData(false);
            }
        }
        if ((_obj = this.getUIContext().get("BGFORM_INFO")) != null && _obj instanceof BgFormInfo) {
            this.setEditData(_obj);
        }
        if ((_obj = this.getUIContext().get("MEASUREUNIT_INFO")) != null && _obj instanceof Map) {
            this.getMeasureUnitMap().putAll(_obj);
        }
        if ((_obj = this.getUIContext().get("CURRENCY_INFO")) != null && _obj instanceof Map) {
            this.getCurrencyMap().putAll(_obj);
        }
        if ((_obj = this.getUIContext().get("FORMULA_INFO")) != null && _obj instanceof Map) {
            this.getFormulaMap().putAll(_obj);
        }
        if ((_obj = this.getUIContext().get("GATHER_ORGUNIT")) != null && _obj instanceof Map) {
            this.getOrgUnitMap().putAll(_obj);
        }
        if ((_obj = this.getUIContext().get("GATHER_ORGUNIT_SORT")) != null && _obj instanceof List) {
            this.getOrgUnitSort().addAll(_obj);
        }
        if ((_obj = this.getUIContext().get("GATHER_SCHEME")) != null && _obj instanceof Map) {
            this.getBgSchemeMap().putAll(_obj);
        }
        if ((_obj = this.getUIContext().get("GATHER_BGFORM")) != null && _obj instanceof Map) {
            this.getBgFormIdsMap().putAll(_obj);
        }
        BgNFSHelper.disableUndo(this.getBook());
        BgNFSHelper.disableCal(this.getBook());
        BgNFSHelper.setBookLANDP(this.getBook(), false, null, null);
    }

    private KDComboBox getKDComboBox(JComponent component) {
        KDComboBox comboBox = null;
        if (component != null && component.getComponents() != null) {
            for (int i = 0; i < component.getComponentCount(); ++i) {
                if (component.getComponent(i) instanceof KDComboBox) {
                    if (i != 3) continue;
                    return (KDComboBox)component.getComponent(i);
                }
                if (!(component.getComponent(i) instanceof JPanel) || (comboBox = this.getKDComboBox((JComponent)component.getComponent(i))) == null) continue;
                return comboBox;
            }
        }
        return null;
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        this.fc = new KDFileChooser();
        this.fc.setDialogTitle(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "fileExport"));
        this.fc.addChoosableFileFilter((FileFilter)new Excel2007FileFilter());
        this.fc.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        this.fc.setAcceptAllFileFilterUsed(false);
        this.name = (String)this.getEditData().get("name");
        this.fc.setSelectedFile(new File(BgExportHelper.getDefaultDirtory() + "//" + this.name.toString().trim() + ".xls"));
        KDComboBox comBox = this.getKDComboBox((JComponent)this.fc);
        if (comBox != null) {
            comBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (BgViewGatherUI.this.fc.getFileFilter() instanceof ExcelFileFilter) {
                        BgViewGatherUI.this.fc.setSelectedFile(new File(BgExportHelper.getDefaultDirtory() + "//" + BgViewGatherUI.this.getEditData().get("name").toString().trim() + ".xls"));
                    } else if (BgViewGatherUI.this.fc.getFileFilter() instanceof Excel2007FileFilter) {
                        BgViewGatherUI.this.fc.setSelectedFile(new File(BgExportHelper.getDefaultDirtory() + "//" + BgViewGatherUI.this.getEditData().get("name").toString().trim() + ".xlsx"));
                    }
                }
            });
        }
        if (this.fc.showSaveDialog((Component)((Object)this)) == 0) {
            int re;
            FileFilter filter = this.fc.getFileFilter();
            File file = this.fc.getSelectedFile();
            if (filter instanceof ExcelFileFilter) {
                if (file.getName().indexOf(".") == -1) {
                    file = new File(this.fc.getSelectedFile() + ".xls");
                }
                if (file != null) {
                    if (file.exists()) {
                        re = MsgBox.showConfirm3((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "existsFile"));
                        if (re == 1 || re == 2) {
                            return;
                        }
                        file.delete();
                    }
                    try {
                        this.exportBook(file);
                    }
                    catch (Exception ex) {
                        logger.error((Object)"budget error:", (Throwable)ex);
                        throw new BgNFormException(BgNFormException.FILEEXPORTERROR);
                    }
                }
            } else if (filter instanceof Excel2007FileFilter) {
                if (file.getName().indexOf(".") == -1) {
                    file = new File(this.fc.getSelectedFile() + ".xlsx");
                }
                if (file != null) {
                    if (file.exists()) {
                        re = MsgBox.showConfirm3((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "existsFile"));
                        if (re == 1 || re == 2) {
                            return;
                        }
                        file.delete();
                    }
                    try {
                        this.exportToExcel2007(this.getBook(), file.getPath());
                    }
                    catch (Exception ex) {
                        throw new BgNFormException(BgNFormException.FILEEXPORTERROR);
                    }
                }
            }
            String exportSuccess = EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgFormImportAndExportResource", (String)"exportSucceed");
            MsgBox.showInfo((String)exportSuccess);
        }
    }

    private void exportBook(File file) throws BOSException {
        if (this.getBgFormInfo() == null) {
            throw new BOSException("Object is null!");
        }
        Book _book = this.getBook();
        String _filename = file.getPath();
        BigDecimal _coefficient = this.getBgFormInfo().getMeasureUnit() != null ? this.getBgFormInfo().getMeasureUnit().getCoefficient() : BgNConstants.ONE;
        HashMap<String, Object> _parameter = new HashMap<String, Object>();
        _parameter.put("EXPORT_BOOK", _book);
        _parameter.put("EXPORT_COEFFICIENT", _coefficient);
        _parameter.put("EXPORT_MEASUREUNIT", this.getMeasureUnitMap());
        _parameter.put("EXPORT_BGFORMULA", this.getFormulaMap());
        _parameter.put("EXPORT_DATA", new Boolean(true));
        KDSBook _kdsBook = BgNFCHelper.exportExcel(_parameter);
        ExportManager em = new ExportManager();
        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"true");
        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
        em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"false");
        em.exportToExcel(_kdsBook, _filename);
    }

    private boolean exportToExcel2007(Book book, String fileName) throws BOSException {
        if (this.getBgFormInfo() == null) {
            throw new BOSException("Object is null!");
        }
        String[] sns = new String[book.getSheetCount()];
        for (int i = 0; i < book.getSheetCount(); ++i) {
            sns[i] = book.getSheetName(i);
        }
        if (sns.length == 0) {
            WindowUtil.msgboxError((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"26_WizzardIO"), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this.getSC());
            return false;
        }
        try {
            Book tempBook = SpreadHelper.copyBook((Book)book);
            HashMap<String, Object> _parameter = new HashMap<String, Object>();
            BigDecimal _coefficient = this.getBgFormInfo().getMeasureUnit() != null ? this.getBgFormInfo().getMeasureUnit().getCoefficient() : BgNConstants.ONE;
            _parameter.put("EXPORT_BOOK", tempBook);
            _parameter.put("EXPORT_COEFFICIENT", _coefficient);
            _parameter.put("EXPORT_MEASUREUNIT", this.getMeasureUnitMap());
            _parameter.put("EXPORT_BGFORMULA", this.getFormulaMap());
            _parameter.put("EXPORT_DATA", new Boolean(true));
            Book _book = BgNFCHelper.exportExcel2007(_parameter);
            BookDataWrapper bookDataWrapper = new BookDataWrapper(_book);
            bookDataWrapper.setExportFormula(false);
            bookDataWrapper.setExportCustomerFomulas(true);
            bookDataWrapper.setShowValue(true);
            bookDataWrapper.setExportHideCols(true);
            bookDataWrapper.setExportHideRows(true);
            SXSSFExportWrapper booksc = new SXSSFExportWrapper((AbstractDataWrapper)bookDataWrapper);
            booksc.write(fileName);
            return true;
        }
        catch (Exception e) {
            WindowUtil.msgboxError((Object)e.getCause().getMessage(), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this.getSC());
            return false;
        }
    }

    private String getLocalText(String key) {
        return LanguageManager.getLangMessage((String)key, WizzardIO.class, (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"23_WizzardIO"));
    }

    private BgFormInfo getBgFormInfo() {
        if (this.getEditData() instanceof BgFormInfo) {
            return (BgFormInfo)this.getEditData();
        }
        return null;
    }

    protected IBgGatherFacade getGatherInterface() throws Exception {
        return BgGatherFacadeFactory.getRemoteInstance();
    }

    public boolean isHasBudget() {
        return this.hasBudget;
    }

    public void setHasBudget(boolean hasBudget) {
        this.hasBudget = hasBudget;
    }

    public boolean isHasTmpData() {
        return this.hasTmpData;
    }

    public void setHasTmpData(boolean hasTmpData) {
        this.hasTmpData = hasTmpData;
    }

    public void setMeasureUnitMap(Map measureUnitMap) {
        this.measureUnitMap = measureUnitMap;
    }

    public Map getMeasureUnitMap() {
        if (this.measureUnitMap == null) {
            this.measureUnitMap = new HashMap();
        }
        return this.measureUnitMap;
    }

    public void setCurrencyMap(Map currencyMap) {
        this.currencyMap = currencyMap;
    }

    public Map getCurrencyMap() {
        if (this.currencyMap == null) {
            this.currencyMap = new HashMap();
        }
        return this.currencyMap;
    }

    public void setFormulaMap(Map formulaMap) {
        this.formulaMap = formulaMap;
    }

    public Map getFormulaMap() {
        if (this.formulaMap == null) {
            this.formulaMap = new HashMap();
        }
        return this.formulaMap;
    }

    public void setOrgUnitMap(Map orgUnitMap) {
        this.orgUnitMap = orgUnitMap;
    }

    public Map getOrgUnitMap() {
        if (this.orgUnitMap == null) {
            this.orgUnitMap = new HashMap();
        }
        return this.orgUnitMap;
    }

    public void setOrgUnitSort(List orgUnitSort) {
        this.orgUnitSort = orgUnitSort;
    }

    public List getOrgUnitSort() {
        if (this.orgUnitSort == null) {
            this.orgUnitSort = new ArrayList();
        }
        return this.orgUnitSort;
    }

    public void setBgSchemeMap(Map bgSchemeMap) {
        this.bgSchemeMap = bgSchemeMap;
    }

    public Map getBgSchemeMap() {
        if (this.bgSchemeMap == null) {
            this.bgSchemeMap = new HashMap();
        }
        return this.bgSchemeMap;
    }

    public void setBgFormIdsMap(Map bgFormIdsMap) {
        this.bgFormIdsMap = bgFormIdsMap;
    }

    public Map getBgFormIdsMap() {
        if (this.bgFormIdsMap == null) {
            this.bgFormIdsMap = new HashMap();
        }
        return this.bgFormIdsMap;
    }

    @Override
    protected ICellDisplayProvider getCellDisplayRender() {
        BgUserCellDisplayProvider render = new BgUserCellDisplayProvider();
        render.setDisplayValueProvider(new BudgetDisplayValueProvider((Component)((Object)this)));
        BgUserCellDisplayProvider.addRenderProvider((IRenderProvider)new DefaultItemRenderProvider());
        BgUserCellDisplayProvider.addRenderProvider(new BudgetCourseProvider());
        BgUserCellDisplayProvider.addRenderProvider((IRenderProvider)new BgEnumerateRender());
        return render;
    }

    protected void viewCompany() throws Exception {
        Book _book = null;
        Map _enumMap = null;
        Map _columnMap = null;
        Map _valueMap = null;
        _book = this.getBook();
        _enumMap = (Map)BgNEnumerateHelper.getBgEnumInfo(_book);
        if (this.getOrgUnitSort().isEmpty()) {
            this.getOrgUnitSort().addAll(this.getOrgUnitMap().keySet());
        }
        if (this.getOrgUnitSort().isEmpty()) {
            return;
        }
        _columnMap = this.queryOrgUnitInfo(_book, _enumMap);
        if (!_columnMap.isEmpty()) {
            _valueMap = this.getGatherInterface().queryGatherValue(this.getBgSchemeMap(), _columnMap, this.VIEW_MODE, this.hasTmpData);
            this.fillCompanyValue(_book, _enumMap, _valueMap);
        }
    }

    private Map queryOrgUnitInfo(Book book, Map enumMap) {
        HashMap _columnMap = new HashMap();
        if (book == null || enumMap == null) {
            return _columnMap;
        }
        Sheet _sheet = null;
        Cell _cell = null;
        List _enumsList = null;
        List _enumsItemList = null;
        List _enumsGatherList = null;
        List<String> _formulaList = null;
        BgNEnumerateInfo _enumInfo = null;
        BgNEnumGatherInfo _enumGatherInfo = null;
        BgNEnumItemInfo _enumItemInfo = null;
        Rectangle _rect = null;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        String _formulaStr = null;
        String _key = null;
        int count = book.getSheetCount();
        for (int index = 0; index < count; ++index) {
            _sheet = book.getSheet(index);
            _enumsList = BgNEnumerateHelper.getBgEnumInfo(_sheet.getID(), enumMap);
            if (_enumsList == null) continue;
            int in = _enumsList.size();
            for (int i = 0; i < in; ++i) {
                _enumInfo = (BgNEnumerateInfo)_enumsList.get(i);
                _enumsItemList = _enumInfo.getBgItemEnumInfo();
                _enumsGatherList = _enumInfo.getGatherEnumInfo();
                this.clearMerge(_sheet, _enumsGatherList);
                if (_enumsGatherList != null) {
                    int jn = _enumsGatherList.size();
                    for (int j = 0; j < jn; ++j) {
                        _enumGatherInfo = (BgNEnumGatherInfo)_enumsGatherList.get(j);
                        _rect = BgNEnumerateHelper.getEnumArea(_sheet, _enumGatherInfo);
                        rowCount = _rect.height;
                        colCount = _rect.width;
                        for (colIndex = _rect.y; colIndex <= colCount; ++colIndex) {
                            for (rowIndex = _rect.x; rowIndex <= rowCount; ++rowIndex) {
                                _cell = _sheet.getCell(rowIndex, colIndex, false);
                                if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                                _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                                _key = new StringBuffer(_sheet.getID()).append("_").append(_enumGatherInfo.getRowBeginId()).append("_").append(_enumGatherInfo.getColBegInId()).append("_").append(String.valueOf(colIndex)).toString();
                                if (_columnMap.containsKey(_key)) {
                                    _formulaList = (List)_columnMap.get(_key);
                                } else {
                                    _formulaList = new ArrayList();
                                    _columnMap.put(_key, _formulaList);
                                }
                                _formulaList.add(_formulaStr);
                            }
                        }
                    }
                }
                BgGatherHelper.removeAreaData((Sheet)_sheet, (BgNEnumerateInfo)_enumInfo);
                if (_enumsItemList == null) continue;
                int tn = _enumsItemList.size();
                for (int t = 0; t < tn; ++t) {
                    _enumItemInfo = (BgNEnumItemInfo)_enumsItemList.get(t);
                    this.fillOrgUnitInfo(_sheet, _enumItemInfo, _enumsGatherList);
                }
            }
        }
        return _columnMap;
    }

    private void fillOrgUnitInfo(Sheet sheet, BgNEnumItemInfo enumInfo, List enumGatherList) {
        if (sheet == null || enumInfo == null || enumGatherList == null) {
            return;
        }
        Row _row = null;
        Cell _cell = null;
        BgNEnumGatherInfo _enumGatherInfo = null;
        Rectangle _rect = null;
        Rectangle _gRect = null;
        String _orgUnitId = null;
        String _orgUnitName = null;
        int in = enumGatherList.size();
        for (int i = 0; i < in; ++i) {
            _enumGatherInfo = (BgNEnumGatherInfo)enumGatherList.get(i);
            _rect = BgNEnumerateHelper.getEnumArea(sheet, enumInfo);
            _gRect = BgNEnumerateHelper.getEnumArea(sheet, _enumGatherInfo);
            _gRect.x = _gRect.x >= _rect.x ? _gRect.x : _rect.x;
            int n = _gRect.height = _gRect.height <= _rect.height ? _gRect.height : _rect.height;
            if (_gRect.height - _gRect.x < 1) continue;
            int jn = this.getOrgUnitSort().size();
            for (int j = 0; j < jn; ++j) {
                _orgUnitId = (String)this.getOrgUnitSort().get(j);
                _orgUnitName = (String)this.getOrgUnitMap().get(_orgUnitId);
                _row = BgGatherHelper.getLastUpdataRow((Sheet)sheet, (Rectangle)_gRect);
                _cell = _row.getCell(_rect.y, true);
                BgNFSHelper.setValue(_cell, _orgUnitName);
                BgNFSHelper.setUserObject(_cell, "ORGUNIT_ID", _orgUnitId);
            }
        }
    }

    private void fillCompanyValue(Book book, Map enumMap, Map valueMap) {
        if (book == null || enumMap == null || valueMap == null) {
            return;
        }
        Sheet _sheet = null;
        Row _row = null;
        Cell _cell = null;
        List _enumsList = null;
        List _enumGatherList = null;
        List _enumItemList = null;
        HashSet<Integer> _columnSet = new HashSet<Integer>();
        BgNEnumerateInfo _enumInfo = null;
        BgNEnumItemInfo _enumItemInfo = null;
        BgNEnumGatherInfo _enumGatherInfo = null;
        Rectangle _rect = null;
        Rectangle _gRect = null;
        Object _obj = null;
        String _orgUnitId = null;
        String _key = null;
        BigDecimal _value = null;
        BigDecimal _tmpValue = null;
        int count = book.getSheetCount();
        for (int index = 0; index < count; ++index) {
            _sheet = book.getSheet(index);
            int maxCol = _sheet.getMaxColIndex();
            _enumsList = BgNEnumerateHelper.getBgEnumInfo(_sheet.getID(), enumMap);
            if (_enumsList == null) continue;
            int in = _enumsList.size();
            for (int i = 0; i < in; ++i) {
                int rowIndex;
                int j;
                int jn;
                _enumInfo = (BgNEnumerateInfo)_enumsList.get(i);
                if (_enumInfo == null) continue;
                _columnSet.clear();
                _enumGatherList = _enumInfo.getGatherEnumInfo();
                _enumItemList = _enumInfo.getBgItemEnumInfo();
                if (_enumItemList != null) {
                    jn = _enumItemList.size();
                    for (j = 0; j < jn; ++j) {
                        _enumItemInfo = (BgNEnumItemInfo)_enumItemList.get(j);
                        _rect = BgNEnumerateHelper.getEnumArea(_sheet, _enumItemInfo);
                        int colCount = _rect.y;
                        for (int colIndex = _rect.y; colIndex <= colCount; ++colIndex) {
                            _columnSet.add(new Integer(colIndex));
                        }
                    }
                }
                if (_enumGatherList == null) continue;
                _rect = BgNEnumerateHelper.getEnumArea(_sheet, _enumInfo);
                jn = _enumGatherList.size();
                for (j = 0; j < jn; ++j) {
                    _enumGatherInfo = (BgNEnumGatherInfo)_enumGatherList.get(j);
                    _gRect = BgNEnumerateHelper.getEnumArea(_sheet, _enumGatherInfo);
                    rowIndex = _gRect.x;
                    int rowCount = _gRect.height;
                    int colIndex = _gRect.y;
                    int colCount = _gRect.width;
                    for (colIndex = _gRect.y; colIndex <= colCount; ++colIndex) {
                        for (rowIndex = _gRect.x; rowIndex <= rowCount; ++rowIndex) {
                            _cell = _sheet.getCell(rowIndex, _rect.y, false);
                            _orgUnitId = _cell != null ? (String)_cell.getUserObjectValue("ORGUNIT_ID") : null;
                            if (_columnSet.contains(new Integer(colIndex)) || StringUtils.isEmpty((String)_orgUnitId)) continue;
                            _cell = _sheet.getCell(rowIndex, colIndex, true);
                            _key = new StringBuffer(_orgUnitId).append("_").append(_sheet.getID()).append("_").append(_enumGatherInfo.getRowBeginId()).append("_").append(_enumGatherInfo.getColBegInId()).append("_").append(String.valueOf(colIndex)).toString();
                            if (!valueMap.containsKey(_key)) continue;
                            _value = (BigDecimal)valueMap.get(_key);
                            BgNFSHelper.setValue(_cell, _value);
                            _cell = _sheet.getCell(_gRect.height, colIndex, true);
                            if (!BgNFSHelper.checkIsEmptyCell(_cell) && (_obj = BgNFSHelper.getValue(_cell)) != null) {
                                if (_obj instanceof BigDecimal) {
                                    _tmpValue = (BigDecimal)_obj;
                                } else {
                                    try {
                                        _tmpValue = new BigDecimal(_obj.toString());
                                    }
                                    catch (Exception ex) {
                                        _tmpValue = BgNConstants.ZERO;
                                    }
                                }
                                _value = _value.add(_tmpValue);
                            }
                            BgNFSHelper.setValue(_cell, _value);
                        }
                    }
                }
                jn = _enumGatherList.size();
                for (j = 0; j < jn; ++j) {
                    _enumGatherInfo = (BgNEnumGatherInfo)_enumGatherList.get(j);
                    _gRect = BgNEnumerateHelper.getEnumArea(_sheet, _enumGatherInfo);
                    rowIndex = _gRect.x;
                    int colIndex = _gRect.y;
                    for (colIndex = _gRect.y; colIndex <= _gRect.width; ++colIndex) {
                        _cell = _sheet.getCell(_gRect.height, colIndex, false);
                        BgGatherHelper.removeGatherSignCell((Cell)_cell);
                    }
                    for (rowIndex = _gRect.height - 1; rowIndex > _gRect.x; --rowIndex) {
                        _row = _sheet.getRow(rowIndex, false);
                        _cell = _sheet.getCell(rowIndex, _rect.y, false);
                        _orgUnitId = _cell != null ? (String)_cell.getUserObjectValue("ORGUNIT_ID") : null;
                        if (_orgUnitId != null || BgNFSHelper.checkHasEnumerateOfRow(_row, maxCol)) continue;
                        BgNFSHelper.removeRow(_sheet, rowIndex);
                    }
                }
            }
        }
    }

    protected void viewCI() throws Exception {
        Book _book = null;
        Map _enumMap = null;
        Map _valueMap = null;
        Set _querySet = null;
        _book = this.getBook();
        _enumMap = (Map)BgNEnumerateHelper.getBgEnumInfo(_book);
        if (this.getOrgUnitSort().isEmpty()) {
            this.getOrgUnitSort().addAll(this.getOrgUnitMap().keySet());
        }
        if (this.getOrgUnitSort().isEmpty()) {
            return;
        }
        _querySet = this.queryInfo(_book, _enumMap, true);
        if (!_querySet.isEmpty()) {
            _valueMap = this.getGatherInterface().queryGatherValue(this.getBgSchemeMap(), _querySet, this.VIEW_MODE, this.hasTmpData);
            this.fillCompanyAndItemValue(_book, _enumMap, _valueMap);
        }
        BgNSHelper.objClear(_valueMap);
        BgNSHelper.objClear(_querySet);
    }

    private Set queryInfo(Book book, Map enumMap, boolean view) {
        HashSet<String> _querySet = new HashSet<String>();
        if (book == null || enumMap == null) {
            return _querySet;
        }
        Sheet _sheet = null;
        Cell _cell = null;
        List _enumsList = null;
        List _enumsGatherList = null;
        BgNEnumerateInfo _enumInfo = null;
        BgNEnumGatherInfo _enumGatherInfo = null;
        Rectangle _rect = null;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        String _formulaStr = null;
        int count = book.getSheetCount();
        for (int index = 0; index < count; ++index) {
            _sheet = book.getSheet(index);
            _enumsList = BgNEnumerateHelper.getBgEnumInfo(_sheet.getID(), enumMap);
            if (_enumsList == null) continue;
            int in = _enumsList.size();
            for (int i = 0; i < in; ++i) {
                _enumInfo = (BgNEnumerateInfo)_enumsList.get(i);
                _enumsGatherList = _enumInfo.getGatherEnumInfo();
                this.clearMerge(_sheet, _enumsGatherList);
                if (_enumsGatherList == null) continue;
                int jn = _enumsGatherList.size();
                for (int j = 0; j < jn; ++j) {
                    _enumGatherInfo = (BgNEnumGatherInfo)_enumsGatherList.get(j);
                    _rect = BgNEnumerateHelper.getEnumArea(_sheet, _enumGatherInfo);
                    rowCount = _rect.height;
                    colCount = _rect.width;
                    for (colIndex = _rect.y; colIndex <= colCount; ++colIndex) {
                        for (rowIndex = _rect.x; rowIndex <= rowCount; ++rowIndex) {
                            _cell = _sheet.getCell(rowIndex, colIndex, false);
                            if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                            _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                            _querySet.add(_formulaStr);
                        }
                    }
                }
            }
        }
        return _querySet;
    }

    private void fillCompanyAndItemValue(Book book, Map enumMap, Map valueMap) {
        if (book == null || enumMap == null || valueMap == null) {
            return;
        }
        Sheet _sheet = null;
        Row _row = null;
        Row _tmpRow = null;
        Cell _cell = null;
        List _enumsList = null;
        List _enumGatherList = null;
        ArrayList _formulaList = new ArrayList();
        ArrayList<String> _bgItemList = new ArrayList<String>();
        Map _tmpMap = null;
        BgNEnumerateInfo _enumInfo = null;
        BgNEnumGatherInfo _enumGatherInfo = null;
        Rectangle _rect = null;
        Rectangle _gRect = null;
        int lastFormulaRowIndex = -1;
        int orgUnitSize = this.getOrgUnitSort().size();
        Object _obj = null;
        Integer _cKey = null;
        String _orgUnitId = null;
        String _orgUnitName = null;
        String _key = null;
        String _formulaStr = null;
        String _bgItemStr = null;
        BigDecimal _value = null;
        int count = book.getSheetCount();
        for (int index = 0; index < count; ++index) {
            int maxRow;
            _sheet = book.getSheet(index);
            _enumsList = BgNEnumerateHelper.getBgEnumInfo(_sheet.getID(), enumMap);
            if (_enumsList != null) {
                int in = _enumsList.size();
                for (int i = 0; i < in; ++i) {
                    _enumInfo = (BgNEnumerateInfo)_enumsList.get(i);
                    if (_enumInfo == null || (_enumGatherList = _enumInfo.getGatherEnumInfo()) == null) continue;
                    _rect = BgNEnumerateHelper.getEnumArea(_sheet, _enumInfo);
                    _formulaList.clear();
                    _bgItemList.clear();
                    lastFormulaRowIndex = -1;
                    int jn = _enumGatherList.size();
                    for (int j = 0; j < jn; ++j) {
                        _bgItemList.clear();
                        _formulaList.clear();
                        lastFormulaRowIndex = -1;
                        _enumGatherInfo = (BgNEnumGatherInfo)_enumGatherList.get(j);
                        _gRect = BgNEnumerateHelper.getEnumArea(_sheet, _enumGatherInfo);
                        int rowIndex = _gRect.x;
                        int rowCount = _gRect.height;
                        int colIndex = _gRect.y;
                        int colCount = _gRect.width;
                        for (rowIndex = rowCount; rowIndex >= _gRect.x; --rowIndex) {
                            _row = _sheet.getRow(rowIndex, false);
                            if (!BgNFSHelper.checkHasFormula(_row)) continue;
                            _row.setUserObject(this.HAS_REMOVE, (Object)Boolean.TRUE);
                            _bgItemStr = null;
                            if (lastFormulaRowIndex == -1) {
                                lastFormulaRowIndex = rowIndex;
                            }
                            _tmpMap = new HashMap<Integer, String>();
                            _orgUnitId = (String)this.getOrgUnitSort().get(0);
                            _orgUnitName = (String)this.getOrgUnitMap().get(_orgUnitId);
                            for (colIndex = _gRect.y; colIndex <= colCount; ++colIndex) {
                                _cell = _sheet.getCell(rowIndex, colIndex, false);
                                if (BgNFSHelper.checkHasBgItemInfo(_cell)) {
                                    _bgItemStr = StringUtils.isEmpty(_bgItemStr) ? (String)BgNFSHelper.getValue(_cell) : _bgItemStr + ";" + (String)BgNFSHelper.getValue(_cell);
                                    BgNFSHelper.setValue(_cell, null);
                                    continue;
                                }
                                if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
                                    _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                                    _tmpMap.put(new Integer(colIndex), _formulaStr);
                                    _key = new StringBuffer(_orgUnitId).append("_").append(_formulaStr).toString();
                                    if (valueMap.containsKey(_key)) {
                                        _value = (BigDecimal)valueMap.get(_key);
                                        BgNFSHelper.setValue(_cell, _value);
                                        _row.removeUserObject(this.HAS_REMOVE);
                                        continue;
                                    }
                                    BgNFSHelper.setValue(_cell, null);
                                    continue;
                                }
                                BgNFSHelper.setValue(_cell, null);
                            }
                            _cell = _sheet.getCell(rowIndex, _rect.y, true);
                            if (_bgItemStr != null) {
                                BgNFSHelper.setValue(_cell, _orgUnitName + "[" + _bgItemStr + "]");
                            } else {
                                BgNFSHelper.setValue(_cell, _orgUnitName);
                            }
                            _formulaList.add(_tmpMap);
                            _bgItemList.add(_bgItemStr);
                        }
                        if (lastFormulaRowIndex == -1 || orgUnitSize <= 1) continue;
                        int formulaSize = _formulaList.size();
                        BgNFSHelper.addRows(_sheet, lastFormulaRowIndex + 1, (orgUnitSize - 1) * formulaSize - 1, true);
                        int pos = lastFormulaRowIndex + 1;
                        for (int x = 1; x < orgUnitSize; ++x) {
                            _orgUnitId = (String)this.getOrgUnitSort().get(x);
                            _orgUnitName = (String)this.getOrgUnitMap().get(_orgUnitId);
                            for (int y = formulaSize - 1; y >= 0; --y) {
                                _bgItemStr = (String)_bgItemList.get(y);
                                _tmpMap = (Map)_formulaList.get(y);
                                _tmpRow = _sheet.getRow(pos, true);
                                _tmpRow.setUserObject(this.HAS_REMOVE, (Object)Boolean.TRUE);
                                int zn = _gRect.width;
                                for (int z = _gRect.y; z <= zn; ++z) {
                                    _cKey = new Integer(z);
                                    if (!_tmpMap.containsKey(_cKey)) continue;
                                    _formulaStr = (String)_tmpMap.get(_cKey);
                                    _cell = _tmpRow.getCell(z, true);
                                    BgNFSHelper.setFormulaOfCell(_cell, _formulaStr, true);
                                    _key = new StringBuffer(_orgUnitId).append("_").append(_formulaStr).toString();
                                    if (!valueMap.containsKey(_key)) continue;
                                    _value = (BigDecimal)valueMap.get(_key);
                                    BgNFSHelper.setValue(_cell, _value);
                                    _tmpRow.removeUserObject(this.HAS_REMOVE);
                                }
                                _cell = _sheet.getCell(pos, _rect.y, true);
                                if (_bgItemStr != null) {
                                    BgNFSHelper.setValue(_cell, _orgUnitName + "[" + _bgItemStr + "]");
                                } else {
                                    BgNFSHelper.setValue(_cell, _orgUnitName);
                                }
                                ++pos;
                            }
                        }
                    }
                }
            }
            for (int rowIndex = maxRow = _sheet.getMaxRowIndex(); rowIndex >= 0; --rowIndex) {
                _tmpRow = _sheet.getRow(rowIndex, false);
                if (_tmpRow == null || (_obj = _tmpRow.getUserObjectValue(this.HAS_REMOVE)) == null || !(_obj instanceof Boolean)) continue;
                BgNFSHelper.removeRow(_sheet, rowIndex);
            }
        }
    }

    protected void viewIC() throws Exception {
        Book _book = null;
        Map _enumMap = null;
        Map _valueMap = null;
        Set _querySet = null;
        _book = this.getBook();
        _enumMap = (Map)BgNEnumerateHelper.getBgEnumInfo(_book);
        if (this.getOrgUnitSort().isEmpty()) {
            this.getOrgUnitSort().addAll(this.getOrgUnitMap().keySet());
        }
        if (this.getOrgUnitSort().isEmpty()) {
            return;
        }
        _querySet = this.queryInfo(_book, _enumMap, false);
        if (!_querySet.isEmpty()) {
            _valueMap = this.getGatherInterface().queryGatherValue(this.getBgSchemeMap(), _querySet, this.VIEW_MODE, this.hasTmpData);
            this.fillItemAndCompanyValue(_book, _enumMap, _valueMap);
        }
        BgNSHelper.objClear(_valueMap);
        BgNSHelper.objClear(_querySet);
    }

    private void fillItemAndCompanyValue(Book book, Map enumMap, Map valueMap) {
        if (book == null || enumMap == null || valueMap == null) {
            return;
        }
        Sheet _sheet = null;
        Row _row = null;
        Row _tmpRow = null;
        Cell _cell = null;
        List _enumsList = null;
        List _enumGatherList = null;
        BgNEnumerateInfo _enumInfo = null;
        BgNEnumGatherInfo _enumGatherInfo = null;
        Rectangle _rect = null;
        Rectangle _gRect = null;
        int size = this.getOrgUnitSort().size();
        Object _obj = null;
        String _orgUnitId = null;
        String _orgUnitName = null;
        String _key = null;
        String _formulaStr = null;
        String _bgItemStr = null;
        BigDecimal _value = null;
        int count = book.getSheetCount();
        for (int index = 0; index < count; ++index) {
            int maxRow;
            _sheet = book.getSheet(index);
            _enumsList = BgNEnumerateHelper.getBgEnumInfo(_sheet.getID(), enumMap);
            if (_enumsList != null) {
                int in = _enumsList.size();
                for (int i = 0; i < in; ++i) {
                    _enumInfo = (BgNEnumerateInfo)_enumsList.get(i);
                    if (_enumInfo == null || (_enumGatherList = _enumInfo.getGatherEnumInfo()) == null) continue;
                    _rect = BgNEnumerateHelper.getEnumArea(_sheet, _enumInfo);
                    int jn = _enumGatherList.size();
                    for (int j = 0; j < jn; ++j) {
                        _enumGatherInfo = (BgNEnumGatherInfo)_enumGatherList.get(j);
                        _gRect = BgNEnumerateHelper.getEnumArea(_sheet, _enumGatherInfo);
                        int rowIndex = _gRect.x;
                        int rowCount = _gRect.height;
                        int colIndex = _gRect.y;
                        int colCount = _gRect.width;
                        for (rowIndex = rowCount; rowIndex >= _gRect.x; --rowIndex) {
                            _row = _sheet.getRow(rowIndex, false);
                            if (!BgNFSHelper.checkHasFormula(_row)) continue;
                            _bgItemStr = null;
                            BgNFSHelper.addRows(_sheet, rowIndex + 1, size - 1, true);
                            for (int z = 0; z < size; ++z) {
                                _tmpRow = _sheet.getRow(rowIndex + z + 1, true);
                                _tmpRow.setUserObject(this.HAS_REMOVE, (Object)Boolean.TRUE);
                            }
                            for (colIndex = _gRect.y; colIndex <= colCount; ++colIndex) {
                                _cell = _sheet.getCell(rowIndex, colIndex, false);
                                if (BgNFSHelper.checkHasBgItemInfo(_cell)) {
                                    if (StringUtils.isEmpty(_bgItemStr)) {
                                        _bgItemStr = (String)BgNFSHelper.getValue(_cell);
                                        continue;
                                    }
                                    _bgItemStr = _bgItemStr + ";" + (String)BgNFSHelper.getValue(_cell);
                                    continue;
                                }
                                if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
                                    _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                                    for (int y = 0; y < size; ++y) {
                                        _orgUnitId = (String)this.getOrgUnitSort().get(y);
                                        _cell = _sheet.getCell(rowIndex + y + 1, colIndex, true);
                                        BgNFSHelper.setFormulaOfCell(_cell, _formulaStr, true);
                                        _key = new StringBuffer(_orgUnitId).append("_").append(_formulaStr).toString();
                                        if (!valueMap.containsKey(_key)) continue;
                                        _value = (BigDecimal)valueMap.get(_key);
                                        BgNFSHelper.setValue(_cell, _value);
                                        _tmpRow = _sheet.getRow(rowIndex + y + 1, true);
                                        _tmpRow.removeUserObject(this.HAS_REMOVE);
                                    }
                                    continue;
                                }
                                BgNFSHelper.setValue(_cell, null);
                            }
                            for (int x = 0; x < size; ++x) {
                                _tmpRow = _sheet.getRow(rowIndex + x + 1, false);
                                if (_tmpRow == null) continue;
                                _orgUnitId = (String)this.getOrgUnitSort().get(x);
                                _orgUnitName = (String)this.getOrgUnitMap().get(_orgUnitId);
                                _cell = _tmpRow.getCell(_rect.y, true);
                                if (_bgItemStr != null) {
                                    BgNFSHelper.setValue(_cell, _bgItemStr + "[" + _orgUnitName + "]");
                                    continue;
                                }
                                BgNFSHelper.setValue(_cell, _orgUnitName);
                            }
                            BgNFSHelper.removeRow(_sheet, rowIndex);
                        }
                    }
                }
            }
            for (int rowIndex = maxRow = _sheet.getMaxRowIndex(); rowIndex >= 0; --rowIndex) {
                _tmpRow = _sheet.getRow(rowIndex, false);
                if (_tmpRow == null || (_obj = _tmpRow.getUserObjectValue(this.HAS_REMOVE)) == null || !(_obj instanceof Boolean)) continue;
                BgNFSHelper.removeRow(_sheet, rowIndex);
            }
        }
    }

    protected void clearMerge(Sheet sheet, List enums) {
        MergeBlocks mb;
        if (sheet != null && (mb = sheet.getMerger(true)) != null) {
            Object _obj = null;
            String _str = null;
            String[] _strs = null;
            Cell _cell = null;
            Rectangle _rect = null;
            Rectangle _enumRect = null;
            CellBlock _block = null;
            ArrayList<Rectangle> _rects = new ArrayList<Rectangle>();
            ArrayList<Object> _strList = new ArrayList<Object>();
            BgNEnumerateInfo _enumInfo = null;
            BgNEnumGatherInfo _enumGatherInfo = null;
            Object obj = null;
            int xn = enums.size();
            for (int x = 0; x < xn; ++x) {
                obj = enums.get(x);
                if (obj instanceof BgNEnumerateInfo) {
                    _enumInfo = (BgNEnumerateInfo)enums.get(x);
                    _enumRect = BgNEnumerateHelper.getEnumArea(sheet, _enumInfo);
                } else if (obj instanceof BgNEnumGatherInfo) {
                    _enumGatherInfo = (BgNEnumGatherInfo)enums.get(x);
                    _enumRect = BgNEnumerateHelper.getEnumArea(sheet, _enumGatherInfo);
                }
                for (int i = mb.size() - 1; i >= 0; --i) {
                    _block = mb.getBlock(i);
                    _rect = new Rectangle(_block.getRow(), _block.getCol(), _block.getCol2(), _block.getRow2());
                    if (!this.compareTo(_enumRect, _rect)) continue;
                    _rects.add(_rect);
                    _cell = sheet.getCell(_block.getRow(), _block.getCol(), false);
                    if (BgNFSHelper.checkHasBgItemInfo(_cell)) {
                        _strs = BgNFSHelper.getBgItemInfo(_cell);
                        if (_cell != null && _cell.getValue() != Variant.nullVariant) {
                            _strs[0] = (String)_cell.getValue().getValue();
                        }
                        _strList.add(_strs);
                    } else {
                        _str = _cell != null && _cell.getValue() != Variant.nullVariant ? (String)_cell.getValue().getValue() : null;
                        _strList.add(_str);
                    }
                    sheet.getRange(_block).merge();
                }
            }
            int in = _rects.size();
            for (int i = 0; i < in; ++i) {
                _rect = (Rectangle)_rects.get(i);
                _obj = _strList.get(i);
                int rowCount = _rect.height;
                for (int rowIndex = _rect.x; rowIndex <= rowCount; ++rowIndex) {
                    int colCount = _rect.width;
                    for (int colIndex = _rect.y; colIndex <= colCount; ++colIndex) {
                        _cell = sheet.getCell(rowIndex, colIndex, true);
                        if (_obj == null) continue;
                        if (_obj instanceof String) {
                            _str = _obj;
                            if (StringUtils.isEmpty((String)_str)) continue;
                            BgNFSHelper.setValue(_cell, _str.replaceAll(" ", ""));
                            continue;
                        }
                        if (!(_obj instanceof String[])) continue;
                        _strs = _obj;
                        BgNFSHelper.setBgItemInfo(_cell, _strs[1], _strs[2]);
                        if (StringUtils.isEmpty((String)_strs[0])) continue;
                        BgNFSHelper.setValue(_cell, _strs[0].replaceAll(" ", ""));
                    }
                }
            }
        }
    }

    protected boolean compareTo(Rectangle enumRect, Rectangle rect) {
        int colIndex;
        int colCount;
        int rowIndex;
        boolean re = false;
        if (enumRect == null || rect == null) {
            return re;
        }
        HashSet<String> signSet = new HashSet<String>();
        int rowCount = enumRect.height;
        for (rowIndex = enumRect.x; rowIndex <= rowCount; ++rowIndex) {
            colCount = enumRect.width;
            for (colIndex = enumRect.y; colIndex <= colCount; ++colIndex) {
                signSet.add(String.valueOf(rowIndex) + "-" + String.valueOf(colIndex));
            }
        }
        rowCount = rect.height;
        for (rowIndex = rect.x; rowIndex <= rowCount; ++rowIndex) {
            colCount = rect.width;
            for (colIndex = rect.y; colIndex <= colCount; ++colIndex) {
                if (!signSet.contains(String.valueOf(rowIndex) + "-" + String.valueOf(colIndex))) continue;
                signSet.clear();
                return true;
            }
        }
        return re;
    }

    @Override
    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            this.getMeasureUnitMap().clear();
            this.getCurrencyMap().clear();
            this.getFormulaMap().clear();
            this.getOrgUnitMap().clear();
            this.getOrgUnitSort().clear();
            this.getBgSchemeMap().clear();
            this.getBgFormIdsMap().clear();
        }
        return re;
    }
}

