/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.nbudget.BgWorkPaperHistoryVersionFactory;
import com.kingdee.eas.ma.nbudget.client.AbstractBgWorkPaperHistoryVersionListUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgWorkPaperHistoryVersionListUI
extends AbstractBgWorkPaperHistoryVersionListUI {
    private static final Logger logger = CoreUIObject.getLogger(BgWorkPaperHistoryVersionListUI.class);
    private String bgWorkPaperId;
    private String value = null;
    private final int rowPerWords = 25;

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void onShow() throws Exception {
        super.onShow();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow irow = this.tblMain.getRow(i);
            Object cellValue = irow.getCell("versionIdea").getValue();
            if (cellValue == null || cellValue.toString().trim().length() == 0) continue;
            int wordCount = irow.getCell("versionIdea").getValue().toString().length();
            int j = wordCount / 25;
            int rowHeight = wordCount % 25 == 0 ? j * 20 : (j + 1) * 20;
            irow.setHeight(rowHeight);
        }
        this.tblMain.getColumn("versionIdea").getStyleAttributes().setWrapText(true);
    }

    public static String showDialogWindow(Component ui, String bgWorkPaperId) throws Exception {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"BGWORKPAPER_ID", (Object)bgWorkPaperId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgWorkPaperHistoryVersionListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        String bgWorkpaperHistoryVersion = ((BgWorkPaperHistoryVersionListUI)uiWindow.getUIObject()).getValue();
        return bgWorkpaperHistoryVersion;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Object obj = this.getUIContext().get("BGWORKPAPER_ID");
        if (obj == null) {
            return;
        }
        this.bgWorkPaperId = obj.toString();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        if (viewInfo == null) {
            viewInfo = new EntityViewInfo();
        }
        FilterInfo filterInfo = new FilterInfo();
        this.replaceFilterItems(filterInfo, new FilterItemInfo("bgWorkPaper.id".toLowerCase(), (Object)this.bgWorkPaperId, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        IQueryExecutor que = super.getQueryExecutor(queryPK, viewInfo);
        return que;
    }

    protected final void replaceFilterItems(FilterInfo filter, FilterItemInfo item) {
        if (filter == null || item == null) {
            return;
        }
        boolean isReplace = false;
        if (filter.getFilterItems() != null) {
            FilterItemInfo fiInfo = null;
            FilterItemCollection fiCol = filter.getFilterItems();
            int n = fiCol.size();
            for (int i = 0; i < n; ++i) {
                fiInfo = fiCol.get(i);
                if (!fiInfo.getPropertyName().trim().equals(item.getPropertyName().trim())) continue;
                fiInfo.setCompareType(item.getCompareType());
                fiInfo.setCompareValue(item.getCompareValue());
                isReplace = true;
            }
            if (!isReplace) {
                fiCol.add(item);
                int itemsSize = fiCol.size();
                if (itemsSize <= 1) {
                    filter.setMaskString("(#0)");
                } else {
                    filter.setMaskString(filter.getMaskString() + " and (#" + String.valueOf(itemsSize - 1) + ")");
                }
            }
        }
    }

    protected void initWorkButton() {
        this.actionViewCancel.setEnabled(true);
        this.setUIToolBar(null);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgWorkPaperHistoryVersionFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.ma.nbudget.client.BgWorkPaperHistoryVersionProcessUI";
    }

    @Override
    public void actionViewOk_actionPerformed(ActionEvent e) throws Exception {
        this.setValue(this.getSelectedKeyValue());
        this.destroyWindow();
    }

    @Override
    public void actionViewCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }
}

