/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgDataTypeEnum;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.nbudget.BgElimContextHelper;
import com.kingdee.eas.ma.nbudget.BgNWorkPaperFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgNWorkPaperHelper;
import com.kingdee.eas.ma.nbudget.BgWorkPaperFactory;
import com.kingdee.eas.ma.nbudget.BgWorkPaperStateEnum;
import com.kingdee.eas.ma.nbudget.BgWorkTemplateInfo;
import com.kingdee.eas.ma.nbudget.IBgNWorkPaperFacade;
import com.kingdee.eas.ma.nbudget.client.AbstractBgWorkPaperListUI;
import com.kingdee.eas.ma.nbudget.client.BgWorkPaperHistoryVersionListUI;
import com.kingdee.eas.ma.nbudget.client.BgWorkPaperHistoryVersionProcessUI;
import com.kingdee.eas.ma.nbudget.client.IBgElimContextUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.Observable;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class BgWorkPaperListUI
extends AbstractBgWorkPaperListUI
implements IBgElimContextUI {
    private static final long serialVersionUID = 5718938336570970144L;
    private static final Logger logger = CoreUIObject.getLogger(BgWorkPaperListUI.class);
    public static final String RES_PATH = "com.kingdee.eas.ma.nbudget.client.BgEliminationResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public String getPermissionNum() {
        return "bg_WorkPaper001_list";
    }

    public void onLoad() throws Exception {
        if (BgElimContextHelper.isInitialized(this.getUIContext())) {
            super.onLoad();
            BgElimContextHelper.registUIObject(this);
        } else {
            SysUtil.abort();
        }
        this.init();
    }

    private void init() throws Exception {
        if (this.bgElimContext.getCurBgDataType() != null) {
            this.cbxDataType.setSelectedItem((Object)this.bgElimContext.getCurBgDataType());
        }
        this.refreshBgSchemeF7();
        this.refreshWorkTemplateF7();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getGroupManager().group();
    }

    private void refreshWorkTemplateF7() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        view.setFilter(filter);
        view.setSorter(sorter);
        this.prmtBgWorkTemplate.setEntityViewInfo(view);
        this.prmtBgWorkTemplate.setEnabled(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionUnAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionBatchAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_auditbatch"));
        this.actionBatchUnAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unauditbatch"));
        this.actionViewHistory.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_historyedition"));
        this.btnQuery.setText(EASResource.getString((String)RES_PATH, (String)"conditionQuery"));
        this.btnQuery.setToolTipText(EASResource.getString((String)RES_PATH, (String)"conditionQuery"));
        this.menuBiz.setVisible(false);
        this.itemViewFlow.setVisible(false);
        this.btnCancel.setVisible(false);
        this.menuItemCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.menuItemCancelCancel.setVisible(false);
        this.rbCurrOrgUnit.setVisible(false);
        this.rbImmOrgUnit.setVisible(false);
        this.rbAllOrgUnit.setVisible(false);
        this.btnViewHistory.setVisible(true);
        this.btnViewHistory.setEnabled(true);
        this.itemViewHistory.setVisible(true);
        this.itemViewHistory.setEnabled(true);
    }

    private void refreshBgSchemeF7() throws Exception {
        if (this.bgElimContext.getCurBgScheme() != null) {
            this.prmtBgScheme.setData((Object)this.bgElimContext.getCurBgScheme());
            this.prmtBgScheme.setEnabled(false);
        } else {
            String orgUnitId = null;
            OrgUnitInfo orgUnit = this.bgElimContext.getCurMappedOrgUnit();
            orgUnitId = orgUnit != null ? orgUnit.getId().toString() : "NONE_ORGUNIT_ID";
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.Id", (Object)orgUnitId));
            SorterItemCollection sorter = new SorterItemCollection();
            sorter.add(new SorterItemInfo("number"));
            view.setFilter(filter);
            view.setSorter(sorter);
            this.prmtBgScheme.setEntityViewInfo(view);
            this.prmtBgScheme.setEnabled(true);
        }
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        this.actionRefresh_actionPerformed(null);
    }

    @Override
    protected void prmtBgWorkTemplate_dataChanged(DataChangeEvent e) throws Exception {
        this.actionRefresh_actionPerformed(null);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        FilterInfo filter;
        this.resetBtnState(false, false);
        if (viewInfo == null) {
            viewInfo = new EntityViewInfo();
        }
        if ((filter = viewInfo.getFilter()) == null) {
            filter = this.getDefaultFilterForQuery();
            viewInfo.setFilter(filter);
        }
        this.replaceDataTypeFilter(filter);
        this.replaceOrgFilter(filter);
        this.replaceSchemeFilter(filter);
        this.replaceWorkTemplateFilter(filter);
        IQueryExecutor que = super.getQueryExecutor(queryPK, viewInfo);
        return que;
    }

    protected void replaceDataTypeFilter(FilterInfo filter) {
        if (filter != null) {
            int dataType = 1;
            if (this.cbxDataType.getSelectedItem() instanceof BgDataTypeEnum) {
                dataType = ((BgDataTypeEnum)this.cbxDataType.getSelectedItem()).getValue();
            }
            FilterItemInfo fitem = new FilterItemInfo("dataType", (Object)new Integer(dataType));
            this.replaceFilterItems(filter, fitem);
        }
    }

    protected void replaceOrgFilter(FilterInfo filter) {
        if (filter != null) {
            String orgId = this.getOrgUnitId();
            if (orgId == null) {
                orgId = "000000000000000000000000000=";
            }
            FilterItemInfo fitem = new FilterItemInfo("orgunit.id", (Object)orgId);
            this.replaceFilterItems(filter, fitem);
        }
    }

    protected void replaceSchemeFilter(FilterInfo filter) {
        if (filter != null && this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
            BgSchemeInfo bgScheme = (BgSchemeInfo)this.prmtBgScheme.getData();
            this.replaceFilterItems(filter, new FilterItemInfo("bgScheme.number", (Object)bgScheme.getNumber()));
        }
    }

    protected void replaceWorkTemplateFilter(FilterInfo filter) {
        if (filter != null && this.prmtBgWorkTemplate.getData() instanceof BgWorkTemplateInfo) {
            BgWorkTemplateInfo info = (BgWorkTemplateInfo)this.prmtBgWorkTemplate.getData();
            this.replaceFilterItems(filter, new FilterItemInfo("bgWorkTemplate.number", (Object)info.getNumber()));
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        boolean isAudited = true;
        boolean isSelected = false;
        int rowIndex = this.getSelectedRow();
        IRow row = null;
        if (rowIndex >= 0 && (row = this.tblMain.getRow(rowIndex)) != null) {
            isSelected = true;
            Object obj = row.getCell("state").getValue();
            if (obj instanceof BgWorkPaperStateEnum) {
                isAudited = ((BgWorkPaperStateEnum)((Object)obj)).getValue() == 2;
            } else if (obj instanceof BizEnumValueDTO && ((BizEnumValueDTO)obj).getValue() != null) {
                isAudited = String.valueOf(2).equals(((BizEnumValueDTO)obj).getValue().toString());
            }
        }
        this.resetBtnState(isAudited, isSelected);
    }

    protected void resetBtnState(boolean isAudited, boolean isSelected) {
        this.actionEdit.setEnabled(!isAudited && isSelected);
        this.actionRemove.setEnabled(!isAudited && isSelected);
        this.actionAudit.setEnabled(!isAudited && isSelected);
        this.actionBatchAudit.setEnabled(!isAudited && isSelected);
        this.actionUnAudit.setEnabled(isAudited && isSelected);
        this.actionBatchUnAudit.setEnabled(isAudited && isSelected);
    }

    protected int getSelectedRow() {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows != null && selectRows.length > 0) {
            return selectRows[0];
        }
        return -1;
    }

    protected void treeOrgUnit_valueChanged(TreeSelectionEvent e) throws Exception {
        if (!this.treeOrgUnit.isEnabled()) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node != null && OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
            this.tblMain.removeRows();
            this.enableBtns(false);
            if (this.isInit()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"SelectPermiUnit"));
                this.enableBtns(false);
                SysUtil.abort();
            }
        } else {
            FullOrgUnitInfo orgUnitInfo = this.getBGOrgUnitInfo();
            if (orgUnitInfo == null) {
                return;
            }
            this.execQuery();
        }
        this.refreshBgSchemeF7();
        this.refreshWorkTemplateF7();
    }

    @Override
    public void update(Observable o, Object arg) {
        BgElimContextHelper.update(o, (CoreUI)this);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.getSelectedRow();
        if (rowIndex >= 0 && this.tblMain.getRow(rowIndex) != null) {
            boolean isUnAudited = false;
            IRow row = this.tblMain.getRow(rowIndex);
            String billId = row.getCell("id").getValue().toString();
            Object obj = row.getCell("state").getValue();
            if (obj instanceof BgWorkPaperStateEnum) {
                isUnAudited = ((BgWorkPaperStateEnum)((Object)obj)).getValue() == 1;
            } else if (obj instanceof BizEnumValueDTO && ((BizEnumValueDTO)obj).getValue() != null) {
                isUnAudited = String.valueOf(1).equals(((BizEnumValueDTO)obj).getValue().toString());
            }
            if (!isUnAudited) {
                // empty if block
            }
            this.openAuditUI(billId, true, e);
        }
    }

    @Override
    public void actionBatchAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        this.getFacaceInterface().audit(ids);
        this.showMsg(BgNWorkPaperHelper.getWorkPaperMsg("batchAuditSuccess"));
        this.actionRefresh_actionPerformed(null);
    }

    @Override
    public void actionBatchUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        this.getFacaceInterface().unAudit(ids);
        this.showMsg(BgNWorkPaperHelper.getWorkPaperMsg("batchUnAuditSuccess"));
        this.actionRefresh_actionPerformed(null);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.getSelectedRow();
        if (rowIndex >= 0 && this.tblMain.getRow(rowIndex) != null) {
            boolean isAudited = false;
            IRow row = this.tblMain.getRow(rowIndex);
            String billId = row.getCell("id").getValue().toString();
            Object obj = row.getCell("state").getValue();
            if (obj instanceof BgWorkPaperStateEnum) {
                isAudited = ((BgWorkPaperStateEnum)((Object)obj)).getValue() == 2;
            } else if (obj instanceof BizEnumValueDTO && ((BizEnumValueDTO)obj).getValue() != null) {
                isAudited = String.valueOf(2).equals(((BizEnumValueDTO)obj).getValue().toString());
            }
            if (!isAudited) {
                // empty if block
            }
            this.openAuditUI(billId, false, e);
        }
    }

    protected void openAuditUI(String billId, boolean isAudit, ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        if (isAudit) {
            uiContext.put((Object)"BGFORM_AUDIT_TYPE", (Object)"BGFORM_AUDIT");
        } else {
            uiContext.put((Object)"BGFORM_AUDIT_TYPE", (Object)"BGFORM_ANTIAUDIT");
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected void showMsg(String msg) {
        this.setMessageText(msg);
        super.showMessage();
    }

    public boolean destroyWindow() {
        BgElimContextHelper.unRegistUIObject(this);
        return super.destroyWindow();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        uiContext.put((Object)"ORG_UNIT", (Object)this.getOrgUnitInfo());
        super.prepareUIContext(uiContext, e);
    }

    protected IObjectPK getOrgPK() {
        String _orgUnitId = this.getOrgUnitId();
        if (!StringUtils.isEmpty((String)_orgUnitId)) {
            return new ObjectUuidPK(BOSUuid.read((String)_orgUnitId));
        }
        return super.getOrgPK();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        String _orgUnitId = this.getOrgUnitId();
        if (!StringUtils.isEmpty((String)_orgUnitId)) {
            return new ObjectUuidPK(BOSUuid.read((String)_orgUnitId));
        }
        return super.getOrgPK(action);
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.ma.nbudget.client.BgWorkPaperProcessUI";
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgWorkPaperFactory.getRemoteInstance();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected boolean isOrderByIDForBill() {
        return false;
    }

    protected boolean isUseForElim() {
        return true;
    }

    protected boolean isOnlyShowGroup() {
        return true;
    }

    public IBgNWorkPaperFacade getFacaceInterface() throws Exception {
        return BgNWorkPaperFacadeFactory.getRemoteInstance();
    }

    @Override
    public void actionViewHistory_actionPerformed(ActionEvent e) throws Exception {
        String bgWorkPaperHistoryVersionId = BgWorkPaperHistoryVersionListUI.showDialogWindow((Component)((Object)this), this.getSelectedKeyValue());
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)bgWorkPaperHistoryVersionId);
        if (bgWorkPaperHistoryVersionId == null || bgWorkPaperHistoryVersionId.trim().length() == 0) {
            return;
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(BgWorkPaperHistoryVersionProcessUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }
}

