/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.SpreadHelper;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.client.designer.IMenuStrategy;
import com.kingdee.eas.fi.newrpt.client.designer.TimeMark;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.framework.client.mutex.DataObjectMutex;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.nbudget.BgCourseException;
import com.kingdee.eas.ma.nbudget.BgElimContext;
import com.kingdee.eas.ma.nbudget.BgExportHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNFormException;
import com.kingdee.eas.ma.nbudget.BgNWorkPaperFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgNWorkPaperHelper;
import com.kingdee.eas.ma.nbudget.BgWorkPaperFactory;
import com.kingdee.eas.ma.nbudget.BgWorkPaperInfo;
import com.kingdee.eas.ma.nbudget.BgWorkPaperMeasureUnitCollection;
import com.kingdee.eas.ma.nbudget.BgWorkPaperMeasureUnitInfo;
import com.kingdee.eas.ma.nbudget.BgWorkPaperPropertyAdapter;
import com.kingdee.eas.ma.nbudget.BgWorkPaperProvider;
import com.kingdee.eas.ma.nbudget.client.AbstractBgWorkPaperProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgNWorkPaperCalUtil;
import com.kingdee.eas.ma.nbudget.client.BgUserCellDisplayProvider;
import com.kingdee.eas.ma.nbudget.client.BgWorkPaperCreateHistoryIdeaEditUI;
import com.kingdee.eas.ma.nbudget.client.BgWorkPaperDisplayValueProvider;
import com.kingdee.eas.ma.nbudget.client.BgWorkPaperMenuManager;
import com.kingdee.eas.ma.nbudget.client.BgWorkRender;
import com.kingdee.eas.ma.nbudget.client.Excel2007FileFilter;
import com.kingdee.eas.ma.nbudget.client.ExcelFileFilter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgWorkPaperProcessUI
extends AbstractBgWorkPaperProcessUI {
    private static final long serialVersionUID = 8465717106218665923L;
    private static final Logger logger = CoreUIObject.getLogger(BgWorkPaperProcessUI.class);
    private boolean isCreatedNewBook = false;
    protected IBookProvider provider = null;
    private Map measureUnitMap = new HashMap();

    @Override
    public IBookProvider getBudgetProvider() {
        if (this.provider == null) {
            this.provider = new BgWorkPaperProvider(this);
        }
        return this.provider;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.toolBar.remove((Component)this.btnUnLock);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            if (this.getBookProvider() instanceof BgWorkPaperProvider) {
                ((BgWorkPaperProvider)this.getBookProvider()).restoreSheetId(this.getBook());
            }
            this.getSpreadManager().getModifyManager().setModified();
        }
        if (this.isAudit() && OprtState.VIEW.equals(this.getOprtState())) {
            DataObjectMutex mutextControl = new DataObjectMutex();
            try {
                mutextControl.requestDataObjectLock(this.getEditData().getId().toString());
            }
            catch (Throwable e) {
                logger.error((Object)"", e);
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        Book book = this.getBook();
        int n = book.getSheetCount();
        for (int i = 0; i < n; ++i) {
            Sheet sheet = book.getSheet(i);
            int colCount = sheet.getMaxColIndex();
            for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                if (!String.valueOf(3).equals(BgNWorkPaperHelper.getSrcType(sheet.getColumn(colIndex, false)))) continue;
                StyleAttributes cellSa = Styles.getEmptySA();
                cellSa.setLocked(true);
                sheet.getRange(0, colIndex, 1048575, colIndex).setStyle(cellSa, Styles.getEmptySA());
            }
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.setVisible(false);
        this.actionUnAudit.setVisible(false);
        this.actionCreaterHistory.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_historyedition"));
        this.btnCreateHistory.setToolTipText(BgNWorkPaperHelper.getWorkPaperMsg("createHistory"));
        if (!this.getOprtState().equals(OprtState.EDIT)) {
            this.actionCreaterHistory.setEnabled(false);
            this.actionCreaterHistory.setVisible(false);
        } else {
            this.btnCreateHistory.setVisible(true);
            this.btnCreateHistory.setEnabled(true);
            this.itemCreateHistory.setVisible(true);
            this.itemCreateHistory.setEnabled(true);
        }
    }

    @Override
    public void actionCreaterHistory_actionPerformed(ActionEvent e) throws Exception {
        if (this.getSpreadManager().getModifyManager().isDirty() && !OprtState.VIEW.equals(this.getOprtState()) || OprtState.COPYADDNEW.equals(this.getOprtState())) {
            int re = MsgBox.showConfirm2((Component)((Object)this), (String)BgNWorkPaperHelper.getWorkPaperMsg("isCreateHistory"));
            if (re == 1 || re == 2) {
                return;
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"BGWORKPAPER_PROCESSUI", (Object)this);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgWorkPaperCreateHistoryIdeaEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            if (((BgWorkPaperCreateHistoryIdeaEditUI)uiWindow.getUIObject()).isSave()) {
                BigDecimal versionNo = this.getEditData().getVersionNo() == null ? new BigDecimal(1.1) : this.getEditData().getVersionNo().add(BgConstants.NextVer);
                this.getEditData().setVersionNo(versionNo);
                this.actionSave_actionPerformed(e);
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)BgNWorkPaperHelper.getWorkPaperMsg("noCreateHistory"));
        }
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (this.getEditData() != null) {
            return new ObjectUuidPK(this.getEditData().getOrgUnit().getId());
        }
        return super.getOrgPK(action);
    }

    @Override
    protected void initToolbar() {
        ToolBarManager toolBarManager = this.getSpreadManager().getSpreadContainer().getToolBarManager();
        this.actionUnAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        if (this.isAudit() || this.isUnAudit()) {
            toolBarManager.addFirstGroupItem((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionUnAudit), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())), "common");
            toolBarManager.addFirstGroupItem((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionAudit), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())), "common");
        }
        super.initToolbar();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        int res;
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.getEditData().getId().toString());
        BgWorkPaperInfo info = BgWorkPaperFactory.getRemoteInstance().getBgWorkPaperInfo("select id,state where id='" + ids.get(0) + "'");
        if (info.getState().getValue() != 1) {
            MsgBox.showWarning((Component)((Object)this), (String)BgNWorkPaperHelper.getWorkPaperMsg("cannotAudit"));
            SysUtil.abort();
        }
        if ((res = MsgBox.showConfirm2((Component)((Object)this), (String)MessageFormat.format(BgNWorkPaperHelper.getWorkPaperMsg("confirmAudit"), this.getEditData().getName()))) != 0) {
            return;
        }
        BgNWorkPaperFacadeFactory.getRemoteInstance().audit(ids);
        MsgBox.showInfo((Component)((Object)this), (String)BgNWorkPaperHelper.getWorkPaperMsg("auditSuccess"));
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        int res;
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.getEditData().getId().toString());
        BgWorkPaperInfo info = BgWorkPaperFactory.getRemoteInstance().getBgWorkPaperInfo("select id,state where id='" + ids.get(0) + "'");
        if (info.getState().getValue() != 2) {
            MsgBox.showWarning((Component)((Object)this), (String)BgNWorkPaperHelper.getWorkPaperMsg("cannotUnAudit"));
            SysUtil.abort();
        }
        if ((res = MsgBox.showConfirm2((Component)((Object)this), (String)MessageFormat.format(BgNWorkPaperHelper.getWorkPaperMsg("confirmUnAudit"), this.getEditData().getName()))) != 0) {
            return;
        }
        BgNWorkPaperFacadeFactory.getRemoteInstance().unAudit(ids);
        MsgBox.showInfo((Component)((Object)this), (String)BgNWorkPaperHelper.getWorkPaperMsg("unAuditSuccess"));
    }

    @Override
    public void onShow() {
        super.onShow();
        this.showUiTitle();
    }

    protected void showUiTitle() {
        String msgKey = this.getOprtState();
        if (this.isAudit() || this.isUnAudit()) {
            msgKey = "AUDIT";
        }
        StringBuffer title = new StringBuffer();
        title.append(BgNWorkPaperHelper.getWorkPaperMsg("entityName")).append(" - ").append(BgNFCHelper.getMessageStr(msgKey));
        String _name = this.getEditData().getName();
        if (!StringUtils.isEmpty((String)_name)) {
            title.append(" - ").append(_name);
        }
        this.setUITitle(title.toString());
    }

    @Override
    public IMenuStrategy getBudgetMenuStrategy() {
        return new BgWorkPaperMenuManager((Component)((Object)this));
    }

    public Book getBook() {
        Book book = null;
        if (!this.isCreatedNewBook && OprtState.ADDNEW.equals(this.getOprtState())) {
            this.isCreatedNewBook = true;
            try {
                book = this.getBookProvider().loadBook();
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                SysUtil.abort();
            }
        } else {
            book = super.getBook();
        }
        return book;
    }

    public BgWorkPaperInfo getEditData() {
        return (BgWorkPaperInfo)this.getBookProvider().getEditValue();
    }

    public void actionCalculate_actionPerformed(ActionEvent e) throws Exception {
        TimeMark mark = this.getTimeMark();
        if (mark != null) {
            mark.Start();
        }
        new BgNWorkPaperCalUtil().calculateReport(this, this.getBook(), this.getEditData());
        super.actionCalculate_actionPerformed(e);
        if (mark != null) {
            mark.Stop();
        }
    }

    public void actionCalculateSelectedSheet_actionPerformed(ActionEvent e) throws Exception {
        int i;
        TimeMark mark = this.getTimeMark();
        if (mark != null) {
            mark.Start();
        }
        for (i = 0; i < this.getBook().getSheetCount(); ++i) {
            this.getBook().getSheet(i).setEnableCalculation(false);
        }
        this.getBook().getActiveSheet().setEnableCalculation(true);
        new BgNWorkPaperCalUtil().calculateReport(this, this.getBook(), this.getEditData());
        for (i = 0; i < this.getBook().getSheetCount(); ++i) {
            this.getBook().getSheet(i).setEnableCalculation(true);
        }
        super.actionCalculateSelectedSheet_actionPerformed(e);
        if (mark != null) {
            mark.Stop();
        }
    }

    protected boolean isAudit() {
        return "BGFORM_AUDIT".equals(this.getUIContext().get("BGFORM_AUDIT_TYPE"));
    }

    protected boolean isUnAudit() {
        return "BGFORM_ANTIAUDIT".equals(this.getUIContext().get("BGFORM_AUDIT_TYPE"));
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.getBookProvider().setEditValue(this.getBookProvider().queryEditData((IObjectPK)new ObjectUuidPK(this.getBillId())));
        this.showUiTitle();
    }

    @Override
    protected BgUserCellDisplayProvider getCellDisplayRender() {
        BgUserCellDisplayProvider render = super.getCellDisplayRender();
        render.setDisplayValueProvider(new BgWorkPaperDisplayValueProvider(this));
        BgUserCellDisplayProvider.addRenderProvider(new BgWorkRender());
        return render;
    }

    @Override
    protected void cell_Selection_Changed(SheetChangeEvent e) throws Exception {
        super.cell_Selection_Changed(e);
        if (e.getChangedBlocks() != null && e.getSheet() != null) {
            Sheet _sheet = e.getSheet();
            Cell _cell = null;
            CellBlock _block = null;
            SortedCellBlockArray _blocks = null;
            _blocks = e.getChangedBlocks();
            int rowCount = _sheet.getMaxRowIndex();
            int colCount = _sheet.getMaxColIndex();
            int size = _blocks.size();
            for (int index = 0; index < size; ++index) {
                _block = _blocks.getBlock(index);
                int maxRow = _block.getRow2() > rowCount ? rowCount : _block.getRow2();
                int maxCol = _block.getCol2() > colCount ? colCount : _block.getCol2();
                int rowEnd = maxRow;
                for (int rowBegin = _block.getRow(); rowBegin <= rowEnd; ++rowBegin) {
                    int colEnd = maxCol;
                    for (int colBegin = _block.getCol(); colBegin <= colEnd; ++colBegin) {
                        _cell = _sheet.getCell(rowBegin, colBegin, false);
                        if (BgNFSHelper.checkHasExpression(_cell)) {
                            BgNWorkPaperHelper.checkExpression(_cell, this.getEditData(), BgElimContext.getInstance().getCurMappedOrgUnit().getNumber(), null);
                        }
                        if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                        this.getSpreadManager().setItemFormulaEnable(false);
                    }
                }
            }
        }
    }

    protected void beforeSaveCheck() throws Exception {
        Book _book = null;
        Sheet _sheet = null;
        Cell _cell = null;
        boolean hasBgFormula = false;
        int rowCount = 0;
        int colCount = 0;
        int rowIndex = 0;
        int colIndex = 0;
        String _formulaStr = null;
        String _sheetName = null;
        String[] _formulaInfo = null;
        ArrayList<String[]> _formulaCheckList = new ArrayList<String[]>();
        _book = this.getBook();
        UserInfo creator = SysContext.getSysContext().getCurrentUserInfo();
        int sheetSize = _book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = _book.getSheet(sheetIndex);
            _sheetName = _sheet.getSheetName();
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            if (_sheet.getUserObject("SHEET_CREATER_ID") == null) {
                if (_sheet.isHide()) {
                    _sheet.setUserObject("SHEET_CREATER_ID", (Object)"000000000000000000000000000=");
                } else {
                    _sheet.setUserObject("SHEET_CREATER_ID", (Object)creator.getId().toString());
                }
            }
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    hasBgFormula = BgNFSHelper.checkHasFormulaOfCell(_cell);
                    if (!hasBgFormula) continue;
                    _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                    _formulaInfo = new String[]{_sheetName, _formulaStr, String.valueOf(rowIndex), String.valueOf(colIndex)};
                    _formulaCheckList.add(_formulaInfo);
                }
            }
        }
        BgNFCHelper.checkFormulaIsEctype(_formulaCheckList);
    }

    @Override
    protected void showAllBook() throws Exception {
        Book _book = null;
        Sheet _sheet = null;
        boolean isSheetPer = BgSHelper.isBgSheetPermissionUsed();
        Map sheetPer = null;
        if (isSheetPer) {
            sheetPer = this.addBgSheetPermission();
        }
        String user = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        _book = this.getBook();
        boolean isShowSheet = false;
        if (_book != null) {
            int sheetIndex = 0;
            int sheetSize = _book.getSheetCount();
            for (sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                _sheet = _book.getSheet(sheetIndex);
                if (isSheetPer) {
                    if (!isShowSheet) {
                        isShowSheet = this.hideSheet(_sheet, sheetPer, user);
                    } else {
                        this.hideSheet(_sheet, sheetPer, user);
                    }
                }
                this.showAllSheet(_sheet);
            }
        }
        this.getSpreadManager().getModifyManager().discardAllEdits();
        if (isSheetPer && !isShowSheet && !this.isActualRecordUI()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSpecialFormResource", (String)"hasnotWorkPaperPermission"));
            SysUtil.abort();
        }
        this.afterLockedAndProtection();
    }

    protected void afterLockedAndProtection() {
        Book _book = null;
        Sheet _sheet = null;
        _book = this.getBook();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            BgNFSHelper.setBookProtection(_book, true, BgNFSHelper.getBookOperation());
            int in = _book.getSheetCount();
            for (int i = 0; i < in; ++i) {
                _sheet = _book.getSheet(i);
                BgNFSHelper.setSheetProtection(_sheet, true, BgNFSHelper.getOnlySelectCellOperation());
            }
        } else {
            BgNFSHelper.setBookProtection(_book, true, null);
            int in = _book.getSheetCount();
            for (int i = 0; i < in; ++i) {
                _sheet = _book.getSheet(i);
                BgNFSHelper.setSheetProtection(_sheet, true, BgNWorkPaperHelper.getSheetOperation());
            }
        }
    }

    protected boolean checkBeforeWindowClosing() {
        boolean re = super.checkBeforeWindowClosing();
        if (this.isAudit() && OprtState.VIEW.equals(this.getOprtState())) {
            DataObjectMutex mutextControl = new DataObjectMutex();
            mutextControl.releaseDataObjectLock(this.getEditData().getId().toString());
        }
        return re;
    }

    public void actionLockCells_actionPerformed(ActionEvent e) throws Exception {
        this.getBook().getUndoManager().startGroup();
        try {
            BgNFSHelper.setCellLocked(this.getBook().getActiveSheet(), this.getBook().getActiveSheet().getSelectionRange(), true);
        }
        finally {
            this.getBook().getUndoManager().endGroup();
        }
        this.getSpreadManager().getSpreadContainer().repaint();
    }

    public void actionUnLockCells_actionPerformed(ActionEvent e) throws Exception {
        this.beforeUnLockCell();
        this.getBook().getUndoManager().startGroup();
        try {
            BgNFSHelper.setCellLocked(this.getBook().getActiveSheet(), this.getBook().getActiveSheet().getSelectionRange(), false);
        }
        finally {
            this.getBook().getUndoManager().endGroup();
        }
        this.getSpreadManager().getSpreadContainer().repaint();
    }

    protected void beforeUnLockCell() throws Exception {
        Sheet _sheet = null;
        Cell _cell = null;
        ArrayList _blocks = null;
        CellBlock _block = null;
        int rowBegin = 0;
        int rowEnd = 0;
        int colBegin = 0;
        int colEnd = 0;
        int rowIndex = 0;
        int colIndex = 0;
        _sheet = this.getBook().getActiveSheet();
        _blocks = _sheet.getSheetOption().getSelection().toSelectionBlocks();
        int rowCount = _sheet.getMaxRowIndex();
        int colCount = _sheet.getMaxColIndex();
        if (_blocks != null) {
            int in = _blocks.size();
            for (int i = 0; i < in; ++i) {
                _block = (CellBlock)_blocks.get(i);
                if (_block == null) continue;
                rowBegin = _block.getRow();
                rowEnd = _block.getRow2() > rowCount ? rowCount : _block.getRow2();
                colBegin = _block.getCol();
                colEnd = _block.getCol2() > colCount ? colCount : _block.getCol2();
                for (rowIndex = rowBegin; rowIndex <= rowEnd; ++rowIndex) {
                    for (colIndex = colBegin; colIndex <= colEnd; ++colIndex) {
                        _cell = _sheet.getCell(rowIndex, colIndex, false);
                        if (!BgNFSHelper.checkHasCertificate(_cell)) continue;
                        throw new BgCourseException(BgCourseException.CHECKCERTIFICATE);
                    }
                }
            }
        }
    }

    @Override
    public IReportPropertyAdapter getBudgetPropertyAdapter() {
        return new BgWorkPaperPropertyAdapter();
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        KDFileChooser fc = new KDFileChooser();
        fc.setDialogTitle(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "fileExport"));
        fc.addChoosableFileFilter((FileFilter)new Excel2007FileFilter());
        fc.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        fc.setAcceptAllFileFilterUsed(false);
        fc.setSelectedFile(new File(BgExportHelper.getDefaultDirtory() + "//" + this.getEditData().getName() + ".xls"));
        if (fc.showSaveDialog((Component)((Object)this)) == 0) {
            FileFilter fileFilter = fc.getFileFilter();
            File file = fc.getSelectedFile();
            if (file.getName().indexOf(".") == -1) {
                String with = null;
                if (fileFilter instanceof ExcelFileFilter) {
                    with = ".xls";
                }
                if (fileFilter instanceof Excel2007FileFilter) {
                    with = ".xlsx";
                }
                file = new File(fc.getSelectedFile() + with);
            }
            if (file != null && file.exists()) {
                int re = MsgBox.showConfirm3((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "existsFile"));
                if (re == 1 || re == 2) {
                    return;
                }
                file.delete();
            }
            Map _parameter = this.getExportImportParmeter(false, null);
            String fileName = file.getPath();
            try {
                BgNFCHelper.exportBookContent(fileName, _parameter, fileFilter);
                String exportSuccess = EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgFormImportAndExportResource", (String)"exportSucceed");
                MsgBox.showInfo((String)exportSuccess);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new BgNFormException(BgNFormException.FILEEXPORTERROR);
            }
        }
    }

    protected Map getExportImportParmeter(boolean isImport, KDSBook kdsBook) throws Exception {
        if (isImport && kdsBook == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"openFileError"));
            SysUtil.abort();
        }
        Book _book = this.getBook();
        BigDecimal _coefficient = this.getMeasureUnitCoefficient();
        HashMap<String, Object> _parameter = new HashMap<String, Object>();
        if (isImport && kdsBook != null) {
            _parameter.put("IMPORT_BOOK", _book);
            _parameter.put("IMPORT_KDSBOOK", kdsBook);
            _parameter.put("IMPORT_COEFFICIENT", _coefficient);
            _parameter.put("IMPORT_MEASUREUNIT", this.getMeasureUnitMap());
            _parameter.put("IMPORT_BGFORMULA", this.getFormulaMap());
            _parameter.put("IMPORT_DATA", Boolean.TRUE);
        } else if (!isImport) {
            Book tempBook = SpreadHelper.copyBook((Book)_book);
            _parameter.put("EXPORT_BOOK", tempBook);
            _parameter.put("EXPORT_COEFFICIENT", _coefficient);
            _parameter.put("EXPORT_MEASUREUNIT", this.getMeasureUnitMap());
            _parameter.put("EXPORT_BGFORMULA", this.getFormulaMap());
            _parameter.put("EXPORT_DATA", Boolean.TRUE);
        }
        return _parameter;
    }

    protected BigDecimal getMeasureUnitCoefficient() {
        BigDecimal _coefficient = this.getEditData().getMeasureUnit() != null ? this.getEditData().getMeasureUnit().getCoefficient() : BgNConstants.ONE;
        return _coefficient;
    }

    public Map getMeasureUnitMap() {
        return this.measureUnitMap;
    }

    public void setMeasureUnitMap(Map measureUnitMap) {
        this.measureUnitMap = measureUnitMap;
    }

    protected void initMeasureUnitInfo() throws Exception {
        this.setMeasureUnitMap(this.getMeasureUnitMap(this.getEditData()));
        if (this.getMeasureUnitMap() == null) {
            this.setMeasureUnitMap(new HashMap());
        }
    }

    protected Map getMeasureUnitMap(BgWorkPaperInfo model) {
        if (model == null) {
            return new HashMap();
        }
        if (model.getMeasureUnit() != null && !model.getMeasureUnit().isEmpty()) {
            HashMap<BgElementInfo, BigDecimal> measureUnit = new HashMap<BgElementInfo, BigDecimal>();
            BgWorkPaperMeasureUnitInfo muInfo = null;
            BgWorkPaperMeasureUnitCollection muCol = model.getWorkPaperMeasureUnit();
            Iterator iter = muCol.iterator();
            while (iter.hasNext()) {
                muInfo = (BgWorkPaperMeasureUnitInfo)iter.next();
                measureUnit.put(muInfo.getBgElement(), muInfo.getMeasureUnit().getCoefficient());
            }
            return measureUnit;
        }
        return new HashMap();
    }
}

