/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.client.RptMuliReportModel;
import com.kingdee.eas.fi.rpt.client.RptStrategyManager;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgCHelper;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.nbudget.BgElimContextHelper;
import com.kingdee.eas.ma.nbudget.BgWorkTemMeasureUnitInfo;
import com.kingdee.eas.ma.nbudget.BgWorkTemplateFactory;
import com.kingdee.eas.ma.nbudget.BgWorkTemplateInfo;
import com.kingdee.eas.ma.nbudget.IBgElimContext;
import com.kingdee.eas.ma.nbudget.IBgWorkTemplate;
import com.kingdee.eas.ma.nbudget.client.AbstractBgWorkTemplateEditUI;
import com.kingdee.eas.ma.nbudget.client.BgWorkTemplateProcessUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class BgWorkTemplateEditUI
extends AbstractBgWorkTemplateEditUI {
    private static final long serialVersionUID = -3687746646642307587L;
    private static final Logger logger = CoreUIObject.getLogger(BgWorkTemplateEditUI.class);
    private Map rpcDataMap = new HashMap();
    private IBgElimContext ctx = BgElimContextHelper.getBgElimContext();
    RptStrategyManager rptStrategyManager = null;
    RptMuliReportModel rptMuliReportModel = new RptMuliReportModel();
    private String[] especialChar = new String[]{"|", "_", "*", "/", "%"};

    public void onLoad() throws Exception {
        this.setPreferredSize(new Dimension(610, 560));
        this.beforeLoad();
        super.onLoad();
        this.afterLoad();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    protected IObjectValue createNewData() {
        BgWorkTemplateInfo bgWorkTemplateInfo = new BgWorkTemplateInfo();
        bgWorkTemplateInfo.setId(BOSUuid.create((BOSObjectType)bgWorkTemplateInfo.getBOSType()));
        bgWorkTemplateInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        bgWorkTemplateInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        bgWorkTemplateInfo.setCU((CtrlUnitInfo)this.getUIContext().get("ORGUNIT_CU"));
        try {
            if (this.ctx.getCurOrgBound() != null) {
                bgWorkTemplateInfo.setTreeId(this.ctx.getCurOrgBound().getId().toString());
            }
            if (this.ctx.getCurOrgGroup() != null) {
                bgWorkTemplateInfo.setOrgUnitId(this.ctx.getCurOrgGroup().getId().toString());
            }
        }
        catch (BOSException e) {
            logger.error((Object)"error", (Throwable)e);
            this.handUIException(e);
        }
        return bgWorkTemplateInfo;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.prmtCreator.setData((Object)SysContext.getSysContext().getCurrentUserInfo());
            this.kDDateCreat.setValue((Object)new Date(System.currentTimeMillis()));
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgWorkTemplateFactory.getRemoteInstance();
    }

    public String getProcessUI() {
        return BgWorkTemplateProcessUI.class.getName();
    }

    protected void beforeLoad() throws Exception {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("oprtState", this.getOprtState());
        this.rpcDataMap = ((IBgWorkTemplate)this.getBizInterface()).getRPCDataMap(paramMap);
    }

    protected void afterLoad() throws Exception {
        int i;
        ArrayList selectIds;
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.prmtCreator.setEnabled(false);
        this.prmtCreator.setData((Object)this.editData.getCreator());
        this.kDDateCreat.setEnabled(false);
        this.kDDateCreat.setValue((Object)this.editData.getCreateTime());
        this.btnAddNew.setVisible(false);
        this.btnRemove.setVisible(false);
        if ("VIEW".equals(this.getOprtState()) && (selectIds = (ArrayList)this.getUIContext().get("selectIds")) != null && selectIds.size() > 1) {
            for (int i2 = 0; i2 < selectIds.size(); ++i2) {
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)selectIds.get(i2).toString()));
                this.rptMuliReportModel.put((Object)selectIds.get(i2).toString(), (Object)this.getValue((IObjectPK)pk));
            }
        }
        IMeasureUnit iM = MeasureUnitFactory.getRemoteInstance();
        EntityViewInfo muView = new EntityViewInfo();
        FilterInfo muFilter = new FilterInfo();
        muFilter.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            muFilter.getFilterItems().add(new FilterItemInfo("isDisabled", (Object)"0", CompareType.EQUALS));
        }
        muView.setFilter(muFilter);
        muView.getSorter().add(new SorterItemInfo("id"));
        muView.getSorter().add(new SorterItemInfo("name"));
        muView.getSorter().add(new SorterItemInfo("number"));
        MeasureUnitCollection coll = iM.getMeasureUnitCollection(muView);
        if (coll != null && coll.size() != 0) {
            for (i = 0; i < coll.size(); ++i) {
                if (!coll.get(i).isIsBaseUnit()) continue;
                this.comboMeasure.addItem((Object)coll.get(i));
                coll.removeObject(i);
            }
            this.comboMeasure.addItems(coll.toArray());
        }
        if (!this.getOprtState().equals(OprtState.ADDNEW) && this.editData.getDefaultMeasureUnit() != null) {
            for (i = 0; i < this.comboMeasure.getItemCount(); ++i) {
                if (!((MeasureUnitInfo)this.comboMeasure.getItemAt(i)).getId().toString().equals(this.editData.getDefaultMeasureUnit().getId().toString())) continue;
                this.comboMeasure.setSelectedIndex(i);
            }
        }
        this.initMeasureUnit(this.editData);
    }

    private void initMeasureUnit(BgWorkTemplateInfo info) throws BOSException, EASBizException {
        this.table.setEnabled(false);
        this.table.setEditable(false);
        this.table.getStyleAttributes().setLocked(true);
        this.table.getStyleAttributes().setBackground(BgSHelper.LOCKED_COLOR);
        if (info.getBgMeasureUnit() != null && info.getBgMeasureUnit().size() != 0) {
            this.cbxMeasureSet.setSelected(true);
            this.table.setEnabled(true);
            this.table.setEditable(true);
            this.table.getStyleAttributes().setLocked(false);
            this.table.getStyleAttributes().setBackground(BgSHelper.BASE_COLOR);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> dataType = new HashSet<Integer>();
        dataType.add(new Integer(0));
        dataType.add(new Integer(1));
        dataType.add(new Integer(2));
        filter.getFilterItems().add(new FilterItemInfo("dataType", dataType, CompareType.INCLUDE));
        SorterItemInfo sorter = new SorterItemInfo("number");
        view.getSorter().add(sorter);
        view.setFilter(filter);
        IBgElement iElement = BgElementFactory.getRemoteInstance();
        if (iElement == null) {
            throw new BgException(BgException.NOINSTANCE);
        }
        IRow row = null;
        BgElementInfo eInfo2 = null;
        BgElementCollection bgECol = null;
        if (this.rpcDataMap.get("bgElementCol") instanceof BgElementCollection) {
            bgECol = (BgElementCollection)this.rpcDataMap.get("bgElementCol");
        }
        if (bgECol != null && !bgECol.isEmpty()) {
            this.table.checkParsed();
            this.table.removeRows();
            this.table.getColumn(0).getStyleAttributes().setLocked(true);
            this.table.getColumn(1).getStyleAttributes().setLocked(true);
            this.table.getColumn(2).getStyleAttributes().setLocked(true);
            this.table.getColumn(3).getStyleAttributes().setLocked(true);
            KDComboBox comboBox = new KDComboBox();
            DefaultComboBoxModel model = new DefaultComboBoxModel();
            EntityViewInfo muView = new EntityViewInfo();
            FilterInfo muFilter = new FilterInfo();
            muFilter.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
            muView.setFilter(muFilter);
            muView.getSorter().add(new SorterItemInfo("number"));
            IMeasureUnit iMeasureUnit = MeasureUnitFactory.getRemoteInstance();
            if (iMeasureUnit == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            MeasureUnitCollection muCol = null;
            if (this.rpcDataMap.get("muCol2") instanceof MeasureUnitCollection) {
                muCol = (MeasureUnitCollection)this.rpcDataMap.get("muCol2");
            }
            if (muCol != null && !muCol.isEmpty()) {
                model.addElement(null);
                Iterator iter = muCol.iterator();
                while (iter.hasNext()) {
                    model.addElement(iter.next());
                }
            }
            if (muCol != null) {
                muCol.clear();
            }
            comboBox.setModel(model);
            this.table.getColumn(4).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboBox));
            for (BgElementInfo eInfo2 : bgECol) {
                row = this.table.addRow();
                row.getCell(0).setValue((Object)eInfo2.getId().toString());
                row.getCell(1).setValue((Object)eInfo2.getNumber());
                row.getCell(2).setValue((Object)eInfo2.getName());
                row.getCell(3).setValue((Object)eInfo2.getDataType().getAlias());
                for (int k = 0; k < info.getBgMeasureUnit().size(); ++k) {
                    BgWorkTemMeasureUnitInfo measure = info.getBgMeasureUnit().get(k);
                    if (!measure.getBgElement().getId().toString().equals(eInfo2.getId().toString())) continue;
                    row.getCell(4).setValue((Object)measure.getMeasureUnit());
                }
                row.setUserObject((Object)eInfo2);
            }
        }
        if (bgECol != null) {
            bgECol.clear();
        }
        if (this.editData.getBgMeasureUnit().isEmpty()) {
            this.table.setEnabled(false);
            return;
        }
    }

    @Override
    protected void cbxMeasureSet_actionPerformed(ActionEvent e) throws Exception {
        super.cbxMeasureSet_actionPerformed(e);
        if (this.cbxMeasureSet.isSelected()) {
            this.table.setEnabled(true);
            this.table.setEditable(true);
            this.table.getStyleAttributes().setLocked(false);
            this.table.getStyleAttributes().setBackground(BgSHelper.BASE_COLOR);
        } else {
            this.table.setEnabled(false);
            this.table.setEditable(false);
            this.table.getStyleAttributes().setLocked(true);
            this.table.getStyleAttributes().setBackground(BgSHelper.LOCKED_COLOR);
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                this.table.getRow(i).getCell("measureUnit").setValue(null);
            }
        }
    }

    private boolean istrue() {
        boolean istrue = true;
        if (this.txtNumber.getText().length() > 80) {
            istrue = false;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgTemplateResource", (String)"tooLongNum"));
        }
        if (this.txtName.getText().length() > 80) {
            istrue = false;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgTemplateResource", (String)"tooLongName"));
        }
        if (this.txtDescription != null && this.txtDescription.getText().length() > 80) {
            istrue = false;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgTemplateResource", (String)"tooLongDescription"));
        }
        return istrue;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        IBgWorkTemplate iBgTem = BgWorkTemplateFactory.getRemoteInstance();
        if (this.canSave()) {
            this.editData.setData(null);
            if (this.cbxMeasureSet.isSelected()) {
                IRow row = null;
                BgWorkTemMeasureUnitInfo bgMeasureUnit = null;
                this.editData.getBgMeasureUnit().clear();
                int count = this.table.getBody().size();
                for (int index = 0; index < count; ++index) {
                    row = this.table.getRow(index);
                    if (row.getCell(4).getValue() == null) continue;
                    bgMeasureUnit = new BgWorkTemMeasureUnitInfo();
                    bgMeasureUnit.setBgworkTemplate(this.editData);
                    bgMeasureUnit.setBgElement((BgElementInfo)row.getUserObject());
                    bgMeasureUnit.setMeasureUnit((MeasureUnitInfo)row.getCell(4).getValue());
                    this.editData.getBgMeasureUnit().add(bgMeasureUnit);
                }
            } else {
                this.editData.getBgMeasureUnit().clear();
            }
            String msgSuccess = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgTemplateResource", (String)"templateSaveSuccess");
            if (this.getOprtState().equals("ADDNEW")) {
                if (!this.istrue()) {
                    return;
                }
                IObjectPK pk = iBgTem.addnew(this.editData);
                this.editData.setId(BOSUuid.read((String)pk.toString()));
                Book book = Book.Manager.getNewBook();
                this.editData.setBook(book);
                MsgBox.showInfo((Component)((Object)this), (String)msgSuccess.substring(2, msgSuccess.length()));
                BgCHelper.refreshListUI((CoreUI)this);
                this.getUIWindow().close();
            } else if (this.istrue()) {
                MsgBox.showInfo((String)msgSuccess.substring(2, msgSuccess.length()));
                BgCHelper.refreshListUI((CoreUI)this);
                this.getUIWindow().close();
            } else {
                return;
            }
        }
    }

    private boolean canSave() {
        String number = null;
        String name = null;
        number = this.txtNumber.getText().toString().trim();
        name = this.txtName.getText().toString().trim();
        if (this.comboMeasure.getItemCount() == 0) {
            this.comboMeasure.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgTemplateResource", (String)"measureSourceIsNull"));
            SysUtil.abort();
        }
        if (this.txtNumber.isEnabled() && number.equals("")) {
            this.txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgTemplateResource", (String)"numberIsNull"));
            SysUtil.abort();
        }
        if (name.equals("")) {
            this.txtName.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgTemplateResource", (String)"nameIsNull"));
            SysUtil.abort();
        }
        String textNum = this.txtNumber.getText();
        for (int i = 0; i < this.especialChar.length; ++i) {
            if (textNum.indexOf(this.especialChar[i]) == -1) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgEliminationResource", (String)"numberHasEspecialChar"));
            SysUtil.abort();
        }
        return true;
    }

    public boolean isModify() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            return false;
        }
        return super.isModify();
    }
}

