/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetOption;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.client.designer.IMenuStrategy;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.mutex.IVOChangeListener;
import com.kingdee.eas.framework.client.mutex.VOChangeEvent;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgItemObject;
import com.kingdee.eas.ma.budget.BgMessageClientHelper;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.client.NewBgItemGroupListF7UI;
import com.kingdee.eas.ma.nbudget.BgElimContextHelper;
import com.kingdee.eas.ma.nbudget.BgEliminationHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNLockProtectHelper;
import com.kingdee.eas.ma.nbudget.BgNTemplateHelper;
import com.kingdee.eas.ma.nbudget.BgWorkTemplateInfo;
import com.kingdee.eas.ma.nbudget.BgWorkTemplatePropertyAdapter;
import com.kingdee.eas.ma.nbudget.IBgElimContext;
import com.kingdee.eas.ma.nbudget.client.AbstractBgWorkTemplateProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgElimUIUtil;
import com.kingdee.eas.ma.nbudget.client.BgItemDisplayProvider;
import com.kingdee.eas.ma.nbudget.client.BgNFillHelper;
import com.kingdee.eas.ma.nbudget.client.BgUserCellDisplayProvider;
import com.kingdee.eas.ma.nbudget.client.BgWorkRender;
import com.kingdee.eas.ma.nbudget.client.BgWorkTemplateMenuManager;
import com.kingdee.eas.ma.nbudget.client.BgWorkTemplateProvider;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgWorkTemplateProcessUI
extends AbstractBgWorkTemplateProcessUI {
    private static final long serialVersionUID = -7148883534556676964L;
    private static final Logger logger = CoreUIObject.getLogger(BgWorkTemplateProcessUI.class);
    private BgWorkTemplateInfo templateInfo = null;
    private IBgElimContext ctx = BgElimContextHelper.getBgElimContext();

    @Override
    public void onLoad() throws Exception {
        if (this.getUIContext().get("ID") != null && this.getUIContext().get("InitDataObject") == null) {
            this.templateInfo = (BgWorkTemplateInfo)this.getBudgetProvider().queryEditData((IObjectPK)new ObjectUuidPK(this.getUIContext().get("ID").toString()));
        }
        super.onLoad();
        this.templateInfo = (BgWorkTemplateInfo)this.getBookProvider().getEditValue();
        BgUserCellDisplayProvider userCellDisplayProvider = new BgUserCellDisplayProvider();
        userCellDisplayProvider.setDisplayValueProvider(new BgItemDisplayProvider());
        this.getSpreadManager().registerCellDisplayProvider((ICellDisplayProvider)userCellDisplayProvider);
        this.getSpreadManager().getSpreadContainer().getUserObjectRegister().setUserList(new String[]{"ITEM"}, new String[]{BgMessageClientHelper.getMessage((String)"itemformula")});
        Object _obj = this.getBook().getUserObjectValue("VARIABLES");
        if (_obj == null || !(_obj instanceof ReportVariables)) {
            this.initVarialbes();
        } else {
            ReportVariables variables = (ReportVariables)_obj;
            if (variables.getAllVariables() == null || variables.getAllVariables().isEmpty()) {
                this.initVarialbes();
            }
        }
        this.getSpreadManager().getSpreadContainer().getActionManager().getAction("Sheet_Insert").setEnabled(true);
        this.getSpreadManager().getSpreadContainer().getActionManager().getAction("Sheet_Delete").setEnabled(true);
        this.getSpreadManager().getSpreadContainer().getActionManager().getAction("Sheet_MoveAndCopy").setEnabled(true);
    }

    @Override
    public void onShow() {
        super.onShow();
        this.setUiTitle();
        this.menuItemWorkTemplateWizard.setIcon(EASResource.getIcon((String)"imgTbtn_dengzsetting"));
        this.btnWorkTemplateWizard.setIcon(EASResource.getIcon((String)"imgTbtn_dengzsetting"));
        this.menuItemAddItem.setIcon(EASResource.getIcon((String)"imgTbtn_addsinglefile"));
        this.btnAddItem.setIcon(EASResource.getIcon((String)"imgTbtn_addsinglefile"));
        this.menuBatchEditFormula.setEnabled(false);
        this.menuBatchEditFormula.setVisible(false);
        this.itemShowLevelComboBox.setVisible(false);
        this.menuReportCheck.setVisible(true);
        this.btnCheck.setVisible(false);
        this.menuItemReportCheck.setVisible(false);
        this.menuItemViewFormula.setSelected(true);
        SheetOption so = this.getBook().getActiveSheet().getSheetOption();
        if (so.getCellDisplayMode() != 1) {
            so.setCellDisplayMode(1);
            this.getSpreadManager().getSpreadContainer().repaint();
        }
    }

    public void setUiTitle() {
        String title = EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgEliminationResource", (String)"workTemplate") + "-" + ((BgWorkTemplateInfo)this.getEditData()).getNumber();
        if (this.uiWindow instanceof Frame) {
            ((Frame)this.uiWindow).setTitle(title);
        } else if (this.uiWindow instanceof Dialog) {
            ((Dialog)this.uiWindow).setTitle(title);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionClearItemFormula_actionPerformed(ActionEvent e) throws Exception {
        this.getBook().getUndoManager().startGroup();
        try {
            this.checkBeforeEditRange();
            Cell cell = null;
            Sheet sheet = this.getBook().getActiveSheet();
            Range range = sheet.getSelectionRange();
            int num = range.size();
            if (num <= 0) {
                return;
            }
            for (int i = 0; i < range.size(); ++i) {
                CellBlock block = range.getBlock(i);
                for (int j = block.getRow(); j <= block.getRow2(); ++j) {
                    for (int k = block.getCol(); k <= block.getCol2(); ++k) {
                        cell = sheet.getCell(j, k, false);
                        if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                        BgNTemplateHelper.clearFormulaOfCell(cell, true);
                    }
                }
            }
        }
        finally {
            this.getBook().getUndoManager().endGroup();
        }
    }

    private void checkBeforeEditRange() {
        Sheet sheet = this.getBook().getActiveSheet();
        Range range = this.getBook().getActiveSheet().getSelectionRange();
        boolean locked = false;
        Protection pro = sheet.getSheetOption().getProtection(false);
        boolean isPro = false;
        if (pro != null && pro.isProtected() && !pro.allowEditObjects()) {
            isPro = true;
        }
        for (int i = 0; i < range.size(); ++i) {
            CellBlock block = range.getBlock(i);
            block1: for (int j = block.getRow(); j <= block.getRow2(); ++j) {
                for (int k = block.getCol(); k <= block.getCol2(); ++k) {
                    Cell currentIteratorCell = sheet.getCell(j, k, false);
                    if (currentIteratorCell == null || !isPro || !BgNLockProtectHelper.isCellLocked(currentIteratorCell)) continue;
                    locked = true;
                    continue block1;
                }
            }
        }
        if (locked) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"exit.cell.lock"));
            SysUtil.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionWorkTemplateWizard_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkTemplateWizard_actionPerformed(e);
        BgWorkTemplateInfo info = (BgWorkTemplateInfo)this.getEditData();
        this.getBook().getUndoManager().startGroup();
        try {
            UIContext uiContext = new UIContext((Object)this);
            if (this.ctx.getCurMappedOrgUnit() != null) {
                uiContext.put((Object)"ORGUNITID", (Object)BgSHelper.getIsolateOrg((String)this.ctx.getCurMappedOrgUnit().getId().toString()));
            }
            BgElimUIUtil.workTemplateWizard(this, info, uiContext);
            this.repaint();
        }
        finally {
            this.getBook().getUndoManager().endGroup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAddItem_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddItem_actionPerformed(e);
        int rowBase = -1;
        int colBase = -1;
        Sheet sheet = this.getBook().getActiveSheet();
        Range range = null;
        HashMap map = BgEliminationHelper.getBasePosition(sheet);
        if (map != null && map.get("top") != null && map.get("left") != null) {
            rowBase = (Integer)map.get("top");
            colBase = (Integer)map.get("left");
        }
        if (rowBase != -1 && colBase != -1) {
            range = BgNFillHelper.getSelectRange((IUIObject)this, sheet);
            int colIndex = range.getBlock(0).getCol();
            int rowIndex = range.getBlock(0).getRow();
            if (colIndex != colBase) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgEliminationResource", (String)"plsAddItemOnBaseCol"));
                SysUtil.abort();
            }
            if (rowIndex <= rowBase) {
                return;
            }
            range.setIgnoreProtected(true);
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"isSelectCombinItem", (Object)Boolean.FALSE);
            if (this.ctx.getCurMappedOrgUnit() != null) {
                uiContext.put((Object)"ORGUNITID", (Object)this.ctx.getCurMappedOrgUnit().getId().toString());
            }
            IUIWindow uiWindow = null;
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.budget.client.NewBgItemGroupListF7UI", (Map)uiContext);
            }
            catch (UIException ex) {
                ExceptionHandler.handle((Throwable)ex);
                return;
            }
            NewBgItemGroupListF7UI f7ui = (NewBgItemGroupListF7UI)uiWindow.getUIObject();
            uiWindow.show();
            if (f7ui.getResult() != null && ((BgItemObject)f7ui.getResult()).getResult().size() != 0) {
                this.getBook().getUndoManager().enable(true);
                this.getBook().getUndoManager().startGroup();
                try {
                    BgItemCollection col = ((BgItemObject)f7ui.getResult()).getResult();
                    int size = col.size();
                    int colCount = sheet.getMaxColIndex() + 1;
                    BgItemInfo item = null;
                    Cell curCell = null;
                    Range curRange = null;
                    Row curRow = null;
                    Column curCol = null;
                    int curRowIndex = rowIndex;
                    int curColIndex = colIndex;
                    Map props = null;
                    for (int i = 0; i < size; ++i) {
                        item = col.get(i);
                        for (int j = 0; j < colCount; ++j) {
                            curRow = sheet.getRow(curRowIndex, true);
                            curCol = sheet.getColumn(curColIndex, true);
                            curCell = sheet.getCell(curRowIndex, curColIndex, true);
                            curRange = sheet.getRange(curCell);
                            if (curColIndex == colBase) {
                                curRange.setValue(new Variant((Object)item.getName()));
                                curCell.getRowObject().setUserObject("WORK_ROW_ITEM", (Object)item.getNumber());
                            } else {
                                props = (Map)curCol.getUserObjectValue("WORK_COL_DATA");
                                if (props != null && props.get("WORK_DATA_SRC_TYPE") instanceof String && props.get("BG_ELEMENT") instanceof String) {
                                    String dataSrcType = (String)props.get("WORK_DATA_SRC_TYPE");
                                    String bgElement = (String)props.get("BG_ELEMENT");
                                    if (dataSrcType.equals("4")) {
                                        ItemFormula itemFormula = new ItemFormula(this.constructFormula(item.getNumber(), bgElement));
                                        curRange.setUserObject("ITEM", (Object)itemFormula);
                                    }
                                }
                            }
                            ++curColIndex;
                        }
                        ++curRowIndex;
                        curColIndex = colIndex;
                    }
                }
                finally {
                    this.getBook().getUndoManager().endGroup();
                }
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgEliminationResource", (String)"plsAddItemOnBaseCol"));
            SysUtil.abort();
        }
    }

    private String constructFormula(String bgItem, String bgElement) {
        if (bgItem == null || bgElement == null) {
            return null;
        }
        String bgPeriodNumber = "";
        String currencyNumber = "";
        String formulaLine = "=BgItem(\"" + bgItem + "\",\"" + bgPeriodNumber + "\",\"" + bgElement + "\",\"BgData\",true,\"" + currencyNumber + "\")";
        return formulaLine;
    }

    protected boolean checkBeforeWindowClosing() {
        BgNFSHelper.printBookRowSign(this.getBook());
        this.getSpreadManager().getSpreadContainer().getStateManager().stopEditing();
        boolean bclose = false;
        if (this.getBook().getUndoManager().canUndo() && !OprtState.VIEW.equals(this.getOprtState())) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                try {
                    this.actionSave_actionPerformed(null);
                    bclose = true;
                }
                catch (Exception exc) {
                    this.handUIException(exc);
                    SysUtil.abort();
                    bclose = false;
                }
                if (bclose) {
                    this.releaseNetControl();
                }
            } else {
                bclose = result == 1;
            }
        } else {
            bclose = super.checkBeforeWindowClosing();
        }
        return bclose;
    }

    protected void releaseNetControl() {
        if (!"RequestMutex_Failed".equals(this.getOprtState())) {
            this.setOprtState("RELEASEALL");
            try {
                if (this.getBookProvider().getEditValue() == null) {
                    return;
                }
                this.fireVOChangeListener(this.getBookProvider().getEditValue(), false);
            }
            catch (Throwable e) {
                this.handUIException(e);
                this.abort();
            }
        }
    }

    private void fireVOChangeListener(IObjectValue newObject, boolean requestLock) throws Throwable {
        IVOChangeListener listener = this.getVOChangeListener();
        if (listener != null) {
            VOChangeEvent e = new VOChangeEvent((Object)this);
            if ((IObjectValue)this.getUIContext().get("CURRENT.VO") != null) {
                e.setCurrentObject((IObjectValue)this.getUIContext().get("CURRENT.VO"));
            }
            e.setState(this.getOprtState());
            if (requestLock) {
                e.setNewObjectId(newObject.getBOSUuid(this.getBookProvider().getEditValue().getPKField()).toString());
            } else {
                e.setCurrentObjectId(newObject.getBOSUuid(this.getBookProvider().getEditValue().getPKField()).toString());
            }
            listener.change(e);
        }
    }

    public BgWorkTemplateInfo getTemplateInfo() {
        return this.templateInfo;
    }

    public void setTemplateInfo(BgWorkTemplateInfo templateInfo) {
        this.templateInfo = templateInfo;
    }

    @Override
    public IMenuStrategy getBudgetMenuStrategy() {
        return new BgWorkTemplateMenuManager((Component)((Object)this));
    }

    @Override
    public IBookProvider getBudgetProvider() {
        return new BgWorkTemplateProvider(this);
    }

    protected CoreBaseInfo getEditData() {
        return (CoreBaseInfo)this.getBookProvider().getEditValue();
    }

    @Override
    protected BgUserCellDisplayProvider getCellDisplayRender() {
        BgUserCellDisplayProvider.addRenderProvider(new BgWorkRender());
        return super.getCellDisplayRender();
    }

    @Override
    public IReportPropertyAdapter getBudgetPropertyAdapter() {
        return new BgWorkTemplatePropertyAdapter();
    }
}

