/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.budget.BgItemGroupFactory;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.client.BgItemGroupInDialog;
import com.kingdee.eas.ma.nbudget.BgElimTypeEnum;
import com.kingdee.eas.ma.nbudget.client.AbstractBgWorkTemplateSelectItemUI;
import com.kingdee.eas.ma.nbudget.client.BgWorkTemplateWizard_ChooseItemsUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgWorkTemplateSelectItemUI
extends AbstractBgWorkTemplateSelectItemUI {
    private static final Logger logger = CoreUIObject.getLogger(BgWorkTemplateSelectItemUI.class);
    private String orgUnitId = null;
    private Set selectedItemNums = new HashSet();
    private List result = new ArrayList();
    private String col_number = "number";
    private String col_name = "name";
    private String col_elimType = "elimType";
    private String col_level = "level";
    private boolean cancel = false;

    public void onLoad() throws Exception {
        List items;
        super.onLoad();
        BgItemGroupInDialog boxItemGroup = new BgItemGroupInDialog((IUIObject)this);
        this.bizItemGroup.setSelector((KDPromptSelector)boxItemGroup);
        this.bizItemGroup.setEditFormat("$number$");
        this.bizItemGroup.setEditFormat("$number$");
        if (this.getUIContext().get("ORGUNITID") != null) {
            this.setOrgUnitId((String)this.getUIContext().get("ORGUNITID"));
        }
        if (this.getUIContext().get("Owner") instanceof BgWorkTemplateWizard_ChooseItemsUI && (items = ((BgWorkTemplateWizard_ChooseItemsUI)((Object)this.getUIContext().get("Owner"))).getBgItems()) instanceof List) {
            this.fillSelectedItems(items);
            this.getResult().clear();
            this.getResult().addAll(items);
        }
    }

    private void fillSelectedItems(List items) {
        if (items == null || items.isEmpty()) {
            return;
        }
        Object obj = null;
        BgItemInfo info = null;
        IRow rowR = null;
        String itemNumber = null;
        this.selectedItemTable.checkParsed();
        this.selectedItemTable.setRefresh(false);
        for (int i = 0; i < items.size(); ++i) {
            obj = items.get(i);
            if (!(obj instanceof BgItemInfo) || StringUtils.isEmpty((String)(itemNumber = (info = (BgItemInfo)obj).getNumber())) || this.selectedItemNums.contains(itemNumber)) continue;
            this.selectedItemNums.add(itemNumber);
            rowR = this.selectedItemTable.addRow();
            rowR.getCell(this.col_number).setValue((Object)info.getNumber());
            rowR.getCell(this.col_name).setValue((Object)info.getName());
            rowR.getCell(this.col_elimType).setValue((Object)info.getElimType());
            rowR.getCell(this.col_level).setValue((Object)("" + info.getLevel()));
            rowR.setUserObject((Object)info);
        }
        this.selectedItemTable.setRefresh(true);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnSelect.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnAntiSelect.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnAntiSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnUp.setText("");
        this.btnDown.setText("");
        this.btnTop.setText("");
        this.btnBottom.setText("");
        this.btnTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.btnUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.itemTable.getSelectManager().setSelectMode(10);
        this.selectedItemTable.getSelectManager().setSelectMode(10);
        this.itemTable.setEditable(false);
        this.selectedItemTable.setEditable(false);
    }

    @Override
    protected void bizItemGroup_dataChanged(DataChangeEvent e) throws Exception {
        super.bizItemGroup_dataChanged(e);
        if (this.bizItemGroup.getData() == null) {
            return;
        }
        if (this.bizItemGroup.getData() instanceof String) {
            String sql = "select id,number,name,elimType,level where number = '" + this.bizItemGroup.getData().toString() + "'";
            BgItemGroupInfo item = null;
            try {
                item = BgItemGroupFactory.getRemoteInstance().getBgItemGroupInfo(sql);
            }
            catch (Exception e1) {
                logger.error((Object)e1);
            }
            this.bizItemGroup.setData((Object)item);
        }
        if (this.bizItemGroup.getData() != null && this.bizItemGroup.getData() instanceof BgItemGroupInfo) {
            BgItemGroupInfo group = (BgItemGroupInfo)this.bizItemGroup.getData();
            IQueryExecutor queryExecutor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.ma.budget.BgItemListQuery"));
            queryExecutor.setObjectView(" WHERE bgItemGroup.id = '" + group.getId() + "' and isEffective = 1");
            EntityViewInfo viewInfo = queryExecutor.getObjectView();
            FilterInfo filter = viewInfo.getFilter();
            int maskSize = filter.getFilterItems().size();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.getOrgUnitId(), CompareType.EQUALS));
            if (StringUtils.isEmpty((String)filter.getMaskString())) {
                filter.setMaskString("#0");
            } else {
                filter.setMaskString("(" + filter.getMaskString() + ") and #" + String.valueOf(maskSize));
            }
            queryExecutor.setObjectView(viewInfo);
            IRowSet rowSet = queryExecutor.executeQuery();
            this.itemTable.removeRows();
            while (rowSet.next()) {
                BgItemInfo item = this.createBgItem(rowSet);
                item.put("myItemGroup", (Object)group);
                IRow row = this.itemTable.addRow();
                row.getCell(this.col_number).setValue((Object)item.getNumber());
                row.getCell(this.col_name).setValue((Object)item.getName());
                row.getCell(this.col_elimType).setValue((Object)item.getElimType());
                row.getCell(this.col_level).setValue((Object)("" + item.getLevel()));
                row.setUserObject((Object)item);
            }
        }
    }

    private BgItemInfo createBgItem(IRowSet rowSet) throws SQLException {
        String number = rowSet.getString(this.col_number);
        String name = rowSet.getString(this.col_name);
        String refField = rowSet.getString("refField");
        int elimType = rowSet.getInt(this.col_elimType);
        int level = rowSet.getInt(this.col_level);
        String bgItemGroupId = rowSet.getString("bgItemGroup.id");
        String bgItemGroupNumber = rowSet.getString("bgItemGroup.number");
        BgItemInfo item = new BgItemInfo();
        item.setNumber(number);
        item.setName(name);
        item.setRefField(refField);
        item.setElimType(BgElimTypeEnum.getEnum(elimType));
        item.setLevel(level);
        BgItemGroupInfo group = new BgItemGroupInfo();
        group.setId(BOSUuid.read((String)bgItemGroupId));
        group.setNumber(bgItemGroupNumber);
        item.setBgItemGroup(group);
        return item;
    }

    @Override
    protected void btnSelect_actionPerformed(ActionEvent e) throws Exception {
        int size = this.itemTable.getSelectManager().size();
        IRow rowL = null;
        IRow rowR = null;
        String itemNumber = null;
        for (int i = size - 1; i >= 0; --i) {
            int j;
            KDTSelectBlock sb = this.itemTable.getSelectManager().get(i);
            if (sb == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgTemFormatResource", (String)"selectLeftItem"));
                return;
            }
            int beginIndex = sb.getBeginRow();
            int endIndex = sb.getEndRow();
            for (j = beginIndex; j <= endIndex; ++j) {
                rowL = this.itemTable.getRow(j);
                itemNumber = (String)rowL.getCell(this.col_number).getValue();
                if (StringUtils.isEmpty((String)itemNumber) || this.selectedItemNums.contains(itemNumber)) continue;
                this.selectedItemNums.add(itemNumber);
                rowR = this.selectedItemTable.addRow();
                rowR.getCell(this.col_number).setValue(rowL.getCell(this.col_number).getValue());
                rowR.getCell(this.col_name).setValue(rowL.getCell(this.col_name).getValue());
                rowR.getCell(this.col_elimType).setValue(rowL.getCell(this.col_elimType).getValue());
                rowR.getCell(this.col_level).setValue(rowL.getCell(this.col_level).getValue());
                rowR.setUserObject(rowL.getUserObject());
            }
            for (j = endIndex; j >= beginIndex; --j) {
                this.itemTable.removeRow(j);
            }
        }
    }

    @Override
    protected void btnAntiSelect_actionPerformed(ActionEvent e) throws Exception {
        int size = this.selectedItemTable.getSelectManager().size();
        IRow rowR = null;
        IRow rowL = null;
        String itemNumber = null;
        Object obj = null;
        for (int i = size - 1; i >= 0; --i) {
            int endIndex;
            KDTSelectBlock sb = this.selectedItemTable.getSelectManager().get(i);
            if (sb == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgTemFormatResource", (String)"selectLeftItem"));
                return;
            }
            int beginIndex = sb.getBeginRow();
            for (int j = endIndex = sb.getEndRow(); j >= beginIndex; --j) {
                rowR = this.selectedItemTable.getRow(j);
                itemNumber = (String)rowR.getCell(this.col_number).getValue();
                if (StringUtils.isEmpty((String)itemNumber)) continue;
                this.selectedItemNums.remove(itemNumber);
                rowL = this.itemTable.addRow();
                rowL.getCell(this.col_number).setValue(rowR.getCell(this.col_number).getValue());
                rowL.getCell(this.col_name).setValue(rowR.getCell(this.col_name).getValue());
                rowL.getCell(this.col_elimType).setValue(rowR.getCell(this.col_elimType).getValue());
                rowL.getCell(this.col_level).setValue(rowR.getCell(this.col_level).getValue());
                rowL.setUserObject(rowR.getUserObject());
                this.selectedItemTable.removeRow(j);
            }
        }
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.itemTable.getRowCount();
        IRow rowL = null;
        IRow rowR = null;
        String itemNumber = null;
        if (rowCount == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgTemFormatResource", (String)"selectLeftItem"));
            return;
        }
        for (int i = 0; i < rowCount; ++i) {
            rowL = this.itemTable.getRow(i);
            itemNumber = (String)rowL.getCell(this.col_number).getValue();
            if (StringUtils.isEmpty((String)itemNumber) || this.selectedItemNums.contains(itemNumber)) continue;
            this.selectedItemNums.add(itemNumber);
            rowR = this.selectedItemTable.addRow();
            rowR.getCell(this.col_number).setValue(rowL.getCell(this.col_number).getValue());
            rowR.getCell(this.col_name).setValue(rowL.getCell(this.col_name).getValue());
            rowR.getCell(this.col_elimType).setValue(rowL.getCell(this.col_elimType).getValue());
            rowR.getCell(this.col_level).setValue(rowL.getCell(this.col_level).getValue());
            rowR.setUserObject(rowL.getUserObject());
        }
        this.itemTable.removeRows();
    }

    @Override
    protected void btnAntiSelectAll_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.selectedItemTable.getRowCount();
        IRow rowL = null;
        IRow rowR = null;
        for (int i = 0; i < rowCount; ++i) {
            rowR = this.selectedItemTable.getRow(i);
            rowL = this.itemTable.addRow();
            rowL.getCell(this.col_number).setValue(rowR.getCell(this.col_number).getValue());
            rowL.getCell(this.col_name).setValue(rowR.getCell(this.col_name).getValue());
            rowL.getCell(this.col_elimType).setValue(rowR.getCell(this.col_elimType).getValue());
            rowL.getCell(this.col_level).setValue(rowR.getCell(this.col_level).getValue());
            rowL.setUserObject(rowR.getUserObject());
        }
        this.selectedItemTable.removeRows();
        this.selectedItemNums.clear();
    }

    @Override
    protected void btnUp_actionPerformed(ActionEvent e) throws Exception {
        this.moveUp();
    }

    @Override
    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        this.moveDown();
    }

    @Override
    protected void btnTop_actionPerformed(ActionEvent e) throws Exception {
        while (this.moveUp()) {
        }
    }

    @Override
    protected void btnBottom_actionPerformed(ActionEvent e) throws Exception {
        while (this.moveDown()) {
        }
    }

    protected boolean moveUp() {
        IRow[] rows = this.getTableSelection(this.selectedItemTable);
        Arrays.sort(rows, new RowIdxComparer());
        if (rows.length > 0) {
            if (rows[0].getRowIndex() == 0) {
                return false;
            }
        } else {
            return false;
        }
        this.selectedItemTable.getSelectManager().removeAll();
        boolean moved = false;
        for (int i = 0; i < rows.length; ++i) {
            IRow row = rows[i];
            int r = rows[i].getRowIndex();
            if (r == 0) break;
            moved = true;
            this.selectedItemTable.removeRow(r);
            this.selectedItemTable.addRow(r - 1, row);
            KDTSelectBlock sel = new KDTSelectBlock();
            sel.setTable(this.selectedItemTable);
            sel.setTop(r - 1);
            sel.setBottom(r - 1);
            sel.setMode(2);
            this.selectedItemTable.getSelectManager().add(sel);
        }
        if (moved) {
            this.selectedItemTable.setRefresh(true);
        }
        return true;
    }

    protected boolean moveDown() {
        IRow row;
        int r;
        int rowcount = this.selectedItemTable.getRowCount();
        IRow[] rows = this.getTableSelection(this.selectedItemTable);
        Arrays.sort(rows, new RowIdxComparer());
        if (rows.length > 0) {
            if (rows[rows.length - 1].getRowIndex() == rowcount - 1) {
                return false;
            }
        } else {
            return false;
        }
        this.selectedItemTable.getSelectManager().removeAll();
        boolean moved = false;
        for (int i = rows.length - 1; i >= 0 && (r = (row = rows[i]).getRowIndex()) != rowcount - 1; --i) {
            moved = true;
            this.selectedItemTable.removeRow(r);
            this.selectedItemTable.addRow(r + 1, row);
            KDTSelectBlock sel = new KDTSelectBlock();
            sel.setTable(this.selectedItemTable);
            sel.setTop(r + 1);
            sel.setBottom(r + 1);
            sel.setMode(2);
            this.selectedItemTable.getSelectManager().add(sel);
        }
        if (moved) {
            this.selectedItemTable.setRefresh(true);
        }
        return true;
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        this.getResult().clear();
        int rowCount = this.selectedItemTable.getRowCount();
        IRow row = null;
        BgItemInfo info = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.selectedItemTable.getRow(i);
            info = new BgItemInfo();
            info.setNumber((String)row.getCell(this.col_number).getValue());
            info.setName((String)row.getCell(this.col_name).getValue());
            if (row.getCell(this.col_elimType).getValue() instanceof BgElimTypeEnum) {
                info.setElimType((BgElimTypeEnum)((Object)row.getCell(this.col_elimType).getValue()));
            }
            info.setLevel(Integer.valueOf((String)row.getCell(this.col_level).getValue()).intValue());
            this.getResult().add(info);
        }
        this.setCancel(false);
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    protected void btnAbandon_actionPerformed(ActionEvent e) throws Exception {
        this.setCancel(true);
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    protected void itemTable_tableClicked(KDTMouseEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        IRow rowL = null;
        IRow rowR = null;
        String itemNumber = null;
        if (e.getClickCount() == 2) {
            rowL = this.itemTable.getRow(rowIndex);
            if (rowL == null) {
                return;
            }
            itemNumber = (String)rowL.getCell(this.col_number).getValue();
            if (!StringUtils.isEmpty((String)itemNumber) && !this.selectedItemNums.contains(itemNumber)) {
                this.selectedItemNums.add(itemNumber);
                rowR = this.selectedItemTable.addRow();
                rowR.getCell(this.col_number).setValue(rowL.getCell(this.col_number).getValue());
                rowR.getCell(this.col_name).setValue(rowL.getCell(this.col_name).getValue());
                rowR.getCell(this.col_elimType).setValue(rowL.getCell(this.col_elimType).getValue());
                rowR.getCell(this.col_level).setValue(rowL.getCell(this.col_level).getValue());
                rowR.setUserObject(rowL.getUserObject());
                this.itemTable.removeRow(rowIndex);
            }
        }
    }

    @Override
    protected void selectedItemTable_tableClicked(KDTMouseEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        IRow rowL = null;
        IRow rowR = null;
        String itemNumber = null;
        if (e.getClickCount() == 2) {
            rowR = this.selectedItemTable.getRow(rowIndex);
            if (rowR == null) {
                return;
            }
            itemNumber = (String)rowR.getCell(this.col_number).getValue();
            this.selectedItemNums.remove(itemNumber);
            rowL = this.itemTable.addRow();
            rowL.getCell(this.col_number).setValue(rowR.getCell(this.col_number).getValue());
            rowL.getCell(this.col_name).setValue(rowR.getCell(this.col_name).getValue());
            rowL.getCell(this.col_elimType).setValue(rowR.getCell(this.col_elimType).getValue());
            rowL.getCell(this.col_level).setValue(rowR.getCell(this.col_level).getValue());
            rowL.setUserObject(rowR.getUserObject());
            this.selectedItemTable.removeRow(rowIndex);
        }
    }

    public String getOrgUnitId() {
        return this.orgUnitId;
    }

    public void setOrgUnitId(String orgUnitId) {
        this.orgUnitId = orgUnitId;
    }

    public Set getSelectedItemNums() {
        return this.selectedItemNums;
    }

    public void setSelectedItemNums(Set selectedItemNums) {
        this.selectedItemNums = selectedItemNums;
    }

    public List getResult() {
        return this.result;
    }

    public void setResult(List result) {
        this.result = result;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public void setCancel(boolean cancel) {
        this.cancel = cancel;
    }

    protected IRow[] getTableSelection(KDTable tbl) {
        ArrayList blocks = tbl.getSelectManager().getBlocks();
        ArrayList<IRow> rows = new ArrayList<IRow>();
        for (int i = 0; i < blocks.size(); ++i) {
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(i);
            if (block.getMode() == 8) {
                for (int j = 0; j < tbl.getRowCount(); ++j) {
                    rows.add(tbl.getRow(j));
                }
                break;
            }
            for (int row = block.getBeginRow(); row <= block.getEndRow(); ++row) {
                rows.add(tbl.getRow(row));
            }
        }
        return rows.toArray(new IRow[rows.size()]);
    }

    class RowIdxComparer
    implements Comparator {
        RowIdxComparer() {
        }

        public int compare(Object row1, Object row2) {
            return ((IRow)row1).getRowIndex() - ((IRow)row2).getRowIndex();
        }
    }
}

