/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgWorkTemplateWizard_ChooseBgElementUI;
import com.kingdee.eas.ma.nbudget.client.BgElimUIUtil;
import com.kingdee.eas.ma.nbudget.client.BgWorkTemplateWizard_ChooseTableHead;
import com.kingdee.eas.ma.nbudget.client.BgWorkTemplateWizard_ShowResult_Items;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgWorkTemplateWizard_ChooseBgElementUI
extends AbstractBgWorkTemplateWizard_ChooseBgElementUI {
    private static final Logger logger = CoreUIObject.getLogger(BgWorkTemplateWizard_ChooseBgElementUI.class);
    public Sheet curSheet;
    private List selectedElements = new ArrayList();

    public void onLoad() throws Exception {
        super.onLoad();
        BgElimUIUtil.initGuideImage(this.pnlImage);
        this.btnFinished.setEnabled(false);
        this.btnHelp.setVisible(false);
        BgElimUIUtil.hmUIs.put(BgWorkTemplateWizard_ChooseBgElementUI.class.getName(), this);
        this.curSheet = (Sheet)this.getUIContext().get("curSheet");
        this.getUIdata();
        this.loadBgElements();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
    }

    private void getUIdata() throws Exception {
        Cell curCell = null;
        String formulaStr = null;
        String[] params = null;
        if (this.curSheet == null) {
            return;
        }
        for (int i = 0; i <= this.curSheet.getMaxColIndex(); ++i) {
            for (int j = 0; j <= this.curSheet.getMaxRowIndex(); ++j) {
                curCell = this.curSheet.getCell(j, i, true);
                if (!BgNFSHelper.checkHasFormulaOfCell(curCell) || (params = BgNFSHelper.parseFormulaPara(null, formulaStr = BgNFSHelper.getFormulaOfCell(curCell))) == null || StringUtils.isEmpty((String)params[2]) || this.selectedElements.contains(params[2])) continue;
                this.selectedElements.add(params[2]);
            }
        }
    }

    private void loadBgElements() throws Exception {
        String oql = "select id, number, name, dataType, isApportionable, type order by number";
        IBgElement iBgElement = BgElementFactory.getRemoteInstance();
        BgElementCollection col = iBgElement.getBgElementCollection(oql);
        BgElementInfo info = null;
        String number = null;
        IRow row = null;
        if (col != null && !col.isEmpty()) {
            int i;
            this.tblMain.checkParsed();
            this.tblMain.setRefresh(false);
            this.tblMain.removeRows();
            int size = col.size();
            if (!this.selectedElements.isEmpty()) {
                for (i = 0; i < this.selectedElements.size(); ++i) {
                    number = (String)this.selectedElements.get(i);
                    for (int j = 0; j < size; ++j) {
                        if (col.get(j).getNumber().equals(number)) {
                            info = col.get(j);
                            break;
                        }
                        info = null;
                    }
                    if (info == null) continue;
                    row = this.tblMain.addRow();
                    row.setUserObject(info);
                    row.getCell("id").setValue((Object)info.getId().toString());
                    row.getCell("select").setValue((Object)new Boolean(true));
                    row.getCell("number").setValue((Object)info.getNumber());
                    row.getCell("name").setValue((Object)info.getName());
                    row.getCell("dataFormat").setValue((Object)info.getDataType());
                    row.getCell("dataType").setValue((Object)info.getType());
                    row.getCell("isApportionable").setValue((Object)new Boolean(info.isIsApportionable()));
                }
            }
            for (i = 0; i < size; ++i) {
                if (this.selectedElements.contains(col.get(i).getNumber())) continue;
                row = this.tblMain.addRow();
                row.setUserObject((Object)col.get(i));
                row.getCell("id").setValue((Object)col.get(i).getId().toString());
                row.getCell("select").setValue((Object)new Boolean(false));
                row.getCell("number").setValue((Object)col.get(i).getNumber());
                row.getCell("name").setValue((Object)col.get(i).getName());
                row.getCell("dataFormat").setValue((Object)col.get(i).getDataType());
                row.getCell("dataType").setValue((Object)col.get(i).getType());
                row.getCell("isApportionable").setValue((Object)new Boolean(col.get(i).isIsApportionable()));
            }
            this.tblMain.setRefresh(true);
        }
    }

    public List getResult() {
        int rowCount = this.tblMain.getRowCount();
        ArrayList<BgElementInfo> result = new ArrayList<BgElementInfo>();
        BgElementInfo info = null;
        IRow row = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            if (!(row.getCell(1).getValue() instanceof Boolean) || !((Boolean)row.getCell(1).getValue()).booleanValue()) continue;
            info = new BgElementInfo();
            info.setId(BOSUuid.read((String)((String)row.getCell("id").getValue())));
            info.setNumber((String)row.getCell("number").getValue());
            info.setName((String)row.getCell("name").getValue());
            result.add(info);
        }
        return result;
    }

    private boolean verifyInput() {
        int rowCount = this.tblMain.getRowCount();
        IRow row = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            if (!(row.getCell(1).getValue() instanceof Boolean) || !((Boolean)row.getCell(1).getValue()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        if (BgElimUIUtil.isCloseWindow((Component)((Object)this))) {
            BgElimUIUtil.closeAllUI();
        }
    }

    @Override
    protected void btnPreStep_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().hide();
        Object obj = BgElimUIUtil.hmUIs.get(this.getPreUIName());
        if (obj != null && obj instanceof CoreUI) {
            CoreUI preUI = (CoreUI)obj;
            preUI.getUIWindow().show();
            this.getUIWindow().hide();
        }
    }

    @Override
    protected void btnNextStep_actionPerformed(ActionEvent e) throws Exception {
        if (!this.verifyInput()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"msgSelectEle"));
            SysUtil.abort();
        }
        this.getUIWindow().hide();
        if (BgElimUIUtil.hmUIs.get(this.getNextUIName()) == null) {
            UIContext uiContext = new UIContext((Object)this);
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getNextUIName(), (Map)uiContext, null, this.getOprtState());
            window.show();
        } else {
            Object obj = BgElimUIUtil.hmUIs.get(this.getNextUIName());
            if (obj instanceof CoreUI) {
                CoreUI nextUI = (CoreUI)obj;
                nextUI.onLoad();
                nextUI.getUIWindow().show();
            }
        }
    }

    private String getNextUIName() {
        return BgWorkTemplateWizard_ShowResult_Items.class.getName();
    }

    private String getPreUIName() {
        return BgWorkTemplateWizard_ChooseTableHead.class.getName();
    }

    @Override
    protected void btnUp_actionPerformed(ActionEvent e) throws Exception {
        this.moveUp();
    }

    @Override
    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        this.moveDown();
    }

    protected boolean moveUp() {
        IRow[] rows = this.getTableSelection(this.tblMain);
        Arrays.sort(rows, new RowIdxComparer());
        if (rows.length > 0) {
            if (rows[0].getRowIndex() == 0) {
                return false;
            }
        } else {
            return false;
        }
        this.tblMain.getSelectManager().removeAll();
        boolean moved = false;
        for (int i = 0; i < rows.length; ++i) {
            IRow row = rows[i];
            int r = rows[i].getRowIndex();
            if (r == 0) break;
            moved = true;
            this.tblMain.removeRow(r);
            this.tblMain.addRow(r - 1, row);
            KDTSelectBlock sel = new KDTSelectBlock();
            sel.setTable(this.tblMain);
            sel.setTop(r - 1);
            sel.setBottom(r - 1);
            sel.setMode(2);
            this.tblMain.getSelectManager().add(sel);
        }
        if (moved) {
            this.tblMain.setRefresh(true);
        }
        return true;
    }

    protected boolean moveDown() {
        IRow row;
        int r;
        int rowcount = this.tblMain.getRowCount();
        IRow[] rows = this.getTableSelection(this.tblMain);
        Arrays.sort(rows, new RowIdxComparer());
        if (rows.length > 0) {
            if (rows[rows.length - 1].getRowIndex() == rowcount - 1) {
                return false;
            }
        } else {
            return false;
        }
        this.tblMain.getSelectManager().removeAll();
        boolean moved = false;
        for (int i = rows.length - 1; i >= 0 && (r = (row = rows[i]).getRowIndex()) != rowcount - 1; --i) {
            moved = true;
            this.tblMain.removeRow(r);
            this.tblMain.addRow(r + 1, row);
            KDTSelectBlock sel = new KDTSelectBlock();
            sel.setTable(this.tblMain);
            sel.setTop(r + 1);
            sel.setBottom(r + 1);
            sel.setMode(2);
            this.tblMain.getSelectManager().add(sel);
        }
        if (moved) {
            this.tblMain.setRefresh(true);
        }
        return true;
    }

    protected IRow[] getTableSelection(KDTable tbl) {
        ArrayList blocks = tbl.getSelectManager().getBlocks();
        ArrayList<IRow> rows = new ArrayList<IRow>();
        for (int i = 0; i < blocks.size(); ++i) {
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(i);
            if (block.getMode() == 8) {
                for (int j = 0; j < tbl.getRowCount(); ++j) {
                    rows.add(tbl.getRow(j));
                }
                break;
            }
            for (int row = block.getBeginRow(); row <= block.getEndRow(); ++row) {
                rows.add(tbl.getRow(row));
            }
        }
        return rows.toArray(new IRow[rows.size()]);
    }

    class RowIdxComparer
    implements Comparator {
        RowIdxComparer() {
        }

        public int compare(Object row1, Object row2) {
            return ((IRow)row1).getRowIndex() - ((IRow)row2).getRowIndex();
        }
    }
}

