/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFacadeFactory;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.nbudget.BgElimContextHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgWorkTemplateWizard_ChooseItemsUI;
import com.kingdee.eas.ma.nbudget.client.BgElimUIUtil;
import com.kingdee.eas.ma.nbudget.client.BgWorkTemplateSelectItemUI;
import com.kingdee.eas.ma.nbudget.client.BgWorkTemplateWizard_ChooseTableHead;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgWorkTemplateWizard_ChooseItemsUI
extends AbstractBgWorkTemplateWizard_ChooseItemsUI {
    private static final Logger logger = CoreUIObject.getLogger(BgWorkTemplateWizard_ChooseItemsUI.class);
    public Sheet curSheet;
    private List bgItems = new ArrayList();
    private String orgUnitId = null;

    public void onLoad() throws Exception {
        super.onLoad();
        BgElimUIUtil.initGuideImage(this.pnlImage);
        this.curSheet = (Sheet)this.getUIContext().get("curSheet");
        if (this.getUIContext().get("ORGUNITID") != null) {
            this.orgUnitId = (String)this.getUIContext().get("ORGUNITID");
        } else if (BgElimContextHelper.getBgElimContext().getCurMappedOrgUnit() != null) {
            this.orgUnitId = BgElimContextHelper.getBgElimContext().getCurMappedOrgUnit().getId().toString();
        }
        BgElimUIUtil.hmUIs.put(BgWorkTemplateWizard_ChooseItemsUI.class.getName(), this);
        this.tblItems.checkParsed();
        this.tblItems.getSelectManager().setSelectMode(2);
        this.tblItems.getStyleAttributes().setLocked(true);
        this.btnCancel.setEnabled(true);
        this.btnPreStep.setEnabled(false);
        this.btnNextStep.setEnabled(true);
        this.btnFinished.setEnabled(false);
        this.btnHelp.setVisible(false);
        this.getUIdata();
        this.addCollectionToTable(this.bgItems);
    }

    @Override
    protected void btnNextStep_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblItems.getRowCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgEliminationResource", (String)"itemCantBeNull"));
            SysUtil.abort();
        }
        this.getUIWindow().hide();
        if (BgElimUIUtil.hmUIs.get(this.getNextUIName()) == null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"curSheet", (Object)this.curSheet);
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getNextUIName(), (Map)uiContext, null, this.getOprtState());
            window.show();
        } else {
            Object obj = BgElimUIUtil.hmUIs.get(this.getNextUIName());
            if (obj instanceof CoreUI) {
                CoreUI nextUI = (CoreUI)obj;
                nextUI.getUIWindow().show();
            }
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        if (BgElimUIUtil.isCloseWindow((Component)((Object)this))) {
            BgElimUIUtil.closeAllUI();
        }
    }

    @Override
    public void selectItems_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        if (this.getUIContext().get("ORGUNITID") != null) {
            uiContext.put((Object)"ORGUNITID", (Object)this.orgUnitId);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.nbudget.client.BgWorkTemplateSelectItemUI", (Map)uiContext, null, this.getOprtState());
        uiWindow.show();
        if (!((BgWorkTemplateSelectItemUI)uiWindow.getUIObject()).isCancel()) {
            List result = ((BgWorkTemplateSelectItemUI)uiWindow.getUIObject()).getResult();
            this.addCollectionToTable(result);
            this.bgItems = result;
        }
    }

    private void addCollectionToTable(List list) {
        this.tblItems.checkParsed();
        this.tblItems.removeRows();
        if (list == null) {
            return;
        }
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            BgItemInfo info = (BgItemInfo)list.get(i);
            IRow r = this.tblItems.addRow();
            r.getCell(0).setValue((Object)info.getNumber());
            r.getCell(1).setValue((Object)info.getName());
            r.setUserObject((Object)info);
        }
    }

    protected boolean isUpgrade() throws Exception {
        return BgItemFacadeFactory.getRemoteInstance().checkIsUpgrade();
    }

    private void getUIdata() throws Exception {
        Cell curCell = null;
        String formulaStr = null;
        String[] params = null;
        HashSet<String> itemNumber = new HashSet<String>();
        boolean findItemCol = false;
        for (int i = 0; i <= this.curSheet.getMaxColIndex(); ++i) {
            for (int j = 0; j <= this.curSheet.getMaxRowIndex(); ++j) {
                curCell = this.curSheet.getCell(j, i, true);
                if (!BgNFSHelper.checkHasFormulaOfCell(curCell) || (params = BgNFSHelper.parseFormulaPara(null, formulaStr = BgNFSHelper.getFormulaOfCell(curCell))) == null || StringUtils.isEmpty((String)params[0])) continue;
                itemNumber.add(params[0]);
                findItemCol = true;
            }
            if (findItemCol) break;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("bgItemGroup.id"));
        sic.add(new SelectorItemInfo("bgItemGroup.number"));
        sic.add(new SelectorItemInfo("refField"));
        sic.add(new SelectorItemInfo("elimType"));
        sic.add(new SelectorItemInfo("level"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", itemNumber, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)BgSHelper.getIsolateOrg((String)this.orgUnitId), CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        BgItemCollection items = BgItemFactory.getRemoteInstance().getBgItemCollection(view);
        this.bgItems.clear();
        this.bgItems.addAll(Arrays.asList(items.toArray()));
    }

    public List getBgItems() {
        return this.bgItems;
    }

    public void setBgItems(List bgItems) {
        this.bgItems = bgItems;
    }

    public String getOrgUnitId() {
        return this.orgUnitId;
    }

    public void setOrgUnitId(String orgUnitId) {
        this.orgUnitId = orgUnitId;
    }

    public boolean destroyWindow() {
        BgElimUIUtil.closeAllUI();
        return super.destroyWindow();
    }

    private String getNextUIName() {
        return BgWorkTemplateWizard_ChooseTableHead.class.getName();
    }
}

