/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.nbudget.client.AbstractBudgetRequestBillConfigPeriodUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.request.BgFields;
import com.kingdee.eas.ma.nbudget.request.IBgField;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class BudgetRequestBillConfigPeriodUI
extends AbstractBudgetRequestBillConfigPeriodUI {
    private static final long serialVersionUID = -6051821284147125953L;
    private static final Logger logger = CoreUIObject.getLogger(BudgetRequestBillConfigPeriodUI.class);
    private String dateFormatStr = null;
    private boolean isCancel = false;

    public BudgetRequestBillConfigPeriodUI() throws Exception {
        this.init();
    }

    public void onShow() throws Exception {
        Boolean hasSelect;
        super.onShow();
        IBgField field = (IBgField)this.getUIContext().get(BgFields.INIT_FIELD);
        if (field != null) {
            String[] strs;
            this.dateFormatStr = field.getInitValue().getDefValue();
            if (!StringUtils.isEmpty((String)this.dateFormatStr) && (strs = this.dateFormatStr.split(";")) != null && strs.length > 0) {
                int size = strs.length;
                if (size > 0) {
                    this.setSelectObject(this.comField, strs[0]);
                }
                if (size > 1) {
                    this.setSelectObject(this.comOperator, strs[1]);
                }
                if (size > 2) {
                    this.txtNumber.setText(strs[2]);
                }
                if (size > 3) {
                    this.setSelectObject(this.comPeriodType, strs[3]);
                }
            }
        }
        if ((hasSelect = (Boolean)this.getUIContext().get("hasSelectDate")) != null && !hasSelect.booleanValue()) {
            this.comField.setEnabled(false);
            this.comOperator.setEnabled(false);
            this.txtNumber.setEnabled(false);
            this.comPeriodType.setEnabled(false);
            this.button_ok.setEnabled(false);
        } else {
            this.button_ok.setEnabled(true);
            this.button_cancel.setEnabled(true);
        }
    }

    private void init() {
        this.comField.removeAllItems();
        this.comField.addItem((Object)new PeriodObj(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", BgFields.DATE_APPLY), BgFields.DATE_APPLY));
        this.comField.setSelectedIndex(0);
        this.comOperator.removeAllItems();
        this.comOperator.addItem((Object)new PeriodObj("+", "+"));
        this.comOperator.addItem((Object)new PeriodObj("-", "-"));
        this.comOperator.setSelectedIndex(0);
        this.comPeriodType.removeAllItems();
        this.comPeriodType.addItem((Object)new PeriodObj(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", BgFields.DATE_DAY), BgFields.DATE_DAY));
        this.comPeriodType.addItem((Object)new PeriodObj(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", BgFields.DATE_MONTH), BgFields.DATE_MONTH));
        this.comPeriodType.addItem((Object)new PeriodObj(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", BgFields.DATE_YEAR), BgFields.DATE_YEAR));
        this.comPeriodType.setSelectedIndex(0);
    }

    private void setSelectObject(KDComboBox combox, String object) {
        if (combox == null || StringUtils.isEmpty((String)object)) {
            return;
        }
        combox.setSelectedItem((Object)new PeriodObj(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", BgFields.DATE_DAY), object));
    }

    public boolean isCanceled() {
        return false;
    }

    public void setDateFormatStr(String dateFormatStr) {
        this.dateFormatStr = dateFormatStr;
    }

    public String getDateFormatStr() {
        return this.dateFormatStr;
    }

    public Object getData() {
        return this.getDateFormatStr();
    }

    public void show() {
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        PeriodObj o1 = (PeriodObj)this.comField.getSelectedItem();
        String txt = this.txtNumber.getText();
        if (StringUtils.isEmpty((String)txt)) {
            this.setDateFormatStr(o1.getValue() + ";");
        } else {
            PeriodObj o2 = (PeriodObj)this.comOperator.getSelectedItem();
            Number number = this.txtNumber.getNumberValue();
            if (number.intValue() == 0) {
                this.setDateFormatStr(o1.getValue() + ";");
            } else {
                PeriodObj o3 = (PeriodObj)this.comPeriodType.getSelectedItem();
                this.setDateFormatStr(o1.getValue() + ";" + o2 + ";" + txt + ";" + o3.getValue());
            }
        }
        this.setCancel(false);
        this.getUIWindow().close();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setCancel(true);
        this.getUIWindow().close();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    class PeriodObj {
        private String name = null;
        private String value = null;

        public PeriodObj(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PeriodObj) {
                return this.value.equals(((PeriodObj)obj).getValue());
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }
}

