/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgUnitRelationInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgCtrlResultCollection;
import com.kingdee.eas.ma.budget.BgCtrlResultInfo;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormHelper;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BudgetCtrlUtil;
import com.kingdee.eas.ma.budget.IBgFacade;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.IBudgetCtrlFacade;
import com.kingdee.eas.ma.budget.VisualItemCollection;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.ma.budget.client.BgCompanyF7;
import com.kingdee.eas.ma.budget.client.BgElementDialog;
import com.kingdee.eas.ma.budget.client.BgOrgViewF7;
import com.kingdee.eas.ma.budget.client.NewBgItemDialog;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.BgRequestAdjustBillFactory;
import com.kingdee.eas.ma.nbudget.BudgetBillStateEnum;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillEntryInfo;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillFactory;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillHelper;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillInfo;
import com.kingdee.eas.ma.nbudget.BudgetRequestException;
import com.kingdee.eas.ma.nbudget.BudgetRequestFormDiversityData;
import com.kingdee.eas.ma.nbudget.IBgRequestAdjustBill;
import com.kingdee.eas.ma.nbudget.IBudgetRequestBill;
import com.kingdee.eas.ma.nbudget.client.AbstractBudgetRequestBillEditUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.ma.nbudget.client.BudgetFormQueryUI;
import com.kingdee.eas.ma.nbudget.client.BudgetRequestBillListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class BudgetRequestBillEditUI
extends AbstractBudgetRequestBillEditUI {
    private static final long serialVersionUID = 6134393698098338129L;
    private static final Logger logger = CoreUIObject.getLogger(BudgetRequestBillEditUI.class);
    private static final String RESOURCESTR = "com.kingdee.eas.ma.nbudget.client.BgRequestAdjustBillResource";
    protected BudgetRequestBillListUI budgetRequestBillListUI = null;
    protected IBgScheme ibgScheme = null;
    protected IBgFacade ibgFacade = null;
    protected boolean hasCodeNumber = false;
    protected boolean hasCodeShowOfAddNew = false;
    protected Map paramValue = null;
    protected KDBizPromptBox prmtForm_global;
    protected String bgElementColName = "bgElement";
    protected String bgFormulaColName = "formula";
    protected String bgItemNameColName = "bgItemName";
    protected String currencyColName = "currency";
    protected String bgItemSpNumColName = "bgItemNumber";
    protected String applyColName = "applyValue";
    protected BgSchemeInfo bgSchemeRootInfo = null;
    protected FullOrgUnitInfo OrgUnitInfo = null;
    protected BgFormInfo bgFormInfo = null;
    protected Map budgetInfo = null;
    protected Map bgItemsInfo = new HashMap();
    protected Map bgElementsInfo = new HashMap();
    protected Map currencysInfo = new HashMap();
    protected Map formulaMap = null;
    protected Map bgPeriodsInfo = new HashMap();
    protected static final String STATUS_AUDIT = "AUDIT";

    public Map getBudgetInfo() {
        return this.budgetInfo;
    }

    public void setBudgetInfo(Map budgetInfo) {
        this.budgetInfo = budgetInfo;
    }

    public BgFormInfo getBgFormInfo() {
        return this.bgFormInfo;
    }

    public void setBgFormInfo(BgFormInfo bgFormInfo) {
        this.bgFormInfo = bgFormInfo;
    }

    public void onLoad() throws Exception {
        this.getUIContext().put("isLoading", "true");
        super.onLoad();
        String CurrOprtState = this.getOprtState();
        if (!CurrOprtState.equals(OprtState.ADDNEW)) {
            this.txtNumber.setEnabled(false);
            if (this.editData.getState().equals((Object)BudgetBillStateEnum.bgAudited)) {
                this.btnAntiAudit.setEnabled(true);
            } else if (this.editData.getState().equals((Object)BudgetBillStateEnum.bgprocess)) {
                this.btnAudit.setEnabled(true);
            }
        }
        if (this.getUIContext().get("ORGUNIT_INFO") == null) {
            this.btnAddNew.setEnabled(false);
        }
        this.paramValue = BgNSHelper.getAllParamValue();
        this.initSystemInfo();
        this.initWorkButton();
        if (!this.editData.getState().equals((Object)BudgetBillStateEnum.bgprocess)) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.menuItemEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
            this.BudgetBtnAddLine.setEnabled(false);
            this.BudgetbtnRemoveLine.setEnabled(false);
            this.btnBillReport.setEnabled(false);
            this.btnAntiAudit.setEnabled(false);
            this.btnAudit.setEnabled(false);
            if (this.editData.getState().equals((Object)BudgetBillStateEnum.bgAudited)) {
                this.btnAntiAudit.setEnabled(true);
                this.btnSave.setEnabled(false);
            } else if (this.editData.getState().equals((Object)BudgetBillStateEnum.bgprocess)) {
                this.btnAudit.setEnabled(true);
                this.btnSave.setEnabled(true);
            }
            if (this.editData.getState().equals((Object)BudgetBillStateEnum.bgAudited) || this.editData.getState().equals((Object)BudgetBillStateEnum.adjusting)) {
                this.btnCreateTo.setEnabled(true);
                this.menuItemCreateTo.setEnabled(true);
                this.menuItemTraceDown.setEnabled(true);
            } else {
                this.btnCreateTo.setEnabled(false);
                this.menuItemTraceDown.setEnabled(false);
                this.menuItemCreateTo.setEnabled(false);
            }
        } else {
            this.btnCreateTo.setEnabled(false);
            this.menuItemCreateTo.setEnabled(false);
            this.menuItemTraceDown.setEnabled(false);
        }
        this.getUIContext().remove("isLoading");
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.editData.getBgScheme() == null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgunit.id", (Object)this.editData.getReqOrgUnit().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("dateFrom", (Object)this.editData.getBizDate(), CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("dateTo", (Object)this.editData.getBizDate(), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isFormal", (Object)new Integer(1)));
            evi.getSelector().clear();
            evi.getSelector().add("id");
            evi.getSelector().add("number");
            evi.getSelector().add("name");
            evi.setFilter(filter);
            try {
                BgSchemeCollection col = BgSchemeFactory.getRemoteInstance().getBgSchemeCollection(evi);
                if (col != null && col.size() > 0) {
                    this.prmtBgScheme.setData((Object)col.get(0));
                }
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("isLoading", "true");
        super.actionRemove_actionPerformed(e);
        this.getUIContext().remove("isLoading");
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.setButtAndMenuState();
    }

    private void setButtAndMenuState() {
        if (this.editData != null && this.editData.getState() != null) {
            int bgBillStateEnumValue = this.editData.getState().getValue();
            switch (bgBillStateEnumValue) {
                case 0: {
                    this.setProcessButtAndMenu();
                    break;
                }
                case 1: {
                    this.setAllEnabledButtAndMenu();
                    break;
                }
                case 3: {
                    this.setAllEnabledButtAndMenu();
                    break;
                }
                case 5: {
                    this.setAuditedButtAndMenu();
                    break;
                }
                case 9: {
                    this.setCloseButtAndMenu();
                    break;
                }
                case 11: {
                    this.setAllEnabledButtAndMenu();
                }
            }
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.hasCodeNumber) {
                this.txtNumber.setEditable(false);
            } else {
                this.txtNumber.setEnabled(true);
                this.txtNumber.setEditable(true);
            }
        }
    }

    private void setProcessButtAndMenu() {
        this.actionCreateTo.setEnabled(false);
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.btnBillReport.setEnabled(true);
            this.actionAddLine.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
            this.actionEdit.setEnabled(false);
            this.actionSave.setEnabled(true);
            this.actionSubmit.setEnabled(true);
            this.actionRemove.setEnabled(true);
        } else if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.btnBillReport.setEnabled(false);
            this.actionAddLine.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
            this.actionEdit.setEnabled(false);
            this.actionSave.setEnabled(true);
            this.actionSubmit.setEnabled(true);
            this.actionRemove.setEnabled(false);
        } else {
            this.btnBillReport.setEnabled(false);
            this.actionAddLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
            this.actionEdit.setEnabled(true);
            this.actionSave.setEnabled(false);
            this.actionSubmit.setEnabled(false);
            this.actionRemove.setEnabled(true);
        }
        this.actionAudit.setEnabled(true);
        this.actionAntiAudit.setEnabled(false);
    }

    private void setCloseButtAndMenu() {
        this.setAllEnabledButtAndMenu();
        this.actionCreateTo.setEnabled(true);
    }

    private void setAuditedButtAndMenu() {
        this.setAllEnabledButtAndMenu();
        this.actionAntiAudit.setEnabled(true);
        this.actionCreateTo.setEnabled(true);
    }

    private void setAllEnabledButtAndMenu() {
        this.actionEdit.setEnabled(false);
        this.actionSave.setEnabled(false);
        this.actionSubmit.setEnabled(false);
        this.actionRemove.setEnabled(false);
        this.actionCreateTo.setEnabled(false);
        this.actionAddLine.setEnabled(false);
        this.actionRemoveLine.setEnabled(false);
        this.actionBillReport.setEnabled(false);
        this.actionAudit.setEnabled(false);
        this.actionAntiAudit.setEnabled(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.BudgetBtnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.BudgetBtnAddLine.setText("");
        this.BudgetbtnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.BudgetbtnRemoveLine.setText("");
        this.btnAddLine.setVisible(false);
        this.btnRemoveLine.setVisible(false);
        this.btnInsertLine.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnTraceUp.setVisible(false);
        this.btnTraceDown.setVisible(false);
        this.menuItemCopy.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnBillReport.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        if (!this.getOprtState().equals("ADDNEW")) {
            this.btnBillReport.setEnabled(true);
        } else {
            this.btnBillReport.setEnabled(false);
        }
        this.prmtReqOrgUnit.setEditable(false);
        this.prmtReqCompany.setEditable(false);
        this.actionPrint.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setEnabled(false);
        this.actionPrintPreview.setVisible(false);
    }

    protected IObjectValue createNewData() {
        BudgetRequestBillInfo billInfo = new BudgetRequestBillInfo();
        billInfo.setId(BOSUuid.create((BOSObjectType)billInfo.getBOSType()));
        String fullInfoId = ((FullOrgUnitInfo)this.getUIContext().get("ORGUNIT_INFO")).getId().toString();
        ObjectUuidPK pk = new ObjectUuidPK(fullInfoId);
        CostCenterOrgUnitInfo costCenterOrgUnitInfo = null;
        try {
            costCenterOrgUnitInfo = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)pk);
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
        billInfo.setOrgUnit(costCenterOrgUnitInfo);
        billInfo.setReqOrgUnit(costCenterOrgUnitInfo);
        billInfo.setCU((CtrlUnitInfo)this.getUIContext().get("ORGUNIT_CU"));
        billInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        billInfo.setState(BudgetBillStateEnum.bgprocess);
        billInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        billInfo.setBizDate(new Date());
        try {
            billInfo.setCompany(this.getBillCompany((OrgUnitInfo)costCenterOrgUnitInfo));
            CompanyOrgUnitInfo companyInfo = this.getCompanyByOrgUnit((OrgUnitInfo)this.getUIContext().get("ORGUNIT_INFO"));
            if (companyInfo != null) {
                billInfo.setReqCompany(companyInfo);
                this.initPurchase(companyInfo.getId().toString());
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        String CUID = billInfo.getCU().getId().toString();
        this.hasCodeNumber = BgHelper.hasNumber((CoreBaseInfo)billInfo, (String)CUID, null);
        if (this.hasCodeNumber) {
            this.txtNumber.setEnabled(false);
            this.hasCodeShowOfAddNew = BgHelper.hasDisplayNumber((CoreBaseInfo)billInfo, (String)CUID, null);
            if (this.hasCodeShowOfAddNew) {
                this.getNumberByCodingRule((IObjectValue)billInfo, CUID);
            }
        }
        return billInfo;
    }

    protected CompanyOrgUnitInfo getCompanyByOrgUnit(OrgUnitInfo orgUnitInfo) throws Exception {
        if (orgUnitInfo.isIsCompanyOrgUnit()) {
            return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), this.getCompanySelectors());
        }
        OrgUnitInfo parent = this.getOrgFacadeInterface().getParent(orgUnitInfo.getId().toString(), OrgViewType.COSTCENTER);
        if (parent != null) {
            return this.getCompanyByOrgUnit(parent);
        }
        return null;
    }

    protected INewOrgViewFacade getOrgFacadeInterface() throws Exception {
        return NewOrgViewFacadeFactory.getRemoteInstance();
    }

    protected SelectorItemCollection getCompanySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("isBizUnit");
        sic.add("accountPeriodType.id");
        return sic;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        BudgetRequestBillEntryInfo entryInfo = new BudgetRequestBillEntryInfo();
        entryInfo.setBgItemName(null);
        entryInfo.setBgItemNumber(null);
        entryInfo.setBgElement(null);
        entryInfo.setCurrency(null);
        entryInfo.setBudgetValue(BgConstants.ZERO);
        entryInfo.setActualValue(BgConstants.ZERO);
        entryInfo.setApplyValue(BgConstants.ZERO);
        entryInfo.setCheckValue(BgConstants.ZERO);
        entryInfo.setUseValue(BgConstants.ZERO);
        entryInfo.setBgForm(null);
        return entryInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BudgetRequestBillFactory.getRemoteInstance();
    }

    protected KDTable getDetailTable() {
        return this.kdtBgEnties;
    }

    protected void prepareNumber(IObjectValue caller, String number) {
        if (number != null && number.length() > 0) {
            caller.put("number", (Object)number);
            this.txtNumber.setText(number);
        }
    }

    protected void setNumberTextEnabled() {
        this.txtNumber.setEnabled(true);
        this.txtNumber.setEditable(true);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (!this.hasCodeNumber && this.txtNumber.getText().trim().length() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"isNullOfNumber"));
            this.txtNumber.requestFocus();
            SysUtil.abort();
        }
        if (this.pkBizDate.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"isBizDateNull"));
            this.pkBizDate.requestFocus(true);
            SysUtil.abort();
        }
        if (this.pkBgEndDate.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"isBgEndDateNull"));
            this.pkBgEndDate.requestFocus(true);
            SysUtil.abort();
        }
        if (this.prmtReqOrgUnit.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"isNullOfReqOrgUnit"));
            this.prmtReqOrgUnit.requestFocus(true);
            SysUtil.abort();
        }
        if (this.prmtReqCompany.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"isNullOfReqCompany"));
            this.prmtReqCompany.requestFocus(true);
            SysUtil.abort();
        }
        Date now = BgHelper.getDayBegin((Date)new Date());
        Date bgEndDate = BgHelper.getDayBegin((Date)((Date)this.pkBgEndDate.getValue()));
        if (bgEndDate.before(now)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"createDateToBgEndDate"));
            this.pkBizDate.requestFocus(true);
            SysUtil.abort();
        }
    }

    private CompanyOrgUnitInfo getBillCompany(OrgUnitInfo srcOrgUnit) {
        if (srcOrgUnit != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("toUnit.id");
            sic.add("toUnit.number");
            sic.add("toUnit.name");
            viewInfo.getSelector().addObjectCollection((IObjectCollection)sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)srcOrgUnit.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)OrgType.CostCenter, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)OrgType.Company, CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and #2");
            viewInfo.setFilter(filter);
            try {
                OrgUnitRelationInfo relation;
                OrgUnitRelationCollection col = OrgUnitRelationFactory.getRemoteInstance().getOrgUnitRelationCollection(viewInfo);
                if (col != null && col.size() > 0 && (relation = col.get(0)).getToUnit() != null) {
                    CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                    company.setId(relation.getToUnit().getId());
                    company.setNumber(relation.getToUnit().getNumber());
                    company.setName(relation.getToUnit().getName());
                    return company;
                }
            }
            catch (BOSException e) {
                this.prmtCompany.setData(null);
            }
        }
        return null;
    }

    protected void initSystemInfo() throws EASBizException, BOSException {
        this.prmtBgScheme.setDisplayFormat("$name$");
        this.prmtBgScheme.setEditFormat("$number$");
        this.prmtBgScheme.setCommitFormat("$number$");
        this.prmtBgScheme.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                BudgetRequestBillEditUI.this.prmtBgScheme_willShow(e);
            }
        });
        BgOrgViewF7 orgView = new BgOrgViewF7((IUIObject)this);
        orgView.setMultiSelect(false);
        this.prmtReqOrgUnit.setSelector((KDPromptSelector)orgView);
        BgCompanyF7 view = new BgCompanyF7();
        view.setMultiSelect(false);
        this.prmtReqCompany.setSelector((KDPromptSelector)view);
        this.initSelectInfo();
        String CurrOprtState = this.getOprtState();
        if (CurrOprtState.equals(OprtState.ADDNEW) || CurrOprtState.equals(OprtState.EDIT)) {
            String CUID = this.editData.getCU().getId().toString();
            this.hasCodeNumber = BgHelper.hasNumber((CoreBaseInfo)this.editData, (String)CUID, null);
            if (this.hasCodeNumber) {
                this.txtNumber.setEnabled(false);
            }
        }
    }

    protected void initSelectInfo() throws EASBizException, BOSException {
        KDBizPromptBox prmtSelect = null;
        prmtSelect = new KDBizPromptBox();
        prmtSelect.setDisplayFormat("$name$");
        prmtSelect.setEditFormat("$number$");
        prmtSelect.setCommitFormat("$number$");
        prmtSelect.setSelector((KDPromptSelector)new NewBgItemDialog((IUIObject)this));
        prmtSelect.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BudgetRequestBillEditUI.this.bgVisualItemInfo_dataChanged(eventObj);
            }
        });
        this.getDetailTable().getColumn(this.bgItemNameColName).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
        KDComboBox comSelect = new KDComboBox();
        BgNFCHelper.setCurrency(comSelect, this.editData.getOrgUnit().getId(), true);
        this.getDetailTable().getColumn(this.currencyColName).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comSelect));
        prmtSelect = new KDBizPromptBox();
        prmtSelect.setDisplayFormat("$name$");
        prmtSelect.setEditFormat("$number$");
        prmtSelect.setCommitFormat("$number$");
        BgElementDialog bgElementDialog = new BgElementDialog((IUIObject)this);
        bgElementDialog.setIsChooseOne(true);
        prmtSelect.setSelector((KDPromptSelector)bgElementDialog);
        this.getDetailTable().getColumn(this.bgElementColName).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
        KDFormattedTextField formattedTextField = null;
        formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        formattedTextField.setPrecision(10);
        formattedTextField.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
        formattedTextField.setMinimumValue((Comparable)GlUtils.minBigDecimal);
        this.getDetailTable().getColumn(this.applyColName).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
        prmtSelect = new KDBizPromptBox();
        prmtSelect.setEditFormat("$number$");
        prmtSelect.setDisplayFormat("$name$");
        prmtSelect.setCommitFormat("$number$");
        prmtSelect.setQueryInfo("com.kingdee.eas.basedata.scm.common.app.F7RowTypeQuery");
        this.getDetailTable().getColumn("rowType").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
        this.getDetailTable().getColumn("material").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.getMaterialF7()));
    }

    @Override
    protected void kdtBgEnties_editStarting(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        String fieldName = this.getDetailTable().getColumnKey(colIndex);
        if (fieldName.equals("material") && this.prmtPurchaseItem.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"isNullOfPurchase"));
            this.prmtPurchaseItem.requestFocus(true);
            e.setCancel(true);
        }
    }

    private void beforReqCompanyChanged() {
        this.prmtPurchaseItem.setData(null);
        int rowCount = this.getDetailTable().getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.getDetailTable().getRow(i).getCell("material").setValue(null);
        }
    }

    @Override
    protected void prmtReqCompany_dataChanged(DataChangeEvent e) {
        this.beforReqCompanyChanged();
        if (this.prmtReqCompany.getData() instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)this.prmtReqCompany.getData();
            if (e.getNewValue() != e.getOldValue()) {
                this.initPurchase(org.getId().toString());
                this.getDetailTable().getColumn("material").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.getMaterialF7()));
            }
        } else if (this.prmtReqCompany.getData() instanceof FullOrgUnitInfo) {
            FullOrgUnitInfo org = (FullOrgUnitInfo)this.prmtReqCompany.getData();
            if (e.getNewValue() != e.getOldValue()) {
                this.initPurchase(org.getId().toString());
                this.getDetailTable().getColumn("material").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.getMaterialF7()));
            }
        }
    }

    @Override
    protected void pkBizDate_dataChanged(DataChangeEvent e) throws BOSException, EASBizException {
        if (e.getNewValue() != e.getOldValue()) {
            this.fillValueToTable();
        }
    }

    @Override
    protected void prmtPurchaseItem_dataChanged(DataChangeEvent e) {
        if (e.getNewValue() != e.getOldValue()) {
            int rowCount = this.getDetailTable().getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                this.getDetailTable().getRow(i).getCell("material").setValue(null);
            }
        }
    }

    protected void bgVisualItemInfo_dataChanged(DataChangeEvent e) {
        VisualItemInfo visInfo;
        int rowIndex = this.getDetailTable().getSelectManager().getActiveRowIndex();
        if (e.getNewValue() != null && e.getNewValue() instanceof VisualItemInfo && (visInfo = (VisualItemInfo)e.getNewValue()).getNumber() != null) {
            this.getDetailTable().getCell(rowIndex, this.bgItemSpNumColName).setValue((Object)visInfo.getNumber());
        }
    }

    protected void prmtBgScheme_willShow(PreChangeEvent e) {
        if (this.getDetailTable().getRowCount() > 0) {
            int re;
            if (e.getOldData() == null) {
                return;
            }
            if (e.getOldData().equals(e.getData())) {
                e.setResult(0);
                SysUtil.abort();
            }
            if ((re = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"isRemoveEntyMesg"))) == 1 || re == 2) {
                e.setResult(0);
                SysUtil.abort();
            } else {
                this.getDetailTable().removeRows();
            }
        }
    }

    @Override
    protected void prmtBgScheme_willShow(SelectorEvent e) throws Exception {
        super.prmtBgScheme_willShow(e);
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        if (this.getUIContext().get("isLoading") != null) {
            return;
        }
        Object newObj = e.getNewValue();
        Object oldObj = e.getOldValue();
        if (newObj != null) {
            int isSelectSch;
            this.btnBillReport.setEnabled(true);
            BgSchemeInfo newbgScheme = (BgSchemeInfo)newObj;
            BgSchemeInfo oldbgScheme = (BgSchemeInfo)oldObj;
            String oldSchemeNum = "";
            if (oldbgScheme != null) {
                oldSchemeNum = oldbgScheme.getNumber();
            }
            this.editData.setBgScheme(newbgScheme);
            if (!newbgScheme.getNumber().equals(oldSchemeNum) && newbgScheme.isIsFormal() && (isSelectSch = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"isSelectSchMesg"))) != 0) {
                this.prmtBgScheme.setData(null);
                this.btnBillReport.setEnabled(false);
            }
        } else if (newObj == null && oldObj != null) {
            this.btnBillReport.setEnabled(false);
            if (this.getDetailTable().getRowCount() > 0) {
                this.getDetailTable().removeRows();
            }
        }
        this.initSelectInfo();
    }

    private void processBgScemeView() {
        String orgUnitId = "000000000000000000000000000";
        if (this.prmtReqOrgUnit.getData() instanceof OrgUnitInfo) {
            orgUnitId = ((OrgUnitInfo)this.prmtReqOrgUnit.getData()).getId().toString();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        filter.setMaskString(" #0 ");
        if (BgParamCHelper.isFodian()) {
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(4), CompareType.NOTEQUALS));
        }
        if (BgSHelper.isBgPermissionUsed((Map)this.paramValue)) {
            HashSet<String> orgSet = new HashSet<String>();
            orgSet.add(orgUnitId);
            String user = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            filter = BgPermissionHelper.addBgSchemePermission(user, orgSet, filter);
        }
        view.setFilter(filter);
        this.prmtBgScheme.setEntityViewInfo(view);
        if (this.prmtBgScheme.getData() instanceof BgSchemeInfo && !((BgSchemeInfo)this.prmtBgScheme.getData()).getOrgUnit().getId().toString().equals(orgUnitId)) {
            this.prmtBgScheme.setData(null);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.beforeSave();
        if (this.prmtReqCompany.getData() != null) {
            if (this.prmtReqCompany.getData() instanceof CompanyOrgUnitInfo) {
                this.editData.setReqCompany((CompanyOrgUnitInfo)this.prmtReqCompany.getData());
            } else if (this.prmtReqCompany.getData() instanceof FullOrgUnitInfo) {
                FullOrgUnitInfo fullOrg = (FullOrgUnitInfo)this.prmtReqCompany.getData();
                CompanyOrgUnitInfo comOrg = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(fullOrg.getId()));
                this.editData.setReqCompany(comOrg);
            }
        }
        this.getUIContext().put("isLoading", "true");
        super.actionSave_actionPerformed(e);
        this.getUIContext().remove("isLoading");
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.txtNumber.setEnabled(false);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        String CUID = this.editData.getCU().getId().toString();
        this.hasCodeNumber = BgHelper.hasNumber((CoreBaseInfo)this.editData, (String)CUID, null);
        this.setButtAndMenuState();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.actionSave_actionPerformed(e);
        if (BgFormHelper.checkInProInst((String)this.editData.getId().toString())) {
            throw new BudgetRequestException(BudgetRequestException.SUBMITBILLINWORK);
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        BudgetRequestBillInfo budget = BudgetRequestBillFactory.getRemoteInstance().getBudgetRequestBillInfo((IObjectPK)pk);
        if (budget.getState().equals((Object)BudgetBillStateEnum.bgprocess) && BudgetRequestBillFactory.getRemoteInstance().submitWorkFlow(this.editData.getId())) {
            this.setOprtState(OprtState.VIEW);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"submitReferWoring"));
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.menuItemEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
            this.btnBillReport.setEnabled(false);
        }
        if (budget.getState().equals((Object)BudgetBillStateEnum.bgAudited)) {
            BOTRelationCollection botRelationCol = BTPManagerFactory.getRemoteInstance().getDestRelation(this.editData.getId().toString());
            if (botRelationCol != null && botRelationCol.size() > 0) {
                throw new BudgetRequestException(BudgetRequestException.HASBOTPBILL);
            }
            FilterInfo filter = new FilterInfo();
            FilterItemCollection item = filter.getFilterItems();
            item.add(new FilterItemInfo("bgRequestBill.id", (Object)this.editData.getId().toString(), CompareType.EQUALS));
            IBgRequestAdjustBill ibgAdjust = BgRequestAdjustBillFactory.getRemoteInstance();
            if (ibgAdjust.exists(filter)) {
                throw new BudgetRequestException(BudgetRequestException.HASADJUSTBILL);
            }
            if (BudgetRequestBillFactory.getRemoteInstance().unSubmitWorkFlow(this.editData.getId())) {
                this.setOprtState(OprtState.VIEW);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"submitReferWoring"));
                this.btnEdit.setEnabled(false);
                this.btnRemove.setEnabled(false);
                this.menuItemEdit.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
                this.btnBillReport.setEnabled(false);
            }
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.btnAntiAudit.setEnabled(false);
        this.btnAudit.setEnabled(true);
        this.btnCreateTo.setEnabled(false);
        this.btnBillReport.setEnabled(false);
        this.BudgetBtnAddLine.setEnabled(true);
        this.BudgetbtnRemoveLine.setEnabled(true);
        super.actionAddNew_actionPerformed(e);
        if (this.hasCodeNumber) {
            this.txtNumber.setEditable(false);
        } else {
            this.txtNumber.setEnabled(true);
            this.txtNumber.setEditable(true);
        }
        this.prmtBgScheme.setData(null);
        this.pkBgEndDate.setValue(null);
    }

    protected void beforeSave() throws Exception {
        if (this.getDetailTable() != null && this.getDetailTable().getBody().size() > 0) {
            this.checkItermName();
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"appBillMesg"));
            SysUtil.abort();
        }
    }

    private void checkItermName() {
        int i;
        int detailBill = this.kdtBgEnties.getRowCount();
        IRow rowI = null;
        IRow rowJ = null;
        for (i = 0; i < detailBill; ++i) {
            rowI = this.kdtBgEnties.getRow(i);
            if (rowI.getCell("bgItemName").getValue() == null || rowI.getCell("currency").getValue() == null || rowI.getCell("bgElement").getValue() == null || rowI.getCell("applyValue").getValue() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"appBillBgItemNameMesg"));
                SysUtil.abort();
                continue;
            }
            if (((BigDecimal)rowI.getCell("applyValue").getValue()).compareTo(new BigDecimal(0)) != -1) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"budgetValueLessThenZero"));
            SysUtil.abort();
        }
        for (i = 0; i < detailBill; ++i) {
            rowI = this.kdtBgEnties.getRow(i);
            String bgItemNameNew = rowI.getCell("bgItemName").getValue().toString();
            String bgElementNew = rowI.getCell("bgElement").getValue().toString();
            String currencyNew = rowI.getCell("currency").getValue().toString();
            for (int j = i + 1; j < detailBill - 1; ++j) {
                rowJ = this.kdtBgEnties.getRow(j);
                String bgItemName = rowJ.getCell("bgItemName").getValue().toString();
                String currency = rowJ.getCell("currency").getValue().toString();
                String bgElement = rowJ.getCell("bgElement").getValue().toString();
                if (!bgItemNameNew.equals(bgItemName) || !currencyNew.equals(currency) || !bgElementNew.equals(bgElement)) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"isBudgetItermOnlyOne"));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionBillReport_actionPerformed(ActionEvent e) throws Exception {
        super.actionBillReport_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BudgetRequestBillUI", (Object)this);
        FullOrgUnitInfo _orgUnitInfo = null;
        if (this.prmtReqOrgUnit.getData() != null) {
            _orgUnitInfo = ((OrgUnitInfo)this.prmtReqOrgUnit.getData()).castToFullOrgUnitInfo();
        }
        uiContext.put((Object)"ORGUNIT_INFO", _orgUnitInfo);
        uiContext.put((Object)"BGSCHEME_INFO", this.prmtBgScheme.getData());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BudgetFormQueryUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    protected void prmtReqOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        Object objOrg = e.getNewValue();
        if (objOrg == null) {
            this.setSchemeF7Filter(null);
            return;
        }
        OrgUnitInfo fullOrgUnitInfo = (OrgUnitInfo)this.prmtReqOrgUnit.getData();
        CompanyOrgUnitInfo companyInfo = this.getCompanyByOrgUnit(fullOrgUnitInfo);
        if (companyInfo != null) {
            this.prmtReqCompany.setData((Object)companyInfo);
            int rowCount = this.getDetailTable().getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                this.getDetailTable().getRow(i).getCell("material").setValue(null);
            }
        }
        this.fillValueToTable();
        this.processBgScemeView();
    }

    private void setSchemeF7Filter(String orgId) {
        EntityViewInfo view = this.prmtBgScheme.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filer = new FilterInfo(EntryFilterType.NORMAL);
        filer.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgId, CompareType.EQUALS));
        view.setFilter(filer);
        this.prmtBgScheme.setEntityViewInfo(view);
    }

    public boolean updateBudgetMapInfo() throws Exception {
        if (this.getDetailTable() == null || this.budgetInfo == null || this.budgetInfo.isEmpty()) {
            return false;
        }
        String formulaString2 = null;
        String[] parameter = null;
        BudgetRequestFormDiversityData divData = null;
        HashMap usebgItems = new HashMap();
        HashMap<String, String> useFormula = new HashMap<String, String>();
        HashMap usebgElement = new HashMap();
        HashMap useCurrency = new HashMap();
        VisualItemInfo visItemInfo2 = null;
        VisualItemCollection visItemCol = null;
        KDTable table = this.getDetailTable();
        IRow row = null;
        for (String formulaString2 : this.budgetInfo.keySet()) {
            divData = (BudgetRequestFormDiversityData)((Object)this.budgetInfo.get(formulaString2));
            parameter = divData.getParameter();
            if (parameter == null) continue;
            if (parameter[0] != null && !this.bgItemsInfo.containsKey(parameter[0]) && !usebgItems.containsKey(parameter[0])) {
                usebgItems.put(parameter[0], null);
            }
            if (parameter[2] != null && !this.bgElementsInfo.containsKey(parameter[2]) && !usebgElement.containsKey(parameter[2])) {
                usebgElement.put(parameter[2], null);
            }
            if (parameter[5] == null || this.currencysInfo.containsKey(parameter[5]) || useCurrency.containsKey(parameter[5])) continue;
            useCurrency.put(parameter[5], null);
        }
        BudgetRequestBillEntryInfo entryInfo = null;
        String orgUnitId = null;
        if (this.bgFormInfo != null && this.bgFormInfo.getOrgUnit() != null) {
            orgUnitId = this.bgFormInfo.getOrgUnit().getId().toString();
        }
        visItemCol = this.getFacadeInterface().getVisualItemCollection(usebgItems, true, orgUnitId);
        for (VisualItemInfo visItemInfo2 : visItemCol) {
            this.bgItemsInfo.put(visItemInfo2.getNumber(), visItemInfo2);
        }
        this.bgElementsInfo = BgSHelper.getBgElementInfo(null, usebgElement, (Map)this.bgElementsInfo, null);
        this.currencysInfo = BgSHelper.getCurrencyInfo(null, useCurrency, (Map)this.currencysInfo, null);
        int n = table.getBody().size();
        for (int i = 0; i < n; ++i) {
            row = table.getRow(i);
            if (row.getCell("bgForm").getValue() == null || !row.getCell("bgForm").getValue().toString().equals(this.bgFormInfo.getId().toString())) continue;
            if (row.getCell(this.bgFormulaColName).getValue() != null) {
                formulaString2 = (String)row.getCell(this.bgFormulaColName).getValue();
            } else {
                for (String formulaString2 : this.budgetInfo.keySet()) {
                    if (useFormula.containsKey(formulaString2)) continue;
                    divData = (BudgetRequestFormDiversityData)((Object)this.budgetInfo.get(formulaString2));
                    row.getCell(this.bgFormulaColName).setValue((Object)formulaString2);
                    break;
                }
            }
            if (!this.budgetInfo.containsKey(formulaString2) || useFormula.containsKey(formulaString2)) continue;
            entryInfo = (BudgetRequestBillEntryInfo)row.getUserObject();
            divData = (BudgetRequestFormDiversityData)((Object)this.budgetInfo.get(formulaString2));
            parameter = divData.getParameter();
            if (parameter != null && parameter[0] != null) {
                visItemInfo2 = (VisualItemInfo)this.bgItemsInfo.get(parameter[0]);
                entryInfo.setBgItemName(visItemInfo2.getName());
                entryInfo.setBgItemNumber(visItemInfo2.getNumber());
                row.getCell(this.bgItemNameColName).setValue((Object)visItemInfo2);
                row.getCell("bgItemNumber").setValue((Object)visItemInfo2.getNumber());
            }
            if (parameter != null && parameter[2] != null) {
                entryInfo.setBgElement((BgElementInfo)this.bgElementsInfo.get(parameter[2]));
                row.getCell(this.bgElementColName).setValue((Object)entryInfo.getBgElement());
            }
            if (parameter != null && parameter[5] != null) {
                entryInfo.setCurrency((CurrencyInfo)this.currencysInfo.get(parameter[5]));
                row.getCell(this.currencyColName).setValue((Object)entryInfo.getCurrency());
                row.getCell("budgetValue").setValue((Object)divData.getNewValue().setScale(entryInfo.getCurrency().getPrecision(), 4));
            } else {
                row.getCell("budgetValue").setValue((Object)divData.getNewValue());
            }
            useFormula.put(formulaString2, formulaString2);
        }
        for (String formulaString2 : this.budgetInfo.keySet()) {
            if (useFormula.containsKey(formulaString2)) continue;
            row = table.addRow();
            divData = (BudgetRequestFormDiversityData)((Object)this.budgetInfo.get(formulaString2));
            entryInfo = (BudgetRequestBillEntryInfo)this.createNewDetailData(null);
            entryInfo.setBgBill(this.editData);
            entryInfo.setFormula(formulaString2);
            entryInfo.setBgForm(this.getBgFormInfo().getId().toString());
            row.getCell("bgForm").setValue((Object)entryInfo.getBgForm());
            parameter = divData.getParameter();
            if (parameter != null && parameter[0] != null) {
                visItemInfo2 = (VisualItemInfo)this.bgItemsInfo.get(parameter[0]);
                entryInfo.setBgItemName(visItemInfo2.getName());
                entryInfo.setBgItemNumber(visItemInfo2.getNumber());
                row.getCell(this.bgItemNameColName).setValue((Object)visItemInfo2);
                row.getCell("bgItemNumber").setValue((Object)visItemInfo2.getNumber());
            }
            if (parameter != null && parameter[2] != null) {
                entryInfo.setBgElement((BgElementInfo)this.bgElementsInfo.get(parameter[2]));
                row.getCell(this.bgElementColName).setValue((Object)entryInfo.getBgElement());
            }
            if (parameter != null && parameter[5] != null) {
                entryInfo.setCurrency((CurrencyInfo)this.currencysInfo.get(parameter[5]));
                row.getCell(this.currencyColName).setValue((Object)entryInfo.getCurrency());
                entryInfo.setBudgetValue(divData.getNewValue().setScale(entryInfo.getCurrency().getPrecision(), 4));
            } else {
                entryInfo.setBudgetValue(divData.getNewValue());
            }
            row.getCell("actualValue").setValue((Object)BgConstants.ZERO);
            row.getCell("applyValue").setValue((Object)BgConstants.ZERO);
            this.loadLineFields(table, row, (IObjectValue)entryInfo);
            if (parameter == null || parameter[0] == null) continue;
            visItemInfo2 = (VisualItemInfo)this.bgItemsInfo.get(parameter[0]);
            entryInfo.setBgItemName(visItemInfo2.getName());
            entryInfo.setBgItemNumber(visItemInfo2.getNumber());
            row.getCell(this.bgItemNameColName).setValue((Object)visItemInfo2);
            row.getCell("bgItemNumber").setValue((Object)visItemInfo2.getNumber());
        }
        this.fillValueToTable();
        return true;
    }

    protected IBgFacade getFacadeInterface() throws BOSException {
        if (this.ibgFacade == null) {
            this.ibgFacade = BgFacadeFactory.getRemoteInstance();
        }
        return this.ibgFacade;
    }

    @Override
    protected void kdtBgEnties_editStopped(KDTEditEvent e) throws Exception {
        IRow row;
        super.kdtBgEnties_editStopped(e);
        if (e.getOldValue() == e.getValue()) {
            return;
        }
        String colName = this.getDetailTable().getColumnKey(e.getColIndex());
        if (("bgItemNumber".equals(colName) || "bgElement".equals(colName) || "currency".equals(colName)) && this.canEdit() && (row = this.getDetailTable().getRow(e.getRowIndex())) != null && this.isNeedFill(row)) {
            this.fillValueToRow(row, this.getCtrlReoultCol());
        }
    }

    private boolean isNeedFill(IRow row) {
        return row.getCell("bgItemName").getValue() != null && row.getCell("bgElement").getValue() != null && row.getCell("currency").getValue() != null;
    }

    private boolean canEdit() {
        return OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState());
    }

    private BgCtrlResultCollection getCtrlReoultCol() throws BOSException, EASBizException {
        if (this.getUIContext().get("isLoading") == null) {
            this.storeFields();
        }
        if (this.pkBizDate.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"isBizDateNull"));
            this.pkBizDate.requestFocus(true);
            SysUtil.abort();
        } else {
            this.editData.setBizDate((Date)this.pkBizDate.getValue());
        }
        if (this.prmtReqOrgUnit.getData() instanceof CostCenterOrgUnitInfo) {
            this.editData.setReqOrgUnit((CostCenterOrgUnitInfo)this.prmtReqOrgUnit.getData());
        } else {
            this.editData.setReqOrgUnit(CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(((OrgUnitInfo)this.prmtReqOrgUnit.getData()).getId())));
        }
        IBudgetCtrlFacade iCtrl = BudgetCtrlUtil.getBudgetCtrlFacadeImpl(null);
        return iCtrl.getBudget((IObjectValue)this.editData);
    }

    private void fillValueToTable() throws BOSException, EASBizException {
        int rowCount;
        if (this.getDetailTable() != null && (rowCount = this.getDetailTable().getRowCount()) != 0) {
            BgCtrlResultCollection ctrlResCol = this.getCtrlReoultCol();
            for (int i = 0; i < rowCount; ++i) {
                IRow row = this.getDetailTable().getRow(i);
                this.fillValueToRow(row, ctrlResCol);
            }
        }
    }

    private void fillValueToRow(IRow row, BgCtrlResultCollection ctrlResultCol) throws BOSException, EASBizException {
        row.getCell("budgetValue").setValue((Object)BgConstants.ZERO);
        row.getCell("actualValue").setValue((Object)BgConstants.ZERO);
        row.getCell("baBlance").setValue((Object)BgConstants.ZERO);
        row.getCell("period").setValue(null);
        if (this.isNeedFill(row) && this.canEdit()) {
            HashMap usebgItems = new HashMap();
            HashMap usebgElement = new HashMap();
            HashMap useCurrency = new HashMap();
            VisualItemCollection visItemCol = null;
            VisualItemInfo visItemInfo2 = null;
            String[] parameter = null;
            if (ctrlResultCol.size() > 0) {
                int count = ctrlResultCol.size();
                for (int i = 0; i < count; ++i) {
                    BgCtrlResultInfo ctrlRes = ctrlResultCol.get(i);
                    parameter = BgNFSHelper.parseFormulaPara(this.getFormulaMap(), ctrlRes.getBgItemFormula());
                    if (parameter == null) continue;
                    if (parameter[0] != null && !this.bgItemsInfo.containsKey(parameter[0]) && !usebgItems.containsKey(parameter[0])) {
                        usebgItems.put(parameter[0], null);
                    }
                    if (parameter[2] != null && !this.bgElementsInfo.containsKey(parameter[2]) && !usebgElement.containsKey(parameter[2])) {
                        usebgElement.put(parameter[2], null);
                    }
                    if (parameter[5] == null || this.currencysInfo.containsKey(parameter[5]) || useCurrency.containsKey(parameter[5])) continue;
                    useCurrency.put(parameter[5], null);
                }
                String orgUnitId = null;
                if (this.bgFormInfo != null && this.bgFormInfo.getOrgUnit() != null) {
                    orgUnitId = this.bgFormInfo.getOrgUnit().getId().toString();
                }
                visItemCol = this.getFacadeInterface().getVisualItemCollection(usebgItems, true, orgUnitId);
                for (VisualItemInfo visItemInfo2 : visItemCol) {
                    this.bgItemsInfo.put(visItemInfo2.getNumber(), visItemInfo2);
                }
                this.bgElementsInfo = BgSHelper.getBgElementInfo(null, usebgElement, (Map)this.bgElementsInfo, null);
                this.currencysInfo = BgSHelper.getCurrencyInfo(null, useCurrency, (Map)this.currencysInfo, null);
                int count2 = ctrlResultCol.size();
                for (int i = 0; i < count2; ++i) {
                    String currencyNumber;
                    BgCtrlResultInfo ctrlEntryInfo = ctrlResultCol.get(i);
                    parameter = BgNFSHelper.parseFormulaPara(this.getFormulaMap(), ctrlEntryInfo.getBgItemFormula());
                    visItemInfo2 = (VisualItemInfo)this.bgItemsInfo.get(parameter[0]);
                    String itemNumber = (String)row.getCell("bgItemNumber").getValue();
                    String elementNumber = row.getCell("bgElement").getValue() instanceof BgElementInfo ? ((BgElementInfo)row.getCell("bgElement").getValue()).getNumber() : "";
                    String string = currencyNumber = row.getCell("currency").getValue() instanceof CurrencyInfo ? ((CurrencyInfo)row.getCell("currency").getValue()).getNumber() : "";
                    if (!itemNumber.equals(visItemInfo2.getNumber()) || !elementNumber.equals(parameter[2]) || !currencyNumber.equals(parameter[5])) continue;
                    if (row.getCell("period").getValue() != null) {
                        BgPeriodInfo oldPeriodInfo = null;
                        BgPeriodInfo newPeriodInfo = null;
                        BgPeriodCollection periodColl = null;
                        String oldPeriodNum = row.getCell("period").getValue().toString();
                        String newPeriodNum = ctrlEntryInfo.getBgPeriodNumber();
                        IBgPeriod iBgPeriod = BgPeriodFactory.getRemoteInstance();
                        EntityViewInfo view = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("number", (Object)oldPeriodNum, CompareType.EQUALS));
                        view.setFilter(filter);
                        periodColl = iBgPeriod.getBgPeriodCollection(view);
                        oldPeriodInfo = periodColl.get(0);
                        filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("number", (Object)newPeriodNum, CompareType.EQUALS));
                        view.setFilter(filter);
                        periodColl = iBgPeriod.getBgPeriodCollection(view);
                        newPeriodInfo = periodColl.get(0);
                        if (oldPeriodInfo.getLevel() > newPeriodInfo.getLevel()) continue;
                        row.getCell("budgetValue").setValue((Object)BgConstants.ZERO);
                        row.getCell("actualValue").setValue((Object)BgConstants.ZERO);
                        row.getCell("baBlance").setValue((Object)BgConstants.ZERO);
                    }
                    row.getCell("period").setValue((Object)ctrlEntryInfo.getBgPeriodNumber());
                    if (ctrlEntryInfo.getBgValue() != null) {
                        row.getCell("budgetValue").setValue((Object)ctrlEntryInfo.getBgValue());
                    }
                    if (ctrlEntryInfo.getBizActual() != null) {
                        row.getCell("actualValue").setValue((Object)ctrlEntryInfo.getBizActual());
                    }
                    if (ctrlEntryInfo.getBalance() == null) break;
                    row.getCell("baBlance").setValue((Object)ctrlEntryInfo.getBalance());
                    break;
                }
            }
        }
    }

    public Map getFormulaMap() {
        return this.formulaMap;
    }

    private KDBizPromptBox getMaterialF7() {
        CompanyOrgUnitInfo org;
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        String orgUnitId = "";
        if (this.prmtReqCompany.getData() instanceof CompanyOrgUnitInfo) {
            org = (CompanyOrgUnitInfo)this.prmtReqCompany.getData();
            orgUnitId = org.getId().toString();
            prmtSelect.setCurrentMainBizOrgUnit((OrgUnitInfo)org, OrgType.CostCenter);
        } else if (this.prmtReqCompany.getData() instanceof FullOrgUnitInfo) {
            org = (FullOrgUnitInfo)this.prmtReqCompany.getData();
            orgUnitId = org.getId().toString();
            prmtSelect.setCurrentMainBizOrgUnit((OrgUnitInfo)org, OrgType.CostCenter);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo tmpFilter = new FilterInfo();
        tmpFilter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        tmpFilter.getFilterItems().add(new FilterItemInfo("status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        tmpFilter.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        view.setFilter(tmpFilter);
        prmtSelect.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialFINoGroupQuery");
        prmtSelect.setEntityViewInfo(view);
        prmtSelect.setDisplayFormat("$name$");
        prmtSelect.setEditFormat("$number$");
        prmtSelect.setCommitFormat("$number$");
        return prmtSelect;
    }

    private void initPurchase(String orgUnitId) {
        OrgUnitCollection orgUnitCollection = null;
        try {
            IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getRemoteInstance();
            if (orgUnitId != null) {
                orgUnitCollection = iOrgUnitRelation.getFromUnit(orgUnitId, 1, 3);
            }
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
        StringBuffer str = new StringBuffer();
        if (orgUnitCollection != null) {
            int c = orgUnitCollection.size();
            for (int i = 0; i < c; ++i) {
                if (str.length() > 0) {
                    str.append(",");
                }
                str.append(orgUnitCollection.get(i).getId().toString());
            }
        }
        FilterInfo filterInfo = new FilterInfo();
        EntityViewInfo ev = new EntityViewInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)str.toString(), CompareType.INCLUDE));
        ev.setFilter(filterInfo);
        this.prmtPurchaseItem.setQueryInfo("com.kingdee.eas.basedata.org.app.PurchaseItemQuery");
        this.prmtPurchaseItem.setEntityViewInfo(ev);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("CU.id"));
        return sic;
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.actionSave_actionPerformed(e);
        if (this.getInterface().unAudit(this.editData.getId())) {
            this.getUIWindow().close();
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.actionSave_actionPerformed(e);
        if (this.getInterface().audit(this.editData.getId())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCESTR, (String)"submitApplyAuditOk"));
            this.getUIWindow().close();
        }
    }

    public void beforeTransform(IObjectCollection srcObjCols, String destBillBosType) {
        BudgetRequestBillHelper.beforeTransformForBudgetRequestBill((CoreUIObject)this, srcObjCols, destBillBosType);
    }

    protected IBudgetRequestBill getInterface() throws BOSException {
        return BudgetRequestBillFactory.getRemoteInstance();
    }
}

