/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.myeas.OpenModelInfo;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.UIFrameContext;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.ma.budget.BgFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormHelper;
import com.kingdee.eas.ma.budget.IBgFacade;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.BudgetBillStateEnum;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillFactory;
import com.kingdee.eas.ma.nbudget.BudgetRequestBillHelper;
import com.kingdee.eas.ma.nbudget.BudgetRequestException;
import com.kingdee.eas.ma.nbudget.IBudgetRequestBill;
import com.kingdee.eas.ma.nbudget.client.AbstractBudgetRequestBillListUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.ma.nbudget.client.BudgetRequestBillEditUI;
import com.kingdee.eas.ma.nbudget.client.BudgetRequestBillFilterUI;
import com.kingdee.eas.ma.nbudget.client.BudgetRequestRemakeDateUI;
import com.kingdee.eas.ma.view.util.BgViewHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BudgetRequestBillListUI
extends AbstractBudgetRequestBillListUI {
    private static final long serialVersionUID = -7658620843889583276L;
    private static final Logger logger = CoreUIObject.getLogger(BudgetRequestBillListUI.class);
    protected String projectName = null;
    protected BudgetRequestBillFilterUI defaultFilterUI = null;
    protected IMetaDataPK mainQueryPk = null;
    protected Map budgetInfo = null;
    protected Map bgItemsInfo = null;
    protected Map bgElementsInfo = null;
    protected Map currencysInfo = null;
    private Map formulaMap = null;
    protected IBgFacade ibgFacade = null;
    private boolean isInit = false;
    private Set permissionOrg = null;
    private Map paramValue = null;
    private Map permissionOrgMap = new HashMap();
    private boolean hasFodian = false;
    private String permissionNum = "BudgetRequest001_list";

    public void setParamValue(Map paramValue) {
        this.paramValue = paramValue;
    }

    public Map getParamValue() {
        return this.paramValue;
    }

    public boolean isHasFodian() {
        return this.hasFodian;
    }

    public void setHasFodian(boolean hasFodian) {
        this.hasFodian = hasFodian;
    }

    public Set getPermissionOrg() {
        return this.permissionOrg;
    }

    public void setPermissionOrg(Set permissionOrg) {
        this.permissionOrg = permissionOrg;
    }

    public BudgetRequestBillListUI() throws Exception {
        this.bgItemsInfo = new HashMap();
        this.bgElementsInfo = new HashMap();
        this.currencysInfo = new HashMap();
    }

    protected BudgetRequestBillFilterUI getFilterUI() {
        if (this.defaultFilterUI == null) {
            try {
                this.defaultFilterUI = new BudgetRequestBillFilterUI((Object)this);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                this.handleException(ex);
            }
        }
        return this.defaultFilterUI;
    }

    public void onLoad() throws Exception {
        this.rbCurrOrgUnit.setSelected(true);
        this.setParamValue(BgNSHelper.getAllParamValue());
        this.setHasFodian(BgParamCHelper.isFodian());
        if (this.permissionNum != null) {
            FullOrgUnitCollection orgCol = this.getBgFacadeInterface().getAuthorizedOrg((IObjectPK)new ObjectUuidPK(this.getUserInfo().getId()), OrgType.CostCenter, null, this.permissionNum);
            this.getPermissionOrg(orgCol);
        }
        this.initTreePopMenu();
        this.treeOrgUnit.setModel(null);
        this.treeOrgUnit.setEnabled(false);
        super.onLoad();
        this.tblMain.getGroupManager().setGroup(true);
        this.initComboxOrgType();
        this.refreshOrgUnitTree();
        this.locateCurrentOrg();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        boolean isPerimess = true;
        if (node != null) {
            isPerimess = !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node);
        }
        this.actionAddNew.setEnabled(isPerimess);
        this.treeOrgUnit.setEnabled(true);
        this.isInit = true;
        this.applyPreference();
        this.tblMain.refresh();
    }

    protected IBgFacade getBgFacadeInterface() throws Exception {
        return BgFacadeFactory.getRemoteInstance();
    }

    private void getPermissionOrg(FullOrgUnitCollection orgCol) {
        if (orgCol != null && orgCol.size() > 0) {
            for (int i = 0; i < orgCol.size(); ++i) {
                this.permissionOrgMap.put(orgCol.get(i).getId(), null);
            }
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnClose.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.reMakeDate.setIcon(EASResource.getIcon((String)"imgTbtn_asset"));
        this.btnAudit.setEnabled(true);
        this.btnUnAudit.setEnabled(true);
        this.btnClose.setEnabled(true);
        this.reMakeDate.setEnabled(true);
        this.btnEdit.setEnabled(true);
        this.btnSubmit.setEnabled(true);
        this.btnCreateTo.setEnabled(false);
        this.btnTraceDown.setEnabled(false);
        this.btnLocate.setVisible(false);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BudgetRequestBillFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return BudgetRequestBillEditUI.class.getName();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor queryExecutor = null;
        FilterInfo filter = null;
        if (this.rbImmOrgUnit.isSelected()) {
            filter = this.getImmSelectedQueryFilterInfo(viewInfo);
        } else if (this.rbAllOrgUnit.isSelected()) {
            filter = this.getSelectedQueryFilterInfo(viewInfo);
        } else if (this.rbCurrOrgUnit.isSelected()) {
            filter = this.getUnSelectedQueryFilterInfo(viewInfo);
        }
        viewInfo.setFilter(filter);
        queryExecutor = super.getQueryExecutor(queryPK, viewInfo);
        return queryExecutor;
    }

    protected void initComboxOrgType() {
        this.comboxOrgType.addItem((Object)OrgViewType.COSTCENTER);
        this.comboxOrgType.setSelectedItem((Object)OrgViewType.COSTCENTER);
        this.comboxOrgType.setEnabled(false);
        this.treeViewOrgUnit.setTitle(OrgViewType.RESPONSECENTER.getAlias());
    }

    protected IObjectPK getOrgPK() {
        CompanyOrgUnitInfo info = SysContext.getSysContext().getCurrentFIUnit();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node != null) {
            OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
            FullOrgUnitInfo org = oui.getUnit();
            org.setLongNumber(oui.getLongNumber());
            if (org.isIsCompanyOrgUnit()) {
                return new ObjectUuidPK(org.getId());
            }
        }
        return info != null ? new ObjectUuidPK(info.getId()) : null;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        String _orgUnitId = this.getOrgUnitId();
        if (StringUtils.isEmpty((String)_orgUnitId) || SysContext.getSysContext().getCurrentCostUnit() == null) {
            return new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId());
        }
        return new ObjectUuidPK(_orgUnitId);
    }

    protected FilterInfo getImmSelectedQueryFilterInfo(EntityViewInfo viewInfo) {
        FilterInfo filter = this.getDefaultFilterForQuery();
        filter = this.getQueryFilterInfo(filter);
        if (this.permissionOrg == null) {
            this.permissionOrg = new HashSet();
        } else {
            this.permissionOrg.clear();
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
            HashSet<String> orgUnitIdSet = new HashSet<String>();
            OrgStructureInfo _oui = null;
            FullOrgUnitInfo _orgUnitInfo = null;
            DefaultKingdeeTreeNode _node = null;
            _oui = (OrgStructureInfo)node.getUserObject();
            _orgUnitInfo = _oui.getUnit();
            if (this.permissionOrgMap.containsKey(_orgUnitInfo.getId())) {
                orgUnitIdSet.add(_orgUnitInfo.getId().toString());
                this.permissionOrg.add(_orgUnitInfo.getId().toString());
            }
            if (!node.isLeaf()) {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    _node = (DefaultKingdeeTreeNode)node.getChildAt(i);
                    if (_node == null || OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)_node) || !this.permissionOrgMap.containsKey((_orgUnitInfo = (_oui = (OrgStructureInfo)_node.getUserObject()).getUnit()).getId())) continue;
                    orgUnitIdSet.add(_orgUnitInfo.getId().toString());
                    this.permissionOrg.add(_orgUnitInfo.getId().toString());
                }
            }
            FilterItemInfo item = null;
            item = orgUnitIdSet.isEmpty() ? new FilterItemInfo("orgUnit.id".toLowerCase(), (Object)"000000000000000000000000000=", CompareType.EQUALS) : new FilterItemInfo("orgUnit.id".toLowerCase(), orgUnitIdSet, CompareType.INCLUDE);
            this.replaceFilterItems(filter, item);
        }
        return filter;
    }

    protected FilterInfo getSelectedQueryFilterInfo(EntityViewInfo viewInfo) {
        FilterInfo filter = this.getDefaultFilterForQuery();
        filter = this.getQueryFilterInfo(filter);
        if (this.permissionOrg == null) {
            this.permissionOrg = new HashSet();
        } else {
            this.permissionOrg.clear();
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
            OrgStructureInfo _oui = null;
            FullOrgUnitInfo _orgUnitInfo = null;
            FullOrgUnitInfo _tmpUnitInfo = null;
            ArrayList<FullOrgUnitInfo> list = new ArrayList<FullOrgUnitInfo>();
            _oui = (OrgStructureInfo)node.getUserObject();
            _orgUnitInfo = _oui.getUnit();
            _orgUnitInfo.setLongNumber(_oui.getLongNumber());
            list.add(_orgUnitInfo);
            this.traceNode(node, list);
            for (int i = 0; i < list.size(); ++i) {
                _tmpUnitInfo = (FullOrgUnitInfo)list.get(i);
                if (!this.permissionOrgMap.containsKey(_tmpUnitInfo.getId())) continue;
                this.permissionOrg.add(_tmpUnitInfo.getId().toString());
            }
            FilterItemInfo itemInfo = null;
            itemInfo = this.permissionOrg.isEmpty() ? new FilterItemInfo("orgUnit.id".toLowerCase(), (Object)"000000000000000000000000000=", CompareType.EQUALS) : new FilterItemInfo("orgUnit.id".toLowerCase(), (Object)this.permissionOrg, CompareType.INCLUDE);
            this.replaceFilterItems(filter, itemInfo);
            BgNSHelper.objClear(list);
        }
        return filter;
    }

    private void traceNode(DefaultKingdeeTreeNode root, ArrayList list) {
        DefaultKingdeeTreeNode _node = null;
        OrgStructureInfo _osi = null;
        FullOrgUnitInfo _unitInfo = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            _node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (_node == null || OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)_node)) continue;
            _osi = (OrgStructureInfo)_node.getUserObject();
            _unitInfo = _osi.getUnit();
            _unitInfo.setLongNumber(_osi.getLongNumber());
            list.add(_unitInfo);
            if (_node.getChildCount() == 0) continue;
            this.traceNode(_node, list);
        }
    }

    protected FilterInfo getUnSelectedQueryFilterInfo(EntityViewInfo viewInfo) {
        FilterInfo filter = this.getDefaultFilterForQuery();
        filter = this.getQueryFilterInfo(filter);
        if (this.permissionOrg == null) {
            this.permissionOrg = new HashSet();
        } else {
            this.permissionOrg.clear();
        }
        String billId = this.getOrgUnitId();
        if (billId != null && this.permissionOrgMap.containsKey(BOSUuid.read((String)this.getOrgUnitId()))) {
            this.permissionOrg.add(this.getOrgUnitId());
        }
        FilterItemInfo item = null;
        item = this.permissionOrg.isEmpty() ? new FilterItemInfo("orgUnit.id".toLowerCase(), (Object)"000000000000000000000000000=", CompareType.EQUALS) : new FilterItemInfo("orgUnit.id".toLowerCase(), (Object)this.getOrgUnitId(), CompareType.EQUALS);
        this.replaceFilterItems(filter, item);
        return filter;
    }

    protected final void replaceFilterItems(FilterInfo filter, FilterItemInfo item) {
        if (filter == null || item == null) {
            return;
        }
        boolean isReplace = false;
        if (filter.getFilterItems() != null) {
            FilterItemInfo fiInfo = null;
            FilterItemCollection fiCol = filter.getFilterItems();
            int n = fiCol.size();
            for (int i = 0; i < n; ++i) {
                fiInfo = fiCol.get(i);
                if (!fiInfo.getPropertyName().trim().equals(item.getPropertyName().trim())) continue;
                fiInfo.setCompareType(item.getCompareType());
                fiInfo.setCompareValue(item.getCompareValue());
                isReplace = true;
            }
            if (!isReplace) {
                fiCol.add(item);
                int itemsSize = fiCol.size();
                if (itemsSize <= 1) {
                    filter.setMaskString("(#0)");
                } else {
                    filter.setMaskString(filter.getMaskString() + " and (#" + String.valueOf(itemsSize - 1) + ")");
                }
            }
        }
    }

    protected String getOrgUnitId() {
        OrgUnitInfo orgUnitInfo = this.getOrgUnitInfo();
        if (orgUnitInfo != null) {
            return orgUnitInfo.getId().toString();
        }
        return null;
    }

    protected FilterInfo getQueryFilterInfo(FilterInfo filter) {
        if (filter == null) {
            filter = this.getDefaultFilterForQuery();
        }
        EntityViewInfo tmpView = null;
        if (this.getDialog() != null) {
            try {
                tmpView = this.getEntityViewInfo(this.getDialog().getEntityViewInfoResult());
            }
            catch (BOSException ex) {
                logger.error((Object)ex);
            }
            if ((tmpView == null || tmpView.getFilter() == null) && this.getDialog().getCurrentSolutionInfo() != null) {
                if (tmpView == null) {
                    tmpView = new EntityViewInfo();
                }
                try {
                    tmpView.decode(this.getDialog().getCurrentSolutionInfo().getEntityViewInfo());
                }
                catch (Exception ex) {
                    logger.error((Object)this.getDialog().getCurrentSolutionInfo().getEntityViewInfo());
                    logger.error((Object)ex);
                }
            }
        } else {
            tmpView = this.getDefaultEntityViewInfo();
        }
        if (tmpView != null && tmpView.getFilter() != null && tmpView.getFilter().getFilterItems() != null && !tmpView.getFilter().getFilterItems().isEmpty()) {
            filter.getFilterItems().addObjectCollection((IObjectCollection)tmpView.getFilter().getFilterItems());
            if (!StringUtils.isEmpty((String)tmpView.getFilter().getMaskString())) {
                filter.setMaskString("(" + tmpView.getFilter().getMaskString() + ")");
            } else {
                int size = filter.getFilterItems().size();
                if (size <= 1) {
                    filter.setMaskString("#0");
                } else {
                    StringBuffer str = new StringBuffer("#0");
                    int in = size;
                    for (int i = 1; i < in; ++i) {
                        str.append(" and #").append(i);
                    }
                }
            }
        }
        return filter;
    }

    public boolean checkPermissionByOrg(OrgUnitInfo orgUnitInfo) throws BOSException {
        boolean isPermiss = false;
        if (orgUnitInfo == null) {
            return isPermiss;
        }
        UserInfo userInfo = this.getUserInfo();
        if (userInfo == null) {
            return isPermiss;
        }
        String strUserId = userInfo.getId().toString();
        String strOrgId = orgUnitInfo.getId().toString();
        IOrgRange iOrgRange = OrgRangeFactory.getRemoteInstance();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("user".toLowerCase(), (Object)strUserId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("org".toLowerCase(), (Object)strOrgId, CompareType.EQUALS));
        filterInfo.setMaskString("#0 and #1");
        entityViewInfo.setFilter(filterInfo);
        OrgRangeCollection orgRangeCollection = iOrgRange.getOrgRangeCollection(entityViewInfo);
        if (orgRangeCollection.size() > 0) {
            isPermiss = true;
        }
        return isPermiss;
    }

    @Override
    public void actionCloseBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String canClose = BudgetRequestBillFactory.getRemoteInstance().isApplyValueToUseValue(BOSUuid.read((String)this.getSelectedKeyValue()));
        if (canClose == null) {
            boolean closeResult = BudgetRequestBillFactory.getRemoteInstance().close(BOSUuid.read((String)this.getSelectedKeyValue()));
            if (!closeResult) {
                MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"unAuditMesg"));
            } else {
                this.refreshList();
            }
        } else {
            int isUsedFinishedOfBudgetMoney = MsgBox.showConfirm2((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"isUsedFinishedOfBudgetMoney"), canClose));
            if (isUsedFinishedOfBudgetMoney == 0) {
                boolean closeResult = BudgetRequestBillFactory.getRemoteInstance().close(BOSUuid.read((String)this.getSelectedKeyValue()));
                if (!closeResult) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"unAuditMesg"));
                } else {
                    this.refreshList();
                }
            }
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (id != null) {
            BgFormHelper.checkInProInst((String)id);
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)id);
            this.prepareUIContext(uiContext, e);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
            if (this.isDoRefresh(uiWindow)) {
                this.refresh(e);
            }
        }
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (id != null) {
            BgFormHelper.checkInProInst((String)id);
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)id);
            this.prepareUIContext(uiContext, e);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
            if (this.isDoRefresh(uiWindow)) {
                this.refresh(e);
            }
        }
    }

    public void actionViewAdjust_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void checkBills(int state) throws Exception {
        int rowCount = 0;
        int rowBegin = 0;
        int rowEnd = 0;
        KDTSelectBlock block = null;
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range != null) {
            rowCount = range.size();
            for (int i = 0; i < rowCount; ++i) {
                block = (KDTSelectBlock)range.get(i);
                rowBegin = block.getBeginRow();
                rowEnd = block.getEndRow();
                for (int j = rowBegin; j <= rowEnd; ++j) {
                    this.checkBill(j, state);
                }
            }
        }
    }

    protected void checkBill(int rowIndex, int state) throws Exception {
        IRow row = this.tblMain.getRow(rowIndex = rowIndex == -1 ? 0 : rowIndex);
        if (row != null) {
            String number = (String)row.getCell("number").getValue();
            BizEnumValueInfo enumState = (BizEnumValueInfo)row.getCell("state").getValue();
            if (enumState.getInt() != state) {
                if (state == 5) {
                    throw new BudgetRequestException(BudgetRequestException.ISNOTAUDITEDSTATE, new String[]{number});
                }
                if (state == 0) {
                    throw new BudgetRequestException(BudgetRequestException.ISNOTPROCESSSTATE, new String[]{number});
                }
            }
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (BgFormHelper.checkInProInst((String)id)) {
            throw new BudgetRequestException(BudgetRequestException.SUBMITBILLINWORK);
        }
        BOSUuid billId = BOSUuid.read((String)id);
        this.getInterface().submitWorkFlow(billId);
        this.refreshList();
    }

    public void actionWfAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.getSelectedKeyValue() != null) {
            boolean wfAuditResult = BudgetRequestBillFactory.getRemoteInstance().wfAudit(BOSUuid.read((String)this.getSelectedKeyValue()), SysContext.getSysContext().getCurrentUserInfo().getId());
            if (!wfAuditResult) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"billAuditedMesg"));
            } else {
                this.refreshList();
            }
        }
    }

    public void actionWfUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.getSelectedKeyValue() != null) {
            boolean wfAuditResult = BudgetRequestBillFactory.getRemoteInstance().wfUnAudit(BOSUuid.read((String)this.getSelectedKeyValue()), SysContext.getSysContext().getCurrentUserInfo().getId());
            if (!wfAuditResult) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"billAuditedMesg"));
            } else {
                this.refreshList();
            }
        }
    }

    @Override
    public void actionRemakeDate_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionRemakeDate_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        int rowIndex = BgViewHelper.getSelectedRowIndex((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowIndex);
        Date bgEndDate = (Date)row.getCell("bgEndDate").getValue();
        uiContext.put((Object)"bgEndDate", (Object)bgEndDate);
        uiContext.put((Object)"billID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"BudgetRequestBillListUI", (Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BudgetRequestRemakeDateUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        try {
            dialog.setEntityViewInfo(new EntityViewInfo());
            dialog.addUserPanel((KDPanel)this.getFilterUI());
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return dialog;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        FullOrgUnitInfo orgInfo = this.getBGOrgUnitInfo();
        uiContext.put((Object)"ORGUNIT_INFO", (Object)orgInfo);
        uiContext.put((Object)"ORGUNIT_CU", (Object)orgInfo.getCU());
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkOrgUnitDisable();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BudgetRequestBillListUI", (Object)this);
        super.actionAddNew_actionPerformed(e);
    }

    protected boolean checkOrgUnitDisable(DefaultKingdeeTreeNode node) {
        OrgStructureInfo oui;
        DefaultKingdeeTreeNode _node = null;
        FullOrgUnitInfo orgInfo = null;
        _node = node == null ? (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent() : node;
        if (_node != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)_node) && (oui = (OrgStructureInfo)_node.getUserObject()) != null && oui.getUnit() != null) {
            orgInfo = oui.getUnit();
            try {
                orgInfo = this.getFullOrgUnitInterface().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgInfo.getId()));
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
            return orgInfo.isIsOUSealUp();
        }
        return false;
    }

    protected void checkOrgUnitDisable() {
        if (this.checkOrgUnitDisable(null)) {
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "orgUnitDisable"));
            SysUtil.abort();
        }
    }

    @Override
    protected void treeOrgUnit_valueChanged(TreeSelectionEvent e) throws Exception {
        if (!this.treeOrgUnit.isEnabled()) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node != null) {
            if (OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
                this.enableBtns(false);
                this.tblMain.removeRows();
                if (this.isInit) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"SelectPermiUnit"));
                    SysUtil.abort();
                }
            } else {
                this.enableBtns(true);
                OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
                if (oui != null && oui.getUnit() != null) {
                    this.buildTreeFilter();
                    this.execQuery();
                }
            }
        }
    }

    protected void buildTreeFilter() throws Exception {
        if (this.mainQuery.getFilter() == null) {
            this.mainQuery.setFilter(new FilterInfo());
        }
        EntityViewInfo view = null;
        String cureQueryName = BudgetRequestBillListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        QuerySolutionInfo querySolution = this.getQuerySolutionInterface().getDefaultSolution(this.getMetaDataPK().getFullName(), cureQueryName);
        if (querySolution != null) {
            if (querySolution != null && querySolution.getEntityViewInfo() != null) {
                view = Util.getInnerFilterInfo((QuerySolutionInfo)querySolution);
            } else if (this.getDialog() != null && this.getDialog().getEntityViewInfoResult() != null) {
                view = this.getDialog().getEntityViewInfoResult();
            }
        }
        if (view != null) {
            this.mainQuery = this.getEntityViewInfo(view);
        } else {
            this.removeQueryFilterAndSorter(this.mainQuery);
            this.mainQuery.getFilter().remove("maskString");
        }
    }

    protected IQuerySolutionFacade getQuerySolutionInterface() throws Exception {
        return QuerySolutionFacadeFactory.getRemoteInstance();
    }

    protected void enableBtns(boolean flag) {
        this.btnAddNew.setEnabled(flag);
        this.actionAddNew.setEnabled(flag);
        this.btnView.setEnabled(flag);
        this.btnEdit.setEnabled(flag);
        this.btnRefresh.setEnabled(flag);
        this.btnRemove.setEnabled(flag);
    }

    protected FullOrgUnitInfo getBGOrgUnitInfo() {
        OrgStructureInfo oui;
        FullOrgUnitInfo info = null;
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node) && (oui = (OrgStructureInfo)node.getUserObject()) != null && oui.getUnit() != null) {
            info = oui.getUnit();
            String id = info.getId().toString();
            try {
                FullOrgUnitInfo info1 = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo("select CU.id, CU.name where id='" + id + "'");
                info.setCU(info1.getCU());
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
            info.setLongNumber(oui.getLongNumber());
        }
        return info;
    }

    protected IFullOrgUnit getFullOrgUnitInterface() throws Exception {
        return FullOrgUnitFactory.getRemoteInstance();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    protected FullOrgUnitInfo getOrgUnitInfo(DefaultKingdeeTreeNode node) {
        OrgStructureInfo oui;
        FullOrgUnitInfo orgInfo = null;
        if (node != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node) && (oui = (OrgStructureInfo)node.getUserObject()) != null && oui.getUnit() != null) {
            orgInfo = oui.getUnit();
            orgInfo.setLongNumber(oui.getLongNumber());
        }
        return orgInfo;
    }

    private void refreshOrgUnitTree() throws Exception {
        TreeModel treeModel = null;
        String rootUnitID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        try {
            treeModel = BgNFSHelper.getOrgTreeModel(rootUnitID, this.treeOrgUnit);
            this.treeOrgUnit.setModel(treeModel);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        if (this.treeOrgUnit.getRowCount() > 0) {
            this.treeOrgUnit.expandRow(0);
        }
        this.treeOrgUnit.setSelectionRow(0);
        if (this.getOrgUnitInfo() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"noResponTree"));
            SysUtil.abort();
        }
    }

    private void locateCurrentOrg() throws BOSException, EASBizException {
        int i;
        FullOrgUnitInfo fOrgUnitInfo = null;
        OrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
        for (i = 0; i < this.treeOrgUnit.getRowCount(); ++i) {
            this.treeOrgUnit.expandRow(i);
        }
        if (orgUnitInfo != null && orgUnitInfo.getId() != null) {
            int size = this.treeOrgUnit.getRowCount();
            for (i = 0; i < size; ++i) {
                TreePath tp = this.treeOrgUnit.getPathForRow(i);
                if (tp == null) continue;
                DefaultKingdeeTreeNode tn = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
                if (tn == null) {
                    return;
                }
                OrgStructureInfo oui = null;
                if (size == 1) {
                    oui = new OrgStructureInfo();
                    FullOrgUnitInfo fullOrgUnit = null;
                    try {
                        fullOrgUnit = this.getFullOrgUnitInterface().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()));
                    }
                    catch (Exception e) {
                        logger.error((Object)"budget error:", (Throwable)e);
                    }
                    oui.setUnit(fullOrgUnit);
                    if (fullOrgUnit != null && fullOrgUnit.getLongNumber() != null) {
                        oui.setLongNumber(fullOrgUnit.getLongNumber());
                    }
                } else {
                    oui = (OrgStructureInfo)tn.getUserObject();
                }
                if (oui == null || oui.getUnit() == null) continue;
                fOrgUnitInfo = oui.getUnit();
                fOrgUnitInfo.setLongNumber(oui.getLongNumber());
                if (!fOrgUnitInfo.getId().toString().equals(orgUnitInfo.getId().toString())) continue;
                this.treeOrgUnit.setSelectionRow(i);
                break;
            }
        }
        if (this.treeOrgUnit.getSelectionPath() == null && this.treeOrgUnit.getRowCount() > 0) {
            this.treeOrgUnit.setSelectionRow(0);
        }
        if (this.treeOrgUnit.getModel() != null && this.treeOrgUnit.getModel().getRoot() != null) {
            DefaultKingdeeTreeNode currNode;
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
            this.treeOrgUnit.expandAllNodes(false, (TreeNode)root);
            OrgStructureInfo oui = (OrgStructureInfo)root.getUserObject();
            ArrayList list = new ArrayList();
            IFullOrgUnit iou = FullOrgUnitFactory.getRemoteInstance();
            FullOrgUnitInfo currentOrg = SysContext.getSysContext().getCurrentOrgUnit().castToFullOrgUnitInfo();
            if (oui != null) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("parent.id"));
                this.getCurrentOrgTree(list, currentOrg, oui.getUnit(), iou, selector);
            }
            if ((currNode = this.expandCurrentOrg(list, root)) != null) {
                this.treeOrgUnit.setSelectionPath(new TreePath(currNode.getPath()));
            }
        }
    }

    protected void getCurrentOrgTree(List list, FullOrgUnitInfo currentOrg, FullOrgUnitInfo endOrg, IFullOrgUnit iou, SelectorItemCollection selector) throws BOSException, EASBizException {
        if (list == null || currentOrg == null || endOrg == null || iou == null) {
            return;
        }
        if (currentOrg.getId().equals((Object)endOrg.getId())) {
            list.add(endOrg.getId().toString());
        } else {
            list.add(currentOrg.getId().toString());
            if (currentOrg.getParent() != null) {
                currentOrg = iou.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentOrg.getParent().getId()), selector);
            }
            this.getCurrentOrgTree(list, currentOrg, endOrg, iou, selector);
        }
    }

    protected DefaultKingdeeTreeNode expandCurrentOrg(List currOrgTree, DefaultKingdeeTreeNode node) {
        OrgStructureInfo oui;
        DefaultKingdeeTreeNode sub = null;
        DefaultKingdeeTreeNode res = null;
        if (node != null && (oui = (OrgStructureInfo)node.getUserObject()) != null) {
            String id = oui.getUnit().getId().toString();
            if (id.equals(currOrgTree.get(0))) {
                res = node;
            } else if (currOrgTree.contains(id)) {
                this.treeOrgUnit.expandPath(new TreePath(node.getPath()));
                for (int i = 0; i < node.getChildCount() && (res = this.expandCurrentOrg(currOrgTree, sub = (DefaultKingdeeTreeNode)node.getChildAt(i))) == null; ++i) {
                }
            }
        }
        return res;
    }

    private Map initMap() {
        String resource = "com.kingdee.eas.ma.budget.client.BgFormResource";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("actopen", EASResource.getString((String)resource, (String)"actopen"));
        map.put("actclose", EASResource.getString((String)resource, (String)"actclose"));
        map.put("actopenll", EASResource.getString((String)resource, (String)"actopenll"));
        map.put("actopenall", EASResource.getString((String)resource, (String)"actopenall"));
        map.put("actcloseall", EASResource.getString((String)resource, (String)"actcloseall"));
        return map;
    }

    protected void initTreePopMenu() {
        Map map = this.initMap();
        String resource = "com.kingdee.eas.ma.budget.client.BgFormResource";
        String baseStr = "bgFormR";
        for (int i = 0; i < this.treeOrgUnit.getPopupMenu().getComponentCount(); ++i) {
            if (!(this.treeOrgUnit.getPopupMenu().getComponent(i) instanceof JMenuItem)) continue;
            JMenuItem mItem = (JMenuItem)this.treeOrgUnit.getPopupMenu().getComponent(i);
            String text = null;
            try {
                String key = mItem.getActionCommand();
                if (!map.containsKey(key)) continue;
                text = map.get(key).toString();
                mItem.setText(text);
                continue;
            }
            catch (Exception e) {
                logger.debug((Object)"Read resource error:", (Throwable)e);
            }
        }
        this.treeOrgUnit.addTreePopupMenu(new TreePopupMenuListener(){

            public boolean popMenu(TreePopupMenuEvent event) {
                return BudgetRequestBillListUI.this.isShowTreePopMenu();
            }
        });
    }

    protected boolean isShowTreePopMenu() {
        return true;
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.setButtonState();
    }

    protected void setButtonState() throws BOSException {
        int rowIndex = BgViewHelper.getSelectedRowIndex((KDTable)this.tblMain);
        if (rowIndex >= 0) {
            IRow row = this.tblMain.getRow(rowIndex);
            BizEnumValueDTO billState = (BizEnumValueDTO)row.getCell("state").getValue();
            if (billState.getInt() == 9) {
                this.btnSubmit.setEnabled(false);
                this.btnAudit.setEnabled(false);
                this.btnUnAudit.setEnabled(false);
                this.btnClose.setEnabled(false);
                this.btnEdit.setEnabled(false);
                this.btnRemove.setEnabled(false);
                this.btnCreateTo.setEnabled(false);
                this.reMakeDate.setEnabled(false);
                this.btnTraceDown.setEnabled(true);
                this.menuItemEdit.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
                this.menuItemCreateTo.setEnabled(false);
                this.menuItemTraceDown.setEnabled(false);
            } else {
                boolean isHasNotWork = this.isHasNotWorkFlow();
                if (billState.getInt() == 0) {
                    this.btnEdit.setEnabled(true);
                    this.btnSubmit.setEnabled(true);
                    this.btnAudit.setEnabled(true);
                    this.btnUnAudit.setEnabled(false);
                    this.btnClose.setEnabled(false);
                    this.reMakeDate.setEnabled(false);
                    this.btnRemove.setEnabled(true);
                    this.btnCreateTo.setEnabled(false);
                    this.btnTraceDown.setEnabled(false);
                    this.menuItemEdit.setEnabled(true);
                    this.menuItemRemove.setEnabled(true);
                    this.menuItemCreateTo.setEnabled(false);
                    this.menuItemTraceDown.setEnabled(false);
                } else if (billState.getInt() == 1) {
                    if (isHasNotWork) {
                        this.btnAudit.setEnabled(false);
                        this.btnUnAudit.setEnabled(false);
                        this.btnSubmit.setEnabled(false);
                    } else {
                        this.btnAudit.setEnabled(true);
                        this.btnUnAudit.setEnabled(false);
                        this.btnSubmit.setEnabled(true);
                    }
                    this.btnEdit.setEnabled(false);
                    this.btnRemove.setEnabled(false);
                    this.btnClose.setEnabled(false);
                    this.reMakeDate.setEnabled(false);
                    this.btnCreateTo.setEnabled(false);
                    this.btnTraceDown.setEnabled(false);
                    this.menuItemEdit.setEnabled(false);
                    this.menuItemRemove.setEnabled(false);
                    this.menuItemCreateTo.setEnabled(false);
                    this.menuItemTraceDown.setEnabled(false);
                } else if (billState.getInt() == 3) {
                    this.btnAudit.setEnabled(false);
                    this.btnUnAudit.setEnabled(false);
                    this.btnSubmit.setEnabled(false);
                    this.btnEdit.setEnabled(false);
                    this.btnRemove.setEnabled(false);
                    this.btnClose.setEnabled(false);
                    this.reMakeDate.setEnabled(false);
                    this.btnCreateTo.setEnabled(false);
                    this.btnTraceDown.setEnabled(false);
                    this.menuItemEdit.setEnabled(false);
                    this.menuItemRemove.setEnabled(false);
                    this.menuItemCreateTo.setEnabled(false);
                    this.menuItemTraceDown.setEnabled(false);
                } else if (billState.getInt() == 5) {
                    this.btnAudit.setEnabled(false);
                    this.btnSubmit.setEnabled(false);
                    this.btnUnAudit.setEnabled(true);
                    this.btnEdit.setEnabled(false);
                    this.btnRemove.setEnabled(false);
                    this.btnClose.setEnabled(true);
                    this.reMakeDate.setEnabled(true);
                    this.btnCreateTo.setEnabled(true);
                    this.btnTraceDown.setEnabled(true);
                    this.menuItemEdit.setEnabled(false);
                    this.menuItemRemove.setEnabled(false);
                    this.menuItemCreateTo.setEnabled(false);
                    this.menuItemTraceDown.setEnabled(false);
                } else if (billState.getInt() == 11) {
                    this.btnAudit.setEnabled(false);
                    this.btnSubmit.setEnabled(false);
                    this.btnUnAudit.setEnabled(false);
                    this.btnEdit.setEnabled(false);
                    this.btnRemove.setEnabled(false);
                    this.btnClose.setEnabled(false);
                    this.reMakeDate.setEnabled(false);
                    this.btnCreateTo.setEnabled(true);
                    this.btnTraceDown.setEnabled(true);
                    this.menuItemEdit.setEnabled(false);
                    this.menuItemRemove.setEnabled(false);
                    this.menuItemCreateTo.setEnabled(false);
                    this.menuItemTraceDown.setEnabled(false);
                }
            }
        }
        this.menuItemTraceDown.setEnabled(this.btnTraceDown.isEnabled());
        this.menuItemTraceDown.setVisible(this.btnTraceDown.isVisible());
    }

    public boolean isHasNotWorkFlow() throws BOSException {
        boolean isHasNotWorkFlow = false;
        String fieldName = this.getQueryFieldNameBindingWf();
        String id = (String)this.getSelectedFieldValues(fieldName).get(0);
        IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
        ProcessInstInfo processInstInfo = null;
        ProcessInstInfo[] procInsts = service.getProcessInstanceByHoldedObjectId(id);
        int n = procInsts.length;
        for (int i = 0; i < n; ++i) {
            if (!procInsts[i].getState().startsWith("open")) continue;
            processInstInfo = procInsts[i];
        }
        isHasNotWorkFlow = processInstInfo == null ? (procInsts = service.getAllProcessInstancesByBizobjId(id)) != null && procInsts.length > 0 : true;
        return isHasNotWorkFlow;
    }

    protected String getEditUIModal() {
        OpenModelInfo openModelInfo = (OpenModelInfo)UIFrameContext.getInstance().getProperty((Object)"OpenModel");
        if (openModelInfo != null) {
            if (openModelInfo.isIsOpenInFour()) {
                return "com.kingdee.eas.base.uiframe.client.UIFixTabFactory";
            }
            if (openModelInfo.isIsOpenInNewTab()) {
                return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
            }
            if (openModelInfo.isIsOpenInWindow()) {
                return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
            }
        }
        return "com.kingdee.eas.base.uiframe.client.UIFixTabFactory";
    }

    public Map getFormulaMap() {
        return this.formulaMap;
    }

    protected IBgFacade getFacadeInterface() throws Exception {
        if (this.ibgFacade == null) {
            this.ibgFacade = BgFacadeFactory.getRemoteInstance();
        }
        return this.ibgFacade;
    }

    protected IBudgetRequestBill getInterface() throws BOSException {
        return BudgetRequestBillFactory.getRemoteInstance();
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            request.put("USER_ID", (Object)this.getUserInfo().getId().toString());
            request.put("ORGUNIT_CU", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            request.put("PERMISSION_NUM", (Object)this.permissionNum);
        }
        return handler;
    }

    public boolean isPrepareDestoryWindow() {
        return true;
    }

    protected OrgUnitInfo getOrgUnitInfo() {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        return this.getOrgUnitInfo(node);
    }

    @Override
    protected void rbCurrOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        if (this.rbCurrOrgUnit.isSelected()) {
            this.tblMain.refresh();
        }
    }

    @Override
    protected void rbImmOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        if (this.rbImmOrgUnit.isSelected()) {
            this.tblMain.refresh();
        }
    }

    @Override
    protected void rbAllOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        if (this.rbAllOrgUnit.isSelected()) {
            this.tblMain.refresh();
        }
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        String boID = this.getSelectedKeyValue();
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row.getCell("state").getValue().toString().equals(BudgetBillStateEnum.bgAudited.toString())) {
            boID = row.getCell("id").getValue().toString();
        }
        if (boID == null) {
            return;
        }
        acm.showAttachmentListUIByBoID(boID, (Object)this, this.btnEdit.isEnabled());
    }

    public void beforeTransform(IObjectCollection srcObjCols, String destBillBosType) {
        BudgetRequestBillHelper.beforeTransformForBudgetRequestBill((CoreUIObject)this, srcObjCols, destBillBosType);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        BudgetRequestBillHelper.addVerifySelector(sic);
        return sic;
    }
}

