/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IEditableExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.NameExpr;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.client.NewBgItemForEnumDialog;
import com.kingdee.eas.ma.nbudget.BudgetRequestConfigEnum;
import com.kingdee.eas.ma.nbudget.BudgetRequestConfigFactory;
import com.kingdee.eas.ma.nbudget.BudgetRequestConfigInfo;
import com.kingdee.eas.ma.nbudget.IBudgetRequestConfig;
import com.kingdee.eas.ma.nbudget.client.AbstractBudgetRequestConfigEditUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BudgetRequestConPeriodF7;
import com.kingdee.eas.ma.nbudget.client.BudgetRequestConfigExpressionF7;
import com.kingdee.eas.ma.nbudget.request.BgBillInfo;
import com.kingdee.eas.ma.nbudget.request.BgConfigFieldComboxVal;
import com.kingdee.eas.ma.nbudget.request.BgFields;
import com.kingdee.eas.ma.nbudget.request.IBgBill;
import com.kingdee.eas.ma.nbudget.request.IBgField;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class BudgetRequestConfigEditUI
extends AbstractBudgetRequestConfigEditUI {
    private static final long serialVersionUID = -4474517267173132584L;
    private static final Logger logger = CoreUIObject.getLogger(BudgetRequestConfigEditUI.class);
    private static final Color lockColor = new Color(230, 230, 230);
    private static final BgConfigFieldComboxVal DISPLAY = new BgConfigFieldComboxVal("true", EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", (String)"display"));
    private static final BgConfigFieldComboxVal SHOWLIST = new BgConfigFieldComboxVal("list", EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", (String)"showlist"));
    private static final BgConfigFieldComboxVal SHOWEDIT = new BgConfigFieldComboxVal("edit", EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", (String)"showedit"));
    private static final BgConfigFieldComboxVal HIDE = new BgConfigFieldComboxVal("false", EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", (String)"hide"));
    private static final BgConfigFieldComboxVal HEAD = new BgConfigFieldComboxVal("true", EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", (String)"heard"));
    private static final BgConfigFieldComboxVal BODY = new BgConfigFieldComboxVal("false", EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", (String)"body"));
    private static final BgConfigFieldComboxVal lock = new BgConfigFieldComboxVal("lcok", EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", (String)"lock"));
    private static final BgConfigFieldComboxVal unlock = new BgConfigFieldComboxVal("unlock", EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", (String)"unlock"));
    private final String def_config = "com/kingdee/eas/ma/nbudget/config/budgetRequest-def.xml";
    private final String ext_config = "com/kingdee/eas/ma/nbudget/config/budgetRequest-ext.xml";
    private boolean isSwitchModel = false;
    private boolean isEditModel = false;
    private boolean isModify = false;

    public boolean isSwitchModel() {
        return this.isSwitchModel;
    }

    public void setSwitchModel(boolean isSwitchModel) {
        this.isSwitchModel = isSwitchModel;
    }

    public boolean isEditModel() {
        return this.isEditModel;
    }

    public void setEditModel(boolean isEditModel) {
        this.isEditModel = isEditModel;
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BudgetRequestConfigFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.getMainTable().getScriptManager().setScriptDisabled(true);
        this.getMainTable().getSelectManager().setSelectMode(2);
        this.getMainTable().setFormulaMode(1);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setSwitchModel(true);
        }
        if (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState())) {
            this.setEditModel(true);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.radioEdit.setSelected(true);
        }
        this.switchTableStyle();
        if (this.getUIWindow() instanceof KDFrame) {
            ((KDFrame)this.getUIWindow()).setExtendedState(6);
        }
    }

    public void initLayout() {
        super.initLayout();
        this.initCustomTableStyle();
    }

    protected void initCustomTableStyle() {
        this.getMainTable().checkParsed();
        this.getMainTable().getColumn("show").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        this.getMainTable().getColumn("show").setEditor(this.getDisplayEditor());
        this.getMainTable().getColumn("isHead").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        this.getMainTable().getColumn("isHead").getStyleAttributes().setHided(true);
        this.getMainTable().getColumn("isHead").setEditor(this.getHeadOrBodyEditor());
        this.getMainTable().getColumn("request").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        this.getMainTable().getColumn("edit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        this.getMainTable().getColumn("edit").setEditor(this.getEditEditor());
    }

    protected void initListener() {
        super.initListener();
        if (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState())) {
            this.getMainTable().addKDTEditListener(new KDTEditListener(){

                public void editValueChanged(KDTEditEvent e) {
                    BudgetRequestConfigEditUI.this.isModify = true;
                }

                public void editStopping(KDTEditEvent e) {
                }

                public void editStopped(KDTEditEvent e) {
                }

                public void editStarting(KDTEditEvent e) {
                    try {
                        BudgetRequestConfigEditUI.this.editStarting_actionPerformed(e);
                    }
                    catch (Exception ex) {
                        BudgetRequestConfigEditUI.this.handUIExceptionAndAbort(ex);
                    }
                }

                public void editStarted(KDTEditEvent e) {
                }

                public void editCanceled(KDTEditEvent e) {
                }
            });
            this.txtName.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    BudgetRequestConfigEditUI.this.isModify = true;
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }
            });
        }
    }

    protected void loadData() throws Exception {
        BudgetRequestConfigEnum ui;
        super.loadData();
        BudgetRequestConfigInfo configInfo = (BudgetRequestConfigInfo)this.editData;
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.parseConfigData();
        } else {
            this.fillData(configInfo);
        }
        if (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState())) {
            this.getMainTable().addKDTSelectListener(new KDTSelectListener(){

                public void tableSelectChanged(KDTSelectEvent e) {
                    try {
                        BudgetRequestConfigEditUI.this.tableSelectChanged_actionPerformed(e);
                    }
                    catch (Exception ex) {
                        BudgetRequestConfigEditUI.this.handUIExceptionAndAbort(ex);
                    }
                }
            });
        }
        if ((ui = configInfo.getUiType()).getValue() == 0) {
            this.radioList.setSelected(true);
            this.radioEdit.setSelected(false);
        } else {
            this.radioEdit.setSelected(true);
            this.radioList.setSelected(false);
        }
        if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState())) {
            this.radioList.setEnabled(false);
            this.radioEdit.setEnabled(false);
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.getMainTable().getStyleAttributes().setLocked(true);
            this.txtName.setEnabled(false);
        }
    }

    protected void parseConfigData() throws Exception {
        IBgBill bgBillInfo = null;
        IBgBill tmpBillInfo = null;
        try (InputStream xmlStream = null;){
            xmlStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/kingdee/eas/ma/nbudget/config/budgetRequest-def.xml");
            bgBillInfo = BgFields.getBgBillInfo(xmlStream, true, false);
            xmlStream.close();
            xmlStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/kingdee/eas/ma/nbudget/config/budgetRequest-ext.xml");
            tmpBillInfo = BgFields.getBgBillInfo(xmlStream, true, false);
            bgBillInfo.mergeBgBillInfo(tmpBillInfo);
        }
        this.fillData(bgBillInfo);
    }

    protected void fillData(BudgetRequestConfigInfo configInfo) throws Exception {
        if (configInfo == null) {
            return;
        }
        this.txtName.setText(configInfo.getName());
        this.fillData(configInfo.getBgBillInfo(true, false));
    }

    protected void fillData(IBgBill bgBillInfo) throws Exception {
        if (bgBillInfo == null) {
            return;
        }
        IBgField field = null;
        IRow row = null;
        List<IBgField> fields = bgBillInfo.getFields();
        if (fields != null && !fields.isEmpty()) {
            this.getMainTable().addRows(fields.size());
            this.getMainTable().getColumn("name").getStyleAttributes().setLocked(true);
            int in = fields.size();
            for (int i = 0; i < in; ++i) {
                field = fields.get(i);
                row = this.getMainTable().getRow(i);
                row.getCell("name").setValue((Object)field.getName());
                row.getCell("name").setUserObject((Object)field.getValue());
                row.getCell("show").setValue((Object)this.getDisplayType(field.getDisplayType()));
                row.getCell("isHead").setValue((Object)this.getHeadOrBody(field.isHead()));
                row.getCell("filter").setValue((Object)field.getInitValue().isFilter());
                row.getCell("order").setValue((Object)field.getInitValue().isOrder());
                if (!StringUtils.isEmpty((String)field.getDisplayName())) {
                    row.getCell("showName").setValue((Object)field.getDisplayName());
                } else {
                    row.getCell("showName").setValue((Object)field.getName());
                }
                row.getCell("request").setValue((Object)field.isRequest());
                row.getCell("edit").setValue((Object)this.getEdit(field.getInitValue().isEdit()));
                row.getCell("blankSpaces").setValue((Object)field.getBlankSpaces());
                row.getCell("totalRowNums").setValue((Object)field.getTotalRowNums());
                row.getCell("totalColNums").setValue((Object)field.getTotalColNums());
                if (!"string".equalsIgnoreCase(field.getType())) {
                    row.getCell("totalRowNums").getStyleAttributes().setLocked(true);
                    row.getCell("totalColNums").getStyleAttributes().setLocked(true);
                }
                if (field.isLock()) {
                    this.lockRow(row);
                }
                if (BgFields.FIELD_TYPE_OBJ.equals(field.getType())) {
                    if (field.getInitValue().getId() != null) {
                        DataBaseInfo baseInfo = (DataBaseInfo)Class.forName(field.getInitValue().getClassName()).newInstance();
                        baseInfo.setId(BOSUuid.read((String)field.getInitValue().getId()));
                        baseInfo.setName(field.getInitValue().getName());
                        baseInfo.setNumber(field.getInitValue().getNumber());
                        row.getCell("initValue").setValue((Object)baseInfo);
                    } else if (field.getInitValue().getDefValue() != null) {
                        if (field.getInitValue().getDefValue().equals(BgFields.ORGUNIT_CURRORGUNIT)) {
                            row.getCell("initValue").setValue((Object)new BgConfigFieldComboxVal(BgFields.ORGUNIT_CURRORGUNIT, EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", (String)BgFields.ORGUNIT_CURRORGUNIT)));
                        } else if (field.getInitValue().getDefValue().equals(BgFields.ORGUNIT_CURRCOMPANY)) {
                            row.getCell("initValue").setValue((Object)new BgConfigFieldComboxVal(BgFields.ORGUNIT_CURRCOMPANY, EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", (String)BgFields.ORGUNIT_CURRCOMPANY)));
                        } else if (field.getInitValue().getDefValue().equals(BgFields.ORGUNIT_CURRADMIN)) {
                            row.getCell("initValue").setValue((Object)new BgConfigFieldComboxVal(BgFields.ORGUNIT_CURRADMIN, EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", (String)BgFields.ORGUNIT_CURRADMIN)));
                        } else {
                            row.getCell("initValue").setValue((Object)field.getInitValue().getDefValue());
                        }
                    }
                } else if (BgFields.FIELD_TYPE_BGITEM.equals(field.getType())) {
                    if (field.getInitValue().getId() != null) {
                        String[] groupIds = field.getInitValue().getId().split(",");
                        String[] groupNames = field.getInitValue().getName().split(",");
                        String[] groupNumbers = field.getInitValue().getNumber().split(",");
                        String[] groupRefFields = field.getInitValue().getRefField().split(",");
                        Vector<String> vector = new Vector<String>();
                        if (groupIds != null) {
                            for (int j = 0; j < groupIds.length; ++j) {
                                String[] strs = groupIds[j].split(";");
                                String[] names = groupNames[j].split(";");
                                String[] numbers = groupNumbers[j].split(";");
                                String refField = groupRefFields[j];
                                BgItemGroupInfo groupInfo = null;
                                BgItemInfo itemInfo = null;
                                if (strs.length > 0) {
                                    groupInfo = new BgItemGroupInfo();
                                    groupInfo.setId(BOSUuid.read((String)strs[0]));
                                    groupInfo.setName(names[0]);
                                    groupInfo.setNumber(numbers[0]);
                                    groupInfo.setRefField(refField);
                                }
                                if (strs.length > 1) {
                                    itemInfo = new BgItemInfo();
                                    itemInfo.setId(BOSUuid.read((String)strs[1]));
                                    itemInfo.setName(names[1]);
                                    itemInfo.setNumber(numbers[1]);
                                }
                                String number = "";
                                if (groupInfo != null) {
                                    number = groupInfo.getNumber();
                                }
                                if (itemInfo != null) {
                                    number = number + ";" + itemInfo.getNumber();
                                }
                                vector.add(number);
                                vector.add((String)groupInfo);
                                if (itemInfo == null) continue;
                                vector.add((String)itemInfo);
                            }
                        }
                        row.getCell("initValue").setValue(vector);
                    }
                } else if (BgFields.FIELD_TYPE_ENUM.equals(field.getType())) {
                    if (field.getInitValue().getClassName() != null && field.getInitValue().getDefValue() != null) {
                        row.getCell("initValue").setValue((Object)(field.getInitValue().getClassName() + ";" + field.getInitValue().getDefValue()));
                    }
                } else if (BgFields.FIELD_TYPE_NUMBER.equals(field.getType())) {
                    if (!StringUtils.isEmpty((String)field.getInitValue().getExpression())) {
                        row.getCell("initValue").setValue((Object)field.getInitValue().getExpression());
                    } else {
                        row.getCell("initValue").setValue((Object)field.getInitValue().getDefValue());
                    }
                } else if (BgFields.FIELD_NUMBER_CODENUMBER.equals(field.getInitValue().getDefValue())) {
                    row.getCell("initValue").setValue((Object)new BgConfigFieldComboxVal(BgFields.FIELD_NUMBER_CODENUMBER, EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", (String)BgFields.FIELD_NUMBER_CODENUMBER)));
                } else {
                    row.getCell("initValue").setValue((Object)field.getInitValue().getDefValue());
                }
                row.setUserObject((Object)field);
            }
        }
    }

    private void lockRow(IRow row) {
        if (row == null) {
            return;
        }
        KDTColumn column = null;
        KDTColumns columns = this.getMainTable().getColumns();
        int in = columns.size();
        for (int i = 0; i < in; ++i) {
            column = columns.getColumn(i);
            if ("show".equals(column.getKey())) continue;
            row.getCell(column.getKey()).getStyleAttributes().setLocked(true);
        }
        row.getStyleAttributes().setBackground(lockColor);
    }

    private BgConfigFieldComboxVal getDisplayType(String showType) {
        BgConfigFieldComboxVal value = null;
        value = BgFields.showType_display_all.equals(showType) ? DISPLAY : (BgFields.showType_display_list.equals(showType) ? SHOWLIST : (BgFields.showType_display_edit.equals(showType) ? SHOWEDIT : HIDE));
        return value;
    }

    private BgConfigFieldComboxVal getEdit(boolean showType) {
        if (showType) {
            return unlock;
        }
        return lock;
    }

    private BgConfigFieldComboxVal getHeadOrBody(boolean showType) {
        if (showType) {
            return HEAD;
        }
        return BODY;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemMoveToBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.menuItemMoveToPrevious.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.menuItemMoveToNext.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.menuItemMoveToBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.btnMovePrevious.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveNext.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.enabledAction(this.btnPrint, this.menuItemPrint, (IItemAction)this.actionPrint);
        this.enabledAction(this.btnPrintPreview, this.menuItemPrintPreview, (IItemAction)this.actionPrintPreview);
    }

    protected void disableAction(KDWorkButton btnButton, KDMenuItem menuItem, IItemAction action) {
        this.setFunctionState((JButton)btnButton, (JMenuItem)menuItem, action, false);
    }

    protected void enabledAction(KDWorkButton btnButton, KDMenuItem menuItem, IItemAction action) {
        this.setFunctionState((JButton)btnButton, (JMenuItem)menuItem, action, true);
    }

    private void setFunctionState(JButton btnButton, JMenuItem menuItem, IItemAction action, boolean enabled) {
        if (btnButton != null) {
            btnButton.setEnabled(enabled);
        }
        if (menuItem != null) {
            menuItem.setEnabled(enabled);
        }
        if (action != null) {
            action.setEnabled(enabled);
        }
    }

    protected IObjectValue createNewData() {
        BudgetRequestConfigInfo info = new BudgetRequestConfigInfo();
        return info;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    protected void afterSubmitEdit(IObjectPK pk) {
        super.afterSubmitEdit(pk);
        this.isModify = false;
        this.radioEdit.setEnabled(false);
        this.radioList.setEnabled(false);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        String tmpStr;
        IBudgetRequestConfig config;
        super.verifyInput(e);
        if (OprtState.ADDNEW.equals(this.getOprtState()) && this.radioList.isSelected() && (config = (IBudgetRequestConfig)this.getBizInterface()) != null && config.isExistListConfig()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", "checkCommon"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)(tmpStr = this.txtName.getText()).trim())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", (String)"nameISEmpty"));
            SysUtil.abort();
        }
        IRow row = null;
        IBgField field = null;
        HashMap<String, String> refFieldSet = new HashMap<String, String>();
        HashMap<Object, IBgField> expressions = new HashMap<Object, IBgField>();
        HashSet<String> fields = new HashSet<String>();
        int rowCount = this.getMainTable().getRowCount3();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            String message;
            Object obj;
            row = this.getMainTable().getRow(rowIndex);
            field = (IBgField)row.getUserObject();
            if (BgFields.FIELD_TYPE_BGITEM.equals(field.getType())) {
                obj = row.getCell("initValue").getValue();
                if (obj instanceof Vector) {
                    Vector vector = (Vector)obj;
                    int jn = vector.size();
                    for (int j = 0; j < jn; ++j) {
                        obj = vector.get(j);
                        if (!(obj instanceof BgItemGroupInfo)) continue;
                        BgItemGroupInfo groupInfo = (BgItemGroupInfo)obj;
                        if (refFieldSet.containsKey(groupInfo.getRefField())) {
                            String message2 = MessageFormat.format(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", "checkGroup"), field.getName(), refFieldSet.get(groupInfo.getRefField()));
                            MsgBox.showWarning((Component)((Object)this), (String)message2);
                            SysUtil.abort();
                            continue;
                        }
                        refFieldSet.put(groupInfo.getRefField(), field.getName());
                    }
                }
            } else if (BgFields.FIELD_TYPE_NUMBER.equals(field.getType())) {
                obj = row.getCell("initValue").getValue();
                if (obj instanceof String && (tmpStr = (String)obj).startsWith("=")) {
                    expressions.put(obj, field);
                }
                fields.add(field.getName());
            }
            if (field.getBlankSpaces() != null && !field.getBlankSpaces().matches("[0-9]*")) {
                message = MessageFormat.format(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", "checkBlankSpaces"), field.getName());
                MsgBox.showWarning((Component)((Object)this), (String)message);
                SysUtil.abort();
            }
            if (field.getTotalRowNums() != null && !field.getTotalRowNums().matches("[0-9]*")) {
                message = MessageFormat.format(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", "checkTotalRowNums"), field.getName());
                MsgBox.showWarning((Component)((Object)this), (String)message);
                SysUtil.abort();
            }
            if (field.getTotalColNums() == null || field.getTotalColNums().matches("[0-3]")) continue;
            message = MessageFormat.format(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", "checkTotalColNums"), field.getName());
            MsgBox.showWarning((Component)((Object)this), (String)message);
            SysUtil.abort();
        }
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : expressions.entrySet()) {
            tmpStr = (String)entry2.getKey();
            field = (IBgField)entry2.getValue();
            this.checkExpression(tmpStr, field, fields);
        }
        IBgBill bgBill = this.getBgBillInfo();
        if (bgBill != null && !bgBill.getFields().isEmpty()) {
            int jn = bgBill.getFields().size();
            for (int j = 0; j < jn; ++j) {
                field = bgBill.getFields().get(j);
                if (field.getValue().equalsIgnoreCase("FConfigID") || !BgFields.showType_display_no.equals(field.getDisplayType()) && !BgFields.showType_display_list.equals(field.getDisplayType()) || !field.isRequest() || field.getInitValue().getDefValue() != null || field.getInitValue().getId() != null) continue;
                String message = MessageFormat.format(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", "checkDefValue"), field.getName());
                MsgBox.showWarning((Component)((Object)this), (String)message);
                SysUtil.abort();
            }
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        BudgetRequestConfigInfo configInfo = (BudgetRequestConfigInfo)this.editData;
        configInfo.setName(this.txtName.getText().trim());
        configInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        configInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        if (this.radioEdit.isSelected()) {
            configInfo.setUiType(BudgetRequestConfigEnum.BILL);
        } else {
            configInfo.setUiType(BudgetRequestConfigEnum.COMMON);
        }
        try {
            configInfo.setBgBillInfo(this.getBgBillInfo());
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    protected IBgBill getBgBillInfo() throws Exception {
        BgBillInfo bgBillInfo = new BgBillInfo();
        Object obj = null;
        IBgField field = null;
        IRow row = null;
        int in = this.getMainTable().getRowCount3();
        for (int i = 0; i < in; ++i) {
            row = this.getMainTable().getRow(i);
            field = (IBgField)row.getUserObject();
            obj = row.getCell("show").getValue();
            if (obj instanceof BgConfigFieldComboxVal) {
                field.setDisplayType(((BgConfigFieldComboxVal)obj).getKey().toString());
            } else {
                field.setDisplayType(BgFields.showType_display_no);
            }
            obj = row.getCell("isHead").getValue();
            if (obj instanceof BgConfigFieldComboxVal) {
                field.setHead(Boolean.valueOf(((BgConfigFieldComboxVal)obj).getKey().toString()));
            }
            if ((obj = row.getCell("showName").getValue()) != null) {
                field.setDisplayName(obj.toString());
            }
            if ((obj = row.getCell("blankSpaces").getValue()) != null) {
                field.setBlankSpaces(obj.toString());
            }
            if ((obj = row.getCell("totalRowNums").getValue()) != null) {
                field.setTotalRowNums(obj.toString());
            }
            if ((obj = row.getCell("totalColNums").getValue()) != null) {
                field.setTotalColNums(obj.toString());
            }
            obj = row.getCell("initValue").getValue();
            if (field.getType().equals(BgFields.FIELD_TYPE_OBJ)) {
                if (obj instanceof DataBaseInfo) {
                    DataBaseInfo database = (DataBaseInfo)obj;
                    field.getInitValue().setId(database.getId().toString());
                    field.getInitValue().setName(database.getName());
                    field.getInitValue().setNumber(database.getNumber());
                } else if (obj instanceof String) {
                    field.getInitValue().setDefValue(obj.toString());
                } else if (obj instanceof BgConfigFieldComboxVal) {
                    field.getInitValue().setDefValue(((BgConfigFieldComboxVal)obj).getKey());
                } else {
                    field.getInitValue().setId(null);
                    field.getInitValue().setName(null);
                    field.getInitValue().setNumber(null);
                    field.getInitValue().setDefValue(null);
                }
            } else if (field.getType().equals(BgFields.FIELD_TYPE_BGITEM)) {
                if (obj instanceof Vector) {
                    Vector vector = (Vector)obj;
                    String fieldId = "";
                    String fieldName = "";
                    String fieldNumber = "";
                    String fieldRefString = "";
                    int jn = vector.size();
                    for (int j = 0; j < jn; ++j) {
                        BgItemCollection colls;
                        obj = vector.get(j);
                        BgItemGroupInfo groupInfo = null;
                        BgItemInfo itemInfo = null;
                        if (obj instanceof BgItemGroupInfo) {
                            groupInfo = (BgItemGroupInfo)obj;
                        } else if (obj instanceof BgItemInfo) {
                            itemInfo = (BgItemInfo)obj;
                        } else if (obj instanceof BgItemCollection && !(colls = (BgItemCollection)obj).isEmpty()) {
                            itemInfo = colls.get(0);
                        }
                        if (groupInfo != null) {
                            fieldId = fieldId + "," + groupInfo.getId().toString();
                            fieldName = fieldName + "," + groupInfo.getName();
                            fieldNumber = fieldNumber + "," + groupInfo.getNumber();
                            fieldRefString = fieldRefString + "," + groupInfo.getRefField();
                        }
                        if (itemInfo == null) continue;
                        fieldId = fieldId + ";" + itemInfo.getId().toString();
                        fieldName = fieldName + ";" + itemInfo.getName();
                        fieldNumber = fieldNumber + ";" + itemInfo.getNumber();
                    }
                    field.getInitValue().setId(fieldId.substring(1));
                    field.getInitValue().setName(fieldName.substring(1));
                    field.getInitValue().setNumber(fieldNumber.substring(1));
                    field.getInitValue().setRefField(fieldRefString.substring(1));
                } else {
                    field.getInitValue().setId(null);
                    field.getInitValue().setName(null);
                    field.getInitValue().setNumber(null);
                    field.getInitValue().setDefValue(null);
                }
            } else if (field.getType().equals(BgFields.FIELD_TYPE_ENUM)) {
                if (obj != null) {
                    String[] str = obj.toString().split(";");
                    if (str != null && str.length > 1) {
                        field.getInitValue().setClassName(str[0]);
                        field.getInitValue().setDefValue(str[1]);
                    }
                } else {
                    field.getInitValue().setClassName(null);
                    field.getInitValue().setDefValue(null);
                }
            } else if (BgFields.FIELD_TYPE_NUMBER.equals(field.getType())) {
                if (obj != null) {
                    String tmpStr = obj.toString();
                    if (tmpStr.startsWith("=")) {
                        field.getInitValue().setExpression(tmpStr);
                    } else {
                        field.getInitValue().setDefValue(tmpStr);
                    }
                } else {
                    field.getInitValue().setDefValue(null);
                    field.getInitValue().setExpression(null);
                }
            } else if (obj != null) {
                if (obj instanceof BgConfigFieldComboxVal) {
                    field.getInitValue().setDefValue(((BgConfigFieldComboxVal)obj).getKey());
                } else {
                    field.getInitValue().setDefValue(obj.toString());
                }
            } else {
                field.getInitValue().setDefValue(null);
            }
            obj = row.getCell("request").getValue();
            if (obj instanceof Boolean) {
                field.setRequest((Boolean)obj);
            }
            if (lockColor.equals(row.getStyleAttributes().getBackground())) {
                field.setLock(true);
            } else {
                field.setLock(false);
            }
            obj = row.getCell("edit").getValue();
            if (lock.equals(obj)) {
                field.getInitValue().setEdit(false);
            } else {
                field.getInitValue().setEdit(true);
            }
            bgBillInfo.getFields().add(field);
        }
        return bgBillInfo;
    }

    @Override
    protected void radioEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.radioEdit.isSelected()) {
            this.switchTableStyle();
        }
    }

    @Override
    protected void radioList_actionPerformed(ActionEvent e) throws Exception {
        if (this.radioList.isEnabled()) {
            this.switchTableStyle();
        }
    }

    protected void switchTableStyle() throws Exception {
        if (this.radioList.isSelected()) {
            this.showListStyle();
        } else {
            this.showEditStyle();
        }
    }

    protected void showListStyle() {
        this.getMainTable().getColumn("width").getStyleAttributes().setHided(false);
        this.getMainTable().getColumn("initValue").getStyleAttributes().setHided(true);
        this.getMainTable().getColumn("request").getStyleAttributes().setHided(true);
    }

    protected void showEditStyle() {
        this.getMainTable().getColumn("width").getStyleAttributes().setHided(true);
        this.getMainTable().getColumn("initValue").getStyleAttributes().setHided(false);
        this.getMainTable().getColumn("request").getStyleAttributes().setHided(false);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.getMainTable().getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.getMainTable().getPrintManager().printPreview();
    }

    protected void tableSelectChanged_actionPerformed(KDTSelectEvent e) throws Exception {
        if (e.getSelectBlock() == null) {
            return;
        }
        int rowIndex = e.getSelectBlock().getBeginRow();
        int colIndex = e.getSelectBlock().getBeginCol();
        if (rowIndex < 0 || colIndex < 0) {
            return;
        }
        if (this.getMainTable().getColumn("initValue").getColumnIndex() == colIndex) {
            IRow row = this.getMainTable().getRow(rowIndex);
            IBgField field = (IBgField)row.getUserObject();
            ICellEditor editor = row.getCell("initValue").getEditor();
            if (editor == null) {
                if (BgFields.FIELD_TYPE_DATE.equals(field.getType()) || BgFields.FIELD_TYPE_TIME.equals(field.getType())) {
                    row.getCell("initValue").setEditor(this.getTimeDateEditor(true));
                } else if (BgFields.FIELD_TYPE_BGITEM.equals(field.getType())) {
                    row.getCell("initValue").setEditor(this.getBgItemEditor());
                } else if (BgFields.FIELD_TYPE_OBJ.equals(field.getType())) {
                    row.getCell("initValue").setEditor(this.getF7Editor(field.getInitValue().getQuery()));
                } else if (BgFields.FIELD_TYPE_NUMBER.equals(field.getType())) {
                    row.getCell("initValue").setEditor(this.getExpression(field.getInitValue().getExpression()));
                }
            }
        }
    }

    protected void editStarting_actionPerformed(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (rowIndex < 0 || colIndex < 0) {
            return;
        }
        if (this.getMainTable().getColumn("initValue").getColumnIndex() == colIndex) {
            KDBizPromptBox prmtSelect;
            ICellEditor editor;
            Object obj;
            IRow row = this.getMainTable().getRow(rowIndex);
            IBgField field = (IBgField)row.getUserObject();
            if (BgFields.FIELD_TYPE_DATE.equals(field.getType()) || BgFields.FIELD_TYPE_TIME.equals(field.getType())) {
                Object obj2 = row.getCell("initValue").getValue();
                if (obj2 != null) {
                    KDBizPromptBox prmtSelect2;
                    field.getInitValue().setDefValue(obj2.toString());
                    ICellEditor editor2 = row.getCell("initValue").getEditor();
                    if (editor2 != null && (prmtSelect2 = (KDBizPromptBox)editor2.getComponent()) != null) {
                        BudgetRequestConPeriodF7 f7 = (BudgetRequestConPeriodF7)prmtSelect2.getSelector();
                        f7.setField(field);
                    }
                }
            } else if (BgFields.FIELD_TYPE_NUMBER.equals(field.getType()) && (obj = row.getCell("initValue").getValue()) instanceof String && (editor = row.getCell("initValue").getEditor()) != null && (prmtSelect = (KDBizPromptBox)editor.getComponent()) != null) {
                BudgetRequestConfigExpressionF7 f7 = (BudgetRequestConfigExpressionF7)prmtSelect.getSelector();
                f7.setExpression(obj.toString());
            }
        }
    }

    protected ICellEditor getDisplayEditor() {
        KDComboBox box = new KDComboBox();
        box.addItems(new Object[]{DISPLAY, SHOWLIST, SHOWEDIT, HIDE});
        return new KDTDefaultCellEditor((JComboBox)box);
    }

    protected ICellEditor getHeadOrBodyEditor() {
        KDComboBox box = new KDComboBox();
        box.addItems(new Object[]{HEAD, BODY});
        return new KDTDefaultCellEditor((JComboBox)box);
    }

    protected ICellEditor getBgItemEditor() {
        NewBgItemForEnumDialog itemF7 = new NewBgItemForEnumDialog((IUIObject)this, true);
        itemF7.setMulSelect(false);
        itemF7.setSelectCombinItem(false);
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        prmtSelect.setSelector((KDPromptSelector)itemF7);
        prmtSelect.setEditable(false);
        prmtSelect.setEnabledMultiSelection(true);
        prmtSelect.setDisplayFormat("$name$");
        return new KDTDefaultCellEditor((IKDEditor)prmtSelect);
    }

    protected ICellEditor getExpression(String expression) {
        BudgetRequestConfigExpressionF7 f7 = new BudgetRequestConfigExpressionF7((IUIObject)this);
        f7.setExpression(expression);
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        prmtSelect.setSelector((KDPromptSelector)f7);
        return new KDTDefaultCellEditor((IKDEditor)prmtSelect);
    }

    protected ICellEditor getEditEditor() {
        KDComboBox box = new KDComboBox();
        box.addItems(new Object[]{lock, unlock});
        return new KDTDefaultCellEditor((JComboBox)box);
    }

    protected ICellEditor getTimeDateEditor(boolean isCanSelectApplyDate) throws Exception {
        BudgetRequestConPeriodF7 period = new BudgetRequestConPeriodF7((IUIObject)this);
        period.setCanSelectApplyDate(isCanSelectApplyDate);
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        prmtSelect.setSelector((KDPromptSelector)period);
        prmtSelect.setEditable(false);
        prmtSelect.setDisplayFormat("$name$");
        return new KDTDefaultCellEditor((IKDEditor)prmtSelect);
    }

    private ICellEditor getF7Editor(String queryInfo) {
        if (StringUtils.isEmpty((String)queryInfo)) {
            return null;
        }
        KDBizPromptBox prop = new KDBizPromptBox();
        prop.setQueryInfo(queryInfo);
        prop.setEditFormat("$number$");
        prop.setDisplayFormat("$name$");
        prop.setCommitFormat("$number$");
        if ("com.kingdee.eas.ma.budget.BgSchemeF7Query".equals(queryInfo)) {
            String orgUnitId = SysContext.getSysContext().getCurrentCostUnit().getId().toString();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
            view.setFilter(filter);
            prop.setEntityViewInfo(view);
        }
        return new KDTDefaultCellEditor((IKDEditor)prop);
    }

    protected void checkExpression(final String expressionStr, final IBgField field, final Set fields) throws Exception {
        if (StringUtils.isEmpty((String)expressionStr) || field == null || fields == null) {
            return;
        }
        Expression expression = null;
        try {
            expression = ExcelFormulaPaserHelper.parse((String)expressionStr);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        expression = ExcelFormulaPaserHelper.walk((Expression)expression, (IEditableExpressionHandler)new IEditableExpressionHandler(){

            public Expression handle(Expression expr) {
                return BudgetRequestConfigEditUI.this.checkExpression(expr, expressionStr, field, fields);
            }
        });
    }

    private Expression checkExpression(Expression expression, String expressionStr, IBgField field, Set fields) {
        if (expression instanceof BinaryOperationExpr) {
            expression = this.checkBinaryOperationExpr((BinaryOperationExpr)expression, expressionStr, field, fields);
        } else if (expression instanceof NameExpr) {
            expression = this.checkNameExpr((NameExpr)expression, expressionStr, field, fields);
        }
        return expression;
    }

    private Expression checkBinaryOperationExpr(BinaryOperationExpr boExpr, String expressionStr, IBgField field, Set fields) {
        boExpr.left = this.checkExpression(boExpr.left, expressionStr, field, fields);
        boExpr.right = this.checkExpression(boExpr.right, expressionStr, field, fields);
        return boExpr;
    }

    private Expression checkNameExpr(NameExpr nameExpr, String expressionStr, IBgField field, Set fields) {
        String message;
        if (nameExpr.name.equals(field.getName())) {
            message = MessageFormat.format(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", "checkExpression"), expressionStr, field.getName());
            MsgBox.showWarning((Component)((Object)this), (String)message);
            SysUtil.abort();
        }
        if (!fields.contains(nameExpr.name)) {
            message = MessageFormat.format(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.BudgetRequestConfigResource", "checkExpressionError"), expressionStr, nameExpr.name);
            MsgBox.showWarning((Component)((Object)this), (String)message);
            SysUtil.abort();
        }
        return nameExpr;
    }

    @Override
    public void actionMoveToTop_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveToTop_actionPerformed(e);
        int rowIndex = this.getMainTable().getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0) {
            this.isModify = true;
            this.getMainTable().moveRow(rowIndex, 0);
            this.getMainTable().getSelectManager().select(0, 0);
            this.getMainTable().scrollToVisible(0, 0);
        }
    }

    @Override
    public void actionMoveToPrevious_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveToPrevious_actionPerformed(e);
        int rowIndex = this.getMainTable().getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0) {
            this.isModify = true;
            int moveTo = rowIndex - 1;
            this.getMainTable().moveRow(rowIndex, rowIndex - 1);
            this.getMainTable().getSelectManager().select(moveTo, 0);
            this.getMainTable().scrollToVisible(moveTo, 0);
        }
    }

    @Override
    public void actionMoveToNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveToNext_actionPerformed(e);
        int rowIndex = this.getMainTable().getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0) {
            this.isModify = true;
            int moveTo = rowIndex + 1;
            this.getMainTable().moveRow(rowIndex, rowIndex + 1);
            this.getMainTable().getSelectManager().select(moveTo, 0);
            this.getMainTable().scrollToVisible(moveTo, 0);
        }
    }

    @Override
    public void actionMoveToBottom_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveToBottom_actionPerformed(e);
        int rowIndex = this.getMainTable().getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0) {
            this.isModify = true;
            int moveTo = this.getMainTable().getRowCount3() - 1;
            this.getMainTable().moveRow(rowIndex, moveTo);
            this.getMainTable().getSelectManager().select(moveTo, 0);
            this.getMainTable().scrollToVisible(moveTo, 0);
        }
    }

    public boolean isModify() {
        return this.isModify;
    }
}

