/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.ma.nbudget.client.IToolbarStrategy;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class BudgetToolbarStrategy
implements IToolbarStrategy {
    private static final Logger logger = CoreUIObject.getLogger(BudgetToolbarStrategy.class);
    private Object obj = null;
    private IBookProvider provider = null;
    private Set disableSet = new HashSet();
    private Set enabledSet = new HashSet();

    public BudgetToolbarStrategy(Object obj, IBookProvider provider) {
        this.setObj(obj);
        this.setProvider(provider);
    }

    @Override
    public void applyToolbarState(String state) {
        if (OprtState.ADDNEW.equalsIgnoreCase(state)) {
            this.addNew();
        } else if (OprtState.EDIT.equalsIgnoreCase(state)) {
            this.edit();
        } else if (OprtState.VIEW.equalsIgnoreCase(state)) {
            this.view();
        } else {
            this.common();
        }
        try {
            this.apply();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    public void setObj(Object obj) {
        this.obj = obj;
    }

    public Object getObj() {
        return this.obj;
    }

    protected void setProvider(IBookProvider provider) {
        this.provider = provider;
    }

    protected IBookProvider getProvider() {
        return this.provider;
    }

    public Set getDisableSet() {
        return this.disableSet;
    }

    public Set getEnabledSet() {
        return this.enabledSet;
    }

    protected void common() {
        this.disable("actionBgExamineCheck");
    }

    protected void addNew() {
        this.common();
    }

    protected void edit() {
        this.common();
    }

    protected void view() {
        this.common();
    }

    protected void disable(String key) {
        this.getDisableSet().add(key);
    }

    protected void enabled(String key) {
        this.getEnabledSet().add(key);
    }

    protected void apply() throws Exception {
        if (this.getObj() == null) {
            return;
        }
        Field _field2 = null;
        Field[] _fields = null;
        _fields = this.getObj().getClass().getFields();
        if (_fields != null) {
            for (Field _field2 : _fields) {
                this.enabled(_field2);
                this.disable(_field2);
            }
        }
    }

    private void disable(Field field) throws Exception {
        if (field != null && this.getDisableSet().contains(field.getName())) {
            Object _obj = field.get(this.getObj());
            this.setEnabled(_obj, false);
            this.setVisible(_obj, false);
        }
    }

    private void enabled(Field field) throws Exception {
        if (field != null && this.getEnabledSet().contains(field.getName())) {
            Object _obj = field.get(this.getObj());
            this.setEnabled(_obj, true);
            this.setVisible(_obj, true);
        }
    }

    private void setEnabled(Object obj, boolean value) throws Exception {
        Method _method = obj.getClass().getMethod("setEnabled", Boolean.class);
        if (_method != null) {
            _method.invoke(obj, value);
        }
    }

    private void setVisible(Object obj, boolean value) throws Exception {
        Method _method = obj.getClass().getMethod("setVisible", Boolean.class);
        if (_method != null) {
            _method.invoke(obj, value);
        }
    }
}

