/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.excel.impl.icons.ResourceManager;
import com.kingdee.bos.ctrl.excel.io.kds.BookToKDSBook;
import com.kingdee.bos.ctrl.excel.io.kds.KDSBookToBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.export.POIExportException;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.util.printout.PrintableBook;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.newrpt.DesignerResource;
import com.kingdee.eas.fi.newrpt.SpreadHelper;
import com.kingdee.eas.fi.newrpt.client.designer.io.WizzardIO;
import com.kingdee.eas.fi.newrpt.designer.comment.CommentUtil;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.IEnumrateImportConstans;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.eas.util.encryptalgorithm.Base64;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class EnumerateImportWizzard
extends KDDialog
implements ISpreadWizzard,
IEnumrateImportConstans {
    private static final long serialVersionUID = -2909188119082545615L;
    private final SimpleFileFilter Filter_PDF = new SimpleFileFilter("pdf", "pdf" + this.getLocalText("Key_File"));
    private final SimpleFileFilter Filter_HTML = new SimpleFileFilter(new String[]{"htm", "html"}, this.getLocalText("Key_Page"));
    private final SimpleFileFilter Filter_Excel = new SimpleFileFilter("xls", "MS Excel" + this.getLocalText("Key_File"));
    private final SimpleFileFilter Filter_KDF = new SimpleFileFilter("kdf", "KDTable" + this.getLocalText("Key_File"));
    private final SimpleFileFilter Filter_XML = new SimpleFileFilter("xml", "xml" + this.getLocalText("Key_Table"));
    protected KDLabel _lbFile;
    protected KDTextField _tfFile;
    protected KDButton _btnFile;
    protected KDLabel _lbImportMode;
    protected KDComboBox _cbImportMode;
    protected KDButton _btnSelAll;
    protected KDButton _btnUnSelAll;
    protected ImportOptionPanel _pnlIm;
    protected ExportOptionPanel _pnlEx;
    protected SheetListPanel _pnlSheet;
    protected KDButton _btnOk;
    protected KDButton _btnCancel;
    protected SpreadContext _context;
    protected KDFileChooser _chsFile;
    protected boolean _isForImport;

    public EnumerateImportWizzard(Dialog parent, SpreadContext context) {
        super(parent, true);
        this.initSpreadContext(context);
        this.initDialog();
        this.initComps();
        this.initPanel();
        this.setLocationRelativeTo(parent);
    }

    public EnumerateImportWizzard(Frame parent, SpreadContext context) {
        super(parent, true);
        this.initSpreadContext(context);
        this.initDialog();
        this.initComps();
        this.initPanel();
        this.setLocationRelativeTo(parent);
    }

    protected void initSpreadContext(SpreadContext context) {
        this._context = context;
    }

    protected void initDialog() {
        this.setSize(500, 300);
        this.setResizable(false);
        this._chsFile = this.createFileChooser();
        this.setSize(500, 300);
        this.setResizable(false);
        this._chsFile = this.createFileChooser();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                EnumerateImportWizzard.this._pnlSheet.setData(null);
            }
        });
    }

    protected void initComps() {
        this._lbFile = new KDLabel(this.getLocalText("Key_File"));
        this._tfFile = new KDTextField();
        this._tfFile.setEditable(false);
        this._btnFile = new KDButton(this.getLocalText("Key_Scan"));
        this._btnFile.addActionListener((ActionListener)new ChooseFileAction());
        this._lbImportMode = new KDLabel(this.getLocalText("Key_ImportMode"));
        this._cbImportMode = new KDComboBox((Object[])new String[]{this.getLocalText("Key_ImportMode_Override"), this.getLocalText("Key_ImportMode_Append")});
        this._cbImportMode.setEditable(false);
        this._btnSelAll = new KDButton();
        this._btnSelAll.setIcon((Icon)ResourceManager.getImageIcon((String)"tbtn_SelectAll.gif"));
        this._btnSelAll.setBorder(null);
        this._btnSelAll.setLimitedSize(false);
        this._btnSelAll.setToolTipText(this.getLocalText("Key_SelectAllSheets"));
        this._btnSelAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnumerateImportWizzard.this._pnlSheet.setAllSelected(true);
            }
        });
        this._btnUnSelAll = new KDButton();
        this._btnUnSelAll.setIcon((Icon)ResourceManager.getImageIcon((String)"tbtn_deleteall.gif"));
        this._btnUnSelAll.setBorder(null);
        this._btnUnSelAll.setLimitedSize(false);
        this._btnUnSelAll.setToolTipText(this.getLocalText("Key_UnSelectAllSheets"));
        this._btnUnSelAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnumerateImportWizzard.this._pnlSheet.setAllSelected(false);
            }
        });
        this._pnlIm = new ImportOptionPanel();
        this._pnlEx = new ExportOptionPanel();
        this._pnlSheet = new SheetListPanel();
        this._btnOk = new KDButton(this.getLocalText("Key_Ok"));
        this._btnOk.addActionListener((ActionListener)new FinishAction());
        this.getRootPane().setDefaultButton((JButton)this._btnOk);
        this._btnCancel = new KDButton(this.getLocalText("Key_Cancel"));
        this._btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnumerateImportWizzard.this.closeDialog();
            }
        });
    }

    protected void initPanel() {
        Container cp = this.getContentPane();
        cp.setLayout(null);
        cp.add((Component)this._lbFile);
        cp.add((Component)this._tfFile);
        cp.add((Component)this._btnFile);
        this._lbFile.setBounds(10, 10, 460, 20);
        this._tfFile.setBounds(10, 35, 370, 20);
        this._btnFile.setBounds(390, 35, 80, 20);
        cp.add((Component)this._lbImportMode);
        cp.add((Component)this._cbImportMode);
        cp.add((Component)this._btnSelAll);
        cp.add((Component)this._btnUnSelAll);
        this._lbImportMode.setBounds(10, 65, 100, 20);
        this._cbImportMode.setBounds(120, 65, 100, 20);
        this._btnSelAll.setBounds(425, 65, 20, 20);
        this._btnUnSelAll.setBounds(450, 65, 20, 20);
        cp.add((Component)((Object)this._pnlIm));
        cp.add((Component)((Object)this._pnlEx));
        cp.add((Component)((Object)this._pnlSheet));
        this._pnlIm.setLocation(10, 90);
        this._pnlEx.setLocation(10, 90);
        this._pnlSheet.setLocation(240, 90);
        cp.add((Component)this._btnOk);
        cp.add((Component)this._btnCancel);
        this._btnOk.setBounds(300, 250, 80, 20);
        this._btnCancel.setBounds(390, 250, 80, 20);
    }

    protected void closeDialog() {
        this._tfFile.setText("");
        this.setVisible(false);
        this.dispose();
        this._context.requestFocus();
    }

    protected String getLocalText(String key) {
        return LanguageManager.getLangMessage((String)key, WizzardIO.class, (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"23_WizzardIO"));
    }

    protected KDFileChooser createFileChooser() {
        KDFileChooser chsFile = new KDFileChooser();
        chsFile.setDialogTitle(this.getLocalText("Key_File"));
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_XML);
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_Excel);
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_KDF);
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_PDF);
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_HTML);
        chsFile.setFileFilter((FileFilter)this.Filter_XML);
        return chsFile;
    }

    public void setForImport(boolean b) {
        this._isForImport = b;
    }

    public boolean prepare() {
        this.setTitle(this.getLocalText(this._isForImport ? "Key_ImportFile" : "Key_ExportFile"));
        this._pnlIm.setVisible(this._isForImport);
        this._pnlEx.setVisible(!this._isForImport);
        this._lbImportMode.setVisible(this._isForImport);
        this._cbImportMode.setVisible(this._isForImport);
        if (this._isForImport) {
            FileFilter ff = this._chsFile.getFileFilter();
            this._chsFile.removeChoosableFileFilter((FileFilter)this.Filter_PDF);
            this._chsFile.removeChoosableFileFilter((FileFilter)this.Filter_HTML);
            this._chsFile.addChoosableFileFilter((FileFilter)this.Filter_KDF);
            if (ff != this.Filter_PDF && ff != this.Filter_HTML) {
                this._chsFile.setFileFilter(ff);
            } else {
                this._chsFile.setFileFilter((FileFilter)this.Filter_XML);
            }
            this._pnlSheet.setData(null);
        } else {
            FileFilter ff = this._chsFile.getFileFilter();
            this._chsFile.removeChoosableFileFilter((FileFilter)this.Filter_KDF);
            this._chsFile.addChoosableFileFilter((FileFilter)this.Filter_PDF);
            this._chsFile.addChoosableFileFilter((FileFilter)this.Filter_HTML);
            if (ff != this.Filter_KDF) {
                this._chsFile.setFileFilter(ff);
            } else {
                this._chsFile.setFileFilter((FileFilter)this.Filter_XML);
            }
            this._pnlSheet.setData(this._context.getBook());
        }
        return true;
    }

    public void commit() {
    }

    protected void openSheetList() {
        String fileName = this._tfFile.getText();
        FileFilter filter = this._chsFile.getFileFilter();
        SimpleFileFilter sff = null;
        if (filter instanceof SimpleFileFilter) {
            sff = (SimpleFileFilter)filter;
        }
        if (StringUtils.isEmpty((String)fileName)) {
            return;
        }
        if (this.acceptExtension(sff, fileName, "xls")) {
            this._pnlSheet.setData(this.openSheetListFromXls(fileName));
        } else if (this.acceptExtension(sff, fileName, "pdf")) {
            WindowUtil.msgboxError((Object)this.getLocalText("Key_UnsupportedFileFormat"), (String)this.getLocalText("Key_UnsupportedFileFormat"), (Component)this._context);
        } else if (this.acceptExtension(sff, fileName, "htm") || this.acceptExtension(sff, fileName, "html")) {
            WindowUtil.msgboxError((Object)this.getLocalText("Key_UnsupportedFileFormat"), (String)this.getLocalText("Key_UnsupportedFileFormat"), (Component)this._context);
        } else {
            this._pnlSheet.setData(this.openSheetListFromXml(fileName));
        }
    }

    protected Book openSheetListFromXml(String fileName) {
        try {
            return IOHelper.loadFile((String)fileName);
        }
        catch (Exception e) {
            WindowUtil.msgboxError((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"24_WizzardIO"), (String)this.getLocalText("Key_ErrorOnOpenFile"), (Component)this._context);
        }
        catch (Throwable e1) {
            WindowUtil.msgboxError((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"24_WizzardIO"), (String)this.getLocalText("Key_ErrorOnOpenFile"), (Component)this._context);
        }
        return null;
    }

    protected Book openSheetListFromXls(String fileName) {
        KDSBook kdsbook = null;
        try {
            kdsbook = POIXlsReader.parse2((String)fileName);
        }
        catch (FileNotFoundException e) {
            WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnOpenFile"), (Component)this._context);
            return null;
        }
        catch (IOException e) {
            WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnOpenFile"), (Component)this._context);
            return null;
        }
        catch (Exception e) {
            WindowUtil.msgboxError((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"25_WizzardIO"), (String)this.getLocalText("Key_ErrorOnOpenFile"), (Component)this._context);
            return null;
        }
        if (kdsbook != null) {
            return KDSBookToBook.traslate((KDSBook)kdsbook);
        }
        String str = this.getLocalText("Key_UnsupportedFileFormat");
        WindowUtil.msgboxError((Object)str, (String)str, (Component)this._context);
        return null;
    }

    protected void transBook() throws Exception {
        if (this._pnlSheet._book == null) {
            String str = this.getLocalText("Key_NeedOpenFile");
            WindowUtil.msgboxError((Object)str, (String)str, (Component)this._context);
            return;
        }
        if (this._cbImportMode.getSelectedIndex() == 0) {
            if (this._pnlSheet.getSelectedSheets().length == 0) {
                return;
            }
            this.overWriteImport();
        } else {
            int cellDisplayMode = this._context.getBook().getActiveSheet().getSheetOption().getCellDisplayMode();
            String[] sns = this._pnlSheet.getSelectedSheets();
            if (sns.length > 0) {
                int i;
                BookProperties bpSrc = BookProperties.loadFromBook((Book)this._pnlSheet._book);
                for (int i2 = 0; i2 < this._pnlSheet._book.getSheetCount(); ++i2) {
                    String name = this._pnlSheet._book.getSheet(i2).getSheetName();
                    boolean selected = false;
                    for (int j = 0; j < sns.length; ++j) {
                        if (!name.equals(sns[j])) continue;
                        selected = true;
                        break;
                    }
                    if (selected) continue;
                    bpSrc.notifyDeleteSheet(name);
                }
                Book book = this._context.getBook();
                BookProperties bpDest = BookProperties.loadFromBook((Book)book);
                byte[] data = bpDest.toByteData();
                boolean b = book.getUndoManager().isEnable();
                book.getUndoManager().discardAllEdits();
                book.getUndoManager().enable(false);
                book.startGroup();
                HashSet<String> names = new HashSet<String>(sns.length);
                for (i = 0; i < this._pnlSheet._book.getSheetCount(); ++i) {
                    String name = this._pnlSheet._book.getSheet(i).getSheetName();
                    names.add(name);
                }
                for (i = 0; i < sns.length; ++i) {
                    String srcName = sns[i];
                    Sheet sheet = this._pnlSheet._book.getSheet(sns[i]);
                    sheet.getSheetOption().setCellDisplayMode(cellDisplayMode);
                    String destName = this.getSheetName(srcName, book);
                    if (!srcName.equals(destName)) {
                        sheet.setName(destName);
                        bpSrc.notifyRenameSheet(srcName, destName);
                    }
                    book.addSheet(sheet, false);
                    this.croppSheet(sheet);
                    sheet.updateUnknownMethod(book.getDeps().getUnknownMethodManager());
                }
                for (i = 0; i < sns.length; ++i) {
                    if (names.contains(sns[i])) continue;
                    bpSrc.notifyDeleteSheet(sns[i]);
                }
                bpDest = bpDest.loadFromByteData(data);
                bpDest.merge(bpSrc);
                bpDest.restoreToBook(book);
                book.endGroup();
                book.getUndoManager().enable(b);
            }
        }
        this._context.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EnumerateImportWizzard.this._context.requestFocus();
            }
        });
        if (this._chsFile.getFileFilter().equals(this.Filter_XML)) {
            this._context.getBook().setUserObject("isFromXMLImport", (Object)Boolean.TRUE);
        }
        MsgBox.showInfo((Component)((Object)this), (String)RptUtil.getReportResource((String)"report_import_success"));
    }

    protected String getSheetName(String name, Book book) {
        String src = name;
        int count = 1;
        while (book.getSheet(src) != null) {
            src = name + "(" + count + ")";
            ++count;
        }
        return src;
    }

    protected void croppSheet(Sheet sheet) {
        int option = this._pnlIm.getImportOption();
        if (option == 0) {
            return;
        }
        Sheet.ICellsIterator it = sheet.getCellsIterator(null, false, false);
        while (it.hasNext()) {
            Cell cell = it.next();
            String formula = cell.getFormula();
            if (formula == null || formula.length() <= 0 || formula.charAt(0) != '=') continue;
            if (option == 2) {
                cell.setValue(Variant.nullVariant);
                cell.setFormula(formula);
                continue;
            }
            if (option != 1) continue;
            Variant value = cell.getValue();
            cell.setFormula(null);
            cell.setValue(value);
        }
    }

    private void filterSheets() {
        int i;
        String[] sheets = this._pnlSheet.getSelectedSheets();
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < sheets.length; ++i2) {
            list.add(sheets[i2]);
        }
        ArrayList<String> list2 = new ArrayList<String>();
        for (i = 0; i < this._pnlSheet._book.getSheetCount(); ++i) {
            if (list.contains(this._pnlSheet._book.getSheet(i).getSheetName())) continue;
            list2.add(this._pnlSheet._book.getSheet(i).getSheetName());
        }
        for (i = 0; i < list2.size(); ++i) {
            this._pnlSheet._book.removeSheet((String)list2.get(i));
        }
    }

    private boolean saveToFile() {
        String fileName = this._tfFile.getText();
        FileFilter filter = this._chsFile.getFileFilter();
        if (fileName == null || fileName.trim().length() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.client.designer.DesignerResource", (String)"Select_File_First"));
            return false;
        }
        SimpleFileFilter sff = null;
        if (filter instanceof SimpleFileFilter) {
            sff = (SimpleFileFilter)filter;
        }
        boolean is_success = false;
        is_success = this.acceptExtension(sff, fileName = this.addExtension2(fileName, sff), "xls") ? this.exportToXls(fileName) : (this.acceptExtension(sff, fileName, "pdf") ? this.exportToPdf(fileName) : (this.acceptExtension(sff, fileName, "html") ? this.exportToHtml(fileName) : this.exportToXml(fileName)));
        if (is_success) {
            MsgBox.showInfo((Component)((Object)this), (String)RptUtil.getReportResource((String)"report_export_success"));
        }
        return true;
    }

    private String addExtension2(String fileName, SimpleFileFilter sff) {
        if (sff == null) {
            return fileName;
        }
        fileName = this.acceptExtension(sff, fileName, "xls") ? this.addExtension(fileName, "xls") : (this.acceptExtension(sff, fileName, "pdf") ? this.addExtension(fileName, "pdf") : (this.acceptExtension(sff, fileName, "html") ? this.addExtension(fileName, "html") : (this.acceptExtension(sff, fileName, "kdf") ? this.addExtension(fileName, "kdf") : this.addExtension(fileName, "xml"))));
        return fileName;
    }

    private boolean acceptExtension(SimpleFileFilter sff, String fileName, String extension) {
        if (sff != null) {
            return sff.acceptExtension(extension);
        }
        return fileName.toLowerCase(Locale.ENGLISH).endsWith(extension.toLowerCase(Locale.ENGLISH));
    }

    private boolean exportToHtml(String fileName) {
        String[] sns = this._pnlSheet.getSelectedSheets();
        if (sns.length == 0) {
            WindowUtil.msgboxError((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"26_WizzardIO"), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
            return false;
        }
        KDSBook kdsbook = BookToKDSBook.traslate((Book)this._pnlSheet._book, (String[])sns);
        PrintableBook prtbook = new PrintableBook(kdsbook);
        try {
            new ExportManager().exportToHtmlFile(prtbook, fileName);
            return true;
        }
        catch (Exception e) {
            WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
            return false;
        }
    }

    private boolean exportToPdf(String fileName) {
        String[] sns = this._pnlSheet.getSelectedSheets();
        if (sns.length == 0) {
            WindowUtil.msgboxError((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"26_WizzardIO"), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
            return false;
        }
        KDSBook kdsbook = BookToKDSBook.traslate((Book)this._pnlSheet._book, (String[])sns);
        PrintableBook prtbook = new PrintableBook(kdsbook);
        new ExportManager().exportToPdfFile(prtbook, fileName);
        return true;
    }

    private boolean exportToXls(String fileName) {
        String[] sns = this._pnlSheet.getSelectedSheets();
        if (sns.length == 0) {
            WindowUtil.msgboxError((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"26_WizzardIO"), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
            return false;
        }
        Book tempBook = this._pnlSheet._book;
        boolean isConfirm = false;
        for (int i = 0; i < sns.length; ++i) {
            Sheet sheet = tempBook.getSheet(sns[i]);
            if (sheet.getMaxColIndex() <= 255 && sheet.getMaxRowIndex() <= 65535) continue;
            if (!isConfirm) {
                int confirm = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource", (String)"excel255_65535"));
                if (confirm != 0) {
                    return false;
                }
                isConfirm = true;
            }
            try {
                if (tempBook == this._pnlSheet._book) {
                    tempBook = SpreadHelper.copyBook((Book)this._pnlSheet._book);
                    sheet = tempBook.getSheet(sns[i]);
                }
                if (sheet.getMaxColIndex() > 255) {
                    sheet.getColRange(256, sheet.getMaxColIndex()).delete();
                }
                if (sheet.getMaxRowIndex() <= 65535) continue;
                sheet.getRowRange(65536, sheet.getMaxRowIndex()).delete();
                continue;
            }
            catch (Exception e) {
                WindowUtil.msgboxError((Object)e.getCause().getMessage(), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
                return false;
            }
        }
        KDSBook kdsbook = BookToKDSBook.traslate((Book)tempBook, (String[])sns);
        ExportManager em = new ExportManager();
        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"TRUE");
        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"FALSE");
        if (this._pnlEx._rbValueAndExcelFormula.isSelected()) {
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
        } else if (this._pnlEx._rbValueAndFormula.isSelected()) {
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
        } else {
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
        }
        try {
            em.exportToExcel(kdsbook, fileName);
            return true;
        }
        catch (POIExportException poie) {
            WindowUtil.msgboxError((Object)poie.getCause().getMessage(), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
            return false;
        }
        catch (Exception e) {
            WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
            return false;
        }
    }

    private boolean exportToXml(String fileName) {
        try {
            IOHelper.saveToFile((Book)this._pnlSheet._book, (String)fileName, (String[])this._pnlSheet.getSelectedSheets());
            return true;
        }
        catch (FileNotFoundException e) {
            WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
        }
        catch (IOException e) {
            WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
        }
        return false;
    }

    private String addExtension(String fileName, String extension) {
        if (fileName.toLowerCase(Locale.ENGLISH).endsWith(extension.toLowerCase(Locale.ENGLISH))) {
            return fileName;
        }
        return fileName + "." + extension;
    }

    protected void overWriteImport() {
        String[] sns = this._pnlSheet.getSelectedSheets();
        Book book = this._context.getBook();
        if (book.getProtection().isProtected()) {
            MsgBox.showWarning((Component)this._context, (String)DesignerResource.getString((String)"protectedBook"));
            SysUtil.abort();
        }
        boolean b = book.getUndoManager().isEnable();
        book.getUndoManager().discardAllEdits();
        book.getUndoManager().enable(false);
        book.startGroup();
        int cellDisplayMode = this._context.getBook().getActiveSheet().getSheetOption().getCellDisplayMode();
        LinkedList<String> snsNameList = new LinkedList<String>();
        for (int i = 0; i < sns.length; ++i) {
            snsNameList.add(sns[i]);
        }
        Map currEnum = this.getBookEnumerate(this._context.getBook());
        Map importEnum = this.getBookEnumerate(this.getPnlSheetBook());
        Map sheetInfo = this.getBookUserObject(this.getPnlSheetBook(), "SHEET_INFO_IMPORT");
        int count = book.getSheetCount();
        ArrayList<String> deleteSheetNameList = new ArrayList<String>();
        block1: for (int i = 0; i < count; ++i) {
            Sheet sheet = book.getSheet(i);
            boolean isExistSheet = false;
            for (String sheetName : snsNameList) {
                if (!sheetName.equalsIgnoreCase(sheet.getSheetName())) continue;
                isExistSheet = true;
                break;
            }
            if (!isExistSheet && !sheet.getSheetOption().getProtection(true).isProtected()) {
                deleteSheetNameList.add(sheet.getSheetName());
                continue;
            }
            if (sheet.getSheetOption().getProtection(true).isProtected()) {
                if (this.hasLockedCell(sheet)) {
                    if (!isExistSheet) continue;
                    this.overWriterImportWithProtection(sheet, this._pnlSheet._book.getSheet(sheet.getSheetName()));
                    Iterator iterator = snsNameList.iterator();
                    while (iterator.hasNext()) {
                        String sheetName;
                        sheetName = (String)iterator.next();
                        if (!sheetName.equalsIgnoreCase(sheet.getSheetName())) continue;
                        iterator.remove();
                        continue block1;
                    }
                    continue;
                }
                deleteSheetNameList.add(sheet.getSheetName());
                continue;
            }
            deleteSheetNameList.add(sheet.getSheetName());
        }
        String[] ids = new String[deleteSheetNameList.size()];
        int index = 0;
        for (String sheetName : deleteSheetNameList) {
            ids[index++] = book.getSheet(sheetName).getID();
            currEnum.remove(ids[index - 1]);
            book.removeSheet(sheetName);
        }
        index = 0;
        int i = 0;
        for (String sheetName : snsNameList) {
            Object map;
            Sheet sheet = this._pnlSheet._book.getSheet(sheetName);
            sheet.getSheetOption().setCellDisplayMode(cellDisplayMode);
            if (i == 0) {
                book.addSheet(sheet, true);
            } else {
                book.addSheet(sheet, false);
            }
            if (index < ids.length) {
                sheet.setID(ids[index++]);
            }
            this.croppSheet(sheet);
            Map subSheet = (Map)sheetInfo.get(sheetName);
            if (subSheet != null && !subSheet.isEmpty() && (map = importEnum.get(subSheet.get("SHEET_NAME_ID"))) != null) {
                currEnum.put(sheet.getID(), map);
                String id2 = null;
                Integer num = null;
                Map id_num = (Map)subSheet.get("SHEET_ROW_IDS");
                if (id_num != null) {
                    for (String id2 : id_num.keySet()) {
                        num = (Integer)id_num.get(id2);
                        BgNFSHelper.setRowSign(sheet.getRow(num.intValue(), true), id2);
                    }
                }
                if ((id_num = (Map)subSheet.get("SHEET_COL_IDS")) != null) {
                    for (String id2 : id_num.keySet()) {
                        num = (Integer)id_num.get(id2);
                        BgNFSHelper.setColSign(sheet.getColumn(num.intValue(), true), id2);
                    }
                }
            }
            sheet.updateUnknownMethod(book.getDeps().getUnknownMethodManager());
            ++i;
        }
        BookProperties bp = BookProperties.loadFromBook((Book)this._pnlSheet._book);
        bp.restoreToBook(this._context.getBook());
        book.endGroup();
        book.getUndoManager().enable(b);
        this.setBookEnumerate(this._context.getBook(), currEnum);
    }

    private boolean hasLockedCell(Sheet sheet) {
        if (!sheet.getSheetOption().getProtection(true).isProtected()) {
            return false;
        }
        Sheet.ICellsIterator iterator = sheet.getCellsIterator(sheet.getSheetRange().getBlock(0), false, false);
        while (iterator.hasNext()) {
            Cell cell = iterator.next();
            if (!cell.isLocked()) continue;
            return true;
        }
        return false;
    }

    protected void overWriterImportWithProtection(Sheet sourceSheet, Sheet targetSheet) {
        int targetRowIndex = targetSheet.getMaxRowIndex();
        int targetColIndex = targetSheet.getMaxColIndex();
        int sourceRowIndex = sourceSheet.getMaxRowIndex();
        int sourceColIndex = sourceSheet.getMaxColIndex();
        int rowCount = Math.max(targetRowIndex, sourceRowIndex);
        int colCount = Math.max(targetColIndex, sourceColIndex);
        int option = this._pnlIm.getImportOption();
        for (int row = 0; row <= rowCount; ++row) {
            for (int col = 0; col <= colCount; ++col) {
                Cell targetCell = targetSheet.getCell(row, col, true);
                Cell sourceCell = sourceSheet.getCell(row, col, true);
                if (sourceCell.isLocked()) continue;
                if (option == 2) {
                    sourceCell.setValue(Variant.nullVariant);
                    sourceCell.setFormula(targetCell.getFormula());
                } else if (option == 1) {
                    sourceCell.setFormula(null);
                    sourceCell.setValue(targetCell.getValue());
                } else {
                    sourceCell.setValue(targetCell.getValue());
                    sourceCell.setFormula(targetCell.getFormula());
                }
                sourceCell.setComment((Comment)CommentUtil.getReportComment((Cell)targetCell));
                if (!targetCell.isLocked()) continue;
                StyleAttributes sa = Styles.getEmptySA();
                sa.setLocked(true);
                sourceSheet.getRange(sourceCell).setStyle(sa, Styles.getEmptySA());
            }
        }
        if (targetSheet.getUserObjects() != null && targetSheet.getUserObjects().size() > 0) {
            if (sourceSheet.getUserObjects() != null) {
                sourceSheet.getUserObjects().clear();
            }
            for (int i = 0; i < targetSheet.getUserObjects().size(); ++i) {
                sourceSheet.setUserObject(targetSheet.getUserObjects().getUserObject(i).getKey(), targetSheet.getUserObjects().getUserObject(i).getValue());
            }
        } else if (sourceSheet.getUserObjects() != null) {
            sourceSheet.getUserObjects().clear();
        }
    }

    public Book getPnlSheetBook() {
        return this._pnlSheet._book;
    }

    protected Map getBookEnumerate(Book book) {
        return this.getBookUserObject(book, "EnumerAteArea");
    }

    protected Map getBookUserObject(Book book, String key) {
        if (book != null && book.getUserObjectValue(key) instanceof String) {
            return (Map)BgAnalyseHelper.getObject((byte[])Base64.decode((String)((String)book.getUserObjectValue(key))));
        }
        return new HashMap();
    }

    protected void setBookEnumerate(Book book, Map enumArea) {
        if (book != null) {
            if (enumArea == null || enumArea.isEmpty()) {
                book.removeUserObject("EnumerAteArea");
            } else {
                String enumStr = Base64.encodeBytes((byte[])BgAnalyseHelper.getBytes((Object)enumArea));
                book.setUserObject("EnumerAteArea", (Object)enumStr);
            }
        }
    }

    protected class FinishAction
    extends AbstractAction {
        protected FinishAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EnumerateImportWizzard.this._isForImport) {
                try {
                    EnumerateImportWizzard.this.transBook();
                }
                catch (Exception ed) {
                    ExceptionHandler.handle((Component)((Object)EnumerateImportWizzard.this), (Throwable)ed);
                }
            } else {
                boolean isDeployed = EnumerateImportWizzard.this.saveToFile();
                if (!isDeployed) {
                    return;
                }
            }
            EnumerateImportWizzard.this.closeDialog();
        }
    }

    protected class ChooseFileAction
    extends AbstractAction {
        protected ChooseFileAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int ret;
            String fileName;
            block11: {
                fileName = "";
                ret = 0;
                while ((ret = EnumerateImportWizzard.this._chsFile.showOpenDialog((Component)((Object)EnumerateImportWizzard.this))) == 0) {
                    String name;
                    File file = EnumerateImportWizzard.this._chsFile.getSelectedFile();
                    fileName = file.getAbsolutePath();
                    SimpleFileFilter sff = null;
                    FileFilter fileFilter = EnumerateImportWizzard.this._chsFile.getFileFilter();
                    if (fileFilter instanceof SimpleFileFilter) {
                        sff = (SimpleFileFilter)fileFilter;
                    }
                    if ((name = (file = new File(fileName = EnumerateImportWizzard.this.addExtension2(fileName, sff))).getName()).matches(".*[\\>|\\<|\\||\\:|\\?|\\*|\\/|\\\\|\"].*")) {
                        MsgBox.showWarning((String)(name + "\n" + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"invalidFileName", (Locale)SysContext.getSysContext().getLocale())));
                        continue;
                    }
                    if (!EnumerateImportWizzard.this._isForImport && file.exists()) {
                        int showConfirm3 = MsgBox.showConfirm3((Component)EnumerateImportWizzard.this._tfFile, (String)ResourceBase.getString((String)"com/kingdee/eas/fi/rpt/ReportResource", (String)"file-overwrite-confirm", (Locale)SysContext.getSysContext().getLocale()));
                        if (showConfirm3 == 2) {
                            EnumerateImportWizzard.this.closeDialog();
                            SysUtil.abort();
                        } else if (showConfirm3 != 0 && showConfirm3 == 1) {
                            continue;
                        }
                    } else if (EnumerateImportWizzard.this._isForImport && !file.isFile()) {
                        MsgBox.showWarning((String)ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"badFileError", (Locale)SysContext.getSysContext().getLocale()));
                        continue;
                    }
                    break block11;
                }
                return;
            }
            if (ret == 0) {
                EnumerateImportWizzard.this._tfFile.setText(fileName);
                if (EnumerateImportWizzard.this._isForImport && !StringUtils.isEmpty((String)fileName)) {
                    EnumerateImportWizzard.this.openSheetList();
                }
            }
        }
    }

    protected class SheetListPanel
    extends KDScrollPane {
        private KDPanel _pnlList;
        private Book _book;

        SheetListPanel() {
            this.setSize(230, 150);
            this.setBorder(new TitledBorder(EnumerateImportWizzard.this.getLocalText("Key_Sheet")));
            this.getVerticalScrollBar().setUnitIncrement(25);
            this._pnlList = new KDPanel();
            this.setViewportView((Component)this._pnlList);
        }

        void setData(Book book) {
            this._book = book;
            EnumerateImportWizzard.this._btnOk.setEnabled(this._book != null);
            this._pnlList.removeAll();
            if (book != null && book.getSheetCount() > 0) {
                int count = book.getSheetCount();
                this._pnlList.setLayout((LayoutManager)new GridLayout(count, 1, 5, 0));
                for (int i = 0; i < count; ++i) {
                    KDCheckBox ck = new KDCheckBox(book.getSheet(i).getSheetName());
                    this._pnlList.add((Component)ck);
                    ck.setLocation(0, i * 25 + 25);
                    ck.setSelected(true);
                }
                this._pnlList.doLayout();
                this._pnlList.revalidate();
            }
        }

        void setAllSelected(boolean b) {
            int count = this._pnlList.getComponentCount();
            for (int i = 0; i < count; ++i) {
                ((KDCheckBox)this._pnlList.getComponent(i)).setSelected(b);
            }
        }

        String[] getSelectedSheets() {
            int count = this._pnlList.getComponentCount();
            ArrayList<String> al = new ArrayList<String>(count);
            for (int i = 0; i < count; ++i) {
                if (!((KDCheckBox)this._pnlList.getComponent(i)).isSelected()) continue;
                al.add(this._book.getSheet(i).getSheetName());
            }
            if (al.size() == 0) {
                return new String[0];
            }
            String[] str = new String[al.size()];
            for (int i = 0; i < str.length; ++i) {
                str[i] = (String)al.get(i);
            }
            return str;
        }
    }

    protected class ExportOptionPanel
    extends KDScrollPane {
        private KDRadioButton _rbValueAndFormula;
        private KDRadioButton _rbValue;
        private KDRadioButton _rbValueAndExcelFormula;

        ExportOptionPanel() {
            this.setSize(220, 150);
            this.setBorder(new TitledBorder(EnumerateImportWizzard.this.getLocalText("Key_ExportOption")));
            this.getVerticalScrollBar().setUnitIncrement(25);
            this._rbValueAndFormula = new KDRadioButton(EnumerateImportWizzard.this.getLocalText("Key_ValueAndFormula"));
            this._rbValueAndFormula.setSelected(true);
            this._rbValueAndExcelFormula = new KDRadioButton(EnumerateImportWizzard.this.getLocalText("Key_ValueAndExcelformula"));
            this._rbValue = new KDRadioButton(EnumerateImportWizzard.this.getLocalText("Key_Value"));
            KDButtonGroup bg = new KDButtonGroup();
            bg.add((AbstractButton)this._rbValueAndFormula);
            bg.add((AbstractButton)this._rbValueAndExcelFormula);
            bg.add((AbstractButton)this._rbValue);
            KDPanel pnl = new KDPanel();
            pnl.setLayout((LayoutManager)new GridLayout(3, 1, 5, 0));
            pnl.add((Component)this._rbValueAndFormula);
            this._rbValueAndExcelFormula.setLocation(0, 0);
            pnl.add((Component)this._rbValueAndExcelFormula);
            this._rbValueAndExcelFormula.setLocation(0, 25);
            pnl.add((Component)this._rbValue);
            this._rbValue.setLocation(0, 50);
            this.setViewportView((Component)pnl);
        }
    }

    protected class ImportOptionPanel
    extends KDScrollPane {
        static final int IMPORT_ALL = 0;
        static final int IMPORT_VALUE = 1;
        static final int IMPORT_FORMULA = 2;
        private KDRadioButton _rbAll;
        private KDRadioButton _rbValue;
        private KDRadioButton _rbFormula;

        ImportOptionPanel() {
            this.setSize(220, 150);
            this.setBorder(new TitledBorder(EnumerateImportWizzard.this.getLocalText("Key_ImportOption")));
            this.getVerticalScrollBar().setUnitIncrement(25);
            this._rbAll = new KDRadioButton(EnumerateImportWizzard.this.getLocalText("Key_AllContent"));
            this._rbAll.setSelected(true);
            this._rbValue = new KDRadioButton(EnumerateImportWizzard.this.getLocalText("Key_Value"));
            this._rbFormula = new KDRadioButton(EnumerateImportWizzard.this.getLocalText("Key_Formula"));
            KDButtonGroup bg = new KDButtonGroup();
            bg.add((AbstractButton)this._rbAll);
            bg.add((AbstractButton)this._rbFormula);
            bg.add((AbstractButton)this._rbValue);
            KDPanel pnlOption = new KDPanel();
            pnlOption.setLayout((LayoutManager)new GridLayout(3, 1, 5, 0));
            pnlOption.add((Component)this._rbAll);
            this._rbFormula.setLocation(0, 0);
            pnlOption.add((Component)this._rbValue);
            this._rbValue.setLocation(0, 25);
            pnlOption.add((Component)this._rbFormula);
            this._rbFormula.setLocation(0, 50);
            this.setViewportView((Component)pnlOption);
        }

        int getImportOption() {
            if (this._rbFormula.isSelected()) {
                return 2;
            }
            if (this._rbValue.isSelected()) {
                return 1;
            }
            return 0;
        }
    }
}

