/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client.utils;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.event.CellActionAfterListener;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.ParseException;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.client.IBgNumberCellDisplayHelper;
import com.kingdee.eas.ma.nbudget.client.utils.IMeasureProcesser;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;

public abstract class MeasureUnitCellActionAfterListener
implements CellActionAfterListener {
    private static final String PASTE = "Paste";
    private static final String COPY = "Copy";
    private IBgNumberCellDisplayHelper ui = null;
    private boolean isExport = false;

    protected IBgNumberCellDisplayHelper getHelper() {
        return this.ui;
    }

    public MeasureUnitCellActionAfterListener(IBgNumberCellDisplayHelper ui) {
        this.ui = ui;
    }

    public static void setExport(Book book, boolean isExport) {
        if (book != null && book.getCellActionAfterListener() instanceof MeasureUnitCellActionAfterListener) {
            ((MeasureUnitCellActionAfterListener)book.getCellActionAfterListener()).isExport = isExport;
        }
    }

    public void doAfter(Cell paramCell1, Cell paramCell2, String paramString) {
        BigDecimal coefficient = BgNConstants.ONE;
        boolean isProcess = this.isProcess();
        if (isProcess) {
            IMeasureProcesser processor = this.getProcessor();
            coefficient = processor.getCoefficient(paramCell1.getText(), paramCell2);
            if (coefficient == null) {
                coefficient = BgNConstants.ONE;
            }
            if (paramString.equals(PASTE)) {
                if (paramCell2.getValue().getValue() instanceof BigDecimal && paramCell1.getValue() != null && paramCell1.getValue().getValue() == paramCell2.getValue().getValue()) {
                    paramCell2.setValue(new Variant((Object)((BigDecimal)paramCell1.getValue().getValue()).multiply(coefficient), 10));
                }
            } else if (paramString.equals(COPY)) {
                if (paramCell1.getValue().getValue() instanceof BigDecimal) {
                    paramCell2.setValue(new Variant((Object)((BigDecimal)paramCell1.getValue().getValue()).divide(coefficient), 10));
                }
                if (paramCell2.hasFormula()) {
                    try {
                        String formula = paramCell2.getFormula();
                        if (!StringUtils.isEmpty((String)formula)) {
                            formula = formula.replaceAll("R\\d*C\\d*\\[-{0,1}\\d*\\]", "A1");
                            formula = formula.replaceAll("R\\d*C\\d*", "A1");
                            formula = formula.replaceAll("R\\[-{0,1}\\d*\\]C\\[-{0,1}\\d*\\]", "A1");
                            formula = formula.replaceAll("R\\[-{0,1}\\d*\\]C", "A1");
                            formula = formula.replaceAll("R\\[\\d*\\]C\\[\\d*\\]", "A1");
                            formula = formula.replaceAll("#REF!", "A1");
                        }
                        Expression expression = ExcelFormulaPaserHelper.parse((String)formula);
                    }
                    catch (ParseException e) {
                        Variant value = paramCell2.getValue();
                        paramCell2.setFormula(null);
                        paramCell2.setValue(value);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected abstract boolean isProcess();

    protected abstract IMeasureProcesser getProcessor();
}

