/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.BaseVoucherEntryInfo;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IBaseVoucherAssistRecord;
import com.kingdee.eas.fi.gl.VoucherPrintDataProvider;
import com.kingdee.eas.fi.gl.VoucherPrintSettingInfo;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.DateFormat;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class PcVoucherPrintDataProvider
extends VoucherPrintDataProvider {
    private static final Logger log = Logger.getLogger(PcVoucherPrintDataProvider.class);
    public static final String[] col = new String[]{"pageCount", "pageCurrent", "pageTotal", "company", "profitCenter", "companyBaseCurreny", "companyReportCurreny", "description", "attachments", "attachmentsChinese", "sum", "periodYear", "periodNumber", "bizDate", "voucherDate", "bookedDate", "bookedDateYear", "bookedDateMonth", "bookedDateDay", "sysDateNow", "vchId", "bizStatus", "voucherType", "number", "numberShort", "vouchtTypeNumber", "currency", "amountTotalChinese", "amountTotal", "creditTotal", "debitTotal", "localAmountDebit", "localAmountCredit", "reportingAmountDebit", "reportingAmountCredit", "handler", "creator", "auditor", "cashier", "poster", "canceller", "e_seq", "e_description", "e_account", "e_accountCategory", "e_profitCenter", "zc_account", "e_currency", "e_isoCode", "e_measureUnitName", "e_measureUnitNumber", "e_price", "e_quantity", "e_originalAmount", "e_originalAmountDebit", "e_originalAmountCredit", "e_localExchangeRate", "e_localAmountDebit", "e_localAmountCredit", "e_reportingExchangeRate", "e_reportingAmountDebit", "e_reportingAmountCredit", "r_description", "r_settlementType", "r_settlementCode", "r_bizNumber", "r_originalAmount", "r_originalAmountDebit", "r_originalAmountCredit", "r_localAmount", "r_localAmountDebit", "r_localAmountCredit", "r_reportingAmount", "r_reportingAmountDebit", "r_reportingAmountCredit", "r_measureUnitName", "r_measureUnitNumber", "r_price", "r_quantity", "r_bizDate", "r_invoice", "r_endDate", "r_customer", "r_supplier", "r_orgUnit", "r_matirial", "r_assGrp", "r_longName", "r_AsstHeadNumber", "r_AsstNumber", "r_AsstHeadName", "r_AsstName", "r_AsstLevelName", "r_accountAsst", "r_accountAsstPrimItem", "zc_assGrp", "c_item", "c_itemEbb", "c_primItem", "c_supp", "c_suppEbb", "c_suppItem", "c_fullInfo", "c_fullInfoEbb", "c_fullInfoItem", "c_oppAccount", "c_originalAmount", "c_localAmount", "c_reportingAmount", "c_primItemName", "c_suppItemName", "customer.number", "customer.name", "cusNumberName", "sourceSys", "sourceType"};

    public PcVoucherPrintDataProvider(VoucherPrintSettingInfo settingInfo) throws EASBizException, BOSException {
        super(settingInfo);
    }

    public void fillVoucherHeaderData(BaseVoucherInfo vch, IRowSet rs, DateFormat df, DateFormat dft, int size, BigDecimal allDeit, BigDecimal allCret) throws Exception {
        CompanyOrgUnitInfo com = vch.getCompany();
        this.initGLMap(com.getId().toString());
        rs.updateString("company", com.getName());
        rs.updateString("companyBaseCurreny", com.getBaseCurrency().getName().toString());
        if (com.getReportCurrency() != null) {
            rs.updateString("companyReportCurreny", com.getReportCurrency().getName().toString());
        }
        rs.updateString("description", vch.getDescription());
        rs.updateDate("bookedDate", new Date(vch.getBookedDate().getTime()));
        rs.updateDate("voucherDate", new Date(vch.getBookedDate().getTime()));
        rs.updateString("sourceSys", vch.getSourceSys() == null ? "" : vch.getSourceSys().toString());
        rs.updateString("sourceType", vch.getSourceType() == null ? "" : vch.getSourceType().toString());
        Date voucherBookDate = (Date)vch.getBookedDate();
        Calendar now = Calendar.getInstance();
        now.setTime(voucherBookDate);
        rs.updateString("bookedDateYear", String.valueOf(now.get(1)));
        int month = now.get(2) + 1;
        rs.updateString("bookedDateMonth", month < 10 ? "0" + month : "" + month);
        int date = now.get(5);
        rs.updateString("bookedDateDay", date < 10 ? "0" + date : "" + date);
        rs.updateDate("bizDate", new Date(vch.getBizDate().getTime()));
        PeriodInfo prd = vch.getPeriod();
        if (prd != null) {
            rs.updateString("periodYear", Integer.toString(prd.getPeriodYear()));
            rs.updateString("periodNumber", Integer.toString(prd.getPeriodNumber()));
        }
        rs.updateString("sysDateNow", GlUtils.formatDate((DateFormat)dft, (java.util.Date)SysUtil.getAppServerTime(null)));
        String type = GlUtils.getName((IObjectValue)vch, (String)"voucherType");
        rs.updateString("voucherType", type);
        String strNumber = vch.getNumber();
        String strNumberShort = "";
        if (strNumber != null) {
            int n = strNumber.length();
            int il = 0;
            char[] ch = new char[n];
            for (int i = 0; i < n; ++i) {
                ch[i] = strNumber.charAt(i);
                if (ch[i] != '0') break;
                ++il;
            }
            strNumberShort = strNumber.substring(il, n);
        }
        rs.updateString("number", vch.getNumber());
        rs.updateString("numberShort", strNumberShort);
        rs.updateString("vouchtTypeNumber", type + vch.getNumber());
        rs.updateString("currency", GlUtils.getName((IObjectValue)vch, (String)"currency"));
        rs.updateString("handler", GlUtils.getName((IObjectValue)vch, (String)"handler"));
        rs.updateString("creator", GlUtils.getName((IObjectValue)vch, (String)"creator"));
        rs.updateString("auditor", GlUtils.getName((IObjectValue)vch, (String)"auditor"));
        rs.updateString("cashier", GlUtils.getName((IObjectValue)vch, (String)"cashier"));
        rs.updateString("poster", GlUtils.getName((IObjectValue)vch, (String)"poster"));
        rs.updateString("canceller", GlUtils.getName((IObjectValue)vch, (String)"canceller"));
        if (!(vch instanceof PcVoucherInfo)) {
            log.error((Object)("invalid PcVoucherInfo : " + vch), (Throwable)new Exception());
            return;
        }
        rs.updateString("profitCenter", ((PcVoucherInfo)vch).getProfitCenter().getName());
        rs.updateInt("attachments", Integer.valueOf(((PcVoucherInfo)vch).getAttachments()).intValue());
    }

    public void fillVoucherEntryData(String vchId, BaseVoucherEntryInfo e, IRowSet rs, int lcpre, int rcpre, String companyId) throws Exception {
        super.fillVoucherEntryData(vchId, e, rs, lcpre, rcpre, companyId);
    }

    public void fillVoucherASSTData(BaseVoucherAssistRecordInfo r, IRowSet rs, DateFormat adf, int lcpre, EntryDC dc, IAssistantHG assistantHG, IBaseVoucherAssistRecord asstre, BaseVoucherEntryInfo e, String companyId) throws Exception {
        super.fillVoucherASSTData(r, rs, adf, lcpre, dc, assistantHG, asstre, e, companyId);
        if (rs.getString("r_assGrp") != null && !"".equals(rs.getString("r_assGrp"))) {
            rs.updateString("r_accountAsst", rs.getString("e_account") + " ( " + rs.getString("r_assGrp") + " )");
        }
    }
}

