/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountProperty;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.BaseVoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.BaseVoucherEntryInfo;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.IBaseVoucherAssistRecord;
import com.kingdee.eas.fi.gl.IVoucherAssistRecord;
import com.kingdee.eas.fi.gl.VoucherAssistRecordFactory;
import com.kingdee.eas.fi.gl.VoucherPrintDataProvider;
import com.kingdee.eas.fi.gl.VoucherPrintSettingInfo;
import com.kingdee.eas.fi.gl.VoucherRowSetProvider;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordCollection;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordInfo;
import com.kingdee.eas.ma.pca.PcVoucherCollection;
import com.kingdee.eas.ma.pca.PcVoucherEntryCollection;
import com.kingdee.eas.ma.pca.PcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcVoucherPrintDataProvider;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class PcVoucherRowSetProvider
implements BOSQueryDelegate {
    private static final Logger logger = Logger.getLogger(VoucherRowSetProvider.class);
    private Locale locale;
    private DateFormat df;
    private DateFormat adf;
    private DateFormat dft;
    private PcVoucherCollection vchCol;
    private VoucherPrintSettingInfo settingInfo;
    private VoucherPrintDataProvider provider;

    public PcVoucherRowSetProvider(Locale locale, PcVoucherCollection vc, VoucherPrintSettingInfo settingInfo) throws EASBizException, BOSException {
        this.locale = locale;
        if (this.locale == null) {
            this.locale = SysContext.getSysContext().getLocale();
        }
        this.df = new SimpleDateFormat(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"20_RptAsstactXBalanceUI", (Locale)this.locale));
        this.adf = DateFormat.getDateInstance(2, locale);
        this.dft = DateFormat.getDateTimeInstance(2, 2, this.locale);
        this.vchCol = vc;
        this.settingInfo = settingInfo;
        this.provider = new PcVoucherPrintDataProvider(settingInfo);
    }

    public PcVoucherRowSetProvider(PcVoucherCollection vc, VoucherPrintSettingInfo settingInfo) throws EASBizException, BOSException {
        this(null, vc, settingInfo);
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        return this.getRowSet(ds.getID());
    }

    public IRowSet getRowSet(String dsId) {
        IRowSet rs = null;
        for (int i = 4; i <= 30; ++i) {
            if (("dsStandard" + i).equalsIgnoreCase(dsId)) {
                rs = this.getRowSet(false, i);
                break;
            }
            if (("flowStandard" + i).equalsIgnoreCase(dsId)) {
                rs = this.getRowSetFlow(false, i);
                break;
            }
            if (("ds1_Standard" + i).equalsIgnoreCase(dsId)) {
                rs = this.getRowSet(true, i);
                break;
            }
            if (("flow1_Standard" + i).equalsIgnoreCase(dsId)) {
                rs = this.getRowSetFlow(true, i);
                break;
            }
            if (("ds2_subtotal" + i).equalsIgnoreCase(dsId)) {
                rs = this.getRowSet2(i);
                break;
            }
            if (("ds" + i).equalsIgnoreCase(dsId)) {
                rs = this.getRowSet3(i);
                break;
            }
            if (("voucher_ds" + i).equalsIgnoreCase(dsId)) {
                rs = this.getRowSet4(i);
                break;
            }
            if (!("vchFlow" + i).equalsIgnoreCase(dsId)) continue;
            rs = this.getRowSet5(i);
            break;
        }
        return rs;
    }

    private IRowSet getRowSet(boolean pltype, int rowLineCount) {
        int colCount = PcVoucherPrintDataProvider.col.length;
        DynamicRowSet drs = null;
        try {
            drs = new DynamicRowSet(colCount);
            for (int i = 0; i < colCount; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = PcVoucherPrintDataProvider.col[i];
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            Iterator itrVch = this.vchCol.iterator();
            int size = this.vchCol.size();
            BigDecimal allDeit = SysConstant.BIGZERO;
            BigDecimal allCret = SysConstant.BIGZERO;
            int vchCount = 0;
            IAssistantHG assistantHG = null;
            IVoucherAssistRecord asstre = null;
            while (itrVch.hasNext()) {
                int lcpre;
                PcVoucherInfo vch = (PcVoucherInfo)itrVch.next();
                if (pltype && this.computerVoucherType(vch)) {
                    vch = this.changeVoucher(vch);
                }
                String vchId = Integer.toString(++vchCount);
                CompanyOrgUnitInfo com = vch.getCompany();
                CurrencyInfo localCurrency = com.getBaseCurrency();
                int rcpre = lcpre = localCurrency.getPrecision();
                CurrencyInfo reportingCurrency = com.getReportCurrency();
                if (reportingCurrency != null) {
                    rcpre = reportingCurrency.getPrecision();
                }
                allDeit = vch.getLocalDebitAmount();
                allCret = vch.getLocalCreditAmount();
                Iterator itrEntry = vch.getEntries().iterator();
                int entrySize = vch.getEntries().size();
                int voucherCount = 0;
                voucherCount = entrySize % rowLineCount == 0 ? entrySize / rowLineCount : entrySize / rowLineCount + 1;
                int entryCount = 1;
                while (itrEntry.hasNext()) {
                    PcVoucherEntryInfo e = (PcVoucherEntryInfo)itrEntry.next();
                    PcVoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                    if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                        Iterator itrASST = assitCollection.iterator();
                        int asstCount = 0;
                        EntryDC dc = e.getEntryDC();
                        while (itrASST.hasNext()) {
                            PcVoucherAssistRecordInfo r = (PcVoucherAssistRecordInfo)itrASST.next();
                            if (assistantHG == null) {
                                assistantHG = AssistantHGFactory.getRemoteInstance();
                            }
                            if (asstre == null) {
                                asstre = VoucherAssistRecordFactory.getRemoteInstance();
                            }
                            drs.moveToInsertRow();
                            this.provider.clearRow((IRowSet)drs);
                            this.provider.clearRow((IRowSet)drs);
                            this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                            this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                            if (this.settingInfo.isPrintAssistant()) {
                                this.provider.fillVoucherASSTData((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, this.df, lcpre, dc, assistantHG, (IBaseVoucherAssistRecord)asstre, (BaseVoucherEntryInfo)e, vch.getProfitCenter().getId().toString());
                            }
                            if (++asstCount > 1) {
                                drs.updateString("e_seq", " ");
                            }
                            int page = 0;
                            page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                            drs.updateString("pageCount", page + "/" + voucherCount);
                            drs.updateString("pageCurrent", page + "");
                            drs.updateString("pageTotal", "" + voucherCount);
                            drs.updateString("bizStatus", vch.getBizStatus().toString());
                            drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                            drs.updateString("attachmentsChinese", PcaUtils.getChineseBig(vch.getAttachments(), this.locale));
                            if (page == voucherCount) {
                                drs.updateString("debitTotal", PcaUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                                drs.updateString("creditTotal", PcaUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                                drs.updateString("localAmountDebit", PcaUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                                drs.updateString("localAmountCredit", PcaUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                                drs.updateString("reportingAmountDebit", PcaUtils.formatNumber(vch.getReportingDebitAmount(), lcpre));
                                drs.updateString("reportingAmountCredit", PcaUtils.formatNumber(vch.getReportingCreditAmount(), lcpre));
                                drs.updateString("amountTotalChinese", PcaUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                                drs.updateString("amountTotal", PcaUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                            }
                            drs.insertRow();
                        }
                        continue;
                    }
                    drs.moveToInsertRow();
                    this.provider.clearRow((IRowSet)drs);
                    this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                    this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                    int page = 0;
                    page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                    drs.updateString("pageCount", page + "/" + voucherCount);
                    drs.updateString("pageCurrent", page + "");
                    drs.updateString("pageTotal", "" + voucherCount);
                    drs.updateString("bizStatus", vch.getBizStatus().toString());
                    drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                    drs.updateString("attachmentsChinese", PcaUtils.getChineseBig(vch.getAttachments(), this.locale));
                    if (page == voucherCount) {
                        drs.updateString("creditTotal", PcaUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                        drs.updateString("debitTotal", PcaUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                        drs.updateString("localAmountDebit", PcaUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                        drs.updateString("localAmountCredit", PcaUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                        drs.updateString("reportingAmountDebit", PcaUtils.formatNumber(vch.getReportingDebitAmount(), lcpre));
                        drs.updateString("reportingAmountCredit", PcaUtils.formatNumber(vch.getReportingCreditAmount(), lcpre));
                        drs.updateString("amountTotalChinese", PcaUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                        drs.updateString("amountTotal", PcaUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                    }
                    drs.insertRow();
                }
            }
            drs.beforeFirst();
        }
        catch (Exception ex) {
            logger.error((Object)"Get rowset error!", (Throwable)ex);
            return null;
        }
        return drs;
    }

    private IRowSet getRowSetFlow(boolean pltype, int rowLineCount) {
        int colCount = PcVoucherPrintDataProvider.col.length;
        DynamicRowSet drs = null;
        try {
            drs = new DynamicRowSet(colCount);
            for (int i = 0; i < colCount; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = PcVoucherPrintDataProvider.col[i];
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            Iterator itrVch = this.vchCol.iterator();
            int size = this.vchCol.size();
            BigDecimal allDeit = SysConstant.BIGZERO;
            BigDecimal allCret = SysConstant.BIGZERO;
            int vchCount = 0;
            while (itrVch.hasNext()) {
                int lcpre;
                PcVoucherInfo vch = (PcVoucherInfo)itrVch.next();
                if (pltype && this.computerVoucherType(vch)) {
                    vch = this.changeVoucher(vch);
                }
                String vchId = Integer.toString(++vchCount);
                CompanyOrgUnitInfo com = vch.getCompany();
                CurrencyInfo localCurrency = com.getBaseCurrency();
                int rcpre = lcpre = localCurrency.getPrecision();
                CurrencyInfo reportingCurrency = com.getReportCurrency();
                if (reportingCurrency != null) {
                    rcpre = reportingCurrency.getPrecision();
                }
                allDeit = vch.getLocalDebitAmount();
                allCret = vch.getLocalCreditAmount();
                Iterator itrEntry = vch.getEntries().iterator();
                int entrySize = vch.getEntries().size();
                int voucherCount = 0;
                voucherCount = entrySize % rowLineCount == 0 ? entrySize / rowLineCount : entrySize / rowLineCount + 1;
                int entryCount = 1;
                while (itrEntry.hasNext()) {
                    PcVoucherEntryInfo e = (PcVoucherEntryInfo)itrEntry.next();
                    EntryDC dc = e.getEntryDC();
                    drs.moveToInsertRow();
                    this.provider.clearRow((IRowSet)drs);
                    this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                    this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                    int page = 0;
                    page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                    drs.updateString("pageCount", page + "/" + voucherCount);
                    drs.updateString("pageCurrent", page + "");
                    drs.updateString("pageTotal", "" + voucherCount);
                    drs.updateString("bizStatus", vch.getBizStatus().toString());
                    drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                    drs.updateString("attachmentsChinese", PcaUtils.getChineseBig(vch.getAttachments(), this.locale));
                    if (page == voucherCount) {
                        drs.updateString("creditTotal", PcaUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                        drs.updateString("debitTotal", PcaUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                        drs.updateString("localAmountDebit", PcaUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                        drs.updateString("localAmountCredit", PcaUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                        drs.updateString("reportingAmountDebit", PcaUtils.formatNumber(vch.getReportingDebitAmount(), lcpre));
                        drs.updateString("reportingAmountCredit", PcaUtils.formatNumber(vch.getReportingCreditAmount(), lcpre));
                        drs.updateString("amountTotalChinese", PcaUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                        drs.updateString("amountTotal", PcaUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                    }
                    drs.insertRow();
                }
            }
            drs.beforeFirst();
        }
        catch (Exception ex) {
            logger.error((Object)"Get rowset error!", (Throwable)ex);
            return null;
        }
        return drs;
    }

    private IRowSet getRowSet2(int rowLineCount) {
        int colCount = PcVoucherPrintDataProvider.col.length;
        DynamicRowSet drs = null;
        IAssistantHG assistantHG = null;
        IBaseVoucherAssistRecord asstre = null;
        try {
            drs = new DynamicRowSet(colCount);
            for (int i = 0; i < colCount; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = PcVoucherPrintDataProvider.col[i];
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            Iterator itrVch = this.vchCol.iterator();
            int size = this.vchCol.size();
            BigDecimal allDeit = SysConstant.BIGZERO;
            BigDecimal allCret = SysConstant.BIGZERO;
            int vchCount = 0;
            while (itrVch.hasNext()) {
                int lcpre;
                PcVoucherInfo vch = (PcVoucherInfo)itrVch.next();
                String vchId = Integer.toString(++vchCount);
                CompanyOrgUnitInfo com = vch.getCompany();
                CurrencyInfo localCurrency = com.getBaseCurrency();
                int rcpre = lcpre = localCurrency.getPrecision();
                CurrencyInfo reportingCurrency = com.getReportCurrency();
                if (reportingCurrency != null) {
                    rcpre = reportingCurrency.getPrecision();
                }
                allDeit = vch.getLocalDebitAmount();
                allCret = vch.getLocalCreditAmount();
                Iterator itr = vch.getEntries().iterator();
                int entrySize = 0;
                int seq = 0;
                while (itr.hasNext()) {
                    PcVoucherEntryInfo e = (PcVoucherEntryInfo)itr.next();
                    seq = e.getSeq();
                    PcVoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                    if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                        entrySize += assitCollection.size();
                        continue;
                    }
                    ++entrySize;
                }
                Iterator itrEntry = vch.getEntries().iterator();
                int voucherCount = 0;
                voucherCount = (entrySize + seq) % rowLineCount == 0 ? (entrySize + seq) / rowLineCount : (entrySize + seq) / rowLineCount + 1;
                int entryCount = 1;
                while (itrEntry.hasNext()) {
                    int page;
                    PcVoucherEntryInfo e = (PcVoucherEntryInfo)itrEntry.next();
                    PcVoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                    EntryDC dc = e.getEntryDC();
                    int asstCount = 0;
                    if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                        for (PcVoucherAssistRecordInfo r : assitCollection) {
                            drs.moveToInsertRow();
                            this.provider.clearRow((IRowSet)drs);
                            this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                            this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                            if (this.settingInfo.isPrintAssistant()) {
                                this.provider.fillVoucherASSTData((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, this.df, lcpre, dc, assistantHG, asstre, (BaseVoucherEntryInfo)e, vch.getCompany().getId().toString());
                            }
                            if (++asstCount > 1) {
                                drs.updateString("e_seq", " ");
                                drs.updateString("e_account", null);
                            }
                            int page2 = 0;
                            page2 = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                            drs.updateString("pageCount", page2 + "/" + voucherCount);
                            drs.updateString("pageCurrent", page2 + "");
                            drs.updateString("pageTotal", "" + voucherCount);
                            drs.updateString("bizStatus", vch.getBizStatus().toString());
                            drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                            drs.updateString("attachmentsChinese", PcaUtils.getChineseBig(vch.getAttachments(), this.locale));
                            if (page2 == voucherCount) {
                                drs.updateString("debitTotal", PcaUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                                drs.updateString("creditTotal", PcaUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                                drs.updateString("localAmountDebit", PcaUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                                drs.updateString("localAmountCredit", PcaUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                                drs.updateString("reportingAmountDebit", PcaUtils.formatNumber(vch.getReportingDebitAmount(), lcpre));
                                drs.updateString("reportingAmountCredit", PcaUtils.formatNumber(vch.getReportingCreditAmount(), lcpre));
                                drs.updateString("amountTotalChinese", PcaUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                                drs.updateString("amountTotal", PcaUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                                drs.updateString("sum", "");
                            }
                            drs.insertRow();
                        }
                    } else {
                        drs.moveToInsertRow();
                        this.provider.clearRow((IRowSet)drs);
                        this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                        this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                        if (EntryDC.DEBIT.equals((Object)dc)) {
                            drs.updateString("e_originalAmountDebit", PcaUtils.formatNumber(e.getOriginalAmount(), lcpre));
                            drs.updateString("e_localAmountDebit", PcaUtils.formatNumber(e.getLocalAmount(), lcpre));
                            drs.updateString("e_reportingAmountDebit", PcaUtils.formatNumber(e.getReportingAmount(), lcpre));
                            drs.updateString("r_originalAmountDebit", PcaUtils.formatNumber(e.getOriginalAmount(), lcpre));
                            drs.updateString("r_localAmountDebit", PcaUtils.formatNumber(e.getLocalAmount(), lcpre));
                            drs.updateString("r_reportingAmountDebit", PcaUtils.formatNumber(e.getReportingAmount(), lcpre));
                        } else {
                            drs.updateString("e_localAmountCredit", PcaUtils.formatNumber(e.getLocalAmount(), lcpre));
                            drs.updateString("e_originalAmountCredit", PcaUtils.formatNumber(e.getOriginalAmount(), lcpre));
                            drs.updateString("e_reportingAmountCredit", PcaUtils.formatNumber(e.getReportingAmount(), lcpre));
                            drs.updateString("r_originalAmountCredit", PcaUtils.formatNumber(e.getOriginalAmount(), lcpre));
                            drs.updateString("r_localAmountCredit", PcaUtils.formatNumber(e.getOriginalAmount(), lcpre));
                            drs.updateString("r_reportingAmountCredit", PcaUtils.formatNumber(e.getReportingAmount(), lcpre));
                        }
                        page = 0;
                        page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                        drs.updateString("pageCount", page + "/" + voucherCount);
                        drs.updateString("pageCurrent", page + "");
                        drs.updateString("pageTotal", "" + voucherCount);
                        drs.updateString("bizStatus", vch.getBizStatus().toString());
                        drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                        drs.updateString("attachmentsChinese", PcaUtils.getChineseBig(vch.getAttachments(), this.locale));
                        if (page == voucherCount) {
                            drs.updateString("debitTotal", PcaUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                            drs.updateString("creditTotal", PcaUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                            drs.updateString("localAmountDebit", PcaUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                            drs.updateString("localAmountCredit", PcaUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                            drs.updateString("reportingAmountDebit", PcaUtils.formatNumber(vch.getReportingDebitAmount(), lcpre));
                            drs.updateString("reportingAmountCredit", PcaUtils.formatNumber(vch.getReportingCreditAmount(), lcpre));
                            drs.updateString("amountTotalChinese", PcaUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                            drs.updateString("amountTotal", PcaUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                            drs.updateString("sum", "");
                        }
                        drs.insertRow();
                    }
                    drs.moveToInsertRow();
                    drs.updateString("e_seq", "");
                    drs.updateString("e_description", "");
                    drs.updateString("e_account", "");
                    drs.updateString("zc_account", "");
                    drs.updateString("e_currency", "");
                    drs.updateString("e_measureUnitName", "");
                    drs.updateString("e_measureUnitNumber", "");
                    drs.updateString("periodYear", "");
                    drs.updateString("periodNumber", "");
                    drs.updateString("bizDate", "");
                    drs.updateString("bookedDate", "");
                    drs.updateString("bookedDateYear", "");
                    drs.updateString("bookedDateMonth", "");
                    drs.updateString("r_description", "");
                    drs.updateString("r_settlementType", "");
                    drs.updateString("r_settlementCode", "");
                    drs.updateString("r_bizNumber", "");
                    drs.updateString("r_originalAmount", "");
                    drs.updateString("r_originalAmount", "");
                    drs.updateString("r_originalAmountDebit", "");
                    drs.updateString("r_localAmount", "");
                    drs.updateString("r_localAmountDebit", "");
                    drs.updateString("r_localAmountCredit", "");
                    drs.updateString("r_reportingAmount", "");
                    drs.updateString("r_reportingAmountDebit", "");
                    drs.updateString("r_reportingAmountCredit", "");
                    drs.updateString("r_measureUnitName", "");
                    drs.updateString("r_measureUnitNumber", "");
                    drs.updateString("r_price", "");
                    drs.updateString("r_quantity", "");
                    drs.updateString("r_bizDate", "");
                    drs.updateString("r_invoice", "");
                    drs.updateString("r_endDate", "");
                    drs.updateString("r_assGrp", "");
                    drs.updateString("r_longName", "");
                    drs.updateString("r_accountAsst", "");
                    drs.updateString("r_AsstHeadNumber", "");
                    drs.updateString("r_AsstNumber", "");
                    drs.updateString("r_AsstHeadName", "");
                    drs.updateString("r_AsstName", "");
                    drs.updateString("r_AsstLevelName", "");
                    drs.updateString("zc_assGrp", "");
                    drs.updateString("c_item", "");
                    drs.updateString("c_itemEbb", "");
                    drs.updateString("c_primItem", "");
                    drs.updateString("c_suppItem", "");
                    drs.updateString("c_oppAccount", "");
                    drs.updateString("c_originalAmount", "");
                    drs.updateString("c_localAmount", "");
                    drs.updateString("c_reportingAmount", "");
                    drs.updateString("c_primItemName", "");
                    drs.updateString("c_suppItemName", "");
                    drs.updateString("customer.number", "");
                    drs.updateString("customer.name", "");
                    drs.updateString("cusNumberName", "");
                    drs.updateString("vchId", vchId);
                    drs.updateString("e_isoCode", GLResUtil.getRes((String)"subtotal", (Locale)this.locale));
                    if (EntryDC.DEBIT.equals((Object)dc)) {
                        drs.updateString("e_originalAmountDebit", PcaUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("e_localAmountDebit", PcaUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("e_reportingAmountDebit", PcaUtils.formatNumber(e.getReportingAmount(), lcpre));
                        drs.updateString("r_originalAmountDebit", PcaUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("r_localAmountDebit", PcaUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("r_reportingAmountDebit", PcaUtils.formatNumber(e.getReportingAmount(), lcpre));
                    } else {
                        drs.updateString("e_localAmountCredit", PcaUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("e_originalAmountCredit", PcaUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("e_reportingAmountCredit", PcaUtils.formatNumber(e.getReportingAmount(), lcpre));
                        drs.updateString("r_originalAmountCredit", PcaUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("r_localAmountCredit", PcaUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("r_reportingAmountCredit", PcaUtils.formatNumber(e.getReportingAmount(), lcpre));
                    }
                    page = 0;
                    page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                    drs.updateString("pageCount", page + "/" + voucherCount);
                    drs.updateString("pageCurrent", page + "");
                    drs.updateString("pageTotal", "" + voucherCount);
                    drs.updateString("bizStatus", vch.getBizStatus().toString());
                    drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                    drs.updateString("attachmentsChinese", PcaUtils.getChineseBig(vch.getAttachments(), this.locale));
                    if (page == voucherCount) {
                        drs.updateString("debitTotal", PcaUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                        drs.updateString("creditTotal", PcaUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                        drs.updateString("localAmountDebit", PcaUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                        drs.updateString("localAmountCredit", PcaUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                        drs.updateString("reportingAmountDebit", PcaUtils.formatNumber(vch.getReportingDebitAmount(), lcpre));
                        drs.updateString("reportingAmountCredit", PcaUtils.formatNumber(vch.getReportingCreditAmount(), lcpre));
                        drs.updateString("amountTotalChinese", PcaUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                        drs.updateString("amountTotal", PcaUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                    }
                    drs.insertRow();
                }
            }
            drs.beforeFirst();
        }
        catch (Exception ex) {
            logger.error((Object)"Get rowset error!", (Throwable)ex);
            return null;
        }
        return drs;
    }

    private IRowSet getRowSet3(int rowLineCount) {
        int colCount = PcVoucherPrintDataProvider.col.length;
        DynamicRowSet drs = null;
        IAssistantHG assistantHG = null;
        IBaseVoucherAssistRecord asstre = null;
        PcVoucherEntryInfo e = null;
        try {
            drs = new DynamicRowSet(colCount);
            for (int i = 0; i < colCount; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = PcVoucherPrintDataProvider.col[i];
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            Iterator itrVch = this.vchCol.iterator();
            int size = this.vchCol.size();
            BigDecimal allDeit = SysConstant.BIGZERO;
            BigDecimal allCret = SysConstant.BIGZERO;
            int vchCount = 0;
            while (itrVch.hasNext()) {
                int lcpre;
                PcVoucherInfo vch = (PcVoucherInfo)itrVch.next();
                String vchId = Integer.toString(++vchCount);
                CompanyOrgUnitInfo com = vch.getCompany();
                CurrencyInfo localCurrency = com.getBaseCurrency();
                int rcpre = lcpre = localCurrency.getPrecision();
                CurrencyInfo reportingCurrency = com.getReportCurrency();
                if (reportingCurrency != null) {
                    rcpre = reportingCurrency.getPrecision();
                }
                allDeit = vch.getLocalDebitAmount();
                allCret = vch.getLocalCreditAmount();
                Iterator itr = vch.getEntries().iterator();
                int entrySize = 0;
                while (itr.hasNext()) {
                    e = (PcVoucherEntryInfo)itr.next();
                    PcVoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                    if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                        entrySize += assitCollection.size();
                        continue;
                    }
                    ++entrySize;
                }
                Iterator itrEntry = vch.getEntries().iterator();
                int voucherCount = 0;
                voucherCount = entrySize % rowLineCount == 0 ? entrySize / rowLineCount : entrySize / rowLineCount + 1;
                int entryCount = 0;
                while (itrEntry.hasNext()) {
                    e = (PcVoucherEntryInfo)itrEntry.next();
                    PcVoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                    EntryDC dc = e.getEntryDC();
                    int asstCount = 0;
                    if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                        for (PcVoucherAssistRecordInfo r : assitCollection) {
                            drs.moveToInsertRow();
                            this.provider.clearRow((IRowSet)drs);
                            this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                            this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                            if (this.settingInfo.isPrintAssistant()) {
                                this.provider.fillVoucherASSTData((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, this.df, lcpre, dc, assistantHG, asstre, (BaseVoucherEntryInfo)e, vch.getCompany().getId().toString());
                            }
                            if (++asstCount > 1) {
                                drs.updateString("e_seq", " ");
                            }
                            int page = 0;
                            page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                            drs.updateString("pageCount", page + "/" + voucherCount);
                            drs.updateString("pageCurrent", page + "");
                            drs.updateString("pageTotal", "" + voucherCount);
                            drs.updateString("bizStatus", vch.getBizStatus().toString());
                            drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                            drs.updateString("attachmentsChinese", PcaUtils.getChineseBig(vch.getAttachments(), this.locale));
                            if (page == voucherCount) {
                                drs.updateString("debitTotal", PcaUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                                drs.updateString("creditTotal", PcaUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                                drs.updateString("localAmountDebit", PcaUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                                drs.updateString("localAmountCredit", PcaUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                                drs.updateString("reportingAmountDebit", PcaUtils.formatNumber(vch.getReportingDebitAmount(), lcpre));
                                drs.updateString("reportingAmountCredit", PcaUtils.formatNumber(vch.getReportingCreditAmount(), lcpre));
                                drs.updateString("amountTotalChinese", PcaUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                                drs.updateString("amountTotal", PcaUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                            }
                            drs.insertRow();
                        }
                        continue;
                    }
                    drs.moveToInsertRow();
                    this.provider.clearRow((IRowSet)drs);
                    this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                    this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                    if (EntryDC.DEBIT.equals((Object)dc)) {
                        drs.updateString("e_originalAmountDebit", PcaUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("e_localAmountDebit", PcaUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("e_reportingAmountDebit", PcaUtils.formatNumber(e.getReportingAmount(), lcpre));
                        drs.updateString("r_originalAmountDebit", PcaUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("r_localAmountDebit", PcaUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("r_reportingAmountDebit", PcaUtils.formatNumber(e.getReportingAmount(), lcpre));
                    } else {
                        drs.updateString("e_localAmountCredit", PcaUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("e_originalAmountCredit", PcaUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("e_reportingAmountCredit", PcaUtils.formatNumber(e.getReportingAmount(), lcpre));
                        drs.updateString("r_originalAmountCredit", PcaUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("r_localAmountCredit", PcaUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("r_reportingAmountCredit", PcaUtils.formatNumber(e.getReportingAmount(), lcpre));
                    }
                    int page = 0;
                    page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                    drs.updateString("pageCount", page + "/" + voucherCount);
                    drs.updateString("pageCurrent", page + "");
                    drs.updateString("pageTotal", "" + voucherCount);
                    drs.updateString("bizStatus", vch.getBizStatus().toString());
                    drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                    drs.updateString("attachmentsChinese", PcaUtils.getChineseBig(vch.getAttachments(), this.locale));
                    if (page == voucherCount) {
                        drs.updateString("debitTotal", PcaUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                        drs.updateString("creditTotal", PcaUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                        drs.updateString("localAmountDebit", PcaUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                        drs.updateString("localAmountCredit", PcaUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                        drs.updateString("reportingAmountDebit", PcaUtils.formatNumber(vch.getReportingDebitAmount(), lcpre));
                        drs.updateString("reportingAmountCredit", PcaUtils.formatNumber(vch.getReportingCreditAmount(), lcpre));
                        drs.updateString("amountTotalChinese", PcaUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                        drs.updateString("amountTotal", PcaUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                    }
                    drs.insertRow();
                }
            }
            drs.beforeFirst();
        }
        catch (Exception ex) {
            logger.error((Object)"Get rowset error!", (Throwable)ex);
            return null;
        }
        return drs;
    }

    private IRowSet getRowSet4(int rowLineCount) {
        int colCount = PcVoucherPrintDataProvider.col.length;
        DynamicRowSet drs = null;
        IAssistantHG assistantHG = null;
        IBaseVoucherAssistRecord asstre = null;
        try {
            drs = new DynamicRowSet(colCount);
            for (int i = 0; i < colCount; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = PcVoucherPrintDataProvider.col[i];
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            Iterator itrVch = this.vchCol.iterator();
            int size = this.vchCol.size();
            BigDecimal allDeit = SysConstant.BIGZERO;
            BigDecimal allCret = SysConstant.BIGZERO;
            int vchCount = 0;
            while (itrVch.hasNext()) {
                int lcpre;
                PcVoucherInfo vch = (PcVoucherInfo)itrVch.next();
                String vchId = Integer.toString(++vchCount);
                CompanyOrgUnitInfo com = vch.getCompany();
                CurrencyInfo localCurrency = com.getBaseCurrency();
                int rcpre = lcpre = localCurrency.getPrecision();
                CurrencyInfo reportingCurrency = com.getReportCurrency();
                if (reportingCurrency != null) {
                    rcpre = reportingCurrency.getPrecision();
                }
                allDeit = vch.getLocalDebitAmount();
                allCret = vch.getLocalCreditAmount();
                Iterator itr = vch.getEntries().iterator();
                int entrySize = 0;
                while (itr.hasNext()) {
                    PcVoucherEntryInfo e = (PcVoucherEntryInfo)itr.next();
                    PcVoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                    if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                        entrySize += assitCollection.size();
                        continue;
                    }
                    ++entrySize;
                }
                Iterator itrEntry = vch.getEntries().iterator();
                int voucherCount = 0;
                voucherCount = entrySize % rowLineCount == 0 ? entrySize / rowLineCount : entrySize / rowLineCount + 1;
                int entryCount = 0;
                BigDecimal creditTotal = PcaUtils.zero;
                BigDecimal debitTotal = PcaUtils.zero;
                HashMap<String, BigDecimal> creditmap = new HashMap<String, BigDecimal>();
                HashMap<String, BigDecimal> debitmap = new HashMap<String, BigDecimal>();
                for (PcVoucherEntryInfo e : vch.getEntries()) {
                    EntryDC dc = e.getEntryDC();
                    PcVoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                    if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                        for (PcVoucherAssistRecordInfo r : assitCollection) {
                            int page = 0;
                            page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                            if (entryCount % rowLineCount == 1) {
                                creditTotal = PcaUtils.zero;
                                debitTotal = PcaUtils.zero;
                            }
                            if (EntryDC.DEBIT.equals((Object)dc)) {
                                debitTotal = debitTotal.add(r.getLocalAmount());
                            } else {
                                creditTotal = creditTotal.add(r.getLocalAmount());
                            }
                            if (entryCount % rowLineCount != 0) continue;
                            creditmap.put(String.valueOf(page), creditTotal);
                            debitmap.put(String.valueOf(page), debitTotal);
                        }
                        continue;
                    }
                    int page = 0;
                    page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                    if (entryCount % rowLineCount == 1) {
                        creditTotal = PcaUtils.zero;
                        debitTotal = PcaUtils.zero;
                    }
                    if (EntryDC.DEBIT.equals((Object)dc)) {
                        debitTotal = debitTotal.add(e.getLocalAmount());
                    } else {
                        creditTotal = creditTotal.add(e.getLocalAmount());
                    }
                    if (entryCount % rowLineCount != 0) continue;
                    creditmap.put(String.valueOf(page), creditTotal);
                    debitmap.put(String.valueOf(page), debitTotal);
                }
                entryCount = 0;
                while (itrEntry.hasNext()) {
                    PcVoucherEntryInfo e;
                    e = (PcVoucherEntryInfo)itrEntry.next();
                    PcVoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                    EntryDC dc = e.getEntryDC();
                    int asstCount = 0;
                    if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                        for (PcVoucherAssistRecordInfo r : assitCollection) {
                            drs.moveToInsertRow();
                            this.provider.clearRow((IRowSet)drs);
                            this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                            this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                            if (this.settingInfo.isPrintAssistant()) {
                                this.provider.fillVoucherASSTData((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, this.df, lcpre, dc, assistantHG, asstre, (BaseVoucherEntryInfo)e, vch.getCompany().getId().toString());
                            }
                            if (++asstCount > 1) {
                                drs.updateString("e_seq", " ");
                            }
                            int page = 0;
                            if (++entryCount % rowLineCount == 0) {
                                page = entryCount / rowLineCount;
                            } else {
                                page = entryCount / rowLineCount + 1;
                                if (entryCount % rowLineCount == 1) {
                                    creditTotal = PcaUtils.zero;
                                    debitTotal = PcaUtils.zero;
                                }
                            }
                            if (EntryDC.DEBIT.equals((Object)dc)) {
                                debitTotal = debitTotal.add(r.getLocalAmount());
                            } else {
                                creditTotal = creditTotal.add(r.getLocalAmount());
                            }
                            drs.updateString("pageCount", page + "/" + voucherCount);
                            drs.updateString("pageCurrent", page + "");
                            drs.updateString("pageTotal", "" + voucherCount);
                            drs.updateString("bizStatus", vch.getBizStatus().toString());
                            drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                            drs.updateString("attachmentsChinese", PcaUtils.getChineseBig(vch.getAttachments(), this.locale));
                            if (page == voucherCount) {
                                drs.updateString("debitTotal", PcaUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                                drs.updateString("creditTotal", PcaUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                                drs.updateString("localAmountDebit", PcaUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                                drs.updateString("localAmountCredit", PcaUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                                drs.updateString("reportingAmountDebit", PcaUtils.formatNumber(vch.getReportingDebitAmount(), lcpre));
                                drs.updateString("reportingAmountCredit", PcaUtils.formatNumber(vch.getReportingCreditAmount(), lcpre));
                                drs.updateString("amountTotalChinese", PcaUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                                drs.updateString("amountTotal", PcaUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                                drs.updateString("sum", "");
                            } else {
                                drs.updateString("debitTotal", PcaUtils.formatNumber((BigDecimal)debitmap.get(String.valueOf(page)), lcpre));
                                drs.updateString("creditTotal", PcaUtils.formatNumber((BigDecimal)creditmap.get(String.valueOf(page)), lcpre));
                                drs.updateString("sum", GLResUtil.getRes((String)"subtotal"));
                            }
                            drs.insertRow();
                        }
                        continue;
                    }
                    drs.moveToInsertRow();
                    this.provider.clearRow((IRowSet)drs);
                    this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                    this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                    if (EntryDC.DEBIT.equals((Object)dc)) {
                        drs.updateString("e_originalAmountDebit", PcaUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("e_localAmountDebit", PcaUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("e_reportingAmountDebit", PcaUtils.formatNumber(e.getReportingAmount(), lcpre));
                        drs.updateString("r_originalAmountDebit", PcaUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("r_localAmountDebit", PcaUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("r_reportingAmountDebit", PcaUtils.formatNumber(e.getReportingAmount(), lcpre));
                    } else {
                        drs.updateString("e_localAmountCredit", PcaUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("e_originalAmountCredit", PcaUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("e_reportingAmountCredit", PcaUtils.formatNumber(e.getReportingAmount(), lcpre));
                        drs.updateString("r_originalAmountCredit", PcaUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("r_localAmountCredit", PcaUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("r_reportingAmountCredit", PcaUtils.formatNumber(e.getReportingAmount(), lcpre));
                    }
                    int page = 0;
                    if (++entryCount % rowLineCount == 0) {
                        page = entryCount / rowLineCount;
                    } else {
                        page = entryCount / rowLineCount + 1;
                        if (entryCount % rowLineCount == 1) {
                            creditTotal = PcaUtils.zero;
                            debitTotal = PcaUtils.zero;
                        }
                    }
                    if (EntryDC.DEBIT.equals((Object)dc)) {
                        debitTotal = debitTotal.add(e.getLocalAmount());
                    } else {
                        creditTotal = creditTotal.add(e.getLocalAmount());
                    }
                    drs.updateString("pageCount", page + "/" + voucherCount);
                    drs.updateString("pageCurrent", page + "");
                    drs.updateString("pageTotal", "" + voucherCount);
                    drs.updateString("bizStatus", vch.getBizStatus().toString());
                    drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                    drs.updateString("attachmentsChinese", PcaUtils.getChineseBig(vch.getAttachments(), this.locale));
                    if (page == voucherCount) {
                        drs.updateString("debitTotal", PcaUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                        drs.updateString("creditTotal", PcaUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                        drs.updateString("localAmountDebit", PcaUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                        drs.updateString("localAmountCredit", PcaUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                        drs.updateString("reportingAmountDebit", PcaUtils.formatNumber(vch.getReportingDebitAmount(), lcpre));
                        drs.updateString("reportingAmountCredit", PcaUtils.formatNumber(vch.getReportingCreditAmount(), lcpre));
                        drs.updateString("amountTotalChinese", PcaUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                        drs.updateString("amountTotal", PcaUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                        drs.updateString("sum", "");
                    } else {
                        drs.updateString("debitTotal", PcaUtils.formatNumber((BigDecimal)debitmap.get(String.valueOf(page)), lcpre));
                        drs.updateString("creditTotal", PcaUtils.formatNumber((BigDecimal)creditmap.get(String.valueOf(page)), lcpre));
                        drs.updateString("sum", GLResUtil.getRes((String)"subtotal"));
                    }
                    drs.insertRow();
                }
            }
            drs.beforeFirst();
        }
        catch (Exception ex) {
            logger.error((Object)"Get rowset error!", (Throwable)ex);
            return null;
        }
        return drs;
    }

    private IRowSet getRowSet5(int rowLineCount) {
        int colCount = PcVoucherPrintDataProvider.col.length;
        DynamicRowSet drs = null;
        IAssistantHG assistantHG = null;
        IBaseVoucherAssistRecord asstre = null;
        try {
            drs = new DynamicRowSet(colCount);
            for (int i = 0; i < colCount; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = PcVoucherPrintDataProvider.col[i];
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            Iterator itrVch = this.vchCol.iterator();
            int size = this.vchCol.size();
            BigDecimal allDeit = SysConstant.BIGZERO;
            BigDecimal allCret = SysConstant.BIGZERO;
            int vchCount = 0;
            while (itrVch.hasNext()) {
                int lcpre;
                PcVoucherInfo vch = (PcVoucherInfo)itrVch.next();
                String vchId = Integer.toString(++vchCount);
                CompanyOrgUnitInfo com = vch.getCompany();
                CurrencyInfo localCurrency = com.getBaseCurrency();
                int rcpre = lcpre = localCurrency.getPrecision();
                CurrencyInfo reportingCurrency = com.getReportCurrency();
                if (reportingCurrency != null) {
                    rcpre = reportingCurrency.getPrecision();
                }
                allDeit = vch.getLocalDebitAmount();
                allCret = vch.getLocalCreditAmount();
                Iterator itr = vch.getEntries().iterator();
                int entrySize = 0;
                while (itr.hasNext()) {
                    PcVoucherEntryInfo e = (PcVoucherEntryInfo)itr.next();
                    PcVoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                    if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                        entrySize += assitCollection.size();
                        continue;
                    }
                    ++entrySize;
                }
                Iterator itrEntry = vch.getEntries().iterator();
                int voucherCount = 0;
                voucherCount = entrySize % rowLineCount == 0 ? entrySize / rowLineCount : entrySize / rowLineCount + 1;
                int entryCount = 0;
                BigDecimal creditTotal = PcaUtils.zero;
                BigDecimal debitTotal = PcaUtils.zero;
                HashMap<String, BigDecimal> creditmap = new HashMap<String, BigDecimal>();
                HashMap<String, BigDecimal> debitmap = new HashMap<String, BigDecimal>();
                for (PcVoucherEntryInfo e : vch.getEntries()) {
                    EntryDC dc = e.getEntryDC();
                    PcVoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                    if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                        for (PcVoucherAssistRecordInfo r : assitCollection) {
                            int page = 0;
                            page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                            if (entryCount % rowLineCount == 1) {
                                creditTotal = PcaUtils.zero;
                                debitTotal = PcaUtils.zero;
                            }
                            if (EntryDC.DEBIT.equals((Object)dc)) {
                                debitTotal = debitTotal.add(r.getLocalAmount());
                            } else {
                                creditTotal = creditTotal.add(r.getLocalAmount());
                            }
                            if (entryCount % rowLineCount != 0) continue;
                            creditmap.put(String.valueOf(page), creditTotal);
                            debitmap.put(String.valueOf(page), debitTotal);
                        }
                        continue;
                    }
                    int page = 0;
                    page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                    if (entryCount % rowLineCount == 1) {
                        creditTotal = PcaUtils.zero;
                        debitTotal = PcaUtils.zero;
                    }
                    if (EntryDC.DEBIT.equals((Object)dc)) {
                        debitTotal = debitTotal.add(e.getLocalAmount());
                    } else {
                        creditTotal = creditTotal.add(e.getLocalAmount());
                    }
                    if (entryCount % rowLineCount != 0) continue;
                    creditmap.put(String.valueOf(page), creditTotal);
                    debitmap.put(String.valueOf(page), debitTotal);
                }
                entryCount = 0;
                while (itrEntry.hasNext()) {
                    PcVoucherEntryInfo e;
                    e = (PcVoucherEntryInfo)itrEntry.next();
                    PcVoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                    EntryDC dc = e.getEntryDC();
                    int asstCount = 0;
                    if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                        for (PcVoucherAssistRecordInfo r : assitCollection) {
                            drs.moveToInsertRow();
                            this.provider.clearRow((IRowSet)drs);
                            this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                            this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                            if (this.settingInfo.isPrintAssistant()) {
                                this.provider.fillVoucherASSTData((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, this.df, lcpre, dc, assistantHG, asstre, (BaseVoucherEntryInfo)e, vch.getCompany().getId().toString());
                            }
                            if (++asstCount > 1) {
                                drs.updateString("e_seq", " ");
                            }
                            int page = 0;
                            if (++entryCount % rowLineCount == 0) {
                                page = entryCount / rowLineCount;
                            } else {
                                page = entryCount / rowLineCount + 1;
                                if (entryCount % rowLineCount == 1) {
                                    creditTotal = PcaUtils.zero;
                                    debitTotal = PcaUtils.zero;
                                }
                            }
                            if (EntryDC.DEBIT.equals((Object)dc)) {
                                debitTotal = debitTotal.add(r.getLocalAmount());
                            } else {
                                creditTotal = creditTotal.add(r.getLocalAmount());
                            }
                            drs.updateString("pageCount", page + "/" + voucherCount);
                            drs.updateString("pageCurrent", page + "");
                            drs.updateString("pageTotal", "" + voucherCount);
                            drs.updateString("bizStatus", vch.getBizStatus().toString());
                            drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                            drs.updateString("attachmentsChinese", PcaUtils.getChineseBig(vch.getAttachments(), this.locale));
                            if (page == voucherCount) {
                                drs.updateString("debitTotal", PcaUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                                drs.updateString("creditTotal", PcaUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                                drs.updateString("localAmountDebit", PcaUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                                drs.updateString("localAmountCredit", PcaUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                                drs.updateString("reportingAmountDebit", PcaUtils.formatNumber(vch.getReportingDebitAmount(), lcpre));
                                drs.updateString("reportingAmountCredit", PcaUtils.formatNumber(vch.getReportingCreditAmount(), lcpre));
                                drs.updateString("amountTotalChinese", PcaUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                                drs.updateString("amountTotal", PcaUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                                drs.updateString("sum", "");
                            } else {
                                drs.updateString("debitTotal", PcaUtils.formatNumber((BigDecimal)debitmap.get(String.valueOf(page)), lcpre));
                                drs.updateString("creditTotal", PcaUtils.formatNumber((BigDecimal)creditmap.get(String.valueOf(page)), lcpre));
                                drs.updateString("sum", GLResUtil.getRes((String)"subtotal"));
                            }
                            drs.insertRow();
                        }
                        continue;
                    }
                    drs.moveToInsertRow();
                    this.provider.clearRow((IRowSet)drs);
                    this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                    this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                    if (EntryDC.DEBIT.equals((Object)dc)) {
                        drs.updateString("e_originalAmountDebit", PcaUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("e_localAmountDebit", PcaUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("e_reportingAmountDebit", PcaUtils.formatNumber(e.getReportingAmount(), lcpre));
                        drs.updateString("r_originalAmountDebit", PcaUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("r_localAmountDebit", PcaUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("r_reportingAmountDebit", PcaUtils.formatNumber(e.getReportingAmount(), lcpre));
                    } else {
                        drs.updateString("e_localAmountCredit", PcaUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("e_originalAmountCredit", PcaUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("e_reportingAmountCredit", PcaUtils.formatNumber(e.getReportingAmount(), lcpre));
                        drs.updateString("r_originalAmountCredit", PcaUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("r_localAmountCredit", PcaUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("r_reportingAmountCredit", PcaUtils.formatNumber(e.getReportingAmount(), lcpre));
                    }
                    int page = 0;
                    if (++entryCount % rowLineCount == 0) {
                        page = entryCount / rowLineCount;
                    } else {
                        page = entryCount / rowLineCount + 1;
                        if (entryCount % rowLineCount == 1) {
                            creditTotal = PcaUtils.zero;
                            debitTotal = PcaUtils.zero;
                        }
                    }
                    if (EntryDC.DEBIT.equals((Object)dc)) {
                        debitTotal = debitTotal.add(e.getLocalAmount());
                    } else {
                        creditTotal = creditTotal.add(e.getLocalAmount());
                    }
                    drs.updateString("pageCount", page + "/" + voucherCount);
                    drs.updateString("pageCurrent", page + "");
                    drs.updateString("pageTotal", "" + voucherCount);
                    drs.updateString("bizStatus", vch.getBizStatus().toString());
                    drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                    drs.updateString("attachmentsChinese", PcaUtils.getChineseBig(vch.getAttachments(), this.locale));
                    if (page == voucherCount) {
                        drs.updateString("debitTotal", PcaUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                        drs.updateString("creditTotal", PcaUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                        drs.updateString("localAmountDebit", PcaUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                        drs.updateString("localAmountCredit", PcaUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                        drs.updateString("reportingAmountDebit", PcaUtils.formatNumber(vch.getReportingDebitAmount(), lcpre));
                        drs.updateString("reportingAmountCredit", PcaUtils.formatNumber(vch.getReportingCreditAmount(), lcpre));
                        drs.updateString("amountTotalChinese", PcaUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                        drs.updateString("amountTotal", PcaUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                        drs.updateString("sum", "");
                    } else {
                        drs.updateString("debitTotal", PcaUtils.formatNumber((BigDecimal)debitmap.get(String.valueOf(page)), lcpre));
                        drs.updateString("creditTotal", PcaUtils.formatNumber((BigDecimal)creditmap.get(String.valueOf(page)), lcpre));
                        drs.updateString("sum", GLResUtil.getRes((String)"subtotal"));
                    }
                    drs.insertRow();
                }
            }
            drs.beforeFirst();
        }
        catch (Exception ex) {
            logger.error((Object)"Get rowset error!", (Throwable)ex);
            return null;
        }
        return drs;
    }

    private boolean computerVoucherType(PcVoucherInfo vch) {
        boolean pnlAccExist = false;
        int count = vch.getEntryCount();
        for (int i = 0; i < count; ++i) {
            AccountViewInfo acc = vch.getEntries().get(i).getAccount();
            if (!AccountProperty.SUNYI.equals((Object)acc.getAccountTypeID().getProperty())) continue;
            pnlAccExist = true;
        }
        return pnlAccExist;
    }

    private PcVoucherInfo changeVoucher(PcVoucherInfo vch) {
        PcVoucherInfo info = new PcVoucherInfo();
        info.setId(vch.getId());
        info.setNumber(vch.getNumber());
        info.setAttachments(vch.getAttachments());
        info.setBizOU(vch.getBizOU());
        info.setPeriod(vch.getPeriod());
        info.setBizDate(vch.getBizDate());
        info.setBookedDate(vch.getBookedDate());
        info.setCompany(vch.getCompany());
        info.setCreateTime(vch.getCreateTime());
        info.setCreator(vch.getCreator());
        info.setCU(vch.getCU());
        info.setCurrency(vch.getCurrency());
        info.setDescription(vch.getDescription());
        info.setDisplayFormat(vch.getDisplayFormat());
        info.setLocalCreditAmount(vch.getLocalCreditAmount());
        info.setLocalDebitAmount(vch.getLocalDebitAmount());
        info.setReportingCreditAmount(vch.getReportingCreditAmount());
        info.setReportingDebitAmount(vch.getReportingDebitAmount());
        info.setHandler(vch.getHandler());
        info.setAuditor(vch.getAuditor());
        info.setCashier(vch.getCashier());
        info.setCanceller(vch.getCanceller());
        info.setPoster(vch.getPoster());
        info.setHasCashAccount(vch.isHasCashAccount());
        info.setHasEffected(vch.isHasEffected());
        info.setLastUpdateTime(vch.getLastUpdateTime());
        info.setLastUpdateUser(vch.getLastUpdateUser());
        info.setVoucherType(vch.getVoucherType());
        info.setVoucherTypeDetail(vch.getVoucherTypeDetail());
        int infoCount = 0;
        HashMap<String, PcVoucherEntryInfo> acctMap = new HashMap<String, PcVoucherEntryInfo>();
        int count = vch.getEntryCount();
        PcVoucherEntryCollection vchEntryCol = vch.getEntries();
        PcVoucherEntryCollection infoEntryCol = info.getEntries();
        for (int i = 0; i < count; ++i) {
            PcVoucherEntryInfo vchEntryInfo = vchEntryCol.get(i);
            PcVoucherEntryInfo entry = new PcVoucherEntryInfo();
            entry.setAccount(vchEntryInfo.getAccount());
            entry.setBill(info);
            entry.setId(vchEntryInfo.getId());
            entry.setCurrency(vchEntryInfo.getCurrency());
            entry.setDescription(vchEntryInfo.getDescription());
            entry.setDisplayFormat(vchEntryInfo.getDisplayFormat());
            entry.setEntryDC(vchEntryInfo.getEntryDC());
            entry.setMeasureUnit(vchEntryInfo.getMeasureUnit());
            entry.setOriginalAmount(vchEntryInfo.getOriginalAmount());
            entry.setLocalAmount(vchEntryInfo.getLocalAmount());
            entry.setReportingAmount(vchEntryInfo.getReportingAmount());
            entry.setLocalExchangeRate(vchEntryInfo.getLocalExchangeRate());
            entry.setReportingExchangeRate(vchEntryInfo.getReportingExchangeRate());
            entry.setPrice(vchEntryInfo.getPrice());
            entry.setQuantity(vchEntryInfo.getQuantity());
            entry.setStandardQuantity(vchEntryInfo.getStandardQuantity());
            AccountViewInfo acc = entry.getAccount();
            if (AccountProperty.SUNYI.equals((Object)acc.getAccountTypeID().getProperty())) {
                AccountViewInfo accInfo = null;
                try {
                    BOSUuid accID = acc.getId();
                    ObjectUuidPK objectUUidPK = new ObjectUuidPK(accID);
                    accInfo = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)objectUUidPK);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                }
                String flongnumber = accInfo.getLongNumber();
                String flongname = accInfo.getLongName();
                String fnumber = flongnumber;
                String fname = flongname;
                int index = flongnumber.indexOf("!");
                if (index != -1) {
                    fnumber = flongnumber.substring(0, flongnumber.indexOf("!"));
                    fname = flongname.substring(0, flongname.indexOf("_"));
                }
                acc.setName(fname);
                acc.setNumber(fnumber);
                acc.setLongName(fname);
                acc.setLongNumber(fnumber);
                if (acctMap.containsKey(fnumber)) {
                    PcVoucherEntryInfo entryInfo = (PcVoucherEntryInfo)acctMap.get(fnumber);
                    entryInfo.setOriginalAmount(entryInfo.getOriginalAmount().add(entry.getOriginalAmount()));
                    entryInfo.setLocalAmount(entryInfo.getLocalAmount().add(entry.getLocalAmount()));
                    entryInfo.setReportingAmount(entryInfo.getReportingAmount().add(entry.getReportingAmount()));
                    entryInfo.setQuantity(entryInfo.getQuantity().add(entry.getQuantity()));
                    entryInfo.setStandardQuantity(entryInfo.getStandardQuantity().add(entry.getStandardQuantity()));
                    continue;
                }
                entry.setSeq(++infoCount);
                acctMap.put(fnumber, entry);
                continue;
            }
            entry.setSeq(++infoCount);
            infoEntryCol.add(entry);
        }
        info.setEntryCount(infoCount);
        Set set = acctMap.keySet();
        for (String fnumber : set) {
            PcVoucherEntryInfo entryInfo = (PcVoucherEntryInfo)acctMap.get(fnumber);
            infoEntryCol.add(entryInfo);
        }
        return info;
    }
}

